var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn2, res) => function __init() {
  return fn2 && (res = (0, fn2[__getOwnPropNames(fn2)[0]])(fn2 = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// ../../node_modules/.pnpm/big-integer@1.6.52/node_modules/big-integer/BigInteger.js
var require_BigInteger = __commonJS({
  "../../node_modules/.pnpm/big-integer@1.6.52/node_modules/big-integer/BigInteger.js"(exports, module) {
    var bigInt = function(undefined2) {
      "use strict";
      var BASE = 1e7, LOG_BASE = 7, MAX_INT = 9007199254740992, MAX_INT_ARR = smallToArray(MAX_INT), DEFAULT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz";
      var supportsNativeBigInt = typeof BigInt === "function";
      function Integer(v3, radix, alphabet, caseSensitive) {
        if (typeof v3 === "undefined")
          return Integer[0];
        if (typeof radix !== "undefined")
          return +radix === 10 && !alphabet ? parseValue(v3) : parseBase(v3, radix, alphabet, caseSensitive);
        return parseValue(v3);
      }
      function BigInteger(value, sign2) {
        this.value = value;
        this.sign = sign2;
        this.isSmall = false;
      }
      BigInteger.prototype = Object.create(Integer.prototype);
      function SmallInteger(value) {
        this.value = value;
        this.sign = value < 0;
        this.isSmall = true;
      }
      SmallInteger.prototype = Object.create(Integer.prototype);
      function NativeBigInt(value) {
        this.value = value;
      }
      NativeBigInt.prototype = Object.create(Integer.prototype);
      function isPrecise(n2) {
        return -MAX_INT < n2 && n2 < MAX_INT;
      }
      function smallToArray(n2) {
        if (n2 < 1e7)
          return [n2];
        if (n2 < 1e14)
          return [n2 % 1e7, Math.floor(n2 / 1e7)];
        return [n2 % 1e7, Math.floor(n2 / 1e7) % 1e7, Math.floor(n2 / 1e14)];
      }
      function arrayToSmall(arr) {
        trim(arr);
        var length = arr.length;
        if (length < 4 && compareAbs(arr, MAX_INT_ARR) < 0) {
          switch (length) {
            case 0:
              return 0;
            case 1:
              return arr[0];
            case 2:
              return arr[0] + arr[1] * BASE;
            default:
              return arr[0] + (arr[1] + arr[2] * BASE) * BASE;
          }
        }
        return arr;
      }
      function trim(v3) {
        var i6 = v3.length;
        while (v3[--i6] === 0)
          ;
        v3.length = i6 + 1;
      }
      function createArray(length) {
        var x6 = new Array(length);
        var i6 = -1;
        while (++i6 < length) {
          x6[i6] = 0;
        }
        return x6;
      }
      function truncate(n2) {
        if (n2 > 0)
          return Math.floor(n2);
        return Math.ceil(n2);
      }
      function add4(a6, b5) {
        var l_a = a6.length, l_b = b5.length, r3 = new Array(l_a), carry = 0, base2 = BASE, sum2, i6;
        for (i6 = 0; i6 < l_b; i6++) {
          sum2 = a6[i6] + b5[i6] + carry;
          carry = sum2 >= base2 ? 1 : 0;
          r3[i6] = sum2 - carry * base2;
        }
        while (i6 < l_a) {
          sum2 = a6[i6] + carry;
          carry = sum2 === base2 ? 1 : 0;
          r3[i6++] = sum2 - carry * base2;
        }
        if (carry > 0)
          r3.push(carry);
        return r3;
      }
      function addAny(a6, b5) {
        if (a6.length >= b5.length)
          return add4(a6, b5);
        return add4(b5, a6);
      }
      function addSmall(a6, carry) {
        var l3 = a6.length, r3 = new Array(l3), base2 = BASE, sum2, i6;
        for (i6 = 0; i6 < l3; i6++) {
          sum2 = a6[i6] - base2 + carry;
          carry = Math.floor(sum2 / base2);
          r3[i6] = sum2 - carry * base2;
          carry += 1;
        }
        while (carry > 0) {
          r3[i6++] = carry % base2;
          carry = Math.floor(carry / base2);
        }
        return r3;
      }
      BigInteger.prototype.add = function(v3) {
        var n2 = parseValue(v3);
        if (this.sign !== n2.sign) {
          return this.subtract(n2.negate());
        }
        var a6 = this.value, b5 = n2.value;
        if (n2.isSmall) {
          return new BigInteger(addSmall(a6, Math.abs(b5)), this.sign);
        }
        return new BigInteger(addAny(a6, b5), this.sign);
      };
      BigInteger.prototype.plus = BigInteger.prototype.add;
      SmallInteger.prototype.add = function(v3) {
        var n2 = parseValue(v3);
        var a6 = this.value;
        if (a6 < 0 !== n2.sign) {
          return this.subtract(n2.negate());
        }
        var b5 = n2.value;
        if (n2.isSmall) {
          if (isPrecise(a6 + b5))
            return new SmallInteger(a6 + b5);
          b5 = smallToArray(Math.abs(b5));
        }
        return new BigInteger(addSmall(b5, Math.abs(a6)), a6 < 0);
      };
      SmallInteger.prototype.plus = SmallInteger.prototype.add;
      NativeBigInt.prototype.add = function(v3) {
        return new NativeBigInt(this.value + parseValue(v3).value);
      };
      NativeBigInt.prototype.plus = NativeBigInt.prototype.add;
      function subtract(a6, b5) {
        var a_l = a6.length, b_l = b5.length, r3 = new Array(a_l), borrow = 0, base2 = BASE, i6, difference2;
        for (i6 = 0; i6 < b_l; i6++) {
          difference2 = a6[i6] - borrow - b5[i6];
          if (difference2 < 0) {
            difference2 += base2;
            borrow = 1;
          } else
            borrow = 0;
          r3[i6] = difference2;
        }
        for (i6 = b_l; i6 < a_l; i6++) {
          difference2 = a6[i6] - borrow;
          if (difference2 < 0)
            difference2 += base2;
          else {
            r3[i6++] = difference2;
            break;
          }
          r3[i6] = difference2;
        }
        for (; i6 < a_l; i6++) {
          r3[i6] = a6[i6];
        }
        trim(r3);
        return r3;
      }
      function subtractAny(a6, b5, sign2) {
        var value;
        if (compareAbs(a6, b5) >= 0) {
          value = subtract(a6, b5);
        } else {
          value = subtract(b5, a6);
          sign2 = !sign2;
        }
        value = arrayToSmall(value);
        if (typeof value === "number") {
          if (sign2)
            value = -value;
          return new SmallInteger(value);
        }
        return new BigInteger(value, sign2);
      }
      function subtractSmall(a6, b5, sign2) {
        var l3 = a6.length, r3 = new Array(l3), carry = -b5, base2 = BASE, i6, difference2;
        for (i6 = 0; i6 < l3; i6++) {
          difference2 = a6[i6] + carry;
          carry = Math.floor(difference2 / base2);
          difference2 %= base2;
          r3[i6] = difference2 < 0 ? difference2 + base2 : difference2;
        }
        r3 = arrayToSmall(r3);
        if (typeof r3 === "number") {
          if (sign2)
            r3 = -r3;
          return new SmallInteger(r3);
        }
        return new BigInteger(r3, sign2);
      }
      BigInteger.prototype.subtract = function(v3) {
        var n2 = parseValue(v3);
        if (this.sign !== n2.sign) {
          return this.add(n2.negate());
        }
        var a6 = this.value, b5 = n2.value;
        if (n2.isSmall)
          return subtractSmall(a6, Math.abs(b5), this.sign);
        return subtractAny(a6, b5, this.sign);
      };
      BigInteger.prototype.minus = BigInteger.prototype.subtract;
      SmallInteger.prototype.subtract = function(v3) {
        var n2 = parseValue(v3);
        var a6 = this.value;
        if (a6 < 0 !== n2.sign) {
          return this.add(n2.negate());
        }
        var b5 = n2.value;
        if (n2.isSmall) {
          return new SmallInteger(a6 - b5);
        }
        return subtractSmall(b5, Math.abs(a6), a6 >= 0);
      };
      SmallInteger.prototype.minus = SmallInteger.prototype.subtract;
      NativeBigInt.prototype.subtract = function(v3) {
        return new NativeBigInt(this.value - parseValue(v3).value);
      };
      NativeBigInt.prototype.minus = NativeBigInt.prototype.subtract;
      BigInteger.prototype.negate = function() {
        return new BigInteger(this.value, !this.sign);
      };
      SmallInteger.prototype.negate = function() {
        var sign2 = this.sign;
        var small = new SmallInteger(-this.value);
        small.sign = !sign2;
        return small;
      };
      NativeBigInt.prototype.negate = function() {
        return new NativeBigInt(-this.value);
      };
      BigInteger.prototype.abs = function() {
        return new BigInteger(this.value, false);
      };
      SmallInteger.prototype.abs = function() {
        return new SmallInteger(Math.abs(this.value));
      };
      NativeBigInt.prototype.abs = function() {
        return new NativeBigInt(this.value >= 0 ? this.value : -this.value);
      };
      function multiplyLong(a6, b5) {
        var a_l = a6.length, b_l = b5.length, l3 = a_l + b_l, r3 = createArray(l3), base2 = BASE, product, carry, i6, a_i, b_j;
        for (i6 = 0; i6 < a_l; ++i6) {
          a_i = a6[i6];
          for (var j4 = 0; j4 < b_l; ++j4) {
            b_j = b5[j4];
            product = a_i * b_j + r3[i6 + j4];
            carry = Math.floor(product / base2);
            r3[i6 + j4] = product - carry * base2;
            r3[i6 + j4 + 1] += carry;
          }
        }
        trim(r3);
        return r3;
      }
      function multiplySmall(a6, b5) {
        var l3 = a6.length, r3 = new Array(l3), base2 = BASE, carry = 0, product, i6;
        for (i6 = 0; i6 < l3; i6++) {
          product = a6[i6] * b5 + carry;
          carry = Math.floor(product / base2);
          r3[i6] = product - carry * base2;
        }
        while (carry > 0) {
          r3[i6++] = carry % base2;
          carry = Math.floor(carry / base2);
        }
        return r3;
      }
      function shiftLeft(x6, n2) {
        var r3 = [];
        while (n2-- > 0)
          r3.push(0);
        return r3.concat(x6);
      }
      function multiplyKaratsuba(x6, y6) {
        var n2 = Math.max(x6.length, y6.length);
        if (n2 <= 30)
          return multiplyLong(x6, y6);
        n2 = Math.ceil(n2 / 2);
        var b5 = x6.slice(n2), a6 = x6.slice(0, n2), d6 = y6.slice(n2), c5 = y6.slice(0, n2);
        var ac = multiplyKaratsuba(a6, c5), bd = multiplyKaratsuba(b5, d6), abcd = multiplyKaratsuba(addAny(a6, b5), addAny(c5, d6));
        var product = addAny(addAny(ac, shiftLeft(subtract(subtract(abcd, ac), bd), n2)), shiftLeft(bd, 2 * n2));
        trim(product);
        return product;
      }
      function useKaratsuba(l1, l22) {
        return -0.012 * l1 - 0.012 * l22 + 15e-6 * l1 * l22 > 0;
      }
      BigInteger.prototype.multiply = function(v3) {
        var n2 = parseValue(v3), a6 = this.value, b5 = n2.value, sign2 = this.sign !== n2.sign, abs;
        if (n2.isSmall) {
          if (b5 === 0)
            return Integer[0];
          if (b5 === 1)
            return this;
          if (b5 === -1)
            return this.negate();
          abs = Math.abs(b5);
          if (abs < BASE) {
            return new BigInteger(multiplySmall(a6, abs), sign2);
          }
          b5 = smallToArray(abs);
        }
        if (useKaratsuba(a6.length, b5.length))
          return new BigInteger(multiplyKaratsuba(a6, b5), sign2);
        return new BigInteger(multiplyLong(a6, b5), sign2);
      };
      BigInteger.prototype.times = BigInteger.prototype.multiply;
      function multiplySmallAndArray(a6, b5, sign2) {
        if (a6 < BASE) {
          return new BigInteger(multiplySmall(b5, a6), sign2);
        }
        return new BigInteger(multiplyLong(b5, smallToArray(a6)), sign2);
      }
      SmallInteger.prototype._multiplyBySmall = function(a6) {
        if (isPrecise(a6.value * this.value)) {
          return new SmallInteger(a6.value * this.value);
        }
        return multiplySmallAndArray(Math.abs(a6.value), smallToArray(Math.abs(this.value)), this.sign !== a6.sign);
      };
      BigInteger.prototype._multiplyBySmall = function(a6) {
        if (a6.value === 0)
          return Integer[0];
        if (a6.value === 1)
          return this;
        if (a6.value === -1)
          return this.negate();
        return multiplySmallAndArray(Math.abs(a6.value), this.value, this.sign !== a6.sign);
      };
      SmallInteger.prototype.multiply = function(v3) {
        return parseValue(v3)._multiplyBySmall(this);
      };
      SmallInteger.prototype.times = SmallInteger.prototype.multiply;
      NativeBigInt.prototype.multiply = function(v3) {
        return new NativeBigInt(this.value * parseValue(v3).value);
      };
      NativeBigInt.prototype.times = NativeBigInt.prototype.multiply;
      function square(a6) {
        var l3 = a6.length, r3 = createArray(l3 + l3), base2 = BASE, product, carry, i6, a_i, a_j;
        for (i6 = 0; i6 < l3; i6++) {
          a_i = a6[i6];
          carry = 0 - a_i * a_i;
          for (var j4 = i6; j4 < l3; j4++) {
            a_j = a6[j4];
            product = 2 * (a_i * a_j) + r3[i6 + j4] + carry;
            carry = Math.floor(product / base2);
            r3[i6 + j4] = product - carry * base2;
          }
          r3[i6 + l3] = carry;
        }
        trim(r3);
        return r3;
      }
      BigInteger.prototype.square = function() {
        return new BigInteger(square(this.value), false);
      };
      SmallInteger.prototype.square = function() {
        var value = this.value * this.value;
        if (isPrecise(value))
          return new SmallInteger(value);
        return new BigInteger(square(smallToArray(Math.abs(this.value))), false);
      };
      NativeBigInt.prototype.square = function(v3) {
        return new NativeBigInt(this.value * this.value);
      };
      function divMod1(a6, b5) {
        var a_l = a6.length, b_l = b5.length, base2 = BASE, result = createArray(b5.length), divisorMostSignificantDigit = b5[b_l - 1], lambda = Math.ceil(base2 / (2 * divisorMostSignificantDigit)), remainder = multiplySmall(a6, lambda), divisor = multiplySmall(b5, lambda), quotientDigit, shift, carry, borrow, i6, l3, q6;
        if (remainder.length <= a_l)
          remainder.push(0);
        divisor.push(0);
        divisorMostSignificantDigit = divisor[b_l - 1];
        for (shift = a_l - b_l; shift >= 0; shift--) {
          quotientDigit = base2 - 1;
          if (remainder[shift + b_l] !== divisorMostSignificantDigit) {
            quotientDigit = Math.floor((remainder[shift + b_l] * base2 + remainder[shift + b_l - 1]) / divisorMostSignificantDigit);
          }
          carry = 0;
          borrow = 0;
          l3 = divisor.length;
          for (i6 = 0; i6 < l3; i6++) {
            carry += quotientDigit * divisor[i6];
            q6 = Math.floor(carry / base2);
            borrow += remainder[shift + i6] - (carry - q6 * base2);
            carry = q6;
            if (borrow < 0) {
              remainder[shift + i6] = borrow + base2;
              borrow = -1;
            } else {
              remainder[shift + i6] = borrow;
              borrow = 0;
            }
          }
          while (borrow !== 0) {
            quotientDigit -= 1;
            carry = 0;
            for (i6 = 0; i6 < l3; i6++) {
              carry += remainder[shift + i6] - base2 + divisor[i6];
              if (carry < 0) {
                remainder[shift + i6] = carry + base2;
                carry = 0;
              } else {
                remainder[shift + i6] = carry;
                carry = 1;
              }
            }
            borrow += carry;
          }
          result[shift] = quotientDigit;
        }
        remainder = divModSmall(remainder, lambda)[0];
        return [arrayToSmall(result), arrayToSmall(remainder)];
      }
      function divMod2(a6, b5) {
        var a_l = a6.length, b_l = b5.length, result = [], part = [], base2 = BASE, guess, xlen, highx, highy, check;
        while (a_l) {
          part.unshift(a6[--a_l]);
          trim(part);
          if (compareAbs(part, b5) < 0) {
            result.push(0);
            continue;
          }
          xlen = part.length;
          highx = part[xlen - 1] * base2 + part[xlen - 2];
          highy = b5[b_l - 1] * base2 + b5[b_l - 2];
          if (xlen > b_l) {
            highx = (highx + 1) * base2;
          }
          guess = Math.ceil(highx / highy);
          do {
            check = multiplySmall(b5, guess);
            if (compareAbs(check, part) <= 0)
              break;
            guess--;
          } while (guess);
          result.push(guess);
          part = subtract(part, check);
        }
        result.reverse();
        return [arrayToSmall(result), arrayToSmall(part)];
      }
      function divModSmall(value, lambda) {
        var length = value.length, quotient = createArray(length), base2 = BASE, i6, q6, remainder, divisor;
        remainder = 0;
        for (i6 = length - 1; i6 >= 0; --i6) {
          divisor = remainder * base2 + value[i6];
          q6 = truncate(divisor / lambda);
          remainder = divisor - q6 * lambda;
          quotient[i6] = q6 | 0;
        }
        return [quotient, remainder | 0];
      }
      function divModAny(self2, v3) {
        var value, n2 = parseValue(v3);
        if (supportsNativeBigInt) {
          return [new NativeBigInt(self2.value / n2.value), new NativeBigInt(self2.value % n2.value)];
        }
        var a6 = self2.value, b5 = n2.value;
        var quotient;
        if (b5 === 0)
          throw new Error("Cannot divide by zero");
        if (self2.isSmall) {
          if (n2.isSmall) {
            return [new SmallInteger(truncate(a6 / b5)), new SmallInteger(a6 % b5)];
          }
          return [Integer[0], self2];
        }
        if (n2.isSmall) {
          if (b5 === 1)
            return [self2, Integer[0]];
          if (b5 == -1)
            return [self2.negate(), Integer[0]];
          var abs = Math.abs(b5);
          if (abs < BASE) {
            value = divModSmall(a6, abs);
            quotient = arrayToSmall(value[0]);
            var remainder = value[1];
            if (self2.sign)
              remainder = -remainder;
            if (typeof quotient === "number") {
              if (self2.sign !== n2.sign)
                quotient = -quotient;
              return [new SmallInteger(quotient), new SmallInteger(remainder)];
            }
            return [new BigInteger(quotient, self2.sign !== n2.sign), new SmallInteger(remainder)];
          }
          b5 = smallToArray(abs);
        }
        var comparison = compareAbs(a6, b5);
        if (comparison === -1)
          return [Integer[0], self2];
        if (comparison === 0)
          return [Integer[self2.sign === n2.sign ? 1 : -1], Integer[0]];
        if (a6.length + b5.length <= 200)
          value = divMod1(a6, b5);
        else
          value = divMod2(a6, b5);
        quotient = value[0];
        var qSign = self2.sign !== n2.sign, mod = value[1], mSign = self2.sign;
        if (typeof quotient === "number") {
          if (qSign)
            quotient = -quotient;
          quotient = new SmallInteger(quotient);
        } else
          quotient = new BigInteger(quotient, qSign);
        if (typeof mod === "number") {
          if (mSign)
            mod = -mod;
          mod = new SmallInteger(mod);
        } else
          mod = new BigInteger(mod, mSign);
        return [quotient, mod];
      }
      BigInteger.prototype.divmod = function(v3) {
        var result = divModAny(this, v3);
        return {
          quotient: result[0],
          remainder: result[1]
        };
      };
      NativeBigInt.prototype.divmod = SmallInteger.prototype.divmod = BigInteger.prototype.divmod;
      BigInteger.prototype.divide = function(v3) {
        return divModAny(this, v3)[0];
      };
      NativeBigInt.prototype.over = NativeBigInt.prototype.divide = function(v3) {
        return new NativeBigInt(this.value / parseValue(v3).value);
      };
      SmallInteger.prototype.over = SmallInteger.prototype.divide = BigInteger.prototype.over = BigInteger.prototype.divide;
      BigInteger.prototype.mod = function(v3) {
        return divModAny(this, v3)[1];
      };
      NativeBigInt.prototype.mod = NativeBigInt.prototype.remainder = function(v3) {
        return new NativeBigInt(this.value % parseValue(v3).value);
      };
      SmallInteger.prototype.remainder = SmallInteger.prototype.mod = BigInteger.prototype.remainder = BigInteger.prototype.mod;
      BigInteger.prototype.pow = function(v3) {
        var n2 = parseValue(v3), a6 = this.value, b5 = n2.value, value, x6, y6;
        if (b5 === 0)
          return Integer[1];
        if (a6 === 0)
          return Integer[0];
        if (a6 === 1)
          return Integer[1];
        if (a6 === -1)
          return n2.isEven() ? Integer[1] : Integer[-1];
        if (n2.sign) {
          return Integer[0];
        }
        if (!n2.isSmall)
          throw new Error("The exponent " + n2.toString() + " is too large.");
        if (this.isSmall) {
          if (isPrecise(value = Math.pow(a6, b5)))
            return new SmallInteger(truncate(value));
        }
        x6 = this;
        y6 = Integer[1];
        while (true) {
          if (b5 & true) {
            y6 = y6.times(x6);
            --b5;
          }
          if (b5 === 0)
            break;
          b5 /= 2;
          x6 = x6.square();
        }
        return y6;
      };
      SmallInteger.prototype.pow = BigInteger.prototype.pow;
      NativeBigInt.prototype.pow = function(v3) {
        var n2 = parseValue(v3);
        var a6 = this.value, b5 = n2.value;
        var _0 = BigInt(0), _1 = BigInt(1), _22 = BigInt(2);
        if (b5 === _0)
          return Integer[1];
        if (a6 === _0)
          return Integer[0];
        if (a6 === _1)
          return Integer[1];
        if (a6 === BigInt(-1))
          return n2.isEven() ? Integer[1] : Integer[-1];
        if (n2.isNegative())
          return new NativeBigInt(_0);
        var x6 = this;
        var y6 = Integer[1];
        while (true) {
          if ((b5 & _1) === _1) {
            y6 = y6.times(x6);
            --b5;
          }
          if (b5 === _0)
            break;
          b5 /= _22;
          x6 = x6.square();
        }
        return y6;
      };
      BigInteger.prototype.modPow = function(exp, mod) {
        exp = parseValue(exp);
        mod = parseValue(mod);
        if (mod.isZero())
          throw new Error("Cannot take modPow with modulus 0");
        var r3 = Integer[1], base2 = this.mod(mod);
        if (exp.isNegative()) {
          exp = exp.multiply(Integer[-1]);
          base2 = base2.modInv(mod);
        }
        while (exp.isPositive()) {
          if (base2.isZero())
            return Integer[0];
          if (exp.isOdd())
            r3 = r3.multiply(base2).mod(mod);
          exp = exp.divide(2);
          base2 = base2.square().mod(mod);
        }
        return r3;
      };
      NativeBigInt.prototype.modPow = SmallInteger.prototype.modPow = BigInteger.prototype.modPow;
      function compareAbs(a6, b5) {
        if (a6.length !== b5.length) {
          return a6.length > b5.length ? 1 : -1;
        }
        for (var i6 = a6.length - 1; i6 >= 0; i6--) {
          if (a6[i6] !== b5[i6])
            return a6[i6] > b5[i6] ? 1 : -1;
        }
        return 0;
      }
      BigInteger.prototype.compareAbs = function(v3) {
        var n2 = parseValue(v3), a6 = this.value, b5 = n2.value;
        if (n2.isSmall)
          return 1;
        return compareAbs(a6, b5);
      };
      SmallInteger.prototype.compareAbs = function(v3) {
        var n2 = parseValue(v3), a6 = Math.abs(this.value), b5 = n2.value;
        if (n2.isSmall) {
          b5 = Math.abs(b5);
          return a6 === b5 ? 0 : a6 > b5 ? 1 : -1;
        }
        return -1;
      };
      NativeBigInt.prototype.compareAbs = function(v3) {
        var a6 = this.value;
        var b5 = parseValue(v3).value;
        a6 = a6 >= 0 ? a6 : -a6;
        b5 = b5 >= 0 ? b5 : -b5;
        return a6 === b5 ? 0 : a6 > b5 ? 1 : -1;
      };
      BigInteger.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var n2 = parseValue(v3), a6 = this.value, b5 = n2.value;
        if (this.sign !== n2.sign) {
          return n2.sign ? 1 : -1;
        }
        if (n2.isSmall) {
          return this.sign ? -1 : 1;
        }
        return compareAbs(a6, b5) * (this.sign ? -1 : 1);
      };
      BigInteger.prototype.compareTo = BigInteger.prototype.compare;
      SmallInteger.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var n2 = parseValue(v3), a6 = this.value, b5 = n2.value;
        if (n2.isSmall) {
          return a6 == b5 ? 0 : a6 > b5 ? 1 : -1;
        }
        if (a6 < 0 !== n2.sign) {
          return a6 < 0 ? -1 : 1;
        }
        return a6 < 0 ? 1 : -1;
      };
      SmallInteger.prototype.compareTo = SmallInteger.prototype.compare;
      NativeBigInt.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var a6 = this.value;
        var b5 = parseValue(v3).value;
        return a6 === b5 ? 0 : a6 > b5 ? 1 : -1;
      };
      NativeBigInt.prototype.compareTo = NativeBigInt.prototype.compare;
      BigInteger.prototype.equals = function(v3) {
        return this.compare(v3) === 0;
      };
      NativeBigInt.prototype.eq = NativeBigInt.prototype.equals = SmallInteger.prototype.eq = SmallInteger.prototype.equals = BigInteger.prototype.eq = BigInteger.prototype.equals;
      BigInteger.prototype.notEquals = function(v3) {
        return this.compare(v3) !== 0;
      };
      NativeBigInt.prototype.neq = NativeBigInt.prototype.notEquals = SmallInteger.prototype.neq = SmallInteger.prototype.notEquals = BigInteger.prototype.neq = BigInteger.prototype.notEquals;
      BigInteger.prototype.greater = function(v3) {
        return this.compare(v3) > 0;
      };
      NativeBigInt.prototype.gt = NativeBigInt.prototype.greater = SmallInteger.prototype.gt = SmallInteger.prototype.greater = BigInteger.prototype.gt = BigInteger.prototype.greater;
      BigInteger.prototype.lesser = function(v3) {
        return this.compare(v3) < 0;
      };
      NativeBigInt.prototype.lt = NativeBigInt.prototype.lesser = SmallInteger.prototype.lt = SmallInteger.prototype.lesser = BigInteger.prototype.lt = BigInteger.prototype.lesser;
      BigInteger.prototype.greaterOrEquals = function(v3) {
        return this.compare(v3) >= 0;
      };
      NativeBigInt.prototype.geq = NativeBigInt.prototype.greaterOrEquals = SmallInteger.prototype.geq = SmallInteger.prototype.greaterOrEquals = BigInteger.prototype.geq = BigInteger.prototype.greaterOrEquals;
      BigInteger.prototype.lesserOrEquals = function(v3) {
        return this.compare(v3) <= 0;
      };
      NativeBigInt.prototype.leq = NativeBigInt.prototype.lesserOrEquals = SmallInteger.prototype.leq = SmallInteger.prototype.lesserOrEquals = BigInteger.prototype.leq = BigInteger.prototype.lesserOrEquals;
      BigInteger.prototype.isEven = function() {
        return (this.value[0] & 1) === 0;
      };
      SmallInteger.prototype.isEven = function() {
        return (this.value & 1) === 0;
      };
      NativeBigInt.prototype.isEven = function() {
        return (this.value & BigInt(1)) === BigInt(0);
      };
      BigInteger.prototype.isOdd = function() {
        return (this.value[0] & 1) === 1;
      };
      SmallInteger.prototype.isOdd = function() {
        return (this.value & 1) === 1;
      };
      NativeBigInt.prototype.isOdd = function() {
        return (this.value & BigInt(1)) === BigInt(1);
      };
      BigInteger.prototype.isPositive = function() {
        return !this.sign;
      };
      SmallInteger.prototype.isPositive = function() {
        return this.value > 0;
      };
      NativeBigInt.prototype.isPositive = SmallInteger.prototype.isPositive;
      BigInteger.prototype.isNegative = function() {
        return this.sign;
      };
      SmallInteger.prototype.isNegative = function() {
        return this.value < 0;
      };
      NativeBigInt.prototype.isNegative = SmallInteger.prototype.isNegative;
      BigInteger.prototype.isUnit = function() {
        return false;
      };
      SmallInteger.prototype.isUnit = function() {
        return Math.abs(this.value) === 1;
      };
      NativeBigInt.prototype.isUnit = function() {
        return this.abs().value === BigInt(1);
      };
      BigInteger.prototype.isZero = function() {
        return false;
      };
      SmallInteger.prototype.isZero = function() {
        return this.value === 0;
      };
      NativeBigInt.prototype.isZero = function() {
        return this.value === BigInt(0);
      };
      BigInteger.prototype.isDivisibleBy = function(v3) {
        var n2 = parseValue(v3);
        if (n2.isZero())
          return false;
        if (n2.isUnit())
          return true;
        if (n2.compareAbs(2) === 0)
          return this.isEven();
        return this.mod(n2).isZero();
      };
      NativeBigInt.prototype.isDivisibleBy = SmallInteger.prototype.isDivisibleBy = BigInteger.prototype.isDivisibleBy;
      function isBasicPrime(v3) {
        var n2 = v3.abs();
        if (n2.isUnit())
          return false;
        if (n2.equals(2) || n2.equals(3) || n2.equals(5))
          return true;
        if (n2.isEven() || n2.isDivisibleBy(3) || n2.isDivisibleBy(5))
          return false;
        if (n2.lesser(49))
          return true;
      }
      function millerRabinTest(n2, a6) {
        var nPrev = n2.prev(), b5 = nPrev, r3 = 0, d6, t5, i6, x6;
        while (b5.isEven())
          b5 = b5.divide(2), r3++;
        next:
          for (i6 = 0; i6 < a6.length; i6++) {
            if (n2.lesser(a6[i6]))
              continue;
            x6 = bigInt(a6[i6]).modPow(b5, n2);
            if (x6.isUnit() || x6.equals(nPrev))
              continue;
            for (d6 = r3 - 1; d6 != 0; d6--) {
              x6 = x6.square().mod(n2);
              if (x6.isUnit())
                return false;
              if (x6.equals(nPrev))
                continue next;
            }
            return false;
          }
        return true;
      }
      BigInteger.prototype.isPrime = function(strict) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined2)
          return isPrime;
        var n2 = this.abs();
        var bits = n2.bitLength();
        if (bits <= 64)
          return millerRabinTest(n2, [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37]);
        var logN = Math.log(2) * bits.toJSNumber();
        var t5 = Math.ceil(strict === true ? 2 * Math.pow(logN, 2) : logN);
        for (var a6 = [], i6 = 0; i6 < t5; i6++) {
          a6.push(bigInt(i6 + 2));
        }
        return millerRabinTest(n2, a6);
      };
      NativeBigInt.prototype.isPrime = SmallInteger.prototype.isPrime = BigInteger.prototype.isPrime;
      BigInteger.prototype.isProbablePrime = function(iterations, rng) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined2)
          return isPrime;
        var n2 = this.abs();
        var t5 = iterations === undefined2 ? 5 : iterations;
        for (var a6 = [], i6 = 0; i6 < t5; i6++) {
          a6.push(bigInt.randBetween(2, n2.minus(2), rng));
        }
        return millerRabinTest(n2, a6);
      };
      NativeBigInt.prototype.isProbablePrime = SmallInteger.prototype.isProbablePrime = BigInteger.prototype.isProbablePrime;
      BigInteger.prototype.modInv = function(n2) {
        var t5 = bigInt.zero, newT = bigInt.one, r3 = parseValue(n2), newR = this.abs(), q6, lastT, lastR;
        while (!newR.isZero()) {
          q6 = r3.divide(newR);
          lastT = t5;
          lastR = r3;
          t5 = newT;
          r3 = newR;
          newT = lastT.subtract(q6.multiply(newT));
          newR = lastR.subtract(q6.multiply(newR));
        }
        if (!r3.isUnit())
          throw new Error(this.toString() + " and " + n2.toString() + " are not co-prime");
        if (t5.compare(0) === -1) {
          t5 = t5.add(n2);
        }
        if (this.isNegative()) {
          return t5.negate();
        }
        return t5;
      };
      NativeBigInt.prototype.modInv = SmallInteger.prototype.modInv = BigInteger.prototype.modInv;
      BigInteger.prototype.next = function() {
        var value = this.value;
        if (this.sign) {
          return subtractSmall(value, 1, this.sign);
        }
        return new BigInteger(addSmall(value, 1), this.sign);
      };
      SmallInteger.prototype.next = function() {
        var value = this.value;
        if (value + 1 < MAX_INT)
          return new SmallInteger(value + 1);
        return new BigInteger(MAX_INT_ARR, false);
      };
      NativeBigInt.prototype.next = function() {
        return new NativeBigInt(this.value + BigInt(1));
      };
      BigInteger.prototype.prev = function() {
        var value = this.value;
        if (this.sign) {
          return new BigInteger(addSmall(value, 1), true);
        }
        return subtractSmall(value, 1, this.sign);
      };
      SmallInteger.prototype.prev = function() {
        var value = this.value;
        if (value - 1 > -MAX_INT)
          return new SmallInteger(value - 1);
        return new BigInteger(MAX_INT_ARR, true);
      };
      NativeBigInt.prototype.prev = function() {
        return new NativeBigInt(this.value - BigInt(1));
      };
      var powersOfTwo = [1];
      while (2 * powersOfTwo[powersOfTwo.length - 1] <= BASE)
        powersOfTwo.push(2 * powersOfTwo[powersOfTwo.length - 1]);
      var powers2Length = powersOfTwo.length, highestPower2 = powersOfTwo[powers2Length - 1];
      function shift_isSmall(n2) {
        return Math.abs(n2) <= BASE;
      }
      BigInteger.prototype.shiftLeft = function(v3) {
        var n2 = parseValue(v3).toJSNumber();
        if (!shift_isSmall(n2)) {
          throw new Error(String(n2) + " is too large for shifting.");
        }
        if (n2 < 0)
          return this.shiftRight(-n2);
        var result = this;
        if (result.isZero())
          return result;
        while (n2 >= powers2Length) {
          result = result.multiply(highestPower2);
          n2 -= powers2Length - 1;
        }
        return result.multiply(powersOfTwo[n2]);
      };
      NativeBigInt.prototype.shiftLeft = SmallInteger.prototype.shiftLeft = BigInteger.prototype.shiftLeft;
      BigInteger.prototype.shiftRight = function(v3) {
        var remQuo;
        var n2 = parseValue(v3).toJSNumber();
        if (!shift_isSmall(n2)) {
          throw new Error(String(n2) + " is too large for shifting.");
        }
        if (n2 < 0)
          return this.shiftLeft(-n2);
        var result = this;
        while (n2 >= powers2Length) {
          if (result.isZero() || result.isNegative() && result.isUnit())
            return result;
          remQuo = divModAny(result, highestPower2);
          result = remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
          n2 -= powers2Length - 1;
        }
        remQuo = divModAny(result, powersOfTwo[n2]);
        return remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
      };
      NativeBigInt.prototype.shiftRight = SmallInteger.prototype.shiftRight = BigInteger.prototype.shiftRight;
      function bitwise(x6, y6, fn2) {
        y6 = parseValue(y6);
        var xSign = x6.isNegative(), ySign = y6.isNegative();
        var xRem = xSign ? x6.not() : x6, yRem = ySign ? y6.not() : y6;
        var xDigit = 0, yDigit = 0;
        var xDivMod = null, yDivMod = null;
        var result = [];
        while (!xRem.isZero() || !yRem.isZero()) {
          xDivMod = divModAny(xRem, highestPower2);
          xDigit = xDivMod[1].toJSNumber();
          if (xSign) {
            xDigit = highestPower2 - 1 - xDigit;
          }
          yDivMod = divModAny(yRem, highestPower2);
          yDigit = yDivMod[1].toJSNumber();
          if (ySign) {
            yDigit = highestPower2 - 1 - yDigit;
          }
          xRem = xDivMod[0];
          yRem = yDivMod[0];
          result.push(fn2(xDigit, yDigit));
        }
        var sum2 = fn2(xSign ? 1 : 0, ySign ? 1 : 0) !== 0 ? bigInt(-1) : bigInt(0);
        for (var i6 = result.length - 1; i6 >= 0; i6 -= 1) {
          sum2 = sum2.multiply(highestPower2).add(bigInt(result[i6]));
        }
        return sum2;
      }
      BigInteger.prototype.not = function() {
        return this.negate().prev();
      };
      NativeBigInt.prototype.not = SmallInteger.prototype.not = BigInteger.prototype.not;
      BigInteger.prototype.and = function(n2) {
        return bitwise(this, n2, function(a6, b5) {
          return a6 & b5;
        });
      };
      NativeBigInt.prototype.and = SmallInteger.prototype.and = BigInteger.prototype.and;
      BigInteger.prototype.or = function(n2) {
        return bitwise(this, n2, function(a6, b5) {
          return a6 | b5;
        });
      };
      NativeBigInt.prototype.or = SmallInteger.prototype.or = BigInteger.prototype.or;
      BigInteger.prototype.xor = function(n2) {
        return bitwise(this, n2, function(a6, b5) {
          return a6 ^ b5;
        });
      };
      NativeBigInt.prototype.xor = SmallInteger.prototype.xor = BigInteger.prototype.xor;
      var LOBMASK_I = 1 << 30, LOBMASK_BI = (BASE & -BASE) * (BASE & -BASE) | LOBMASK_I;
      function roughLOB(n2) {
        var v3 = n2.value, x6 = typeof v3 === "number" ? v3 | LOBMASK_I : typeof v3 === "bigint" ? v3 | BigInt(LOBMASK_I) : v3[0] + v3[1] * BASE | LOBMASK_BI;
        return x6 & -x6;
      }
      function integerLogarithm(value, base2) {
        if (base2.compareTo(value) <= 0) {
          var tmp = integerLogarithm(value, base2.square(base2));
          var p4 = tmp.p;
          var e5 = tmp.e;
          var t5 = p4.multiply(base2);
          return t5.compareTo(value) <= 0 ? { p: t5, e: e5 * 2 + 1 } : { p: p4, e: e5 * 2 };
        }
        return { p: bigInt(1), e: 0 };
      }
      BigInteger.prototype.bitLength = function() {
        var n2 = this;
        if (n2.compareTo(bigInt(0)) < 0) {
          n2 = n2.negate().subtract(bigInt(1));
        }
        if (n2.compareTo(bigInt(0)) === 0) {
          return bigInt(0);
        }
        return bigInt(integerLogarithm(n2, bigInt(2)).e).add(bigInt(1));
      };
      NativeBigInt.prototype.bitLength = SmallInteger.prototype.bitLength = BigInteger.prototype.bitLength;
      function max(a6, b5) {
        a6 = parseValue(a6);
        b5 = parseValue(b5);
        return a6.greater(b5) ? a6 : b5;
      }
      function min(a6, b5) {
        a6 = parseValue(a6);
        b5 = parseValue(b5);
        return a6.lesser(b5) ? a6 : b5;
      }
      function gcd(a6, b5) {
        a6 = parseValue(a6).abs();
        b5 = parseValue(b5).abs();
        if (a6.equals(b5))
          return a6;
        if (a6.isZero())
          return b5;
        if (b5.isZero())
          return a6;
        var c5 = Integer[1], d6, t5;
        while (a6.isEven() && b5.isEven()) {
          d6 = min(roughLOB(a6), roughLOB(b5));
          a6 = a6.divide(d6);
          b5 = b5.divide(d6);
          c5 = c5.multiply(d6);
        }
        while (a6.isEven()) {
          a6 = a6.divide(roughLOB(a6));
        }
        do {
          while (b5.isEven()) {
            b5 = b5.divide(roughLOB(b5));
          }
          if (a6.greater(b5)) {
            t5 = b5;
            b5 = a6;
            a6 = t5;
          }
          b5 = b5.subtract(a6);
        } while (!b5.isZero());
        return c5.isUnit() ? a6 : a6.multiply(c5);
      }
      function lcm(a6, b5) {
        a6 = parseValue(a6).abs();
        b5 = parseValue(b5).abs();
        return a6.divide(gcd(a6, b5)).multiply(b5);
      }
      function randBetween(a6, b5, rng) {
        a6 = parseValue(a6);
        b5 = parseValue(b5);
        var usedRNG = rng || Math.random;
        var low = min(a6, b5), high = max(a6, b5);
        var range = high.subtract(low).add(1);
        if (range.isSmall)
          return low.add(Math.floor(usedRNG() * range));
        var digits = toBase(range, BASE).value;
        var result = [], restricted = true;
        for (var i6 = 0; i6 < digits.length; i6++) {
          var top = restricted ? digits[i6] + (i6 + 1 < digits.length ? digits[i6 + 1] / BASE : 0) : BASE;
          var digit = truncate(usedRNG() * top);
          result.push(digit);
          if (digit < digits[i6])
            restricted = false;
        }
        return low.add(Integer.fromArray(result, BASE, false));
      }
      var parseBase = function(text, base2, alphabet, caseSensitive) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        text = String(text);
        if (!caseSensitive) {
          text = text.toLowerCase();
          alphabet = alphabet.toLowerCase();
        }
        var length = text.length;
        var i6;
        var absBase = Math.abs(base2);
        var alphabetValues = {};
        for (i6 = 0; i6 < alphabet.length; i6++) {
          alphabetValues[alphabet[i6]] = i6;
        }
        for (i6 = 0; i6 < length; i6++) {
          var c5 = text[i6];
          if (c5 === "-")
            continue;
          if (c5 in alphabetValues) {
            if (alphabetValues[c5] >= absBase) {
              if (c5 === "1" && absBase === 1)
                continue;
              throw new Error(c5 + " is not a valid digit in base " + base2 + ".");
            }
          }
        }
        base2 = parseValue(base2);
        var digits = [];
        var isNegative = text[0] === "-";
        for (i6 = isNegative ? 1 : 0; i6 < text.length; i6++) {
          var c5 = text[i6];
          if (c5 in alphabetValues)
            digits.push(parseValue(alphabetValues[c5]));
          else if (c5 === "<") {
            var start = i6;
            do {
              i6++;
            } while (text[i6] !== ">" && i6 < text.length);
            digits.push(parseValue(text.slice(start + 1, i6)));
          } else
            throw new Error(c5 + " is not a valid character");
        }
        return parseBaseFromArray(digits, base2, isNegative);
      };
      function parseBaseFromArray(digits, base2, isNegative) {
        var val = Integer[0], pow = Integer[1], i6;
        for (i6 = digits.length - 1; i6 >= 0; i6--) {
          val = val.add(digits[i6].times(pow));
          pow = pow.times(base2);
        }
        return isNegative ? val.negate() : val;
      }
      function stringify(digit, alphabet) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        if (digit < alphabet.length) {
          return alphabet[digit];
        }
        return "<" + digit + ">";
      }
      function toBase(n2, base2) {
        base2 = bigInt(base2);
        if (base2.isZero()) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          throw new Error("Cannot convert nonzero numbers to base 0.");
        }
        if (base2.equals(-1)) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          if (n2.isNegative())
            return {
              value: [].concat.apply(
                [],
                Array.apply(null, Array(-n2.toJSNumber())).map(Array.prototype.valueOf, [1, 0])
              ),
              isNegative: false
            };
          var arr = Array.apply(null, Array(n2.toJSNumber() - 1)).map(Array.prototype.valueOf, [0, 1]);
          arr.unshift([1]);
          return {
            value: [].concat.apply([], arr),
            isNegative: false
          };
        }
        var neg = false;
        if (n2.isNegative() && base2.isPositive()) {
          neg = true;
          n2 = n2.abs();
        }
        if (base2.isUnit()) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          return {
            value: Array.apply(null, Array(n2.toJSNumber())).map(Number.prototype.valueOf, 1),
            isNegative: neg
          };
        }
        var out = [];
        var left = n2, divmod;
        while (left.isNegative() || left.compareAbs(base2) >= 0) {
          divmod = left.divmod(base2);
          left = divmod.quotient;
          var digit = divmod.remainder;
          if (digit.isNegative()) {
            digit = base2.minus(digit).abs();
            left = left.next();
          }
          out.push(digit.toJSNumber());
        }
        out.push(left.toJSNumber());
        return { value: out.reverse(), isNegative: neg };
      }
      function toBaseString(n2, base2, alphabet) {
        var arr = toBase(n2, base2);
        return (arr.isNegative ? "-" : "") + arr.value.map(function(x6) {
          return stringify(x6, alphabet);
        }).join("");
      }
      BigInteger.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      SmallInteger.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      NativeBigInt.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      BigInteger.prototype.toString = function(radix, alphabet) {
        if (radix === undefined2)
          radix = 10;
        if (radix !== 10 || alphabet)
          return toBaseString(this, radix, alphabet);
        var v3 = this.value, l3 = v3.length, str = String(v3[--l3]), zeros = "0000000", digit;
        while (--l3 >= 0) {
          digit = String(v3[l3]);
          str += zeros.slice(digit.length) + digit;
        }
        var sign2 = this.sign ? "-" : "";
        return sign2 + str;
      };
      SmallInteger.prototype.toString = function(radix, alphabet) {
        if (radix === undefined2)
          radix = 10;
        if (radix != 10 || alphabet)
          return toBaseString(this, radix, alphabet);
        return String(this.value);
      };
      NativeBigInt.prototype.toString = SmallInteger.prototype.toString;
      NativeBigInt.prototype.toJSON = BigInteger.prototype.toJSON = SmallInteger.prototype.toJSON = function() {
        return this.toString();
      };
      BigInteger.prototype.valueOf = function() {
        return parseInt(this.toString(), 10);
      };
      BigInteger.prototype.toJSNumber = BigInteger.prototype.valueOf;
      SmallInteger.prototype.valueOf = function() {
        return this.value;
      };
      SmallInteger.prototype.toJSNumber = SmallInteger.prototype.valueOf;
      NativeBigInt.prototype.valueOf = NativeBigInt.prototype.toJSNumber = function() {
        return parseInt(this.toString(), 10);
      };
      function parseStringValue(v3) {
        if (isPrecise(+v3)) {
          var x6 = +v3;
          if (x6 === truncate(x6))
            return supportsNativeBigInt ? new NativeBigInt(BigInt(x6)) : new SmallInteger(x6);
          throw new Error("Invalid integer: " + v3);
        }
        var sign2 = v3[0] === "-";
        if (sign2)
          v3 = v3.slice(1);
        var split = v3.split(/e/i);
        if (split.length > 2)
          throw new Error("Invalid integer: " + split.join("e"));
        if (split.length === 2) {
          var exp = split[1];
          if (exp[0] === "+")
            exp = exp.slice(1);
          exp = +exp;
          if (exp !== truncate(exp) || !isPrecise(exp))
            throw new Error("Invalid integer: " + exp + " is not a valid exponent.");
          var text = split[0];
          var decimalPlace = text.indexOf(".");
          if (decimalPlace >= 0) {
            exp -= text.length - decimalPlace - 1;
            text = text.slice(0, decimalPlace) + text.slice(decimalPlace + 1);
          }
          if (exp < 0)
            throw new Error("Cannot include negative exponent part for integers");
          text += new Array(exp + 1).join("0");
          v3 = text;
        }
        var isValid3 = /^([0-9][0-9]*)$/.test(v3);
        if (!isValid3)
          throw new Error("Invalid integer: " + v3);
        if (supportsNativeBigInt) {
          return new NativeBigInt(BigInt(sign2 ? "-" + v3 : v3));
        }
        var r3 = [], max2 = v3.length, l3 = LOG_BASE, min2 = max2 - l3;
        while (max2 > 0) {
          r3.push(+v3.slice(min2, max2));
          min2 -= l3;
          if (min2 < 0)
            min2 = 0;
          max2 -= l3;
        }
        trim(r3);
        return new BigInteger(r3, sign2);
      }
      function parseNumberValue(v3) {
        if (supportsNativeBigInt) {
          return new NativeBigInt(BigInt(v3));
        }
        if (isPrecise(v3)) {
          if (v3 !== truncate(v3))
            throw new Error(v3 + " is not an integer.");
          return new SmallInteger(v3);
        }
        return parseStringValue(v3.toString());
      }
      function parseValue(v3) {
        if (typeof v3 === "number") {
          return parseNumberValue(v3);
        }
        if (typeof v3 === "string") {
          return parseStringValue(v3);
        }
        if (typeof v3 === "bigint") {
          return new NativeBigInt(v3);
        }
        return v3;
      }
      for (var i5 = 0; i5 < 1e3; i5++) {
        Integer[i5] = parseValue(i5);
        if (i5 > 0)
          Integer[-i5] = parseValue(-i5);
      }
      Integer.one = Integer[1];
      Integer.zero = Integer[0];
      Integer.minusOne = Integer[-1];
      Integer.max = max;
      Integer.min = min;
      Integer.gcd = gcd;
      Integer.lcm = lcm;
      Integer.isInstance = function(x6) {
        return x6 instanceof BigInteger || x6 instanceof SmallInteger || x6 instanceof NativeBigInt;
      };
      Integer.randBetween = randBetween;
      Integer.fromArray = function(digits, base2, isNegative) {
        return parseBaseFromArray(digits.map(parseValue), parseValue(base2 || 10), isNegative);
      };
      return Integer;
    }();
    if (typeof module !== "undefined" && module.hasOwnProperty("exports")) {
      module.exports = bigInt;
    }
    if (typeof define === "function" && define.amd) {
      define(function() {
        return bigInt;
      });
    }
  }
});

// ../../node_modules/.pnpm/jed@1.1.1/node_modules/jed/jed.js
var require_jed = __commonJS({
  "../../node_modules/.pnpm/jed@1.1.1/node_modules/jed/jed.js"(exports, module) {
    (function(root, undef) {
      var ArrayProto = Array.prototype, ObjProto = Object.prototype, slice = ArrayProto.slice, hasOwnProp = ObjProto.hasOwnProperty, nativeForEach = ArrayProto.forEach, breaker = {};
      var _3 = {
        forEach: function(obj, iterator, context) {
          var i5, l3, key;
          if (obj === null) {
            return;
          }
          if (nativeForEach && obj.forEach === nativeForEach) {
            obj.forEach(iterator, context);
          } else if (obj.length === +obj.length) {
            for (i5 = 0, l3 = obj.length; i5 < l3; i5++) {
              if (i5 in obj && iterator.call(context, obj[i5], i5, obj) === breaker) {
                return;
              }
            }
          } else {
            for (key in obj) {
              if (hasOwnProp.call(obj, key)) {
                if (iterator.call(context, obj[key], key, obj) === breaker) {
                  return;
                }
              }
            }
          }
        },
        extend: function(obj) {
          this.forEach(slice.call(arguments, 1), function(source) {
            for (var prop in source) {
              obj[prop] = source[prop];
            }
          });
          return obj;
        }
      };
      var Jed2 = function(options) {
        this.defaults = {
          "locale_data": {
            "messages": {
              "": {
                "domain": "messages",
                "lang": "en",
                "plural_forms": "nplurals=2; plural=(n != 1);"
              }
              // There are no default keys, though
            }
          },
          // The default domain if one is missing
          "domain": "messages",
          // enable debug mode to log untranslated strings to the console
          "debug": false
        };
        this.options = _3.extend({}, this.defaults, options);
        this.textdomain(this.options.domain);
        if (options.domain && !this.options.locale_data[this.options.domain]) {
          throw new Error("Text domain set to non-existent domain: `" + options.domain + "`");
        }
      };
      Jed2.context_delimiter = String.fromCharCode(4);
      function getPluralFormFunc(plural_form_string) {
        return Jed2.PF.compile(plural_form_string || "nplurals=2; plural=(n != 1);");
      }
      function Chain(key, i18n2) {
        this._key = key;
        this._i18n = i18n2;
      }
      _3.extend(Chain.prototype, {
        onDomain: function(domain) {
          this._domain = domain;
          return this;
        },
        withContext: function(context) {
          this._context = context;
          return this;
        },
        ifPlural: function(num, pkey) {
          this._val = num;
          this._pkey = pkey;
          return this;
        },
        fetch: function(sArr) {
          if ({}.toString.call(sArr) != "[object Array]") {
            sArr = [].slice.call(arguments, 0);
          }
          return (sArr && sArr.length ? Jed2.sprintf : function(x6) {
            return x6;
          })(
            this._i18n.dcnpgettext(this._domain, this._context, this._key, this._pkey, this._val),
            sArr
          );
        }
      });
      _3.extend(Jed2.prototype, {
        // The sexier api start point
        translate: function(key) {
          return new Chain(key, this);
        },
        textdomain: function(domain) {
          if (!domain) {
            return this._textdomain;
          }
          this._textdomain = domain;
        },
        gettext: function(key) {
          return this.dcnpgettext.call(this, undef, undef, key);
        },
        dgettext: function(domain, key) {
          return this.dcnpgettext.call(this, domain, undef, key);
        },
        dcgettext: function(domain, key) {
          return this.dcnpgettext.call(this, domain, undef, key);
        },
        ngettext: function(skey, pkey, val) {
          return this.dcnpgettext.call(this, undef, undef, skey, pkey, val);
        },
        dngettext: function(domain, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, undef, skey, pkey, val);
        },
        dcngettext: function(domain, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, undef, skey, pkey, val);
        },
        pgettext: function(context, key) {
          return this.dcnpgettext.call(this, undef, context, key);
        },
        dpgettext: function(domain, context, key) {
          return this.dcnpgettext.call(this, domain, context, key);
        },
        dcpgettext: function(domain, context, key) {
          return this.dcnpgettext.call(this, domain, context, key);
        },
        npgettext: function(context, skey, pkey, val) {
          return this.dcnpgettext.call(this, undef, context, skey, pkey, val);
        },
        dnpgettext: function(domain, context, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, context, skey, pkey, val);
        },
        // The most fully qualified gettext function. It has every option.
        // Since it has every option, we can use it from every other method.
        // This is the bread and butter.
        // Technically there should be one more argument in this function for 'Category',
        // but since we never use it, we might as well not waste the bytes to define it.
        dcnpgettext: function(domain, context, singular_key, plural_key, val) {
          plural_key = plural_key || singular_key;
          domain = domain || this._textdomain;
          var fallback;
          if (!this.options) {
            fallback = new Jed2();
            return fallback.dcnpgettext.call(fallback, void 0, void 0, singular_key, plural_key, val);
          }
          if (!this.options.locale_data) {
            throw new Error("No locale data provided.");
          }
          if (!this.options.locale_data[domain]) {
            throw new Error("Domain `" + domain + "` was not found.");
          }
          if (!this.options.locale_data[domain][""]) {
            throw new Error("No locale meta information provided.");
          }
          if (!singular_key) {
            throw new Error("No translation key found.");
          }
          var key = context ? context + Jed2.context_delimiter + singular_key : singular_key, locale_data = this.options.locale_data, dict = locale_data[domain], defaultConf = (locale_data.messages || this.defaults.locale_data.messages)[""], pluralForms = dict[""].plural_forms || dict[""]["Plural-Forms"] || dict[""]["plural-forms"] || defaultConf.plural_forms || defaultConf["Plural-Forms"] || defaultConf["plural-forms"], val_list, res;
          var val_idx;
          if (val === void 0) {
            val_idx = 0;
          } else {
            if (typeof val != "number") {
              val = parseInt(val, 10);
              if (isNaN(val)) {
                throw new Error("The number that was passed in is not a number.");
              }
            }
            val_idx = getPluralFormFunc(pluralForms)(val);
          }
          if (!dict) {
            throw new Error("No domain named `" + domain + "` could be found.");
          }
          val_list = dict[key];
          if (!val_list || val_idx > val_list.length) {
            if (this.options.missing_key_callback) {
              this.options.missing_key_callback(key, domain);
            }
            res = [singular_key, plural_key];
            if (this.options.debug === true) {
              console.log(res[getPluralFormFunc(pluralForms)(val)]);
            }
            return res[getPluralFormFunc()(val)];
          }
          res = val_list[val_idx];
          if (!res) {
            res = [singular_key, plural_key];
            return res[getPluralFormFunc()(val)];
          }
          return res;
        }
      });
      var sprintf = function() {
        function get_type(variable) {
          return Object.prototype.toString.call(variable).slice(8, -1).toLowerCase();
        }
        function str_repeat(input, multiplier) {
          for (var output = []; multiplier > 0; output[--multiplier] = input) {
          }
          return output.join("");
        }
        var str_format = function() {
          if (!str_format.cache.hasOwnProperty(arguments[0])) {
            str_format.cache[arguments[0]] = str_format.parse(arguments[0]);
          }
          return str_format.format.call(null, str_format.cache[arguments[0]], arguments);
        };
        str_format.format = function(parse_tree, argv) {
          var cursor = 1, tree_length = parse_tree.length, node_type = "", arg, output = [], i5, k6, match6, pad, pad_character, pad_length;
          for (i5 = 0; i5 < tree_length; i5++) {
            node_type = get_type(parse_tree[i5]);
            if (node_type === "string") {
              output.push(parse_tree[i5]);
            } else if (node_type === "array") {
              match6 = parse_tree[i5];
              if (match6[2]) {
                arg = argv[cursor];
                for (k6 = 0; k6 < match6[2].length; k6++) {
                  if (!arg.hasOwnProperty(match6[2][k6])) {
                    throw sprintf('[sprintf] property "%s" does not exist', match6[2][k6]);
                  }
                  arg = arg[match6[2][k6]];
                }
              } else if (match6[1]) {
                arg = argv[match6[1]];
              } else {
                arg = argv[cursor++];
              }
              if (/[^s]/.test(match6[8]) && get_type(arg) != "number") {
                throw sprintf("[sprintf] expecting number but found %s", get_type(arg));
              }
              if (typeof arg == "undefined" || arg === null) {
                arg = "";
              }
              switch (match6[8]) {
                case "b":
                  arg = arg.toString(2);
                  break;
                case "c":
                  arg = String.fromCharCode(arg);
                  break;
                case "d":
                  arg = parseInt(arg, 10);
                  break;
                case "e":
                  arg = match6[7] ? arg.toExponential(match6[7]) : arg.toExponential();
                  break;
                case "f":
                  arg = match6[7] ? parseFloat(arg).toFixed(match6[7]) : parseFloat(arg);
                  break;
                case "o":
                  arg = arg.toString(8);
                  break;
                case "s":
                  arg = (arg = String(arg)) && match6[7] ? arg.substring(0, match6[7]) : arg;
                  break;
                case "u":
                  arg = Math.abs(arg);
                  break;
                case "x":
                  arg = arg.toString(16);
                  break;
                case "X":
                  arg = arg.toString(16).toUpperCase();
                  break;
              }
              arg = /[def]/.test(match6[8]) && match6[3] && arg >= 0 ? "+" + arg : arg;
              pad_character = match6[4] ? match6[4] == "0" ? "0" : match6[4].charAt(1) : " ";
              pad_length = match6[6] - String(arg).length;
              pad = match6[6] ? str_repeat(pad_character, pad_length) : "";
              output.push(match6[5] ? arg + pad : pad + arg);
            }
          }
          return output.join("");
        };
        str_format.cache = {};
        str_format.parse = function(fmt) {
          var _fmt = fmt, match6 = [], parse_tree = [], arg_names = 0;
          while (_fmt) {
            if ((match6 = /^[^\x25]+/.exec(_fmt)) !== null) {
              parse_tree.push(match6[0]);
            } else if ((match6 = /^\x25{2}/.exec(_fmt)) !== null) {
              parse_tree.push("%");
            } else if ((match6 = /^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(_fmt)) !== null) {
              if (match6[2]) {
                arg_names |= 1;
                var field_list = [], replacement_field = match6[2], field_match = [];
                if ((field_match = /^([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                  field_list.push(field_match[1]);
                  while ((replacement_field = replacement_field.substring(field_match[0].length)) !== "") {
                    if ((field_match = /^\.([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                      field_list.push(field_match[1]);
                    } else if ((field_match = /^\[(\d+)\]/.exec(replacement_field)) !== null) {
                      field_list.push(field_match[1]);
                    } else {
                      throw "[sprintf] huh?";
                    }
                  }
                } else {
                  throw "[sprintf] huh?";
                }
                match6[2] = field_list;
              } else {
                arg_names |= 2;
              }
              if (arg_names === 3) {
                throw "[sprintf] mixing positional and named placeholders is not (yet) supported";
              }
              parse_tree.push(match6);
            } else {
              throw "[sprintf] huh?";
            }
            _fmt = _fmt.substring(match6[0].length);
          }
          return parse_tree;
        };
        return str_format;
      }();
      var vsprintf = function(fmt, argv) {
        argv.unshift(fmt);
        return sprintf.apply(null, argv);
      };
      Jed2.parse_plural = function(plural_forms, n2) {
        plural_forms = plural_forms.replace(/n/g, n2);
        return Jed2.parse_expression(plural_forms);
      };
      Jed2.sprintf = function(fmt, args) {
        if ({}.toString.call(args) == "[object Array]") {
          return vsprintf(fmt, [].slice.call(args));
        }
        return sprintf.apply(this, [].slice.call(arguments));
      };
      Jed2.prototype.sprintf = function() {
        return Jed2.sprintf.apply(this, arguments);
      };
      Jed2.PF = {};
      Jed2.PF.parse = function(p4) {
        var plural_str = Jed2.PF.extractPluralExpr(p4);
        return Jed2.PF.parser.parse.call(Jed2.PF.parser, plural_str);
      };
      Jed2.PF.compile = function(p4) {
        function imply(val) {
          return val === true ? 1 : val ? val : 0;
        }
        var ast = Jed2.PF.parse(p4);
        return function(n2) {
          return imply(Jed2.PF.interpreter(ast)(n2));
        };
      };
      Jed2.PF.interpreter = function(ast) {
        return function(n2) {
          var res;
          switch (ast.type) {
            case "GROUP":
              return Jed2.PF.interpreter(ast.expr)(n2);
            case "TERNARY":
              if (Jed2.PF.interpreter(ast.expr)(n2)) {
                return Jed2.PF.interpreter(ast.truthy)(n2);
              }
              return Jed2.PF.interpreter(ast.falsey)(n2);
            case "OR":
              return Jed2.PF.interpreter(ast.left)(n2) || Jed2.PF.interpreter(ast.right)(n2);
            case "AND":
              return Jed2.PF.interpreter(ast.left)(n2) && Jed2.PF.interpreter(ast.right)(n2);
            case "LT":
              return Jed2.PF.interpreter(ast.left)(n2) < Jed2.PF.interpreter(ast.right)(n2);
            case "GT":
              return Jed2.PF.interpreter(ast.left)(n2) > Jed2.PF.interpreter(ast.right)(n2);
            case "LTE":
              return Jed2.PF.interpreter(ast.left)(n2) <= Jed2.PF.interpreter(ast.right)(n2);
            case "GTE":
              return Jed2.PF.interpreter(ast.left)(n2) >= Jed2.PF.interpreter(ast.right)(n2);
            case "EQ":
              return Jed2.PF.interpreter(ast.left)(n2) == Jed2.PF.interpreter(ast.right)(n2);
            case "NEQ":
              return Jed2.PF.interpreter(ast.left)(n2) != Jed2.PF.interpreter(ast.right)(n2);
            case "MOD":
              return Jed2.PF.interpreter(ast.left)(n2) % Jed2.PF.interpreter(ast.right)(n2);
            case "VAR":
              return n2;
            case "NUM":
              return ast.val;
            default:
              throw new Error("Invalid Token found.");
          }
        };
      };
      Jed2.PF.extractPluralExpr = function(p4) {
        p4 = p4.replace(/^\s\s*/, "").replace(/\s\s*$/, "");
        if (!/;\s*$/.test(p4)) {
          p4 = p4.concat(";");
        }
        var nplurals_re = /nplurals\=(\d+);/, plural_re = /plural\=(.*);/, nplurals_matches = p4.match(nplurals_re), res = {}, plural_matches;
        if (nplurals_matches.length > 1) {
          res.nplurals = nplurals_matches[1];
        } else {
          throw new Error("nplurals not found in plural_forms string: " + p4);
        }
        p4 = p4.replace(nplurals_re, "");
        plural_matches = p4.match(plural_re);
        if (!(plural_matches && plural_matches.length > 1)) {
          throw new Error("`plural` expression not found: " + p4);
        }
        return plural_matches[1];
      };
      Jed2.PF.parser = function() {
        var parser = {
          trace: function trace() {
          },
          yy: {},
          symbols_: { "error": 2, "expressions": 3, "e": 4, "EOF": 5, "?": 6, ":": 7, "||": 8, "&&": 9, "<": 10, "<=": 11, ">": 12, ">=": 13, "!=": 14, "==": 15, "%": 16, "(": 17, ")": 18, "n": 19, "NUMBER": 20, "$accept": 0, "$end": 1 },
          terminals_: { 2: "error", 5: "EOF", 6: "?", 7: ":", 8: "||", 9: "&&", 10: "<", 11: "<=", 12: ">", 13: ">=", 14: "!=", 15: "==", 16: "%", 17: "(", 18: ")", 19: "n", 20: "NUMBER" },
          productions_: [0, [3, 2], [4, 5], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 1], [4, 1]],
          performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
            var $0 = $$.length - 1;
            switch (yystate) {
              case 1:
                return { type: "GROUP", expr: $$[$0 - 1] };
                break;
              case 2:
                this.$ = { type: "TERNARY", expr: $$[$0 - 4], truthy: $$[$0 - 2], falsey: $$[$0] };
                break;
              case 3:
                this.$ = { type: "OR", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 4:
                this.$ = { type: "AND", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 5:
                this.$ = { type: "LT", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 6:
                this.$ = { type: "LTE", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 7:
                this.$ = { type: "GT", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 8:
                this.$ = { type: "GTE", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 9:
                this.$ = { type: "NEQ", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 10:
                this.$ = { type: "EQ", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 11:
                this.$ = { type: "MOD", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 12:
                this.$ = { type: "GROUP", expr: $$[$0 - 1] };
                break;
              case 13:
                this.$ = { type: "VAR" };
                break;
              case 14:
                this.$ = { type: "NUM", val: Number(yytext) };
                break;
            }
          },
          table: [{ 3: 1, 4: 2, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 1: [3] }, { 5: [1, 6], 6: [1, 7], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16] }, { 4: 17, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 5: [2, 13], 6: [2, 13], 7: [2, 13], 8: [2, 13], 9: [2, 13], 10: [2, 13], 11: [2, 13], 12: [2, 13], 13: [2, 13], 14: [2, 13], 15: [2, 13], 16: [2, 13], 18: [2, 13] }, { 5: [2, 14], 6: [2, 14], 7: [2, 14], 8: [2, 14], 9: [2, 14], 10: [2, 14], 11: [2, 14], 12: [2, 14], 13: [2, 14], 14: [2, 14], 15: [2, 14], 16: [2, 14], 18: [2, 14] }, { 1: [2, 1] }, { 4: 18, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 19, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 20, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 21, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 22, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 23, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 24, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 25, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 26, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 27, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 6: [1, 7], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [1, 28] }, { 6: [1, 7], 7: [1, 29], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16] }, { 5: [2, 3], 6: [2, 3], 7: [2, 3], 8: [2, 3], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 3] }, { 5: [2, 4], 6: [2, 4], 7: [2, 4], 8: [2, 4], 9: [2, 4], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 4] }, { 5: [2, 5], 6: [2, 5], 7: [2, 5], 8: [2, 5], 9: [2, 5], 10: [2, 5], 11: [2, 5], 12: [2, 5], 13: [2, 5], 14: [2, 5], 15: [2, 5], 16: [1, 16], 18: [2, 5] }, { 5: [2, 6], 6: [2, 6], 7: [2, 6], 8: [2, 6], 9: [2, 6], 10: [2, 6], 11: [2, 6], 12: [2, 6], 13: [2, 6], 14: [2, 6], 15: [2, 6], 16: [1, 16], 18: [2, 6] }, { 5: [2, 7], 6: [2, 7], 7: [2, 7], 8: [2, 7], 9: [2, 7], 10: [2, 7], 11: [2, 7], 12: [2, 7], 13: [2, 7], 14: [2, 7], 15: [2, 7], 16: [1, 16], 18: [2, 7] }, { 5: [2, 8], 6: [2, 8], 7: [2, 8], 8: [2, 8], 9: [2, 8], 10: [2, 8], 11: [2, 8], 12: [2, 8], 13: [2, 8], 14: [2, 8], 15: [2, 8], 16: [1, 16], 18: [2, 8] }, { 5: [2, 9], 6: [2, 9], 7: [2, 9], 8: [2, 9], 9: [2, 9], 10: [2, 9], 11: [2, 9], 12: [2, 9], 13: [2, 9], 14: [2, 9], 15: [2, 9], 16: [1, 16], 18: [2, 9] }, { 5: [2, 10], 6: [2, 10], 7: [2, 10], 8: [2, 10], 9: [2, 10], 10: [2, 10], 11: [2, 10], 12: [2, 10], 13: [2, 10], 14: [2, 10], 15: [2, 10], 16: [1, 16], 18: [2, 10] }, { 5: [2, 11], 6: [2, 11], 7: [2, 11], 8: [2, 11], 9: [2, 11], 10: [2, 11], 11: [2, 11], 12: [2, 11], 13: [2, 11], 14: [2, 11], 15: [2, 11], 16: [2, 11], 18: [2, 11] }, { 5: [2, 12], 6: [2, 12], 7: [2, 12], 8: [2, 12], 9: [2, 12], 10: [2, 12], 11: [2, 12], 12: [2, 12], 13: [2, 12], 14: [2, 12], 15: [2, 12], 16: [2, 12], 18: [2, 12] }, { 4: 30, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 5: [2, 2], 6: [1, 7], 7: [2, 2], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 2] }],
          defaultActions: { 6: [2, 1] },
          parseError: function parseError(str, hash3) {
            throw new Error(str);
          },
          parse: function parse(input) {
            var self2 = this, stack = [0], vstack = [null], lstack = [], table2 = this.table, yytext = "", yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
            this.lexer.setInput(input);
            this.lexer.yy = this.yy;
            this.yy.lexer = this.lexer;
            if (typeof this.lexer.yylloc == "undefined")
              this.lexer.yylloc = {};
            var yyloc = this.lexer.yylloc;
            lstack.push(yyloc);
            if (typeof this.yy.parseError === "function")
              this.parseError = this.yy.parseError;
            function popStack(n2) {
              stack.length = stack.length - 2 * n2;
              vstack.length = vstack.length - n2;
              lstack.length = lstack.length - n2;
            }
            function lex() {
              var token;
              token = self2.lexer.lex() || 1;
              if (typeof token !== "number") {
                token = self2.symbols_[token] || token;
              }
              return token;
            }
            var symbol, preErrorSymbol, state, action, a6, r3, yyval = {}, p4, len, newState, expected;
            while (true) {
              state = stack[stack.length - 1];
              if (this.defaultActions[state]) {
                action = this.defaultActions[state];
              } else {
                if (symbol == null)
                  symbol = lex();
                action = table2[state] && table2[state][symbol];
              }
              _handle_error:
                if (typeof action === "undefined" || !action.length || !action[0]) {
                  if (!recovering) {
                    expected = [];
                    for (p4 in table2[state])
                      if (this.terminals_[p4] && p4 > 2) {
                        expected.push("'" + this.terminals_[p4] + "'");
                      }
                    var errStr = "";
                    if (this.lexer.showPosition) {
                      errStr = "Parse error on line " + (yylineno + 1) + ":\n" + this.lexer.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + this.terminals_[symbol] + "'";
                    } else {
                      errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == 1 ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
                    }
                    this.parseError(
                      errStr,
                      { text: this.lexer.match, token: this.terminals_[symbol] || symbol, line: this.lexer.yylineno, loc: yyloc, expected }
                    );
                  }
                  if (recovering == 3) {
                    if (symbol == EOF) {
                      throw new Error(errStr || "Parsing halted.");
                    }
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    symbol = lex();
                  }
                  while (1) {
                    if (TERROR.toString() in table2[state]) {
                      break;
                    }
                    if (state == 0) {
                      throw new Error(errStr || "Parsing halted.");
                    }
                    popStack(1);
                    state = stack[stack.length - 1];
                  }
                  preErrorSymbol = symbol;
                  symbol = TERROR;
                  state = stack[stack.length - 1];
                  action = table2[state] && table2[state][TERROR];
                  recovering = 3;
                }
              if (action[0] instanceof Array && action.length > 1) {
                throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
              }
              switch (action[0]) {
                case 1:
                  stack.push(symbol);
                  vstack.push(this.lexer.yytext);
                  lstack.push(this.lexer.yylloc);
                  stack.push(action[1]);
                  symbol = null;
                  if (!preErrorSymbol) {
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    if (recovering > 0)
                      recovering--;
                  } else {
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                  }
                  break;
                case 2:
                  len = this.productions_[action[1]][1];
                  yyval.$ = vstack[vstack.length - len];
                  yyval._$ = {
                    first_line: lstack[lstack.length - (len || 1)].first_line,
                    last_line: lstack[lstack.length - 1].last_line,
                    first_column: lstack[lstack.length - (len || 1)].first_column,
                    last_column: lstack[lstack.length - 1].last_column
                  };
                  r3 = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);
                  if (typeof r3 !== "undefined") {
                    return r3;
                  }
                  if (len) {
                    stack = stack.slice(0, -1 * len * 2);
                    vstack = vstack.slice(0, -1 * len);
                    lstack = lstack.slice(0, -1 * len);
                  }
                  stack.push(this.productions_[action[1]][0]);
                  vstack.push(yyval.$);
                  lstack.push(yyval._$);
                  newState = table2[stack[stack.length - 2]][stack[stack.length - 1]];
                  stack.push(newState);
                  break;
                case 3:
                  return true;
              }
            }
            return true;
          }
        };
        var lexer = function() {
          var lexer2 = {
            EOF: 1,
            parseError: function parseError(str, hash3) {
              if (this.yy.parseError) {
                this.yy.parseError(str, hash3);
              } else {
                throw new Error(str);
              }
            },
            setInput: function(input) {
              this._input = input;
              this._more = this._less = this.done = false;
              this.yylineno = this.yyleng = 0;
              this.yytext = this.matched = this.match = "";
              this.conditionStack = ["INITIAL"];
              this.yylloc = { first_line: 1, first_column: 0, last_line: 1, last_column: 0 };
              return this;
            },
            input: function() {
              var ch = this._input[0];
              this.yytext += ch;
              this.yyleng++;
              this.match += ch;
              this.matched += ch;
              var lines = ch.match(/\n/);
              if (lines)
                this.yylineno++;
              this._input = this._input.slice(1);
              return ch;
            },
            unput: function(ch) {
              this._input = ch + this._input;
              return this;
            },
            more: function() {
              this._more = true;
              return this;
            },
            pastInput: function() {
              var past = this.matched.substr(0, this.matched.length - this.match.length);
              return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
            },
            upcomingInput: function() {
              var next = this.match;
              if (next.length < 20) {
                next += this._input.substr(0, 20 - next.length);
              }
              return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
            },
            showPosition: function() {
              var pre = this.pastInput();
              var c5 = new Array(pre.length + 1).join("-");
              return pre + this.upcomingInput() + "\n" + c5 + "^";
            },
            next: function() {
              if (this.done) {
                return this.EOF;
              }
              if (!this._input)
                this.done = true;
              var token, match6, col, lines;
              if (!this._more) {
                this.yytext = "";
                this.match = "";
              }
              var rules = this._currentRules();
              for (var i5 = 0; i5 < rules.length; i5++) {
                match6 = this._input.match(this.rules[rules[i5]]);
                if (match6) {
                  lines = match6[0].match(/\n.*/g);
                  if (lines)
                    this.yylineno += lines.length;
                  this.yylloc = {
                    first_line: this.yylloc.last_line,
                    last_line: this.yylineno + 1,
                    first_column: this.yylloc.last_column,
                    last_column: lines ? lines[lines.length - 1].length - 1 : this.yylloc.last_column + match6[0].length
                  };
                  this.yytext += match6[0];
                  this.match += match6[0];
                  this.matches = match6;
                  this.yyleng = this.yytext.length;
                  this._more = false;
                  this._input = this._input.slice(match6[0].length);
                  this.matched += match6[0];
                  token = this.performAction.call(this, this.yy, this, rules[i5], this.conditionStack[this.conditionStack.length - 1]);
                  if (token)
                    return token;
                  else
                    return;
                }
              }
              if (this._input === "") {
                return this.EOF;
              } else {
                this.parseError(
                  "Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(),
                  { text: "", token: null, line: this.yylineno }
                );
              }
            },
            lex: function lex() {
              var r3 = this.next();
              if (typeof r3 !== "undefined") {
                return r3;
              } else {
                return this.lex();
              }
            },
            begin: function begin(condition) {
              this.conditionStack.push(condition);
            },
            popState: function popState() {
              return this.conditionStack.pop();
            },
            _currentRules: function _currentRules() {
              return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
            },
            topState: function() {
              return this.conditionStack[this.conditionStack.length - 2];
            },
            pushState: function begin(condition) {
              this.begin(condition);
            }
          };
          lexer2.performAction = function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
            var YYSTATE = YY_START;
            switch ($avoiding_name_collisions) {
              case 0:
                break;
              case 1:
                return 20;
                break;
              case 2:
                return 19;
                break;
              case 3:
                return 8;
                break;
              case 4:
                return 9;
                break;
              case 5:
                return 6;
                break;
              case 6:
                return 7;
                break;
              case 7:
                return 11;
                break;
              case 8:
                return 13;
                break;
              case 9:
                return 10;
                break;
              case 10:
                return 12;
                break;
              case 11:
                return 14;
                break;
              case 12:
                return 15;
                break;
              case 13:
                return 16;
                break;
              case 14:
                return 17;
                break;
              case 15:
                return 18;
                break;
              case 16:
                return 5;
                break;
              case 17:
                return "INVALID";
                break;
            }
          };
          lexer2.rules = [/^\s+/, /^[0-9]+(\.[0-9]+)?\b/, /^n\b/, /^\|\|/, /^&&/, /^\?/, /^:/, /^<=/, /^>=/, /^</, /^>/, /^!=/, /^==/, /^%/, /^\(/, /^\)/, /^$/, /^./];
          lexer2.conditions = { "INITIAL": { "rules": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17], "inclusive": true } };
          return lexer2;
        }();
        parser.lexer = lexer;
        return parser;
      }();
      if (typeof exports !== "undefined") {
        if (typeof module !== "undefined" && module.exports) {
          exports = module.exports = Jed2;
        }
        exports.Jed = Jed2;
      } else {
        if (typeof define === "function" && define.amd) {
          define(function() {
            return Jed2;
          });
        }
        root["Jed"] = Jed2;
      }
    })(exports);
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/dist/preact.module.js
function s(n2, l3) {
  for (var u5 in l3)
    n2[u5] = l3[u5];
  return n2;
}
function a(n2) {
  var l3 = n2.parentNode;
  l3 && l3.removeChild(n2);
}
function h(l3, u5, i5) {
  var t5, o3, r3, f3 = {};
  for (r3 in u5)
    "key" == r3 ? t5 = u5[r3] : "ref" == r3 ? o3 = u5[r3] : f3[r3] = u5[r3];
  if (arguments.length > 2 && (f3.children = arguments.length > 3 ? n.call(arguments, 2) : i5), "function" == typeof l3 && null != l3.defaultProps)
    for (r3 in l3.defaultProps)
      void 0 === f3[r3] && (f3[r3] = l3.defaultProps[r3]);
  return v(l3, f3, t5, o3, null);
}
function v(n2, i5, t5, o3, r3) {
  var f3 = { type: n2, props: i5, key: t5, ref: o3, __k: null, __: null, __b: 0, __e: null, __d: void 0, __c: null, __h: null, constructor: void 0, __v: null == r3 ? ++u : r3 };
  return null == r3 && null != l.vnode && l.vnode(f3), f3;
}
function y() {
  return { current: null };
}
function p2(n2) {
  return n2.children;
}
function d(n2, l3) {
  this.props = n2, this.context = l3;
}
function _(n2, l3) {
  if (null == l3)
    return n2.__ ? _(n2.__, n2.__.__k.indexOf(n2) + 1) : null;
  for (var u5; l3 < n2.__k.length; l3++)
    if (null != (u5 = n2.__k[l3]) && null != u5.__e)
      return u5.__e;
  return "function" == typeof n2.type ? _(n2) : null;
}
function k(n2) {
  var l3, u5;
  if (null != (n2 = n2.__) && null != n2.__c) {
    for (n2.__e = n2.__c.base = null, l3 = 0; l3 < n2.__k.length; l3++)
      if (null != (u5 = n2.__k[l3]) && null != u5.__e) {
        n2.__e = n2.__c.base = u5.__e;
        break;
      }
    return k(n2);
  }
}
function b(n2) {
  (!n2.__d && (n2.__d = true) && t.push(n2) && !g.__r++ || o !== l.debounceRendering) && ((o = l.debounceRendering) || setTimeout)(g);
}
function g() {
  for (var n2; g.__r = t.length; )
    n2 = t.sort(function(n3, l3) {
      return n3.__v.__b - l3.__v.__b;
    }), t = [], n2.some(function(n3) {
      var l3, u5, i5, t5, o3, r3;
      n3.__d && (o3 = (t5 = (l3 = n3).__v).__e, (r3 = l3.__P) && (u5 = [], (i5 = s({}, t5)).__v = t5.__v + 1, j(r3, t5, i5, l3.__n, void 0 !== r3.ownerSVGElement, null != t5.__h ? [o3] : null, u5, null == o3 ? _(t5) : o3, t5.__h), z(u5, t5), t5.__e != o3 && k(t5)));
    });
}
function w(n2, l3, u5, i5, t5, o3, r3, c5, s6, a6) {
  var h5, y6, d6, k6, b5, g4, w6, x6 = i5 && i5.__k || e, C3 = x6.length;
  for (u5.__k = [], h5 = 0; h5 < l3.length; h5++)
    if (null != (k6 = u5.__k[h5] = null == (k6 = l3[h5]) || "boolean" == typeof k6 ? null : "string" == typeof k6 || "number" == typeof k6 || "bigint" == typeof k6 ? v(null, k6, null, null, k6) : Array.isArray(k6) ? v(p2, { children: k6 }, null, null, null) : k6.__b > 0 ? v(k6.type, k6.props, k6.key, k6.ref ? k6.ref : null, k6.__v) : k6)) {
      if (k6.__ = u5, k6.__b = u5.__b + 1, null === (d6 = x6[h5]) || d6 && k6.key == d6.key && k6.type === d6.type)
        x6[h5] = void 0;
      else
        for (y6 = 0; y6 < C3; y6++) {
          if ((d6 = x6[y6]) && k6.key == d6.key && k6.type === d6.type) {
            x6[y6] = void 0;
            break;
          }
          d6 = null;
        }
      j(n2, k6, d6 = d6 || f, t5, o3, r3, c5, s6, a6), b5 = k6.__e, (y6 = k6.ref) && d6.ref != y6 && (w6 || (w6 = []), d6.ref && w6.push(d6.ref, null, k6), w6.push(y6, k6.__c || b5, k6)), null != b5 ? (null == g4 && (g4 = b5), "function" == typeof k6.type && k6.__k === d6.__k ? k6.__d = s6 = m(k6, s6, n2) : s6 = A2(n2, k6, d6, x6, b5, s6), "function" == typeof u5.type && (u5.__d = s6)) : s6 && d6.__e == s6 && s6.parentNode != n2 && (s6 = _(d6));
    }
  for (u5.__e = g4, h5 = C3; h5--; )
    null != x6[h5] && N(x6[h5], x6[h5]);
  if (w6)
    for (h5 = 0; h5 < w6.length; h5++)
      M2(w6[h5], w6[++h5], w6[++h5]);
}
function m(n2, l3, u5) {
  for (var i5, t5 = n2.__k, o3 = 0; t5 && o3 < t5.length; o3++)
    (i5 = t5[o3]) && (i5.__ = n2, l3 = "function" == typeof i5.type ? m(i5, l3, u5) : A2(u5, i5, i5, t5, i5.__e, l3));
  return l3;
}
function x(n2, l3) {
  return l3 = l3 || [], null == n2 || "boolean" == typeof n2 || (Array.isArray(n2) ? n2.some(function(n3) {
    x(n3, l3);
  }) : l3.push(n2)), l3;
}
function A2(n2, l3, u5, i5, t5, o3) {
  var r3, f3, e5;
  if (void 0 !== l3.__d)
    r3 = l3.__d, l3.__d = void 0;
  else if (null == u5 || t5 != o3 || null == t5.parentNode)
    n:
      if (null == o3 || o3.parentNode !== n2)
        n2.appendChild(t5), r3 = null;
      else {
        for (f3 = o3, e5 = 0; (f3 = f3.nextSibling) && e5 < i5.length; e5 += 1)
          if (f3 == t5)
            break n;
        n2.insertBefore(t5, o3), r3 = o3;
      }
  return void 0 !== r3 ? r3 : t5.nextSibling;
}
function C(n2, l3, u5, i5, t5) {
  var o3;
  for (o3 in u5)
    "children" === o3 || "key" === o3 || o3 in l3 || H(n2, o3, null, u5[o3], i5);
  for (o3 in l3)
    t5 && "function" != typeof l3[o3] || "children" === o3 || "key" === o3 || "value" === o3 || "checked" === o3 || u5[o3] === l3[o3] || H(n2, o3, l3[o3], u5[o3], i5);
}
function $(n2, l3, u5) {
  "-" === l3[0] ? n2.setProperty(l3, u5) : n2[l3] = null == u5 ? "" : "number" != typeof u5 || c.test(l3) ? u5 : u5 + "px";
}
function H(n2, l3, u5, i5, t5) {
  var o3;
  n:
    if ("style" === l3)
      if ("string" == typeof u5)
        n2.style.cssText = u5;
      else {
        if ("string" == typeof i5 && (n2.style.cssText = i5 = ""), i5)
          for (l3 in i5)
            u5 && l3 in u5 || $(n2.style, l3, "");
        if (u5)
          for (l3 in u5)
            i5 && u5[l3] === i5[l3] || $(n2.style, l3, u5[l3]);
      }
    else if ("o" === l3[0] && "n" === l3[1])
      o3 = l3 !== (l3 = l3.replace(/Capture$/, "")), l3 = l3.toLowerCase() in n2 ? l3.toLowerCase().slice(2) : l3.slice(2), n2.l || (n2.l = {}), n2.l[l3 + o3] = u5, u5 ? i5 || n2.addEventListener(l3, o3 ? T : I2, o3) : n2.removeEventListener(l3, o3 ? T : I2, o3);
    else if ("dangerouslySetInnerHTML" !== l3) {
      if (t5)
        l3 = l3.replace(/xlink(H|:h)/, "h").replace(/sName$/, "s");
      else if ("href" !== l3 && "list" !== l3 && "form" !== l3 && "tabIndex" !== l3 && "download" !== l3 && l3 in n2)
        try {
          n2[l3] = null == u5 ? "" : u5;
          break n;
        } catch (n3) {
        }
      "function" == typeof u5 || (null == u5 || false === u5 && -1 == l3.indexOf("-") ? n2.removeAttribute(l3) : n2.setAttribute(l3, u5));
    }
}
function I2(n2) {
  this.l[n2.type + false](l.event ? l.event(n2) : n2);
}
function T(n2) {
  this.l[n2.type + true](l.event ? l.event(n2) : n2);
}
function j(n2, u5, i5, t5, o3, r3, f3, e5, c5) {
  var a6, h5, v3, y6, _3, k6, b5, g4, m6, x6, A5, C3, $3, H6, I6, T6 = u5.type;
  if (void 0 !== u5.constructor)
    return null;
  null != i5.__h && (c5 = i5.__h, e5 = u5.__e = i5.__e, u5.__h = null, r3 = [e5]), (a6 = l.__b) && a6(u5);
  try {
    n:
      if ("function" == typeof T6) {
        if (g4 = u5.props, m6 = (a6 = T6.contextType) && t5[a6.__c], x6 = a6 ? m6 ? m6.props.value : a6.__ : t5, i5.__c ? b5 = (h5 = u5.__c = i5.__c).__ = h5.__E : ("prototype" in T6 && T6.prototype.render ? u5.__c = h5 = new T6(g4, x6) : (u5.__c = h5 = new d(g4, x6), h5.constructor = T6, h5.render = O), m6 && m6.sub(h5), h5.props = g4, h5.state || (h5.state = {}), h5.context = x6, h5.__n = t5, v3 = h5.__d = true, h5.__h = [], h5._sb = []), null == h5.__s && (h5.__s = h5.state), null != T6.getDerivedStateFromProps && (h5.__s == h5.state && (h5.__s = s({}, h5.__s)), s(h5.__s, T6.getDerivedStateFromProps(g4, h5.__s))), y6 = h5.props, _3 = h5.state, v3)
          null == T6.getDerivedStateFromProps && null != h5.componentWillMount && h5.componentWillMount(), null != h5.componentDidMount && h5.__h.push(h5.componentDidMount);
        else {
          if (null == T6.getDerivedStateFromProps && g4 !== y6 && null != h5.componentWillReceiveProps && h5.componentWillReceiveProps(g4, x6), !h5.__e && null != h5.shouldComponentUpdate && false === h5.shouldComponentUpdate(g4, h5.__s, x6) || u5.__v === i5.__v) {
            for (h5.props = g4, h5.state = h5.__s, u5.__v !== i5.__v && (h5.__d = false), h5.__v = u5, u5.__e = i5.__e, u5.__k = i5.__k, u5.__k.forEach(function(n3) {
              n3 && (n3.__ = u5);
            }), A5 = 0; A5 < h5._sb.length; A5++)
              h5.__h.push(h5._sb[A5]);
            h5._sb = [], h5.__h.length && f3.push(h5);
            break n;
          }
          null != h5.componentWillUpdate && h5.componentWillUpdate(g4, h5.__s, x6), null != h5.componentDidUpdate && h5.__h.push(function() {
            h5.componentDidUpdate(y6, _3, k6);
          });
        }
        if (h5.context = x6, h5.props = g4, h5.__v = u5, h5.__P = n2, C3 = l.__r, $3 = 0, "prototype" in T6 && T6.prototype.render) {
          for (h5.state = h5.__s, h5.__d = false, C3 && C3(u5), a6 = h5.render(h5.props, h5.state, h5.context), H6 = 0; H6 < h5._sb.length; H6++)
            h5.__h.push(h5._sb[H6]);
          h5._sb = [];
        } else
          do {
            h5.__d = false, C3 && C3(u5), a6 = h5.render(h5.props, h5.state, h5.context), h5.state = h5.__s;
          } while (h5.__d && ++$3 < 25);
        h5.state = h5.__s, null != h5.getChildContext && (t5 = s(s({}, t5), h5.getChildContext())), v3 || null == h5.getSnapshotBeforeUpdate || (k6 = h5.getSnapshotBeforeUpdate(y6, _3)), I6 = null != a6 && a6.type === p2 && null == a6.key ? a6.props.children : a6, w(n2, Array.isArray(I6) ? I6 : [I6], u5, i5, t5, o3, r3, f3, e5, c5), h5.base = u5.__e, u5.__h = null, h5.__h.length && f3.push(h5), b5 && (h5.__E = h5.__ = null), h5.__e = false;
      } else
        null == r3 && u5.__v === i5.__v ? (u5.__k = i5.__k, u5.__e = i5.__e) : u5.__e = L2(i5.__e, u5, i5, t5, o3, r3, f3, c5);
    (a6 = l.diffed) && a6(u5);
  } catch (n3) {
    u5.__v = null, (c5 || null != r3) && (u5.__e = e5, u5.__h = !!c5, r3[r3.indexOf(e5)] = null), l.__e(n3, u5, i5);
  }
}
function z(n2, u5) {
  l.__c && l.__c(u5, n2), n2.some(function(u6) {
    try {
      n2 = u6.__h, u6.__h = [], n2.some(function(n3) {
        n3.call(u6);
      });
    } catch (n3) {
      l.__e(n3, u6.__v);
    }
  });
}
function L2(l3, u5, i5, t5, o3, r3, e5, c5) {
  var s6, h5, v3, y6 = i5.props, p4 = u5.props, d6 = u5.type, k6 = 0;
  if ("svg" === d6 && (o3 = true), null != r3) {
    for (; k6 < r3.length; k6++)
      if ((s6 = r3[k6]) && "setAttribute" in s6 == !!d6 && (d6 ? s6.localName === d6 : 3 === s6.nodeType)) {
        l3 = s6, r3[k6] = null;
        break;
      }
  }
  if (null == l3) {
    if (null === d6)
      return document.createTextNode(p4);
    l3 = o3 ? document.createElementNS("http://www.w3.org/2000/svg", d6) : document.createElement(d6, p4.is && p4), r3 = null, c5 = false;
  }
  if (null === d6)
    y6 === p4 || c5 && l3.data === p4 || (l3.data = p4);
  else {
    if (r3 = r3 && n.call(l3.childNodes), h5 = (y6 = i5.props || f).dangerouslySetInnerHTML, v3 = p4.dangerouslySetInnerHTML, !c5) {
      if (null != r3)
        for (y6 = {}, k6 = 0; k6 < l3.attributes.length; k6++)
          y6[l3.attributes[k6].name] = l3.attributes[k6].value;
      (v3 || h5) && (v3 && (h5 && v3.__html == h5.__html || v3.__html === l3.innerHTML) || (l3.innerHTML = v3 && v3.__html || ""));
    }
    if (C(l3, p4, y6, o3, c5), v3)
      u5.__k = [];
    else if (k6 = u5.props.children, w(l3, Array.isArray(k6) ? k6 : [k6], u5, i5, t5, o3 && "foreignObject" !== d6, r3, e5, r3 ? r3[0] : i5.__k && _(i5, 0), c5), null != r3)
      for (k6 = r3.length; k6--; )
        null != r3[k6] && a(r3[k6]);
    c5 || ("value" in p4 && void 0 !== (k6 = p4.value) && (k6 !== l3.value || "progress" === d6 && !k6 || "option" === d6 && k6 !== y6.value) && H(l3, "value", k6, y6.value, false), "checked" in p4 && void 0 !== (k6 = p4.checked) && k6 !== l3.checked && H(l3, "checked", k6, y6.checked, false));
  }
  return l3;
}
function M2(n2, u5, i5) {
  try {
    "function" == typeof n2 ? n2(u5) : n2.current = u5;
  } catch (n3) {
    l.__e(n3, i5);
  }
}
function N(n2, u5, i5) {
  var t5, o3;
  if (l.unmount && l.unmount(n2), (t5 = n2.ref) && (t5.current && t5.current !== n2.__e || M2(t5, null, u5)), null != (t5 = n2.__c)) {
    if (t5.componentWillUnmount)
      try {
        t5.componentWillUnmount();
      } catch (n3) {
        l.__e(n3, u5);
      }
    t5.base = t5.__P = null, n2.__c = void 0;
  }
  if (t5 = n2.__k)
    for (o3 = 0; o3 < t5.length; o3++)
      t5[o3] && N(t5[o3], u5, i5 || "function" != typeof n2.type);
  i5 || null == n2.__e || a(n2.__e), n2.__ = n2.__e = n2.__d = void 0;
}
function O(n2, l3, u5) {
  return this.constructor(n2, u5);
}
function P(u5, i5, t5) {
  var o3, r3, e5;
  l.__ && l.__(u5, i5), r3 = (o3 = "function" == typeof t5) ? null : t5 && t5.__k || i5.__k, e5 = [], j(i5, u5 = (!o3 && t5 || i5).__k = h(p2, null, [u5]), r3 || f, f, void 0 !== i5.ownerSVGElement, !o3 && t5 ? [t5] : r3 ? null : i5.firstChild ? n.call(i5.childNodes) : null, e5, !o3 && t5 ? t5 : r3 ? r3.__e : i5.firstChild, o3), z(e5, u5);
}
function S2(n2, l3) {
  P(n2, l3, S2);
}
function q(l3, u5, i5) {
  var t5, o3, r3, f3 = s({}, l3.props);
  for (r3 in u5)
    "key" == r3 ? t5 = u5[r3] : "ref" == r3 ? o3 = u5[r3] : f3[r3] = u5[r3];
  return arguments.length > 2 && (f3.children = arguments.length > 3 ? n.call(arguments, 2) : i5), v(l3.type, f3, t5 || l3.key, o3 || l3.ref, null);
}
function B(n2, l3) {
  var u5 = { __c: l3 = "__cC" + r++, __: n2, Consumer: function(n3, l4) {
    return n3.children(l4);
  }, Provider: function(n3) {
    var u6, i5;
    return this.getChildContext || (u6 = [], (i5 = {})[l3] = this, this.getChildContext = function() {
      return i5;
    }, this.shouldComponentUpdate = function(n4) {
      this.props.value !== n4.value && u6.some(b);
    }, this.sub = function(n4) {
      u6.push(n4);
      var l4 = n4.componentWillUnmount;
      n4.componentWillUnmount = function() {
        u6.splice(u6.indexOf(n4), 1), l4 && l4.call(n4);
      };
    }), n3.children;
  } };
  return u5.Provider.__ = u5.Consumer.contextType = u5;
}
var n, l, u, i, t, o, r, f, e, c;
var init_preact_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/dist/preact.module.js"() {
    f = {};
    e = [];
    c = /acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;
    n = e.slice, l = { __e: function(n2, l3, u5, i5) {
      for (var t5, o3, r3; l3 = l3.__; )
        if ((t5 = l3.__c) && !t5.__)
          try {
            if ((o3 = t5.constructor) && null != o3.getDerivedStateFromError && (t5.setState(o3.getDerivedStateFromError(n2)), r3 = t5.__d), null != t5.componentDidCatch && (t5.componentDidCatch(n2, i5 || {}), r3 = t5.__d), r3)
              return t5.__E = t5;
          } catch (l4) {
            n2 = l4;
          }
      throw n2;
    } }, u = 0, i = function(n2) {
      return null != n2 && void 0 === n2.constructor;
    }, d.prototype.setState = function(n2, l3) {
      var u5;
      u5 = null != this.__s && this.__s !== this.state ? this.__s : this.__s = s({}, this.state), "function" == typeof n2 && (n2 = n2(s({}, u5), this.props)), n2 && s(u5, n2), null != n2 && this.__v && (l3 && this._sb.push(l3), b(this));
    }, d.prototype.forceUpdate = function(n2) {
      this.__v && (this.__e = true, n2 && this.__h.push(n2), b(this));
    }, d.prototype.render = p2, t = [], g.__r = 0, r = 0;
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/hooks/dist/hooks.module.js
function d2(t5, u5) {
  l.__h && l.__h(r2, t5, o2 || u5), o2 = 0;
  var i5 = r2.__H || (r2.__H = { __: [], __h: [] });
  return t5 >= i5.__.length && i5.__.push({ __V: c2 }), i5.__[t5];
}
function p3(n2) {
  return o2 = 1, y2(B2, n2);
}
function y2(n2, u5, i5) {
  var o3 = d2(t2++, 2);
  if (o3.t = n2, !o3.__c && (o3.__ = [i5 ? i5(u5) : B2(void 0, u5), function(n3) {
    var t5 = o3.__N ? o3.__N[0] : o3.__[0], r3 = o3.t(t5, n3);
    t5 !== r3 && (o3.__N = [r3, o3.__[1]], o3.__c.setState({}));
  }], o3.__c = r2, !r2.u)) {
    r2.u = true;
    var f3 = r2.shouldComponentUpdate;
    r2.shouldComponentUpdate = function(n3, t5, r3) {
      if (!o3.__c.__H)
        return true;
      var u6 = o3.__c.__H.__.filter(function(n4) {
        return n4.__c;
      });
      if (u6.every(function(n4) {
        return !n4.__N;
      }))
        return !f3 || f3.call(this, n3, t5, r3);
      var i6 = false;
      return u6.forEach(function(n4) {
        if (n4.__N) {
          var t6 = n4.__[0];
          n4.__ = n4.__N, n4.__N = void 0, t6 !== n4.__[0] && (i6 = true);
        }
      }), !(!i6 && o3.__c.props === n3) && (!f3 || f3.call(this, n3, t5, r3));
    };
  }
  return o3.__N || o3.__;
}
function h2(u5, i5) {
  var o3 = d2(t2++, 3);
  !l.__s && z2(o3.__H, i5) && (o3.__ = u5, o3.i = i5, r2.__H.__h.push(o3));
}
function s2(u5, i5) {
  var o3 = d2(t2++, 4);
  !l.__s && z2(o3.__H, i5) && (o3.__ = u5, o3.i = i5, r2.__h.push(o3));
}
function _2(n2) {
  return o2 = 5, F(function() {
    return { current: n2 };
  }, []);
}
function A3(n2, t5, r3) {
  o2 = 6, s2(function() {
    return "function" == typeof n2 ? (n2(t5()), function() {
      return n2(null);
    }) : n2 ? (n2.current = t5(), function() {
      return n2.current = null;
    }) : void 0;
  }, null == r3 ? r3 : r3.concat(n2));
}
function F(n2, r3) {
  var u5 = d2(t2++, 7);
  return z2(u5.__H, r3) ? (u5.__V = n2(), u5.i = r3, u5.__h = n2, u5.__V) : u5.__;
}
function T2(n2, t5) {
  return o2 = 8, F(function() {
    return n2;
  }, t5);
}
function q2(n2) {
  var u5 = r2.context[n2.__c], i5 = d2(t2++, 9);
  return i5.c = n2, u5 ? (null == i5.__ && (i5.__ = true, u5.sub(r2)), u5.props.value) : n2.__;
}
function x2(t5, r3) {
  l.useDebugValue && l.useDebugValue(r3 ? r3(t5) : t5);
}
function P2(n2) {
  var u5 = d2(t2++, 10), i5 = p3();
  return u5.__ = n2, r2.componentDidCatch || (r2.componentDidCatch = function(n3, t5) {
    u5.__ && u5.__(n3, t5), i5[1](n3);
  }), [i5[0], function() {
    i5[1](void 0);
  }];
}
function V() {
  var n2 = d2(t2++, 11);
  if (!n2.__) {
    for (var u5 = r2.__v; null !== u5 && !u5.__m && null !== u5.__; )
      u5 = u5.__;
    var i5 = u5.__m || (u5.__m = [0, 0]);
    n2.__ = "P" + i5[0] + "-" + i5[1]++;
  }
  return n2.__;
}
function b2() {
  for (var t5; t5 = f2.shift(); )
    if (t5.__P && t5.__H)
      try {
        t5.__H.__h.forEach(k2), t5.__H.__h.forEach(w2), t5.__H.__h = [];
      } catch (r3) {
        t5.__H.__h = [], l.__e(r3, t5.__v);
      }
}
function j2(n2) {
  var t5, r3 = function() {
    clearTimeout(u5), g2 && cancelAnimationFrame(t5), setTimeout(n2);
  }, u5 = setTimeout(r3, 100);
  g2 && (t5 = requestAnimationFrame(r3));
}
function k2(n2) {
  var t5 = r2, u5 = n2.__c;
  "function" == typeof u5 && (n2.__c = void 0, u5()), r2 = t5;
}
function w2(n2) {
  var t5 = r2;
  n2.__c = n2.__(), r2 = t5;
}
function z2(n2, t5) {
  return !n2 || n2.length !== t5.length || t5.some(function(t6, r3) {
    return t6 !== n2[r3];
  });
}
function B2(n2, t5) {
  return "function" == typeof t5 ? t5(n2) : t5;
}
var t2, r2, u2, i2, o2, f2, c2, e2, a2, v2, l2, m2, g2;
var init_hooks_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/hooks/dist/hooks.module.js"() {
    init_preact_module();
    o2 = 0;
    f2 = [];
    c2 = [];
    e2 = l.__b;
    a2 = l.__r;
    v2 = l.diffed;
    l2 = l.__c;
    m2 = l.unmount;
    l.__b = function(n2) {
      r2 = null, e2 && e2(n2);
    }, l.__r = function(n2) {
      a2 && a2(n2), t2 = 0;
      var i5 = (r2 = n2.__c).__H;
      i5 && (u2 === r2 ? (i5.__h = [], r2.__h = [], i5.__.forEach(function(n3) {
        n3.__N && (n3.__ = n3.__N), n3.__V = c2, n3.__N = n3.i = void 0;
      })) : (i5.__h.forEach(k2), i5.__h.forEach(w2), i5.__h = [])), u2 = r2;
    }, l.diffed = function(t5) {
      v2 && v2(t5);
      var o3 = t5.__c;
      o3 && o3.__H && (o3.__H.__h.length && (1 !== f2.push(o3) && i2 === l.requestAnimationFrame || ((i2 = l.requestAnimationFrame) || j2)(b2)), o3.__H.__.forEach(function(n2) {
        n2.i && (n2.__H = n2.i), n2.__V !== c2 && (n2.__ = n2.__V), n2.i = void 0, n2.__V = c2;
      })), u2 = r2 = null;
    }, l.__c = function(t5, r3) {
      r3.some(function(t6) {
        try {
          t6.__h.forEach(k2), t6.__h = t6.__h.filter(function(n2) {
            return !n2.__ || w2(n2);
          });
        } catch (u5) {
          r3.some(function(n2) {
            n2.__h && (n2.__h = []);
          }), r3 = [], l.__e(u5, t6.__v);
        }
      }), l2 && l2(t5, r3);
    }, l.unmount = function(t5) {
      m2 && m2(t5);
      var r3, u5 = t5.__c;
      u5 && u5.__H && (u5.__H.__.forEach(function(n2) {
        try {
          k2(n2);
        } catch (n3) {
          r3 = n3;
        }
      }), u5.__H = void 0, r3 && l.__e(r3, u5.__v));
    };
    g2 = "function" == typeof requestAnimationFrame;
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/compat/dist/compat.module.js
var compat_module_exports = {};
__export(compat_module_exports, {
  Children: () => O2,
  Component: () => d,
  Fragment: () => p2,
  PureComponent: () => w3,
  StrictMode: () => vn2,
  Suspense: () => D3,
  SuspenseList: () => V2,
  __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: () => rn,
  cloneElement: () => cn,
  createContext: () => B,
  createElement: () => h,
  createFactory: () => on,
  createPortal: () => j3,
  createRef: () => y,
  default: () => bn,
  findDOMNode: () => an,
  flushSync: () => hn,
  forwardRef: () => k3,
  hydrate: () => q3,
  isValidElement: () => ln,
  lazy: () => M3,
  memo: () => R,
  render: () => Y2,
  startTransition: () => dn,
  unmountComponentAtNode: () => fn,
  unstable_batchedUpdates: () => sn,
  useCallback: () => T2,
  useContext: () => q2,
  useDebugValue: () => x2,
  useDeferredValue: () => pn,
  useEffect: () => h2,
  useErrorBoundary: () => P2,
  useId: () => V,
  useImperativeHandle: () => A3,
  useInsertionEffect: () => yn,
  useLayoutEffect: () => s2,
  useMemo: () => F,
  useReducer: () => y2,
  useRef: () => _2,
  useState: () => p3,
  useSyncExternalStore: () => _n,
  useTransition: () => mn,
  version: () => un
});
function g3(n2, t5) {
  for (var e5 in t5)
    n2[e5] = t5[e5];
  return n2;
}
function C2(n2, t5) {
  for (var e5 in n2)
    if ("__source" !== e5 && !(e5 in t5))
      return true;
  for (var r3 in t5)
    if ("__source" !== r3 && n2[r3] !== t5[r3])
      return true;
  return false;
}
function E(n2, t5) {
  return n2 === t5 && (0 !== n2 || 1 / n2 == 1 / t5) || n2 != n2 && t5 != t5;
}
function w3(n2) {
  this.props = n2;
}
function R(n2, e5) {
  function r3(n3) {
    var t5 = this.props.ref, r4 = t5 == n3.ref;
    return !r4 && t5 && (t5.call ? t5(null) : t5.current = null), e5 ? !e5(this.props, n3) || !r4 : C2(this.props, n3);
  }
  function u5(e6) {
    return this.shouldComponentUpdate = r3, h(n2, e6);
  }
  return u5.displayName = "Memo(" + (n2.displayName || n2.name) + ")", u5.prototype.isReactComponent = true, u5.__f = true, u5;
}
function k3(n2) {
  function t5(t6) {
    var e5 = g3({}, t6);
    return delete e5.ref, n2(e5, t6.ref || null);
  }
  return t5.$$typeof = N2, t5.render = t5, t5.prototype.isReactComponent = t5.__f = true, t5.displayName = "ForwardRef(" + (n2.displayName || n2.name) + ")", t5;
}
function L3(n2, t5, e5) {
  return n2 && (n2.__c && n2.__c.__H && (n2.__c.__H.__.forEach(function(n3) {
    "function" == typeof n3.__c && n3.__c();
  }), n2.__c.__H = null), null != (n2 = g3({}, n2)).__c && (n2.__c.__P === e5 && (n2.__c.__P = t5), n2.__c = null), n2.__k = n2.__k && n2.__k.map(function(n3) {
    return L3(n3, t5, e5);
  })), n2;
}
function U(n2, t5, e5) {
  return n2 && (n2.__v = null, n2.__k = n2.__k && n2.__k.map(function(n3) {
    return U(n3, t5, e5);
  }), n2.__c && n2.__c.__P === t5 && (n2.__e && e5.insertBefore(n2.__e, n2.__d), n2.__c.__e = true, n2.__c.__P = e5)), n2;
}
function D3() {
  this.__u = 0, this.t = null, this.__b = null;
}
function F2(n2) {
  var t5 = n2.__.__c;
  return t5 && t5.__a && t5.__a(n2);
}
function M3(n2) {
  var e5, r3, u5;
  function o3(o4) {
    if (e5 || (e5 = n2()).then(function(n3) {
      r3 = n3.default || n3;
    }, function(n3) {
      u5 = n3;
    }), u5)
      throw u5;
    if (!r3)
      throw e5;
    return h(r3, o4);
  }
  return o3.displayName = "Lazy", o3.__f = true, o3;
}
function V2() {
  this.u = null, this.o = null;
}
function P3(n2) {
  return this.getChildContext = function() {
    return n2.context;
  }, n2.children;
}
function $2(n2) {
  var e5 = this, r3 = n2.i;
  e5.componentWillUnmount = function() {
    P(null, e5.l), e5.l = null, e5.i = null;
  }, e5.i && e5.i !== r3 && e5.componentWillUnmount(), n2.__v ? (e5.l || (e5.i = r3, e5.l = { nodeType: 1, parentNode: r3, childNodes: [], appendChild: function(n3) {
    this.childNodes.push(n3), e5.i.appendChild(n3);
  }, insertBefore: function(n3, t5) {
    this.childNodes.push(n3), e5.i.appendChild(n3);
  }, removeChild: function(n3) {
    this.childNodes.splice(this.childNodes.indexOf(n3) >>> 1, 1), e5.i.removeChild(n3);
  } }), P(h(P3, { context: e5.context }, n2.__v), e5.l)) : e5.l && e5.componentWillUnmount();
}
function j3(n2, e5) {
  var r3 = h($2, { __v: n2, i: e5 });
  return r3.containerInfo = e5, r3;
}
function Y2(n2, t5, e5) {
  return null == t5.__k && (t5.textContent = ""), P(n2, t5), "function" == typeof e5 && e5(), n2 ? n2.__c : null;
}
function q3(n2, t5, e5) {
  return S2(n2, t5), "function" == typeof e5 && e5(), n2 ? n2.__c : null;
}
function J() {
}
function K3() {
  return this.cancelBubble;
}
function Q() {
  return this.defaultPrevented;
}
function on(n2) {
  return h.bind(null, n2);
}
function ln(n2) {
  return !!n2 && n2.$$typeof === z3;
}
function cn(n2) {
  return ln(n2) ? q.apply(null, arguments) : n2;
}
function fn(n2) {
  return !!n2.__k && (P(null, n2), true);
}
function an(n2) {
  return n2 && (n2.base || 1 === n2.nodeType && n2) || null;
}
function dn(n2) {
  n2();
}
function pn(n2) {
  return n2;
}
function mn() {
  return [false, dn];
}
function _n(n2, t5) {
  var e5 = t5(), r3 = p3({ h: { __: e5, v: t5 } }), u5 = r3[0].h, o3 = r3[1];
  return s2(function() {
    u5.__ = e5, u5.v = t5, E(u5.__, t5()) || o3({ h: u5 });
  }, [n2, e5, t5]), h2(function() {
    return E(u5.__, u5.v()) || o3({ h: u5 }), n2(function() {
      E(u5.__, u5.v()) || o3({ h: u5 });
    });
  }, [n2]), e5;
}
var x3, N2, A4, O2, T3, I3, W, z3, B3, H2, Z2, G, X2, nn, tn, en, rn, un, sn, hn, vn2, yn, bn;
var init_compat_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/compat/dist/compat.module.js"() {
    init_preact_module();
    init_preact_module();
    init_hooks_module();
    init_hooks_module();
    (w3.prototype = new d()).isPureReactComponent = true, w3.prototype.shouldComponentUpdate = function(n2, t5) {
      return C2(this.props, n2) || C2(this.state, t5);
    };
    x3 = l.__b;
    l.__b = function(n2) {
      n2.type && n2.type.__f && n2.ref && (n2.props.ref = n2.ref, n2.ref = null), x3 && x3(n2);
    };
    N2 = "undefined" != typeof Symbol && Symbol.for && Symbol.for("react.forward_ref") || 3911;
    A4 = function(n2, t5) {
      return null == n2 ? null : x(x(n2).map(t5));
    };
    O2 = { map: A4, forEach: A4, count: function(n2) {
      return n2 ? x(n2).length : 0;
    }, only: function(n2) {
      var t5 = x(n2);
      if (1 !== t5.length)
        throw "Children.only";
      return t5[0];
    }, toArray: x };
    T3 = l.__e;
    l.__e = function(n2, t5, e5, r3) {
      if (n2.then) {
        for (var u5, o3 = t5; o3 = o3.__; )
          if ((u5 = o3.__c) && u5.__c)
            return null == t5.__e && (t5.__e = e5.__e, t5.__k = e5.__k), u5.__c(n2, t5);
      }
      T3(n2, t5, e5, r3);
    };
    I3 = l.unmount;
    l.unmount = function(n2) {
      var t5 = n2.__c;
      t5 && t5.__R && t5.__R(), t5 && true === n2.__h && (n2.type = null), I3 && I3(n2);
    }, (D3.prototype = new d()).__c = function(n2, t5) {
      var e5 = t5.__c, r3 = this;
      null == r3.t && (r3.t = []), r3.t.push(e5);
      var u5 = F2(r3.__v), o3 = false, i5 = function() {
        o3 || (o3 = true, e5.__R = null, u5 ? u5(l3) : l3());
      };
      e5.__R = i5;
      var l3 = function() {
        if (!--r3.__u) {
          if (r3.state.__a) {
            var n3 = r3.state.__a;
            r3.__v.__k[0] = U(n3, n3.__c.__P, n3.__c.__O);
          }
          var t6;
          for (r3.setState({ __a: r3.__b = null }); t6 = r3.t.pop(); )
            t6.forceUpdate();
        }
      }, c5 = true === t5.__h;
      r3.__u++ || c5 || r3.setState({ __a: r3.__b = r3.__v.__k[0] }), n2.then(i5, i5);
    }, D3.prototype.componentWillUnmount = function() {
      this.t = [];
    }, D3.prototype.render = function(n2, e5) {
      if (this.__b) {
        if (this.__v.__k) {
          var r3 = document.createElement("div"), o3 = this.__v.__k[0].__c;
          this.__v.__k[0] = L3(this.__b, r3, o3.__O = o3.__P);
        }
        this.__b = null;
      }
      var i5 = e5.__a && h(p2, null, n2.fallback);
      return i5 && (i5.__h = null), [h(p2, null, e5.__a ? null : n2.children), i5];
    };
    W = function(n2, t5, e5) {
      if (++e5[1] === e5[0] && n2.o.delete(t5), n2.props.revealOrder && ("t" !== n2.props.revealOrder[0] || !n2.o.size))
        for (e5 = n2.u; e5; ) {
          for (; e5.length > 3; )
            e5.pop()();
          if (e5[1] < e5[0])
            break;
          n2.u = e5 = e5[2];
        }
    };
    (V2.prototype = new d()).__a = function(n2) {
      var t5 = this, e5 = F2(t5.__v), r3 = t5.o.get(n2);
      return r3[0]++, function(u5) {
        var o3 = function() {
          t5.props.revealOrder ? (r3.push(u5), W(t5, n2, r3)) : u5();
        };
        e5 ? e5(o3) : o3();
      };
    }, V2.prototype.render = function(n2) {
      this.u = null, this.o = /* @__PURE__ */ new Map();
      var t5 = x(n2.children);
      n2.revealOrder && "b" === n2.revealOrder[0] && t5.reverse();
      for (var e5 = t5.length; e5--; )
        this.o.set(t5[e5], this.u = [1, 0, this.u]);
      return n2.children;
    }, V2.prototype.componentDidUpdate = V2.prototype.componentDidMount = function() {
      var n2 = this;
      this.o.forEach(function(t5, e5) {
        W(n2, e5, t5);
      });
    };
    z3 = "undefined" != typeof Symbol && Symbol.for && Symbol.for("react.element") || 60103;
    B3 = /^(?:accent|alignment|arabic|baseline|cap|clip(?!PathU)|color|dominant|fill|flood|font|glyph(?!R)|horiz|image|letter|lighting|marker(?!H|W|U)|overline|paint|pointer|shape|stop|strikethrough|stroke|text(?!L)|transform|underline|unicode|units|v|vector|vert|word|writing|x(?!C))[A-Z]/;
    H2 = "undefined" != typeof document;
    Z2 = function(n2) {
      return ("undefined" != typeof Symbol && "symbol" == typeof Symbol() ? /fil|che|rad/i : /fil|che|ra/i).test(n2);
    };
    d.prototype.isReactComponent = {}, ["componentWillMount", "componentWillReceiveProps", "componentWillUpdate"].forEach(function(t5) {
      Object.defineProperty(d.prototype, t5, { configurable: true, get: function() {
        return this["UNSAFE_" + t5];
      }, set: function(n2) {
        Object.defineProperty(this, t5, { configurable: true, writable: true, value: n2 });
      } });
    });
    G = l.event;
    l.event = function(n2) {
      return G && (n2 = G(n2)), n2.persist = J, n2.isPropagationStopped = K3, n2.isDefaultPrevented = Q, n2.nativeEvent = n2;
    };
    nn = { configurable: true, get: function() {
      return this.class;
    } };
    tn = l.vnode;
    l.vnode = function(n2) {
      var t5 = n2.type, e5 = n2.props, u5 = e5;
      if ("string" == typeof t5) {
        var o3 = -1 === t5.indexOf("-");
        for (var i5 in u5 = {}, e5) {
          var l3 = e5[i5];
          H2 && "children" === i5 && "noscript" === t5 || "value" === i5 && "defaultValue" in e5 && null == l3 || ("defaultValue" === i5 && "value" in e5 && null == e5.value ? i5 = "value" : "download" === i5 && true === l3 ? l3 = "" : /ondoubleclick/i.test(i5) ? i5 = "ondblclick" : /^onchange(textarea|input)/i.test(i5 + t5) && !Z2(e5.type) ? i5 = "oninput" : /^onfocus$/i.test(i5) ? i5 = "onfocusin" : /^onblur$/i.test(i5) ? i5 = "onfocusout" : /^on(Ani|Tra|Tou|BeforeInp|Compo)/.test(i5) ? i5 = i5.toLowerCase() : o3 && B3.test(i5) ? i5 = i5.replace(/[A-Z0-9]/g, "-$&").toLowerCase() : null === l3 && (l3 = void 0), /^oninput$/i.test(i5) && (i5 = i5.toLowerCase(), u5[i5] && (i5 = "oninputCapture")), u5[i5] = l3);
        }
        "select" == t5 && u5.multiple && Array.isArray(u5.value) && (u5.value = x(e5.children).forEach(function(n3) {
          n3.props.selected = -1 != u5.value.indexOf(n3.props.value);
        })), "select" == t5 && null != u5.defaultValue && (u5.value = x(e5.children).forEach(function(n3) {
          n3.props.selected = u5.multiple ? -1 != u5.defaultValue.indexOf(n3.props.value) : u5.defaultValue == n3.props.value;
        })), n2.props = u5, e5.class != e5.className && (nn.enumerable = "className" in e5, null != e5.className && (u5.class = e5.className), Object.defineProperty(u5, "className", nn));
      }
      n2.$$typeof = z3, tn && tn(n2);
    };
    en = l.__r;
    l.__r = function(n2) {
      en && en(n2), X2 = n2.__c;
    };
    rn = { ReactCurrentDispatcher: { current: { readContext: function(n2) {
      return X2.__n[n2.__c].props.value;
    } } } };
    un = "17.0.2";
    sn = function(n2, t5) {
      return n2(t5);
    };
    hn = function(n2, t5) {
      return n2(t5);
    };
    vn2 = p2;
    yn = s2;
    bn = { useState: p3, useId: V, useReducer: y2, useEffect: h2, useLayoutEffect: s2, useInsertionEffect: yn, useTransition: mn, useDeferredValue: pn, useSyncExternalStore: _n, startTransition: dn, useRef: _2, useImperativeHandle: A3, useMemo: F, useCallback: T2, useContext: q2, useDebugValue: x2, version: "17.0.2", Children: O2, render: Y2, hydrate: q3, unmountComponentAtNode: fn, createPortal: j3, createElement: h, createContext: B, createFactory: on, cloneElement: cn, createRef: y, Fragment: p2, isValidElement: ln, findDOMNode: an, Component: d, PureComponent: w3, memo: R, forwardRef: k3, flushSync: hn, unstable_batchedUpdates: sn, StrictMode: vn2, Suspense: D3, SuspenseList: V2, lazy: M3, __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: rn };
  }
});

// ../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/cjs/use-sync-external-store-shim.production.min.js
var require_use_sync_external_store_shim_production_min = __commonJS({
  "../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/cjs/use-sync-external-store-shim.production.min.js"(exports) {
    "use strict";
    var e5 = (init_compat_module(), __toCommonJS(compat_module_exports));
    function h5(a6, b5) {
      return a6 === b5 && (0 !== a6 || 1 / a6 === 1 / b5) || a6 !== a6 && b5 !== b5;
    }
    var k6 = "function" === typeof Object.is ? Object.is : h5;
    var l3 = e5.useState;
    var m6 = e5.useEffect;
    var n2 = e5.useLayoutEffect;
    var p4 = e5.useDebugValue;
    function q6(a6, b5) {
      var d6 = b5(), f3 = l3({ inst: { value: d6, getSnapshot: b5 } }), c5 = f3[0].inst, g4 = f3[1];
      n2(function() {
        c5.value = d6;
        c5.getSnapshot = b5;
        r3(c5) && g4({ inst: c5 });
      }, [a6, d6, b5]);
      m6(function() {
        r3(c5) && g4({ inst: c5 });
        return a6(function() {
          r3(c5) && g4({ inst: c5 });
        });
      }, [a6]);
      p4(d6);
      return d6;
    }
    function r3(a6) {
      var b5 = a6.getSnapshot;
      a6 = a6.value;
      try {
        var d6 = b5();
        return !k6(a6, d6);
      } catch (f3) {
        return true;
      }
    }
    function t5(a6, b5) {
      return b5();
    }
    var u5 = "undefined" === typeof window || "undefined" === typeof window.document || "undefined" === typeof window.document.createElement ? t5 : q6;
    exports.useSyncExternalStore = void 0 !== e5.useSyncExternalStore ? e5.useSyncExternalStore : u5;
  }
});

// ../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/shim/index.js
var require_shim = __commonJS({
  "../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/shim/index.js"(exports, module) {
    "use strict";
    if (true) {
      module.exports = require_use_sync_external_store_shim_production_min();
    } else {
      module.exports = null;
    }
  }
});

// ../../node_modules/.pnpm/qrcode-generator@1.4.4/node_modules/qrcode-generator/qrcode.js
var require_qrcode = __commonJS({
  "../../node_modules/.pnpm/qrcode-generator@1.4.4/node_modules/qrcode-generator/qrcode.js"(exports, module) {
    var qrcode2 = function() {
      var qrcode3 = function(typeNumber, errorCorrectionLevel) {
        var PAD0 = 236;
        var PAD1 = 17;
        var _typeNumber = typeNumber;
        var _errorCorrectionLevel = QRErrorCorrectionLevel[errorCorrectionLevel];
        var _modules = null;
        var _moduleCount = 0;
        var _dataCache = null;
        var _dataList = [];
        var _this = {};
        var makeImpl = function(test, maskPattern) {
          _moduleCount = _typeNumber * 4 + 17;
          _modules = function(moduleCount) {
            var modules = new Array(moduleCount);
            for (var row = 0; row < moduleCount; row += 1) {
              modules[row] = new Array(moduleCount);
              for (var col = 0; col < moduleCount; col += 1) {
                modules[row][col] = null;
              }
            }
            return modules;
          }(_moduleCount);
          setupPositionProbePattern(0, 0);
          setupPositionProbePattern(_moduleCount - 7, 0);
          setupPositionProbePattern(0, _moduleCount - 7);
          setupPositionAdjustPattern();
          setupTimingPattern();
          setupTypeInfo(test, maskPattern);
          if (_typeNumber >= 7) {
            setupTypeNumber(test);
          }
          if (_dataCache == null) {
            _dataCache = createData(_typeNumber, _errorCorrectionLevel, _dataList);
          }
          mapData(_dataCache, maskPattern);
        };
        var setupPositionProbePattern = function(row, col) {
          for (var r3 = -1; r3 <= 7; r3 += 1) {
            if (row + r3 <= -1 || _moduleCount <= row + r3)
              continue;
            for (var c5 = -1; c5 <= 7; c5 += 1) {
              if (col + c5 <= -1 || _moduleCount <= col + c5)
                continue;
              if (0 <= r3 && r3 <= 6 && (c5 == 0 || c5 == 6) || 0 <= c5 && c5 <= 6 && (r3 == 0 || r3 == 6) || 2 <= r3 && r3 <= 4 && 2 <= c5 && c5 <= 4) {
                _modules[row + r3][col + c5] = true;
              } else {
                _modules[row + r3][col + c5] = false;
              }
            }
          }
        };
        var getBestMaskPattern = function() {
          var minLostPoint = 0;
          var pattern = 0;
          for (var i5 = 0; i5 < 8; i5 += 1) {
            makeImpl(true, i5);
            var lostPoint = QRUtil.getLostPoint(_this);
            if (i5 == 0 || minLostPoint > lostPoint) {
              minLostPoint = lostPoint;
              pattern = i5;
            }
          }
          return pattern;
        };
        var setupTimingPattern = function() {
          for (var r3 = 8; r3 < _moduleCount - 8; r3 += 1) {
            if (_modules[r3][6] != null) {
              continue;
            }
            _modules[r3][6] = r3 % 2 == 0;
          }
          for (var c5 = 8; c5 < _moduleCount - 8; c5 += 1) {
            if (_modules[6][c5] != null) {
              continue;
            }
            _modules[6][c5] = c5 % 2 == 0;
          }
        };
        var setupPositionAdjustPattern = function() {
          var pos = QRUtil.getPatternPosition(_typeNumber);
          for (var i5 = 0; i5 < pos.length; i5 += 1) {
            for (var j4 = 0; j4 < pos.length; j4 += 1) {
              var row = pos[i5];
              var col = pos[j4];
              if (_modules[row][col] != null) {
                continue;
              }
              for (var r3 = -2; r3 <= 2; r3 += 1) {
                for (var c5 = -2; c5 <= 2; c5 += 1) {
                  if (r3 == -2 || r3 == 2 || c5 == -2 || c5 == 2 || r3 == 0 && c5 == 0) {
                    _modules[row + r3][col + c5] = true;
                  } else {
                    _modules[row + r3][col + c5] = false;
                  }
                }
              }
            }
          }
        };
        var setupTypeNumber = function(test) {
          var bits = QRUtil.getBCHTypeNumber(_typeNumber);
          for (var i5 = 0; i5 < 18; i5 += 1) {
            var mod = !test && (bits >> i5 & 1) == 1;
            _modules[Math.floor(i5 / 3)][i5 % 3 + _moduleCount - 8 - 3] = mod;
          }
          for (var i5 = 0; i5 < 18; i5 += 1) {
            var mod = !test && (bits >> i5 & 1) == 1;
            _modules[i5 % 3 + _moduleCount - 8 - 3][Math.floor(i5 / 3)] = mod;
          }
        };
        var setupTypeInfo = function(test, maskPattern) {
          var data = _errorCorrectionLevel << 3 | maskPattern;
          var bits = QRUtil.getBCHTypeInfo(data);
          for (var i5 = 0; i5 < 15; i5 += 1) {
            var mod = !test && (bits >> i5 & 1) == 1;
            if (i5 < 6) {
              _modules[i5][8] = mod;
            } else if (i5 < 8) {
              _modules[i5 + 1][8] = mod;
            } else {
              _modules[_moduleCount - 15 + i5][8] = mod;
            }
          }
          for (var i5 = 0; i5 < 15; i5 += 1) {
            var mod = !test && (bits >> i5 & 1) == 1;
            if (i5 < 8) {
              _modules[8][_moduleCount - i5 - 1] = mod;
            } else if (i5 < 9) {
              _modules[8][15 - i5 - 1 + 1] = mod;
            } else {
              _modules[8][15 - i5 - 1] = mod;
            }
          }
          _modules[_moduleCount - 8][8] = !test;
        };
        var mapData = function(data, maskPattern) {
          var inc = -1;
          var row = _moduleCount - 1;
          var bitIndex = 7;
          var byteIndex = 0;
          var maskFunc = QRUtil.getMaskFunction(maskPattern);
          for (var col = _moduleCount - 1; col > 0; col -= 2) {
            if (col == 6)
              col -= 1;
            while (true) {
              for (var c5 = 0; c5 < 2; c5 += 1) {
                if (_modules[row][col - c5] == null) {
                  var dark = false;
                  if (byteIndex < data.length) {
                    dark = (data[byteIndex] >>> bitIndex & 1) == 1;
                  }
                  var mask = maskFunc(row, col - c5);
                  if (mask) {
                    dark = !dark;
                  }
                  _modules[row][col - c5] = dark;
                  bitIndex -= 1;
                  if (bitIndex == -1) {
                    byteIndex += 1;
                    bitIndex = 7;
                  }
                }
              }
              row += inc;
              if (row < 0 || _moduleCount <= row) {
                row -= inc;
                inc = -inc;
                break;
              }
            }
          }
        };
        var createBytes = function(buffer, rsBlocks) {
          var offset = 0;
          var maxDcCount = 0;
          var maxEcCount = 0;
          var dcdata = new Array(rsBlocks.length);
          var ecdata = new Array(rsBlocks.length);
          for (var r3 = 0; r3 < rsBlocks.length; r3 += 1) {
            var dcCount = rsBlocks[r3].dataCount;
            var ecCount = rsBlocks[r3].totalCount - dcCount;
            maxDcCount = Math.max(maxDcCount, dcCount);
            maxEcCount = Math.max(maxEcCount, ecCount);
            dcdata[r3] = new Array(dcCount);
            for (var i5 = 0; i5 < dcdata[r3].length; i5 += 1) {
              dcdata[r3][i5] = 255 & buffer.getBuffer()[i5 + offset];
            }
            offset += dcCount;
            var rsPoly = QRUtil.getErrorCorrectPolynomial(ecCount);
            var rawPoly = qrPolynomial(dcdata[r3], rsPoly.getLength() - 1);
            var modPoly = rawPoly.mod(rsPoly);
            ecdata[r3] = new Array(rsPoly.getLength() - 1);
            for (var i5 = 0; i5 < ecdata[r3].length; i5 += 1) {
              var modIndex = i5 + modPoly.getLength() - ecdata[r3].length;
              ecdata[r3][i5] = modIndex >= 0 ? modPoly.getAt(modIndex) : 0;
            }
          }
          var totalCodeCount = 0;
          for (var i5 = 0; i5 < rsBlocks.length; i5 += 1) {
            totalCodeCount += rsBlocks[i5].totalCount;
          }
          var data = new Array(totalCodeCount);
          var index = 0;
          for (var i5 = 0; i5 < maxDcCount; i5 += 1) {
            for (var r3 = 0; r3 < rsBlocks.length; r3 += 1) {
              if (i5 < dcdata[r3].length) {
                data[index] = dcdata[r3][i5];
                index += 1;
              }
            }
          }
          for (var i5 = 0; i5 < maxEcCount; i5 += 1) {
            for (var r3 = 0; r3 < rsBlocks.length; r3 += 1) {
              if (i5 < ecdata[r3].length) {
                data[index] = ecdata[r3][i5];
                index += 1;
              }
            }
          }
          return data;
        };
        var createData = function(typeNumber2, errorCorrectionLevel2, dataList) {
          var rsBlocks = QRRSBlock.getRSBlocks(typeNumber2, errorCorrectionLevel2);
          var buffer = qrBitBuffer();
          for (var i5 = 0; i5 < dataList.length; i5 += 1) {
            var data = dataList[i5];
            buffer.put(data.getMode(), 4);
            buffer.put(data.getLength(), QRUtil.getLengthInBits(data.getMode(), typeNumber2));
            data.write(buffer);
          }
          var totalDataCount = 0;
          for (var i5 = 0; i5 < rsBlocks.length; i5 += 1) {
            totalDataCount += rsBlocks[i5].dataCount;
          }
          if (buffer.getLengthInBits() > totalDataCount * 8) {
            throw "code length overflow. (" + buffer.getLengthInBits() + ">" + totalDataCount * 8 + ")";
          }
          if (buffer.getLengthInBits() + 4 <= totalDataCount * 8) {
            buffer.put(0, 4);
          }
          while (buffer.getLengthInBits() % 8 != 0) {
            buffer.putBit(false);
          }
          while (true) {
            if (buffer.getLengthInBits() >= totalDataCount * 8) {
              break;
            }
            buffer.put(PAD0, 8);
            if (buffer.getLengthInBits() >= totalDataCount * 8) {
              break;
            }
            buffer.put(PAD1, 8);
          }
          return createBytes(buffer, rsBlocks);
        };
        _this.addData = function(data, mode) {
          mode = mode || "Byte";
          var newData = null;
          switch (mode) {
            case "Numeric":
              newData = qrNumber(data);
              break;
            case "Alphanumeric":
              newData = qrAlphaNum(data);
              break;
            case "Byte":
              newData = qr8BitByte(data);
              break;
            case "Kanji":
              newData = qrKanji(data);
              break;
            default:
              throw "mode:" + mode;
          }
          _dataList.push(newData);
          _dataCache = null;
        };
        _this.isDark = function(row, col) {
          if (row < 0 || _moduleCount <= row || col < 0 || _moduleCount <= col) {
            throw row + "," + col;
          }
          return _modules[row][col];
        };
        _this.getModuleCount = function() {
          return _moduleCount;
        };
        _this.make = function() {
          if (_typeNumber < 1) {
            var typeNumber2 = 1;
            for (; typeNumber2 < 40; typeNumber2++) {
              var rsBlocks = QRRSBlock.getRSBlocks(typeNumber2, _errorCorrectionLevel);
              var buffer = qrBitBuffer();
              for (var i5 = 0; i5 < _dataList.length; i5++) {
                var data = _dataList[i5];
                buffer.put(data.getMode(), 4);
                buffer.put(data.getLength(), QRUtil.getLengthInBits(data.getMode(), typeNumber2));
                data.write(buffer);
              }
              var totalDataCount = 0;
              for (var i5 = 0; i5 < rsBlocks.length; i5++) {
                totalDataCount += rsBlocks[i5].dataCount;
              }
              if (buffer.getLengthInBits() <= totalDataCount * 8) {
                break;
              }
            }
            _typeNumber = typeNumber2;
          }
          makeImpl(false, getBestMaskPattern());
        };
        _this.createTableTag = function(cellSize, margin) {
          cellSize = cellSize || 2;
          margin = typeof margin == "undefined" ? cellSize * 4 : margin;
          var qrHtml = "";
          qrHtml += '<table style="';
          qrHtml += " border-width: 0px; border-style: none;";
          qrHtml += " border-collapse: collapse;";
          qrHtml += " padding: 0px; margin: " + margin + "px;";
          qrHtml += '">';
          qrHtml += "<tbody>";
          for (var r3 = 0; r3 < _this.getModuleCount(); r3 += 1) {
            qrHtml += "<tr>";
            for (var c5 = 0; c5 < _this.getModuleCount(); c5 += 1) {
              qrHtml += '<td style="';
              qrHtml += " border-width: 0px; border-style: none;";
              qrHtml += " border-collapse: collapse;";
              qrHtml += " padding: 0px; margin: 0px;";
              qrHtml += " width: " + cellSize + "px;";
              qrHtml += " height: " + cellSize + "px;";
              qrHtml += " background-color: ";
              qrHtml += _this.isDark(r3, c5) ? "#000000" : "#ffffff";
              qrHtml += ";";
              qrHtml += '"/>';
            }
            qrHtml += "</tr>";
          }
          qrHtml += "</tbody>";
          qrHtml += "</table>";
          return qrHtml;
        };
        _this.createSvgTag = function(cellSize, margin, alt, title) {
          var opts = {};
          if (typeof arguments[0] == "object") {
            opts = arguments[0];
            cellSize = opts.cellSize;
            margin = opts.margin;
            alt = opts.alt;
            title = opts.title;
          }
          cellSize = cellSize || 2;
          margin = typeof margin == "undefined" ? cellSize * 4 : margin;
          alt = typeof alt === "string" ? { text: alt } : alt || {};
          alt.text = alt.text || null;
          alt.id = alt.text ? alt.id || "qrcode-description" : null;
          title = typeof title === "string" ? { text: title } : title || {};
          title.text = title.text || null;
          title.id = title.text ? title.id || "qrcode-title" : null;
          var size = _this.getModuleCount() * cellSize + margin * 2;
          var c5, mc, r3, mr, qrSvg = "", rect;
          rect = "l" + cellSize + ",0 0," + cellSize + " -" + cellSize + ",0 0,-" + cellSize + "z ";
          qrSvg += '<svg version="1.1" xmlns="http://www.w3.org/2000/svg"';
          qrSvg += !opts.scalable ? ' width="' + size + 'px" height="' + size + 'px"' : "";
          qrSvg += ' viewBox="0 0 ' + size + " " + size + '" ';
          qrSvg += ' preserveAspectRatio="xMinYMin meet"';
          qrSvg += title.text || alt.text ? ' role="img" aria-labelledby="' + escapeXml([title.id, alt.id].join(" ").trim()) + '"' : "";
          qrSvg += ">";
          qrSvg += title.text ? '<title id="' + escapeXml(title.id) + '">' + escapeXml(title.text) + "</title>" : "";
          qrSvg += alt.text ? '<description id="' + escapeXml(alt.id) + '">' + escapeXml(alt.text) + "</description>" : "";
          qrSvg += '<rect width="100%" height="100%" fill="white" cx="0" cy="0"/>';
          qrSvg += '<path d="';
          for (r3 = 0; r3 < _this.getModuleCount(); r3 += 1) {
            mr = r3 * cellSize + margin;
            for (c5 = 0; c5 < _this.getModuleCount(); c5 += 1) {
              if (_this.isDark(r3, c5)) {
                mc = c5 * cellSize + margin;
                qrSvg += "M" + mc + "," + mr + rect;
              }
            }
          }
          qrSvg += '" stroke="transparent" fill="black"/>';
          qrSvg += "</svg>";
          return qrSvg;
        };
        _this.createDataURL = function(cellSize, margin) {
          cellSize = cellSize || 2;
          margin = typeof margin == "undefined" ? cellSize * 4 : margin;
          var size = _this.getModuleCount() * cellSize + margin * 2;
          var min = margin;
          var max = size - margin;
          return createDataURL(size, size, function(x6, y6) {
            if (min <= x6 && x6 < max && min <= y6 && y6 < max) {
              var c5 = Math.floor((x6 - min) / cellSize);
              var r3 = Math.floor((y6 - min) / cellSize);
              return _this.isDark(r3, c5) ? 0 : 1;
            } else {
              return 1;
            }
          });
        };
        _this.createImgTag = function(cellSize, margin, alt) {
          cellSize = cellSize || 2;
          margin = typeof margin == "undefined" ? cellSize * 4 : margin;
          var size = _this.getModuleCount() * cellSize + margin * 2;
          var img = "";
          img += "<img";
          img += ' src="';
          img += _this.createDataURL(cellSize, margin);
          img += '"';
          img += ' width="';
          img += size;
          img += '"';
          img += ' height="';
          img += size;
          img += '"';
          if (alt) {
            img += ' alt="';
            img += escapeXml(alt);
            img += '"';
          }
          img += "/>";
          return img;
        };
        var escapeXml = function(s6) {
          var escaped = "";
          for (var i5 = 0; i5 < s6.length; i5 += 1) {
            var c5 = s6.charAt(i5);
            switch (c5) {
              case "<":
                escaped += "&lt;";
                break;
              case ">":
                escaped += "&gt;";
                break;
              case "&":
                escaped += "&amp;";
                break;
              case '"':
                escaped += "&quot;";
                break;
              default:
                escaped += c5;
                break;
            }
          }
          return escaped;
        };
        var _createHalfASCII = function(margin) {
          var cellSize = 1;
          margin = typeof margin == "undefined" ? cellSize * 2 : margin;
          var size = _this.getModuleCount() * cellSize + margin * 2;
          var min = margin;
          var max = size - margin;
          var y6, x6, r1, r22, p4;
          var blocks = {
            "\u2588\u2588": "\u2588",
            "\u2588 ": "\u2580",
            " \u2588": "\u2584",
            "  ": " "
          };
          var blocksLastLineNoMargin = {
            "\u2588\u2588": "\u2580",
            "\u2588 ": "\u2580",
            " \u2588": " ",
            "  ": " "
          };
          var ascii = "";
          for (y6 = 0; y6 < size; y6 += 2) {
            r1 = Math.floor((y6 - min) / cellSize);
            r22 = Math.floor((y6 + 1 - min) / cellSize);
            for (x6 = 0; x6 < size; x6 += 1) {
              p4 = "\u2588";
              if (min <= x6 && x6 < max && min <= y6 && y6 < max && _this.isDark(r1, Math.floor((x6 - min) / cellSize))) {
                p4 = " ";
              }
              if (min <= x6 && x6 < max && min <= y6 + 1 && y6 + 1 < max && _this.isDark(r22, Math.floor((x6 - min) / cellSize))) {
                p4 += " ";
              } else {
                p4 += "\u2588";
              }
              ascii += margin < 1 && y6 + 1 >= max ? blocksLastLineNoMargin[p4] : blocks[p4];
            }
            ascii += "\n";
          }
          if (size % 2 && margin > 0) {
            return ascii.substring(0, ascii.length - size - 1) + Array(size + 1).join("\u2580");
          }
          return ascii.substring(0, ascii.length - 1);
        };
        _this.createASCII = function(cellSize, margin) {
          cellSize = cellSize || 1;
          if (cellSize < 2) {
            return _createHalfASCII(margin);
          }
          cellSize -= 1;
          margin = typeof margin == "undefined" ? cellSize * 2 : margin;
          var size = _this.getModuleCount() * cellSize + margin * 2;
          var min = margin;
          var max = size - margin;
          var y6, x6, r3, p4;
          var white = Array(cellSize + 1).join("\u2588\u2588");
          var black = Array(cellSize + 1).join("  ");
          var ascii = "";
          var line = "";
          for (y6 = 0; y6 < size; y6 += 1) {
            r3 = Math.floor((y6 - min) / cellSize);
            line = "";
            for (x6 = 0; x6 < size; x6 += 1) {
              p4 = 1;
              if (min <= x6 && x6 < max && min <= y6 && y6 < max && _this.isDark(r3, Math.floor((x6 - min) / cellSize))) {
                p4 = 0;
              }
              line += p4 ? white : black;
            }
            for (r3 = 0; r3 < cellSize; r3 += 1) {
              ascii += line + "\n";
            }
          }
          return ascii.substring(0, ascii.length - 1);
        };
        _this.renderTo2dContext = function(context, cellSize) {
          cellSize = cellSize || 2;
          var length = _this.getModuleCount();
          for (var row = 0; row < length; row++) {
            for (var col = 0; col < length; col++) {
              context.fillStyle = _this.isDark(row, col) ? "black" : "white";
              context.fillRect(row * cellSize, col * cellSize, cellSize, cellSize);
            }
          }
        };
        return _this;
      };
      qrcode3.stringToBytesFuncs = {
        "default": function(s6) {
          var bytes = [];
          for (var i5 = 0; i5 < s6.length; i5 += 1) {
            var c5 = s6.charCodeAt(i5);
            bytes.push(c5 & 255);
          }
          return bytes;
        }
      };
      qrcode3.stringToBytes = qrcode3.stringToBytesFuncs["default"];
      qrcode3.createStringToBytes = function(unicodeData, numChars) {
        var unicodeMap = function() {
          var bin = base64DecodeInputStream(unicodeData);
          var read = function() {
            var b5 = bin.read();
            if (b5 == -1)
              throw "eof";
            return b5;
          };
          var count = 0;
          var unicodeMap2 = {};
          while (true) {
            var b0 = bin.read();
            if (b0 == -1)
              break;
            var b1 = read();
            var b22 = read();
            var b32 = read();
            var k6 = String.fromCharCode(b0 << 8 | b1);
            var v3 = b22 << 8 | b32;
            unicodeMap2[k6] = v3;
            count += 1;
          }
          if (count != numChars) {
            throw count + " != " + numChars;
          }
          return unicodeMap2;
        }();
        var unknownChar = "?".charCodeAt(0);
        return function(s6) {
          var bytes = [];
          for (var i5 = 0; i5 < s6.length; i5 += 1) {
            var c5 = s6.charCodeAt(i5);
            if (c5 < 128) {
              bytes.push(c5);
            } else {
              var b5 = unicodeMap[s6.charAt(i5)];
              if (typeof b5 == "number") {
                if ((b5 & 255) == b5) {
                  bytes.push(b5);
                } else {
                  bytes.push(b5 >>> 8);
                  bytes.push(b5 & 255);
                }
              } else {
                bytes.push(unknownChar);
              }
            }
          }
          return bytes;
        };
      };
      var QRMode = {
        MODE_NUMBER: 1 << 0,
        MODE_ALPHA_NUM: 1 << 1,
        MODE_8BIT_BYTE: 1 << 2,
        MODE_KANJI: 1 << 3
      };
      var QRErrorCorrectionLevel = {
        L: 1,
        M: 0,
        Q: 3,
        H: 2
      };
      var QRMaskPattern = {
        PATTERN000: 0,
        PATTERN001: 1,
        PATTERN010: 2,
        PATTERN011: 3,
        PATTERN100: 4,
        PATTERN101: 5,
        PATTERN110: 6,
        PATTERN111: 7
      };
      var QRUtil = function() {
        var PATTERN_POSITION_TABLE = [
          [],
          [6, 18],
          [6, 22],
          [6, 26],
          [6, 30],
          [6, 34],
          [6, 22, 38],
          [6, 24, 42],
          [6, 26, 46],
          [6, 28, 50],
          [6, 30, 54],
          [6, 32, 58],
          [6, 34, 62],
          [6, 26, 46, 66],
          [6, 26, 48, 70],
          [6, 26, 50, 74],
          [6, 30, 54, 78],
          [6, 30, 56, 82],
          [6, 30, 58, 86],
          [6, 34, 62, 90],
          [6, 28, 50, 72, 94],
          [6, 26, 50, 74, 98],
          [6, 30, 54, 78, 102],
          [6, 28, 54, 80, 106],
          [6, 32, 58, 84, 110],
          [6, 30, 58, 86, 114],
          [6, 34, 62, 90, 118],
          [6, 26, 50, 74, 98, 122],
          [6, 30, 54, 78, 102, 126],
          [6, 26, 52, 78, 104, 130],
          [6, 30, 56, 82, 108, 134],
          [6, 34, 60, 86, 112, 138],
          [6, 30, 58, 86, 114, 142],
          [6, 34, 62, 90, 118, 146],
          [6, 30, 54, 78, 102, 126, 150],
          [6, 24, 50, 76, 102, 128, 154],
          [6, 28, 54, 80, 106, 132, 158],
          [6, 32, 58, 84, 110, 136, 162],
          [6, 26, 54, 82, 110, 138, 166],
          [6, 30, 58, 86, 114, 142, 170]
        ];
        var G15 = 1 << 10 | 1 << 8 | 1 << 5 | 1 << 4 | 1 << 2 | 1 << 1 | 1 << 0;
        var G18 = 1 << 12 | 1 << 11 | 1 << 10 | 1 << 9 | 1 << 8 | 1 << 5 | 1 << 2 | 1 << 0;
        var G15_MASK = 1 << 14 | 1 << 12 | 1 << 10 | 1 << 4 | 1 << 1;
        var _this = {};
        var getBCHDigit = function(data) {
          var digit = 0;
          while (data != 0) {
            digit += 1;
            data >>>= 1;
          }
          return digit;
        };
        _this.getBCHTypeInfo = function(data) {
          var d6 = data << 10;
          while (getBCHDigit(d6) - getBCHDigit(G15) >= 0) {
            d6 ^= G15 << getBCHDigit(d6) - getBCHDigit(G15);
          }
          return (data << 10 | d6) ^ G15_MASK;
        };
        _this.getBCHTypeNumber = function(data) {
          var d6 = data << 12;
          while (getBCHDigit(d6) - getBCHDigit(G18) >= 0) {
            d6 ^= G18 << getBCHDigit(d6) - getBCHDigit(G18);
          }
          return data << 12 | d6;
        };
        _this.getPatternPosition = function(typeNumber) {
          return PATTERN_POSITION_TABLE[typeNumber - 1];
        };
        _this.getMaskFunction = function(maskPattern) {
          switch (maskPattern) {
            case QRMaskPattern.PATTERN000:
              return function(i5, j4) {
                return (i5 + j4) % 2 == 0;
              };
            case QRMaskPattern.PATTERN001:
              return function(i5, j4) {
                return i5 % 2 == 0;
              };
            case QRMaskPattern.PATTERN010:
              return function(i5, j4) {
                return j4 % 3 == 0;
              };
            case QRMaskPattern.PATTERN011:
              return function(i5, j4) {
                return (i5 + j4) % 3 == 0;
              };
            case QRMaskPattern.PATTERN100:
              return function(i5, j4) {
                return (Math.floor(i5 / 2) + Math.floor(j4 / 3)) % 2 == 0;
              };
            case QRMaskPattern.PATTERN101:
              return function(i5, j4) {
                return i5 * j4 % 2 + i5 * j4 % 3 == 0;
              };
            case QRMaskPattern.PATTERN110:
              return function(i5, j4) {
                return (i5 * j4 % 2 + i5 * j4 % 3) % 2 == 0;
              };
            case QRMaskPattern.PATTERN111:
              return function(i5, j4) {
                return (i5 * j4 % 3 + (i5 + j4) % 2) % 2 == 0;
              };
            default:
              throw "bad maskPattern:" + maskPattern;
          }
        };
        _this.getErrorCorrectPolynomial = function(errorCorrectLength) {
          var a6 = qrPolynomial([1], 0);
          for (var i5 = 0; i5 < errorCorrectLength; i5 += 1) {
            a6 = a6.multiply(qrPolynomial([1, QRMath.gexp(i5)], 0));
          }
          return a6;
        };
        _this.getLengthInBits = function(mode, type) {
          if (1 <= type && type < 10) {
            switch (mode) {
              case QRMode.MODE_NUMBER:
                return 10;
              case QRMode.MODE_ALPHA_NUM:
                return 9;
              case QRMode.MODE_8BIT_BYTE:
                return 8;
              case QRMode.MODE_KANJI:
                return 8;
              default:
                throw "mode:" + mode;
            }
          } else if (type < 27) {
            switch (mode) {
              case QRMode.MODE_NUMBER:
                return 12;
              case QRMode.MODE_ALPHA_NUM:
                return 11;
              case QRMode.MODE_8BIT_BYTE:
                return 16;
              case QRMode.MODE_KANJI:
                return 10;
              default:
                throw "mode:" + mode;
            }
          } else if (type < 41) {
            switch (mode) {
              case QRMode.MODE_NUMBER:
                return 14;
              case QRMode.MODE_ALPHA_NUM:
                return 13;
              case QRMode.MODE_8BIT_BYTE:
                return 16;
              case QRMode.MODE_KANJI:
                return 12;
              default:
                throw "mode:" + mode;
            }
          } else {
            throw "type:" + type;
          }
        };
        _this.getLostPoint = function(qrcode4) {
          var moduleCount = qrcode4.getModuleCount();
          var lostPoint = 0;
          for (var row = 0; row < moduleCount; row += 1) {
            for (var col = 0; col < moduleCount; col += 1) {
              var sameCount = 0;
              var dark = qrcode4.isDark(row, col);
              for (var r3 = -1; r3 <= 1; r3 += 1) {
                if (row + r3 < 0 || moduleCount <= row + r3) {
                  continue;
                }
                for (var c5 = -1; c5 <= 1; c5 += 1) {
                  if (col + c5 < 0 || moduleCount <= col + c5) {
                    continue;
                  }
                  if (r3 == 0 && c5 == 0) {
                    continue;
                  }
                  if (dark == qrcode4.isDark(row + r3, col + c5)) {
                    sameCount += 1;
                  }
                }
              }
              if (sameCount > 5) {
                lostPoint += 3 + sameCount - 5;
              }
            }
          }
          ;
          for (var row = 0; row < moduleCount - 1; row += 1) {
            for (var col = 0; col < moduleCount - 1; col += 1) {
              var count = 0;
              if (qrcode4.isDark(row, col))
                count += 1;
              if (qrcode4.isDark(row + 1, col))
                count += 1;
              if (qrcode4.isDark(row, col + 1))
                count += 1;
              if (qrcode4.isDark(row + 1, col + 1))
                count += 1;
              if (count == 0 || count == 4) {
                lostPoint += 3;
              }
            }
          }
          for (var row = 0; row < moduleCount; row += 1) {
            for (var col = 0; col < moduleCount - 6; col += 1) {
              if (qrcode4.isDark(row, col) && !qrcode4.isDark(row, col + 1) && qrcode4.isDark(row, col + 2) && qrcode4.isDark(row, col + 3) && qrcode4.isDark(row, col + 4) && !qrcode4.isDark(row, col + 5) && qrcode4.isDark(row, col + 6)) {
                lostPoint += 40;
              }
            }
          }
          for (var col = 0; col < moduleCount; col += 1) {
            for (var row = 0; row < moduleCount - 6; row += 1) {
              if (qrcode4.isDark(row, col) && !qrcode4.isDark(row + 1, col) && qrcode4.isDark(row + 2, col) && qrcode4.isDark(row + 3, col) && qrcode4.isDark(row + 4, col) && !qrcode4.isDark(row + 5, col) && qrcode4.isDark(row + 6, col)) {
                lostPoint += 40;
              }
            }
          }
          var darkCount = 0;
          for (var col = 0; col < moduleCount; col += 1) {
            for (var row = 0; row < moduleCount; row += 1) {
              if (qrcode4.isDark(row, col)) {
                darkCount += 1;
              }
            }
          }
          var ratio = Math.abs(100 * darkCount / moduleCount / moduleCount - 50) / 5;
          lostPoint += ratio * 10;
          return lostPoint;
        };
        return _this;
      }();
      var QRMath = function() {
        var EXP_TABLE = new Array(256);
        var LOG_TABLE = new Array(256);
        for (var i5 = 0; i5 < 8; i5 += 1) {
          EXP_TABLE[i5] = 1 << i5;
        }
        for (var i5 = 8; i5 < 256; i5 += 1) {
          EXP_TABLE[i5] = EXP_TABLE[i5 - 4] ^ EXP_TABLE[i5 - 5] ^ EXP_TABLE[i5 - 6] ^ EXP_TABLE[i5 - 8];
        }
        for (var i5 = 0; i5 < 255; i5 += 1) {
          LOG_TABLE[EXP_TABLE[i5]] = i5;
        }
        var _this = {};
        _this.glog = function(n2) {
          if (n2 < 1) {
            throw "glog(" + n2 + ")";
          }
          return LOG_TABLE[n2];
        };
        _this.gexp = function(n2) {
          while (n2 < 0) {
            n2 += 255;
          }
          while (n2 >= 256) {
            n2 -= 255;
          }
          return EXP_TABLE[n2];
        };
        return _this;
      }();
      function qrPolynomial(num, shift) {
        if (typeof num.length == "undefined") {
          throw num.length + "/" + shift;
        }
        var _num = function() {
          var offset = 0;
          while (offset < num.length && num[offset] == 0) {
            offset += 1;
          }
          var _num2 = new Array(num.length - offset + shift);
          for (var i5 = 0; i5 < num.length - offset; i5 += 1) {
            _num2[i5] = num[i5 + offset];
          }
          return _num2;
        }();
        var _this = {};
        _this.getAt = function(index) {
          return _num[index];
        };
        _this.getLength = function() {
          return _num.length;
        };
        _this.multiply = function(e5) {
          var num2 = new Array(_this.getLength() + e5.getLength() - 1);
          for (var i5 = 0; i5 < _this.getLength(); i5 += 1) {
            for (var j4 = 0; j4 < e5.getLength(); j4 += 1) {
              num2[i5 + j4] ^= QRMath.gexp(QRMath.glog(_this.getAt(i5)) + QRMath.glog(e5.getAt(j4)));
            }
          }
          return qrPolynomial(num2, 0);
        };
        _this.mod = function(e5) {
          if (_this.getLength() - e5.getLength() < 0) {
            return _this;
          }
          var ratio = QRMath.glog(_this.getAt(0)) - QRMath.glog(e5.getAt(0));
          var num2 = new Array(_this.getLength());
          for (var i5 = 0; i5 < _this.getLength(); i5 += 1) {
            num2[i5] = _this.getAt(i5);
          }
          for (var i5 = 0; i5 < e5.getLength(); i5 += 1) {
            num2[i5] ^= QRMath.gexp(QRMath.glog(e5.getAt(i5)) + ratio);
          }
          return qrPolynomial(num2, 0).mod(e5);
        };
        return _this;
      }
      ;
      var QRRSBlock = function() {
        var RS_BLOCK_TABLE = [
          // L
          // M
          // Q
          // H
          // 1
          [1, 26, 19],
          [1, 26, 16],
          [1, 26, 13],
          [1, 26, 9],
          // 2
          [1, 44, 34],
          [1, 44, 28],
          [1, 44, 22],
          [1, 44, 16],
          // 3
          [1, 70, 55],
          [1, 70, 44],
          [2, 35, 17],
          [2, 35, 13],
          // 4
          [1, 100, 80],
          [2, 50, 32],
          [2, 50, 24],
          [4, 25, 9],
          // 5
          [1, 134, 108],
          [2, 67, 43],
          [2, 33, 15, 2, 34, 16],
          [2, 33, 11, 2, 34, 12],
          // 6
          [2, 86, 68],
          [4, 43, 27],
          [4, 43, 19],
          [4, 43, 15],
          // 7
          [2, 98, 78],
          [4, 49, 31],
          [2, 32, 14, 4, 33, 15],
          [4, 39, 13, 1, 40, 14],
          // 8
          [2, 121, 97],
          [2, 60, 38, 2, 61, 39],
          [4, 40, 18, 2, 41, 19],
          [4, 40, 14, 2, 41, 15],
          // 9
          [2, 146, 116],
          [3, 58, 36, 2, 59, 37],
          [4, 36, 16, 4, 37, 17],
          [4, 36, 12, 4, 37, 13],
          // 10
          [2, 86, 68, 2, 87, 69],
          [4, 69, 43, 1, 70, 44],
          [6, 43, 19, 2, 44, 20],
          [6, 43, 15, 2, 44, 16],
          // 11
          [4, 101, 81],
          [1, 80, 50, 4, 81, 51],
          [4, 50, 22, 4, 51, 23],
          [3, 36, 12, 8, 37, 13],
          // 12
          [2, 116, 92, 2, 117, 93],
          [6, 58, 36, 2, 59, 37],
          [4, 46, 20, 6, 47, 21],
          [7, 42, 14, 4, 43, 15],
          // 13
          [4, 133, 107],
          [8, 59, 37, 1, 60, 38],
          [8, 44, 20, 4, 45, 21],
          [12, 33, 11, 4, 34, 12],
          // 14
          [3, 145, 115, 1, 146, 116],
          [4, 64, 40, 5, 65, 41],
          [11, 36, 16, 5, 37, 17],
          [11, 36, 12, 5, 37, 13],
          // 15
          [5, 109, 87, 1, 110, 88],
          [5, 65, 41, 5, 66, 42],
          [5, 54, 24, 7, 55, 25],
          [11, 36, 12, 7, 37, 13],
          // 16
          [5, 122, 98, 1, 123, 99],
          [7, 73, 45, 3, 74, 46],
          [15, 43, 19, 2, 44, 20],
          [3, 45, 15, 13, 46, 16],
          // 17
          [1, 135, 107, 5, 136, 108],
          [10, 74, 46, 1, 75, 47],
          [1, 50, 22, 15, 51, 23],
          [2, 42, 14, 17, 43, 15],
          // 18
          [5, 150, 120, 1, 151, 121],
          [9, 69, 43, 4, 70, 44],
          [17, 50, 22, 1, 51, 23],
          [2, 42, 14, 19, 43, 15],
          // 19
          [3, 141, 113, 4, 142, 114],
          [3, 70, 44, 11, 71, 45],
          [17, 47, 21, 4, 48, 22],
          [9, 39, 13, 16, 40, 14],
          // 20
          [3, 135, 107, 5, 136, 108],
          [3, 67, 41, 13, 68, 42],
          [15, 54, 24, 5, 55, 25],
          [15, 43, 15, 10, 44, 16],
          // 21
          [4, 144, 116, 4, 145, 117],
          [17, 68, 42],
          [17, 50, 22, 6, 51, 23],
          [19, 46, 16, 6, 47, 17],
          // 22
          [2, 139, 111, 7, 140, 112],
          [17, 74, 46],
          [7, 54, 24, 16, 55, 25],
          [34, 37, 13],
          // 23
          [4, 151, 121, 5, 152, 122],
          [4, 75, 47, 14, 76, 48],
          [11, 54, 24, 14, 55, 25],
          [16, 45, 15, 14, 46, 16],
          // 24
          [6, 147, 117, 4, 148, 118],
          [6, 73, 45, 14, 74, 46],
          [11, 54, 24, 16, 55, 25],
          [30, 46, 16, 2, 47, 17],
          // 25
          [8, 132, 106, 4, 133, 107],
          [8, 75, 47, 13, 76, 48],
          [7, 54, 24, 22, 55, 25],
          [22, 45, 15, 13, 46, 16],
          // 26
          [10, 142, 114, 2, 143, 115],
          [19, 74, 46, 4, 75, 47],
          [28, 50, 22, 6, 51, 23],
          [33, 46, 16, 4, 47, 17],
          // 27
          [8, 152, 122, 4, 153, 123],
          [22, 73, 45, 3, 74, 46],
          [8, 53, 23, 26, 54, 24],
          [12, 45, 15, 28, 46, 16],
          // 28
          [3, 147, 117, 10, 148, 118],
          [3, 73, 45, 23, 74, 46],
          [4, 54, 24, 31, 55, 25],
          [11, 45, 15, 31, 46, 16],
          // 29
          [7, 146, 116, 7, 147, 117],
          [21, 73, 45, 7, 74, 46],
          [1, 53, 23, 37, 54, 24],
          [19, 45, 15, 26, 46, 16],
          // 30
          [5, 145, 115, 10, 146, 116],
          [19, 75, 47, 10, 76, 48],
          [15, 54, 24, 25, 55, 25],
          [23, 45, 15, 25, 46, 16],
          // 31
          [13, 145, 115, 3, 146, 116],
          [2, 74, 46, 29, 75, 47],
          [42, 54, 24, 1, 55, 25],
          [23, 45, 15, 28, 46, 16],
          // 32
          [17, 145, 115],
          [10, 74, 46, 23, 75, 47],
          [10, 54, 24, 35, 55, 25],
          [19, 45, 15, 35, 46, 16],
          // 33
          [17, 145, 115, 1, 146, 116],
          [14, 74, 46, 21, 75, 47],
          [29, 54, 24, 19, 55, 25],
          [11, 45, 15, 46, 46, 16],
          // 34
          [13, 145, 115, 6, 146, 116],
          [14, 74, 46, 23, 75, 47],
          [44, 54, 24, 7, 55, 25],
          [59, 46, 16, 1, 47, 17],
          // 35
          [12, 151, 121, 7, 152, 122],
          [12, 75, 47, 26, 76, 48],
          [39, 54, 24, 14, 55, 25],
          [22, 45, 15, 41, 46, 16],
          // 36
          [6, 151, 121, 14, 152, 122],
          [6, 75, 47, 34, 76, 48],
          [46, 54, 24, 10, 55, 25],
          [2, 45, 15, 64, 46, 16],
          // 37
          [17, 152, 122, 4, 153, 123],
          [29, 74, 46, 14, 75, 47],
          [49, 54, 24, 10, 55, 25],
          [24, 45, 15, 46, 46, 16],
          // 38
          [4, 152, 122, 18, 153, 123],
          [13, 74, 46, 32, 75, 47],
          [48, 54, 24, 14, 55, 25],
          [42, 45, 15, 32, 46, 16],
          // 39
          [20, 147, 117, 4, 148, 118],
          [40, 75, 47, 7, 76, 48],
          [43, 54, 24, 22, 55, 25],
          [10, 45, 15, 67, 46, 16],
          // 40
          [19, 148, 118, 6, 149, 119],
          [18, 75, 47, 31, 76, 48],
          [34, 54, 24, 34, 55, 25],
          [20, 45, 15, 61, 46, 16]
        ];
        var qrRSBlock = function(totalCount, dataCount) {
          var _this2 = {};
          _this2.totalCount = totalCount;
          _this2.dataCount = dataCount;
          return _this2;
        };
        var _this = {};
        var getRsBlockTable = function(typeNumber, errorCorrectionLevel) {
          switch (errorCorrectionLevel) {
            case QRErrorCorrectionLevel.L:
              return RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 0];
            case QRErrorCorrectionLevel.M:
              return RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 1];
            case QRErrorCorrectionLevel.Q:
              return RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 2];
            case QRErrorCorrectionLevel.H:
              return RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 3];
            default:
              return void 0;
          }
        };
        _this.getRSBlocks = function(typeNumber, errorCorrectionLevel) {
          var rsBlock = getRsBlockTable(typeNumber, errorCorrectionLevel);
          if (typeof rsBlock == "undefined") {
            throw "bad rs block @ typeNumber:" + typeNumber + "/errorCorrectionLevel:" + errorCorrectionLevel;
          }
          var length = rsBlock.length / 3;
          var list = [];
          for (var i5 = 0; i5 < length; i5 += 1) {
            var count = rsBlock[i5 * 3 + 0];
            var totalCount = rsBlock[i5 * 3 + 1];
            var dataCount = rsBlock[i5 * 3 + 2];
            for (var j4 = 0; j4 < count; j4 += 1) {
              list.push(qrRSBlock(totalCount, dataCount));
            }
          }
          return list;
        };
        return _this;
      }();
      var qrBitBuffer = function() {
        var _buffer = [];
        var _length = 0;
        var _this = {};
        _this.getBuffer = function() {
          return _buffer;
        };
        _this.getAt = function(index) {
          var bufIndex = Math.floor(index / 8);
          return (_buffer[bufIndex] >>> 7 - index % 8 & 1) == 1;
        };
        _this.put = function(num, length) {
          for (var i5 = 0; i5 < length; i5 += 1) {
            _this.putBit((num >>> length - i5 - 1 & 1) == 1);
          }
        };
        _this.getLengthInBits = function() {
          return _length;
        };
        _this.putBit = function(bit) {
          var bufIndex = Math.floor(_length / 8);
          if (_buffer.length <= bufIndex) {
            _buffer.push(0);
          }
          if (bit) {
            _buffer[bufIndex] |= 128 >>> _length % 8;
          }
          _length += 1;
        };
        return _this;
      };
      var qrNumber = function(data) {
        var _mode = QRMode.MODE_NUMBER;
        var _data = data;
        var _this = {};
        _this.getMode = function() {
          return _mode;
        };
        _this.getLength = function(buffer) {
          return _data.length;
        };
        _this.write = function(buffer) {
          var data2 = _data;
          var i5 = 0;
          while (i5 + 2 < data2.length) {
            buffer.put(strToNum(data2.substring(i5, i5 + 3)), 10);
            i5 += 3;
          }
          if (i5 < data2.length) {
            if (data2.length - i5 == 1) {
              buffer.put(strToNum(data2.substring(i5, i5 + 1)), 4);
            } else if (data2.length - i5 == 2) {
              buffer.put(strToNum(data2.substring(i5, i5 + 2)), 7);
            }
          }
        };
        var strToNum = function(s6) {
          var num = 0;
          for (var i5 = 0; i5 < s6.length; i5 += 1) {
            num = num * 10 + chatToNum(s6.charAt(i5));
          }
          return num;
        };
        var chatToNum = function(c5) {
          if ("0" <= c5 && c5 <= "9") {
            return c5.charCodeAt(0) - "0".charCodeAt(0);
          }
          throw "illegal char :" + c5;
        };
        return _this;
      };
      var qrAlphaNum = function(data) {
        var _mode = QRMode.MODE_ALPHA_NUM;
        var _data = data;
        var _this = {};
        _this.getMode = function() {
          return _mode;
        };
        _this.getLength = function(buffer) {
          return _data.length;
        };
        _this.write = function(buffer) {
          var s6 = _data;
          var i5 = 0;
          while (i5 + 1 < s6.length) {
            buffer.put(
              getCode(s6.charAt(i5)) * 45 + getCode(s6.charAt(i5 + 1)),
              11
            );
            i5 += 2;
          }
          if (i5 < s6.length) {
            buffer.put(getCode(s6.charAt(i5)), 6);
          }
        };
        var getCode = function(c5) {
          if ("0" <= c5 && c5 <= "9") {
            return c5.charCodeAt(0) - "0".charCodeAt(0);
          } else if ("A" <= c5 && c5 <= "Z") {
            return c5.charCodeAt(0) - "A".charCodeAt(0) + 10;
          } else {
            switch (c5) {
              case " ":
                return 36;
              case "$":
                return 37;
              case "%":
                return 38;
              case "*":
                return 39;
              case "+":
                return 40;
              case "-":
                return 41;
              case ".":
                return 42;
              case "/":
                return 43;
              case ":":
                return 44;
              default:
                throw "illegal char :" + c5;
            }
          }
        };
        return _this;
      };
      var qr8BitByte = function(data) {
        var _mode = QRMode.MODE_8BIT_BYTE;
        var _data = data;
        var _bytes = qrcode3.stringToBytes(data);
        var _this = {};
        _this.getMode = function() {
          return _mode;
        };
        _this.getLength = function(buffer) {
          return _bytes.length;
        };
        _this.write = function(buffer) {
          for (var i5 = 0; i5 < _bytes.length; i5 += 1) {
            buffer.put(_bytes[i5], 8);
          }
        };
        return _this;
      };
      var qrKanji = function(data) {
        var _mode = QRMode.MODE_KANJI;
        var _data = data;
        var stringToBytes2 = qrcode3.stringToBytesFuncs["SJIS"];
        if (!stringToBytes2) {
          throw "sjis not supported.";
        }
        !function(c5, code) {
          var test = stringToBytes2(c5);
          if (test.length != 2 || (test[0] << 8 | test[1]) != code) {
            throw "sjis not supported.";
          }
        }("\u53CB", 38726);
        var _bytes = stringToBytes2(data);
        var _this = {};
        _this.getMode = function() {
          return _mode;
        };
        _this.getLength = function(buffer) {
          return ~~(_bytes.length / 2);
        };
        _this.write = function(buffer) {
          var data2 = _bytes;
          var i5 = 0;
          while (i5 + 1 < data2.length) {
            var c5 = (255 & data2[i5]) << 8 | 255 & data2[i5 + 1];
            if (33088 <= c5 && c5 <= 40956) {
              c5 -= 33088;
            } else if (57408 <= c5 && c5 <= 60351) {
              c5 -= 49472;
            } else {
              throw "illegal char at " + (i5 + 1) + "/" + c5;
            }
            c5 = (c5 >>> 8 & 255) * 192 + (c5 & 255);
            buffer.put(c5, 13);
            i5 += 2;
          }
          if (i5 < data2.length) {
            throw "illegal char at " + (i5 + 1);
          }
        };
        return _this;
      };
      var byteArrayOutputStream = function() {
        var _bytes = [];
        var _this = {};
        _this.writeByte = function(b5) {
          _bytes.push(b5 & 255);
        };
        _this.writeShort = function(i5) {
          _this.writeByte(i5);
          _this.writeByte(i5 >>> 8);
        };
        _this.writeBytes = function(b5, off, len) {
          off = off || 0;
          len = len || b5.length;
          for (var i5 = 0; i5 < len; i5 += 1) {
            _this.writeByte(b5[i5 + off]);
          }
        };
        _this.writeString = function(s6) {
          for (var i5 = 0; i5 < s6.length; i5 += 1) {
            _this.writeByte(s6.charCodeAt(i5));
          }
        };
        _this.toByteArray = function() {
          return _bytes;
        };
        _this.toString = function() {
          var s6 = "";
          s6 += "[";
          for (var i5 = 0; i5 < _bytes.length; i5 += 1) {
            if (i5 > 0) {
              s6 += ",";
            }
            s6 += _bytes[i5];
          }
          s6 += "]";
          return s6;
        };
        return _this;
      };
      var base64EncodeOutputStream = function() {
        var _buffer = 0;
        var _buflen = 0;
        var _length = 0;
        var _base64 = "";
        var _this = {};
        var writeEncoded = function(b5) {
          _base64 += String.fromCharCode(encode2(b5 & 63));
        };
        var encode2 = function(n2) {
          if (n2 < 0) {
          } else if (n2 < 26) {
            return 65 + n2;
          } else if (n2 < 52) {
            return 97 + (n2 - 26);
          } else if (n2 < 62) {
            return 48 + (n2 - 52);
          } else if (n2 == 62) {
            return 43;
          } else if (n2 == 63) {
            return 47;
          }
          throw "n:" + n2;
        };
        _this.writeByte = function(n2) {
          _buffer = _buffer << 8 | n2 & 255;
          _buflen += 8;
          _length += 1;
          while (_buflen >= 6) {
            writeEncoded(_buffer >>> _buflen - 6);
            _buflen -= 6;
          }
        };
        _this.flush = function() {
          if (_buflen > 0) {
            writeEncoded(_buffer << 6 - _buflen);
            _buffer = 0;
            _buflen = 0;
          }
          if (_length % 3 != 0) {
            var padlen = 3 - _length % 3;
            for (var i5 = 0; i5 < padlen; i5 += 1) {
              _base64 += "=";
            }
          }
        };
        _this.toString = function() {
          return _base64;
        };
        return _this;
      };
      var base64DecodeInputStream = function(str) {
        var _str = str;
        var _pos = 0;
        var _buffer = 0;
        var _buflen = 0;
        var _this = {};
        _this.read = function() {
          while (_buflen < 8) {
            if (_pos >= _str.length) {
              if (_buflen == 0) {
                return -1;
              }
              throw "unexpected end of file./" + _buflen;
            }
            var c5 = _str.charAt(_pos);
            _pos += 1;
            if (c5 == "=") {
              _buflen = 0;
              return -1;
            } else if (c5.match(/^\s$/)) {
              continue;
            }
            _buffer = _buffer << 6 | decode2(c5.charCodeAt(0));
            _buflen += 6;
          }
          var n2 = _buffer >>> _buflen - 8 & 255;
          _buflen -= 8;
          return n2;
        };
        var decode2 = function(c5) {
          if (65 <= c5 && c5 <= 90) {
            return c5 - 65;
          } else if (97 <= c5 && c5 <= 122) {
            return c5 - 97 + 26;
          } else if (48 <= c5 && c5 <= 57) {
            return c5 - 48 + 52;
          } else if (c5 == 43) {
            return 62;
          } else if (c5 == 47) {
            return 63;
          } else {
            throw "c:" + c5;
          }
        };
        return _this;
      };
      var gifImage = function(width, height) {
        var _width = width;
        var _height = height;
        var _data = new Array(width * height);
        var _this = {};
        _this.setPixel = function(x6, y6, pixel) {
          _data[y6 * _width + x6] = pixel;
        };
        _this.write = function(out) {
          out.writeString("GIF87a");
          out.writeShort(_width);
          out.writeShort(_height);
          out.writeByte(128);
          out.writeByte(0);
          out.writeByte(0);
          out.writeByte(0);
          out.writeByte(0);
          out.writeByte(0);
          out.writeByte(255);
          out.writeByte(255);
          out.writeByte(255);
          out.writeString(",");
          out.writeShort(0);
          out.writeShort(0);
          out.writeShort(_width);
          out.writeShort(_height);
          out.writeByte(0);
          var lzwMinCodeSize = 2;
          var raster = getLZWRaster(lzwMinCodeSize);
          out.writeByte(lzwMinCodeSize);
          var offset = 0;
          while (raster.length - offset > 255) {
            out.writeByte(255);
            out.writeBytes(raster, offset, 255);
            offset += 255;
          }
          out.writeByte(raster.length - offset);
          out.writeBytes(raster, offset, raster.length - offset);
          out.writeByte(0);
          out.writeString(";");
        };
        var bitOutputStream = function(out) {
          var _out = out;
          var _bitLength = 0;
          var _bitBuffer = 0;
          var _this2 = {};
          _this2.write = function(data, length) {
            if (data >>> length != 0) {
              throw "length over";
            }
            while (_bitLength + length >= 8) {
              _out.writeByte(255 & (data << _bitLength | _bitBuffer));
              length -= 8 - _bitLength;
              data >>>= 8 - _bitLength;
              _bitBuffer = 0;
              _bitLength = 0;
            }
            _bitBuffer = data << _bitLength | _bitBuffer;
            _bitLength = _bitLength + length;
          };
          _this2.flush = function() {
            if (_bitLength > 0) {
              _out.writeByte(_bitBuffer);
            }
          };
          return _this2;
        };
        var getLZWRaster = function(lzwMinCodeSize) {
          var clearCode = 1 << lzwMinCodeSize;
          var endCode = (1 << lzwMinCodeSize) + 1;
          var bitLength = lzwMinCodeSize + 1;
          var table2 = lzwTable();
          for (var i5 = 0; i5 < clearCode; i5 += 1) {
            table2.add(String.fromCharCode(i5));
          }
          table2.add(String.fromCharCode(clearCode));
          table2.add(String.fromCharCode(endCode));
          var byteOut = byteArrayOutputStream();
          var bitOut = bitOutputStream(byteOut);
          bitOut.write(clearCode, bitLength);
          var dataIndex = 0;
          var s6 = String.fromCharCode(_data[dataIndex]);
          dataIndex += 1;
          while (dataIndex < _data.length) {
            var c5 = String.fromCharCode(_data[dataIndex]);
            dataIndex += 1;
            if (table2.contains(s6 + c5)) {
              s6 = s6 + c5;
            } else {
              bitOut.write(table2.indexOf(s6), bitLength);
              if (table2.size() < 4095) {
                if (table2.size() == 1 << bitLength) {
                  bitLength += 1;
                }
                table2.add(s6 + c5);
              }
              s6 = c5;
            }
          }
          bitOut.write(table2.indexOf(s6), bitLength);
          bitOut.write(endCode, bitLength);
          bitOut.flush();
          return byteOut.toByteArray();
        };
        var lzwTable = function() {
          var _map = {};
          var _size = 0;
          var _this2 = {};
          _this2.add = function(key) {
            if (_this2.contains(key)) {
              throw "dup key:" + key;
            }
            _map[key] = _size;
            _size += 1;
          };
          _this2.size = function() {
            return _size;
          };
          _this2.indexOf = function(key) {
            return _map[key];
          };
          _this2.contains = function(key) {
            return typeof _map[key] != "undefined";
          };
          return _this2;
        };
        return _this;
      };
      var createDataURL = function(width, height, getPixel) {
        var gif = gifImage(width, height);
        for (var y6 = 0; y6 < height; y6 += 1) {
          for (var x6 = 0; x6 < width; x6 += 1) {
            gif.setPixel(x6, y6, getPixel(x6, y6));
          }
        }
        var b5 = byteArrayOutputStream();
        gif.write(b5);
        var base64 = base64EncodeOutputStream();
        var bytes = b5.toByteArray();
        for (var i5 = 0; i5 < bytes.length; i5 += 1) {
          base64.writeByte(bytes[i5]);
        }
        base64.flush();
        return "data:image/gif;base64," + base64;
      };
      return qrcode3;
    }();
    !function() {
      qrcode2.stringToBytesFuncs["UTF-8"] = function(s6) {
        function toUTF8Array(str) {
          var utf8 = [];
          for (var i5 = 0; i5 < str.length; i5++) {
            var charcode = str.charCodeAt(i5);
            if (charcode < 128)
              utf8.push(charcode);
            else if (charcode < 2048) {
              utf8.push(
                192 | charcode >> 6,
                128 | charcode & 63
              );
            } else if (charcode < 55296 || charcode >= 57344) {
              utf8.push(
                224 | charcode >> 12,
                128 | charcode >> 6 & 63,
                128 | charcode & 63
              );
            } else {
              i5++;
              charcode = 65536 + ((charcode & 1023) << 10 | str.charCodeAt(i5) & 1023);
              utf8.push(
                240 | charcode >> 18,
                128 | charcode >> 12 & 63,
                128 | charcode >> 6 & 63,
                128 | charcode & 63
              );
            }
          }
          return utf8;
        }
        return toUTF8Array(s6);
      };
    }();
    (function(factory) {
      if (typeof define === "function" && define.amd) {
        define([], factory);
      } else if (typeof exports === "object") {
        module.exports = factory();
      }
    })(function() {
      return qrcode2;
    });
  }
});

// ../taler-util/lib/nacl-fast.js
var gf = function(init = []) {
  const r3 = new Float64Array(16);
  if (init)
    for (let i5 = 0; i5 < init.length; i5++)
      r3[i5] = init[i5];
  return r3;
};
var randombytes = function(x6, n2) {
  throw new Error("no PRNG");
};
var _9 = new Uint8Array(32);
_9[0] = 9;
var gf0 = gf();
var gf1 = gf([1]);
var _121665 = gf([56129, 1]);
var D = gf([
  30883,
  4953,
  19914,
  30187,
  55467,
  16705,
  2637,
  112,
  59544,
  30585,
  16505,
  36039,
  65139,
  11119,
  27886,
  20995
]);
var D2 = gf([
  61785,
  9906,
  39828,
  60374,
  45398,
  33411,
  5274,
  224,
  53552,
  61171,
  33010,
  6542,
  64743,
  22239,
  55772,
  9222
]);
var X = gf([
  54554,
  36645,
  11616,
  51542,
  42930,
  38181,
  51040,
  26924,
  56412,
  64982,
  57905,
  49316,
  21502,
  52590,
  14035,
  8553
]);
var Y = gf([
  26200,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214
]);
var I = gf([
  41136,
  18958,
  6951,
  50414,
  58488,
  44335,
  6150,
  12099,
  55207,
  15867,
  153,
  11085,
  57099,
  20417,
  9344,
  11139
]);
function ts64(x6, i5, h5, l3) {
  x6[i5] = h5 >> 24 & 255;
  x6[i5 + 1] = h5 >> 16 & 255;
  x6[i5 + 2] = h5 >> 8 & 255;
  x6[i5 + 3] = h5 & 255;
  x6[i5 + 4] = l3 >> 24 & 255;
  x6[i5 + 5] = l3 >> 16 & 255;
  x6[i5 + 6] = l3 >> 8 & 255;
  x6[i5 + 7] = l3 & 255;
}
function vn(x6, xi, y6, yi, n2) {
  let i5, d6 = 0;
  for (i5 = 0; i5 < n2; i5++)
    d6 |= x6[xi + i5] ^ y6[yi + i5];
  return (1 & d6 - 1 >>> 8) - 1;
}
function crypto_verify_32(x6, xi, y6, yi) {
  return vn(x6, xi, y6, yi, 32);
}
var sigma = new Uint8Array([
  101,
  120,
  112,
  97,
  110,
  100,
  32,
  51,
  50,
  45,
  98,
  121,
  116,
  101,
  32,
  107
]);
function set25519(r3, a6) {
  let i5;
  for (i5 = 0; i5 < 16; i5++)
    r3[i5] = a6[i5] | 0;
}
function car25519(o3) {
  let i5, v3, c5 = 1;
  for (i5 = 0; i5 < 16; i5++) {
    v3 = o3[i5] + c5 + 65535;
    c5 = Math.floor(v3 / 65536);
    o3[i5] = v3 - c5 * 65536;
  }
  o3[0] += c5 - 1 + 37 * (c5 - 1);
}
function sel25519(p4, q6, b5) {
  let t5;
  const c5 = ~(b5 - 1);
  for (let i5 = 0; i5 < 16; i5++) {
    t5 = c5 & (p4[i5] ^ q6[i5]);
    p4[i5] ^= t5;
    q6[i5] ^= t5;
  }
}
function pack25519(o3, n2) {
  let i5, j4, b5;
  const m6 = gf(), t5 = gf();
  for (i5 = 0; i5 < 16; i5++)
    t5[i5] = n2[i5];
  car25519(t5);
  car25519(t5);
  car25519(t5);
  for (j4 = 0; j4 < 2; j4++) {
    m6[0] = t5[0] - 65517;
    for (i5 = 1; i5 < 15; i5++) {
      m6[i5] = t5[i5] - 65535 - (m6[i5 - 1] >> 16 & 1);
      m6[i5 - 1] &= 65535;
    }
    m6[15] = t5[15] - 32767 - (m6[14] >> 16 & 1);
    b5 = m6[15] >> 16 & 1;
    m6[14] &= 65535;
    sel25519(t5, m6, 1 - b5);
  }
  for (i5 = 0; i5 < 16; i5++) {
    o3[2 * i5] = t5[i5] & 255;
    o3[2 * i5 + 1] = t5[i5] >> 8;
  }
}
function neq25519(a6, b5) {
  const c5 = new Uint8Array(32), d6 = new Uint8Array(32);
  pack25519(c5, a6);
  pack25519(d6, b5);
  return crypto_verify_32(c5, 0, d6, 0);
}
function par25519(a6) {
  const d6 = new Uint8Array(32);
  pack25519(d6, a6);
  return d6[0] & 1;
}
function unpack25519(o3, n2) {
  let i5;
  for (i5 = 0; i5 < 16; i5++)
    o3[i5] = n2[2 * i5] + (n2[2 * i5 + 1] << 8);
  o3[15] &= 32767;
}
function A(o3, a6, b5) {
  for (let i5 = 0; i5 < 16; i5++)
    o3[i5] = a6[i5] + b5[i5];
}
function Z(o3, a6, b5) {
  for (let i5 = 0; i5 < 16; i5++)
    o3[i5] = a6[i5] - b5[i5];
}
function M(o3, a6, b5) {
  let v3, c5, t0 = 0, t1 = 0, t22 = 0, t32 = 0, t42 = 0, t5 = 0, t6 = 0, t7 = 0, t8 = 0, t9 = 0, t10 = 0, t11 = 0, t12 = 0, t13 = 0, t14 = 0, t15 = 0, t16 = 0, t17 = 0, t18 = 0, t19 = 0, t20 = 0, t21 = 0, t222 = 0, t23 = 0, t24 = 0, t25 = 0, t26 = 0, t27 = 0, t28 = 0, t29 = 0, t30 = 0;
  const b0 = b5[0], b1 = b5[1], b22 = b5[2], b32 = b5[3], b42 = b5[4], b52 = b5[5], b6 = b5[6], b7 = b5[7], b8 = b5[8], b9 = b5[9], b10 = b5[10], b11 = b5[11], b12 = b5[12], b13 = b5[13], b14 = b5[14], b15 = b5[15];
  v3 = a6[0];
  t0 += v3 * b0;
  t1 += v3 * b1;
  t22 += v3 * b22;
  t32 += v3 * b32;
  t42 += v3 * b42;
  t5 += v3 * b52;
  t6 += v3 * b6;
  t7 += v3 * b7;
  t8 += v3 * b8;
  t9 += v3 * b9;
  t10 += v3 * b10;
  t11 += v3 * b11;
  t12 += v3 * b12;
  t13 += v3 * b13;
  t14 += v3 * b14;
  t15 += v3 * b15;
  v3 = a6[1];
  t1 += v3 * b0;
  t22 += v3 * b1;
  t32 += v3 * b22;
  t42 += v3 * b32;
  t5 += v3 * b42;
  t6 += v3 * b52;
  t7 += v3 * b6;
  t8 += v3 * b7;
  t9 += v3 * b8;
  t10 += v3 * b9;
  t11 += v3 * b10;
  t12 += v3 * b11;
  t13 += v3 * b12;
  t14 += v3 * b13;
  t15 += v3 * b14;
  t16 += v3 * b15;
  v3 = a6[2];
  t22 += v3 * b0;
  t32 += v3 * b1;
  t42 += v3 * b22;
  t5 += v3 * b32;
  t6 += v3 * b42;
  t7 += v3 * b52;
  t8 += v3 * b6;
  t9 += v3 * b7;
  t10 += v3 * b8;
  t11 += v3 * b9;
  t12 += v3 * b10;
  t13 += v3 * b11;
  t14 += v3 * b12;
  t15 += v3 * b13;
  t16 += v3 * b14;
  t17 += v3 * b15;
  v3 = a6[3];
  t32 += v3 * b0;
  t42 += v3 * b1;
  t5 += v3 * b22;
  t6 += v3 * b32;
  t7 += v3 * b42;
  t8 += v3 * b52;
  t9 += v3 * b6;
  t10 += v3 * b7;
  t11 += v3 * b8;
  t12 += v3 * b9;
  t13 += v3 * b10;
  t14 += v3 * b11;
  t15 += v3 * b12;
  t16 += v3 * b13;
  t17 += v3 * b14;
  t18 += v3 * b15;
  v3 = a6[4];
  t42 += v3 * b0;
  t5 += v3 * b1;
  t6 += v3 * b22;
  t7 += v3 * b32;
  t8 += v3 * b42;
  t9 += v3 * b52;
  t10 += v3 * b6;
  t11 += v3 * b7;
  t12 += v3 * b8;
  t13 += v3 * b9;
  t14 += v3 * b10;
  t15 += v3 * b11;
  t16 += v3 * b12;
  t17 += v3 * b13;
  t18 += v3 * b14;
  t19 += v3 * b15;
  v3 = a6[5];
  t5 += v3 * b0;
  t6 += v3 * b1;
  t7 += v3 * b22;
  t8 += v3 * b32;
  t9 += v3 * b42;
  t10 += v3 * b52;
  t11 += v3 * b6;
  t12 += v3 * b7;
  t13 += v3 * b8;
  t14 += v3 * b9;
  t15 += v3 * b10;
  t16 += v3 * b11;
  t17 += v3 * b12;
  t18 += v3 * b13;
  t19 += v3 * b14;
  t20 += v3 * b15;
  v3 = a6[6];
  t6 += v3 * b0;
  t7 += v3 * b1;
  t8 += v3 * b22;
  t9 += v3 * b32;
  t10 += v3 * b42;
  t11 += v3 * b52;
  t12 += v3 * b6;
  t13 += v3 * b7;
  t14 += v3 * b8;
  t15 += v3 * b9;
  t16 += v3 * b10;
  t17 += v3 * b11;
  t18 += v3 * b12;
  t19 += v3 * b13;
  t20 += v3 * b14;
  t21 += v3 * b15;
  v3 = a6[7];
  t7 += v3 * b0;
  t8 += v3 * b1;
  t9 += v3 * b22;
  t10 += v3 * b32;
  t11 += v3 * b42;
  t12 += v3 * b52;
  t13 += v3 * b6;
  t14 += v3 * b7;
  t15 += v3 * b8;
  t16 += v3 * b9;
  t17 += v3 * b10;
  t18 += v3 * b11;
  t19 += v3 * b12;
  t20 += v3 * b13;
  t21 += v3 * b14;
  t222 += v3 * b15;
  v3 = a6[8];
  t8 += v3 * b0;
  t9 += v3 * b1;
  t10 += v3 * b22;
  t11 += v3 * b32;
  t12 += v3 * b42;
  t13 += v3 * b52;
  t14 += v3 * b6;
  t15 += v3 * b7;
  t16 += v3 * b8;
  t17 += v3 * b9;
  t18 += v3 * b10;
  t19 += v3 * b11;
  t20 += v3 * b12;
  t21 += v3 * b13;
  t222 += v3 * b14;
  t23 += v3 * b15;
  v3 = a6[9];
  t9 += v3 * b0;
  t10 += v3 * b1;
  t11 += v3 * b22;
  t12 += v3 * b32;
  t13 += v3 * b42;
  t14 += v3 * b52;
  t15 += v3 * b6;
  t16 += v3 * b7;
  t17 += v3 * b8;
  t18 += v3 * b9;
  t19 += v3 * b10;
  t20 += v3 * b11;
  t21 += v3 * b12;
  t222 += v3 * b13;
  t23 += v3 * b14;
  t24 += v3 * b15;
  v3 = a6[10];
  t10 += v3 * b0;
  t11 += v3 * b1;
  t12 += v3 * b22;
  t13 += v3 * b32;
  t14 += v3 * b42;
  t15 += v3 * b52;
  t16 += v3 * b6;
  t17 += v3 * b7;
  t18 += v3 * b8;
  t19 += v3 * b9;
  t20 += v3 * b10;
  t21 += v3 * b11;
  t222 += v3 * b12;
  t23 += v3 * b13;
  t24 += v3 * b14;
  t25 += v3 * b15;
  v3 = a6[11];
  t11 += v3 * b0;
  t12 += v3 * b1;
  t13 += v3 * b22;
  t14 += v3 * b32;
  t15 += v3 * b42;
  t16 += v3 * b52;
  t17 += v3 * b6;
  t18 += v3 * b7;
  t19 += v3 * b8;
  t20 += v3 * b9;
  t21 += v3 * b10;
  t222 += v3 * b11;
  t23 += v3 * b12;
  t24 += v3 * b13;
  t25 += v3 * b14;
  t26 += v3 * b15;
  v3 = a6[12];
  t12 += v3 * b0;
  t13 += v3 * b1;
  t14 += v3 * b22;
  t15 += v3 * b32;
  t16 += v3 * b42;
  t17 += v3 * b52;
  t18 += v3 * b6;
  t19 += v3 * b7;
  t20 += v3 * b8;
  t21 += v3 * b9;
  t222 += v3 * b10;
  t23 += v3 * b11;
  t24 += v3 * b12;
  t25 += v3 * b13;
  t26 += v3 * b14;
  t27 += v3 * b15;
  v3 = a6[13];
  t13 += v3 * b0;
  t14 += v3 * b1;
  t15 += v3 * b22;
  t16 += v3 * b32;
  t17 += v3 * b42;
  t18 += v3 * b52;
  t19 += v3 * b6;
  t20 += v3 * b7;
  t21 += v3 * b8;
  t222 += v3 * b9;
  t23 += v3 * b10;
  t24 += v3 * b11;
  t25 += v3 * b12;
  t26 += v3 * b13;
  t27 += v3 * b14;
  t28 += v3 * b15;
  v3 = a6[14];
  t14 += v3 * b0;
  t15 += v3 * b1;
  t16 += v3 * b22;
  t17 += v3 * b32;
  t18 += v3 * b42;
  t19 += v3 * b52;
  t20 += v3 * b6;
  t21 += v3 * b7;
  t222 += v3 * b8;
  t23 += v3 * b9;
  t24 += v3 * b10;
  t25 += v3 * b11;
  t26 += v3 * b12;
  t27 += v3 * b13;
  t28 += v3 * b14;
  t29 += v3 * b15;
  v3 = a6[15];
  t15 += v3 * b0;
  t16 += v3 * b1;
  t17 += v3 * b22;
  t18 += v3 * b32;
  t19 += v3 * b42;
  t20 += v3 * b52;
  t21 += v3 * b6;
  t222 += v3 * b7;
  t23 += v3 * b8;
  t24 += v3 * b9;
  t25 += v3 * b10;
  t26 += v3 * b11;
  t27 += v3 * b12;
  t28 += v3 * b13;
  t29 += v3 * b14;
  t30 += v3 * b15;
  t0 += 38 * t16;
  t1 += 38 * t17;
  t22 += 38 * t18;
  t32 += 38 * t19;
  t42 += 38 * t20;
  t5 += 38 * t21;
  t6 += 38 * t222;
  t7 += 38 * t23;
  t8 += 38 * t24;
  t9 += 38 * t25;
  t10 += 38 * t26;
  t11 += 38 * t27;
  t12 += 38 * t28;
  t13 += 38 * t29;
  t14 += 38 * t30;
  c5 = 1;
  v3 = t0 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t0 = v3 - c5 * 65536;
  v3 = t1 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t1 = v3 - c5 * 65536;
  v3 = t22 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t22 = v3 - c5 * 65536;
  v3 = t32 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t32 = v3 - c5 * 65536;
  v3 = t42 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t42 = v3 - c5 * 65536;
  v3 = t5 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t5 = v3 - c5 * 65536;
  v3 = t6 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t6 = v3 - c5 * 65536;
  v3 = t7 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t7 = v3 - c5 * 65536;
  v3 = t8 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t8 = v3 - c5 * 65536;
  v3 = t9 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t9 = v3 - c5 * 65536;
  v3 = t10 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t10 = v3 - c5 * 65536;
  v3 = t11 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t11 = v3 - c5 * 65536;
  v3 = t12 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t12 = v3 - c5 * 65536;
  v3 = t13 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t13 = v3 - c5 * 65536;
  v3 = t14 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t14 = v3 - c5 * 65536;
  v3 = t15 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t15 = v3 - c5 * 65536;
  t0 += c5 - 1 + 37 * (c5 - 1);
  c5 = 1;
  v3 = t0 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t0 = v3 - c5 * 65536;
  v3 = t1 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t1 = v3 - c5 * 65536;
  v3 = t22 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t22 = v3 - c5 * 65536;
  v3 = t32 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t32 = v3 - c5 * 65536;
  v3 = t42 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t42 = v3 - c5 * 65536;
  v3 = t5 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t5 = v3 - c5 * 65536;
  v3 = t6 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t6 = v3 - c5 * 65536;
  v3 = t7 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t7 = v3 - c5 * 65536;
  v3 = t8 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t8 = v3 - c5 * 65536;
  v3 = t9 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t9 = v3 - c5 * 65536;
  v3 = t10 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t10 = v3 - c5 * 65536;
  v3 = t11 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t11 = v3 - c5 * 65536;
  v3 = t12 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t12 = v3 - c5 * 65536;
  v3 = t13 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t13 = v3 - c5 * 65536;
  v3 = t14 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t14 = v3 - c5 * 65536;
  v3 = t15 + c5 + 65535;
  c5 = Math.floor(v3 / 65536);
  t15 = v3 - c5 * 65536;
  t0 += c5 - 1 + 37 * (c5 - 1);
  o3[0] = t0;
  o3[1] = t1;
  o3[2] = t22;
  o3[3] = t32;
  o3[4] = t42;
  o3[5] = t5;
  o3[6] = t6;
  o3[7] = t7;
  o3[8] = t8;
  o3[9] = t9;
  o3[10] = t10;
  o3[11] = t11;
  o3[12] = t12;
  o3[13] = t13;
  o3[14] = t14;
  o3[15] = t15;
}
function S(o3, a6) {
  M(o3, a6, a6);
}
function inv25519(o3, i5) {
  const c5 = gf();
  let a6;
  for (a6 = 0; a6 < 16; a6++)
    c5[a6] = i5[a6];
  for (a6 = 253; a6 >= 0; a6--) {
    S(c5, c5);
    if (a6 !== 2 && a6 !== 4)
      M(c5, c5, i5);
  }
  for (a6 = 0; a6 < 16; a6++)
    o3[a6] = c5[a6];
}
function pow2523(o3, i5) {
  const c5 = gf();
  let a6;
  for (a6 = 0; a6 < 16; a6++)
    c5[a6] = i5[a6];
  for (a6 = 250; a6 >= 0; a6--) {
    S(c5, c5);
    if (a6 !== 1)
      M(c5, c5, i5);
  }
  for (a6 = 0; a6 < 16; a6++)
    o3[a6] = c5[a6];
}
var K = [
  1116352408,
  3609767458,
  1899447441,
  602891725,
  3049323471,
  3964484399,
  3921009573,
  2173295548,
  961987163,
  4081628472,
  1508970993,
  3053834265,
  2453635748,
  2937671579,
  2870763221,
  3664609560,
  3624381080,
  2734883394,
  310598401,
  1164996542,
  607225278,
  1323610764,
  1426881987,
  3590304994,
  1925078388,
  4068182383,
  2162078206,
  991336113,
  2614888103,
  633803317,
  3248222580,
  3479774868,
  3835390401,
  2666613458,
  4022224774,
  944711139,
  264347078,
  2341262773,
  604807628,
  2007800933,
  770255983,
  1495990901,
  1249150122,
  1856431235,
  1555081692,
  3175218132,
  1996064986,
  2198950837,
  2554220882,
  3999719339,
  2821834349,
  766784016,
  2952996808,
  2566594879,
  3210313671,
  3203337956,
  3336571891,
  1034457026,
  3584528711,
  2466948901,
  113926993,
  3758326383,
  338241895,
  168717936,
  666307205,
  1188179964,
  773529912,
  1546045734,
  1294757372,
  1522805485,
  1396182291,
  2643833823,
  1695183700,
  2343527390,
  1986661051,
  1014477480,
  2177026350,
  1206759142,
  2456956037,
  344077627,
  2730485921,
  1290863460,
  2820302411,
  3158454273,
  3259730800,
  3505952657,
  3345764771,
  106217008,
  3516065817,
  3606008344,
  3600352804,
  1432725776,
  4094571909,
  1467031594,
  275423344,
  851169720,
  430227734,
  3100823752,
  506948616,
  1363258195,
  659060556,
  3750685593,
  883997877,
  3785050280,
  958139571,
  3318307427,
  1322822218,
  3812723403,
  1537002063,
  2003034995,
  1747873779,
  3602036899,
  1955562222,
  1575990012,
  2024104815,
  1125592928,
  2227730452,
  2716904306,
  2361852424,
  442776044,
  2428436474,
  593698344,
  2756734187,
  3733110249,
  3204031479,
  2999351573,
  3329325298,
  3815920427,
  3391569614,
  3928383900,
  3515267271,
  566280711,
  3940187606,
  3454069534,
  4118630271,
  4000239992,
  116418474,
  1914138554,
  174292421,
  2731055270,
  289380356,
  3203993006,
  460393269,
  320620315,
  685471733,
  587496836,
  852142971,
  1086792851,
  1017036298,
  365543100,
  1126000580,
  2618297676,
  1288033470,
  3409855158,
  1501505948,
  4234509866,
  1607167915,
  987167468,
  1816402316,
  1246189591
];
function crypto_hashblocks_hl(hh, hl, m6, n2) {
  const wh = new Int32Array(16), wl = new Int32Array(16);
  let bh0, bh1, bh2, bh3, bh4, bh5, bh6, bh7, bl0, bl1, bl2, bl3, bl4, bl5, bl6, bl7, th, tl, i5, j4, h5, l3, a6, b5, c5, d6;
  let ah0 = hh[0], ah1 = hh[1], ah2 = hh[2], ah3 = hh[3], ah4 = hh[4], ah5 = hh[5], ah6 = hh[6], ah7 = hh[7], al0 = hl[0], al1 = hl[1], al2 = hl[2], al3 = hl[3], al4 = hl[4], al5 = hl[5], al6 = hl[6], al7 = hl[7];
  let pos = 0;
  while (n2 >= 128) {
    for (i5 = 0; i5 < 16; i5++) {
      j4 = 8 * i5 + pos;
      wh[i5] = m6[j4 + 0] << 24 | m6[j4 + 1] << 16 | m6[j4 + 2] << 8 | m6[j4 + 3];
      wl[i5] = m6[j4 + 4] << 24 | m6[j4 + 5] << 16 | m6[j4 + 6] << 8 | m6[j4 + 7];
    }
    for (i5 = 0; i5 < 80; i5++) {
      bh0 = ah0;
      bh1 = ah1;
      bh2 = ah2;
      bh3 = ah3;
      bh4 = ah4;
      bh5 = ah5;
      bh6 = ah6;
      bh7 = ah7;
      bl0 = al0;
      bl1 = al1;
      bl2 = al2;
      bl3 = al3;
      bl4 = al4;
      bl5 = al5;
      bl6 = al6;
      bl7 = al7;
      h5 = ah7;
      l3 = al7;
      a6 = l3 & 65535;
      b5 = l3 >>> 16;
      c5 = h5 & 65535;
      d6 = h5 >>> 16;
      h5 = (ah4 >>> 14 | al4 << 32 - 14) ^ (ah4 >>> 18 | al4 << 32 - 18) ^ (al4 >>> 41 - 32 | ah4 << 32 - (41 - 32));
      l3 = (al4 >>> 14 | ah4 << 32 - 14) ^ (al4 >>> 18 | ah4 << 32 - 18) ^ (ah4 >>> 41 - 32 | al4 << 32 - (41 - 32));
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      h5 = ah4 & ah5 ^ ~ah4 & ah6;
      l3 = al4 & al5 ^ ~al4 & al6;
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      h5 = K[i5 * 2];
      l3 = K[i5 * 2 + 1];
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      h5 = wh[i5 % 16];
      l3 = wl[i5 % 16];
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      b5 += a6 >>> 16;
      c5 += b5 >>> 16;
      d6 += c5 >>> 16;
      th = c5 & 65535 | d6 << 16;
      tl = a6 & 65535 | b5 << 16;
      h5 = th;
      l3 = tl;
      a6 = l3 & 65535;
      b5 = l3 >>> 16;
      c5 = h5 & 65535;
      d6 = h5 >>> 16;
      h5 = (ah0 >>> 28 | al0 << 32 - 28) ^ (al0 >>> 34 - 32 | ah0 << 32 - (34 - 32)) ^ (al0 >>> 39 - 32 | ah0 << 32 - (39 - 32));
      l3 = (al0 >>> 28 | ah0 << 32 - 28) ^ (ah0 >>> 34 - 32 | al0 << 32 - (34 - 32)) ^ (ah0 >>> 39 - 32 | al0 << 32 - (39 - 32));
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      h5 = ah0 & ah1 ^ ah0 & ah2 ^ ah1 & ah2;
      l3 = al0 & al1 ^ al0 & al2 ^ al1 & al2;
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      b5 += a6 >>> 16;
      c5 += b5 >>> 16;
      d6 += c5 >>> 16;
      bh7 = c5 & 65535 | d6 << 16;
      bl7 = a6 & 65535 | b5 << 16;
      h5 = bh3;
      l3 = bl3;
      a6 = l3 & 65535;
      b5 = l3 >>> 16;
      c5 = h5 & 65535;
      d6 = h5 >>> 16;
      h5 = th;
      l3 = tl;
      a6 += l3 & 65535;
      b5 += l3 >>> 16;
      c5 += h5 & 65535;
      d6 += h5 >>> 16;
      b5 += a6 >>> 16;
      c5 += b5 >>> 16;
      d6 += c5 >>> 16;
      bh3 = c5 & 65535 | d6 << 16;
      bl3 = a6 & 65535 | b5 << 16;
      ah1 = bh0;
      ah2 = bh1;
      ah3 = bh2;
      ah4 = bh3;
      ah5 = bh4;
      ah6 = bh5;
      ah7 = bh6;
      ah0 = bh7;
      al1 = bl0;
      al2 = bl1;
      al3 = bl2;
      al4 = bl3;
      al5 = bl4;
      al6 = bl5;
      al7 = bl6;
      al0 = bl7;
      if (i5 % 16 === 15) {
        for (j4 = 0; j4 < 16; j4++) {
          h5 = wh[j4];
          l3 = wl[j4];
          a6 = l3 & 65535;
          b5 = l3 >>> 16;
          c5 = h5 & 65535;
          d6 = h5 >>> 16;
          h5 = wh[(j4 + 9) % 16];
          l3 = wl[(j4 + 9) % 16];
          a6 += l3 & 65535;
          b5 += l3 >>> 16;
          c5 += h5 & 65535;
          d6 += h5 >>> 16;
          th = wh[(j4 + 1) % 16];
          tl = wl[(j4 + 1) % 16];
          h5 = (th >>> 1 | tl << 32 - 1) ^ (th >>> 8 | tl << 32 - 8) ^ th >>> 7;
          l3 = (tl >>> 1 | th << 32 - 1) ^ (tl >>> 8 | th << 32 - 8) ^ (tl >>> 7 | th << 32 - 7);
          a6 += l3 & 65535;
          b5 += l3 >>> 16;
          c5 += h5 & 65535;
          d6 += h5 >>> 16;
          th = wh[(j4 + 14) % 16];
          tl = wl[(j4 + 14) % 16];
          h5 = (th >>> 19 | tl << 32 - 19) ^ (tl >>> 61 - 32 | th << 32 - (61 - 32)) ^ th >>> 6;
          l3 = (tl >>> 19 | th << 32 - 19) ^ (th >>> 61 - 32 | tl << 32 - (61 - 32)) ^ (tl >>> 6 | th << 32 - 6);
          a6 += l3 & 65535;
          b5 += l3 >>> 16;
          c5 += h5 & 65535;
          d6 += h5 >>> 16;
          b5 += a6 >>> 16;
          c5 += b5 >>> 16;
          d6 += c5 >>> 16;
          wh[j4] = c5 & 65535 | d6 << 16;
          wl[j4] = a6 & 65535 | b5 << 16;
        }
      }
    }
    h5 = ah0;
    l3 = al0;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[0];
    l3 = hl[0];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[0] = ah0 = c5 & 65535 | d6 << 16;
    hl[0] = al0 = a6 & 65535 | b5 << 16;
    h5 = ah1;
    l3 = al1;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[1];
    l3 = hl[1];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[1] = ah1 = c5 & 65535 | d6 << 16;
    hl[1] = al1 = a6 & 65535 | b5 << 16;
    h5 = ah2;
    l3 = al2;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[2];
    l3 = hl[2];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[2] = ah2 = c5 & 65535 | d6 << 16;
    hl[2] = al2 = a6 & 65535 | b5 << 16;
    h5 = ah3;
    l3 = al3;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[3];
    l3 = hl[3];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[3] = ah3 = c5 & 65535 | d6 << 16;
    hl[3] = al3 = a6 & 65535 | b5 << 16;
    h5 = ah4;
    l3 = al4;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[4];
    l3 = hl[4];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[4] = ah4 = c5 & 65535 | d6 << 16;
    hl[4] = al4 = a6 & 65535 | b5 << 16;
    h5 = ah5;
    l3 = al5;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[5];
    l3 = hl[5];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[5] = ah5 = c5 & 65535 | d6 << 16;
    hl[5] = al5 = a6 & 65535 | b5 << 16;
    h5 = ah6;
    l3 = al6;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[6];
    l3 = hl[6];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[6] = ah6 = c5 & 65535 | d6 << 16;
    hl[6] = al6 = a6 & 65535 | b5 << 16;
    h5 = ah7;
    l3 = al7;
    a6 = l3 & 65535;
    b5 = l3 >>> 16;
    c5 = h5 & 65535;
    d6 = h5 >>> 16;
    h5 = hh[7];
    l3 = hl[7];
    a6 += l3 & 65535;
    b5 += l3 >>> 16;
    c5 += h5 & 65535;
    d6 += h5 >>> 16;
    b5 += a6 >>> 16;
    c5 += b5 >>> 16;
    d6 += c5 >>> 16;
    hh[7] = ah7 = c5 & 65535 | d6 << 16;
    hl[7] = al7 = a6 & 65535 | b5 << 16;
    pos += 128;
    n2 -= 128;
  }
  return n2;
}
function crypto_hash(out, m6, n2) {
  const hh = new Int32Array(8);
  const hl = new Int32Array(8);
  const x6 = new Uint8Array(256);
  const b5 = n2;
  hh[0] = 1779033703;
  hh[1] = 3144134277;
  hh[2] = 1013904242;
  hh[3] = 2773480762;
  hh[4] = 1359893119;
  hh[5] = 2600822924;
  hh[6] = 528734635;
  hh[7] = 1541459225;
  hl[0] = 4089235720;
  hl[1] = 2227873595;
  hl[2] = 4271175723;
  hl[3] = 1595750129;
  hl[4] = 2917565137;
  hl[5] = 725511199;
  hl[6] = 4215389547;
  hl[7] = 327033209;
  crypto_hashblocks_hl(hh, hl, m6, n2);
  n2 %= 128;
  for (let i5 = 0; i5 < n2; i5++)
    x6[i5] = m6[b5 - n2 + i5];
  x6[n2] = 128;
  n2 = 256 - 128 * (n2 < 112 ? 1 : 0);
  x6[n2 - 9] = 0;
  ts64(x6, n2 - 8, b5 / 536870912 | 0, b5 << 3);
  crypto_hashblocks_hl(hh, hl, x6, n2);
  for (let i5 = 0; i5 < 8; i5++)
    ts64(out, 8 * i5, hh[i5], hl[i5]);
  return 0;
}
var HashState = class {
  constructor() {
    this.hh = new Int32Array(8);
    this.hl = new Int32Array(8);
    this.next = new Uint8Array(128);
    this.p = 0;
    this.total = 0;
    this.hh[0] = 1779033703;
    this.hh[1] = 3144134277;
    this.hh[2] = 1013904242;
    this.hh[3] = 2773480762;
    this.hh[4] = 1359893119;
    this.hh[5] = 2600822924;
    this.hh[6] = 528734635;
    this.hh[7] = 1541459225;
    this.hl[0] = 4089235720;
    this.hl[1] = 2227873595;
    this.hl[2] = 4271175723;
    this.hl[3] = 1595750129;
    this.hl[4] = 2917565137;
    this.hl[5] = 725511199;
    this.hl[6] = 4215389547;
    this.hl[7] = 327033209;
  }
  update(data) {
    this.total += data.length;
    let i5 = 0;
    while (i5 < data.length) {
      const r3 = 128 - this.p;
      if (r3 > data.length - i5) {
        for (let j4 = 0; i5 + j4 < data.length; j4++) {
          this.next[this.p + j4] = data[i5 + j4];
        }
        this.p += data.length - i5;
        break;
      } else {
        for (let j4 = 0; this.p + j4 < 128; j4++) {
          this.next[this.p + j4] = data[i5 + j4];
        }
        crypto_hashblocks_hl(this.hh, this.hl, this.next, 128);
        i5 += 128 - this.p;
        this.p = 0;
      }
    }
    return this;
  }
  finish() {
    const out = new Uint8Array(64);
    let n2 = this.p;
    const x6 = new Uint8Array(256);
    const b5 = this.total;
    for (let i5 = 0; i5 < n2; i5++)
      x6[i5] = this.next[i5];
    x6[n2] = 128;
    n2 = 256 - 128 * (n2 < 112 ? 1 : 0);
    x6[n2 - 9] = 0;
    ts64(x6, n2 - 8, b5 / 536870912 | 0, b5 << 3);
    crypto_hashblocks_hl(this.hh, this.hl, x6, n2);
    for (let i5 = 0; i5 < 8; i5++)
      ts64(out, 8 * i5, this.hh[i5], this.hl[i5]);
    return out;
  }
};
function add(p4, q6) {
  const a6 = gf(), b5 = gf(), c5 = gf(), d6 = gf(), e5 = gf(), f3 = gf(), g4 = gf(), h5 = gf(), t5 = gf();
  Z(a6, p4[1], p4[0]);
  Z(t5, q6[1], q6[0]);
  M(a6, a6, t5);
  A(b5, p4[0], p4[1]);
  A(t5, q6[0], q6[1]);
  M(b5, b5, t5);
  M(c5, p4[3], q6[3]);
  M(c5, c5, D2);
  M(d6, p4[2], q6[2]);
  A(d6, d6, d6);
  Z(e5, b5, a6);
  Z(f3, d6, c5);
  A(g4, d6, c5);
  A(h5, b5, a6);
  M(p4[0], e5, f3);
  M(p4[1], h5, g4);
  M(p4[2], g4, f3);
  M(p4[3], e5, h5);
}
function cswap(p4, q6, b5) {
  let i5;
  for (i5 = 0; i5 < 4; i5++) {
    sel25519(p4[i5], q6[i5], b5);
  }
}
function pack(r3, p4) {
  const tx = gf(), ty = gf(), zi = gf();
  inv25519(zi, p4[2]);
  M(tx, p4[0], zi);
  M(ty, p4[1], zi);
  pack25519(r3, ty);
  r3[31] ^= par25519(tx) << 7;
}
function scalarmult(p4, q6, s6) {
  let b5, i5;
  set25519(p4[0], gf0);
  set25519(p4[1], gf1);
  set25519(p4[2], gf1);
  set25519(p4[3], gf0);
  for (i5 = 255; i5 >= 0; --i5) {
    b5 = s6[i5 / 8 | 0] >> (i5 & 7) & 1;
    cswap(p4, q6, b5);
    add(q6, p4);
    add(p4, p4);
    cswap(p4, q6, b5);
  }
}
function scalarbase(p4, s6) {
  const q6 = [gf(), gf(), gf(), gf()];
  set25519(q6[0], X);
  set25519(q6[1], Y);
  set25519(q6[2], gf1);
  M(q6[3], X, Y);
  scalarmult(p4, q6, s6);
}
function crypto_sign_keypair(pk, sk, seeded) {
  const d6 = new Uint8Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  if (!seeded)
    randombytes(sk, 32);
  crypto_hash(d6, sk, 32);
  d6[0] &= 248;
  d6[31] &= 127;
  d6[31] |= 64;
  scalarbase(p4, d6);
  pack(pk, p4);
  for (let i5 = 0; i5 < 32; i5++)
    sk[i5 + 32] = pk[i5];
  return 0;
}
var L = new Float64Array([
  237,
  211,
  245,
  92,
  26,
  99,
  18,
  88,
  214,
  156,
  247,
  162,
  222,
  249,
  222,
  20,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  16
]);
function modL(r3, x6) {
  let carry, i5, j4, k6;
  for (i5 = 63; i5 >= 32; --i5) {
    carry = 0;
    for (j4 = i5 - 32, k6 = i5 - 12; j4 < k6; ++j4) {
      x6[j4] += carry - 16 * x6[i5] * L[j4 - (i5 - 32)];
      carry = Math.floor((x6[j4] + 128) / 256);
      x6[j4] -= carry * 256;
    }
    x6[j4] += carry;
    x6[i5] = 0;
  }
  carry = 0;
  for (j4 = 0; j4 < 32; j4++) {
    x6[j4] += carry - (x6[31] >> 4) * L[j4];
    carry = x6[j4] >> 8;
    x6[j4] &= 255;
  }
  for (j4 = 0; j4 < 32; j4++)
    x6[j4] -= carry * L[j4];
  for (i5 = 0; i5 < 32; i5++) {
    x6[i5 + 1] += x6[i5] >> 8;
    r3[i5] = x6[i5] & 255;
  }
}
function reduce(r3) {
  const x6 = new Float64Array(64);
  for (let i5 = 0; i5 < 64; i5++)
    x6[i5] = r3[i5];
  for (let i5 = 0; i5 < 64; i5++)
    r3[i5] = 0;
  modL(r3, x6);
}
function crypto_sign(sm, m6, n2, sk) {
  const d6 = new Uint8Array(64), h5 = new Uint8Array(64), r3 = new Uint8Array(64);
  let i5, j4;
  const x6 = new Float64Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  crypto_hash(d6, sk, 32);
  d6[0] &= 248;
  d6[31] &= 127;
  d6[31] |= 64;
  const smlen = n2 + 64;
  for (i5 = 0; i5 < n2; i5++)
    sm[64 + i5] = m6[i5];
  for (i5 = 0; i5 < 32; i5++)
    sm[32 + i5] = d6[32 + i5];
  crypto_hash(r3, sm.subarray(32), n2 + 32);
  reduce(r3);
  scalarbase(p4, r3);
  pack(sm, p4);
  for (i5 = 32; i5 < 64; i5++)
    sm[i5] = sk[i5];
  crypto_hash(h5, sm, n2 + 64);
  reduce(h5);
  for (i5 = 0; i5 < 64; i5++)
    x6[i5] = 0;
  for (i5 = 0; i5 < 32; i5++)
    x6[i5] = r3[i5];
  for (i5 = 0; i5 < 32; i5++) {
    for (j4 = 0; j4 < 32; j4++) {
      x6[i5 + j4] += h5[i5] * d6[j4];
    }
  }
  modL(sm.subarray(32), x6);
  return smlen;
}
function unpackpos(r3, p4) {
  const q6 = [gf(), gf(), gf(), gf()];
  if (unpackneg(q6, p4))
    return -1;
  const scalar0 = new Uint8Array(32);
  const scalar1 = new Uint8Array(32);
  scalar1[0] = 1;
  const scalarNeg1 = crypto_core_ed25519_scalar_sub(scalar0, scalar1);
  scalarmult(r3, q6, scalarNeg1);
  return 0;
}
function unpackneg(r3, p4) {
  const t5 = gf();
  const chk = gf();
  const num = gf();
  const den = gf();
  const den2 = gf();
  const den4 = gf();
  const den6 = gf();
  set25519(r3[2], gf1);
  unpack25519(r3[1], p4);
  S(num, r3[1]);
  M(den, num, D);
  Z(num, num, r3[2]);
  A(den, r3[2], den);
  S(den2, den);
  S(den4, den2);
  M(den6, den4, den2);
  M(t5, den6, num);
  M(t5, t5, den);
  pow2523(t5, t5);
  M(t5, t5, num);
  M(t5, t5, den);
  M(t5, t5, den);
  M(r3[0], t5, den);
  S(chk, r3[0]);
  M(chk, chk, den);
  if (neq25519(chk, num))
    M(r3[0], r3[0], I);
  S(chk, r3[0]);
  M(chk, chk, den);
  if (neq25519(chk, num))
    return -1;
  if (par25519(r3[0]) === p4[31] >> 7)
    Z(r3[0], gf0, r3[0]);
  M(r3[3], r3[0], r3[1]);
  return 0;
}
function crypto_scalarmult_ed25519_base_noclamp(s6) {
  const r3 = new Uint8Array(32);
  const p4 = [gf(), gf(), gf(), gf()];
  scalarbase(p4, s6);
  pack(r3, p4);
  return r3;
}
function crypto_scalarmult_ed25519_noclamp(s6, q6) {
  const r3 = new Uint8Array(32);
  const p4 = [gf(), gf(), gf(), gf()];
  const ql = [gf(), gf(), gf(), gf()];
  if (unpackpos(ql, q6))
    throw new Error();
  scalarmult(p4, ql, s6);
  pack(r3, p4);
  return r3;
}
function crypto_sign_open(m6, sm, n2, pk) {
  let i5, mlen;
  const t5 = new Uint8Array(32), h5 = new Uint8Array(64);
  const p4 = [gf(), gf(), gf(), gf()], q6 = [gf(), gf(), gf(), gf()];
  mlen = -1;
  if (n2 < 64)
    return -1;
  if (unpackneg(q6, pk))
    return -1;
  for (i5 = 0; i5 < n2; i5++)
    m6[i5] = sm[i5];
  for (i5 = 0; i5 < 32; i5++)
    m6[i5 + 32] = pk[i5];
  crypto_hash(h5, m6, n2);
  reduce(h5);
  scalarmult(p4, q6, h5);
  scalarbase(q6, sm.subarray(32));
  add(p4, q6);
  pack(t5, p4);
  n2 -= 64;
  if (crypto_verify_32(sm, 0, t5, 0)) {
    for (i5 = 0; i5 < n2; i5++)
      m6[i5] = 0;
    return -1;
  }
  for (i5 = 0; i5 < n2; i5++)
    m6[i5] = sm[i5 + 64];
  mlen = n2;
  return mlen;
}
var crypto_sign_BYTES = 64;
var crypto_sign_PUBLICKEYBYTES = 32;
var crypto_sign_SECRETKEYBYTES = 64;
var crypto_sign_SEEDBYTES = 32;
var crypto_hash_BYTES = 64;
function checkArrayTypes(...args) {
  for (let i5 = 0; i5 < args.length; i5++) {
    if (!(args[i5] instanceof Uint8Array))
      throw new TypeError("unexpected type, use Uint8Array");
  }
}
function randomBytes(n2) {
  const b5 = new Uint8Array(n2);
  randombytes(b5, n2);
  return b5;
}
function sign(msg, secretKey) {
  checkArrayTypes(msg, secretKey);
  if (secretKey.length !== crypto_sign_SECRETKEYBYTES)
    throw new Error("bad secret key size");
  const signedMsg = new Uint8Array(crypto_sign_BYTES + msg.length);
  crypto_sign(signedMsg, msg, msg.length, secretKey);
  return signedMsg;
}
function sign_detached(msg, secretKey) {
  const signedMsg = sign(msg, secretKey);
  const sig = new Uint8Array(crypto_sign_BYTES);
  for (let i5 = 0; i5 < sig.length; i5++)
    sig[i5] = signedMsg[i5];
  return sig;
}
function crypto_sign_keyPair_fromSeed(seed) {
  checkArrayTypes(seed);
  if (seed.length !== crypto_sign_SEEDBYTES)
    throw new Error(`bad seed size: ${seed.length}`);
  const pk = new Uint8Array(crypto_sign_PUBLICKEYBYTES);
  const sk = new Uint8Array(crypto_sign_SECRETKEYBYTES);
  for (let i5 = 0; i5 < 32; i5++)
    sk[i5] = seed[i5];
  crypto_sign_keypair(pk, sk, true);
  return { publicKey: pk, secretKey: sk };
}
function hash(msg) {
  checkArrayTypes(msg);
  const h5 = new Uint8Array(crypto_hash_BYTES);
  crypto_hash(h5, msg, msg.length);
  return h5;
}
function setPRNG(fn2) {
  randombytes = fn2;
}
function crypto_core_ed25519_scalar_reduce(x6) {
  const len = x6.length;
  const z6 = new Float64Array(64);
  for (let i5 = 0; i5 < len; i5++)
    z6[i5] = x6[i5];
  const o3 = new Uint8Array(32);
  modL(o3, z6);
  return o3;
}
function crypto_core_ed25519_scalar_sub(x6, y6) {
  const z6 = new Float64Array(64);
  for (let i5 = 0; i5 < 32; i5++) {
    z6[i5] = x6[i5] - y6[i5];
  }
  const o3 = new Uint8Array(32);
  modL(o3, z6);
  return o3;
}
function crypto_edx25519_private_key_create() {
  const seed = new Uint8Array(32);
  randombytes(seed, 32);
  return crypto_edx25519_private_key_create_from_seed(seed);
}
function crypto_edx25519_private_key_create_from_seed(seed) {
  const pk = hash(seed);
  pk[0] &= 248;
  pk[31] &= 127;
  pk[31] |= 64;
  return pk;
}
function crypto_edx25519_get_public(priv) {
  return crypto_scalarmult_ed25519_base_noclamp(priv.subarray(0, 32));
}
function crypto_edx25519_sign_detached(m6, skx, pkx) {
  const n2 = m6.length;
  const h5 = new Uint8Array(64);
  const r3 = new Uint8Array(64);
  let i5, j4;
  const x6 = new Float64Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  const sm = new Uint8Array(n2 + 64);
  for (i5 = 0; i5 < n2; i5++)
    sm[64 + i5] = m6[i5];
  for (i5 = 0; i5 < 32; i5++)
    sm[32 + i5] = skx[32 + i5];
  crypto_hash(r3, sm.subarray(32), n2 + 32);
  reduce(r3);
  scalarbase(p4, r3);
  pack(sm, p4);
  for (i5 = 32; i5 < 64; i5++)
    sm[i5] = pkx[i5 - 32];
  crypto_hash(h5, sm, n2 + 64);
  reduce(h5);
  for (i5 = 0; i5 < 64; i5++)
    x6[i5] = 0;
  for (i5 = 0; i5 < 32; i5++)
    x6[i5] = r3[i5];
  for (i5 = 0; i5 < 32; i5++) {
    for (j4 = 0; j4 < 32; j4++) {
      x6[i5 + j4] += h5[i5] * skx[j4];
    }
  }
  modL(sm.subarray(32), x6);
  return sm.subarray(0, 64);
}
function crypto_edx25519_sign_detached_verify(msg, sig, publicKey) {
  checkArrayTypes(msg, sig, publicKey);
  if (sig.length !== crypto_sign_BYTES)
    throw new Error("bad signature size");
  if (publicKey.length !== crypto_sign_PUBLICKEYBYTES)
    throw new Error("bad public key size");
  const sm = new Uint8Array(crypto_sign_BYTES + msg.length);
  const m6 = new Uint8Array(crypto_sign_BYTES + msg.length);
  let i5;
  for (i5 = 0; i5 < crypto_sign_BYTES; i5++)
    sm[i5] = sig[i5];
  for (i5 = 0; i5 < msg.length; i5++)
    sm[i5 + crypto_sign_BYTES] = msg[i5];
  return crypto_sign_open(m6, sm, sm.length, publicKey) >= 0;
}

// ../taler-util/lib/prng-browser.js
function loadBrowserPrng() {
  const cr = typeof self !== "undefined" ? self.crypto || self.msCrypto : null;
  const QUOTA = 65536;
  setPRNG(function(x6, n2) {
    let i5;
    const v3 = new Uint8Array(n2);
    for (i5 = 0; i5 < n2; i5 += QUOTA) {
      cr.getRandomValues(v3.subarray(i5, i5 + Math.min(n2 - i5, QUOTA)));
    }
    for (i5 = 0; i5 < n2; i5++)
      x6[i5] = v3[i5];
    for (i5 = 0; i5 < v3.length; i5++)
      v3[i5] = 0;
  });
}

// ../taler-util/lib/punycode.js
var maxInt = 2147483647;
var base = 36;
var tMin = 1;
var tMax = 26;
var skew = 38;
var damp = 700;
var initialBias = 72;
var initialN = 128;
var delimiter = "-";
var regexPunycode = /^xn--/;
var regexNonASCII = /[^\0-\x7E]/;
var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g;
var errors = {
  overflow: "Overflow: input needs wider integers to process",
  "not-basic": "Illegal input >= 0x80 (not a basic code point)",
  "invalid-input": "Invalid input"
};
var baseMinusTMin = base - tMin;
var floor = Math.floor;
var stringFromCharCode = String.fromCharCode;
function error(type) {
  throw new RangeError(errors[type]);
}
function map(array, fn2) {
  const result = [];
  let length = array.length;
  while (length--) {
    result[length] = fn2(array[length]);
  }
  return result;
}
function mapDomain(string, fn2) {
  const parts = string.split("@");
  let result = "";
  if (parts.length > 1) {
    result = parts[0] + "@";
    string = parts[1];
  }
  string = string.replace(regexSeparators, ".");
  const labels = string.split(".");
  const encoded = map(labels, fn2).join(".");
  return result + encoded;
}
function ucs2decode(string) {
  const output = [];
  let counter2 = 0;
  const length = string.length;
  while (counter2 < length) {
    const value = string.charCodeAt(counter2++);
    if (value >= 55296 && value <= 56319 && counter2 < length) {
      const extra = string.charCodeAt(counter2++);
      if ((extra & 64512) == 56320) {
        output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
      } else {
        output.push(value);
        counter2--;
      }
    } else {
      output.push(value);
    }
  }
  return output;
}
var ucs2encode = (array) => String.fromCodePoint(...array);
var basicToDigit = function(codePoint) {
  if (codePoint - 48 < 10) {
    return codePoint - 22;
  }
  if (codePoint - 65 < 26) {
    return codePoint - 65;
  }
  if (codePoint - 97 < 26) {
    return codePoint - 97;
  }
  return base;
};
var digitToBasic = function(digit, flag) {
  return digit + 22 + 75 * Number(digit < 26) - (Number(flag != 0) << 5);
};
var adapt = function(delta, numPoints, firstTime) {
  let k6 = 0;
  delta = firstTime ? floor(delta / damp) : delta >> 1;
  delta += floor(delta / numPoints);
  for (
    ;
    /* no initialization */
    delta > baseMinusTMin * tMax >> 1;
    k6 += base
  ) {
    delta = floor(delta / baseMinusTMin);
  }
  return floor(k6 + (baseMinusTMin + 1) * delta / (delta + skew));
};
var decode = function(input) {
  const output = [];
  const inputLength = input.length;
  let i5 = 0;
  let n2 = initialN;
  let bias = initialBias;
  let basic = input.lastIndexOf(delimiter);
  if (basic < 0) {
    basic = 0;
  }
  for (let j4 = 0; j4 < basic; ++j4) {
    if (input.charCodeAt(j4) >= 128) {
      error("not-basic");
    }
    output.push(input.charCodeAt(j4));
  }
  for (let index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
    let oldi = i5;
    for (let w6 = 1, k6 = base; ; k6 += base) {
      if (index >= inputLength) {
        error("invalid-input");
      }
      const digit = basicToDigit(input.charCodeAt(index++));
      if (digit >= base || digit > floor((maxInt - i5) / w6)) {
        error("overflow");
      }
      i5 += digit * w6;
      const t5 = k6 <= bias ? tMin : k6 >= bias + tMax ? tMax : k6 - bias;
      if (digit < t5) {
        break;
      }
      const baseMinusT = base - t5;
      if (w6 > floor(maxInt / baseMinusT)) {
        error("overflow");
      }
      w6 *= baseMinusT;
    }
    const out = output.length + 1;
    bias = adapt(i5 - oldi, out, oldi == 0);
    if (floor(i5 / out) > maxInt - n2) {
      error("overflow");
    }
    n2 += floor(i5 / out);
    i5 %= out;
    output.splice(i5++, 0, n2);
  }
  return String.fromCodePoint(...output);
};
var encode = function(inputArg) {
  const output = [];
  let input = ucs2decode(inputArg);
  let inputLength = input.length;
  let n2 = initialN;
  let delta = 0;
  let bias = initialBias;
  for (const currentValue of input) {
    if (currentValue < 128) {
      output.push(stringFromCharCode(currentValue));
    }
  }
  let basicLength = output.length;
  let handledCPCount = basicLength;
  if (basicLength) {
    output.push(delimiter);
  }
  while (handledCPCount < inputLength) {
    let m6 = maxInt;
    for (const currentValue of input) {
      if (currentValue >= n2 && currentValue < m6) {
        m6 = currentValue;
      }
    }
    const handledCPCountPlusOne = handledCPCount + 1;
    if (m6 - n2 > floor((maxInt - delta) / handledCPCountPlusOne)) {
      error("overflow");
    }
    delta += (m6 - n2) * handledCPCountPlusOne;
    n2 = m6;
    for (const currentValue of input) {
      if (currentValue < n2 && ++delta > maxInt) {
        error("overflow");
      }
      if (currentValue == n2) {
        let q6 = delta;
        for (let k6 = base; ; k6 += base) {
          const t5 = k6 <= bias ? tMin : k6 >= bias + tMax ? tMax : k6 - bias;
          if (q6 < t5) {
            break;
          }
          const qMinusT = q6 - t5;
          const baseMinusT = base - t5;
          output.push(stringFromCharCode(digitToBasic(t5 + qMinusT % baseMinusT, 0)));
          q6 = floor(qMinusT / baseMinusT);
        }
        output.push(stringFromCharCode(digitToBasic(q6, 0)));
        bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
        delta = 0;
        ++handledCPCount;
      }
    }
    ++delta;
    ++n2;
  }
  return output.join("");
};
var toUnicode = function(input) {
  return mapDomain(input, function(string) {
    return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
  });
};
var toASCII = function(input) {
  return mapDomain(input, function(string) {
    return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
  });
};
var punycode = {
  /**
   * A string representing the current Punycode.js version number.
   * @memberOf punycode
   * @type String
   */
  version: "2.1.0",
  /**
   * An object of methods to convert from JavaScript's internal character
   * representation (UCS-2) to Unicode code points, and back.
   * @see <https://mathiasbynens.be/notes/javascript-encoding>
   * @memberOf punycode
   * @type Object
   */
  ucs2: {
    decode: ucs2decode,
    encode: ucs2encode
  },
  decode,
  encode,
  toASCII,
  toUnicode
};

// ../taler-util/lib/whatwg-url.js
var utf8Encoder = new TextEncoder();
var utf8Decoder = new TextDecoder("utf-8", { ignoreBOM: true });
function utf8Encode(string) {
  return utf8Encoder.encode(string);
}
function utf8DecodeWithoutBOM(bytes) {
  return utf8Decoder.decode(bytes);
}
function parseUrlencoded(input) {
  const sequences = strictlySplitByteSequence(input, p("&"));
  const output = [];
  for (const bytes of sequences) {
    if (bytes.length === 0) {
      continue;
    }
    let name, value;
    const indexOfEqual = bytes.indexOf(p("="));
    if (indexOfEqual >= 0) {
      name = bytes.slice(0, indexOfEqual);
      value = bytes.slice(indexOfEqual + 1);
    } else {
      name = bytes;
      value = new Uint8Array(0);
    }
    name = replaceByteInByteSequence(name, 43, 32);
    value = replaceByteInByteSequence(value, 43, 32);
    const nameString = utf8DecodeWithoutBOM(percentDecodeBytes(name));
    const valueString = utf8DecodeWithoutBOM(percentDecodeBytes(value));
    output.push([nameString, valueString]);
  }
  return output;
}
function parseUrlencodedString(input) {
  return parseUrlencoded(utf8Encode(input));
}
function serializeUrlencoded(tuples, encodingOverride = void 0) {
  let encoding = "utf-8";
  if (encodingOverride !== void 0) {
    encoding = encodingOverride;
  }
  let output = "";
  for (const [i5, tuple] of tuples.entries()) {
    const name = utf8PercentEncodeString(tuple[0], isURLEncodedPercentEncode, true);
    let value = tuple[1];
    if (tuple.length > 2 && tuple[2] !== void 0) {
      if (tuple[2] === "hidden" && name === "_charset_") {
        value = encoding;
      } else if (tuple[2] === "file") {
        value = value.name;
      }
    }
    value = utf8PercentEncodeString(value, isURLEncodedPercentEncode, true);
    if (i5 !== 0) {
      output += "&";
    }
    output += `${name}=${value}`;
  }
  return output;
}
function strictlySplitByteSequence(buf, cp) {
  const list = [];
  let last = 0;
  let i5 = buf.indexOf(cp);
  while (i5 >= 0) {
    list.push(buf.slice(last, i5));
    last = i5 + 1;
    i5 = buf.indexOf(cp, last);
  }
  if (last !== buf.length) {
    list.push(buf.slice(last));
  }
  return list;
}
function replaceByteInByteSequence(buf, from, to) {
  let i5 = buf.indexOf(from);
  while (i5 >= 0) {
    buf[i5] = to;
    i5 = buf.indexOf(from, i5 + 1);
  }
  return buf;
}
function p(char) {
  return char.codePointAt(0);
}
function percentEncode(c5) {
  let hex = c5.toString(16).toUpperCase();
  if (hex.length === 1) {
    hex = `0${hex}`;
  }
  return `%${hex}`;
}
function percentDecodeBytes(input) {
  const output = new Uint8Array(input.byteLength);
  let outputIndex = 0;
  for (let i5 = 0; i5 < input.byteLength; ++i5) {
    const byte = input[i5];
    if (byte !== 37) {
      output[outputIndex++] = byte;
    } else if (byte === 37 && (!isASCIIHex(input[i5 + 1]) || !isASCIIHex(input[i5 + 2]))) {
      output[outputIndex++] = byte;
    } else {
      const bytePoint = parseInt(String.fromCodePoint(input[i5 + 1], input[i5 + 2]), 16);
      output[outputIndex++] = bytePoint;
      i5 += 2;
    }
  }
  return output.slice(0, outputIndex);
}
function percentDecodeString(input) {
  const bytes = utf8Encode(input);
  return percentDecodeBytes(bytes);
}
function isC0ControlPercentEncode(c5) {
  return c5 <= 31 || c5 > 126;
}
var extraFragmentPercentEncodeSet = /* @__PURE__ */ new Set([
  p(" "),
  p('"'),
  p("<"),
  p(">"),
  p("`")
]);
function isFragmentPercentEncode(c5) {
  return isC0ControlPercentEncode(c5) || extraFragmentPercentEncodeSet.has(c5);
}
var extraQueryPercentEncodeSet = /* @__PURE__ */ new Set([
  p(" "),
  p('"'),
  p("#"),
  p("<"),
  p(">")
]);
function isQueryPercentEncode(c5) {
  return isC0ControlPercentEncode(c5) || extraQueryPercentEncodeSet.has(c5);
}
function isSpecialQueryPercentEncode(c5) {
  return isQueryPercentEncode(c5) || c5 === p("'");
}
var extraPathPercentEncodeSet = /* @__PURE__ */ new Set([p("?"), p("`"), p("{"), p("}")]);
function isPathPercentEncode(c5) {
  return isQueryPercentEncode(c5) || extraPathPercentEncodeSet.has(c5);
}
var extraUserinfoPercentEncodeSet = /* @__PURE__ */ new Set([
  p("/"),
  p(":"),
  p(";"),
  p("="),
  p("@"),
  p("["),
  p("\\"),
  p("]"),
  p("^"),
  p("|")
]);
function isUserinfoPercentEncode(c5) {
  return isPathPercentEncode(c5) || extraUserinfoPercentEncodeSet.has(c5);
}
var extraComponentPercentEncodeSet = /* @__PURE__ */ new Set([
  p("$"),
  p("%"),
  p("&"),
  p("+"),
  p(",")
]);
function isComponentPercentEncode(c5) {
  return isUserinfoPercentEncode(c5) || extraComponentPercentEncodeSet.has(c5);
}
var extraURLEncodedPercentEncodeSet = /* @__PURE__ */ new Set([
  p("!"),
  p("'"),
  p("("),
  p(")"),
  p("~")
]);
function isURLEncodedPercentEncode(c5) {
  return isComponentPercentEncode(c5) || extraURLEncodedPercentEncodeSet.has(c5);
}
function utf8PercentEncodeCodePointInternal(codePoint, percentEncodePredicate) {
  const bytes = utf8Encode(codePoint);
  let output = "";
  for (const byte of bytes) {
    if (!percentEncodePredicate(byte)) {
      output += String.fromCharCode(byte);
    } else {
      output += percentEncode(byte);
    }
  }
  return output;
}
function utf8PercentEncodeCodePoint(codePoint, percentEncodePredicate) {
  return utf8PercentEncodeCodePointInternal(String.fromCodePoint(codePoint), percentEncodePredicate);
}
function utf8PercentEncodeString(input, percentEncodePredicate, spaceAsPlus = false) {
  let output = "";
  for (const codePoint of input) {
    if (spaceAsPlus && codePoint === " ") {
      output += "+";
    } else {
      output += utf8PercentEncodeCodePointInternal(codePoint, percentEncodePredicate);
    }
  }
  return output;
}
function isASCIIDigit(c5) {
  return c5 >= 48 && c5 <= 57;
}
function isASCIIAlpha(c5) {
  return c5 >= 65 && c5 <= 90 || c5 >= 97 && c5 <= 122;
}
function isASCIIAlphanumeric(c5) {
  return isASCIIAlpha(c5) || isASCIIDigit(c5);
}
function isASCIIHex(c5) {
  return isASCIIDigit(c5) || c5 >= 65 && c5 <= 70 || c5 >= 97 && c5 <= 102;
}
var URLSearchParamsImpl = class {
  constructor(init, { doNotStripQMark = false } = {}) {
    this._list = [];
    this._url = null;
    if (!doNotStripQMark && typeof init === "string" && init[0] === "?") {
      init = init.slice(1);
    }
    if (Array.isArray(init)) {
      for (const pair of init) {
        if (pair.length !== 2) {
          throw new TypeError("Failed to construct 'URLSearchParams': parameter 1 sequence's element does not contain exactly two elements.");
        }
        this._list.push([pair[0], pair[1]]);
      }
    } else if (typeof init === "object" && Object.getPrototypeOf(init) === null) {
      for (const name of Object.keys(init)) {
        const value = init[name];
        this._list.push([name, value]);
      }
    } else {
      this._list = parseUrlencodedString(init);
    }
  }
  _updateSteps() {
    if (this._url !== null) {
      let query = serializeUrlencoded(this._list);
      if (query === "") {
        query = null;
      }
      this._url._url.query = query;
    }
  }
  append(name, value) {
    this._list.push([name, value]);
    this._updateSteps();
  }
  delete(name) {
    let i5 = 0;
    while (i5 < this._list.length) {
      if (this._list[i5][0] === name) {
        this._list.splice(i5, 1);
      } else {
        i5++;
      }
    }
    this._updateSteps();
  }
  get(name) {
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        return tuple[1];
      }
    }
    return null;
  }
  getAll(name) {
    const output = [];
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        output.push(tuple[1]);
      }
    }
    return output;
  }
  entries() {
    return [...this._list.map((x6) => [x6[0], x6[1]])];
  }
  forEach(callbackfn, thisArg) {
    for (const tuple of this._list) {
      callbackfn.call(thisArg, tuple[1], tuple[0], this);
    }
  }
  has(name) {
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        return true;
      }
    }
    return false;
  }
  set(name, value) {
    let found = false;
    let i5 = 0;
    while (i5 < this._list.length) {
      if (this._list[i5][0] === name) {
        if (found) {
          this._list.splice(i5, 1);
        } else {
          found = true;
          this._list[i5][1] = value;
          i5++;
        }
      } else {
        i5++;
      }
    }
    if (!found) {
      this._list.push([name, value]);
    }
    this._updateSteps();
  }
  sort() {
    this._list.sort((a6, b5) => {
      if (a6[0] < b5[0]) {
        return -1;
      }
      if (a6[0] > b5[0]) {
        return 1;
      }
      return 0;
    });
    this._updateSteps();
  }
  [Symbol.iterator]() {
    return this._list[Symbol.iterator]();
  }
  toString() {
    return serializeUrlencoded(this._list);
  }
};
var specialSchemes = {
  ftp: 21,
  file: null,
  http: 80,
  https: 443,
  ws: 80,
  wss: 443
};
var failure = Symbol("failure");
function countSymbols(str) {
  return [...str].length;
}
function at(input, idx) {
  const c5 = input[idx];
  return isNaN(c5) ? void 0 : String.fromCodePoint(c5);
}
function isSingleDot(buffer) {
  return buffer === "." || buffer.toLowerCase() === "%2e";
}
function isDoubleDot(buffer) {
  buffer = buffer.toLowerCase();
  return buffer === ".." || buffer === "%2e." || buffer === ".%2e" || buffer === "%2e%2e";
}
function isWindowsDriveLetterCodePoints(cp1, cp2) {
  return isASCIIAlpha(cp1) && (cp2 === p(":") || cp2 === p("|"));
}
function isWindowsDriveLetterString(string) {
  return string.length === 2 && isASCIIAlpha(string.codePointAt(0)) && (string[1] === ":" || string[1] === "|");
}
function isNormalizedWindowsDriveLetterString(string) {
  return string.length === 2 && isASCIIAlpha(string.codePointAt(0)) && string[1] === ":";
}
function containsForbiddenHostCodePoint(string) {
  return string.search(/\u0000|\u0009|\u000A|\u000D|\u0020|#|\/|:|<|>|\?|@|\[|\\|\]|\^|\|/u) !== -1;
}
function containsForbiddenDomainCodePoint(string) {
  return containsForbiddenHostCodePoint(string) || string.search(/[\u0000-\u001F]|%|\u007F/u) !== -1;
}
function isSpecialScheme(scheme) {
  return specialSchemes[scheme] !== void 0;
}
function isSpecial(url) {
  return isSpecialScheme(url.scheme);
}
function isNotSpecial(url) {
  return !isSpecialScheme(url.scheme);
}
function defaultPort(scheme) {
  return specialSchemes[scheme];
}
function parseIPv4Number(input) {
  if (input === "") {
    return failure;
  }
  let R4 = 10;
  if (input.length >= 2 && input.charAt(0) === "0" && input.charAt(1).toLowerCase() === "x") {
    input = input.substring(2);
    R4 = 16;
  } else if (input.length >= 2 && input.charAt(0) === "0") {
    input = input.substring(1);
    R4 = 8;
  }
  if (input === "") {
    return 0;
  }
  let regex = /[^0-7]/u;
  if (R4 === 10) {
    regex = /[^0-9]/u;
  }
  if (R4 === 16) {
    regex = /[^0-9A-Fa-f]/u;
  }
  if (regex.test(input)) {
    return failure;
  }
  return parseInt(input, R4);
}
function parseIPv4(input) {
  const parts = input.split(".");
  if (parts[parts.length - 1] === "") {
    if (parts.length > 1) {
      parts.pop();
    }
  }
  if (parts.length > 4) {
    return failure;
  }
  const numbers = [];
  for (const part of parts) {
    const n2 = parseIPv4Number(part);
    if (n2 === failure) {
      return failure;
    }
    numbers.push(n2);
  }
  for (let i5 = 0; i5 < numbers.length - 1; ++i5) {
    if (numbers[i5] > 255) {
      return failure;
    }
  }
  if (numbers[numbers.length - 1] >= 256 ** (5 - numbers.length)) {
    return failure;
  }
  let ipv4 = numbers.pop();
  let counter2 = 0;
  for (const n2 of numbers) {
    ipv4 += n2 * 256 ** (3 - counter2);
    ++counter2;
  }
  return ipv4;
}
function serializeIPv4(address) {
  let output = "";
  let n2 = address;
  for (let i5 = 1; i5 <= 4; ++i5) {
    output = String(n2 % 256) + output;
    if (i5 !== 4) {
      output = `.${output}`;
    }
    n2 = Math.floor(n2 / 256);
  }
  return output;
}
function parseIPv6(inputArg) {
  const address = [0, 0, 0, 0, 0, 0, 0, 0];
  let pieceIndex = 0;
  let compress2 = null;
  let pointer = 0;
  const input = Array.from(inputArg, (c5) => c5.codePointAt(0));
  if (input[pointer] === p(":")) {
    if (input[pointer + 1] !== p(":")) {
      return failure;
    }
    pointer += 2;
    ++pieceIndex;
    compress2 = pieceIndex;
  }
  while (pointer < input.length) {
    if (pieceIndex === 8) {
      return failure;
    }
    if (input[pointer] === p(":")) {
      if (compress2 !== null) {
        return failure;
      }
      ++pointer;
      ++pieceIndex;
      compress2 = pieceIndex;
      continue;
    }
    let value = 0;
    let length = 0;
    while (length < 4 && isASCIIHex(input[pointer])) {
      value = value * 16 + parseInt(at(input, pointer), 16);
      ++pointer;
      ++length;
    }
    if (input[pointer] === p(".")) {
      if (length === 0) {
        return failure;
      }
      pointer -= length;
      if (pieceIndex > 6) {
        return failure;
      }
      let numbersSeen = 0;
      while (input[pointer] !== void 0) {
        let ipv4Piece = null;
        if (numbersSeen > 0) {
          if (input[pointer] === p(".") && numbersSeen < 4) {
            ++pointer;
          } else {
            return failure;
          }
        }
        if (!isASCIIDigit(input[pointer])) {
          return failure;
        }
        while (isASCIIDigit(input[pointer])) {
          const number = parseInt(at(input, pointer));
          if (ipv4Piece === null) {
            ipv4Piece = number;
          } else if (ipv4Piece === 0) {
            return failure;
          } else {
            ipv4Piece = ipv4Piece * 10 + number;
          }
          if (ipv4Piece > 255) {
            return failure;
          }
          ++pointer;
        }
        address[pieceIndex] = address[pieceIndex] * 256 + ipv4Piece;
        ++numbersSeen;
        if (numbersSeen === 2 || numbersSeen === 4) {
          ++pieceIndex;
        }
      }
      if (numbersSeen !== 4) {
        return failure;
      }
      break;
    } else if (input[pointer] === p(":")) {
      ++pointer;
      if (input[pointer] === void 0) {
        return failure;
      }
    } else if (input[pointer] !== void 0) {
      return failure;
    }
    address[pieceIndex] = value;
    ++pieceIndex;
  }
  if (compress2 !== null) {
    let swaps = pieceIndex - compress2;
    pieceIndex = 7;
    while (pieceIndex !== 0 && swaps > 0) {
      const temp = address[compress2 + swaps - 1];
      address[compress2 + swaps - 1] = address[pieceIndex];
      address[pieceIndex] = temp;
      --pieceIndex;
      --swaps;
    }
  } else if (compress2 === null && pieceIndex !== 8) {
    return failure;
  }
  return address;
}
function serializeIPv6(address) {
  let output = "";
  const compress2 = findLongestZeroSequence(address);
  let ignore0 = false;
  for (let pieceIndex = 0; pieceIndex <= 7; ++pieceIndex) {
    if (ignore0 && address[pieceIndex] === 0) {
      continue;
    } else if (ignore0) {
      ignore0 = false;
    }
    if (compress2 === pieceIndex) {
      const separator = pieceIndex === 0 ? "::" : ":";
      output += separator;
      ignore0 = true;
      continue;
    }
    output += address[pieceIndex].toString(16);
    if (pieceIndex !== 7) {
      output += ":";
    }
  }
  return output;
}
function parseHost(input, isNotSpecialArg = false) {
  if (input[0] === "[") {
    if (input[input.length - 1] !== "]") {
      return failure;
    }
    return parseIPv6(input.substring(1, input.length - 1));
  }
  if (isNotSpecialArg) {
    return parseOpaqueHost(input);
  }
  const domain = utf8DecodeWithoutBOM(percentDecodeString(input));
  const asciiDomain = domainToASCII(domain);
  if (asciiDomain === failure) {
    return failure;
  }
  if (containsForbiddenDomainCodePoint(asciiDomain)) {
    return failure;
  }
  if (endsInANumber(asciiDomain)) {
    return parseIPv4(asciiDomain);
  }
  return asciiDomain;
}
function endsInANumber(input) {
  const parts = input.split(".");
  if (parts[parts.length - 1] === "") {
    if (parts.length === 1) {
      return false;
    }
    parts.pop();
  }
  const last = parts[parts.length - 1];
  if (parseIPv4Number(last) !== failure) {
    return true;
  }
  if (/^[0-9]+$/u.test(last)) {
    return true;
  }
  return false;
}
function parseOpaqueHost(input) {
  if (containsForbiddenHostCodePoint(input)) {
    return failure;
  }
  return utf8PercentEncodeString(input, isC0ControlPercentEncode);
}
function findLongestZeroSequence(arr) {
  let maxIdx = null;
  let maxLen = 1;
  let currStart = null;
  let currLen = 0;
  for (let i5 = 0; i5 < arr.length; ++i5) {
    if (arr[i5] !== 0) {
      if (currLen > maxLen) {
        maxIdx = currStart;
        maxLen = currLen;
      }
      currStart = null;
      currLen = 0;
    } else {
      if (currStart === null) {
        currStart = i5;
      }
      ++currLen;
    }
  }
  if (currLen > maxLen) {
    return currStart;
  }
  return maxIdx;
}
function serializeHost(host) {
  if (typeof host === "number") {
    return serializeIPv4(host);
  }
  if (host instanceof Array) {
    return `[${serializeIPv6(host)}]`;
  }
  return host;
}
function domainToASCII(domain, beStrict = false) {
  let result;
  try {
    result = punycode.toASCII(domain);
  } catch (e5) {
    return failure;
  }
  if (result === null || result === "") {
    return failure;
  }
  return result;
}
function trimControlChars(url) {
  return url.replace(/^[\u0000-\u001F\u0020]+|[\u0000-\u001F\u0020]+$/gu, "");
}
function trimTabAndNewline(url) {
  return url.replace(/\u0009|\u000A|\u000D/gu, "");
}
function shortenPath(url) {
  const { path } = url;
  if (path.length === 0) {
    return;
  }
  if (url.scheme === "file" && path.length === 1 && isNormalizedWindowsDriveLetter(path[0])) {
    return;
  }
  path.pop();
}
function includesCredentials(url) {
  return url.username !== "" || url.password !== "";
}
function cannotHaveAUsernamePasswordPort(url) {
  return url.host === null || url.host === "" || url.scheme === "file";
}
function hasAnOpaquePath(url) {
  return typeof url.path === "string";
}
function isNormalizedWindowsDriveLetter(string) {
  return /^[A-Za-z]:$/u.test(string);
}
var URLStateMachine = class {
  constructor(input, base2, encodingOverride, url, stateOverride) {
    this.table = {
      "parse scheme start": this.parseSchemeStart,
      "parse scheme": this.parseScheme,
      "parse no scheme": this.parseNoScheme,
      "parse special relative or authority": this.parseSpecialRelativeOrAuthority,
      "parse path or authority": this.parsePathOrAuthority,
      "parse relative": this.parseRelative,
      "parse relative slash": this.parseRelativeSlash,
      "parse special authority slashes": this.parseSpecialAuthoritySlashes,
      "parse special authority ignore slashes": this.parseSpecialAuthorityIgnoreSlashes,
      "parse authority": this.parseAuthority,
      "parse host": this.parseHostName,
      "parse hostname": this.parseHostName,
      "parse port": this.parsePort,
      "parse file": this.parseFile,
      "parse file slash": this.parseFileSlash,
      "parse file host": this.parseFileHost,
      "parse path start": this.parsePathStart,
      "parse path": this.parsePath,
      "parse opaque path": this.parseOpaquePath,
      "parse query": this.parseQuery,
      "parse fragment": this.parseFragment
    };
    this.pointer = 0;
    this.base = base2 || null;
    this.encodingOverride = encodingOverride || "utf-8";
    this.url = url;
    this.failure = false;
    this.parseError = false;
    if (!this.url) {
      this.url = {
        scheme: "",
        username: "",
        password: "",
        host: null,
        port: null,
        path: [],
        query: null,
        fragment: null
      };
      const res2 = trimControlChars(input);
      if (res2 !== input) {
        this.parseError = true;
      }
      input = res2;
    }
    const res = trimTabAndNewline(input);
    if (res !== input) {
      this.parseError = true;
    }
    input = res;
    this.state = stateOverride || "scheme start";
    this.buffer = "";
    this.atFlag = false;
    this.arrFlag = false;
    this.passwordTokenSeenFlag = false;
    this.input = Array.from(input, (c5) => c5.codePointAt(0));
    for (; this.pointer <= this.input.length; ++this.pointer) {
      const c5 = this.input[this.pointer];
      const cStr = isNaN(c5) ? void 0 : String.fromCodePoint(c5);
      const ret = this.table[`parse ${this.state}`].call(this, c5, cStr);
      if (!ret) {
        break;
      } else if (ret === failure) {
        this.failure = true;
        break;
      }
    }
  }
  parseSchemeStart(c5, cStr) {
    if (isASCIIAlpha(c5)) {
      this.buffer += cStr.toLowerCase();
      this.state = "scheme";
    } else if (!this.stateOverride) {
      this.state = "no scheme";
      --this.pointer;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseScheme(c5, cStr) {
    if (isASCIIAlphanumeric(c5) || c5 === p("+") || c5 === p("-") || c5 === p(".")) {
      this.buffer += cStr.toLowerCase();
    } else if (c5 === p(":")) {
      if (this.stateOverride) {
        if (isSpecial(this.url) && !isSpecialScheme(this.buffer)) {
          return false;
        }
        if (!isSpecial(this.url) && isSpecialScheme(this.buffer)) {
          return false;
        }
        if ((includesCredentials(this.url) || this.url.port !== null) && this.buffer === "file") {
          return false;
        }
        if (this.url.scheme === "file" && this.url.host === "") {
          return false;
        }
      }
      this.url.scheme = this.buffer;
      if (this.stateOverride) {
        if (this.url.port === defaultPort(this.url.scheme)) {
          this.url.port = null;
        }
        return false;
      }
      this.buffer = "";
      if (this.url.scheme === "file") {
        if (this.input[this.pointer + 1] !== p("/") || this.input[this.pointer + 2] !== p("/")) {
          this.parseError = true;
        }
        this.state = "file";
      } else if (isSpecial(this.url) && this.base !== null && this.base.scheme === this.url.scheme) {
        this.state = "special relative or authority";
      } else if (isSpecial(this.url)) {
        this.state = "special authority slashes";
      } else if (this.input[this.pointer + 1] === p("/")) {
        this.state = "path or authority";
        ++this.pointer;
      } else {
        this.url.path = [""];
        this.state = "opaque path";
      }
    } else if (!this.stateOverride) {
      this.buffer = "";
      this.state = "no scheme";
      this.pointer = -1;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseNoScheme(c5) {
    if (this.base === null || hasAnOpaquePath(this.base) && c5 !== p("#")) {
      return failure;
    } else if (hasAnOpaquePath(this.base) && c5 === p("#")) {
      this.url.scheme = this.base.scheme;
      this.url.path = this.base.path;
      this.url.query = this.base.query;
      this.url.fragment = "";
      this.state = "fragment";
    } else if (this.base.scheme === "file") {
      this.state = "file";
      --this.pointer;
    } else {
      this.state = "relative";
      --this.pointer;
    }
    return true;
  }
  parseSpecialRelativeOrAuthority(c5) {
    if (c5 === p("/") && this.input[this.pointer + 1] === p("/")) {
      this.state = "special authority ignore slashes";
      ++this.pointer;
    } else {
      this.parseError = true;
      this.state = "relative";
      --this.pointer;
    }
    return true;
  }
  parsePathOrAuthority(c5) {
    if (c5 === p("/")) {
      this.state = "authority";
    } else {
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseRelative(c5) {
    this.url.scheme = this.base.scheme;
    if (c5 === p("/")) {
      this.state = "relative slash";
    } else if (isSpecial(this.url) && c5 === p("\\")) {
      this.parseError = true;
      this.state = "relative slash";
    } else {
      this.url.username = this.base.username;
      this.url.password = this.base.password;
      this.url.host = this.base.host;
      this.url.port = this.base.port;
      this.url.path = this.base.path.slice();
      this.url.query = this.base.query;
      if (c5 === p("?")) {
        this.url.query = "";
        this.state = "query";
      } else if (c5 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      } else if (!isNaN(c5)) {
        this.url.query = null;
        this.url.path.pop();
        this.state = "path";
        --this.pointer;
      }
    }
    return true;
  }
  parseRelativeSlash(c5) {
    if (isSpecial(this.url) && (c5 === p("/") || c5 === p("\\"))) {
      if (c5 === p("\\")) {
        this.parseError = true;
      }
      this.state = "special authority ignore slashes";
    } else if (c5 === p("/")) {
      this.state = "authority";
    } else {
      this.url.username = this.base.username;
      this.url.password = this.base.password;
      this.url.host = this.base.host;
      this.url.port = this.base.port;
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseSpecialAuthoritySlashes(c5) {
    if (c5 === p("/") && this.input[this.pointer + 1] === p("/")) {
      this.state = "special authority ignore slashes";
      ++this.pointer;
    } else {
      this.parseError = true;
      this.state = "special authority ignore slashes";
      --this.pointer;
    }
    return true;
  }
  parseSpecialAuthorityIgnoreSlashes(c5) {
    if (c5 !== p("/") && c5 !== p("\\")) {
      this.state = "authority";
      --this.pointer;
    } else {
      this.parseError = true;
    }
    return true;
  }
  parseAuthority(c5, cStr) {
    if (c5 === p("@")) {
      this.parseError = true;
      if (this.atFlag) {
        this.buffer = `%40${this.buffer}`;
      }
      this.atFlag = true;
      const len = countSymbols(this.buffer);
      for (let pointer = 0; pointer < len; ++pointer) {
        const codePoint = this.buffer.codePointAt(pointer);
        if (codePoint === p(":") && !this.passwordTokenSeenFlag) {
          this.passwordTokenSeenFlag = true;
          continue;
        }
        const encodedCodePoints = utf8PercentEncodeCodePoint(codePoint, isUserinfoPercentEncode);
        if (this.passwordTokenSeenFlag) {
          this.url.password += encodedCodePoints;
        } else {
          this.url.username += encodedCodePoints;
        }
      }
      this.buffer = "";
    } else if (isNaN(c5) || c5 === p("/") || c5 === p("?") || c5 === p("#") || isSpecial(this.url) && c5 === p("\\")) {
      if (this.atFlag && this.buffer === "") {
        this.parseError = true;
        return failure;
      }
      this.pointer -= countSymbols(this.buffer) + 1;
      this.buffer = "";
      this.state = "host";
    } else {
      this.buffer += cStr;
    }
    return true;
  }
  parseHostName(c5, cStr) {
    if (this.stateOverride && this.url.scheme === "file") {
      --this.pointer;
      this.state = "file host";
    } else if (c5 === p(":") && !this.arrFlag) {
      if (this.buffer === "") {
        this.parseError = true;
        return failure;
      }
      if (this.stateOverride === "hostname") {
        return false;
      }
      const host = parseHost(this.buffer, isNotSpecial(this.url));
      if (host === failure) {
        return failure;
      }
      this.url.host = host;
      this.buffer = "";
      this.state = "port";
    } else if (isNaN(c5) || c5 === p("/") || c5 === p("?") || c5 === p("#") || isSpecial(this.url) && c5 === p("\\")) {
      --this.pointer;
      if (isSpecial(this.url) && this.buffer === "") {
        this.parseError = true;
        return failure;
      } else if (this.stateOverride && this.buffer === "" && (includesCredentials(this.url) || this.url.port !== null)) {
        this.parseError = true;
        return false;
      }
      const host = parseHost(this.buffer, isNotSpecial(this.url));
      if (host === failure) {
        return failure;
      }
      this.url.host = host;
      this.buffer = "";
      this.state = "path start";
      if (this.stateOverride) {
        return false;
      }
    } else {
      if (c5 === p("[")) {
        this.arrFlag = true;
      } else if (c5 === p("]")) {
        this.arrFlag = false;
      }
      this.buffer += cStr;
    }
    return true;
  }
  parsePort(c5, cStr) {
    if (isASCIIDigit(c5)) {
      this.buffer += cStr;
    } else if (isNaN(c5) || c5 === p("/") || c5 === p("?") || c5 === p("#") || isSpecial(this.url) && c5 === p("\\") || this.stateOverride) {
      if (this.buffer !== "") {
        const port = parseInt(this.buffer);
        if (port > 2 ** 16 - 1) {
          this.parseError = true;
          return failure;
        }
        this.url.port = port === defaultPort(this.url.scheme) ? null : port;
        this.buffer = "";
      }
      if (this.stateOverride) {
        return false;
      }
      this.state = "path start";
      --this.pointer;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseFile(c5) {
    this.url.scheme = "file";
    this.url.host = "";
    if (c5 === p("/") || c5 === p("\\")) {
      if (c5 === p("\\")) {
        this.parseError = true;
      }
      this.state = "file slash";
    } else if (this.base !== null && this.base.scheme === "file") {
      this.url.host = this.base.host;
      this.url.path = this.base.path.slice();
      this.url.query = this.base.query;
      if (c5 === p("?")) {
        this.url.query = "";
        this.state = "query";
      } else if (c5 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      } else if (!isNaN(c5)) {
        this.url.query = null;
        if (!startsWithWindowsDriveLetter(this.input, this.pointer)) {
          shortenPath(this.url);
        } else {
          this.parseError = true;
          this.url.path = [];
        }
        this.state = "path";
        --this.pointer;
      }
    } else {
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseFileSlash(c5) {
    if (c5 === p("/") || c5 === p("\\")) {
      if (c5 === p("\\")) {
        this.parseError = true;
      }
      this.state = "file host";
    } else {
      if (this.base !== null && this.base.scheme === "file") {
        if (!startsWithWindowsDriveLetter(this.input, this.pointer) && isNormalizedWindowsDriveLetterString(this.base.path[0])) {
          this.url.path.push(this.base.path[0]);
        }
        this.url.host = this.base.host;
      }
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseFileHost(c5, cStr) {
    if (isNaN(c5) || c5 === p("/") || c5 === p("\\") || c5 === p("?") || c5 === p("#")) {
      --this.pointer;
      if (!this.stateOverride && isWindowsDriveLetterString(this.buffer)) {
        this.parseError = true;
        this.state = "path";
      } else if (this.buffer === "") {
        this.url.host = "";
        if (this.stateOverride) {
          return false;
        }
        this.state = "path start";
      } else {
        let host = parseHost(this.buffer, isNotSpecial(this.url));
        if (host === failure) {
          return failure;
        }
        if (host === "localhost") {
          host = "";
        }
        this.url.host = host;
        if (this.stateOverride) {
          return false;
        }
        this.buffer = "";
        this.state = "path start";
      }
    } else {
      this.buffer += cStr;
    }
    return true;
  }
  parsePathStart(c5) {
    if (isSpecial(this.url)) {
      if (c5 === p("\\")) {
        this.parseError = true;
      }
      this.state = "path";
      if (c5 !== p("/") && c5 !== p("\\")) {
        --this.pointer;
      }
    } else if (!this.stateOverride && c5 === p("?")) {
      this.url.query = "";
      this.state = "query";
    } else if (!this.stateOverride && c5 === p("#")) {
      this.url.fragment = "";
      this.state = "fragment";
    } else if (c5 !== void 0) {
      this.state = "path";
      if (c5 !== p("/")) {
        --this.pointer;
      }
    } else if (this.stateOverride && this.url.host === null) {
      this.url.path.push("");
    }
    return true;
  }
  parsePath(c5) {
    if (isNaN(c5) || c5 === p("/") || isSpecial(this.url) && c5 === p("\\") || !this.stateOverride && (c5 === p("?") || c5 === p("#"))) {
      if (isSpecial(this.url) && c5 === p("\\")) {
        this.parseError = true;
      }
      if (isDoubleDot(this.buffer)) {
        shortenPath(this.url);
        if (c5 !== p("/") && !(isSpecial(this.url) && c5 === p("\\"))) {
          this.url.path.push("");
        }
      } else if (isSingleDot(this.buffer) && c5 !== p("/") && !(isSpecial(this.url) && c5 === p("\\"))) {
        this.url.path.push("");
      } else if (!isSingleDot(this.buffer)) {
        if (this.url.scheme === "file" && this.url.path.length === 0 && isWindowsDriveLetterString(this.buffer)) {
          this.buffer = `${this.buffer[0]}:`;
        }
        this.url.path.push(this.buffer);
      }
      this.buffer = "";
      if (c5 === p("?")) {
        this.url.query = "";
        this.state = "query";
      }
      if (c5 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      }
    } else {
      if (c5 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.buffer += utf8PercentEncodeCodePoint(c5, isPathPercentEncode);
    }
    return true;
  }
  parseOpaquePath(c5) {
    if (c5 === p("?")) {
      this.url.query = "";
      this.state = "query";
    } else if (c5 === p("#")) {
      this.url.fragment = "";
      this.state = "fragment";
    } else {
      if (!isNaN(c5) && c5 !== p("%")) {
        this.parseError = true;
      }
      if (c5 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      if (!isNaN(c5)) {
        this.url.path += utf8PercentEncodeCodePoint(c5, isC0ControlPercentEncode);
      }
    }
    return true;
  }
  parseQuery(c5, cStr) {
    if (!isSpecial(this.url) || this.url.scheme === "ws" || this.url.scheme === "wss") {
      this.encodingOverride = "utf-8";
    }
    if (!this.stateOverride && c5 === p("#") || isNaN(c5)) {
      const queryPercentEncodePredicate = isSpecial(this.url) ? isSpecialQueryPercentEncode : isQueryPercentEncode;
      this.url.query += utf8PercentEncodeString(this.buffer, queryPercentEncodePredicate);
      this.buffer = "";
      if (c5 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      }
    } else if (!isNaN(c5)) {
      if (c5 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.buffer += cStr;
    }
    return true;
  }
  parseFragment(c5) {
    if (!isNaN(c5)) {
      if (c5 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.url.fragment += utf8PercentEncodeCodePoint(c5, isFragmentPercentEncode);
    }
    return true;
  }
};
var fileOtherwiseCodePoints = /* @__PURE__ */ new Set([p("/"), p("\\"), p("?"), p("#")]);
function startsWithWindowsDriveLetter(input, pointer) {
  const length = input.length - pointer;
  return length >= 2 && isWindowsDriveLetterCodePoints(input[pointer], input[pointer + 1]) && (length === 2 || fileOtherwiseCodePoints.has(input[pointer + 2]));
}
function serializeURL(url, excludeFragment) {
  let output = `${url.scheme}:`;
  if (url.host !== null) {
    output += "//";
    if (url.username !== "" || url.password !== "") {
      output += url.username;
      if (url.password !== "") {
        output += `:${url.password}`;
      }
      output += "@";
    }
    output += serializeHost(url.host);
    if (url.port !== null) {
      output += `:${url.port}`;
    }
  }
  if (url.host === null && !hasAnOpaquePath(url) && url.path.length > 1 && url.path[0] === "") {
    output += "/.";
  }
  output += serializePath(url);
  if (url.query !== null) {
    output += `?${url.query}`;
  }
  if (!excludeFragment && url.fragment !== null) {
    output += `#${url.fragment}`;
  }
  return output;
}
function serializeOrigin(tuple) {
  let result = `${tuple.scheme}://`;
  result += serializeHost(tuple.host);
  if (tuple.port !== null) {
    result += `:${tuple.port}`;
  }
  return result;
}
function serializePath(url) {
  if (typeof url.path === "string") {
    return url.path;
  }
  let output = "";
  for (const segment of url.path) {
    output += `/${segment}`;
  }
  return output;
}
function serializeURLOrigin(url) {
  switch (url.scheme) {
    case "blob":
      try {
        return serializeURLOrigin(parseURL(serializePath(url)));
      } catch (e5) {
        return "null";
      }
    case "ftp":
    case "http":
    case "https":
    case "ws":
    case "wss":
      return serializeOrigin({
        scheme: url.scheme,
        host: url.host,
        port: url.port
      });
    case "file":
      return "null";
    default:
      return "null";
  }
}
function basicURLParse(input, options) {
  if (options === void 0) {
    options = {};
  }
  const usm = new URLStateMachine(input, options.baseURL, options.encodingOverride, options.url, options.stateOverride);
  if (usm.failure) {
    return null;
  }
  return usm.url;
}
function setTheUsername(url, username) {
  url.username = utf8PercentEncodeString(username, isUserinfoPercentEncode);
}
function setThePassword(url, password) {
  url.password = utf8PercentEncodeString(password, isUserinfoPercentEncode);
}
function serializeInteger(integer) {
  return String(integer);
}
function parseURL(input, options) {
  if (options === void 0) {
    options = {};
  }
  return basicURLParse(input, {
    baseURL: options.baseURL,
    encodingOverride: options.encodingOverride
  });
}
var NativeURL = typeof URL !== "undefined" ? URL : void 0;
var URLImpl = class {
  //Include URL type for "url" and "base" params.
  constructor(url, base2) {
    let parsedBase = null;
    if (base2 !== void 0) {
      if (base2 instanceof URL) {
        base2 = base2.href;
      }
      parsedBase = basicURLParse(base2);
      if (parsedBase === null) {
        throw new TypeError(`Invalid base URL: ${base2}`);
      }
    }
    if (url instanceof URL) {
      url = url.href;
    }
    const parsedURL = basicURLParse(url, { baseURL: parsedBase });
    if (parsedURL === null) {
      throw new TypeError(`Invalid URL: ${url}`);
    }
    const query = parsedURL.query !== null ? parsedURL.query : "";
    this._url = parsedURL;
    this._query = new URLSearchParamsImpl(query, {
      doNotStripQMark: true
    });
    this._query._url = this;
  }
  get href() {
    return serializeURL(this._url);
  }
  set href(v3) {
    const parsedURL = basicURLParse(v3);
    if (parsedURL === null) {
      throw new TypeError(`Invalid URL: ${v3}`);
    }
    this._url = parsedURL;
    this._query._list.splice(0);
    const { query } = parsedURL;
    if (query !== null) {
      this._query._list = parseUrlencodedString(query);
    }
  }
  get origin() {
    return serializeURLOrigin(this._url);
  }
  get protocol() {
    return `${this._url.scheme}:`;
  }
  set protocol(v3) {
    basicURLParse(`${v3}:`, {
      url: this._url,
      stateOverride: "scheme start"
    });
  }
  get username() {
    return this._url.username;
  }
  set username(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    setTheUsername(this._url, v3);
  }
  get password() {
    return this._url.password;
  }
  set password(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    setThePassword(this._url, v3);
  }
  get host() {
    const url = this._url;
    if (url.host === null) {
      return "";
    }
    if (url.port === null) {
      return serializeHost(url.host);
    }
    return `${serializeHost(url.host)}:${serializeInteger(url.port)}`;
  }
  set host(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    basicURLParse(v3, { url: this._url, stateOverride: "host" });
  }
  get hostname() {
    if (this._url.host === null) {
      return "";
    }
    return serializeHost(this._url.host);
  }
  set hostname(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    basicURLParse(v3, { url: this._url, stateOverride: "hostname" });
  }
  get port() {
    if (this._url.port === null) {
      return "";
    }
    return serializeInteger(this._url.port);
  }
  set port(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    if (v3 === "") {
      this._url.port = null;
    } else {
      basicURLParse(v3, { url: this._url, stateOverride: "port" });
    }
  }
  get pathname() {
    return serializePath(this._url);
  }
  set pathname(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    this._url.path = [];
    basicURLParse(v3, { url: this._url, stateOverride: "path start" });
  }
  get search() {
    if (this._url.query === null || this._url.query === "") {
      return "";
    }
    return `?${this._url.query}`;
  }
  set search(v3) {
    const url = this._url;
    if (v3 === "") {
      url.query = null;
      this._query._list = [];
      return;
    }
    const input = v3[0] === "?" ? v3.substring(1) : v3;
    url.query = "";
    basicURLParse(input, { url, stateOverride: "query" });
    this._query._list = parseUrlencodedString(input);
  }
  get searchParams() {
    return this._query;
  }
  get hash() {
    if (this._url.fragment === null || this._url.fragment === "") {
      return "";
    }
    return `#${this._url.fragment}`;
  }
  set hash(v3) {
    if (v3 === "") {
      this._url.fragment = null;
      return;
    }
    const input = v3[0] === "#" ? v3.substring(1) : v3;
    this._url.fragment = "";
    basicURLParse(input, { url: this._url, stateOverride: "fragment" });
  }
  toJSON() {
    return this.href;
  }
  static createObjectURL(blob) {
    if (!NativeURL)
      throw new Error("This method requires a native implementation, which does not exist");
    return NativeURL.createObjectURL(blob);
  }
  static revokeObjectURL(url) {
    if (!NativeURL)
      throw new Error("This method requires a native implementation, which does not exist");
    return NativeURL.revokeObjectURL(url);
  }
};

// ../taler-util/lib/url.js
(function() {
  if (typeof globalThis === "object")
    return;
  Object.defineProperty(Object.prototype, "__magic__", {
    get: function() {
      return this;
    },
    configurable: true
    // This makes it possible to `delete` the getter later.
  });
  __magic__.globalThis = __magic__;
  delete Object.prototype.__magic__;
})();
var useOwnUrlImp = true;
var _URL = globalThis.URL;
if (useOwnUrlImp || !_URL) {
  globalThis.URL = _URL = URLImpl;
  _URL = URLImpl;
}
var URL2 = _URL;
var _URLSearchParams = globalThis.URLSearchParams;
if (useOwnUrlImp || !_URLSearchParams) {
  globalThis.URLSearchParams = URLSearchParamsImpl;
  _URLSearchParams = URLSearchParamsImpl;
}
var URLSearchParams2 = _URLSearchParams;

// ../taler-util/lib/helpers.js
function canonicalizeBaseUrl(url) {
  if (!url.startsWith("http") && !url.startsWith("https")) {
    url = "https://" + url;
  }
  const x6 = new URL2(url);
  if (!x6.pathname.endsWith("/")) {
    x6.pathname = x6.pathname + "/";
  }
  x6.search = "";
  x6.hash = "";
  return x6.href;
}
function canonicalJson(obj) {
  obj = JSON.parse(JSON.stringify(obj));
  if (typeof obj === "string") {
    return JSON.stringify(obj);
  }
  if (typeof obj === "number" || typeof obj === "boolean" || obj === null) {
    return JSON.stringify(obj);
  }
  if (Array.isArray(obj)) {
    const objs = obj.map((e5) => canonicalJson(e5));
    return `[${objs.join(",")}]`;
  }
  const keys = [];
  for (const key in obj) {
    keys.push(key);
  }
  keys.sort();
  let s6 = "{";
  for (let i5 = 0; i5 < keys.length; i5++) {
    const key = keys[i5];
    s6 += JSON.stringify(key) + ":" + canonicalJson(obj[key]);
    if (i5 !== keys.length - 1) {
      s6 += ",";
    }
  }
  return s6 + "}";
}
function strcmp(s1, s23) {
  if (s1 < s23) {
    return -1;
  }
  if (s1 > s23) {
    return 1;
  }
  return 0;
}
function j2s(x6) {
  return JSON.stringify(x6, void 0, 2);
}

// ../taler-util/lib/logging.js
var isNode = typeof process !== "undefined" && typeof process.release !== "undefined" && process.release.name === "node";
var LogLevel;
(function(LogLevel2) {
  LogLevel2["Trace"] = "trace";
  LogLevel2["Message"] = "message";
  LogLevel2["Info"] = "info";
  LogLevel2["Warn"] = "warn";
  LogLevel2["Error"] = "error";
  LogLevel2["None"] = "none";
})(LogLevel || (LogLevel = {}));
var globalLogLevel = LogLevel.Info;
var byTagLogLevel = {};
var nativeLogging = false;
Error.prototype.toString = function() {
  if (this === null || typeof this !== "object" && typeof this !== "function") {
    throw new TypeError();
  }
  let name = this.name;
  name = name === void 0 ? "Error" : `${name}`;
  let msg = this.message;
  msg = msg === void 0 ? "" : `${msg}`;
  let cause = "";
  if ("cause" in this) {
    cause = `
 Caused by: ${this.cause}`;
  }
  return `${name}: ${msg}${cause}`;
};
function writeNativeLog(message, tag, level, args) {
  const logFn = globalThis.__nativeLog;
  if (logFn) {
    let m6;
    if (args.length == 0) {
      m6 = message;
    } else {
      m6 = message + " " + args.toString();
    }
    logFn(level, tag, message);
  }
}
function writeNodeLog(message, tag, level, args) {
  try {
    let msg = `${(/* @__PURE__ */ new Date()).toISOString()} ${tag} ${level} ${message}`;
    if (args.length != 0) {
      msg += ` ${JSON.stringify(args, void 0, 2)}
`;
    } else {
      msg += `
`;
    }
    process.stderr.write(msg);
  } catch (e5) {
    let msg = `${(/* @__PURE__ */ new Date()).toISOString()} (logger) FATAL `;
    if (e5 instanceof Error) {
      msg += `failed to write log: ${e5.message}
`;
    } else {
      msg += "failed to write log\n";
    }
    process.stderr.write(msg);
  }
}
var Logger = class {
  constructor(tag) {
    this.tag = tag;
  }
  getGlobalLogLevel() {
    return globalLogLevel;
  }
  shouldLogTrace() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
        return true;
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogInfo() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
        return true;
      case LogLevel.Warn:
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogWarn() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
        return true;
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogError() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
      case LogLevel.Error:
        return true;
      case LogLevel.None:
        return false;
    }
  }
  info(message, ...args) {
    if (!this.shouldLogInfo()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 2, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "INFO", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} INFO ` + message, ...args);
    }
  }
  warn(message, ...args) {
    if (!this.shouldLogWarn()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 3, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "WARN", args);
    } else {
      console.warn(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} INFO ` + message, ...args);
    }
  }
  error(message, ...args) {
    if (!this.shouldLogError()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 4, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "ERROR", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} ERROR ` + message, ...args);
    }
  }
  trace(message, ...args) {
    if (!this.shouldLogTrace()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 1, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "TRACE", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} TRACE ` + message, ...args);
    }
  }
  reportBreak() {
    if (!this.shouldLogError()) {
      return;
    }
    const location2 = new Error("programming error");
    this.error(`assertion failed: ${location2.stack}`);
  }
};

// ../taler-util/lib/codec.js
var logger = new Logger("codec.ts");
var DecodingError = class _DecodingError extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, _DecodingError.prototype);
    this.name = "DecodingError";
  }
};
function renderContext(c5) {
  const p4 = c5?.path;
  if (p4) {
    return p4.join(".");
  } else {
    return "(unknown)";
  }
}
function joinContext(c5, part) {
  const path = c5?.path ?? [];
  return {
    path: path.concat([part])
  };
}
var ObjectCodecBuilder = class {
  constructor() {
    this.propList = [];
    this.deprecatedProps = /* @__PURE__ */ new Set();
    this._allowExtra = false;
  }
  /**
   * Define a property for the object.
   */
  property(x6, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.propList.push({ name: x6, codec });
    return this;
  }
  /**
   * Define a property for the object.
   */
  propertyStrict(x6, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.propList.push({ name: x6, codec });
    return this;
  }
  /**
   * Concatenate properties from @a codec.
   *
   * @param other codec to concat properties from
   *
   * FIXME: do proper union of all `other' props.
   */
  mixin(other) {
    this.propList.push(...other.getProps());
    return this;
  }
  /**
   * Define a deprecated property for the object.
   *
   * Deprecated properties won't be validated, their presence will
   * be validated in TRACE mode.
   */
  deprecatedProperty(x6) {
    this.deprecatedProps.add(x6);
    return this;
  }
  /**
   * Do not log warnings if the object has extra properties.
   */
  allowExtra() {
    this._allowExtra = true;
    return this;
  }
  /**
   * Return the built codec.
   *
   * @param objectDisplayName name of the object that this codec operates on,
   *   used in error messages.
   */
  build(objectDisplayName) {
    const propList = this.propList;
    const allowExtra = this._allowExtra;
    const deprecatedPros = this.deprecatedProps;
    return {
      decode(x6, c5) {
        if (!c5) {
          c5 = {
            path: [`(${objectDisplayName})`]
          };
        }
        if (typeof x6 !== "object") {
          throw new DecodingError(`expected object for ${objectDisplayName} at ${renderContext(c5)} but got ${typeof x6}`);
        }
        const obj = {};
        for (const prop of propList) {
          const propRawVal = x6[prop.name];
          const propVal = prop.codec.decode(propRawVal, joinContext(c5, prop.name));
          obj[prop.name] = propVal;
        }
        for (const prop in x6) {
          if (prop in obj) {
            continue;
          }
          if (allowExtra) {
            obj[prop] = x6[prop];
          } else if (deprecatedPros.has(prop)) {
            logger.trace(`Deprecated property ${prop} for ${objectDisplayName} at ${renderContext(c5)}`);
          } else {
            logger.warn(`Extra property ${prop} for ${objectDisplayName} at ${renderContext(c5)}`);
          }
        }
        return obj;
      },
      getProps() {
        return propList;
      }
    };
  }
};
var UnionCodecBuilder = class {
  constructor(discriminator, baseCodec) {
    this.discriminator = discriminator;
    this.baseCodec = baseCodec;
    this.alternatives = /* @__PURE__ */ new Map();
  }
  /**
   * Define a property for the object.
   */
  alternative(tagValue, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.alternatives.set(tagValue, { codec, tagValue });
    return this;
  }
  /**
   * Return the built codec.
   *
   * @param objectDisplayName name of the object that this codec operates on,
   *   used in error messages.
   */
  build(objectDisplayName) {
    const alternatives = this.alternatives;
    const discriminator = this.discriminator;
    const baseCodec = this.baseCodec;
    return {
      decode(x6, c5) {
        if (!c5) {
          c5 = {
            path: [`(${objectDisplayName})`]
          };
        }
        const d6 = x6[discriminator];
        if (d6 === void 0 && !alternatives.has(d6)) {
          throw new DecodingError(`expected tag for ${objectDisplayName} at ${renderContext(c5)}.${String(discriminator)}`);
        }
        const alt = alternatives.get(d6);
        if (!alt) {
          throw new DecodingError(`unknown tag for ${objectDisplayName} ${d6} at ${renderContext(c5)}.${String(discriminator)}`);
        }
        const altDecoded = alt.codec.decode(x6);
        if (baseCodec) {
          const baseDecoded = baseCodec.decode(x6, c5);
          return { ...baseDecoded, ...altDecoded };
        } else {
          return altDecoded;
        }
      }
    };
  }
};
var UnionCodecPreBuilder = class {
  discriminateOn(discriminator, baseCodec) {
    return new UnionCodecBuilder(discriminator, baseCodec);
  }
};
function buildCodecForObject() {
  return new ObjectCodecBuilder();
}
function buildCodecForUnion() {
  return new UnionCodecPreBuilder();
}
function codecForMap(innerCodec) {
  if (!innerCodec) {
    throw Error("inner codec must be defined");
  }
  return {
    decode(x6, c5) {
      const map2 = {};
      if (typeof x6 !== "object") {
        throw new DecodingError(`expected object at ${renderContext(c5)}`);
      }
      for (const i5 in x6) {
        map2[i5] = innerCodec.decode(x6[i5], joinContext(c5, `[${i5}]`));
      }
      return map2;
    }
  };
}
function codecForList(innerCodec) {
  if (!innerCodec) {
    throw Error("inner codec must be defined");
  }
  return {
    decode(x6, c5) {
      const arr = [];
      if (!Array.isArray(x6)) {
        throw new DecodingError(`expected array at ${renderContext(c5)}`);
      }
      for (const i5 in x6) {
        arr.push(innerCodec.decode(x6[i5], joinContext(c5, `[${i5}]`)));
      }
      return arr;
    }
  };
}
function codecForNumber() {
  return {
    decode(x6, c5) {
      if (typeof x6 === "number") {
        return x6;
      }
      throw new DecodingError(`expected number at ${renderContext(c5)} but got ${typeof x6}`);
    }
  };
}
function codecForBoolean() {
  return {
    decode(x6, c5) {
      if (typeof x6 === "boolean") {
        return x6;
      }
      throw new DecodingError(`expected boolean at ${renderContext(c5)} but got ${typeof x6}`);
    }
  };
}
function codecForString() {
  return {
    decode(x6, c5) {
      if (typeof x6 === "string") {
        return x6;
      }
      throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
    }
  };
}
function codecForStringURL(shouldEndWithSlash) {
  return {
    decode(x6, c5) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
      }
      if (shouldEndWithSlash && !x6.endsWith("/")) {
        throw new DecodingError(`expected URL string that ends with slash at ${renderContext(c5)} but got ${x6}`);
      }
      try {
        const url = new URL(x6);
        return x6;
      } catch (e5) {
        if (e5 instanceof Error) {
          throw new DecodingError(e5.message);
        } else {
          throw new DecodingError(`expected an URL string at ${renderContext(c5)} but got "${x6}"`);
        }
      }
    }
  };
}
function codecForURL(shouldEndWithSlash) {
  return {
    decode(x6, c5) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
      }
      if (shouldEndWithSlash && !x6.endsWith("/")) {
        throw new DecodingError(`expected URL string that ends with slash at ${renderContext(c5)} but got ${x6}`);
      }
      try {
        const url = new URL(x6);
        return url;
      } catch (e5) {
        if (e5 instanceof Error) {
          throw new DecodingError(e5.message);
        } else {
          throw new DecodingError(`expected an URL string at ${renderContext(c5)} but got "${x6}"`);
        }
      }
    }
  };
}
function codecForAny() {
  return {
    decode(x6, c5) {
      return x6;
    }
  };
}
function codecForConstString(s6) {
  return {
    decode(x6, c5) {
      if (x6 === s6) {
        return x6;
      }
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string constant "${s6}" at ${renderContext(c5)} but got ${typeof x6}`);
      }
      throw new DecodingError(`expected string constant "${s6}" at ${renderContext(c5)} but got string value "${x6}"`);
    }
  };
}
function codecForConstNumber(n2) {
  return {
    decode(x6, c5) {
      if (x6 === n2) {
        return x6;
      }
      throw new DecodingError(`expected number constant "${n2}" at ${renderContext(c5)}  but got ${typeof x6}`);
    }
  };
}
function codecOptional(innerCodec) {
  return {
    decode(x6, c5) {
      if (x6 === void 0 || x6 === null) {
        return void 0;
      }
      return innerCodec.decode(x6, c5);
    }
  };
}
function codecOptionalDefault(innerCodec, def) {
  return {
    decode(x6, c5) {
      if (x6 === void 0 || x6 === null) {
        return def;
      }
      return innerCodec.decode(x6, c5);
    }
  };
}
function codecForEither(...alts) {
  return {
    decode(x6, c5) {
      for (const alt of alts) {
        try {
          return alt.decode(x6, c5);
        } catch (e5) {
          continue;
        }
      }
      if (logger.shouldLogTrace()) {
        logger.trace(`offending value: ${j2s(x6)}`);
      }
      throw new DecodingError(`No alternative matched at ${renderContext(c5)}`);
    }
  };
}

// ../taler-util/lib/errors.js
function makeErrorDetail(code, detail, hint) {
  if (!hint && !detail.hint) {
    hint = getDefaultTalerErrorHint(code);
  }
  const when = AbsoluteTime.now();
  return { code, when, hint, ...detail };
}
function getDefaultTalerErrorHint(code) {
  const errName = TalerErrorCode[code];
  if (errName) {
    return `Error (${errName})`;
  } else {
    return `Error (<unknown>)`;
  }
}
var TalerError = class _TalerError extends Error {
  constructor(d6, cause) {
    super(d6.hint ?? `Error (code ${d6.code})`);
    this.errorDetail = d6;
    this.cause = cause;
    Object.setPrototypeOf(this, _TalerError.prototype);
  }
  static fromDetail(code, detail, hint, cause) {
    if (!hint) {
      hint = getDefaultTalerErrorHint(code);
    }
    const when = AbsoluteTime.now();
    return new _TalerError({ code, when, hint, ...detail }, cause);
  }
  static fromUncheckedDetail(d6, c5) {
    return new _TalerError({ ...d6 }, c5);
  }
  static fromException(e5) {
    const errDetail = getErrorDetailFromException(e5);
    return new _TalerError(errDetail, e5);
  }
  hasErrorCode(code) {
    return this.errorDetail.code === code;
  }
  toString() {
    return `TalerError: ${JSON.stringify(this.errorDetail)}`;
  }
};
function getErrorDetailFromException(e5) {
  if (e5 instanceof TalerError) {
    return e5.errorDetail;
  }
  if (e5 instanceof CancellationToken.CancellationError) {
    const err2 = makeErrorDetail(TalerErrorCode.WALLET_CORE_REQUEST_CANCELLED, {});
    return err2;
  }
  if (e5 instanceof Error) {
    const err2 = makeErrorDetail(TalerErrorCode.WALLET_UNEXPECTED_EXCEPTION, {
      stack: e5.stack
    }, `unexpected exception (message: ${e5.message})`);
    return err2;
  }
  let excString;
  try {
    excString = e5.toString();
  } catch (e6) {
    excString = "can't stringify exception";
  }
  const err = makeErrorDetail(TalerErrorCode.WALLET_UNEXPECTED_EXCEPTION, {}, `unexpected exception (not an exception, ${excString})`);
  return err;
}
function assertUnreachable(x6) {
  throw new Error("Didn't expect to get here");
}

// ../taler-util/lib/taler-error-codes.js
var TalerErrorCode;
(function(TalerErrorCode2) {
  TalerErrorCode2[TalerErrorCode2["NONE"] = 0] = "NONE";
  TalerErrorCode2[TalerErrorCode2["INVALID"] = 1] = "INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CLIENT_INTERNAL_ERROR"] = 2] = "GENERIC_CLIENT_INTERNAL_ERROR";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION"] = 3] = "GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION";
  TalerErrorCode2[TalerErrorCode2["GENERIC_INVALID_RESPONSE"] = 10] = "GENERIC_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TIMEOUT"] = 11] = "GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_VERSION_MALFORMED"] = 12] = "GENERIC_VERSION_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_REPLY_MALFORMED"] = 13] = "GENERIC_REPLY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CONFIGURATION_INVALID"] = 14] = "GENERIC_CONFIGURATION_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UNEXPECTED_REQUEST_ERROR"] = 15] = "GENERIC_UNEXPECTED_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_PERMISSION_INSUFFICIENT"] = 16] = "GENERIC_TOKEN_PERMISSION_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_METHOD_INVALID"] = 20] = "GENERIC_METHOD_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_ENDPOINT_UNKNOWN"] = 21] = "GENERIC_ENDPOINT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_JSON_INVALID"] = 22] = "GENERIC_JSON_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_HTTP_HEADERS_MALFORMED"] = 23] = "GENERIC_HTTP_HEADERS_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PAYTO_URI_MALFORMED"] = 24] = "GENERIC_PAYTO_URI_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARAMETER_MISSING"] = 25] = "GENERIC_PARAMETER_MISSING";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARAMETER_MALFORMED"] = 26] = "GENERIC_PARAMETER_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_RESERVE_PUB_MALFORMED"] = 27] = "GENERIC_RESERVE_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_COMPRESSION_INVALID"] = 28] = "GENERIC_COMPRESSION_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PATH_SEGMENT_MALFORMED"] = 29] = "GENERIC_PATH_SEGMENT_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CURRENCY_MISMATCH"] = 30] = "GENERIC_CURRENCY_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["GENERIC_URI_TOO_LONG"] = 31] = "GENERIC_URI_TOO_LONG";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UPLOAD_EXCEEDS_LIMIT"] = 32] = "GENERIC_UPLOAD_EXCEEDS_LIMIT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UNAUTHORIZED"] = 40] = "GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_UNKNOWN"] = 41] = "GENERIC_TOKEN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_EXPIRED"] = 42] = "GENERIC_TOKEN_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_MALFORMED"] = 43] = "GENERIC_TOKEN_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FORBIDDEN"] = 44] = "GENERIC_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_SETUP_FAILED"] = 50] = "GENERIC_DB_SETUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_START_FAILED"] = 51] = "GENERIC_DB_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_STORE_FAILED"] = 52] = "GENERIC_DB_STORE_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_FETCH_FAILED"] = 53] = "GENERIC_DB_FETCH_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_COMMIT_FAILED"] = 54] = "GENERIC_DB_COMMIT_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_SOFT_FAILURE"] = 55] = "GENERIC_DB_SOFT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_INVARIANT_FAILURE"] = 56] = "GENERIC_DB_INVARIANT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_INTERNAL_INVARIANT_FAILURE"] = 60] = "GENERIC_INTERNAL_INVARIANT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_COMPUTE_JSON_HASH"] = 61] = "GENERIC_FAILED_COMPUTE_JSON_HASH";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_COMPUTE_AMOUNT"] = 62] = "GENERIC_FAILED_COMPUTE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARSER_OUT_OF_MEMORY"] = 70] = "GENERIC_PARSER_OUT_OF_MEMORY";
  TalerErrorCode2[TalerErrorCode2["GENERIC_ALLOCATION_FAILURE"] = 71] = "GENERIC_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_JSON_ALLOCATION_FAILURE"] = 72] = "GENERIC_JSON_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CURL_ALLOCATION_FAILURE"] = 73] = "GENERIC_CURL_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_TO_LOAD_TEMPLATE"] = 74] = "GENERIC_FAILED_TO_LOAD_TEMPLATE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_TO_EXPAND_TEMPLATE"] = 75] = "GENERIC_FAILED_TO_EXPAND_TEMPLATE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FEATURE_NOT_IMPLEMENTED"] = 76] = "GENERIC_FEATURE_NOT_IMPLEMENTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_BAD_CONFIGURATION"] = 1e3] = "EXCHANGE_GENERIC_BAD_CONFIGURATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_OPERATION_UNKNOWN"] = 1001] = "EXCHANGE_GENERIC_OPERATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_WRONG_NUMBER_OF_SEGMENTS"] = 1002] = "EXCHANGE_GENERIC_WRONG_NUMBER_OF_SEGMENTS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_CONFLICTING_DENOMINATION_KEY"] = 1003] = "EXCHANGE_GENERIC_COIN_CONFLICTING_DENOMINATION_KEY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COINS_INVALID_COIN_PUB"] = 1004] = "EXCHANGE_GENERIC_COINS_INVALID_COIN_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_KEY_UNKNOWN"] = 1005] = "EXCHANGE_GENERIC_DENOMINATION_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_SIGNATURE_INVALID"] = 1006] = "EXCHANGE_DENOMINATION_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KEYS_MISSING"] = 1007] = "EXCHANGE_GENERIC_KEYS_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_VALIDITY_IN_FUTURE"] = 1008] = "EXCHANGE_GENERIC_DENOMINATION_VALIDITY_IN_FUTURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_EXPIRED"] = 1009] = "EXCHANGE_GENERIC_DENOMINATION_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_REVOKED"] = 1010] = "EXCHANGE_GENERIC_DENOMINATION_REVOKED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_SECMOD_TIMEOUT"] = 1011] = "EXCHANGE_GENERIC_SECMOD_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_INSUFFICIENT_FUNDS"] = 1012] = "EXCHANGE_GENERIC_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_HISTORY_COMPUTATION_FAILED"] = 1013] = "EXCHANGE_GENERIC_COIN_HISTORY_COMPUTATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_HISTORY_DB_ERROR_INSUFFICIENT_FUNDS"] = 1014] = "EXCHANGE_GENERIC_HISTORY_DB_ERROR_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_CONFLICTING_AGE_HASH"] = 1015] = "EXCHANGE_GENERIC_COIN_CONFLICTING_AGE_HASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_INVALID_DENOMINATION_CIPHER_FOR_OPERATION"] = 1016] = "EXCHANGE_GENERIC_INVALID_DENOMINATION_CIPHER_FOR_OPERATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_CIPHER_MISMATCH"] = 1017] = "EXCHANGE_GENERIC_CIPHER_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_NEW_DENOMS_ARRAY_SIZE_EXCESSIVE"] = 1018] = "EXCHANGE_GENERIC_NEW_DENOMS_ARRAY_SIZE_EXCESSIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_UNKNOWN"] = 1019] = "EXCHANGE_GENERIC_COIN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_CLOCK_SKEW"] = 1020] = "EXCHANGE_GENERIC_CLOCK_SKEW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AMOUNT_EXCEEDS_DENOMINATION_VALUE"] = 1021] = "EXCHANGE_GENERIC_AMOUNT_EXCEEDS_DENOMINATION_VALUE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_GLOBAL_FEES_MISSING"] = 1022] = "EXCHANGE_GENERIC_GLOBAL_FEES_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_WIRE_FEES_MISSING"] = 1023] = "EXCHANGE_GENERIC_WIRE_FEES_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_PUB_MALFORMED"] = 1024] = "EXCHANGE_GENERIC_PURSE_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_UNKNOWN"] = 1025] = "EXCHANGE_GENERIC_PURSE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_EXPIRED"] = 1026] = "EXCHANGE_GENERIC_PURSE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_RESERVE_UNKNOWN"] = 1027] = "EXCHANGE_GENERIC_RESERVE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_REQUIRED"] = 1028] = "EXCHANGE_GENERIC_KYC_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_CONFLICTING_ATTEST_VS_AGE_COMMITMENT"] = 1029] = "EXCHANGE_PURSE_DEPOSIT_COIN_CONFLICTING_ATTEST_VS_AGE_COMMITMENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_AGE_ATTESTATION_FAILURE"] = 1030] = "EXCHANGE_PURSE_DEPOSIT_COIN_AGE_ATTESTATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_DELETED"] = 1031] = "EXCHANGE_GENERIC_PURSE_DELETED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_PUB_MALFORMED"] = 1032] = "EXCHANGE_GENERIC_AML_OFFICER_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_GET_SIGNATURE_INVALID"] = 1033] = "EXCHANGE_GENERIC_AML_OFFICER_GET_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_ACCESS_DENIED"] = 1034] = "EXCHANGE_GENERIC_AML_OFFICER_ACCESS_DENIED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_PENDING"] = 1035] = "EXCHANGE_GENERIC_AML_PENDING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_FROZEN"] = 1036] = "EXCHANGE_GENERIC_AML_FROZEN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_CONVERTER_FAILED"] = 1037] = "EXCHANGE_GENERIC_KYC_CONVERTER_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FAILED"] = 1038] = "EXCHANGE_GENERIC_KYC_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FALLBACK_FAILED"] = 1039] = "EXCHANGE_GENERIC_KYC_FALLBACK_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FALLBACK_UNKNOWN"] = 1040] = "EXCHANGE_GENERIC_KYC_FALLBACK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_BANK_ACCOUNT_UNKNOWN"] = 1041] = "EXCHANGE_GENERIC_BANK_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_PROGRAM_RECURSION_DETECTED"] = 1042] = "EXCHANGE_GENERIC_AML_PROGRAM_RECURSION_DETECTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_SANCTION_LIST_CHECK_FAILED"] = 1043] = "EXCHANGE_GENERIC_KYC_SANCTION_LIST_CHECK_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_NOT_FOUND"] = 1100] = "EXCHANGE_DEPOSITS_GET_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_H_WIRE"] = 1101] = "EXCHANGE_DEPOSITS_GET_INVALID_H_WIRE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_MERCHANT_PUB"] = 1102] = "EXCHANGE_DEPOSITS_GET_INVALID_MERCHANT_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_H_CONTRACT_TERMS"] = 1103] = "EXCHANGE_DEPOSITS_GET_INVALID_H_CONTRACT_TERMS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_COIN_PUB"] = 1104] = "EXCHANGE_DEPOSITS_GET_INVALID_COIN_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_SIGNATURE_BY_EXCHANGE"] = 1105] = "EXCHANGE_DEPOSITS_GET_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_MERCHANT_SIGNATURE_INVALID"] = 1106] = "EXCHANGE_DEPOSITS_GET_MERCHANT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_POLICY_NOT_ACCEPTED"] = 1107] = "EXCHANGE_DEPOSITS_POLICY_NOT_ACCEPTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_INSUFFICIENT_FUNDS"] = 1150] = "EXCHANGE_WITHDRAW_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_INSUFFICIENT_FUNDS"] = 1151] = "EXCHANGE_AGE_WITHDRAW_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_AMOUNT_FEE_OVERFLOW"] = 1152] = "EXCHANGE_WITHDRAW_AMOUNT_FEE_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_SIGNATURE_FAILED"] = 1153] = "EXCHANGE_WITHDRAW_SIGNATURE_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_RESERVE_SIGNATURE_INVALID"] = 1154] = "EXCHANGE_WITHDRAW_RESERVE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVE_HISTORY_ERROR_INSUFFICIENT_FUNDS"] = 1155] = "EXCHANGE_RESERVE_HISTORY_ERROR_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GET_RESERVE_HISTORY_ERROR_INSUFFICIENT_BALANCE"] = 1156] = "EXCHANGE_GET_RESERVE_HISTORY_ERROR_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_DENOMINATION_KEY_LOST"] = 1158] = "EXCHANGE_WITHDRAW_DENOMINATION_KEY_LOST";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_UNBLIND_FAILURE"] = 1159] = "EXCHANGE_WITHDRAW_UNBLIND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_NONCE_REUSE"] = 1160] = "EXCHANGE_WITHDRAW_NONCE_REUSE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_COMMITMENT_UNKNOWN"] = 1161] = "EXCHANGE_WITHDRAW_COMMITMENT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_AMOUNT_OVERFLOW"] = 1162] = "EXCHANGE_WITHDRAW_AMOUNT_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_AMOUNT_INCORRECT"] = 1163] = "EXCHANGE_AGE_WITHDRAW_AMOUNT_INCORRECT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_REVEAL_INVALID_HASH"] = 1164] = "EXCHANGE_WITHDRAW_REVEAL_INVALID_HASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_MAXIMUM_AGE_TOO_LARGE"] = 1165] = "EXCHANGE_WITHDRAW_MAXIMUM_AGE_TOO_LARGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_IDEMPOTENT_PLANCHET"] = 1175] = "EXCHANGE_WITHDRAW_IDEMPOTENT_PLANCHET";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_COIN_SIGNATURE_INVALID"] = 1205] = "EXCHANGE_DEPOSIT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_CONFLICTING_CONTRACT"] = 1206] = "EXCHANGE_DEPOSIT_CONFLICTING_CONTRACT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_NEGATIVE_VALUE_AFTER_FEE"] = 1207] = "EXCHANGE_DEPOSIT_NEGATIVE_VALUE_AFTER_FEE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_REFUND_DEADLINE_AFTER_WIRE_DEADLINE"] = 1208] = "EXCHANGE_DEPOSIT_REFUND_DEADLINE_AFTER_WIRE_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_WIRE_DEADLINE_IS_NEVER"] = 1209] = "EXCHANGE_DEPOSIT_WIRE_DEADLINE_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_JSON"] = 1210] = "EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_JSON";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_CONTRACT_HASH_CONFLICT"] = 1211] = "EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_CONTRACT_HASH_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_SIGNATURE_BY_EXCHANGE"] = 1221] = "EXCHANGE_DEPOSIT_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_FEE_ABOVE_AMOUNT"] = 1222] = "EXCHANGE_DEPOSIT_FEE_ABOVE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_EXTENSIONS_INVALID_FULFILLMENT"] = 1240] = "EXCHANGE_EXTENSIONS_INVALID_FULFILLMENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_COIN_HISTORY_BAD_SIGNATURE"] = 1251] = "EXCHANGE_COIN_HISTORY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVE_HISTORY_BAD_SIGNATURE"] = 1252] = "EXCHANGE_RESERVE_HISTORY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_FEES_EXCEED_CONTRIBUTION"] = 1302] = "EXCHANGE_MELT_FEES_EXCEED_CONTRIBUTION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_COIN_SIGNATURE_INVALID"] = 1303] = "EXCHANGE_MELT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_COIN_EXPIRED_NO_ZOMBIE"] = 1305] = "EXCHANGE_MELT_COIN_EXPIRED_NO_ZOMBIE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_INVALID_SIGNATURE_BY_EXCHANGE"] = 1306] = "EXCHANGE_MELT_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_COMMITMENT_VIOLATION"] = 1353] = "EXCHANGE_REFRESHES_REVEAL_COMMITMENT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_SIGNING_ERROR"] = 1354] = "EXCHANGE_REFRESHES_REVEAL_SIGNING_ERROR";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_SESSION_UNKNOWN"] = 1355] = "EXCHANGE_REFRESHES_REVEAL_SESSION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_CNC_TRANSFER_ARRAY_SIZE_INVALID"] = 1356] = "EXCHANGE_REFRESHES_REVEAL_CNC_TRANSFER_ARRAY_SIZE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_NEW_DENOMS_ARRAY_SIZE_MISMATCH"] = 1358] = "EXCHANGE_REFRESHES_REVEAL_NEW_DENOMS_ARRAY_SIZE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_COST_CALCULATION_OVERFLOW"] = 1359] = "EXCHANGE_REFRESHES_REVEAL_COST_CALCULATION_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AMOUNT_INSUFFICIENT"] = 1360] = "EXCHANGE_REFRESHES_REVEAL_AMOUNT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_LINK_SIGNATURE_INVALID"] = 1361] = "EXCHANGE_REFRESHES_REVEAL_LINK_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_INVALID_RCH"] = 1362] = "EXCHANGE_REFRESHES_REVEAL_INVALID_RCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_OPERATION_INVALID"] = 1363] = "EXCHANGE_REFRESHES_REVEAL_OPERATION_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_NOT_SUPPORTED"] = 1364] = "EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_COMMITMENT_INVALID"] = 1365] = "EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_COMMITMENT_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_LINK_COIN_UNKNOWN"] = 1400] = "EXCHANGE_LINK_COIN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WTID_MALFORMED"] = 1450] = "EXCHANGE_TRANSFERS_GET_WTID_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WTID_NOT_FOUND"] = 1451] = "EXCHANGE_TRANSFERS_GET_WTID_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WIRE_FEE_NOT_FOUND"] = 1452] = "EXCHANGE_TRANSFERS_GET_WIRE_FEE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WIRE_FEE_INCONSISTENT"] = 1453] = "EXCHANGE_TRANSFERS_GET_WIRE_FEE_INCONSISTENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSES_INVALID_WAIT_TARGET"] = 1475] = "EXCHANGE_PURSES_INVALID_WAIT_TARGET";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSES_GET_INVALID_SIGNATURE_BY_EXCHANGE"] = 1476] = "EXCHANGE_PURSES_GET_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_COIN_NOT_FOUND"] = 1500] = "EXCHANGE_REFUND_COIN_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_CONFLICT_DEPOSIT_INSUFFICIENT"] = 1501] = "EXCHANGE_REFUND_CONFLICT_DEPOSIT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_DEPOSIT_NOT_FOUND"] = 1502] = "EXCHANGE_REFUND_DEPOSIT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_ALREADY_PAID"] = 1503] = "EXCHANGE_REFUND_MERCHANT_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_FEE_TOO_LOW"] = 1504] = "EXCHANGE_REFUND_FEE_TOO_LOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_FEE_ABOVE_AMOUNT"] = 1505] = "EXCHANGE_REFUND_FEE_ABOVE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_SIGNATURE_INVALID"] = 1506] = "EXCHANGE_REFUND_MERCHANT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_SIGNING_FAILED"] = 1507] = "EXCHANGE_REFUND_MERCHANT_SIGNING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INVALID_SIGNATURE_BY_EXCHANGE"] = 1508] = "EXCHANGE_REFUND_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INVALID_FAILURE_PROOF_BY_EXCHANGE"] = 1509] = "EXCHANGE_REFUND_INVALID_FAILURE_PROOF_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INCONSISTENT_AMOUNT"] = 1510] = "EXCHANGE_REFUND_INCONSISTENT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_SIGNATURE_INVALID"] = 1550] = "EXCHANGE_RECOUP_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_WITHDRAW_NOT_FOUND"] = 1551] = "EXCHANGE_RECOUP_WITHDRAW_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_COIN_BALANCE_ZERO"] = 1552] = "EXCHANGE_RECOUP_COIN_BALANCE_ZERO";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_BLINDING_FAILED"] = 1553] = "EXCHANGE_RECOUP_BLINDING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_COIN_BALANCE_NEGATIVE"] = 1554] = "EXCHANGE_RECOUP_COIN_BALANCE_NEGATIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_NOT_ELIGIBLE"] = 1555] = "EXCHANGE_RECOUP_NOT_ELIGIBLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_SIGNATURE_INVALID"] = 1575] = "EXCHANGE_RECOUP_REFRESH_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_MELT_NOT_FOUND"] = 1576] = "EXCHANGE_RECOUP_REFRESH_MELT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_BLINDING_FAILED"] = 1578] = "EXCHANGE_RECOUP_REFRESH_BLINDING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_NOT_ELIGIBLE"] = 1580] = "EXCHANGE_RECOUP_REFRESH_NOT_ELIGIBLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KEYS_TIMETRAVEL_FORBIDDEN"] = 1600] = "EXCHANGE_KEYS_TIMETRAVEL_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_SIGNATURE_INVALID"] = 1650] = "EXCHANGE_WIRE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_NO_ACCOUNTS_CONFIGURED"] = 1651] = "EXCHANGE_WIRE_NO_ACCOUNTS_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_INVALID_PAYTO_CONFIGURED"] = 1652] = "EXCHANGE_WIRE_INVALID_PAYTO_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_FEES_NOT_CONFIGURED"] = 1653] = "EXCHANGE_WIRE_FEES_NOT_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_CREATE_CONFLICTING_META_DATA"] = 1675] = "EXCHANGE_RESERVES_PURSE_CREATE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_MERGE_CONFLICTING_META_DATA"] = 1676] = "EXCHANGE_RESERVES_PURSE_MERGE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_CREATE_INSUFFICIENT_FUNDS"] = 1677] = "EXCHANGE_RESERVES_PURSE_CREATE_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_FEE_TOO_LOW"] = 1678] = "EXCHANGE_RESERVES_PURSE_FEE_TOO_LOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DELETE_ALREADY_DECIDED"] = 1679] = "EXCHANGE_PURSE_DELETE_ALREADY_DECIDED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DELETE_SIGNATURE_INVALID"] = 1680] = "EXCHANGE_PURSE_DELETE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_AGE_RESTRICTION_REQUIRED"] = 1681] = "EXCHANGE_RESERVES_AGE_RESTRICTION_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_UNAVAILABLE"] = 1700] = "EXCHANGE_DENOMINATION_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_BUG"] = 1701] = "EXCHANGE_DENOMINATION_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_TOO_EARLY"] = 1702] = "EXCHANGE_DENOMINATION_HELPER_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_EXCHANGE_SIGNATURE_INVALID"] = 1725] = "EXCHANGE_PURSE_DEPOSIT_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_UNAVAILABLE"] = 1750] = "EXCHANGE_SIGNKEY_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_BUG"] = 1751] = "EXCHANGE_SIGNKEY_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_TOO_EARLY"] = 1752] = "EXCHANGE_SIGNKEY_HELPER_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_OFFLINE_MISSING"] = 1753] = "EXCHANGE_SIGNKEY_HELPER_OFFLINE_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_EXPIRATION_BEFORE_NOW"] = 1775] = "EXCHANGE_RESERVES_PURSE_EXPIRATION_BEFORE_NOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_EXPIRATION_IS_NEVER"] = 1776] = "EXCHANGE_RESERVES_PURSE_EXPIRATION_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_MERGE_SIGNATURE_INVALID"] = 1777] = "EXCHANGE_RESERVES_PURSE_MERGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_RESERVE_MERGE_SIGNATURE_INVALID"] = 1778] = "EXCHANGE_RESERVES_RESERVE_MERGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_OPEN_BAD_SIGNATURE"] = 1785] = "EXCHANGE_RESERVES_OPEN_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_CLOSE_BAD_SIGNATURE"] = 1786] = "EXCHANGE_RESERVES_CLOSE_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_ATTEST_BAD_SIGNATURE"] = 1787] = "EXCHANGE_RESERVES_ATTEST_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_CLOSE_NO_TARGET_ACCOUNT"] = 1788] = "EXCHANGE_RESERVES_CLOSE_NO_TARGET_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_OPEN_INSUFFICIENT_FUNDS"] = 1789] = "EXCHANGE_RESERVES_OPEN_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_NOT_FOUND"] = 1800] = "EXCHANGE_MANAGEMENT_AUDITOR_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_MORE_RECENT_PRESENT"] = 1801] = "EXCHANGE_MANAGEMENT_AUDITOR_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_ADD_SIGNATURE_INVALID"] = 1802] = "EXCHANGE_MANAGEMENT_AUDITOR_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_DEL_SIGNATURE_INVALID"] = 1803] = "EXCHANGE_MANAGEMENT_AUDITOR_DEL_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_DENOMINATION_REVOKE_SIGNATURE_INVALID"] = 1804] = "EXCHANGE_MANAGEMENT_DENOMINATION_REVOKE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_SIGNKEY_REVOKE_SIGNATURE_INVALID"] = 1805] = "EXCHANGE_MANAGEMENT_SIGNKEY_REVOKE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_MORE_RECENT_PRESENT"] = 1806] = "EXCHANGE_MANAGEMENT_WIRE_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_UNKNOWN"] = 1807] = "EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_DETAILS_SIGNATURE_INVALID"] = 1808] = "EXCHANGE_MANAGEMENT_WIRE_DETAILS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_ADD_SIGNATURE_INVALID"] = 1809] = "EXCHANGE_MANAGEMENT_WIRE_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_DEL_SIGNATURE_INVALID"] = 1810] = "EXCHANGE_MANAGEMENT_WIRE_DEL_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_NOT_FOUND"] = 1811] = "EXCHANGE_MANAGEMENT_WIRE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_FEE_SIGNATURE_INVALID"] = 1812] = "EXCHANGE_MANAGEMENT_WIRE_FEE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_FEE_MISMATCH"] = 1813] = "EXCHANGE_MANAGEMENT_WIRE_FEE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_DENOMKEY_ADD_SIGNATURE_INVALID"] = 1814] = "EXCHANGE_MANAGEMENT_KEYS_DENOMKEY_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_ADD_SIGNATURE_INVALID"] = 1815] = "EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_GLOBAL_FEE_MISMATCH"] = 1816] = "EXCHANGE_MANAGEMENT_GLOBAL_FEE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_GLOBAL_FEE_SIGNATURE_INVALID"] = 1817] = "EXCHANGE_MANAGEMENT_GLOBAL_FEE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_DRAIN_PROFITS_SIGNATURE_INVALID"] = 1818] = "EXCHANGE_MANAGEMENT_DRAIN_PROFITS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_ADD_SIGNATURE_INVALID"] = 1825] = "EXCHANGE_AML_DECISION_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_INVALID_OFFICER"] = 1826] = "EXCHANGE_AML_DECISION_INVALID_OFFICER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_MORE_RECENT_PRESENT"] = 1827] = "EXCHANGE_AML_DECISION_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_UNKNOWN_CHECK"] = 1828] = "EXCHANGE_AML_DECISION_UNKNOWN_CHECK";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_UPDATE_AML_OFFICER_SIGNATURE_INVALID"] = 1830] = "EXCHANGE_MANAGEMENT_UPDATE_AML_OFFICER_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AML_OFFICERS_MORE_RECENT_PRESENT"] = 1831] = "EXCHANGE_MANAGEMENT_AML_OFFICERS_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_CONFLICTING_DENOMINATION_META_DATA"] = 1832] = "EXCHANGE_MANAGEMENT_CONFLICTING_DENOMINATION_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_CONFLICTING_SIGNKEY_META_DATA"] = 1833] = "EXCHANGE_MANAGEMENT_CONFLICTING_SIGNKEY_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA"] = 1850] = "EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_CONFLICTING_CONTRACT_STORED"] = 1851] = "EXCHANGE_PURSE_CREATE_CONFLICTING_CONTRACT_STORED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_COIN_SIGNATURE_INVALID"] = 1852] = "EXCHANGE_PURSE_CREATE_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXPIRATION_BEFORE_NOW"] = 1853] = "EXCHANGE_PURSE_CREATE_EXPIRATION_BEFORE_NOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXPIRATION_IS_NEVER"] = 1854] = "EXCHANGE_PURSE_CREATE_EXPIRATION_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_SIGNATURE_INVALID"] = 1855] = "EXCHANGE_PURSE_CREATE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_ECONTRACT_SIGNATURE_INVALID"] = 1856] = "EXCHANGE_PURSE_ECONTRACT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXCHANGE_SIGNATURE_INVALID"] = 1857] = "EXCHANGE_PURSE_CREATE_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA"] = 1858] = "EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA"] = 1859] = "EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CREATE_PURSE_NEGATIVE_VALUE_AFTER_FEE"] = 1860] = "EXCHANGE_CREATE_PURSE_NEGATIVE_VALUE_AFTER_FEE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_INVALID_MERGE_SIGNATURE"] = 1876] = "EXCHANGE_PURSE_MERGE_INVALID_MERGE_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_INVALID_RESERVE_SIGNATURE"] = 1877] = "EXCHANGE_PURSE_MERGE_INVALID_RESERVE_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_NOT_FULL"] = 1878] = "EXCHANGE_PURSE_NOT_FULL";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_EXCHANGE_SIGNATURE_INVALID"] = 1879] = "EXCHANGE_PURSE_MERGE_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MERGE_PURSE_PARTNER_UNKNOWN"] = 1880] = "EXCHANGE_MERGE_PURSE_PARTNER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_ADD_PARTNER_SIGNATURE_INVALID"] = 1890] = "EXCHANGE_MANAGEMENT_ADD_PARTNER_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_ADD_PARTNER_DATA_CONFLICT"] = 1891] = "EXCHANGE_MANAGEMENT_ADD_PARTNER_DATA_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_SIGNATURE_INVALID"] = 1900] = "EXCHANGE_AUDITORS_AUDITOR_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_UNKNOWN"] = 1901] = "EXCHANGE_AUDITORS_AUDITOR_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_INACTIVE"] = 1902] = "EXCHANGE_AUDITORS_AUDITOR_INACTIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_PROGRAM_TIMEOUT"] = 1918] = "EXCHANGE_KYC_GENERIC_AML_PROGRAM_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INFO_AUTHORIZATION_FAILED"] = 1919] = "EXCHANGE_KYC_INFO_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_RECURSIVE_RULE_DETECTED"] = 1920] = "EXCHANGE_KYC_RECURSIVE_RULE_DETECTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_FORM_INCOMPLETE"] = 1921] = "EXCHANGE_KYC_AML_FORM_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_PROGRAM_GONE"] = 1922] = "EXCHANGE_KYC_GENERIC_AML_PROGRAM_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_NOT_A_FORM"] = 1923] = "EXCHANGE_KYC_NOT_A_FORM";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_CHECK_GONE"] = 1924] = "EXCHANGE_KYC_GENERIC_CHECK_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_WALLET_SIGNATURE_INVALID"] = 1925] = "EXCHANGE_KYC_WALLET_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_INVALID_RESPONSE"] = 1926] = "EXCHANGE_KYC_PROOF_BACKEND_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_ERROR"] = 1927] = "EXCHANGE_KYC_PROOF_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_AUTHORIZATION_FAILED"] = 1928] = "EXCHANGE_KYC_PROOF_BACKEND_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_REQUEST_UNKNOWN"] = 1929] = "EXCHANGE_KYC_PROOF_REQUEST_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_AUTHORIZATION_FAILED"] = 1930] = "EXCHANGE_KYC_CHECK_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_UNKNOWN"] = 1931] = "EXCHANGE_KYC_GENERIC_LOGIC_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_GONE"] = 1932] = "EXCHANGE_KYC_GENERIC_LOGIC_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_BUG"] = 1933] = "EXCHANGE_KYC_GENERIC_LOGIC_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_ACCESS_REFUSED"] = 1934] = "EXCHANGE_KYC_GENERIC_PROVIDER_ACCESS_REFUSED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_TIMEOUT"] = 1935] = "EXCHANGE_KYC_GENERIC_PROVIDER_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_UNEXPECTED_REPLY"] = 1936] = "EXCHANGE_KYC_GENERIC_PROVIDER_UNEXPECTED_REPLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_RATE_LIMIT_EXCEEDED"] = 1937] = "EXCHANGE_KYC_GENERIC_PROVIDER_RATE_LIMIT_EXCEEDED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_WEBHOOK_UNAUTHORIZED"] = 1938] = "EXCHANGE_KYC_WEBHOOK_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_REQUEST_UNKNOWN"] = 1939] = "EXCHANGE_KYC_CHECK_REQUEST_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_AUTHORIZATION_KEY_UNKNOWN"] = 1940] = "EXCHANGE_KYC_CHECK_AUTHORIZATION_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_FORM_ALREADY_UPLOADED"] = 1941] = "EXCHANGE_KYC_FORM_ALREADY_UPLOADED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_MEASURES_MALFORMED"] = 1942] = "EXCHANGE_KYC_MEASURES_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_MEASURE_INDEX_INVALID"] = 1943] = "EXCHANGE_KYC_MEASURE_INDEX_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INVALID_LOGIC_TO_CHECK"] = 1944] = "EXCHANGE_KYC_INVALID_LOGIC_TO_CHECK";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_PROGRAM_FAILURE"] = 1945] = "EXCHANGE_KYC_AML_PROGRAM_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_PROGRAM_MALFORMED_RESULT"] = 1946] = "EXCHANGE_KYC_AML_PROGRAM_MALFORMED_RESULT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_REPLY"] = 1947] = "EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_REPLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_CONTEXT"] = 1948] = "EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_CONTEXT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_LOGIC_BUG"] = 1949] = "EXCHANGE_KYC_GENERIC_AML_LOGIC_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_UNKNOWN"] = 1950] = "EXCHANGE_CONTRACTS_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_INVALID_CONTRACT_PUB"] = 1951] = "EXCHANGE_CONTRACTS_INVALID_CONTRACT_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_DECRYPTION_FAILED"] = 1952] = "EXCHANGE_CONTRACTS_DECRYPTION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_SIGNATURE_INVALID"] = 1953] = "EXCHANGE_CONTRACTS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_DECODING_FAILED"] = 1954] = "EXCHANGE_CONTRACTS_DECODING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_SIGNATURE_INVALID"] = 1975] = "EXCHANGE_PURSE_DEPOSIT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_DECIDED_ALREADY"] = 1976] = "EXCHANGE_PURSE_DEPOSIT_DECIDED_ALREADY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INFO_BUSY"] = 1977] = "EXCHANGE_KYC_INFO_BUSY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TOTP_KEY_INVALID"] = 1980] = "EXCHANGE_TOTP_KEY_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_INSTANCE_UNKNOWN"] = 2e3] = "MERCHANT_GENERIC_INSTANCE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_HOLE_IN_WIRE_FEE_STRUCTURE"] = 2001] = "MERCHANT_GENERIC_HOLE_IN_WIRE_FEE_STRUCTURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_WIRE_REQUEST_FAILED"] = 2002] = "MERCHANT_GENERIC_EXCHANGE_WIRE_REQUEST_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CATEGORY_UNKNOWN"] = 2003] = "MERCHANT_GENERIC_CATEGORY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_ORDER_UNKNOWN"] = 2005] = "MERCHANT_GENERIC_ORDER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_PRODUCT_UNKNOWN"] = 2006] = "MERCHANT_GENERIC_PRODUCT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_REWARD_ID_UNKNOWN"] = 2007] = "MERCHANT_GENERIC_REWARD_ID_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_DB_CONTRACT_CONTENT_INVALID"] = 2008] = "MERCHANT_GENERIC_DB_CONTRACT_CONTENT_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CONTRACT_HASH_DOES_NOT_MATCH_ORDER"] = 2009] = "MERCHANT_GENERIC_CONTRACT_HASH_DOES_NOT_MATCH_ORDER";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_KEYS_FAILURE"] = 2010] = "MERCHANT_GENERIC_EXCHANGE_KEYS_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_TIMEOUT"] = 2011] = "MERCHANT_GENERIC_EXCHANGE_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_CONNECT_FAILURE"] = 2012] = "MERCHANT_GENERIC_EXCHANGE_CONNECT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_REPLY_MALFORMED"] = 2013] = "MERCHANT_GENERIC_EXCHANGE_REPLY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_UNEXPECTED_STATUS"] = 2014] = "MERCHANT_GENERIC_EXCHANGE_UNEXPECTED_STATUS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_UNAUTHORIZED"] = 2015] = "MERCHANT_GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_INSTANCE_DELETED"] = 2016] = "MERCHANT_GENERIC_INSTANCE_DELETED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TRANSFER_UNKNOWN"] = 2017] = "MERCHANT_GENERIC_TRANSFER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TEMPLATE_UNKNOWN"] = 2018] = "MERCHANT_GENERIC_TEMPLATE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_WEBHOOK_UNKNOWN"] = 2019] = "MERCHANT_GENERIC_WEBHOOK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_PENDING_WEBHOOK_UNKNOWN"] = 2020] = "MERCHANT_GENERIC_PENDING_WEBHOOK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_OTP_DEVICE_UNKNOWN"] = 2021] = "MERCHANT_GENERIC_OTP_DEVICE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_ACCOUNT_UNKNOWN"] = 2022] = "MERCHANT_GENERIC_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_H_WIRE_MALFORMED"] = 2023] = "MERCHANT_GENERIC_H_WIRE_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CURRENCY_MISMATCH"] = 2024] = "MERCHANT_GENERIC_CURRENCY_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_UNTRUSTED"] = 2025] = "MERCHANT_GENERIC_EXCHANGE_UNTRUSTED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TOKEN_FAMILY_UNKNOWN"] = 2026] = "MERCHANT_GENERIC_TOKEN_FAMILY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TOKEN_KEY_UNKNOWN"] = 2027] = "MERCHANT_GENERIC_TOKEN_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_DONAU_NOT_CONFIGURED"] = 2028] = "MERCHANT_GENERIC_DONAU_NOT_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_SIGN_PUB_UNKNOWN"] = 2029] = "MERCHANT_EXCHANGE_SIGN_PUB_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_FEATURE_NOT_AVAILABLE"] = 2030] = "MERCHANT_GENERIC_FEATURE_NOT_AVAILABLE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_MFA_MISSING"] = 2031] = "MERCHANT_GENERIC_MFA_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_EXCHANGE_TRACKING_FAILURE"] = 2100] = "MERCHANT_GET_ORDERS_EXCHANGE_TRACKING_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_EXCHANGE_REQUEST_FAILURE"] = 2103] = "MERCHANT_GET_ORDERS_ID_EXCHANGE_REQUEST_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_EXCHANGE_LOOKUP_START_FAILURE"] = 2104] = "MERCHANT_GET_ORDERS_ID_EXCHANGE_LOOKUP_START_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_TOKEN"] = 2105] = "MERCHANT_GET_ORDERS_ID_INVALID_TOKEN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_HASH"] = 2106] = "MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_HASH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_VERSION"] = 2107] = "MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_VERSION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_CHALLENGE_FAILED"] = 2125] = "MERCHANT_TAN_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_CHALLENGE_UNKNOWN"] = 2126] = "MERCHANT_TAN_CHALLENGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_TOO_MANY_ATTEMPTS"] = 2127] = "MERCHANT_TAN_TOO_MANY_ATTEMPTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_MFA_HELPER_EXEC_FAILED"] = 2128] = "MERCHANT_TAN_MFA_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_CHALLENGE_SOLVED"] = 2129] = "MERCHANT_TAN_CHALLENGE_SOLVED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_TAN_TOO_EARLY"] = 2130] = "MERCHANT_TAN_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_MFA_FORBIDDEN"] = 2131] = "MERCHANT_MFA_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_FUNDS"] = 2150] = "MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_NOT_FOUND"] = 2151] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_AUDITOR_FAILURE"] = 2152] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_AUDITOR_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AMOUNT_OVERFLOW"] = 2153] = "MERCHANT_POST_ORDERS_ID_PAY_AMOUNT_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_FEES_EXCEED_PAYMENT"] = 2154] = "MERCHANT_POST_ORDERS_ID_PAY_FEES_EXCEED_PAYMENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_DUE_TO_FEES"] = 2155] = "MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_DUE_TO_FEES";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_PAYMENT_INSUFFICIENT"] = 2156] = "MERCHANT_POST_ORDERS_ID_PAY_PAYMENT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_COIN_SIGNATURE_INVALID"] = 2157] = "MERCHANT_POST_ORDERS_ID_PAY_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_LOOKUP_FAILED"] = 2158] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUND_DEADLINE_PAST_WIRE_TRANSFER_DEADLINE"] = 2159] = "MERCHANT_POST_ORDERS_ID_PAY_REFUND_DEADLINE_PAST_WIRE_TRANSFER_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_ALREADY_PAID"] = 2160] = "MERCHANT_POST_ORDERS_ID_PAY_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_OFFER_EXPIRED"] = 2161] = "MERCHANT_POST_ORDERS_ID_PAY_OFFER_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_MERCHANT_FIELD_MISSING"] = 2162] = "MERCHANT_POST_ORDERS_ID_PAY_MERCHANT_FIELD_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_WIRE_HASH_UNKNOWN"] = 2163] = "MERCHANT_POST_ORDERS_ID_PAY_WIRE_HASH_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_DEPOSIT_EXPIRED"] = 2165] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_DEPOSIT_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_WIRE_FEE_ADDITION_FAILED"] = 2166] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_WIRE_FEE_ADDITION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUNDED"] = 2167] = "MERCHANT_POST_ORDERS_ID_PAY_REFUNDED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUNDS_EXCEED_PAYMENTS"] = 2168] = "MERCHANT_POST_ORDERS_ID_PAY_REFUNDS_EXCEED_PAYMENTS";
  TalerErrorCode2[TalerErrorCode2["DEAD_QQQ_PAY_MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE"] = 2169] = "DEAD_QQQ_PAY_MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_FAILED"] = 2170] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_MISSING"] = 2171] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_SIZE_MISMATCH"] = 2172] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_SIZE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_VERIFICATION_FAILED"] = 2173] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_VERIFICATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_HASH_MISSING"] = 2174] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_HASH_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_WIRE_METHOD_UNSUPPORTED"] = 2175] = "MERCHANT_POST_ORDERS_ID_PAY_WIRE_METHOD_UNSUPPORTED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_MISSING"] = 2176] = "MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_OUT_OF_BOUNDS"] = 2177] = "MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_OUT_OF_BOUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INPUT_TOKENS_MISMATCH"] = 2178] = "MERCHANT_POST_ORDERS_ID_PAY_INPUT_TOKENS_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ISSUE_SIG_INVALID"] = 2179] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ISSUE_SIG_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_USE_SIG_INVALID"] = 2180] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_USE_SIG_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_COUNT_MISMATCH"] = 2181] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_COUNT_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ENVELOPE_COUNT_MISMATCH"] = 2182] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ENVELOPE_COUNT_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_INVALID"] = 2183] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_TRANSACTION_LIMIT_VIOLATION"] = 2184] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_TRANSACTION_LIMIT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DONATION_AMOUNT_MISMATCH"] = 2185] = "MERCHANT_POST_ORDERS_ID_PAY_DONATION_AMOUNT_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAID_CONTRACT_HASH_MISMATCH"] = 2200] = "MERCHANT_POST_ORDERS_ID_PAID_CONTRACT_HASH_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAID_COIN_SIGNATURE_INVALID"] = 2201] = "MERCHANT_POST_ORDERS_ID_PAID_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_TOKEN_FAMILY_CONFLICT"] = 2225] = "MERCHANT_POST_TOKEN_FAMILY_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PATCH_TOKEN_FAMILY_NOT_FOUND"] = 2226] = "MERCHANT_PATCH_TOKEN_FAMILY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_REFUND_FAILED"] = 2251] = "MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_REFUND_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_LOOKUP_FAILED"] = 2252] = "MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_NOT_FOUND"] = 2253] = "MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE"] = 2254] = "MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_HASH_MISSMATCH"] = 2255] = "MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_HASH_MISSMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_COINS_ARRAY_EMPTY"] = 2256] = "MERCHANT_POST_ORDERS_ID_ABORT_COINS_ARRAY_EMPTY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_AWAITING_KEYS"] = 2258] = "MERCHANT_EXCHANGE_TRANSFERS_AWAITING_KEYS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_AWAITING_LIST"] = 2259] = "MERCHANT_EXCHANGE_TRANSFERS_AWAITING_LIST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_FATAL_NO_EXCHANGE"] = 2260] = "MERCHANT_EXCHANGE_TRANSFERS_FATAL_NO_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_FATAL_NOT_FOUND"] = 2261] = "MERCHANT_EXCHANGE_TRANSFERS_FATAL_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_RATE_LIMITED"] = 2262] = "MERCHANT_EXCHANGE_TRANSFERS_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_TRANSIENT_FAILURE"] = 2263] = "MERCHANT_EXCHANGE_TRANSFERS_TRANSIENT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_HARD_FAILURE"] = 2264] = "MERCHANT_EXCHANGE_TRANSFERS_HARD_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_NOT_FOUND"] = 2300] = "MERCHANT_POST_ORDERS_ID_CLAIM_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_ALREADY_CLAIMED"] = 2301] = "MERCHANT_POST_ORDERS_ID_CLAIM_ALREADY_CLAIMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_CLIENT_INTERNAL_FAILURE"] = 2302] = "MERCHANT_POST_ORDERS_ID_CLAIM_CLIENT_INTERNAL_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_REFUND_SIGNATURE_FAILED"] = 2350] = "MERCHANT_POST_ORDERS_ID_REFUND_SIGNATURE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_UNBLIND_FAILURE"] = 2400] = "MERCHANT_REWARD_PICKUP_UNBLIND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_EXCHANGE_ERROR"] = 2403] = "MERCHANT_REWARD_PICKUP_EXCHANGE_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_SUMMATION_FAILED"] = 2404] = "MERCHANT_REWARD_PICKUP_SUMMATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_HAS_EXPIRED"] = 2405] = "MERCHANT_REWARD_PICKUP_HAS_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_AMOUNT_EXCEEDS_REWARD_REMAINING"] = 2406] = "MERCHANT_REWARD_PICKUP_AMOUNT_EXCEEDS_REWARD_REMAINING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_DENOMINATION_UNKNOWN"] = 2407] = "MERCHANT_REWARD_PICKUP_DENOMINATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_INSTANCE_CONFIGURATION_LACKS_WIRE"] = 2500] = "MERCHANT_PRIVATE_POST_ORDERS_INSTANCE_CONFIGURATION_LACKS_WIRE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_LOCALTIME"] = 2501] = "MERCHANT_PRIVATE_POST_ORDERS_NO_LOCALTIME";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_PROPOSAL_PARSE_ERROR"] = 2502] = "MERCHANT_PRIVATE_POST_ORDERS_PROPOSAL_PARSE_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ALREADY_EXISTS"] = 2503] = "MERCHANT_PRIVATE_POST_ORDERS_ALREADY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_REFUND_AFTER_WIRE_DEADLINE"] = 2504] = "MERCHANT_PRIVATE_POST_ORDERS_REFUND_AFTER_WIRE_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_DELIVERY_DATE_IN_PAST"] = 2505] = "MERCHANT_PRIVATE_POST_ORDERS_DELIVERY_DATE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_WIRE_DEADLINE_IS_NEVER"] = 2506] = "MERCHANT_PRIVATE_POST_ORDERS_WIRE_DEADLINE_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_PAY_DEADLINE_IN_PAST"] = 2507] = "MERCHANT_PRIVATE_POST_ORDERS_PAY_DEADLINE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_REFUND_DEADLINE_IN_PAST"] = 2508] = "MERCHANT_PRIVATE_POST_ORDERS_REFUND_DEADLINE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGES_FOR_WIRE_METHOD"] = 2509] = "MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGES_FOR_WIRE_METHOD";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_SYNTAX_INCORRECT"] = 2510] = "MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_SYNTAX_INCORRECT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_NOT_FORGETTABLE"] = 2511] = "MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_NOT_FORGETTABLE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_REFUND_EXCHANGE_TRANSACTION_LIMIT_VIOLATION"] = 2512] = "MERCHANT_POST_ORDERS_ID_REFUND_EXCHANGE_TRANSACTION_LIMIT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_AMOUNT_EXCEEDS_LEGAL_LIMITS"] = 2513] = "MERCHANT_PRIVATE_POST_ORDERS_AMOUNT_EXCEEDS_LEGAL_LIMITS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGE_FOR_CURRENCY"] = 2514] = "MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGE_FOR_CURRENCY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_ORDERS_AWAITING_PAYMENT"] = 2520] = "MERCHANT_PRIVATE_DELETE_ORDERS_AWAITING_PAYMENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_ORDERS_ALREADY_PAID"] = 2521] = "MERCHANT_PRIVATE_DELETE_ORDERS_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_INCONSISTENT_AMOUNT"] = 2530] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_INCONSISTENT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_ORDER_UNPAID"] = 2531] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_ORDER_UNPAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_NOT_ALLOWED_BY_CONTRACT"] = 2532] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_NOT_ALLOWED_BY_CONTRACT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_SLUG_UNKNOWN"] = 2533] = "MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_SLUG_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_NOT_VALID"] = 2534] = "MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_NOT_VALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_EXCHANGE_UNKNOWN"] = 2550] = "MERCHANT_PRIVATE_POST_TRANSFERS_EXCHANGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_REQUEST_ERROR"] = 2551] = "MERCHANT_PRIVATE_POST_TRANSFERS_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_TRANSFERS"] = 2552] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_TRANSFERS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_REPORTS"] = 2553] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_REPORTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_BAD_WIRE_FEE"] = 2554] = "MERCHANT_PRIVATE_POST_TRANSFERS_BAD_WIRE_FEE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_ACCOUNT_NOT_FOUND"] = 2555] = "MERCHANT_PRIVATE_POST_TRANSFERS_ACCOUNT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_TRANSFERS_ALREADY_CONFIRMED"] = 2556] = "MERCHANT_PRIVATE_DELETE_TRANSFERS_ALREADY_CONFIRMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_SUBMISSION"] = 2557] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_SUBMISSION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_TARGET_ACCOUNT_UNKNOWN"] = 2558] = "MERCHANT_EXCHANGE_TRANSFERS_TARGET_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_CONFLICTING_TRANSFERS"] = 2563] = "MERCHANT_EXCHANGE_TRANSFERS_CONFLICTING_TRANSFERS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_ALREADY_EXISTS"] = 2600] = "MERCHANT_PRIVATE_POST_INSTANCES_ALREADY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_BAD_AUTH"] = 2601] = "MERCHANT_PRIVATE_POST_INSTANCES_BAD_AUTH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCE_AUTH_BAD_AUTH"] = 2602] = "MERCHANT_PRIVATE_POST_INSTANCE_AUTH_BAD_AUTH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_PURGE_REQUIRED"] = 2603] = "MERCHANT_PRIVATE_POST_INSTANCES_PURGE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_INSTANCES_PURGE_REQUIRED"] = 2625] = "MERCHANT_PRIVATE_PATCH_INSTANCES_PURGE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_ACCOUNT_DELETE_UNKNOWN_ACCOUNT"] = 2626] = "MERCHANT_PRIVATE_ACCOUNT_DELETE_UNKNOWN_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_ACCOUNT_EXISTS"] = 2627] = "MERCHANT_PRIVATE_ACCOUNT_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PRODUCTS_CONFLICT_PRODUCT_EXISTS"] = 2650] = "MERCHANT_PRIVATE_POST_PRODUCTS_CONFLICT_PRODUCT_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_CATEGORIES_CONFLICT_CATEGORY_EXISTS"] = 2651] = "MERCHANT_PRIVATE_POST_CATEGORIES_CONFLICT_CATEGORY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_REDUCED"] = 2660] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_EXCEEDS_STOCKS"] = 2661] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_EXCEEDS_STOCKS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_STOCKED_REDUCED"] = 2662] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_STOCKED_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_SOLD_REDUCED"] = 2663] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_SOLD_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PRODUCTS_LOCK_INSUFFICIENT_STOCKS"] = 2670] = "MERCHANT_PRIVATE_POST_PRODUCTS_LOCK_INSUFFICIENT_STOCKS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_PRODUCTS_CONFLICTING_LOCK"] = 2680] = "MERCHANT_PRIVATE_DELETE_PRODUCTS_CONFLICTING_LOCK";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_RESERVES_UNSUPPORTED_WIRE_METHOD"] = 2700] = "MERCHANT_PRIVATE_POST_RESERVES_UNSUPPORTED_WIRE_METHOD";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_RESERVES_REWARDS_NOT_ALLOWED"] = 2701] = "MERCHANT_PRIVATE_POST_RESERVES_REWARDS_NOT_ALLOWED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_RESERVES_NO_SUCH_RESERVE"] = 2710] = "MERCHANT_PRIVATE_DELETE_RESERVES_NO_SUCH_RESERVE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_EXPIRED"] = 2750] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_UNKNOWN"] = 2751] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_INSUFFICIENT_FUNDS"] = 2752] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_NOT_FOUND"] = 2753] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_GET_ORDERS_ID_AMOUNT_ARITHMETIC_FAILURE"] = 2800] = "MERCHANT_PRIVATE_GET_ORDERS_ID_AMOUNT_ARITHMETIC_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TEMPLATES_CONFLICT_TEMPLATE_EXISTS"] = 2850] = "MERCHANT_PRIVATE_POST_TEMPLATES_CONFLICT_TEMPLATE_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_OTP_DEVICES_CONFLICT_OTP_DEVICE_EXISTS"] = 2851] = "MERCHANT_PRIVATE_POST_OTP_DEVICES_CONFLICT_OTP_DEVICE_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_AMOUNT_CONFLICT_TEMPLATES_CONTRACT_AMOUNT"] = 2860] = "MERCHANT_POST_USING_TEMPLATES_AMOUNT_CONFLICT_TEMPLATES_CONTRACT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_SUMMARY_CONFLICT_TEMPLATES_CONTRACT_SUBJECT"] = 2861] = "MERCHANT_POST_USING_TEMPLATES_SUMMARY_CONFLICT_TEMPLATES_CONTRACT_SUBJECT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_NO_AMOUNT"] = 2862] = "MERCHANT_POST_USING_TEMPLATES_NO_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_NO_SUMMARY"] = 2863] = "MERCHANT_POST_USING_TEMPLATES_NO_SUMMARY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_WEBHOOKS_CONFLICT_WEBHOOK_EXISTS"] = 2900] = "MERCHANT_PRIVATE_POST_WEBHOOKS_CONFLICT_WEBHOOK_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PENDING_WEBHOOKS_CONFLICT_PENDING_WEBHOOK_EXISTS"] = 2910] = "MERCHANT_PRIVATE_POST_PENDING_WEBHOOKS_CONFLICT_PENDING_WEBHOOK_EXISTS";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_GENERIC_UNAUTHORIZED"] = 3001] = "AUDITOR_GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_GENERIC_METHOD_NOT_ALLOWED"] = 3002] = "AUDITOR_GENERIC_METHOD_NOT_ALLOWED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_DEPOSIT_CONFIRMATION_SIGNATURE_INVALID"] = 3100] = "AUDITOR_DEPOSIT_CONFIRMATION_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_EXCHANGE_SIGNING_KEY_REVOKED"] = 3101] = "AUDITOR_EXCHANGE_SIGNING_KEY_REVOKED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_RESOURCE_NOT_FOUND"] = 3102] = "AUDITOR_RESOURCE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_URI_MISSING_PATH_COMPONENT"] = 3103] = "AUDITOR_URI_MISSING_PATH_COMPONENT";
  TalerErrorCode2[TalerErrorCode2["BANK_SAME_ACCOUNT"] = 5101] = "BANK_SAME_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_UNALLOWED_DEBIT"] = 5102] = "BANK_UNALLOWED_DEBIT";
  TalerErrorCode2[TalerErrorCode2["BANK_NEGATIVE_NUMBER_AMOUNT"] = 5103] = "BANK_NEGATIVE_NUMBER_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_NUMBER_TOO_BIG"] = 5104] = "BANK_NUMBER_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_ACCOUNT"] = 5106] = "BANK_UNKNOWN_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSACTION_NOT_FOUND"] = 5107] = "BANK_TRANSACTION_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["BANK_BAD_FORMAT_AMOUNT"] = 5108] = "BANK_BAD_FORMAT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_REJECT_NO_RIGHTS"] = 5109] = "BANK_REJECT_NO_RIGHTS";
  TalerErrorCode2[TalerErrorCode2["BANK_UNMANAGED_EXCEPTION"] = 5110] = "BANK_UNMANAGED_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["BANK_SOFT_EXCEPTION"] = 5111] = "BANK_SOFT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSFER_REQUEST_UID_REUSED"] = 5112] = "BANK_TRANSFER_REQUEST_UID_REUSED";
  TalerErrorCode2[TalerErrorCode2["BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT"] = 5113] = "BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_DUPLICATE_RESERVE_PUB_SUBJECT"] = 5114] = "BANK_DUPLICATE_RESERVE_PUB_SUBJECT";
  TalerErrorCode2[TalerErrorCode2["BANK_ANCIENT_TRANSACTION_GONE"] = 5115] = "BANK_ANCIENT_TRANSACTION_GONE";
  TalerErrorCode2[TalerErrorCode2["BANK_ABORT_CONFIRM_CONFLICT"] = 5116] = "BANK_ABORT_CONFIRM_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_CONFIRM_ABORT_CONFLICT"] = 5117] = "BANK_CONFIRM_ABORT_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_CONFLICT"] = 5118] = "BANK_REGISTER_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_POST_WITHDRAWAL_OPERATION_REQUIRED"] = 5119] = "BANK_POST_WITHDRAWAL_OPERATION_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_RESERVED_USERNAME_CONFLICT"] = 5120] = "BANK_RESERVED_USERNAME_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_USERNAME_REUSE"] = 5121] = "BANK_REGISTER_USERNAME_REUSE";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_PAYTO_URI_REUSE"] = 5122] = "BANK_REGISTER_PAYTO_URI_REUSE";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_BALANCE_NOT_ZERO"] = 5123] = "BANK_ACCOUNT_BALANCE_NOT_ZERO";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_CREDITOR"] = 5124] = "BANK_UNKNOWN_CREDITOR";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_DEBTOR"] = 5125] = "BANK_UNKNOWN_DEBTOR";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_IS_EXCHANGE"] = 5126] = "BANK_ACCOUNT_IS_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_IS_NOT_EXCHANGE"] = 5127] = "BANK_ACCOUNT_IS_NOT_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_BAD_CONVERSION"] = 5128] = "BANK_BAD_CONVERSION";
  TalerErrorCode2[TalerErrorCode2["BANK_MISSING_TAN_INFO"] = 5129] = "BANK_MISSING_TAN_INFO";
  TalerErrorCode2[TalerErrorCode2["BANK_CONFIRM_INCOMPLETE"] = 5130] = "BANK_CONFIRM_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_RATE_LIMITED"] = 5131] = "BANK_TAN_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHANNEL_NOT_SUPPORTED"] = 5132] = "BANK_TAN_CHANNEL_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHANNEL_SCRIPT_FAILED"] = 5133] = "BANK_TAN_CHANNEL_SCRIPT_FAILED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHALLENGE_FAILED"] = 5134] = "BANK_TAN_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_LEGAL_NAME"] = 5135] = "BANK_NON_ADMIN_PATCH_LEGAL_NAME";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_DEBT_LIMIT"] = 5136] = "BANK_NON_ADMIN_PATCH_DEBT_LIMIT";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD"] = 5137] = "BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD";
  TalerErrorCode2[TalerErrorCode2["BANK_PATCH_BAD_OLD_PASSWORD"] = 5138] = "BANK_PATCH_BAD_OLD_PASSWORD";
  TalerErrorCode2[TalerErrorCode2["BANK_PATCH_ADMIN_EXCHANGE"] = 5139] = "BANK_PATCH_ADMIN_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_CASHOUT"] = 5140] = "BANK_NON_ADMIN_PATCH_CASHOUT";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_CONTACT"] = 5141] = "BANK_NON_ADMIN_PATCH_CONTACT";
  TalerErrorCode2[TalerErrorCode2["BANK_ADMIN_CREDITOR"] = 5142] = "BANK_ADMIN_CREDITOR";
  TalerErrorCode2[TalerErrorCode2["BANK_CHALLENGE_NOT_FOUND"] = 5143] = "BANK_CHALLENGE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHALLENGE_EXPIRED"] = 5144] = "BANK_TAN_CHALLENGE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_TAN_CHANNEL"] = 5145] = "BANK_NON_ADMIN_SET_TAN_CHANNEL";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_MIN_CASHOUT"] = 5146] = "BANK_NON_ADMIN_SET_MIN_CASHOUT";
  TalerErrorCode2[TalerErrorCode2["BANK_CONVERSION_AMOUNT_TO_SMALL"] = 5147] = "BANK_CONVERSION_AMOUNT_TO_SMALL";
  TalerErrorCode2[TalerErrorCode2["BANK_AMOUNT_DIFFERS"] = 5148] = "BANK_AMOUNT_DIFFERS";
  TalerErrorCode2[TalerErrorCode2["BANK_AMOUNT_REQUIRED"] = 5149] = "BANK_AMOUNT_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_PASSWORD_TOO_SHORT"] = 5150] = "BANK_PASSWORD_TOO_SHORT";
  TalerErrorCode2[TalerErrorCode2["BANK_PASSWORD_TOO_LONG"] = 5151] = "BANK_PASSWORD_TOO_LONG";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_LOCKED"] = 5152] = "BANK_ACCOUNT_LOCKED";
  TalerErrorCode2[TalerErrorCode2["BANK_UPDATE_ABORT_CONFLICT"] = 5153] = "BANK_UPDATE_ABORT_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSFER_WTID_REUSED"] = 5154] = "BANK_TRANSFER_WTID_REUSED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS"] = 5155] = "BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS";
  TalerErrorCode2[TalerErrorCode2["BANK_CONVERSION_RATE_CLASS_UNKNOWN"] = 5156] = "BANK_CONVERSION_RATE_CLASS_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["BANK_NAME_REUSE"] = 5157] = "BANK_NAME_REUSE";
  TalerErrorCode2[TalerErrorCode2["SYNC_ACCOUNT_UNKNOWN"] = 6100] = "SYNC_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_IF_NONE_MATCH"] = 6101] = "SYNC_BAD_IF_NONE_MATCH";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_IF_MATCH"] = 6102] = "SYNC_BAD_IF_MATCH";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_SYNC_SIGNATURE"] = 6103] = "SYNC_BAD_SYNC_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["SYNC_INVALID_SIGNATURE"] = 6104] = "SYNC_INVALID_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["SYNC_MALFORMED_CONTENT_LENGTH"] = 6105] = "SYNC_MALFORMED_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_EXCESSIVE_CONTENT_LENGTH"] = 6106] = "SYNC_EXCESSIVE_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_OUT_OF_MEMORY_ON_CONTENT_LENGTH"] = 6107] = "SYNC_OUT_OF_MEMORY_ON_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_INVALID_UPLOAD"] = 6108] = "SYNC_INVALID_UPLOAD";
  TalerErrorCode2[TalerErrorCode2["SYNC_PAYMENT_GENERIC_TIMEOUT"] = 6109] = "SYNC_PAYMENT_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["SYNC_PAYMENT_CREATE_BACKEND_ERROR"] = 6110] = "SYNC_PAYMENT_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["SYNC_PREVIOUS_BACKUP_UNKNOWN"] = 6111] = "SYNC_PREVIOUS_BACKUP_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["SYNC_MISSING_CONTENT_LENGTH"] = 6112] = "SYNC_MISSING_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_GENERIC_BACKEND_ERROR"] = 6113] = "SYNC_GENERIC_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["SYNC_GENERIC_BACKEND_TIMEOUT"] = 6114] = "SYNC_GENERIC_BACKEND_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_PROTOCOL_VERSION_INCOMPATIBLE"] = 7e3] = "WALLET_EXCHANGE_PROTOCOL_VERSION_INCOMPATIBLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_UNEXPECTED_EXCEPTION"] = 7001] = "WALLET_UNEXPECTED_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["WALLET_RECEIVED_MALFORMED_RESPONSE"] = 7002] = "WALLET_RECEIVED_MALFORMED_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["WALLET_NETWORK_ERROR"] = 7003] = "WALLET_NETWORK_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_HTTP_REQUEST_THROTTLED"] = 7004] = "WALLET_HTTP_REQUEST_THROTTLED";
  TalerErrorCode2[TalerErrorCode2["WALLET_UNEXPECTED_REQUEST_ERROR"] = 7005] = "WALLET_UNEXPECTED_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_DENOMINATIONS_INSUFFICIENT"] = 7006] = "WALLET_EXCHANGE_DENOMINATIONS_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_API_OPERATION_UNKNOWN"] = 7007] = "WALLET_CORE_API_OPERATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["WALLET_INVALID_TALER_PAY_URI"] = 7008] = "WALLET_INVALID_TALER_PAY_URI";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_COIN_SIGNATURE_INVALID"] = 7009] = "WALLET_EXCHANGE_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_WITHDRAW_RESERVE_UNKNOWN_AT_EXCHANGE"] = 7010] = "WALLET_EXCHANGE_WITHDRAW_RESERVE_UNKNOWN_AT_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_NOT_AVAILABLE"] = 7011] = "WALLET_CORE_NOT_AVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_OPERATION_ABORTED_BY_BANK"] = 7012] = "WALLET_WITHDRAWAL_OPERATION_ABORTED_BY_BANK";
  TalerErrorCode2[TalerErrorCode2["WALLET_HTTP_REQUEST_GENERIC_TIMEOUT"] = 7013] = "WALLET_HTTP_REQUEST_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["WALLET_ORDER_ALREADY_CLAIMED"] = 7014] = "WALLET_ORDER_ALREADY_CLAIMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_GROUP_INCOMPLETE"] = 7015] = "WALLET_WITHDRAWAL_GROUP_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["WALLET_REWARD_COIN_SIGNATURE_INVALID"] = 7016] = "WALLET_REWARD_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_BANK_INTEGRATION_PROTOCOL_VERSION_INCOMPATIBLE"] = 7017] = "WALLET_BANK_INTEGRATION_PROTOCOL_VERSION_INCOMPATIBLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_BASE_URL_MISMATCH"] = 7018] = "WALLET_CONTRACT_TERMS_BASE_URL_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_SIGNATURE_INVALID"] = 7019] = "WALLET_CONTRACT_TERMS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_MALFORMED"] = 7020] = "WALLET_CONTRACT_TERMS_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PENDING_OPERATION_FAILED"] = 7021] = "WALLET_PENDING_OPERATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_SERVER_ERROR"] = 7022] = "WALLET_PAY_MERCHANT_SERVER_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_CRYPTO_WORKER_ERROR"] = 7023] = "WALLET_CRYPTO_WORKER_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_CRYPTO_WORKER_BAD_REQUEST"] = 7024] = "WALLET_CRYPTO_WORKER_BAD_REQUEST";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_KYC_REQUIRED"] = 7025] = "WALLET_WITHDRAWAL_KYC_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["WALLET_DEPOSIT_GROUP_INSUFFICIENT_BALANCE"] = 7026] = "WALLET_DEPOSIT_GROUP_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PUSH_PAYMENT_INSUFFICIENT_BALANCE"] = 7027] = "WALLET_PEER_PUSH_PAYMENT_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PULL_PAYMENT_INSUFFICIENT_BALANCE"] = 7028] = "WALLET_PEER_PULL_PAYMENT_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_REFRESH_GROUP_INCOMPLETE"] = 7029] = "WALLET_REFRESH_GROUP_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_BASE_URL_MISMATCH"] = 7030] = "WALLET_EXCHANGE_BASE_URL_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["WALLET_ORDER_ALREADY_PAID"] = 7031] = "WALLET_ORDER_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_UNAVAILABLE"] = 7032] = "WALLET_EXCHANGE_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_USED"] = 7033] = "WALLET_EXCHANGE_ENTRY_USED";
  TalerErrorCode2[TalerErrorCode2["WALLET_DB_UNAVAILABLE"] = 7034] = "WALLET_DB_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_TALER_URI_MALFORMED"] = 7035] = "WALLET_TALER_URI_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_REQUEST_CANCELLED"] = 7036] = "WALLET_CORE_REQUEST_CANCELLED";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_TOS_NOT_ACCEPTED"] = 7037] = "WALLET_EXCHANGE_TOS_NOT_ACCEPTED";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_UPDATE_CONFLICT"] = 7038] = "WALLET_EXCHANGE_ENTRY_UPDATE_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_OUTDATED"] = 7039] = "WALLET_EXCHANGE_ENTRY_OUTDATED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_KYC_MISSING"] = 7040] = "WALLET_PAY_MERCHANT_KYC_MISSING";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PULL_DEBIT_PURSE_GONE"] = 7041] = "WALLET_PEER_PULL_DEBIT_PURSE_GONE";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_ABORTED_BY_USER"] = 7042] = "WALLET_TRANSACTION_ABORTED_BY_USER";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_ABANDONED_BY_USER"] = 7043] = "WALLET_TRANSACTION_ABANDONED_BY_USER";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_ORDER_GONE"] = 7044] = "WALLET_PAY_MERCHANT_ORDER_GONE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_NOT_FOUND"] = 7045] = "WALLET_EXCHANGE_ENTRY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["WALLET_REQUEST_TRANSACTION_STATE_UNSUPPORTED"] = 7046] = "WALLET_REQUEST_TRANSACTION_STATE_UNSUPPORTED";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_PROTOCOL_VIOLATION"] = 7047] = "WALLET_TRANSACTION_PROTOCOL_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_API_BAD_REQUEST"] = 7048] = "WALLET_CORE_API_BAD_REQUEST";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_BACKEND_TIMEOUT"] = 8e3] = "ANASTASIS_GENERIC_BACKEND_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_INVALID_PAYMENT_REQUEST"] = 8001] = "ANASTASIS_GENERIC_INVALID_PAYMENT_REQUEST";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_BACKEND_ERROR"] = 8002] = "ANASTASIS_GENERIC_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_MISSING_CONTENT_LENGTH"] = 8003] = "ANASTASIS_GENERIC_MISSING_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_MALFORMED_CONTENT_LENGTH"] = 8004] = "ANASTASIS_GENERIC_MALFORMED_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_ORDER_CREATE_BACKEND_ERROR"] = 8005] = "ANASTASIS_GENERIC_ORDER_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PAYMENT_CHECK_UNAUTHORIZED"] = 8006] = "ANASTASIS_GENERIC_PAYMENT_CHECK_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PAYMENT_CHECK_START_FAILED"] = 8007] = "ANASTASIS_GENERIC_PAYMENT_CHECK_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PROVIDER_UNREACHABLE"] = 8008] = "ANASTASIS_GENERIC_PROVIDER_UNREACHABLE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_PAYMENT_GENERIC_TIMEOUT"] = 8009] = "ANASTASIS_PAYMENT_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UNKNOWN"] = 8108] = "ANASTASIS_TRUTH_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_AUTHORIZATION_METHOD_NO_LONGER_SUPPORTED"] = 8109] = "ANASTASIS_TRUTH_AUTHORIZATION_METHOD_NO_LONGER_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_RESPONSE_REQUIRED"] = 8110] = "ANASTASIS_TRUTH_CHALLENGE_RESPONSE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_FAILED"] = 8111] = "ANASTASIS_TRUTH_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_UNKNOWN"] = 8112] = "ANASTASIS_TRUTH_CHALLENGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_AUTHORIZATION_START_FAILED"] = 8114] = "ANASTASIS_TRUTH_AUTHORIZATION_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_KEY_SHARE_GONE"] = 8115] = "ANASTASIS_TRUTH_KEY_SHARE_GONE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_ORDER_DISAPPEARED"] = 8116] = "ANASTASIS_TRUTH_ORDER_DISAPPEARED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_BACKEND_EXCHANGE_BAD"] = 8117] = "ANASTASIS_TRUTH_BACKEND_EXCHANGE_BAD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UNEXPECTED_PAYMENT_STATUS"] = 8118] = "ANASTASIS_TRUTH_UNEXPECTED_PAYMENT_STATUS";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_PAYMENT_CREATE_BACKEND_ERROR"] = 8119] = "ANASTASIS_TRUTH_PAYMENT_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_DECRYPTION_FAILED"] = 8120] = "ANASTASIS_TRUTH_DECRYPTION_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_RATE_LIMITED"] = 8121] = "ANASTASIS_TRUTH_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_WRONG_METHOD"] = 8123] = "ANASTASIS_TRUTH_CHALLENGE_WRONG_METHOD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UPLOAD_UUID_EXISTS"] = 8150] = "ANASTASIS_TRUTH_UPLOAD_UUID_EXISTS";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UPLOAD_METHOD_NOT_SUPPORTED"] = 8151] = "ANASTASIS_TRUTH_UPLOAD_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_PHONE_INVALID"] = 8200] = "ANASTASIS_SMS_PHONE_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_HELPER_EXEC_FAILED"] = 8201] = "ANASTASIS_SMS_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_HELPER_COMMAND_FAILED"] = 8202] = "ANASTASIS_SMS_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_INVALID"] = 8210] = "ANASTASIS_EMAIL_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_HELPER_EXEC_FAILED"] = 8211] = "ANASTASIS_EMAIL_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_HELPER_COMMAND_FAILED"] = 8212] = "ANASTASIS_EMAIL_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_INVALID"] = 8220] = "ANASTASIS_POST_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_HELPER_EXEC_FAILED"] = 8221] = "ANASTASIS_POST_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_HELPER_COMMAND_FAILED"] = 8222] = "ANASTASIS_POST_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_IBAN_INVALID"] = 8230] = "ANASTASIS_IBAN_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_IBAN_MISSING_TRANSFER"] = 8231] = "ANASTASIS_IBAN_MISSING_TRANSFER";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TOTP_KEY_MISSING"] = 8240] = "ANASTASIS_TOTP_KEY_MISSING";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TOTP_KEY_INVALID"] = 8241] = "ANASTASIS_TOTP_KEY_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_IF_NONE_MATCH"] = 8301] = "ANASTASIS_POLICY_BAD_IF_NONE_MATCH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_OUT_OF_MEMORY_ON_CONTENT_LENGTH"] = 8304] = "ANASTASIS_POLICY_OUT_OF_MEMORY_ON_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_SIGNATURE"] = 8305] = "ANASTASIS_POLICY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_IF_MATCH"] = 8306] = "ANASTASIS_POLICY_BAD_IF_MATCH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_INVALID_UPLOAD"] = 8307] = "ANASTASIS_POLICY_INVALID_UPLOAD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_NOT_FOUND"] = 8350] = "ANASTASIS_POLICY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_ACTION_INVALID"] = 8400] = "ANASTASIS_REDUCER_ACTION_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_STATE_INVALID"] = 8401] = "ANASTASIS_REDUCER_STATE_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_INVALID"] = 8402] = "ANASTASIS_REDUCER_INPUT_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_AUTHENTICATION_METHOD_NOT_SUPPORTED"] = 8403] = "ANASTASIS_REDUCER_AUTHENTICATION_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_INVALID_FOR_STATE"] = 8404] = "ANASTASIS_REDUCER_INPUT_INVALID_FOR_STATE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_BACKEND_FAILURE"] = 8405] = "ANASTASIS_REDUCER_BACKEND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_RESOURCE_MALFORMED"] = 8406] = "ANASTASIS_REDUCER_RESOURCE_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_RESOURCE_MISSING"] = 8407] = "ANASTASIS_REDUCER_RESOURCE_MISSING";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_REGEX_FAILED"] = 8408] = "ANASTASIS_REDUCER_INPUT_REGEX_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_VALIDATION_FAILED"] = 8409] = "ANASTASIS_REDUCER_INPUT_VALIDATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_POLICY_LOOKUP_FAILED"] = 8410] = "ANASTASIS_REDUCER_POLICY_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_BACKUP_PROVIDER_FAILED"] = 8411] = "ANASTASIS_REDUCER_BACKUP_PROVIDER_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDER_CONFIG_FAILED"] = 8412] = "ANASTASIS_REDUCER_PROVIDER_CONFIG_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_POLICY_MALFORMED"] = 8413] = "ANASTASIS_REDUCER_POLICY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_NETWORK_FAILED"] = 8414] = "ANASTASIS_REDUCER_NETWORK_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_SECRET_MALFORMED"] = 8415] = "ANASTASIS_REDUCER_SECRET_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_CHALLENGE_DATA_TOO_BIG"] = 8416] = "ANASTASIS_REDUCER_CHALLENGE_DATA_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_SECRET_TOO_BIG"] = 8417] = "ANASTASIS_REDUCER_SECRET_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDER_INVALID_CONFIG"] = 8418] = "ANASTASIS_REDUCER_PROVIDER_INVALID_CONFIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INTERNAL_ERROR"] = 8419] = "ANASTASIS_REDUCER_INTERNAL_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDERS_ALREADY_SYNCED"] = 8420] = "ANASTASIS_REDUCER_PROVIDERS_ALREADY_SYNCED";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_KEYS_MISSING"] = 8607] = "DONAU_GENERIC_KEYS_MISSING";
  TalerErrorCode2[TalerErrorCode2["DONAU_CHARITY_SIGNATURE_INVALID"] = 8608] = "DONAU_CHARITY_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["DONAU_CHARITY_NOT_FOUND"] = 8609] = "DONAU_CHARITY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["DONAU_EXCEEDING_DONATION_LIMIT"] = 8610] = "DONAU_EXCEEDING_DONATION_LIMIT";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_DONATION_UNIT_UNKNOWN"] = 8611] = "DONAU_GENERIC_DONATION_UNIT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONATION_UNIT_HELPER_UNAVAILABLE"] = 8612] = "DONAU_DONATION_UNIT_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["DONAU_SIGNKEY_HELPER_UNAVAILABLE"] = 8613] = "DONAU_SIGNKEY_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["DONAU_SIGNKEY_HELPER_BUG"] = 8614] = "DONAU_SIGNKEY_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_WRONG_NUMBER_OF_SEGMENTS"] = 8615] = "DONAU_GENERIC_WRONG_NUMBER_OF_SEGMENTS";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONATION_RECEIPT_SIGNATURE_INVALID"] = 8616] = "DONAU_DONATION_RECEIPT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONOR_IDENTIFIER_NONCE_REUSE"] = 8617] = "DONAU_DONOR_IDENTIFIER_NONCE_REUSE";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_NEXUS_GENERIC_ERROR"] = 9e3] = "LIBEUFIN_NEXUS_GENERIC_ERROR";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_NEXUS_UNCAUGHT_EXCEPTION"] = 9001] = "LIBEUFIN_NEXUS_UNCAUGHT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_SANDBOX_GENERIC_ERROR"] = 9500] = "LIBEUFIN_SANDBOX_GENERIC_ERROR";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_SANDBOX_UNCAUGHT_EXCEPTION"] = 9501] = "LIBEUFIN_SANDBOX_UNCAUGHT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["TALDIR_METHOD_NOT_SUPPORTED"] = 9600] = "TALDIR_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["TALDIR_REGISTER_RATE_LIMITED"] = 9601] = "TALDIR_REGISTER_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_CLIENT_UNKNOWN"] = 9750] = "CHALLENGER_GENERIC_CLIENT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_CLIENT_FORBIDDEN_BAD_REDIRECT_URI"] = 9751] = "CHALLENGER_GENERIC_CLIENT_FORBIDDEN_BAD_REDIRECT_URI";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_HELPER_EXEC_FAILED"] = 9752] = "CHALLENGER_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GRANT_UNKNOWN"] = 9753] = "CHALLENGER_GRANT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_BAD_CODE"] = 9754] = "CHALLENGER_CLIENT_FORBIDDEN_BAD_CODE";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_VALIDATION_UNKNOWN"] = 9755] = "CHALLENGER_GENERIC_VALIDATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_INVALID_CODE"] = 9756] = "CHALLENGER_CLIENT_FORBIDDEN_INVALID_CODE";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_TOO_MANY_ATTEMPTS"] = 9757] = "CHALLENGER_TOO_MANY_ATTEMPTS";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_INVALID_PIN"] = 9758] = "CHALLENGER_INVALID_PIN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_MISSING_ADDRESS"] = 9759] = "CHALLENGER_MISSING_ADDRESS";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_READ_ONLY"] = 9760] = "CHALLENGER_CLIENT_FORBIDDEN_READ_ONLY";
  TalerErrorCode2[TalerErrorCode2["END"] = 9999] = "END";
})(TalerErrorCode || (TalerErrorCode = {}));

// ../taler-util/lib/time.js
var opaque_AbsoluteTime = Symbol("opaque_AbsoluteTime");
var TalerPreciseTimestamp;
(function(TalerPreciseTimestamp2) {
  function now2() {
    const absNow = AbsoluteTime.now();
    return AbsoluteTime.toPreciseTimestamp(absNow);
  }
  TalerPreciseTimestamp2.now = now2;
  function round(t5) {
    return {
      t_s: t5.t_s
    };
  }
  TalerPreciseTimestamp2.round = round;
  function fromSeconds(s6) {
    return {
      t_s: Math.floor(s6),
      off_us: Math.floor((s6 - Math.floor(s6)) / 1e3 / 1e3)
    };
  }
  TalerPreciseTimestamp2.fromSeconds = fromSeconds;
  function fromMilliseconds(ms) {
    return {
      t_s: Math.floor(ms / 1e3),
      off_us: Math.floor((ms - Math.floor(ms / 1e3) * 1e3) * 1e3)
    };
  }
  TalerPreciseTimestamp2.fromMilliseconds = fromMilliseconds;
})(TalerPreciseTimestamp || (TalerPreciseTimestamp = {}));
var TalerProtocolDuration;
(function(TalerProtocolDuration3) {
  function fromSpec(d6) {
    return Duration.toTalerProtocolDuration(Duration.fromSpec(d6));
  }
  TalerProtocolDuration3.fromSpec = fromSpec;
  function forever() {
    return {
      d_us: "forever"
    };
  }
  TalerProtocolDuration3.forever = forever;
})(TalerProtocolDuration || (TalerProtocolDuration = {}));
var TalerProtocolTimestamp;
(function(TalerProtocolTimestamp2) {
  function now2() {
    return AbsoluteTime.toProtocolTimestamp(AbsoluteTime.now());
  }
  TalerProtocolTimestamp2.now = now2;
  function zero() {
    return {
      t_s: 0
    };
  }
  TalerProtocolTimestamp2.zero = zero;
  function never() {
    return {
      t_s: "never"
    };
  }
  TalerProtocolTimestamp2.never = never;
  function isNever(t5) {
    return t5.t_s === "never";
  }
  TalerProtocolTimestamp2.isNever = isNever;
  function fromSeconds(s6) {
    return {
      t_s: s6
    };
  }
  TalerProtocolTimestamp2.fromSeconds = fromSeconds;
  function min(t1, t22) {
    if (t1.t_s === "never") {
      return { t_s: t22.t_s };
    }
    if (t22.t_s === "never") {
      return { t_s: t1.t_s };
    }
    return { t_s: Math.min(t1.t_s, t22.t_s) };
  }
  TalerProtocolTimestamp2.min = min;
  function max(t1, t22) {
    if (t1.t_s === "never" || t22.t_s === "never") {
      return { t_s: "never" };
    }
    return { t_s: Math.max(t1.t_s, t22.t_s) };
  }
  TalerProtocolTimestamp2.max = max;
})(TalerProtocolTimestamp || (TalerProtocolTimestamp = {}));
var timeshift = 0;
var Duration;
(function(Duration3) {
  function toMilliseconds(d6) {
    if (d6.d_ms === "forever") {
      return Number.MAX_VALUE;
    }
    return d6.d_ms;
  }
  Duration3.toMilliseconds = toMilliseconds;
  function getRemaining(deadline, now2 = AbsoluteTime.now()) {
    if (deadline.t_ms === "never") {
      return { d_ms: "forever" };
    }
    if (now2.t_ms === "never") {
      throw Error("invalid argument for 'now'");
    }
    if (deadline.t_ms < now2.t_ms) {
      return { d_ms: 0 };
    }
    return { d_ms: deadline.t_ms - now2.t_ms };
  }
  Duration3.getRemaining = getRemaining;
  function fromPrettyString(s6) {
    let dMs = 0;
    let currentNum = "";
    let parsingNum = true;
    for (let i5 = 0; i5 < s6.length; i5++) {
      const cc = s6.charCodeAt(i5);
      if (cc >= "0".charCodeAt(0) && cc <= "9".charCodeAt(0)) {
        if (!parsingNum) {
          throw Error("invalid duration, unexpected number");
        }
        currentNum += s6[i5];
        continue;
      }
      if (s6[i5] == " ") {
        if (currentNum != "") {
          parsingNum = false;
        }
        continue;
      }
      if (currentNum == "") {
        throw Error("invalid duration, missing number");
      }
      if (s6[i5] === "s") {
        if (s6.startsWith("seconds", i5)) {
          i5 += "seconds".length - 1;
        }
        dMs += 1e3 * Number.parseInt(currentNum, 10);
      } else if (s6[i5] === "m") {
        if (s6.startsWith("minutes", i5)) {
          i5 += "minutes".length - 1;
        }
        dMs += 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else if (s6[i5] === "h") {
        if (s6.startsWith("hours", i5)) {
          i5 += "hours".length - 1;
        }
        dMs += 60 * 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else if (s6[i5] === "d") {
        if (s6.startsWith("days", i5)) {
          i5 += "days".length - 1;
        }
        dMs += 24 * 60 * 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else {
        throw Error("invalid duration, unsupported unit");
      }
      currentNum = "";
      parsingNum = true;
    }
    return {
      d_ms: dMs
    };
  }
  Duration3.fromPrettyString = fromPrettyString;
  function cmp(d1, d23) {
    if (d1.d_ms === "forever") {
      if (d23.d_ms === "forever") {
        return 0;
      }
      return 1;
    }
    if (d23.d_ms === "forever") {
      return -1;
    }
    if (d1.d_ms == d23.d_ms) {
      return 0;
    }
    if (d1.d_ms > d23.d_ms) {
      return 1;
    }
    return -1;
  }
  Duration3.cmp = cmp;
  function max(d1, d23) {
    return durationMax(d1, d23);
  }
  Duration3.max = max;
  function min(d1, d23) {
    return durationMin(d1, d23);
  }
  Duration3.min = min;
  function multiply(d1, n2) {
    return durationMul(d1, n2);
  }
  Duration3.multiply = multiply;
  function toIntegerYears(d6) {
    if (typeof d6.d_ms !== "number") {
      throw Error("infinite duration");
    }
    return Math.ceil(d6.d_ms / 1e3 / 60 / 60 / 24 / 365);
  }
  Duration3.toIntegerYears = toIntegerYears;
  function fromSpec(spec) {
    let d_ms = 0;
    d_ms += (spec.seconds ?? 0) * SECONDS;
    d_ms += (spec.minutes ?? 0) * MINUTES;
    d_ms += (spec.hours ?? 0) * HOURS;
    d_ms += (spec.days ?? 0) * DAYS;
    d_ms += (spec.months ?? 0) * MONTHS;
    d_ms += (spec.years ?? 0) * YEARS;
    return { d_ms };
  }
  Duration3.fromSpec = fromSpec;
  function fromSpecOrUndefined(spec) {
    if (spec.seconds == void 0 && spec.minutes == void 0 && spec.hours == void 0 && spec.days == void 0 && spec.months == void 0 && spec.years == void 0) {
      return void 0;
    }
    return Duration3.fromSpec(spec);
  }
  Duration3.fromSpecOrUndefined = fromSpecOrUndefined;
  function toSpec({ d_ms }) {
    if (d_ms === "forever")
      return void 0;
    const ms = d_ms > 0 ? d_ms : 0;
    const Y_rest = ms % YEARS;
    const M_rest = Y_rest % MONTHS;
    const D_rest = M_rest % DAYS;
    const h_rest = D_rest % HOURS;
    const m_rest = h_rest % MINUTES;
    const millis = m_rest % SECONDS;
    return {
      years: (ms - Y_rest) / YEARS,
      month: (Y_rest - M_rest) / MONTHS,
      days: (M_rest - D_rest) / DAYS,
      hours: (D_rest - h_rest) / HOURS,
      minutes: (h_rest - m_rest) / MINUTES,
      seconds: (m_rest - millis) / SECONDS
    };
  }
  Duration3.toSpec = toSpec;
  function getForever() {
    return { d_ms: "forever" };
  }
  Duration3.getForever = getForever;
  function getZero() {
    return { d_ms: 0 };
  }
  Duration3.getZero = getZero;
  function fromTalerProtocolDuration(d6) {
    if (d6.d_us === "forever") {
      return {
        d_ms: "forever"
      };
    }
    return {
      d_ms: Math.floor(d6.d_us / 1e3)
    };
  }
  Duration3.fromTalerProtocolDuration = fromTalerProtocolDuration;
  function toTalerProtocolDuration(d6) {
    if (d6.d_ms === "forever") {
      return {
        d_us: "forever"
      };
    }
    return {
      d_us: d6.d_ms * 1e3
    };
  }
  Duration3.toTalerProtocolDuration = toTalerProtocolDuration;
  function fromMilliseconds(ms) {
    return {
      d_ms: ms
    };
  }
  Duration3.fromMilliseconds = fromMilliseconds;
  function clamp(args) {
    return durationMax(durationMin(args.value, args.upper), args.lower);
  }
  Duration3.clamp = clamp;
})(Duration || (Duration = {}));
var AbsoluteTime;
(function(AbsoluteTime3) {
  function getStampMsNow() {
    return (/* @__PURE__ */ new Date()).getTime();
  }
  AbsoluteTime3.getStampMsNow = getStampMsNow;
  function getStampMsNever() {
    return Number.MAX_SAFE_INTEGER;
  }
  AbsoluteTime3.getStampMsNever = getStampMsNever;
  function now2() {
    return {
      t_ms: (/* @__PURE__ */ new Date()).getTime() + timeshift,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.now = now2;
  function never() {
    return {
      t_ms: "never",
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.never = never;
  function fromMilliseconds(ms) {
    return {
      t_ms: ms,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromMilliseconds = fromMilliseconds;
  function cmp(t1, t22) {
    if (t1.t_ms === "never") {
      if (t22.t_ms === "never") {
        return 0;
      }
      return 1;
    }
    if (t22.t_ms === "never") {
      return -1;
    }
    if (t1.t_ms == t22.t_ms) {
      return 0;
    }
    if (t1.t_ms > t22.t_ms) {
      return 1;
    }
    return -1;
  }
  AbsoluteTime3.cmp = cmp;
  function min(t1, t22) {
    if (t1.t_ms === "never") {
      return { t_ms: t22.t_ms, [opaque_AbsoluteTime]: true };
    }
    if (t22.t_ms === "never") {
      return { t_ms: t22.t_ms, [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.min(t1.t_ms, t22.t_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.min = min;
  function max(t1, t22) {
    if (t1.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    if (t22.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.max(t1.t_ms, t22.t_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.max = max;
  function difference2(t1, t22) {
    if (t1.t_ms === "never") {
      return { d_ms: "forever" };
    }
    if (t22.t_ms === "never") {
      return { d_ms: "forever" };
    }
    return { d_ms: Math.abs(t1.t_ms - t22.t_ms) };
  }
  AbsoluteTime3.difference = difference2;
  function isExpired(t5) {
    return cmp(t5, now2()) <= 0;
  }
  AbsoluteTime3.isExpired = isExpired;
  function isNever(t5) {
    return t5.t_ms === "never";
  }
  AbsoluteTime3.isNever = isNever;
  function fromProtocolTimestamp(t5) {
    if (t5.t_s === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return {
      t_ms: t5.t_s * 1e3,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromProtocolTimestamp = fromProtocolTimestamp;
  function fromStampMs(stampMs) {
    return {
      t_ms: stampMs,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromStampMs = fromStampMs;
  function fromPreciseTimestamp(t5) {
    if (t5.t_s === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    const offsetUs = t5.off_us ?? 0;
    return {
      t_ms: t5.t_s * 1e3 + Math.floor(offsetUs / 1e3),
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromPreciseTimestamp = fromPreciseTimestamp;
  function toStampMs(at2) {
    if (at2.t_ms === "never") {
      return Number.MAX_SAFE_INTEGER;
    }
    return at2.t_ms;
  }
  AbsoluteTime3.toStampMs = toStampMs;
  function toPreciseTimestamp(at2) {
    if (at2.t_ms == "never") {
      return {
        t_s: "never"
      };
    }
    const t_s = Math.floor(at2.t_ms / 1e3);
    const off_us = Math.floor(1e3 * (at2.t_ms - t_s * 1e3));
    return {
      t_s,
      off_us
    };
  }
  AbsoluteTime3.toPreciseTimestamp = toPreciseTimestamp;
  function toProtocolTimestamp(at2) {
    if (at2.t_ms === "never") {
      return { t_s: "never" };
    }
    return {
      t_s: Math.floor(at2.t_ms / 1e3)
    };
  }
  AbsoluteTime3.toProtocolTimestamp = toProtocolTimestamp;
  function isBetween(t5, start, end) {
    if (cmp(t5, start) < 0) {
      return false;
    }
    if (cmp(t5, end) > 0) {
      return false;
    }
    return true;
  }
  AbsoluteTime3.isBetween = isBetween;
  function toIsoString(t5) {
    if (t5.t_ms === "never") {
      return "<never>";
    } else {
      return new Date(t5.t_ms).toISOString();
    }
  }
  AbsoluteTime3.toIsoString = toIsoString;
  function addDuration(t1, d6) {
    if (t1.t_ms === "never" || d6.d_ms === "forever") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return { t_ms: t1.t_ms + d6.d_ms, [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.addDuration = addDuration;
  function remaining(t1) {
    if (t1.t_ms === "never") {
      return Duration.getForever();
    }
    const stampNow = now2();
    if (stampNow.t_ms === "never") {
      throw Error("invariant violated");
    }
    return Duration.fromMilliseconds(Math.max(0, t1.t_ms - stampNow.t_ms));
  }
  AbsoluteTime3.remaining = remaining;
  function subtractDuraction(t1, d6) {
    if (t1.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    if (d6.d_ms === "forever") {
      return { t_ms: 0, [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.max(0, t1.t_ms - d6.d_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.subtractDuraction = subtractDuraction;
  function stringify(t5) {
    if (t5.t_ms === "never") {
      return "never";
    }
    return new Date(t5.t_ms).toISOString();
  }
  AbsoluteTime3.stringify = stringify;
})(AbsoluteTime || (AbsoluteTime = {}));
var SECONDS = 1e3;
var MINUTES = SECONDS * 60;
var HOURS = MINUTES * 60;
var DAYS = HOURS * 24;
var MONTHS = DAYS * 30;
var YEARS = DAYS * 365;
function durationMin(d1, d23) {
  if (d1.d_ms === "forever") {
    return { d_ms: d23.d_ms };
  }
  if (d23.d_ms === "forever") {
    return { d_ms: d1.d_ms };
  }
  return { d_ms: Math.min(d1.d_ms, d23.d_ms) };
}
function durationMax(d1, d23) {
  if (d1.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  if (d23.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  return { d_ms: Math.max(d1.d_ms, d23.d_ms) };
}
function durationMul(d6, n2) {
  if (d6.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  return { d_ms: Math.round(d6.d_ms * n2) };
}
var codecForAbsoluteTime = {
  decode(x6, c5) {
    if (x6 === void 0) {
      throw Error(`got undefined and expected absolute time at ${renderContext(c5)}`);
    }
    const t_ms = x6.t_ms;
    if (typeof t_ms === "string") {
      if (t_ms === "never") {
        return { t_ms: "never", [opaque_AbsoluteTime]: true };
      }
    } else if (typeof t_ms === "number") {
      return { t_ms, [opaque_AbsoluteTime]: true };
    }
    throw Error(`expected timestamp at ${renderContext(c5)}`);
  }
};
var codecForTimestamp = {
  decode(x6, c5) {
    if (x6 === void 0) {
      throw Error(`got undefined and expected timestamp at ${renderContext(c5)}`);
    }
    const t_ms = x6.t_ms;
    if (typeof t_ms === "string") {
      if (t_ms === "never") {
        return { t_s: "never" };
      }
    } else if (typeof t_ms === "number") {
      return { t_s: Math.floor(t_ms / 1e3) };
    }
    const t_s = x6.t_s;
    if (typeof t_s === "string") {
      if (t_s === "never") {
        return { t_s: "never" };
      }
      throw Error(`expected timestamp at ${renderContext(c5)}`);
    }
    if (typeof t_s === "number") {
      return { t_s };
    }
    throw Error(`expected protocol timestamp at ${renderContext(c5)}`);
  }
};
var codecForPreciseTimestamp = {
  decode(x6, c5) {
    const t_ms = x6.t_ms;
    if (typeof t_ms === "string") {
      if (t_ms === "never") {
        return { t_s: "never" };
      }
    } else if (typeof t_ms === "number") {
      return { t_s: Math.floor(t_ms / 1e3) };
    }
    throw Error(`expected precise timestamp at ${renderContext(c5)}`);
  }
};
var codecForDuration = {
  decode(x6, c5) {
    const d_us = x6.d_us;
    if (typeof d_us === "string") {
      if (d_us === "forever") {
        return { d_us: "forever" };
      }
      throw Error(`expected duration at ${renderContext(c5)}`);
    }
    if (typeof d_us === "number") {
      return { d_us };
    }
    throw Error(`expected duration at ${renderContext(c5)}`);
  }
};

// ../taler-util/lib/http-common.js
var textEncoder = new TextEncoder();
var logger2 = new Logger("http.ts");
var DEFAULT_REQUEST_TIMEOUT_MS = 6e4;
var HeadersImpl = class {
  constructor() {
    this.headerMap = /* @__PURE__ */ new Map();
  }
  get(name) {
    const r3 = this.headerMap.get(name.toLowerCase());
    if (r3) {
      return r3;
    }
    return null;
  }
  set(name, value) {
    const normalizedName = name.toLowerCase();
    const existing = this.headerMap.get(normalizedName);
    if (existing !== void 0) {
      this.headerMap.set(normalizedName, existing + "," + value);
    } else {
      this.headerMap.set(normalizedName, value);
    }
  }
  toJSON() {
    const m6 = {};
    this.headerMap.forEach((v3, k6) => m6[k6] = v3);
    return m6;
  }
};
async function readTalerErrorResponse(httpResponse) {
  const contentType = httpResponse.headers.get("content-type");
  if (contentType !== "application/json") {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      contentType: contentType || "<null>"
    }, "Error response did not even contain JSON. The request URL might be wrong or the service might be unavailable.");
  }
  let errJson;
  try {
    errJson = await httpResponse.json();
  } catch (e5) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e5 instanceof Error ? e5.message : String(e5)
    }, "Couldn't parse JSON format from error response");
  }
  const talerErrorCode = errJson.code;
  if (typeof talerErrorCode !== "number") {
    logger2.warn(`malformed error response (status ${httpResponse.status}): ${j2s(errJson)}`);
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text()
    }, "Error response did not contain error code");
  }
  return errJson;
}
async function readSuccessResponseJsonOrErrorCode(httpResponse, codec) {
  if (!(httpResponse.status >= 200 && httpResponse.status < 300)) {
    return {
      isError: true,
      talerErrorResponse: await readTalerErrorResponse(httpResponse)
    };
  }
  let respJson;
  try {
    respJson = await httpResponse.json();
  } catch (e5) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e5 instanceof Error ? e5.message : String(e5)
    }, "Couldn't parse JSON format from response");
  }
  let parsedResponse;
  try {
    parsedResponse = codec.decode(respJson);
  } catch (e5) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e5 instanceof Error ? e5.message : String(e5)
    }, "Response invalid");
  }
  return {
    isError: false,
    response: parsedResponse
  };
}
async function readResponseJsonOrThrow(httpResponse, codec) {
  let respJson;
  try {
    respJson = await httpResponse.json();
  } catch (e5) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e5 instanceof Error ? e5.message : String(e5)
    }, "Couldn't parse JSON format from response");
  }
  let parsedResponse;
  try {
    parsedResponse = codec.decode(respJson);
  } catch (e5) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e5 instanceof Error ? e5.message : String(e5)
    }, "Response invalid");
  }
  return parsedResponse;
}
function throwUnexpectedRequestError(httpResponse, talerErrorResponse) {
  const errorDetails = {
    requestUrl: httpResponse.requestUrl,
    requestMethod: httpResponse.requestMethod,
    httpStatusCode: httpResponse.status,
    errorResponse: talerErrorResponse
  };
  logger2.trace(`unexpected request error: ${j2s(errorDetails)}`);
  throw TalerError.fromDetail(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR, errorDetails, `Unexpected HTTP status ${httpResponse.status} in response`);
}
async function readSuccessResponseJsonOrThrow(httpResponse, codec) {
  const r3 = await readSuccessResponseJsonOrErrorCode(httpResponse, codec);
  if (!r3.isError) {
    return r3.response;
  }
  throwUnexpectedRequestError(httpResponse, r3.talerErrorResponse);
}
function encodeBody(body) {
  if (body == null) {
    return new ArrayBuffer(0);
  }
  if (typeof body === "string") {
    return textEncoder.encode(body).buffer;
  } else if (ArrayBuffer.isView(body)) {
    return body.buffer;
  } else if (body instanceof ArrayBuffer) {
    return body;
  } else if (body instanceof URLSearchParams) {
    return textEncoder.encode(body.toString()).buffer;
  } else if (typeof body === "object" && body.constructor.name === "FormData") {
    return body;
  } else if (typeof body === "object") {
    return textEncoder.encode(JSON.stringify(body)).buffer;
  }
  throw new TypeError("unsupported request body type");
}
function getDefaultHeaders(method) {
  const headers = {};
  if (method === "POST" || method === "PUT" || method === "PATCH") {
    headers["Content-Type"] = "application/json";
  }
  headers["Accept"] = "application/json";
  return headers;
}
function makeBasicAuthHeader(username, password) {
  const auth = `${username}:${password}`;
  const authEncoded = base64FromArrayBuffer(stringToBytes(auth));
  return `Basic ${authEncoded}`;
}

// ../taler-util/lib/libtool-version.js
var LibtoolVersion;
(function(LibtoolVersion2) {
  function compare2(me, other) {
    const meVer = parseVersion(me);
    const otherVer = parseVersion(other);
    if (!(meVer && otherVer)) {
      return void 0;
    }
    const compatible = meVer.current - meVer.age <= otherVer.current && meVer.current >= otherVer.current - otherVer.age;
    const currentCmp = Math.sign(meVer.current - otherVer.current);
    return { compatible, currentCmp };
  }
  LibtoolVersion2.compare = compare2;
  function parseVersionOrThrow(v3) {
    const res = parseVersion(v3);
    if (!res) {
      throw Error("invalid libtool version");
    }
    return res;
  }
  LibtoolVersion2.parseVersionOrThrow = parseVersionOrThrow;
  function parseVersion(v3) {
    const [currentStr, revisionStr, ageStr, ...rest] = v3.split(":");
    if (rest.length !== 0) {
      return void 0;
    }
    const current = Number.parseInt(currentStr);
    const revision = Number.parseInt(revisionStr);
    const age = Number.parseInt(ageStr);
    if (Number.isNaN(current)) {
      return void 0;
    }
    if (Number.isNaN(revision)) {
      return void 0;
    }
    if (Number.isNaN(age)) {
      return void 0;
    }
    return { current, revision, age };
  }
  LibtoolVersion2.parseVersion = parseVersion;
})(LibtoolVersion || (LibtoolVersion = {}));

// ../taler-util/lib/types-taler-common.js
var codecForURLString = codecForString;
var codecForCurrencyName = codecForString;
var codecForDecimalNumber = codecForString;
var codecForEddsaPublicKey = codecForString;
var codecForEddsaSignature = codecForString;
var codecForInternationalizedString = () => codecForMap(codecForString());
var codecForCurrencySpecificiation = () => buildCodecForObject().property("name", codecForString()).property("num_fractional_input_digits", codecForNumber()).property("num_fractional_normal_digits", codecForNumber()).property("num_fractional_trailing_zero_digits", codecForNumber()).property("alt_unit_names", codecForMap(codecForString())).property("common_amounts", codecOptional(codecForList(codecForAmountString()))).deprecatedProperty("currency").build("CurrencySpecification");
var codecForTalerCommonConfigResponse = () => buildCodecForObject().allowExtra().property("name", codecForString()).property("version", codecForString()).build("TalerCommonConfigResponse");
var ExchangeProtocolVersion;
(function(ExchangeProtocolVersion2) {
  ExchangeProtocolVersion2[ExchangeProtocolVersion2["V12"] = 12] = "V12";
})(ExchangeProtocolVersion || (ExchangeProtocolVersion = {}));
var MerchantProtocolVersion;
(function(MerchantProtocolVersion2) {
  MerchantProtocolVersion2[MerchantProtocolVersion2["V3"] = 3] = "V3";
})(MerchantProtocolVersion || (MerchantProtocolVersion = {}));
var codecForTokenInfo = () => buildCodecForObject().property("creation_time", codecForTimestamp).property("expiration", codecForTimestamp).property("scope", codecForString()).property("refreshable", codecForBoolean()).property("description", codecOptional(codecForString())).property("serial", codecForNumber()).build("TokenInfo");
var codecForTokenInfoList = () => buildCodecForObject().property("tokens", codecForList(codecForTokenInfo())).build("TokenInfoList");
var codecForAccessToken = codecForString;
var codecForTokenSuccessResponse = () => buildCodecForObject().property("access_token", codecForAccessToken()).property("expiration", codecForTimestamp).build("TalerAuthentication.TokenSuccessResponse");
var codecForURN = codecForString;

// ../taler-util/lib/operation.js
function isOperationOk(c5) {
  return c5.type === "ok";
}
function isOperationFail(c5) {
  return c5.type === "fail";
}
async function opSuccessFromHttp(resp, codec) {
  const body = await readSuccessResponseJsonOrThrow(resp, codec);
  return { type: "ok", case: "ok", body };
}
function opFixedSuccess(body) {
  return { type: "ok", case: "ok", body };
}
function opEmptySuccess() {
  return { type: "ok", case: "ok", body: void 0 };
}
function opKnownFailure(case_) {
  return { type: "fail", case: case_ };
}
function opKnownFailureWithBody(case_, body) {
  return { type: "fail", case: case_, body };
}
async function carefullyParseConfig(expectedName, clientVersion, httpResponse, codec) {
  const minBody = await readSuccessResponseJsonOrThrow(httpResponse, codecForTalerCommonConfigResponse());
  if (minBody.name !== expectedName) {
    throw TalerError.fromUncheckedDetail({
      code: TalerErrorCode.GENERIC_UNEXPECTED_REQUEST_ERROR,
      requestUrl: httpResponse.requestUrl,
      httpStatusCode: httpResponse.status,
      detail: `Unexpected server component name (got ${minBody.name}, expected ${expectedName}})`
    });
  }
  if (!LibtoolVersion.compare(clientVersion, minBody.version)) {
    throw TalerError.fromUncheckedDetail({
      code: TalerErrorCode.GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION,
      requestUrl: httpResponse.requestUrl,
      httpStatusCode: httpResponse.status,
      detail: `Unsupported protocol version, client supports ${clientVersion}, server supports ${minBody.version}`
    });
  }
  const body = await readSuccessResponseJsonOrThrow(httpResponse, codec);
  return opFixedSuccess(body);
}
async function opKnownAlternativeHttpFailure(resp, s6, codec) {
  const body = await readResponseJsonOrThrow(resp, codec);
  return { type: "fail", case: s6, body };
}
async function opKnownHttpFailure(_case, resp, detail) {
  if (!detail) {
    detail = await readTalerErrorResponse(resp);
  }
  return { type: "fail", case: _case, detail };
}
async function opUnknownHttpFailure(resp, detail) {
  if (!detail) {
    detail = await readTalerErrorResponse(resp);
  }
  throw TalerError.fromDetail(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR, {
    requestUrl: resp.requestUrl,
    requestMethod: resp.requestMethod,
    httpStatusCode: resp.status,
    errorResponse: detail
  }, `Unexpected HTTP status ${resp.status} in response`);
}
function opKnownTalerFailure(_case, detail) {
  return { type: "fail", case: _case, detail };
}
function succeedOrThrow(resp) {
  if (isOperationOk(resp)) {
    return resp.body;
  }
  if (isOperationFail(resp)) {
    throw TalerError.fromUncheckedDetail({ ...resp, case: resp.case });
  }
  throw TalerError.fromException(resp);
}

// ../taler-util/lib/amounts.js
var amountFractionalBase = 1e8;
var amountFractionalLength = 8;
var amountMaxValue = 2 ** 52;
var FRAC_SEPARATOR = ".";
var CURRENCY_SEPARATOR = ":";
var Amount = class _Amount {
  static from(a6) {
    return new _Amount(Amounts.parseOrThrow(a6), 0);
  }
  static zeroOfCurrency(currency) {
    return new _Amount(Amounts.zeroOfCurrency(currency), 0);
  }
  add(...a6) {
    if (this.saturated) {
      return this;
    }
    const r3 = Amounts.add(this.val, ...a6);
    return new _Amount(r3.amount, r3.saturated ? 1 : 0);
  }
  isZero() {
    return this.val.fraction === 0 && this.val.value === 0;
  }
  sub(...a6) {
    if (this.saturated) {
      return this;
    }
    const r3 = Amounts.sub(this.val, ...a6);
    return new _Amount(r3.amount, r3.saturated ? 1 : 0);
  }
  mult(n2) {
    if (this.saturated) {
      return this;
    }
    const r3 = Amounts.mult(this, n2);
    return new _Amount(r3.amount, r3.saturated ? 1 : 0);
  }
  toJson() {
    return { ...this.val };
  }
  toString() {
    return Amounts.stringify(this.val);
  }
  constructor(val, saturated) {
    this.val = val;
    this.saturated = saturated;
  }
};
function codecForAmountString() {
  return {
    decode(x6, c5) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
      }
      if (Amounts.parse(x6) === void 0) {
        throw new DecodingError(`invalid amount at ${renderContext(c5)} got "${x6}"`);
      }
      return x6;
    }
  };
}
var AmountParseError;
(function(AmountParseError2) {
  AmountParseError2[AmountParseError2["MISSING_CURRENCY"] = 0] = "MISSING_CURRENCY";
  AmountParseError2[AmountParseError2["CURRENCY_TOO_LONG"] = 1] = "CURRENCY_TOO_LONG";
  AmountParseError2[AmountParseError2["BAD_CURRENCY"] = 2] = "BAD_CURRENCY";
  AmountParseError2[AmountParseError2["BAD_NUMBER"] = 3] = "BAD_NUMBER";
  AmountParseError2[AmountParseError2["TOO_HIGH"] = 4] = "TOO_HIGH";
  AmountParseError2[AmountParseError2["TOO_PRECISE"] = 5] = "TOO_PRECISE";
})(AmountParseError || (AmountParseError = {}));
var Amounts = class _Amounts {
  constructor() {
    throw Error("not instantiable");
  }
  static currencyOf(amount) {
    const amt = _Amounts.parseOrThrow(amount);
    return amt.currency;
  }
  static zeroOfAmount(amount) {
    const amt = _Amounts.parseOrThrow(amount);
    return {
      currency: amt.currency,
      fraction: 0,
      value: 0
    };
  }
  /**
   * Get an amount that represents zero units of a currency.
   */
  static zeroOfCurrency(currency) {
    return {
      currency,
      fraction: 0,
      value: 0
    };
  }
  static jsonifyAmount(amt) {
    if (typeof amt === "string") {
      return _Amounts.parseOrThrow(amt);
    }
    if (amt instanceof Amount) {
      return amt.toJson();
    }
    return amt;
  }
  static divmod(a1, a23) {
    const am1 = _Amounts.jsonifyAmount(a1);
    const am2 = _Amounts.jsonifyAmount(a23);
    if (am1.currency != am2.currency) {
      throw Error(`incompatible currency (${am1.currency} vs${am2.currency})`);
    }
    const x1 = BigInt(am1.value) * BigInt(amountFractionalBase) + BigInt(am1.fraction);
    const x22 = BigInt(am2.value) * BigInt(amountFractionalBase) + BigInt(am2.fraction);
    const quotient = x1 / x22;
    const remainderScaled = x1 % x22;
    return {
      quotient: Number(quotient),
      remainder: {
        currency: am1.currency,
        value: Number(remainderScaled / BigInt(amountFractionalBase)),
        fraction: Number(remainderScaled % BigInt(amountFractionalBase))
      }
    };
  }
  static sum(amounts) {
    if (amounts.length <= 0) {
      throw Error("can't sum zero amounts");
    }
    const jsonAmounts = amounts.map((x6) => _Amounts.jsonifyAmount(x6));
    return _Amounts.add(jsonAmounts[0], ...jsonAmounts.slice(1));
  }
  static sumOrZero(currency, amounts) {
    if (amounts.length <= 0) {
      return {
        amount: _Amounts.zeroOfCurrency(currency),
        saturated: false
      };
    }
    const jsonAmounts = amounts.map((x6) => _Amounts.jsonifyAmount(x6));
    return _Amounts.add(jsonAmounts[0], ...jsonAmounts.slice(1));
  }
  /**
   * Add two amounts.  Return the result and whether
   * the addition overflowed.  The overflow is always handled
   * by saturating and never by wrapping.
   *
   * Throws when currencies don't match.
   */
  static add(first, ...rest) {
    const firstJ = _Amounts.jsonifyAmount(first);
    const currency = firstJ.currency;
    let value = firstJ.value + Math.floor(firstJ.fraction / amountFractionalBase);
    if (value > amountMaxValue) {
      return {
        amount: {
          currency,
          value: amountMaxValue,
          fraction: amountFractionalBase - 1
        },
        saturated: true
      };
    }
    let fraction = firstJ.fraction % amountFractionalBase;
    for (const x6 of rest) {
      const xJ = _Amounts.jsonifyAmount(x6);
      if (xJ.currency.toUpperCase() !== currency.toUpperCase()) {
        throw Error(`Mismatched currency: ${xJ.currency} and ${currency}`);
      }
      value = value + xJ.value + Math.floor((fraction + xJ.fraction) / amountFractionalBase);
      fraction = Math.floor((fraction + xJ.fraction) % amountFractionalBase);
      if (value > amountMaxValue) {
        return {
          amount: {
            currency,
            value: amountMaxValue,
            fraction: amountFractionalBase - 1
          },
          saturated: true
        };
      }
    }
    return { amount: { currency, value, fraction }, saturated: false };
  }
  /**
   * Subtract two amounts.  Return the result and whether
   * the subtraction overflowed.  The overflow is always handled
   * by saturating and never by wrapping.
   *
   * Throws when currencies don't match.
   */
  static sub(a6, ...rest) {
    const aJ = _Amounts.jsonifyAmount(a6);
    const currency = aJ.currency;
    let value = aJ.value;
    let fraction = aJ.fraction;
    for (const b5 of rest) {
      const bJ = _Amounts.jsonifyAmount(b5);
      if (bJ.currency.toUpperCase() !== aJ.currency.toUpperCase()) {
        throw Error(`Mismatched currency: ${bJ.currency} and ${currency}`);
      }
      if (fraction < bJ.fraction) {
        if (value < 1) {
          return {
            amount: { currency, value: 0, fraction: 0 },
            saturated: true
          };
        }
        value--;
        fraction += amountFractionalBase;
      }
      console.assert(fraction >= bJ.fraction);
      fraction -= bJ.fraction;
      if (value < bJ.value) {
        return { amount: { currency, value: 0, fraction: 0 }, saturated: true };
      }
      value -= bJ.value;
    }
    return { amount: { currency, value, fraction }, saturated: false };
  }
  /**
   * Compare two amounts.  Returns 0 when equal, -1 when a < b
   * and +1 when a > b.  Throws when currencies don't match.
   */
  static cmp(a6, b5) {
    a6 = _Amounts.jsonifyAmount(a6);
    b5 = _Amounts.jsonifyAmount(b5);
    if (a6.currency !== b5.currency) {
      throw Error(`Mismatched currency: ${a6.currency} and ${b5.currency}`);
    }
    const av = a6.value + Math.floor(a6.fraction / amountFractionalBase);
    const af = a6.fraction % amountFractionalBase;
    const bv = b5.value + Math.floor(b5.fraction / amountFractionalBase);
    const bf = b5.fraction % amountFractionalBase;
    switch (true) {
      case av < bv:
        return -1;
      case av > bv:
        return 1;
      case af < bf:
        return -1;
      case af > bf:
        return 1;
      case af === bf:
        return 0;
      default:
        throw Error("assertion failed");
    }
  }
  /**
   * Create a copy of an amount.
   */
  static copy(a6) {
    return {
      currency: a6.currency,
      fraction: a6.fraction,
      value: a6.value
    };
  }
  /**
   * Divide an amount.  Throws on division by zero.
   */
  static divide(a6, n2) {
    if (n2 === 0) {
      throw Error(`Division by 0`);
    }
    if (n2 === 1) {
      return { value: a6.value, fraction: a6.fraction, currency: a6.currency };
    }
    const r3 = a6.value % n2;
    return {
      currency: a6.currency,
      fraction: Math.floor((r3 * amountFractionalBase + a6.fraction) / n2),
      value: Math.floor(a6.value / n2)
    };
  }
  /**
   * Check if an amount is non-zero.
   */
  static isNonZero(a6) {
    a6 = _Amounts.jsonifyAmount(a6);
    return a6.value > 0 || a6.fraction > 0;
  }
  static isZero(a6) {
    a6 = _Amounts.jsonifyAmount(a6);
    return a6.value === 0 && a6.fraction === 0;
  }
  /**
   * Check whether a string is a valid currency for a Taler amount.
   */
  static isCurrency(s6) {
    return /^[a-zA-Z]{1,11}$/.test(s6);
  }
  /**
   * Parse an amount like 'EUR:20.5' for 20 Euros and 50 ct.
   *
   * Currency name size limit is 11 of ASCII letters
   * Fraction size limit is 8
   */
  static parseWithError(s6) {
    const c_idx = s6.indexOf(CURRENCY_SEPARATOR);
    if (c_idx === -1 || c_idx === 0) {
      return opKnownFailure(AmountParseError.MISSING_CURRENCY);
    }
    if (c_idx > 11) {
      return opKnownFailure(AmountParseError.MISSING_CURRENCY);
    }
    const currency = s6.substring(0, c_idx).toUpperCase();
    if (!/^[a-zA-Z]+$/.test(currency)) {
      return opKnownFailure(AmountParseError.BAD_CURRENCY);
    }
    const number = s6.substring(c_idx + 1);
    const d_idx = number.indexOf(FRAC_SEPARATOR);
    const integerStr = d_idx === -1 ? number : number.substring(0, d_idx);
    const fractStr = d_idx === -1 || d_idx === number.length ? "0" : number.substring(d_idx + 1);
    if (!/^[0-9]+$/.test(integerStr) || !/^[0-9]+$/.test(fractStr)) {
      return opKnownFailure(AmountParseError.BAD_NUMBER);
    }
    const value = Number.parseInt(integerStr, 10);
    const fraction = Math.round(amountFractionalBase * Number.parseFloat(FRAC_SEPARATOR + fractStr));
    if (!Number.isInteger(value) || !Number.isInteger(fraction)) {
      return opKnownFailure(AmountParseError.BAD_NUMBER);
    }
    if (value > amountMaxValue) {
      return opKnownFailure(AmountParseError.TOO_HIGH);
    }
    if (fractStr.length > amountFractionalLength) {
      return opKnownFailure(AmountParseError.TOO_PRECISE);
    }
    return opFixedSuccess({
      currency,
      fraction,
      value
    });
  }
  /**
   * Parse an amount like 'EUR:20.5' for 20 Euros and 50 ct.
   *
   * Currency name size limit is 11 of ASCII letters
   * Fraction size limit is 8
   */
  static parse(s6) {
    const res = s6.match(/^([a-zA-Z]{1,11}):([0-9]+)([.][0-9]{1,8})?$/);
    if (!res) {
      return void 0;
    }
    const tail = res[3] || FRAC_SEPARATOR + "0";
    if (tail.length > amountFractionalLength + 1) {
      return void 0;
    }
    const value = Number.parseInt(res[2]);
    if (value > amountMaxValue) {
      return void 0;
    }
    return {
      currency: res[1].toUpperCase(),
      fraction: Math.round(amountFractionalBase * Number.parseFloat(tail)),
      value
    };
  }
  /**
   * Parse amount in standard string form (like 'EUR:20.5'),
   * throw if the input is not a valid amount.
   */
  static parseOrThrow(s6) {
    if (s6 instanceof Amount) {
      return s6.toJson();
    }
    if (typeof s6 === "object") {
      if (typeof s6.currency !== "string") {
        throw Error("invalid amount object");
      }
      if (typeof s6.value !== "number") {
        throw Error("invalid amount object");
      }
      if (typeof s6.fraction !== "number") {
        throw Error("invalid amount object");
      }
      return { currency: s6.currency, value: s6.value, fraction: s6.fraction };
    } else if (typeof s6 === "string") {
      const res = _Amounts.parse(s6);
      if (!res) {
        throw Error(`Can't parse amount: "${s6}"`);
      }
      return res;
    } else {
      throw Error("invalid amount (illegal type)");
    }
  }
  static min(a6, b5) {
    const cr = _Amounts.cmp(a6, b5);
    if (cr >= 0) {
      return _Amounts.jsonifyAmount(b5);
    } else {
      return _Amounts.jsonifyAmount(a6);
    }
  }
  static max(a6, b5) {
    const cr = _Amounts.cmp(a6, b5);
    if (cr >= 0) {
      return _Amounts.jsonifyAmount(a6);
    } else {
      return _Amounts.jsonifyAmount(b5);
    }
  }
  static mult(a6, n2) {
    a6 = this.jsonifyAmount(a6);
    if (!Number.isInteger(n2)) {
      throw Error("amount can only be multiplied by an integer");
    }
    if (n2 < 0) {
      throw Error("amount can only be multiplied by a positive integer");
    }
    if (n2 == 0) {
      return {
        amount: _Amounts.zeroOfCurrency(a6.currency),
        saturated: false
      };
    }
    let x6 = a6;
    let acc = _Amounts.zeroOfCurrency(a6.currency);
    while (n2 > 1) {
      if (n2 % 2 == 0) {
        n2 = n2 / 2;
      } else {
        n2 = (n2 - 1) / 2;
        const r23 = _Amounts.add(acc, x6);
        if (r23.saturated) {
          return r23;
        }
        acc = r23.amount;
      }
      const r22 = _Amounts.add(x6, x6);
      if (r22.saturated) {
        return r22;
      }
      x6 = r22.amount;
    }
    return _Amounts.add(acc, x6);
  }
  /**
   * Check if the argument is a valid amount in string form.
   */
  static check(a6) {
    if (typeof a6 !== "string") {
      return false;
    }
    try {
      const parsedAmount = _Amounts.parse(a6);
      return !!parsedAmount;
    } catch {
      return false;
    }
  }
  /**
   * Convert to standard human-readable string representation that's
   * also used in JSON formats.
   */
  static stringify(a6) {
    a6 = _Amounts.jsonifyAmount(a6);
    const s6 = this.stringifyValue(a6);
    return `${a6.currency}:${s6}`;
  }
  /**
   * Show an amount in a form suitable for the user.
   * FIXME:  In the future, this should consider currency-specific
   * settings such as significant digits or currency symbols.
   */
  static toPretty(amount) {
    const x6 = amount.value + amount.fraction / amountFractionalBase;
    return `${x6} ${amount.currency}`;
  }
  static amountHasSameCurrency(a1, a23) {
    const x1 = this.jsonifyAmount(a1);
    const x22 = this.jsonifyAmount(a23);
    return x1.currency.toUpperCase() === x22.currency.toUpperCase();
  }
  static isSameCurrency(curr1, curr2) {
    return curr1.toLowerCase() === curr2.toLowerCase();
  }
  static stringifyValue(a6, minFractional = 0) {
    const aJ = _Amounts.jsonifyAmount(a6);
    const av = aJ.value + Math.floor(aJ.fraction / amountFractionalBase);
    const af = aJ.fraction % amountFractionalBase;
    let s6 = av.toString();
    if (af || minFractional) {
      s6 = s6 + FRAC_SEPARATOR;
      let n2 = af;
      for (let i5 = 0; i5 < amountFractionalLength; i5++) {
        if (!n2 && i5 >= minFractional) {
          break;
        }
        s6 = s6 + Math.floor(n2 / amountFractionalBase * 10).toString();
        n2 = n2 * 10 % amountFractionalBase;
      }
    }
    return s6;
  }
  /**
   * Number of fractional digits needed to fully represent the amount
   * @param a amount
   * @returns
   */
  static maxFractionalDigits(a6) {
    if (a6.fraction === 0)
      return 0;
    if (a6.fraction < 0) {
      console.error("amount fraction can not be negative", a6);
      return 0;
    }
    let i5 = 0;
    let check = true;
    let rest = a6.fraction;
    while (rest > 0 && check) {
      check = rest % 10 === 0;
      rest = rest / 10;
      i5++;
    }
    return amountFractionalLength - i5 + 1;
  }
  static stringifyValueWithSpec(value, spec) {
    const strValue = _Amounts.stringifyValue(value);
    const pos = strValue.indexOf(FRAC_SEPARATOR);
    const originalPosition = pos < 0 ? strValue.length : pos;
    let currency = value.currency;
    const names2 = Object.keys(spec.alt_unit_names);
    let FRAC_POS_NEW_POSITION = originalPosition;
    if (names2.length > 0) {
      let unitIndex = "0";
      names2.forEach((index) => {
        const i5 = Number.parseInt(index, 10);
        if (Number.isNaN(i5))
          return;
        if (originalPosition - i5 <= 0)
          return;
        if (originalPosition - i5 < FRAC_POS_NEW_POSITION) {
          FRAC_POS_NEW_POSITION = originalPosition - i5;
          unitIndex = index;
        }
      });
      currency = spec.alt_unit_names[unitIndex];
    }
    if (originalPosition === FRAC_POS_NEW_POSITION) {
      const { normal: normal2, small: small2 } = splitNormalAndSmall(strValue, originalPosition, spec);
      return { currency, normal: normal2, small: small2 };
    }
    const intPart = strValue.substring(0, originalPosition);
    const fracPArt = strValue.substring(originalPosition + 1);
    const newValue = intPart.substring(0, FRAC_POS_NEW_POSITION) + FRAC_SEPARATOR + intPart.substring(FRAC_POS_NEW_POSITION) + fracPArt;
    const { normal, small } = splitNormalAndSmall(newValue, FRAC_POS_NEW_POSITION, spec);
    return { currency, normal, small };
  }
};
function splitNormalAndSmall(decimal, fracSeparatorIndex, spec) {
  let normal;
  let small;
  if (decimal.length - fracSeparatorIndex - 1 > spec.num_fractional_normal_digits) {
    const limit = fracSeparatorIndex + spec.num_fractional_normal_digits + 1;
    normal = decimal.substring(0, limit);
    small = decimal.substring(limit);
  } else {
    normal = decimal;
    small = void 0;
  }
  return { normal, small };
}

// ../taler-util/lib/http-impl.missing.js
var HttpLibImpl = class {
  fetch(url, opt) {
    throw new Error("Method not implemented.");
  }
};

// ../taler-util/lib/http.js
function createPlatformHttpLib(args) {
  return new HttpLibImpl(args);
}

// ../taler-util/lib/bank-api-client.js
var logger3 = new Logger("bank-api-client.ts");
var CreditDebitIndicator;
(function(CreditDebitIndicator2) {
  CreditDebitIndicator2["Credit"] = "credit";
  CreditDebitIndicator2["Debit"] = "debit";
})(CreditDebitIndicator || (CreditDebitIndicator = {}));

// ../taler-util/lib/base64.js
function base64FromArrayBuffer(arrayBuffer) {
  var base64 = "";
  var encodings = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  var bytes = new Uint8Array(arrayBuffer);
  var byteLength = bytes.byteLength;
  var byteRemainder = byteLength % 3;
  var mainLength = byteLength - byteRemainder;
  var a6, b5, c5, d6;
  var chunk;
  for (var i5 = 0; i5 < mainLength; i5 = i5 + 3) {
    chunk = bytes[i5] << 16 | bytes[i5 + 1] << 8 | bytes[i5 + 2];
    a6 = (chunk & 16515072) >> 18;
    b5 = (chunk & 258048) >> 12;
    c5 = (chunk & 4032) >> 6;
    d6 = chunk & 63;
    base64 += encodings[a6] + encodings[b5] + encodings[c5] + encodings[d6];
  }
  if (byteRemainder == 1) {
    chunk = bytes[mainLength];
    a6 = (chunk & 252) >> 2;
    b5 = (chunk & 3) << 4;
    base64 += encodings[a6] + encodings[b5] + "==";
  } else if (byteRemainder == 2) {
    chunk = bytes[mainLength] << 8 | bytes[mainLength + 1];
    a6 = (chunk & 64512) >> 10;
    b5 = (chunk & 1008) >> 4;
    c5 = (chunk & 15) << 2;
    base64 += encodings[a6] + encodings[b5] + encodings[c5] + "=";
  }
  return base64;
}

// ../taler-util/lib/bech32.js
var CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
var GENERATOR = [996825010, 642813549, 513874426, 1027748829, 705979059];
function polymod(values) {
  var chk = 1;
  for (var p4 = 0; p4 < values.length; ++p4) {
    var top = chk >> 25;
    chk = (chk & 33554431) << 5 ^ values[p4];
    for (var i5 = 0; i5 < 5; ++i5) {
      if (top >> i5 & 1) {
        chk ^= GENERATOR[i5];
      }
    }
  }
  return chk;
}
function hrpExpand(hrp) {
  const ret = [];
  for (let p4 = 0; p4 < hrp.length; ++p4) {
    ret.push(hrp.charCodeAt(p4) >> 5);
  }
  ret.push(0);
  for (let p4 = 0; p4 < hrp.length; ++p4) {
    ret.push(hrp.charCodeAt(p4) & 31);
  }
  return ret;
}
function getEncodingConst(enc) {
  switch (enc) {
    case BitcoinBech32.Encodings.BECH32:
      return 1;
    case BitcoinBech32.Encodings.BECH32M:
      return 734539939;
    default: {
      assertUnreachable(enc);
    }
  }
}
function verifyChecksum(hrp, data, enc) {
  return polymod(hrpExpand(hrp).concat(data)) === getEncodingConst(enc);
}
function createChecksum(hrp, data, enc) {
  const values = hrpExpand(hrp).concat(data).concat([0, 0, 0, 0, 0, 0]);
  const mod = polymod(values) ^ getEncodingConst(enc);
  const ret = [];
  for (let p4 = 0; p4 < 6; ++p4) {
    ret.push(mod >> 5 * (5 - p4) & 31);
  }
  return ret;
}
var BitcoinBech32;
(function(BitcoinBech322) {
  let Encodings;
  (function(Encodings2) {
    Encodings2["BECH32"] = "bech32";
    Encodings2["BECH32M"] = "bech32m";
  })(Encodings = BitcoinBech322.Encodings || (BitcoinBech322.Encodings = {}));
  ;
  function encode2(hrp, data, enc) {
    var combined = data.concat(createChecksum(hrp, data, enc));
    var ret = hrp + "1";
    for (var p4 = 0; p4 < combined.length; ++p4) {
      ret += CHARSET.charAt(combined[p4]);
    }
    return ret;
  }
  BitcoinBech322.encode = encode2;
  let BitcoinParseError;
  (function(BitcoinParseError2) {
    BitcoinParseError2[BitcoinParseError2["WRONG_CHARSET"] = 0] = "WRONG_CHARSET";
    BitcoinParseError2[BitcoinParseError2["MIXING_UPPER_AND_LOWER"] = 1] = "MIXING_UPPER_AND_LOWER";
    BitcoinParseError2[BitcoinParseError2["MISSING_HRP"] = 2] = "MISSING_HRP";
    BitcoinParseError2[BitcoinParseError2["TOO_LONG"] = 3] = "TOO_LONG";
    BitcoinParseError2[BitcoinParseError2["TOO_SHORT"] = 4] = "TOO_SHORT";
    BitcoinParseError2[BitcoinParseError2["WRONG_CHECKSUM"] = 5] = "WRONG_CHECKSUM";
  })(BitcoinParseError = BitcoinBech322.BitcoinParseError || (BitcoinBech322.BitcoinParseError = {}));
  function decode2(bechString, enc) {
    let p4;
    let has_lower = false;
    let has_upper = false;
    for (p4 = 0; p4 < bechString.length; ++p4) {
      if (bechString.charCodeAt(p4) < 33 || bechString.charCodeAt(p4) > 126) {
        return opKnownFailure(BitcoinParseError.WRONG_CHARSET);
      }
      if (bechString.charCodeAt(p4) >= 97 && bechString.charCodeAt(p4) <= 122) {
        has_lower = true;
      }
      if (bechString.charCodeAt(p4) >= 65 && bechString.charCodeAt(p4) <= 90) {
        has_upper = true;
      }
    }
    if (has_lower && has_upper) {
      return opKnownFailure(BitcoinParseError.MIXING_UPPER_AND_LOWER);
    }
    bechString = bechString.toLowerCase();
    const pos = bechString.lastIndexOf("1");
    if (pos < 1) {
      return opKnownFailure(BitcoinParseError.MISSING_HRP);
    }
    if (pos + 7 > bechString.length) {
      return opKnownFailure(BitcoinParseError.TOO_SHORT);
    }
    if (bechString.length > 90) {
      return opKnownFailure(BitcoinParseError.TOO_LONG);
    }
    const hrp = bechString.substring(0, pos);
    var data = [];
    for (p4 = pos + 1; p4 < bechString.length; ++p4) {
      var d6 = CHARSET.indexOf(bechString.charAt(p4));
      if (d6 === -1) {
        return opKnownFailure(BitcoinParseError.WRONG_CHARSET);
      }
      data.push(d6);
    }
    if (enc && !verifyChecksum(hrp, data, enc)) {
      return opKnownFailure(BitcoinParseError.WRONG_CHECKSUM);
    }
    return opFixedSuccess({ hrp, data: data.slice(0, data.length - 6) });
  }
  BitcoinBech322.decode = decode2;
})(BitcoinBech32 || (BitcoinBech32 = {}));

// ../taler-util/lib/segwit_addr.js
function convertbits(data, frombits, tobits, pad) {
  let acc = 0;
  let bits = 0;
  const ret = [];
  const maxv = (1 << tobits) - 1;
  for (let p4 = 0; p4 < data.length; ++p4) {
    const value = data[p4];
    if (value < 0 || value >> frombits !== 0) {
      return null;
    }
    acc = acc << frombits | value;
    bits += frombits;
    while (bits >= tobits) {
      bits -= tobits;
      ret.push(acc >> bits & maxv);
    }
  }
  if (pad) {
    if (bits > 0) {
      ret.push(acc << tobits - bits & maxv);
    }
  } else if (bits >= frombits || acc << tobits - bits & maxv) {
    return null;
  }
  return ret;
}
var BitcoinSewgit;
(function(BitcoinSewgit2) {
  let BitcoinSewgitParseError;
  (function(BitcoinSewgitParseError2) {
    BitcoinSewgitParseError2["INVALID_DATA"] = "invalid-data";
    BitcoinSewgitParseError2["DECODING_PROBLEM"] = "decoding-problem";
  })(BitcoinSewgitParseError = BitcoinSewgit2.BitcoinSewgitParseError || (BitcoinSewgit2.BitcoinSewgitParseError = {}));
  function decode2(addr, enc) {
    const decResp = BitcoinBech32.decode(addr, enc);
    if (decResp.type === "fail") {
      return decResp;
    }
    const { body: dec } = decResp;
    if (dec.data.length < 1 || dec.data[0] > 16) {
      return opKnownFailure(BitcoinSewgitParseError.INVALID_DATA);
    }
    const res = convertbits(dec.data.slice(1), 5, 8, false);
    if (res === null || res.length < 2 || res.length > 40) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    if (dec.data[0] === 0 && res.length !== 20 && res.length !== 32) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    if (dec.data[0] === 0 && enc === BitcoinBech32.Encodings.BECH32) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    if (dec.data[0] !== 0 && enc === BitcoinBech32.Encodings.BECH32M) {
      return opKnownFailure(BitcoinSewgitParseError.DECODING_PROBLEM);
    }
    return opFixedSuccess({ version: dec.data[0], program: res });
  }
  BitcoinSewgit2.decode = decode2;
  function encode2(hrp, version, program) {
    const enc = version > 0 ? BitcoinBech32.Encodings.BECH32M : BitcoinBech32.Encodings.BECH32;
    const bits = convertbits(program, 8, 5, true);
    if (!bits) {
      return opKnownFailure(BitcoinSewgitParseError.INVALID_DATA);
    }
    const ret = BitcoinBech32.encode(hrp, [version].concat(bits), enc);
    return opFixedSuccess(ret);
  }
  BitcoinSewgit2.encode = encode2;
})(BitcoinSewgit || (BitcoinSewgit = {}));

// ../taler-util/lib/bitcoin.js
var GenerateSegwitAddrError;
(function(GenerateSegwitAddrError2) {
  GenerateSegwitAddrError2["WRONG_RESERVE_PUB"] = "wrong-reserve-pub";
  GenerateSegwitAddrError2["WRONG_PREFIX"] = "wrong-prefix";
  GenerateSegwitAddrError2["INVALID_SEGWIT"] = "invalid-segwit";
})(GenerateSegwitAddrError || (GenerateSegwitAddrError = {}));
function generateFakeSegwitAddress(pub, addr) {
  const first_rnd = new Uint8Array(4);
  first_rnd.set(pub.subarray(0, 4));
  const second_rnd = new Uint8Array(4);
  second_rnd.set(pub.subarray(0, 4));
  first_rnd[0] = first_rnd[0] & 127;
  second_rnd[0] = second_rnd[0] | 128;
  const first_part = new Uint8Array(first_rnd.length + pub.length / 2);
  first_part.set(first_rnd, 0);
  first_part.set(pub.subarray(0, 16), 4);
  const second_part = new Uint8Array(first_rnd.length + pub.length / 2);
  second_part.set(second_rnd, 0);
  second_part.set(pub.subarray(16, 32), 4);
  const prefix2 = addr[0] === "t" && addr[1] == "b" ? "tb" : addr[0] === "b" && addr[1] == "c" && addr[2] === "r" && addr[3] == "t" ? "bcrt" : addr[0] === "b" && addr[1] == "c" ? "bc" : void 0;
  if (prefix2 === void 0) {
    return opKnownFailure(GenerateSegwitAddrError.WRONG_PREFIX);
  }
  const addr1 = BitcoinSewgit.encode(prefix2, 0, Array.from(first_part));
  if (addr1.type === "fail") {
    return opKnownFailure(GenerateSegwitAddrError.INVALID_SEGWIT);
  }
  const addr2 = BitcoinSewgit.encode(prefix2, 0, Array.from(second_part));
  if (addr2.type === "fail") {
    return opKnownFailure(GenerateSegwitAddrError.INVALID_SEGWIT);
  }
  const result = [addr1.body, addr2.body];
  return opFixedSuccess(result);
}

// ../taler-util/lib/CancellationToken.js
var NOOP = () => {
};
var CancellationToken = class _CancellationToken {
  /**
   * Whether the token has been cancelled.
   */
  get isCancelled() {
    return this._isCancelled;
  }
  /**
   * Whether the token can be cancelled.
   */
  get canBeCancelled() {
    return this._canBeCancelled;
  }
  /**
   * Why this token has been cancelled.
   */
  get reason() {
    if (this.isCancelled) {
      return this._reason;
    } else {
      throw new Error("This token is not cancelled.");
    }
  }
  /**
   * Make a promise that resolves when the async operation resolves,
   * or rejects when the operation is rejected or this token is cancelled.
   */
  racePromise(asyncOperation) {
    if (!this.canBeCancelled) {
      return asyncOperation;
    }
    return new Promise((resolve, reject) => {
      const unregister = this.onCancelled((reason) => reject(new _CancellationToken.CancellationError(reason)));
      asyncOperation.then((value) => {
        resolve(value);
        unregister();
      }, (err) => {
        reject(err);
        unregister();
      });
    });
  }
  /**
   * Throw a {CancellationToken.CancellationError} if this token is cancelled.
   */
  throwIfCancelled() {
    if (this._isCancelled) {
      throw new _CancellationToken.CancellationError(this._reason);
    }
  }
  /**
   * Invoke the callback when this token is cancelled.
   * If this token is already cancelled, the callback is invoked immediately.
   * Returns a function that unregisters the cancellation callback.
   */
  onCancelled(cb) {
    if (!this.canBeCancelled) {
      return NOOP;
    }
    if (this.isCancelled) {
      cb(this.reason);
      return NOOP;
    }
    this._callbacks?.add(cb);
    return () => this._callbacks?.delete(cb);
  }
  constructor(_isCancelled, _canBeCancelled) {
    this._isCancelled = _isCancelled;
    this._canBeCancelled = _canBeCancelled;
    this._callbacks = /* @__PURE__ */ new Set();
  }
  /**
   * Create a {CancellationTokenSource}.
   */
  static create() {
    const token = new _CancellationToken(false, true);
    const cancel = (reason) => {
      if (token._isCancelled)
        return;
      token._isCancelled = true;
      token._reason = reason;
      token._callbacks?.forEach((cb) => cb(reason));
      dispose();
    };
    const dispose = () => {
      token._canBeCancelled = token.isCancelled;
      delete token._callbacks;
    };
    return { token, cancel, dispose };
  }
  /**
   * Create a {CancellationTokenSource}.
   * The token will be cancelled automatically after the specified timeout in milliseconds.
   */
  static timeout(ms) {
    const { token, cancel: originalCancel, dispose: originalDispose } = _CancellationToken.create();
    let timer2;
    timer2 = setTimeout(() => originalCancel(`CancellationToken.timeout ${ms}`), ms);
    const disposeTimer = () => {
      if (timer2 == null)
        return;
      clearTimeout(timer2);
      timer2 = null;
    };
    const cancel = (reason) => {
      disposeTimer();
      originalCancel(reason);
    };
    const dispose = () => {
      disposeTimer();
      originalDispose();
    };
    return { token, cancel, dispose };
  }
  /**
   * Create a {CancellationToken} that is cancelled when all of the given tokens are cancelled.
   *
   * This is like {Promise<T>.all} for {CancellationToken}s.
   */
  static all(...tokens) {
    if (tokens.some((token) => !token.canBeCancelled)) {
      return _CancellationToken.CONTINUE;
    }
    const combined = _CancellationToken.create();
    let countdown = tokens.length;
    const handleNextTokenCancelled = () => {
      if (--countdown === 0) {
        const reasons = tokens.map((token) => token._reason);
        combined.cancel(reasons);
      }
    };
    tokens.forEach((token) => token.onCancelled(handleNextTokenCancelled));
    return combined.token;
  }
  /**
   * Create a {CancellationToken} that is cancelled when at least one of the given tokens is cancelled.
   *
   * This is like {Promise<T>.race} for {CancellationToken}s.
   */
  static race(...tokens) {
    for (const token of tokens) {
      if (token._isCancelled) {
        return token;
      }
    }
    const combined = _CancellationToken.create();
    let unregistrations;
    const handleAnyTokenCancelled = (reason) => {
      unregistrations.forEach((unregister) => unregister());
      combined.cancel(reason);
    };
    unregistrations = tokens.map((token) => token.onCancelled(handleAnyTokenCancelled));
    return combined.token;
  }
};
CancellationToken.CANCELLED = new CancellationToken(true, true);
CancellationToken.CONTINUE = new CancellationToken(false, false);
(function(CancellationToken2) {
  class CancellationError extends Error {
    constructor(reason) {
      super("Operation cancelled");
      this.reason = reason;
      Object.setPrototypeOf(this, CancellationError.prototype);
    }
  }
  CancellationToken2.CancellationError = CancellationError;
})(CancellationToken || (CancellationToken = {}));

// ../taler-util/lib/taler-crypto.js
var import_big_integer = __toESM(require_BigInteger(), 1);

// ../taler-util/lib/sha256.js
var digestLength = 32;
var blockSize = 64;
var K2 = new Uint32Array([
  1116352408,
  1899447441,
  3049323471,
  3921009573,
  961987163,
  1508970993,
  2453635748,
  2870763221,
  3624381080,
  310598401,
  607225278,
  1426881987,
  1925078388,
  2162078206,
  2614888103,
  3248222580,
  3835390401,
  4022224774,
  264347078,
  604807628,
  770255983,
  1249150122,
  1555081692,
  1996064986,
  2554220882,
  2821834349,
  2952996808,
  3210313671,
  3336571891,
  3584528711,
  113926993,
  338241895,
  666307205,
  773529912,
  1294757372,
  1396182291,
  1695183700,
  1986661051,
  2177026350,
  2456956037,
  2730485921,
  2820302411,
  3259730800,
  3345764771,
  3516065817,
  3600352804,
  4094571909,
  275423344,
  430227734,
  506948616,
  659060556,
  883997877,
  958139571,
  1322822218,
  1537002063,
  1747873779,
  1955562222,
  2024104815,
  2227730452,
  2361852424,
  2428436474,
  2756734187,
  3204031479,
  3329325298
]);
function hashBlocks(w6, v3, p4, pos, len) {
  let a6, b5, c5, d6, e5, f3, g4, h5, u5, i5, j4, t1, t22;
  while (len >= 64) {
    a6 = v3[0];
    b5 = v3[1];
    c5 = v3[2];
    d6 = v3[3];
    e5 = v3[4];
    f3 = v3[5];
    g4 = v3[6];
    h5 = v3[7];
    for (i5 = 0; i5 < 16; i5++) {
      j4 = pos + i5 * 4;
      w6[i5] = (p4[j4] & 255) << 24 | (p4[j4 + 1] & 255) << 16 | (p4[j4 + 2] & 255) << 8 | p4[j4 + 3] & 255;
    }
    for (i5 = 16; i5 < 64; i5++) {
      u5 = w6[i5 - 2];
      t1 = (u5 >>> 17 | u5 << 32 - 17) ^ (u5 >>> 19 | u5 << 32 - 19) ^ u5 >>> 10;
      u5 = w6[i5 - 15];
      t22 = (u5 >>> 7 | u5 << 32 - 7) ^ (u5 >>> 18 | u5 << 32 - 18) ^ u5 >>> 3;
      w6[i5] = (t1 + w6[i5 - 7] | 0) + (t22 + w6[i5 - 16] | 0);
    }
    for (i5 = 0; i5 < 64; i5++) {
      t1 = (((e5 >>> 6 | e5 << 32 - 6) ^ (e5 >>> 11 | e5 << 32 - 11) ^ (e5 >>> 25 | e5 << 32 - 25)) + (e5 & f3 ^ ~e5 & g4) | 0) + (h5 + (K2[i5] + w6[i5] | 0) | 0) | 0;
      t22 = ((a6 >>> 2 | a6 << 32 - 2) ^ (a6 >>> 13 | a6 << 32 - 13) ^ (a6 >>> 22 | a6 << 32 - 22)) + (a6 & b5 ^ a6 & c5 ^ b5 & c5) | 0;
      h5 = g4;
      g4 = f3;
      f3 = e5;
      e5 = d6 + t1 | 0;
      d6 = c5;
      c5 = b5;
      b5 = a6;
      a6 = t1 + t22 | 0;
    }
    v3[0] += a6;
    v3[1] += b5;
    v3[2] += c5;
    v3[3] += d6;
    v3[4] += e5;
    v3[5] += f3;
    v3[6] += g4;
    v3[7] += h5;
    pos += 64;
    len -= 64;
  }
  return pos;
}
var HashSha256 = class {
  constructor() {
    this.digestLength = digestLength;
    this.blockSize = blockSize;
    this.state = new Int32Array(8);
    this.temp = new Int32Array(64);
    this.buffer = new Uint8Array(128);
    this.bufferLength = 0;
    this.bytesHashed = 0;
    this.finished = false;
    this.reset();
  }
  // Resets hash state making it possible
  // to reuse this instance to hash other data.
  reset() {
    this.state[0] = 1779033703;
    this.state[1] = 3144134277;
    this.state[2] = 1013904242;
    this.state[3] = 2773480762;
    this.state[4] = 1359893119;
    this.state[5] = 2600822924;
    this.state[6] = 528734635;
    this.state[7] = 1541459225;
    this.bufferLength = 0;
    this.bytesHashed = 0;
    this.finished = false;
    return this;
  }
  // Cleans internal buffers and re-initializes hash state.
  clean() {
    for (let i5 = 0; i5 < this.buffer.length; i5++) {
      this.buffer[i5] = 0;
    }
    for (let i5 = 0; i5 < this.temp.length; i5++) {
      this.temp[i5] = 0;
    }
    this.reset();
  }
  // Updates hash state with the given data.
  //
  // Optionally, length of the data can be specified to hash
  // fewer bytes than data.length.
  //
  // Throws error when trying to update already finalized hash:
  // instance must be reset to use it again.
  update(data, dataLength = data.length) {
    if (this.finished) {
      throw new Error("SHA256: can't update because hash was finished.");
    }
    let dataPos = 0;
    this.bytesHashed += dataLength;
    if (this.bufferLength > 0) {
      while (this.bufferLength < 64 && dataLength > 0) {
        this.buffer[this.bufferLength++] = data[dataPos++];
        dataLength--;
      }
      if (this.bufferLength === 64) {
        hashBlocks(this.temp, this.state, this.buffer, 0, 64);
        this.bufferLength = 0;
      }
    }
    if (dataLength >= 64) {
      dataPos = hashBlocks(this.temp, this.state, data, dataPos, dataLength);
      dataLength %= 64;
    }
    while (dataLength > 0) {
      this.buffer[this.bufferLength++] = data[dataPos++];
      dataLength--;
    }
    return this;
  }
  // Finalizes hash state and puts hash into out.
  //
  // If hash was already finalized, puts the same value.
  finish(out) {
    if (!this.finished) {
      const bytesHashed = this.bytesHashed;
      const left = this.bufferLength;
      const bitLenHi = bytesHashed / 536870912 | 0;
      const bitLenLo = bytesHashed << 3;
      const padLength = bytesHashed % 64 < 56 ? 64 : 128;
      this.buffer[left] = 128;
      for (let i5 = left + 1; i5 < padLength - 8; i5++) {
        this.buffer[i5] = 0;
      }
      this.buffer[padLength - 8] = bitLenHi >>> 24 & 255;
      this.buffer[padLength - 7] = bitLenHi >>> 16 & 255;
      this.buffer[padLength - 6] = bitLenHi >>> 8 & 255;
      this.buffer[padLength - 5] = bitLenHi >>> 0 & 255;
      this.buffer[padLength - 4] = bitLenLo >>> 24 & 255;
      this.buffer[padLength - 3] = bitLenLo >>> 16 & 255;
      this.buffer[padLength - 2] = bitLenLo >>> 8 & 255;
      this.buffer[padLength - 1] = bitLenLo >>> 0 & 255;
      hashBlocks(this.temp, this.state, this.buffer, 0, padLength);
      this.finished = true;
    }
    for (let i5 = 0; i5 < 8; i5++) {
      out[i5 * 4 + 0] = this.state[i5] >>> 24 & 255;
      out[i5 * 4 + 1] = this.state[i5] >>> 16 & 255;
      out[i5 * 4 + 2] = this.state[i5] >>> 8 & 255;
      out[i5 * 4 + 3] = this.state[i5] >>> 0 & 255;
    }
    return this;
  }
  // Returns the final hash digest.
  digest() {
    const out = new Uint8Array(this.digestLength);
    this.finish(out);
    return out;
  }
  // Internal function for use in HMAC for optimization.
  _saveState(out) {
    for (let i5 = 0; i5 < this.state.length; i5++) {
      out[i5] = this.state[i5];
    }
  }
  // Internal function for use in HMAC for optimization.
  _restoreState(from, bytesHashed) {
    for (let i5 = 0; i5 < this.state.length; i5++) {
      this.state[i5] = from[i5];
    }
    this.bytesHashed = bytesHashed;
    this.finished = false;
    this.bufferLength = 0;
  }
};
function sha256(data) {
  const h5 = new HashSha256().update(data);
  const digest = h5.digest();
  h5.clean();
  return digest;
}

// ../taler-util/lib/kdf.js
function sha512(data) {
  return hash(data);
}
function hmac(digest, blockSize2, key, message) {
  if (key.byteLength > blockSize2) {
    key = digest(key);
  }
  if (key.byteLength < blockSize2) {
    const k6 = key;
    key = new Uint8Array(blockSize2);
    key.set(k6, 0);
  }
  const okp = new Uint8Array(blockSize2);
  const ikp = new Uint8Array(blockSize2);
  for (let i5 = 0; i5 < blockSize2; i5++) {
    ikp[i5] = key[i5] ^ 54;
    okp[i5] = key[i5] ^ 92;
  }
  const b1 = new Uint8Array(blockSize2 + message.byteLength);
  b1.set(ikp, 0);
  b1.set(message, blockSize2);
  const h0 = digest(b1);
  const b22 = new Uint8Array(blockSize2 + h0.length);
  b22.set(okp, 0);
  b22.set(h0, blockSize2);
  return digest(b22);
}
function hmacSha512(key, message) {
  return hmac(sha512, 128, key, message);
}
function hmacSha256(key, message) {
  return hmac(sha256, 64, key, message);
}

// ../taler-util/lib/iban.js
var ParseIbanError;
(function(ParseIbanError2) {
  ParseIbanError2[ParseIbanError2["UNSUPPORTED_COUNTRY"] = 0] = "UNSUPPORTED_COUNTRY";
  ParseIbanError2[ParseIbanError2["TOO_LONG"] = 1] = "TOO_LONG";
  ParseIbanError2[ParseIbanError2["TOO_SHORT"] = 2] = "TOO_SHORT";
  ParseIbanError2[ParseIbanError2["INVALID_CHARSET"] = 3] = "INVALID_CHARSET";
  ParseIbanError2[ParseIbanError2["INVALID_CHECKSUM"] = 4] = "INVALID_CHECKSUM";
})(ParseIbanError || (ParseIbanError = {}));
var ccZero = "0".charCodeAt(0);
var ccNine = "9".charCodeAt(0);
var ccA = "A".charCodeAt(0);
var ccZ = "Z".charCodeAt(0);
function appendDigit(digits, cc) {
  if (cc >= ccZero && cc <= ccNine) {
    digits.push(cc - ccZero);
  } else if (cc >= ccA && cc <= ccZ) {
    const n2 = cc - ccA + 10;
    digits.push(Math.floor(n2 / 10) % 10);
    digits.push(n2 % 10);
  } else {
    return false;
  }
  return true;
}
function mod97(digits) {
  let i5 = 0;
  let modAccum = 0;
  while (i5 < digits.length) {
    let n2 = 0;
    while (n2 < 9 && i5 < digits.length) {
      modAccum = modAccum * 10 + digits[i5];
      i5++;
      n2++;
    }
    modAccum = modAccum % 97;
  }
  return modAccum;
}
function parseIban(ibanString) {
  if (ibanString.length < 4) {
    return opKnownFailure(ParseIbanError.TOO_SHORT);
  }
  if (ibanString.length > 34) {
    return opKnownFailure(ParseIbanError.TOO_LONG);
  }
  const myIban = ibanString.toUpperCase().replace(/[\s-\._]/g, "");
  const countryCode = myIban.substring(0, 2);
  const countryInfo = ibanCountryInfoTable[countryCode];
  if (!countryInfo) {
    return opKnownFailure(ParseIbanError.UNSUPPORTED_COUNTRY);
  }
  let digits = [];
  for (let i5 = 4; i5 < myIban.length; i5++) {
    const cc = myIban.charCodeAt(i5);
    if (!appendDigit(digits, cc)) {
      return opKnownFailure(ParseIbanError.INVALID_CHARSET);
    }
  }
  for (let i5 = 0; i5 < 4; i5++) {
    const cc = myIban.charCodeAt(i5);
    if (!appendDigit(digits, cc)) {
      return opKnownFailure(ParseIbanError.INVALID_CHARSET);
    }
  }
  const rem = mod97(digits);
  if (rem === 1) {
    return opFixedSuccess(myIban);
  } else {
    return opKnownFailure(ParseIbanError.INVALID_CHECKSUM);
  }
}
var ibanCountryInfoTable = {
  AE: { name: "U.A.E." },
  AF: { name: "Afghanistan" },
  AL: { name: "Albania" },
  AM: { name: "Armenia" },
  AN: { name: "Netherlands Antilles" },
  AR: { name: "Argentina" },
  AT: { name: "Austria" },
  AU: { name: "Australia" },
  AZ: { name: "Azerbaijan" },
  BA: { name: "Bosnia and Herzegovina" },
  BD: { name: "Bangladesh" },
  BE: { name: "Belgium" },
  BG: { name: "Bulgaria" },
  BH: { name: "Bahrain" },
  BN: { name: "Brunei Darussalam" },
  BO: { name: "Bolivia" },
  BR: { name: "Brazil" },
  BT: { name: "Bhutan" },
  BY: { name: "Belarus" },
  BZ: { name: "Belize" },
  CA: { name: "Canada" },
  CG: { name: "Congo" },
  CH: { name: "Switzerland" },
  CI: { name: "Cote d'Ivoire" },
  CL: { name: "Chile" },
  CM: { name: "Cameroon" },
  CN: { name: "People's Republic of China" },
  CO: { name: "Colombia" },
  CR: { name: "Costa Rica" },
  CS: { name: "Serbia and Montenegro" },
  CZ: { name: "Czech Republic" },
  DE: { name: "Germany" },
  DK: { name: "Denmark" },
  DO: { name: "Dominican Republic" },
  DZ: { name: "Algeria" },
  EC: { name: "Ecuador" },
  EE: { name: "Estonia" },
  EG: { name: "Egypt" },
  ER: { name: "Eritrea" },
  ES: { name: "Spain" },
  ET: { name: "Ethiopia" },
  FI: { name: "Finland" },
  FO: { name: "Faroe Islands" },
  FR: { name: "France" },
  GB: { name: "United Kingdom" },
  GD: { name: "Caribbean" },
  GE: { name: "Georgia" },
  GL: { name: "Greenland" },
  GR: { name: "Greece" },
  GT: { name: "Guatemala" },
  HK: { name: "Hong Kong S.A.R." },
  HN: { name: "Honduras" },
  HR: { name: "Croatia" },
  HT: { name: "Haiti" },
  HU: { name: "Hungary" },
  ID: { name: "Indonesia" },
  IE: { name: "Ireland" },
  IL: { name: "Israel" },
  IN: { name: "India" },
  IQ: { name: "Iraq" },
  IR: { name: "Iran" },
  IS: { name: "Iceland" },
  IT: { name: "Italy" },
  JM: { name: "Jamaica" },
  JO: { name: "Jordan" },
  JP: { name: "Japan" },
  KE: { name: "Kenya" },
  KG: { name: "Kyrgyzstan" },
  KH: { name: "Cambodia" },
  KR: { name: "South Korea" },
  KW: { name: "Kuwait" },
  KZ: { name: "Kazakhstan" },
  LA: { name: "Laos" },
  LB: { name: "Lebanon" },
  LI: { name: "Liechtenstein" },
  LK: { name: "Sri Lanka" },
  LT: { name: "Lithuania" },
  LU: { name: "Luxembourg" },
  LV: { name: "Latvia" },
  LY: { name: "Libya" },
  MA: { name: "Morocco" },
  MC: { name: "Principality of Monaco" },
  MD: { name: "Moldava" },
  ME: { name: "Montenegro" },
  MK: { name: "Former Yugoslav Republic of Macedonia" },
  ML: { name: "Mali" },
  MM: { name: "Myanmar" },
  MN: { name: "Mongolia" },
  MO: { name: "Macau S.A.R." },
  MT: { name: "Malta" },
  MV: { name: "Maldives" },
  MX: { name: "Mexico" },
  MY: { name: "Malaysia" },
  NG: { name: "Nigeria" },
  NI: { name: "Nicaragua" },
  NL: { name: "Netherlands" },
  NO: { name: "Norway" },
  NP: { name: "Nepal" },
  NZ: { name: "New Zealand" },
  OM: { name: "Oman" },
  PA: { name: "Panama" },
  PE: { name: "Peru" },
  PH: { name: "Philippines" },
  PK: { name: "Islamic Republic of Pakistan" },
  PL: { name: "Poland" },
  PR: { name: "Puerto Rico" },
  PT: { name: "Portugal" },
  PY: { name: "Paraguay" },
  QA: { name: "Qatar" },
  RE: { name: "Reunion" },
  RO: { name: "Romania" },
  RS: { name: "Serbia" },
  RU: { name: "Russia" },
  RW: { name: "Rwanda" },
  SA: { name: "Saudi Arabia" },
  SE: { name: "Sweden" },
  SG: { name: "Singapore" },
  SI: { name: "Slovenia" },
  SK: { name: "Slovak" },
  SN: { name: "Senegal" },
  SO: { name: "Somalia" },
  SR: { name: "Suriname" },
  SV: { name: "El Salvador" },
  SY: { name: "Syria" },
  TH: { name: "Thailand" },
  TJ: { name: "Tajikistan" },
  TM: { name: "Turkmenistan" },
  TN: { name: "Tunisia" },
  TR: { name: "Turkey" },
  TT: { name: "Trinidad and Tobago" },
  TW: { name: "Taiwan" },
  TZ: { name: "Tanzania" },
  UA: { name: "Ukraine" },
  US: { name: "United States" },
  UY: { name: "Uruguay" },
  VA: { name: "Vatican" },
  VE: { name: "Venezuela" },
  VN: { name: "Viet Nam" },
  YE: { name: "Yemen" },
  ZA: { name: "South Africa" },
  ZW: { name: "Zimbabwe" }
};

// ../taler-util/lib/payto.js
var PAYTO_PREFIX = "payto://";
var PaytoType;
(function(PaytoType3) {
  PaytoType3["IBAN"] = "iban";
  PaytoType3["Bitcoin"] = "bitcoin";
  PaytoType3["TalerBank"] = "x-taler-bank";
  PaytoType3["TalerReserve"] = "taler-reserve";
  PaytoType3["TalerReserveHttp"] = "taler-reserve-http";
  PaytoType3["Ethereum"] = "ethereum";
})(PaytoType || (PaytoType = {}));
var ReservePubParseError;
(function(ReservePubParseError2) {
  ReservePubParseError2[ReservePubParseError2["WRONG_LENGTH"] = 0] = "WRONG_LENGTH";
  ReservePubParseError2[ReservePubParseError2["DECODE_ERROR"] = 1] = "DECODE_ERROR";
})(ReservePubParseError || (ReservePubParseError = {}));
var PaytoParseError;
(function(PaytoParseError2) {
  PaytoParseError2[PaytoParseError2["WRONG_PREFIX"] = 0] = "WRONG_PREFIX";
  PaytoParseError2[PaytoParseError2["INCOMPLETE"] = 1] = "INCOMPLETE";
  PaytoParseError2[PaytoParseError2["UNSUPPORTED"] = 2] = "UNSUPPORTED";
  PaytoParseError2[PaytoParseError2["COMPONENTS_LENGTH"] = 3] = "COMPONENTS_LENGTH";
  PaytoParseError2[PaytoParseError2["INVALID_TARGET_PATH"] = 4] = "INVALID_TARGET_PATH";
})(PaytoParseError || (PaytoParseError = {}));
var Paytos;
(function(Paytos2) {
  const supported_targets = {
    iban: true,
    bitcoin: true,
    "x-taler-bank": true,
    "taler-reserve": true,
    "taler-reserve-http": true,
    ethereum: true
  };
  function hash3(p4) {
    return hashTruncate32(stringToBytes(p4 + "\0"));
  }
  Paytos2.hash = hash3;
  function toNormalizedString(p4) {
    const url = new URL(`${PAYTO_PREFIX}${p4.targetType}/${p4.normalizedPath}`);
    return url.href;
  }
  Paytos2.toNormalizedString = toNormalizedString;
  function toFullString(p4) {
    const url = new URL(`${PAYTO_PREFIX}${p4.targetType}/${p4.fullPath}`);
    const paramList = !p4.params ? [] : Object.entries(p4.params);
    url.search = createSearchParams(paramList);
    return url.href;
  }
  Paytos2.toFullString = toFullString;
  function parseReservePub(reserve) {
    if (!reserve)
      return opKnownFailure(ReservePubParseError.WRONG_LENGTH);
    try {
      const pub = decodeCrock(reserve);
      if (!pub || pub.length !== 32) {
        return opKnownFailure(ReservePubParseError.WRONG_LENGTH);
      }
      return opFixedSuccess(pub);
    } catch (e5) {
      return opKnownFailureWithBody(ReservePubParseError.DECODE_ERROR, {
        message: String(e5)
      });
    }
  }
  Paytos2.parseReservePub = parseReservePub;
  function parseHostPortPath2(hostname, path, scheme = "https") {
    try {
      if (path === void 0) {
        path = "";
      }
      if (!path.endsWith("/")) {
        path = path + "/";
      }
      const url = new URL(path, `${scheme}://${hostname.toLowerCase()}`);
      url.search = "";
      url.password = "";
      url.username = "";
      url.hash = "";
      return url.href;
    } catch (e5) {
      console.log(e5);
      return void 0;
    }
  }
  Paytos2.parseHostPortPath2 = parseHostPortPath2;
  function withoutScheme(h5) {
    return h5.startsWith("http://") ? h5.substring(7) : h5.startsWith("https://") ? h5.substring(8) : h5;
  }
  function parseHostPortPath(hostnameAndPath) {
    const [host, path] = hostnameAndPath.split("/", 1);
    return parseHostPortPath2(host, path ?? "");
  }
  Paytos2.parseHostPortPath = parseHostPortPath;
  function parseEthereumAddress(str) {
    if (!str) {
      return void 0;
    }
    return str;
  }
  Paytos2.parseEthereumAddress = parseEthereumAddress;
  function parseTalerBankAccount(account) {
    if (!account) {
      return void 0;
    }
    return account;
  }
  Paytos2.parseTalerBankAccount = parseTalerBankAccount;
  function createUnsupported(targetType, path, params = {}) {
    return {
      targetType: void 0,
      target: targetType,
      params,
      normalizedPath: path.toLocaleLowerCase(),
      fullPath: path,
      displayName: path
    };
  }
  Paytos2.createUnsupported = createUnsupported;
  function createIban(iban, bic, params = {}) {
    return {
      targetType: PaytoType.IBAN,
      iban,
      bic,
      params,
      normalizedPath: iban.toLocaleLowerCase(),
      fullPath: !bic ? iban : `${bic}/${iban}`,
      displayName: iban
    };
  }
  Paytos2.createIban = createIban;
  function createBitcoin(address, reservePub, params = {}) {
    const sgRes = !reservePub ? void 0 : generateFakeSegwitAddress(reservePub, address);
    const segwitAddrs = !sgRes || sgRes.type === "fail" ? [] : sgRes.body;
    return {
      targetType: PaytoType.Bitcoin,
      address,
      reservePub,
      segwitAddrs,
      params,
      normalizedPath: address.toLocaleLowerCase(),
      fullPath: !reservePub ? address : `${address}/${encodeCrock(reservePub)}`,
      displayName: address
    };
  }
  Paytos2.createBitcoin = createBitcoin;
  function createEthereum(address, params = {}) {
    return {
      targetType: PaytoType.Ethereum,
      address,
      params,
      normalizedPath: address,
      fullPath: address,
      displayName: address
    };
  }
  Paytos2.createEthereum = createEthereum;
  function createTalerReserve(exchange, reservePub, params = {}) {
    const path = withoutScheme(exchange);
    const pub = encodeCrock(reservePub);
    return {
      targetType: PaytoType.TalerReserve,
      exchange,
      reservePub,
      params,
      normalizedPath: `${path.toLocaleLowerCase()}${pub}`,
      fullPath: `${path}${pub}`,
      displayName: `${path}@${pub}`
    };
  }
  Paytos2.createTalerReserve = createTalerReserve;
  function createTalerReserveHttp(exchange, reservePub, params = {}) {
    const path = withoutScheme(exchange);
    const pub = encodeCrock(reservePub);
    return {
      targetType: PaytoType.TalerReserveHttp,
      exchange,
      reservePub,
      params,
      normalizedPath: `${path.toLocaleLowerCase()}${pub}`,
      fullPath: `${path}${pub}`,
      displayName: `${path}@${pub}`
    };
  }
  Paytos2.createTalerReserveHttp = createTalerReserveHttp;
  function createTalerBank(url, account, params = {}) {
    const path = withoutScheme(url);
    const host = path.endsWith("/") ? path.substring(0, path.length - 1) : path;
    return {
      targetType: PaytoType.TalerBank,
      host,
      url,
      account,
      params,
      normalizedPath: `${path.toLocaleLowerCase()}${account}`,
      fullPath: `${path}${account}`,
      displayName: `${account}@${url}`
    };
  }
  Paytos2.createTalerBank = createTalerBank;
  function fromString(s6, opts = {}) {
    if (!s6.startsWith(PAYTO_PREFIX)) {
      return opKnownFailure(PaytoParseError.WRONG_PREFIX);
    }
    const [acct, search] = s6.slice(PAYTO_PREFIX.length).split("?", 2);
    const firstSlashPos = acct.indexOf("/");
    const targetType = firstSlashPos === -1 ? acct : acct.slice(0, firstSlashPos);
    if (!opts.allowUnsupported && !supported_targets[targetType]) {
      const d6 = opKnownFailureWithBody(PaytoParseError.UNSUPPORTED, {
        targetType
      });
      return d6;
    }
    const targetPath = acct.slice(firstSlashPos + 1);
    if (firstSlashPos === -1 || !targetPath) {
      return opKnownFailureWithBody(PaytoParseError.INCOMPLETE, { targetType });
    }
    const params = {};
    if (search) {
      const searchParams = new URLSearchParams2(search);
      searchParams.forEach((v3, k6) => {
        params[k6] = v3;
      });
    }
    const cs = targetPath.split("/");
    switch (targetType) {
      case PaytoType.IBAN: {
        if (cs.length !== 1 && cs.length !== 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const bic = cs.length === 2 ? cs[0] : void 0;
        const iban = cs.length === 1 ? cs[0] : cs[1];
        const ibaRes = parseIban(iban);
        if (!opts.ignoreComponentError && ibaRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: ibaRes
          });
        }
        return opFixedSuccess(createIban(iban, bic, params));
      }
      case PaytoType.Bitcoin: {
        if (cs.length !== 1 && cs.length !== 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const address = cs[0].toLocaleLowerCase();
        const btRes = BitcoinBech32.decode(address, BitcoinBech32.Encodings.BECH32);
        if (!opts.ignoreComponentError && btRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: btRes
          });
        }
        const pubRes = cs.length === 1 ? void 0 : parseReservePub(cs[1]);
        if (!opts.ignoreComponentError && pubRes && pubRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: pubRes
          });
        }
        return opFixedSuccess(createBitcoin(address, pubRes && pubRes.type === "ok" ? pubRes.body : void 0, params));
      }
      case PaytoType.TalerBank: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const host = parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"));
        if (!opts.ignoreComponentError && !host) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: host
          });
        }
        const account = parseTalerBankAccount(cs[cs.length - 1]);
        if (!opts.ignoreComponentError && !account) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: account
          });
        }
        return opFixedSuccess(createTalerBank(host ?? cs[0], account ?? cs[1], params));
      }
      case PaytoType.TalerReserve: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const exchange = parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"));
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: exchange
          });
        }
        const reservePub = cs[cs.length - 1];
        const pubRes = parseReservePub(reservePub);
        if (!opts.ignoreComponentError && pubRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: pubRes
          });
        }
        return opFixedSuccess(createTalerReserve(exchange ?? cs[0], pubRes.type === "ok" ? pubRes.body : decodeCrock(reservePub), params));
      }
      case PaytoType.TalerReserveHttp: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const exchange = parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), "http");
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: exchange
          });
        }
        const reservePub = cs[cs.length - 1];
        const pubRes = parseReservePub(reservePub);
        if (!opts.ignoreComponentError && pubRes.type === "fail") {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 1,
            targetType,
            error: pubRes
          });
        }
        return opFixedSuccess(createTalerReserveHttp(exchange ?? cs[0], pubRes.type === "ok" ? pubRes.body : decodeCrock(reservePub), params));
      }
      case PaytoType.Ethereum: {
        if (cs.length !== 1) {
          return opKnownFailureWithBody(PaytoParseError.COMPONENTS_LENGTH, {
            targetType
          });
        }
        const address = parseEthereumAddress(cs[0]);
        if (!opts.ignoreComponentError && !address) {
          return opKnownFailureWithBody(PaytoParseError.INVALID_TARGET_PATH, {
            pos: 0,
            targetType,
            error: address
          });
        }
        return opFixedSuccess(createEthereum(address ?? cs[0], params));
      }
      default: {
        if (opts.allowUnsupported) {
          return opFixedSuccess(createUnsupported(targetType, targetPath, params));
        }
        assertUnreachable(targetType);
      }
    }
  }
  Paytos2.fromString = fromString;
  function codecFullForPaytoString() {
    return {
      decode(x6, c5) {
        if (typeof x6 !== "string") {
          throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
        }
        if (!x6.startsWith(PAYTO_PREFIX)) {
          throw new DecodingError(`expected start with payto at ${renderContext(c5)} but got "${x6}"`);
        }
        return x6;
      }
    };
  }
  Paytos2.codecFullForPaytoString = codecFullForPaytoString;
  function codecNormalizedForPaytoString() {
    return {
      decode(x6, c5) {
        if (typeof x6 !== "string") {
          throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
        }
        if (!x6.startsWith(PAYTO_PREFIX)) {
          throw new DecodingError(`expected start with payto at ${renderContext(c5)} but got "${x6}"`);
        }
        return x6;
      }
    };
  }
  Paytos2.codecNormalizedForPaytoString = codecNormalizedForPaytoString;
})(Paytos || (Paytos = {}));
function codecForPaytoString() {
  return {
    decode(x6, c5) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
      }
      if (!x6.startsWith(PAYTO_PREFIX)) {
        throw new DecodingError(`expected start with payto at ${renderContext(c5)} but got "${x6}"`);
      }
      return x6;
    }
  };
}
function encodeRFC3986URIComponent(str) {
  return encodeURIComponent(str).replace(/[!'()*]/g, (c5) => `%${c5.charCodeAt(0).toString(16).toUpperCase()}`);
}
var rfc3986 = encodeRFC3986URIComponent;
function createSearchParams(paramList) {
  return paramList.map(([key, value]) => `${rfc3986(key)}=${rfc3986(value)}`).join("&");
}
function stringifyPaytoUri(p4) {
  const url = new URL(`${PAYTO_PREFIX}${p4.targetType}/${p4.targetPath}`);
  const paramList = !p4.params ? [] : Object.entries(p4.params);
  url.search = createSearchParams(paramList);
  return url.href;
}
function parsePaytoUri(s6) {
  if (!s6.startsWith(PAYTO_PREFIX)) {
    return void 0;
  }
  const [acct, search] = s6.slice(PAYTO_PREFIX.length).split("?");
  const firstSlashPos = acct.indexOf("/");
  if (firstSlashPos === -1) {
    return void 0;
  }
  const targetType = acct.slice(0, firstSlashPos);
  const targetPath = acct.slice(firstSlashPos + 1);
  const params = {};
  const searchParams = new URLSearchParams2(search || "");
  searchParams.forEach((v3, k6) => {
    params[k6] = v3;
  });
  switch (targetType) {
    case "iban": {
      const parts = targetPath.split("/");
      let iban = void 0;
      let bic = void 0;
      if (parts.length === 1) {
        iban = parts[0].toUpperCase();
      }
      if (parts.length === 2) {
        bic = parts[0];
        iban = parts[1].toUpperCase();
      } else {
        iban = targetPath.toUpperCase();
      }
      return {
        isKnown: true,
        targetPath,
        targetType,
        params,
        iban,
        bic
      };
    }
    case "bitcoin": {
      const msg = /\b([A-Z0-9]{52})\b/.exec(params["message"]);
      const reserve = !msg ? params["subject"] : msg[0];
      const pubRes = !reserve ? void 0 : Paytos.parseReservePub(reserve);
      const addr = !pubRes || pubRes.type === "fail" ? void 0 : generateFakeSegwitAddress(pubRes.body, targetPath);
      const segwitAddrs = !addr || addr.type === "fail" ? [] : addr.body;
      const result = {
        isKnown: true,
        targetPath,
        targetType,
        address: targetPath,
        params,
        segwitAddrs
      };
      return result;
    }
    case "x-taler-bank": {
      const parts = targetPath.split("/");
      const host = parts[0];
      const account = parts[1];
      return {
        targetPath,
        targetType,
        params,
        isKnown: true,
        host,
        account
      };
    }
    case "taler-reserve": {
      const parts = targetPath.split("/");
      const exchange = parts[0];
      const reservePub = parts[1];
      return {
        targetPath,
        targetType,
        params,
        isKnown: true,
        exchange,
        reservePub
      };
    }
    case "ethereum": {
      const result = {
        isKnown: true,
        targetPath,
        targetType,
        address: targetPath,
        params
      };
      return result;
    }
    default: {
      return {
        targetPath,
        targetType,
        params,
        isKnown: false
      };
    }
  }
}

// ../taler-util/lib/types-taler-exchange.js
var DenominationPubKey;
(function(DenominationPubKey2) {
  function cmp(p1, p22) {
    if (p1.cipher < p22.cipher) {
      return -1;
    } else if (p1.cipher > p22.cipher) {
      return 1;
    } else if (p1.cipher === DenomKeyType.Rsa && p22.cipher === DenomKeyType.Rsa) {
      if ((p1.age_mask ?? 0) < (p22.age_mask ?? 0)) {
        return -1;
      } else if ((p1.age_mask ?? 0) > (p22.age_mask ?? 0)) {
        return 1;
      }
      return strcmp(p1.rsa_public_key, p22.rsa_public_key);
    } else if (p1.cipher === DenomKeyType.ClauseSchnorr && p22.cipher === DenomKeyType.ClauseSchnorr) {
      if ((p1.age_mask ?? 0) < (p22.age_mask ?? 0)) {
        return -1;
      } else if ((p1.age_mask ?? 0) > (p22.age_mask ?? 0)) {
        return 1;
      }
      return strcmp(p1.cs_public_key, p22.cs_public_key);
    } else {
      throw Error("unsupported cipher");
    }
  }
  DenominationPubKey2.cmp = cmp;
})(DenominationPubKey || (DenominationPubKey = {}));
var codecForExchangeWireAccount = () => buildCodecForObject().property("conversion_url", codecOptional(codecForStringURL())).property("credit_restrictions", codecForList(codecForAny())).property("debit_restrictions", codecForList(codecForAny())).property("master_sig", codecForEddsaSignature()).property("payto_uri", codecForString()).property("bank_label", codecOptional(codecForString())).property("priority", codecOptional(codecForNumber())).build("WireAccount");
var codecForNgDenominations = codecForAny();
var DenomKeyType;
(function(DenomKeyType2) {
  DenomKeyType2["Rsa"] = "RSA";
  DenomKeyType2["ClauseSchnorr"] = "CS";
})(DenomKeyType || (DenomKeyType = {}));
(function(DenomKeyType2) {
  function toIntTag(t5) {
    switch (t5) {
      case DenomKeyType2.Rsa:
        return 1;
      case DenomKeyType2.ClauseSchnorr:
        return 2;
    }
  }
  DenomKeyType2.toIntTag = toIntTag;
})(DenomKeyType || (DenomKeyType = {}));
var codecForRsaBlindedDenominationSignature = () => buildCodecForObject().property("cipher", codecForConstString(DenomKeyType.Rsa)).property("blinded_rsa_signature", codecForString()).build("RsaBlindedDenominationSignature");
var codecForBlindedDenominationSignature = () => buildCodecForUnion().discriminateOn("cipher").alternative(DenomKeyType.Rsa, codecForRsaBlindedDenominationSignature()).build("BlindedDenominationSignature");
var codecForExchangeWithdrawResponse = () => buildCodecForObject().property("ev_sigs", codecForList(codecForBlindedDenominationSignature())).build("WithdrawResponse");
var codecForExchangeMeltResponse = () => buildCodecForObject().property("exchange_pub", codecForEddsaPublicKey()).property("exchange_sig", codecForEddsaSignature()).property("noreveal_index", codecForNumber()).property("refresh_base_url", codecOptional(codecForString())).build("ExchangeMeltResponse");
var codecForExchangeGetContractResponse = () => buildCodecForObject().property("purse_pub", codecForString()).property("econtract_sig", codecForString()).property("econtract", codecForString()).build("ExchangeGetContractResponse");
var codecForExchangeMergeSuccessResponse = () => buildCodecForObject().property("merge_amount", codecForAmountString()).property("exchange_timestamp", codecForTimestamp).property("exchange_sig", codecForEddsaSignature()).property("exchange_pub", codecForEddsaPublicKey()).build("ExchangeMergeSuccessResponse");
var codecForExchangeMergeConflictResponse = () => buildCodecForObject().property("merge_timestamp", codecForTimestamp).property("merge_sig", codecForEddsaSignature()).property("reserve_pub", codecForEddsaPublicKey()).property("partner_url", codecOptional(codecForString())).build("ExchangeMergeConflictResponse");
var codecForExchangePurseStatus = () => buildCodecForObject().property("balance", codecForAmountString()).property("deposit_timestamp", codecOptional(codecForTimestamp)).property("merge_timestamp", codecOptional(codecForTimestamp)).build("ExchangePurseStatus");
var AmlSpaDialect;
(function(AmlSpaDialect2) {
  AmlSpaDialect2["TOPS"] = "tops";
  AmlSpaDialect2["GLS"] = "gls";
  AmlSpaDialect2["TESTING"] = "testing";
})(AmlSpaDialect || (AmlSpaDialect = {}));
var LimitOperationType;
(function(LimitOperationType2) {
  LimitOperationType2["withdraw"] = "WITHDRAW";
  LimitOperationType2["deposit"] = "DEPOSIT";
  LimitOperationType2["merge"] = "MERGE";
  LimitOperationType2["aggregate"] = "AGGREGATE";
  LimitOperationType2["balance"] = "BALANCE";
  LimitOperationType2["refund"] = "REFUND";
  LimitOperationType2["close"] = "CLOSE";
  LimitOperationType2["transaction"] = "TRANSACTION";
})(LimitOperationType || (LimitOperationType = {}));
var AmlState;
(function(AmlState2) {
  AmlState2[AmlState2["normal"] = 0] = "normal";
  AmlState2[AmlState2["pending"] = 1] = "pending";
  AmlState2[AmlState2["frozen"] = 2] = "frozen";
})(AmlState || (AmlState = {}));
var codecForAmlSpaDialect = codecForEither(codecForConstString(AmlSpaDialect.GLS), codecForConstString(AmlSpaDialect.TOPS), codecForConstString(AmlSpaDialect.TESTING));
var codecForExchangeConfig = () => buildCodecForObject().property("version", codecForString()).property("name", codecForConstString("taler-exchange")).property("implementation", codecOptional(codecForURN())).property("currency", codecForString()).property("currency_specification", codecForCurrencySpecificiation()).property("supported_kyc_requirements", codecForList(codecForString())).property("aml_spa_dialect", codecOptional(codecForAmlSpaDialect)).deprecatedProperty("shopping_url").deprecatedProperty("wallet_balance_limit_without_kyc").build("TalerExchangeApi.ExchangeVersionResponse");
var codecForExchangeKeysResponse = () => buildCodecForObject().property("version", codecForString()).property("base_url", codecForString()).property("currency", codecForString()).property("accounts", codecForAny()).property("asset_type", codecForAny()).property("auditors", codecForAny()).property("currency_specification", codecForAny()).property("zero_limits", codecForAny()).property("hard_limits", codecForAny()).property("denominations", codecForAny()).property("exchange_pub", codecForAny()).property("exchange_sig", codecForAny()).property("extensions", codecForAny()).property("extensions_sig", codecForAny()).property("global_fees", codecForAny()).property("list_issue_date", codecForAny()).property("master_public_key", codecForAny()).property("recoup", codecForAny()).property("reserve_closing_delay", codecForAny()).property("signkeys", codecForAny()).property("stefan_abs", codecForAny()).property("stefan_lin", codecForAny()).property("stefan_log", codecForAny()).property("wads", codecForAny()).property("wallet_balance_limit_without_kyc", codecForAny()).property("wire_fees", codecForAny()).property("kyc_enabled", codecOptional(codecForBoolean())).property("shopping_url", codecOptional(codecForString())).property("tiny_amount", codecOptional(codecForAmountString())).property("bank_compliance_language", codecOptional(codecForString())).deprecatedProperty("rewards_allowed").build("TalerExchangeApi.ExchangeKeysResponse");
var codecForAmlStatisticsResponse = () => buildCodecForObject().property("statistics", codecForList(codecForEventCounter())).build("TalerExchangeApi.AmlStatisticsResponse");
var codecForEventCounter = () => buildCodecForObject().property("name", codecForString()).property("counter", codecForNumber()).build("TalerExchangeApi.EventCounter");
var codecForLegitimizationMeasuresList = () => buildCodecForObject().property("measures", codecForList(codecForLegitimizationMeasureDetails())).build("TalerExchangeApi.LegitimizationMeasuresList");
var codecForLegitimizationMeasureDetails = () => buildCodecForObject().property("h_payto", codecForAny()).property("rowid", codecForAny()).property("start_time", codecForAny()).property("measures", codecForAny()).property("is_finished", codecForAny()).build("TalerExchangeApi.LegitimizationMeasureDetails");
var codecForAvailableMeasureSummary = () => buildCodecForObject().property("checks", codecForMap(codecForKycCheckInformation())).property("programs", codecForMap(codecForAmlProgramRequirement())).property("roots", codecForMap(codecForMeasureInformation())).property("default_rules", codecForList(codecForKycRules())).build("TalerExchangeApi.AvailableMeasureSummary");
var codecForAmlProgramRequirement = () => buildCodecForObject().property("description", codecForString()).property("context", codecForList(codecForString())).property("inputs", codecForList(codecForString())).build("TalerExchangeApi.AmlProgramRequirement");
var codecForKycCheckInformation = () => buildCodecForObject().property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("fallback", codecForString()).property("outputs", codecForList(codecForString())).property("requires", codecForList(codecForString())).build("TalerExchangeApi.KycCheckInformation");
var codecForMeasureInformation = () => buildCodecForObject().property("prog_name", codecOptional(codecForString())).property("check_name", codecForString()).property("context", codecForAny()).property("operation_type", codecOptional(codecForOperationType)).property("voluntary", codecOptional(codecForBoolean())).build("TalerExchangeApi.MeasureInformation");
var codecForAmlDecisionsResponse = () => buildCodecForObject().property("records", codecForList(codecForAmlDecision())).build("TalerExchangeApi.AmlDecisionsResponse");
var codecForAmlDecision = () => buildCodecForObject().property("h_payto", codecForString()).property("full_payto", codecOptional(codecForString())).property("rowid", codecForNumber()).property("is_wallet", codecForBoolean()).property("justification", codecOptional(codecForString())).property("decision_time", codecForTimestamp).property("properties", codecOptional(codecForAccountProperties())).property("limits", codecForLegitimizationRuleSet()).property("to_investigate", codecForBoolean()).property("is_active", codecForBoolean()).build("TalerExchangeApi.AmlDecision");
var codecForAccountProperties = () => buildCodecForObject().property("pep", codecOptional(codecForBoolean())).property("sanctioned", codecOptional(codecForBoolean())).property("high_risk", codecOptional(codecForBoolean())).property("business_domain", codecOptional(codecForString())).property("is_frozen", codecOptional(codecForBoolean())).property("was_reported", codecOptional(codecForBoolean())).allowExtra().build("TalerExchangeApi.AccountProperties");
var codecForLegitimizationRuleSet = () => buildCodecForObject().property("expiration_time", codecForTimestamp).property("successor_measure", codecOptional(codecForString())).property("rules", codecForList(codecForKycRules())).property("custom_measures", codecForMap(codecForMeasureInformation())).build("TalerExchangeApi.LegitimizationRuleSet");
var codecForKycRules = () => buildCodecForObject().property("operation_type", codecForOperationType).property("threshold", codecForAmountString()).property("timeframe", codecForDuration).property("measures", codecForList(codecForString())).property("display_priority", codecForNumber()).property("exposed", codecOptional(codecForBoolean())).property("is_and_combinator", codecOptional(codecForBoolean())).property("rule_name", codecOptional(codecForString())).build("TalerExchangeApi.KycRule");
var codecForAmlKycAttributes = () => buildCodecForObject().property("details", codecForList(codecForKycAttributeCollectionEvent())).build("TalerExchangeApi.KycAttributes");
var codecForKycAttributeCollectionEvent = () => buildCodecForObject().property("rowid", codecForNumber()).property("provider_name", codecOptional(codecForString())).property("collection_time", codecForTimestamp).property("attributes", codecOptional(codecForAny())).build("TalerExchangeApi.KycAttributeCollectionEvent");
var codecForAmlWalletKycCheckResponse = () => buildCodecForObject().property("next_threshold", codecOptional(codecForAmountString())).property("expiration_time", codecForTimestamp).build("TalerExchangeApi.WalletKycCheckResponse");
var codecForLegitimizationNeededResponse = () => buildCodecForObject().property("code", codecForNumber()).property("hint", codecOptional(codecForString())).property("h_payto", codecForString()).property("account_pub", codecOptional(codecForEddsaPublicKey())).property("requirement_row", codecForNumber()).property("bad_kyc_auth", codecOptional(codecForBoolean())).build("TalerExchangeApi.LegitimizationNeededResponse");
var codecForAccountKycStatus = () => buildCodecForObject().property("aml_review", codecForBoolean()).property("access_token", codecForAccessToken()).property("limits", codecOptional(codecForList(codecForAccountLimit()))).property("rule_gen", codecForNumber()).build("TalerExchangeApi.AccountKycStatus");
var codecForOperationType = codecForEither(codecForConstString(LimitOperationType.withdraw), codecForConstString(LimitOperationType.deposit), codecForConstString(LimitOperationType.merge), codecForConstString(LimitOperationType.balance), codecForConstString(LimitOperationType.close), codecForConstString(LimitOperationType.aggregate), codecForConstString(LimitOperationType.transaction), codecForConstString(LimitOperationType.refund));
var codecForAccountLimit = () => buildCodecForObject().property("operation_type", codecForOperationType).property("timeframe", codecForDuration).property("threshold", codecForAmountString()).property("soft_limit", codecOptional(codecForBoolean())).property("rule_name", codecOptional(codecForString())).build("TalerExchangeApi.AccountLimit");
var codecForKycRequirementInformationId = () => codecForString();
var codecForKycFormId = () => codecForString();
var codecForKycRequirementInformation = () => buildCodecForObject().property("form", codecForEither(codecForConstString("LINK"), codecForConstString("INFO"), codecForKycFormId())).property("description", codecForString()).property("context", codecOptional(codecForAny())).property("description_i18n", codecOptional(codecForInternationalizedString())).property("id", codecOptional(codecForKycRequirementInformationId())).build("TalerExchangeApi.KycRequirementInformation");
var codecForKycProcessClientInformation = () => buildCodecForObject().property("requirements", codecOptionalDefault(codecForList(codecForKycRequirementInformation()), [])).property("is_and_combinator", codecOptional(codecForBoolean())).property("voluntary_measures", codecOptional(codecForList(codecForKycRequirementInformation()))).build("TalerExchangeApi.KycProcessClientInformation");
var codecForExchangeTransferList = () => buildCodecForObject().property("transfers", codecForList(codecForExchangeTransferListEntry())).build("TalerExchangeApi.ExchangeTransferList");
var codecForExchangeTransferListEntry = () => buildCodecForObject().property("rowid", codecForNumber()).property("payto_uri", codecForPaytoString()).property("amount", codecForAmountString()).property("execution_time", codecForTimestamp).build("TalerExchangeApi.ExchangeTransferListEntry");
var codecForKycProcessStartInformation = () => buildCodecForObject().property("redirect_url", codecForURLString()).build("TalerExchangeApi.KycProcessStartInformation");
var TransactionHistoryType;
(function(TransactionHistoryType2) {
  TransactionHistoryType2["setup"] = "SETUP";
  TransactionHistoryType2["withdraw"] = "WITHDRAW";
  TransactionHistoryType2["ageWithdraw"] = "AGEWITHDRAW";
  TransactionHistoryType2["credit"] = "CREDIT";
  TransactionHistoryType2["closing"] = "CLOSING";
  TransactionHistoryType2["open"] = "OPEN";
  TransactionHistoryType2["close"] = "CLOSE";
  TransactionHistoryType2["merge"] = "MERGE";
})(TransactionHistoryType || (TransactionHistoryType = {}));
var codecForPurseConflict = () => buildCodecForUnion().discriminateOn("code").alternative(TalerErrorCode.EXCHANGE_GENERIC_INSUFFICIENT_FUNDS, codecForDepositDoubleSpendError()).alternative(TalerErrorCode.EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA, codecForPurseCreateConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA, codecForPurseDepositConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA, codecForPurseContractConflict()).build("PurseConflict");
var codecForPurseConflictPartial = () => buildCodecForUnion().discriminateOn("code").alternative(TalerErrorCode.EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA, codecForPurseCreateConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA, codecForPurseDepositConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA, codecForPurseContractConflict()).build("PurseConflictPartial");
var codecForDepositDoubleSpendError = () => buildCodecForObject().property("code", codecForNumber()).property("hint", codecForString()).property("coin_pub", codecForString()).build("DepositDoubleSpendError");
var codecForPurseCreateConflict = () => buildCodecForObject().property("code", codecForNumber()).property("amount", codecForAmountString()).property("min_age", codecForNumber()).property("purse_expiration", codecForTimestamp).property("purse_sig", codecForString()).property("h_contract_terms", codecForString()).property("merge_pub", codecForString()).build("PurseCreateConflict");
var codecForPurseDepositConflict = () => buildCodecForObject().property("code", codecForNumber()).property("coin_pub", codecForString()).property("partner_url", codecOptional(codecForString())).property("amount", codecForAmountString()).build("PurseDepositConflict");
var codecForPurseContractConflict = () => buildCodecForObject().property("code", codecForNumber()).property("h_econtract", codecForString()).property("econtract_sig", codecForString()).property("contract_pub", codecForString()).build("PurseContractConflict");

// ../taler-util/lib/taler-crypto.js
var isEddsaPubP = Symbol("isEddsaPubP");
var isEddsaPrivP = Symbol("isEddsaPrivP");
var isEddsaSigP = Symbol("isEddsaSigP");
var isEdx25519PublicKey = Symbol("isEdx25519PublicKey");
var isEdx25519PrivateKey = Symbol("isEdx25519PrivateKey");
var isEcdhePrivP = Symbol("isEcdhePrivP");
var isEdx25519Signature = Symbol("isEdx25519Signature");
var isEdx25519PublicKeyEnc = Symbol("isEdx25519PublicKeyEnc");
var isEdx25519PrivateKeyEnc = Symbol("isEdx25519PrivateKeyEnc");
var isEncryptionNonce = Symbol("isEncryptionNone");
function getRandomBytes(n2) {
  return randomBytes(n2);
}
var useNative = true;
var tart;
if (useNative) {
  tart = globalThis._tart;
}
var encTable = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
var EncodingError = class _EncodingError extends Error {
  constructor() {
    super("Encoding error");
    Object.setPrototypeOf(this, _EncodingError.prototype);
  }
};
function getValue(chr) {
  let a6 = chr;
  switch (chr) {
    case "O":
    case "o":
      a6 = "0";
      break;
    case "i":
    case "I":
    case "l":
    case "L":
      a6 = "1";
      break;
    case "u":
    case "U":
      a6 = "V";
  }
  if (a6 >= "0" && a6 <= "9") {
    return a6.charCodeAt(0) - "0".charCodeAt(0);
  }
  if (a6 >= "a" && a6 <= "z")
    a6 = a6.toUpperCase();
  let dec = 0;
  if (a6 >= "A" && a6 <= "Z") {
    if ("I" < a6)
      dec++;
    if ("L" < a6)
      dec++;
    if ("O" < a6)
      dec++;
    if ("U" < a6)
      dec++;
    return a6.charCodeAt(0) - "A".charCodeAt(0) + 10 - dec;
  }
  throw new EncodingError();
}
function encodeCrock(data) {
  if (tart) {
    return tart.encodeCrock(data);
  }
  const dataBytes = new Uint8Array(data);
  let sb = "";
  const size = data.byteLength;
  let bitBuf = 0;
  let numBits = 0;
  let pos = 0;
  while (pos < size || numBits > 0) {
    if (pos < size && numBits < 5) {
      const d6 = dataBytes[pos++];
      bitBuf = bitBuf << 8 | d6;
      numBits += 8;
    }
    if (numBits < 5) {
      bitBuf = bitBuf << 5 - numBits;
      numBits = 5;
    }
    const v3 = bitBuf >>> numBits - 5 & 31;
    sb += encTable[v3];
    numBits -= 5;
  }
  return sb;
}
function kdf(outputLength, ikm, salt, info) {
  if (tart) {
    return tart.kdf(outputLength, ikm, salt, info);
  }
  salt = salt ?? new Uint8Array(64);
  const prk = hmacSha512(salt, ikm);
  info = info ?? new Uint8Array(0);
  const N3 = Math.ceil(outputLength / 32);
  const output = new Uint8Array(N3 * 32);
  for (let i5 = 0; i5 < N3; i5++) {
    let buf;
    if (i5 == 0) {
      buf = new Uint8Array(info.byteLength + 1);
      buf.set(info, 0);
    } else {
      buf = new Uint8Array(info.byteLength + 1 + 32);
      for (let j4 = 0; j4 < 32; j4++) {
        buf[j4] = output[(i5 - 1) * 32 + j4];
      }
      buf.set(info, 32);
    }
    buf[buf.length - 1] = i5 + 1;
    const chunk = hmacSha256(prk, buf);
    output.set(chunk, i5 * 32);
  }
  return output.slice(0, outputLength);
}
function kdfKw(args) {
  return kdf(args.outputLength, args.ikm, args.salt, args.info);
}
function decodeCrock(encoded) {
  if (tart) {
    return tart.decodeCrock(encoded);
  }
  const size = encoded.length;
  let bitpos = 0;
  let bitbuf = 0;
  let readPosition = 0;
  const outLen = Math.floor(size * 5 / 8);
  const out = new Uint8Array(outLen);
  let outPos = 0;
  while (readPosition < size || bitpos > 0) {
    if (readPosition < size) {
      const v3 = getValue(encoded[readPosition++]);
      bitbuf = bitbuf << 5 | v3;
      bitpos += 5;
    }
    while (bitpos >= 8) {
      const d6 = bitbuf >>> bitpos - 8 & 255;
      out[outPos++] = d6;
      bitpos -= 8;
    }
    if (readPosition == size && bitpos > 0) {
      bitbuf = bitbuf << 8 - bitpos & 255;
      bitpos = bitbuf == 0 ? 0 : 8;
    }
  }
  return out;
}
var encoder;
function stringToBytes(s6) {
  if (!encoder) {
    encoder = new TextEncoder();
  }
  return encoder.encode(s6);
}
function typedArrayConcat(chunks) {
  let payloadLen = 0;
  for (const c5 of chunks) {
    payloadLen += c5.byteLength;
  }
  const buf = new ArrayBuffer(payloadLen);
  const u8buf = new Uint8Array(buf);
  let p4 = 0;
  for (const c5 of chunks) {
    u8buf.set(c5, p4);
    p4 += c5.byteLength;
  }
  return u8buf;
}
function hash2(d6) {
  if (tart) {
    return tart.hash(d6);
  }
  return hash(d6);
}
function hashTruncate32(d6) {
  const sha512HashCode = hash2(d6);
  return sha512HashCode.subarray(0, 32);
}
var logger4 = new Logger("talerCrypto.ts");
function eddsaSign(msg, eddsaPriv) {
  if (tart) {
    return tart.eddsaSign(msg, eddsaPriv);
  }
  const pair = crypto_sign_keyPair_fromSeed(eddsaPriv);
  return sign_detached(msg, pair.secretKey);
}
function bufferForUint32(n2) {
  const arrBuf = new ArrayBuffer(4);
  const buf = new Uint8Array(arrBuf);
  const dv = new DataView(arrBuf);
  dv.setUint32(0, n2);
  return buf;
}
function bufferForUint64(n2) {
  const arrBuf = new ArrayBuffer(8);
  const buf = new Uint8Array(arrBuf);
  const dv = new DataView(arrBuf);
  if (n2 < 0 || !Number.isInteger(n2)) {
    throw Error("non-negative integer expected");
  }
  dv.setBigUint64(0, BigInt(n2));
  return buf;
}
var TalerSignaturePurpose;
(function(TalerSignaturePurpose2) {
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_TRACK_TRANSACTION"] = 1103] = "MERCHANT_TRACK_TRANSACTION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_WITHDRAW"] = 1200] = "WALLET_RESERVE_WITHDRAW";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_HISTORY"] = 1208] = "WALLET_RESERVE_HISTORY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_DEPOSIT"] = 1201] = "WALLET_COIN_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["GLOBAL_FEES"] = 1022] = "GLOBAL_FEES";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DENOMINATION_KEY_VALIDITY"] = 1025] = "MASTER_DENOMINATION_KEY_VALIDITY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_WIRE_FEES"] = 1028] = "MASTER_WIRE_FEES";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_WIRE_DETAILS"] = 1030] = "MASTER_WIRE_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_MELT"] = 1202] = "WALLET_COIN_MELT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["TEST"] = 4242] = "TEST";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_PAYMENT_OK"] = 1104] = "MERCHANT_PAYMENT_OK";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_CONTRACT"] = 1101] = "MERCHANT_CONTRACT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_REFUND"] = 1102] = "MERCHANT_REFUND";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_RECOUP"] = 1203] = "WALLET_COIN_RECOUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_LINK"] = 1204] = "WALLET_COIN_LINK";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_ACCOUNT_SETUP"] = 1205] = "WALLET_ACCOUNT_SETUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_RECOUP_REFRESH"] = 1206] = "WALLET_COIN_RECOUP_REFRESH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_AGE_ATTESTATION"] = 1207] = "WALLET_AGE_ATTESTATION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_CREATE"] = 1210] = "WALLET_PURSE_CREATE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_DEPOSIT"] = 1211] = "WALLET_PURSE_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_MERGE"] = 1213] = "WALLET_PURSE_MERGE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_ACCOUNT_MERGE"] = 1214] = "WALLET_ACCOUNT_MERGE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_ECONTRACT"] = 1216] = "WALLET_PURSE_ECONTRACT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_DELETE"] = 1220] = "WALLET_PURSE_DELETE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_TOKEN_USE"] = 1222] = "WALLET_TOKEN_USE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_HISTORY"] = 1209] = "WALLET_COIN_HISTORY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_RECOUP"] = 1039] = "EXCHANGE_CONFIRM_RECOUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_RECOUP_REFRESH"] = 1041] = "EXCHANGE_CONFIRM_RECOUP_REFRESH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["AML_DECISION"] = 1350] = "AML_DECISION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["AML_QUERY"] = 1351] = "AML_QUERY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_AML_KEY"] = 1017] = "MASTER_AML_KEY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["KYC_AUTH"] = 1360] = "KYC_AUTH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["ANASTASIS_POLICY_UPLOAD"] = 1400] = "ANASTASIS_POLICY_UPLOAD";
  TalerSignaturePurpose2[TalerSignaturePurpose2["ANASTASIS_POLICY_DOWNLOAD"] = 1401] = "ANASTASIS_POLICY_DOWNLOAD";
  TalerSignaturePurpose2[TalerSignaturePurpose2["SYNC_BACKUP_UPLOAD"] = 1450] = "SYNC_BACKUP_UPLOAD";
})(TalerSignaturePurpose || (TalerSignaturePurpose = {}));
var WalletAccountMergeFlags;
(function(WalletAccountMergeFlags2) {
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["None"] = 0] = "None";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["MergeFullyPaidPurse"] = 1] = "MergeFullyPaidPurse";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["CreateFromPurseQuota"] = 2] = "CreateFromPurseQuota";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["CreateWithPurseFee"] = 3] = "CreateWithPurseFee";
})(WalletAccountMergeFlags || (WalletAccountMergeFlags = {}));
var SignaturePurposeBuilder = class {
  constructor(purposeNum) {
    this.purposeNum = purposeNum;
    this.chunks = [];
  }
  put(bytes) {
    this.chunks.push(Uint8Array.from(bytes));
    return this;
  }
  build() {
    let payloadLen = 0;
    for (const c5 of this.chunks) {
      payloadLen += c5.byteLength;
    }
    const buf = new ArrayBuffer(4 + 4 + payloadLen);
    const u8buf = new Uint8Array(buf);
    let p4 = 8;
    for (const c5 of this.chunks) {
      u8buf.set(c5, p4);
      p4 += c5.byteLength;
    }
    const dvbuf = new DataView(buf);
    dvbuf.setUint32(0, payloadLen + 4 + 4);
    dvbuf.setUint32(4, this.purposeNum);
    return u8buf;
  }
};
function buildSigPS(purposeNum) {
  return new SignaturePurposeBuilder(purposeNum);
}
function bigintToNaclArr(x6, size) {
  const byteArr = new Uint8Array(size);
  const arr = x6.toArray(256).value.reverse();
  byteArr.set(arr, 0);
  return byteArr;
}
function bigintFromNaclArr(arr) {
  let rev = new Uint8Array(arr);
  rev = rev.reverse();
  return import_big_integer.default.fromArray(Array.from(rev), 256, false);
}
var Edx25519;
(function(Edx255192) {
  const revL = [
    237,
    211,
    245,
    92,
    26,
    99,
    18,
    88,
    214,
    156,
    247,
    162,
    222,
    249,
    222,
    20,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    16
  ];
  const L6 = import_big_integer.default.fromArray(revL.reverse(), 256, false);
  async function keyCreateFromSeed(seed) {
    return crypto_edx25519_private_key_create_from_seed(seed);
  }
  Edx255192.keyCreateFromSeed = keyCreateFromSeed;
  async function keyCreate() {
    return crypto_edx25519_private_key_create();
  }
  Edx255192.keyCreate = keyCreate;
  async function getPublic(priv) {
    return crypto_edx25519_get_public(priv);
  }
  Edx255192.getPublic = getPublic;
  function sign2(msg, key) {
    throw Error("not implemented");
  }
  Edx255192.sign = sign2;
  async function deriveFactor(pub, seed) {
    const res = kdfKw({
      outputLength: 64,
      ikm: pub,
      salt: stringToBytes("edx25519-derivation"),
      info: seed
    });
    return res;
  }
  async function privateKeyDerive(priv, seed) {
    const pub = await getPublic(priv);
    const privDec = priv;
    const a6 = bigintFromNaclArr(privDec.subarray(0, 32));
    const factorEnc = await deriveFactor(pub, seed);
    const factorModL = bigintFromNaclArr(factorEnc).mod(L6);
    const aPrime = a6.divide(8).multiply(factorModL).mod(L6).multiply(8).mod(L6);
    const bPrime = hash(typedArrayConcat([privDec.subarray(32, 64), factorEnc])).subarray(0, 32);
    const newPriv = typedArrayConcat([bigintToNaclArr(aPrime, 32), bPrime]);
    return newPriv;
  }
  Edx255192.privateKeyDerive = privateKeyDerive;
  async function publicKeyDerive(pub, seed) {
    const factorEnc = await deriveFactor(pub, seed);
    const factorReduced = crypto_core_ed25519_scalar_reduce(factorEnc);
    const res = crypto_scalarmult_ed25519_noclamp(factorReduced, pub);
    return res;
  }
  Edx255192.publicKeyDerive = publicKeyDerive;
})(Edx25519 || (Edx25519 = {}));
function invariant(cond) {
  if (!cond) {
    throw Error("invariant failed");
  }
}
var AgeRestriction;
(function(AgeRestriction2) {
  AgeRestriction2.AGE_UNRESTRICTED = 32;
  function hashCommitment(ac) {
    const hc = new HashState();
    for (const pub of ac.publicKeys) {
      hc.update(decodeCrock(pub));
    }
    return encodeCrock(hc.finish().subarray(0, 32));
  }
  AgeRestriction2.hashCommitment = hashCommitment;
  function countAgeGroups(mask) {
    let count = 0;
    let m6 = mask;
    while (m6 > 0) {
      count += m6 & 1;
      m6 = m6 >> 1;
    }
    return count;
  }
  AgeRestriction2.countAgeGroups = countAgeGroups;
  function getAgeGroupsFromMask(mask) {
    const groups = [];
    let age = 1;
    let m6 = mask >> 1;
    while (m6 > 0) {
      if (m6 & 1) {
        groups.push(age);
      }
      m6 = m6 >> 1;
      age++;
    }
    return groups;
  }
  AgeRestriction2.getAgeGroupsFromMask = getAgeGroupsFromMask;
  function getAgeGroupIndex(mask, age) {
    invariant((mask & 1) === 1);
    let i5 = 0;
    let m6 = mask;
    let a6 = age;
    while (m6 > 0) {
      if (a6 <= 0) {
        break;
      }
      m6 = m6 >> 1;
      i5 += m6 & 1;
      a6--;
    }
    return i5;
  }
  AgeRestriction2.getAgeGroupIndex = getAgeGroupIndex;
  function ageGroupSpecToMask(ageGroupSpec) {
    throw Error("not implemented");
  }
  AgeRestriction2.ageGroupSpecToMask = ageGroupSpecToMask;
  async function restrictionCommit(ageMask, age) {
    invariant((ageMask & 1) === 1);
    const numPubs = countAgeGroups(ageMask) - 1;
    const numPrivs = getAgeGroupIndex(ageMask, age);
    const pubs = [];
    const privs = [];
    for (let i5 = 0; i5 < numPubs; i5++) {
      const priv = await Edx25519.keyCreate();
      const pub = await Edx25519.getPublic(priv);
      pubs.push(pub);
      if (i5 < numPrivs) {
        privs.push(priv);
      }
    }
    return {
      commitment: {
        mask: ageMask,
        publicKeys: pubs.map((x6) => encodeCrock(x6))
      },
      proof: {
        privateKeys: privs.map((x6) => encodeCrock(x6))
      }
    };
  }
  AgeRestriction2.restrictionCommit = restrictionCommit;
  const PublishedAgeRestrictionBaseKey = decodeCrock("CH0VKFDZ2GWRWHQBBGEK9MWV5YDQVJ0RXEE0KYT3NMB69F0R96TG");
  async function restrictionCommitSeeded(ageMask, age, seed) {
    invariant((ageMask & 1) === 1);
    const numPubs = countAgeGroups(ageMask) - 1;
    const numPrivs = getAgeGroupIndex(ageMask, age);
    const pubs = [];
    const privs = [];
    for (let i5 = 0; i5 < numPrivs; i5++) {
      const privSeed = await kdfKw({
        outputLength: 32,
        ikm: seed,
        info: stringToBytes("age-commitment"),
        salt: bufferForUint32(i5)
      });
      const priv = await Edx25519.keyCreateFromSeed(privSeed);
      const pub = await Edx25519.getPublic(priv);
      pubs.push(pub);
      privs.push(priv);
    }
    for (let i5 = numPrivs; i5 < numPubs; i5++) {
      const deriveSeed = await kdfKw({
        outputLength: 32,
        ikm: seed,
        info: stringToBytes("age-factor"),
        salt: bufferForUint32(i5)
      });
      const pub = await Edx25519.publicKeyDerive(PublishedAgeRestrictionBaseKey, deriveSeed);
      pubs.push(pub);
    }
    return {
      commitment: {
        mask: ageMask,
        publicKeys: pubs.map((x6) => encodeCrock(x6))
      },
      proof: {
        privateKeys: privs.map((x6) => encodeCrock(x6))
      }
    };
  }
  AgeRestriction2.restrictionCommitSeeded = restrictionCommitSeeded;
  async function commitCompare(c1, c22, salt) {
    if (c1.publicKeys.length != c22.publicKeys.length) {
      return false;
    }
    for (let i5 = 0; i5 < c1.publicKeys.length; i5++) {
      const k1 = decodeCrock(c1.publicKeys[i5]);
      const k22 = await Edx25519.publicKeyDerive(decodeCrock(c22.publicKeys[i5]), salt);
      if (k1 != k22) {
        return false;
      }
    }
    return true;
  }
  AgeRestriction2.commitCompare = commitCompare;
  async function commitmentDerive(commitmentProof, salt) {
    const newPrivs = [];
    const newPubs = [];
    for (const oldPub of commitmentProof.commitment.publicKeys) {
      newPubs.push(await Edx25519.publicKeyDerive(decodeCrock(oldPub), salt));
    }
    for (const oldPriv of commitmentProof.proof.privateKeys) {
      newPrivs.push(await Edx25519.privateKeyDerive(decodeCrock(oldPriv), salt));
    }
    return {
      commitment: {
        mask: commitmentProof.commitment.mask,
        publicKeys: newPubs.map((x6) => encodeCrock(x6))
      },
      proof: {
        privateKeys: newPrivs.map((x6) => encodeCrock(x6))
      }
    };
  }
  AgeRestriction2.commitmentDerive = commitmentDerive;
  function commitmentAttest(commitmentProof, age) {
    const d6 = buildSigPS(TalerSignaturePurpose.WALLET_AGE_ATTESTATION).put(bufferForUint32(commitmentProof.commitment.mask)).put(bufferForUint32(age)).build();
    const group = getAgeGroupIndex(commitmentProof.commitment.mask, age);
    if (group === 0) {
      return new Uint8Array(64);
    }
    const priv = commitmentProof.proof.privateKeys[group - 1];
    const pub = commitmentProof.commitment.publicKeys[group - 1];
    const sig = crypto_edx25519_sign_detached(d6, decodeCrock(priv), decodeCrock(pub));
    return sig;
  }
  AgeRestriction2.commitmentAttest = commitmentAttest;
  function commitmentVerify(commitment, sig, age) {
    const d6 = buildSigPS(TalerSignaturePurpose.WALLET_AGE_ATTESTATION).put(bufferForUint32(commitment.mask)).put(bufferForUint32(age)).build();
    const group = getAgeGroupIndex(commitment.mask, age);
    if (group === 0) {
      return true;
    }
    const pub = commitment.publicKeys[group - 1];
    return crypto_edx25519_sign_detached_verify(d6, decodeCrock(sig), decodeCrock(pub));
  }
  AgeRestriction2.commitmentVerify = commitmentVerify;
})(AgeRestriction || (AgeRestriction = {}));
var ContractFormatTag;
(function(ContractFormatTag2) {
  ContractFormatTag2[ContractFormatTag2["PaymentOffer"] = 0] = "PaymentOffer";
  ContractFormatTag2[ContractFormatTag2["PaymentRequest"] = 1] = "PaymentRequest";
})(ContractFormatTag || (ContractFormatTag = {}));
var foreverNum = 2n ** 64n - 1n;
function timestampRoundedToBuffer(ts) {
  const b5 = new ArrayBuffer(8);
  const v3 = new DataView(b5);
  const numVal = ts.t_s === "never" ? foreverNum : BigInt(ts.t_s) * 1000n * 1000n;
  if (typeof v3.setBigUint64 !== "undefined") {
    v3.setBigUint64(0, numVal);
  } else {
    const s6 = ts.t_s === "never" ? (0, import_big_integer.default)(foreverNum) : (0, import_big_integer.default)(ts.t_s).multiply(1e3 * 1e3);
    const arr = s6.toArray(2 ** 8).value;
    let offset = 8 - arr.length;
    for (let i5 = 0; i5 < arr.length; i5++) {
      v3.setUint8(offset++, arr[i5]);
    }
  }
  return new Uint8Array(b5);
}

// ../taler-util/lib/types-taler-merchant.js
var types_taler_merchant_exports = {};
__export(types_taler_merchant_exports, {
  CheckPaymentResponse: () => CheckPaymentResponse,
  KycStatusLongPollingReason: () => KycStatusLongPollingReason,
  LoginTokenScope: () => LoginTokenScope,
  MerchantAccountKycStatus: () => MerchantAccountKycStatus,
  MerchantAccountKycStatusSimplified: () => MerchantAccountKycStatusSimplified,
  MerchantAuthMethod: () => MerchantAuthMethod,
  MerchantContractInputType: () => MerchantContractInputType,
  MerchantContractOutputType: () => MerchantContractOutputType,
  MerchantContractTokenKind: () => MerchantContractTokenKind,
  MerchantContractVersion: () => MerchantContractVersion,
  OrderInputType: () => OrderInputType,
  OrderOutputType: () => OrderOutputType,
  OrderVersion: () => OrderVersion,
  TanChannel: () => TanChannel,
  TokenFamilyKind: () => TokenFamilyKind,
  codecForAbortResponse: () => codecForAbortResponse,
  codecForAccountAddResponse: () => codecForAccountAddResponse,
  codecForAccountKycRedirects: () => codecForAccountKycRedirects,
  codecForAccountsSummaryResponse: () => codecForAccountsSummaryResponse,
  codecForAuditorHandle: () => codecForAuditorHandle,
  codecForBankAccountDetail: () => codecForBankAccountDetail,
  codecForBankAccountEntry: () => codecForBankAccountEntry,
  codecForCategoryListEntry: () => codecForCategoryListEntry,
  codecForCategoryListResponse: () => codecForCategoryListResponse,
  codecForCategoryProductList: () => codecForCategoryProductList,
  codecForChallenge: () => codecForChallenge,
  codecForChallengeRequestResponse: () => codecForChallengeRequestResponse,
  codecForChallengeResponse: () => codecForChallengeResponse,
  codecForCheckPaymentClaimedResponse: () => codecForCheckPaymentClaimedResponse,
  codecForCheckPaymentPaidResponse: () => codecForCheckPaymentPaidResponse,
  codecForCheckPaymentResponse: () => codecForCheckPaymentResponse,
  codecForCheckPaymentUnpaidResponse: () => codecForCheckPaymentUnpaidResponse,
  codecForClaimResponse: () => codecForClaimResponse,
  codecForCsTokenIssueBlindSig: () => codecForCsTokenIssueBlindSig,
  codecForExchange: () => codecForExchange,
  codecForExchangeKycTimeout: () => codecForExchangeKycTimeout,
  codecForFullInventoryDetailsResponse: () => codecForFullInventoryDetailsResponse,
  codecForInstance: () => codecForInstance,
  codecForInstancesResponse: () => codecForInstancesResponse,
  codecForInventoryEntry: () => codecForInventoryEntry,
  codecForInventorySummaryResponse: () => codecForInventorySummaryResponse,
  codecForLocation: () => codecForLocation,
  codecForLoginTokenSuccessResponse: () => codecForLoginTokenSuccessResponse,
  codecForMerchant: () => codecForMerchant,
  codecForMerchantAbortPayRefundFailureStatus: () => codecForMerchantAbortPayRefundFailureStatus,
  codecForMerchantAbortPayRefundStatus: () => codecForMerchantAbortPayRefundStatus,
  codecForMerchantAbortPayRefundSuccessStatus: () => codecForMerchantAbortPayRefundSuccessStatus,
  codecForMerchantAbortPayRefundUndepositedStatus: () => codecForMerchantAbortPayRefundUndepositedStatus,
  codecForMerchantAccountKycRedirect: () => codecForMerchantAccountKycRedirect,
  codecForMerchantAccountKycStatus: () => codecForMerchantAccountKycStatus,
  codecForMerchantAuthMethod: () => codecForMerchantAuthMethod,
  codecForMerchantCategory: () => codecForMerchantCategory,
  codecForMerchantClaimResponse: () => codecForMerchantClaimResponse,
  codecForMerchantCoinRefundFailureStatus: () => codecForMerchantCoinRefundFailureStatus,
  codecForMerchantCoinRefundStatus: () => codecForMerchantCoinRefundStatus,
  codecForMerchantCoinRefundSuccessStatus: () => codecForMerchantCoinRefundSuccessStatus,
  codecForMerchantContractChoice: () => codecForMerchantContractChoice,
  codecForMerchantContractDiscountTokenDetails: () => codecForMerchantContractDiscountTokenDetails,
  codecForMerchantContractInput: () => codecForMerchantContractInput,
  codecForMerchantContractInputToken: () => codecForMerchantContractInputToken,
  codecForMerchantContractOutput: () => codecForMerchantContractOutput,
  codecForMerchantContractOutputTaxReceipt: () => codecForMerchantContractOutputTaxReceipt,
  codecForMerchantContractOutputToken: () => codecForMerchantContractOutputToken,
  codecForMerchantContractSubscriptionTokenDetails: () => codecForMerchantContractSubscriptionTokenDetails,
  codecForMerchantContractTerms: () => codecForMerchantContractTerms,
  codecForMerchantContractTermsV0: () => codecForMerchantContractTermsV0,
  codecForMerchantContractTermsV1: () => codecForMerchantContractTermsV1,
  codecForMerchantContractTokenDetails: () => codecForMerchantContractTokenDetails,
  codecForMerchantContractTokenFamily: () => codecForMerchantContractTokenFamily,
  codecForMerchantInfo: () => codecForMerchantInfo,
  codecForMerchantOrderPrivateStatusResponse: () => codecForMerchantOrderPrivateStatusResponse,
  codecForMerchantOrderStatusPaid: () => codecForMerchantOrderStatusPaid,
  codecForMerchantOrderStatusUnpaid: () => codecForMerchantOrderStatusUnpaid,
  codecForMerchantPayResponse: () => codecForMerchantPayResponse,
  codecForMerchantPosProductDetail: () => codecForMerchantPosProductDetail,
  codecForMerchantRefundPermission: () => codecForMerchantRefundPermission,
  codecForMerchantRefundResponse: () => codecForMerchantRefundResponse,
  codecForMerchantReserveCreateConfirmation: () => codecForMerchantReserveCreateConfirmation,
  codecForOrder: () => codecForOrder,
  codecForOrderChoice: () => codecForOrderChoice,
  codecForOrderHistory: () => codecForOrderHistory,
  codecForOrderHistoryEntry: () => codecForOrderHistoryEntry,
  codecForOrderInput: () => codecForOrderInput,
  codecForOrderInputToken: () => codecForOrderInputToken,
  codecForOrderOutput: () => codecForOrderOutput,
  codecForOrderOutputTaxReceipt: () => codecForOrderOutputTaxReceipt,
  codecForOrderOutputToken: () => codecForOrderOutputToken,
  codecForOrderV0: () => codecForOrderV0,
  codecForOrderV1: () => codecForOrderV1,
  codecForOtpDeviceDetails: () => codecForOtpDeviceDetails,
  codecForOtpDeviceEntry: () => codecForOtpDeviceEntry,
  codecForOtpDeviceSummaryResponse: () => codecForOtpDeviceSummaryResponse,
  codecForOutOfStockResponse: () => codecForOutOfStockResponse,
  codecForPaidRefundStatusResponse: () => codecForPaidRefundStatusResponse,
  codecForPaymentDeniedLegallyResponse: () => codecForPaymentDeniedLegallyResponse,
  codecForPaymentResponse: () => codecForPaymentResponse,
  codecForPostOrderResponse: () => codecForPostOrderResponse,
  codecForProduct: () => codecForProduct,
  codecForProductDetail: () => codecForProductDetail,
  codecForProductSummary: () => codecForProductSummary,
  codecForQueryInstancesResponse: () => codecForQueryInstancesResponse,
  codecForRSATokenIssueBlindSig: () => codecForRSATokenIssueBlindSig,
  codecForRefundDetails: () => codecForRefundDetails,
  codecForSignedTokenEnvelope: () => codecForSignedTokenEnvelope,
  codecForStatusGoto: () => codecForStatusGoto,
  codecForStatusPaid: () => codecForStatusPaid,
  codecForStatusStatusUnpaid: () => codecForStatusStatusUnpaid,
  codecForTalerMerchantConfigResponse: () => codecForTalerMerchantConfigResponse,
  codecForTansferList: () => codecForTansferList,
  codecForTax: () => codecForTax,
  codecForTemplateContractDetails: () => codecForTemplateContractDetails,
  codecForTemplateContractDetailsDefaults: () => codecForTemplateContractDetailsDefaults,
  codecForTemplateDetails: () => codecForTemplateDetails,
  codecForTemplateEditableDetails: () => codecForTemplateEditableDetails,
  codecForTemplateEntry: () => codecForTemplateEntry,
  codecForTemplateSummaryResponse: () => codecForTemplateSummaryResponse,
  codecForTokenFamiliesList: () => codecForTokenFamiliesList,
  codecForTokenFamilyDetails: () => codecForTokenFamilyDetails,
  codecForTokenFamilyKind: () => codecForTokenFamilyKind,
  codecForTokenFamilySummary: () => codecForTokenFamilySummary,
  codecForTokenIssueBlindSig: () => codecForTokenIssueBlindSig,
  codecForTokenIssueCsPublicKey: () => codecForTokenIssueCsPublicKey,
  codecForTokenIssuePublicKey: () => codecForTokenIssuePublicKey,
  codecForTokenIssueRsaPublicKey: () => codecForTokenIssueRsaPublicKey,
  codecForTokenScope: () => codecForTokenScope,
  codecForTransactionWireReport: () => codecForTransactionWireReport,
  codecForTransactionWireTransfer: () => codecForTransactionWireTransfer,
  codecForTransferDetails: () => codecForTransferDetails,
  codecForWalletRefundResponse: () => codecForWalletRefundResponse,
  codecForWalletTemplateDetails: () => codecForWalletTemplateDetails,
  codecForWebhookDetails: () => codecForWebhookDetails,
  codecForWebhookEntry: () => codecForWebhookEntry,
  codecForWebhookSummaryResponse: () => codecForWebhookSummaryResponse,
  getMerchantAccountKycStatusSimplified: () => getMerchantAccountKycStatusSimplified
});
var CheckPaymentResponse = class {
};
var codecForMerchantRefundPermission = () => buildCodecForObject().property("refund_amount", codecForAmountString()).property("refund_fee", codecForAmountString()).property("coin_pub", codecForString()).property("rtransaction_id", codecForNumber()).property("exchange_http_status", codecForNumber()).property("exchange_code", codecOptional(codecForNumber())).property("exchange_reply", codecOptional(codecForAny())).property("exchange_sig", codecOptional(codecForString())).property("exchange_pub", codecOptional(codecForString())).build("MerchantRefundPermission");
var codecForMerchantClaimResponse = () => buildCodecForObject().property("contract_terms", codecForMerchantContractTerms()).property("sig", codecForString()).build("MerchantClaimResponse");
var codecForCheckPaymentResponse = () => buildCodecForObject().property("order_status", codecForString()).property("refunded", codecOptional(codecForBoolean())).property("refunded_amount", codecOptional(codecForString())).property("contract_terms", codecOptional(codecForAny())).property("taler_pay_uri", codecOptional(codecForString())).property("contract_url", codecOptional(codecForString())).build("CheckPaymentResponse");
var codecForMerchantPayResponse = () => buildCodecForObject().property("sig", codecForString()).property("pos_confirmation", codecOptional(codecForString())).property("token_sigs", codecOptional(codecForList(codecForSignedTokenEnvelope()))).build("MerchantPayResponse");
var codecForSignedTokenEnvelope = () => buildCodecForObject().property("blind_sig", codecForTokenIssueBlindSig()).build("SignedTokenEnvelope");
var codecForTokenIssueBlindSig = () => buildCodecForUnion().discriminateOn("cipher").alternative(DenomKeyType.Rsa, codecForRSATokenIssueBlindSig()).alternative(DenomKeyType.ClauseSchnorr, codecForCsTokenIssueBlindSig()).build("TokenIssueBlindSig");
var codecForRSATokenIssueBlindSig = () => buildCodecForObject().property("cipher", codecForConstString(DenomKeyType.Rsa)).property("blinded_rsa_signature", codecForString()).build("RSATokenIssueBlindSig");
var codecForCsTokenIssueBlindSig = () => buildCodecForObject().property("cipher", codecForConstString(DenomKeyType.ClauseSchnorr)).property("b", codecForNumber()).property("s", codecForString()).build("CSTokenIssueBlindSig");
var codecForMerchantOrderStatusPaid = () => buildCodecForObject().property("refund_amount", codecForAmountString()).property("refund_taken", codecForAmountString()).property("refund_pending", codecForBoolean()).property("refunded", codecForBoolean()).build("MerchantOrderStatusPaid");
var codecForMerchantOrderStatusUnpaid = () => buildCodecForObject().property("taler_pay_uri", codecForString()).property("already_paid_order_id", codecOptional(codecForString())).build("MerchantOrderStatusUnpaid");
var MerchantContractVersion;
(function(MerchantContractVersion2) {
  MerchantContractVersion2[MerchantContractVersion2["V0"] = 0] = "V0";
  MerchantContractVersion2[MerchantContractVersion2["V1"] = 1] = "V1";
})(MerchantContractVersion || (MerchantContractVersion = {}));
var MerchantContractInputType;
(function(MerchantContractInputType2) {
  MerchantContractInputType2["Token"] = "token";
})(MerchantContractInputType || (MerchantContractInputType = {}));
var MerchantContractOutputType;
(function(MerchantContractOutputType2) {
  MerchantContractOutputType2["Token"] = "token";
  MerchantContractOutputType2["TaxReceipt"] = "tax-receipt";
})(MerchantContractOutputType || (MerchantContractOutputType = {}));
var MerchantContractTokenKind;
(function(MerchantContractTokenKind2) {
  MerchantContractTokenKind2["Subscription"] = "subscription";
  MerchantContractTokenKind2["Discount"] = "discount";
})(MerchantContractTokenKind || (MerchantContractTokenKind = {}));
var codecForAuditorHandle = () => buildCodecForObject().property("name", codecForString()).property("auditor_pub", codecForEddsaPublicKey()).property("url", codecForString()).build("AuditorHandle");
var codecForLocation = () => buildCodecForObject().property("country", codecOptional(codecForString())).property("country_subdivision", codecOptional(codecForString())).property("building_name", codecOptional(codecForString())).property("building_number", codecOptional(codecForString())).property("district", codecOptional(codecForString())).property("street", codecOptional(codecForString())).property("post_code", codecOptional(codecForString())).property("town", codecOptional(codecForString())).property("town_location", codecOptional(codecForString())).property("address_lines", codecOptional(codecForList(codecForString()))).build("Location");
var codecForMerchantInfo = () => buildCodecForObject().property("name", codecForString()).property("address", codecOptional(codecForLocation())).property("jurisdiction", codecOptional(codecForLocation())).build("MerchantInfo");
var codecForMerchantContractTermsCommon = () => buildCodecForObject().property("order_id", codecForString()).property("fulfillment_url", codecOptional(codecForString())).property("fulfillment_message", codecOptional(codecForString())).property("fulfillment_message_i18n", codecOptional(codecForInternationalizedString())).property("public_reorder_url", codecOptional(codecForString())).property("merchant_base_url", codecForString()).property("h_wire", codecForString()).property("auto_refund", codecOptional(codecForDuration)).property("wire_method", codecForString()).property("summary", codecForString()).property("summary_i18n", codecOptional(codecForInternationalizedString())).property("nonce", codecForString()).property("pay_deadline", codecForTimestamp).property("refund_deadline", codecForTimestamp).property("wire_transfer_deadline", codecForTimestamp).property("timestamp", codecForTimestamp).property("delivery_location", codecOptional(codecForLocation())).property("delivery_date", codecOptional(codecForTimestamp)).property("merchant", codecForMerchantInfo()).property("merchant_pub", codecForString()).property("exchanges", codecForList(codecForExchange())).property("products", codecOptional(codecForList(codecForProduct()))).property("extra", codecForAny()).property("minimum_age", codecOptional(codecForNumber())).build("TalerMerchantApi.ContractTermsCommon");
var codecForMerchantContractTermsV0 = () => buildCodecForObject().property("version", codecOptional(codecForConstNumber(MerchantContractVersion.V0))).property("amount", codecForAmountString()).property("max_fee", codecForAmountString()).mixin(codecForMerchantContractTermsCommon()).build("TalerMerchantApi.ContractTermsV0");
var codecForMerchantContractTermsV1 = () => buildCodecForObject().property("version", codecForConstNumber(MerchantContractVersion.V1)).property("choices", codecForList(codecForMerchantContractChoice())).property("token_families", codecForMap(codecForMerchantContractTokenFamily())).mixin(codecForMerchantContractTermsCommon()).build("TalerMerchantApi.ContractTermsV1");
var codecForMerchantContractTerms = () => buildCodecForUnion().discriminateOn("version").alternative(void 0, codecForMerchantContractTermsV0()).alternative(MerchantContractVersion.V0, codecForMerchantContractTermsV0()).alternative(MerchantContractVersion.V1, codecForMerchantContractTermsV1()).build("TalerMerchantApi.ContractTerms");
var codecForMerchantContractChoice = () => buildCodecForObject().property("amount", codecForAmountString()).property("description", codecOptional(codecForString())).property("description_i18n", codecOptional(codecForInternationalizedString())).property("inputs", codecForList(codecForMerchantContractInput())).property("outputs", codecForList(codecForMerchantContractOutput())).property("max_fee", codecForAmountString()).build("TalerMerchantApi.ContractChoice");
var codecForMerchantContractInput = () => buildCodecForUnion().discriminateOn("type").alternative(MerchantContractInputType.Token, codecForMerchantContractInputToken()).build("TalerMerchantApi.ContractInput");
var codecForMerchantContractInputToken = () => buildCodecForObject().property("type", codecForConstString(MerchantContractInputType.Token)).property("token_family_slug", codecForString()).property("count", codecOptional(codecForNumber())).build("TalerMerchantApi.ContractInputToken");
var codecForMerchantContractOutput = () => buildCodecForUnion().discriminateOn("type").alternative(MerchantContractOutputType.Token, codecForMerchantContractOutputToken()).alternative(MerchantContractOutputType.TaxReceipt, codecForMerchantContractOutputTaxReceipt()).build("TalerMerchantApi.ContractOutput");
var codecForMerchantContractOutputToken = () => buildCodecForObject().property("type", codecForConstString(MerchantContractOutputType.Token)).property("token_family_slug", codecForString()).property("count", codecOptional(codecForNumber())).property("key_index", codecForNumber()).build("TalerMerchantApi.ContractOutputToken");
var codecForMerchantContractOutputTaxReceipt = () => buildCodecForObject().property("type", codecForConstString(MerchantContractOutputType.TaxReceipt)).property("donau_urls", codecForList(codecForString())).property("amount", codecOptional(codecForAmountString())).build("TalerMerchantApi.ContractOutputTaxReceipt");
var codecForMerchantContractTokenFamily = () => buildCodecForObject().property("name", codecForString()).property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("keys", codecForList(codecForTokenIssuePublicKey())).property("details", codecForMerchantContractTokenDetails()).property("critical", codecForBoolean()).build("TalerMerchantApi.ContractTokenFamily");
var codecForTokenIssuePublicKey = () => buildCodecForUnion().discriminateOn("cipher").alternative("RSA", codecForTokenIssueRsaPublicKey()).alternative("CS", codecForTokenIssueCsPublicKey()).build("TalerMerchantApi.TokenIssuePublicKey");
var codecForTokenIssueRsaPublicKey = () => buildCodecForObject().property("cipher", codecForConstString("RSA")).property("rsa_pub", codecForString()).property("signature_validity_start", codecForTimestamp).property("signature_validity_end", codecForTimestamp).build("TalerMerchantApi.TokenIssueRsaPublicKey");
var codecForTokenIssueCsPublicKey = () => buildCodecForObject().property("cipher", codecForConstString("CS")).property("cs_pub", codecForString()).property("signature_validity_start", codecForTimestamp).property("signature_validity_end", codecForTimestamp).build("TalerMerchantApi.TokenIssueRsaPublicKey");
var codecForMerchantContractTokenDetails = () => buildCodecForUnion().discriminateOn("class").alternative(MerchantContractTokenKind.Subscription, codecForMerchantContractSubscriptionTokenDetails()).alternative(MerchantContractTokenKind.Discount, codecForMerchantContractDiscountTokenDetails()).build("TalerMerchantApi.ContractTokenDetails");
var codecForMerchantContractSubscriptionTokenDetails = () => buildCodecForObject().property("class", codecForConstString(MerchantContractTokenKind.Subscription)).property("trusted_domains", codecForList(codecForString())).build("TalerMerchantApi.ContractSubscriptionTokenDetails");
var codecForMerchantContractDiscountTokenDetails = () => buildCodecForObject().property("class", codecForConstString(MerchantContractTokenKind.Discount)).property("expected_domains", codecForList(codecForString())).build("TalerMerchantApi.ContractDiscountTokenDetails");
var KycStatusLongPollingReason;
(function(KycStatusLongPollingReason2) {
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["AUTH_TRANSFER"] = 1] = "AUTH_TRANSFER";
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["AML_INVESTIGATION"] = 2] = "AML_INVESTIGATION";
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["TO_BE_OK"] = 3] = "TO_BE_OK";
})(KycStatusLongPollingReason || (KycStatusLongPollingReason = {}));
var LoginTokenScope;
(function(LoginTokenScope2) {
  LoginTokenScope2["ReadOnly"] = "readonly";
  LoginTokenScope2["All"] = "all";
  LoginTokenScope2["Spa"] = "spa";
  LoginTokenScope2["OrderSimple"] = "order-simple";
  LoginTokenScope2["OrderPos"] = "order-pos";
  LoginTokenScope2["OrderManagement"] = "order-mgmt";
  LoginTokenScope2["OrderFull"] = "order-full";
  LoginTokenScope2["ReadOnly_Refreshable"] = "readonly:refreshable";
  LoginTokenScope2["All_Refreshable"] = "all:refreshable";
  LoginTokenScope2["Spa_Refreshable"] = "spa:refreshable";
  LoginTokenScope2["OrderSimple_Refreshable"] = "order-simple:refreshable";
  LoginTokenScope2["OrderPos_Refreshable"] = "order-pos:refreshable";
  LoginTokenScope2["OrderManagement_Refreshable"] = "order-mgmt:refreshable";
  LoginTokenScope2["OrderFull_Refreshable"] = "order-full:refreshable";
})(LoginTokenScope || (LoginTokenScope = {}));
var MerchantAuthMethod;
(function(MerchantAuthMethod2) {
  MerchantAuthMethod2["TOKEN"] = "token";
})(MerchantAuthMethod || (MerchantAuthMethod = {}));
var MerchantAccountKycStatus;
(function(MerchantAccountKycStatus2) {
  MerchantAccountKycStatus2["NO_EXCHANGE_KEY"] = "no-exchange-keys";
  MerchantAccountKycStatus2["KYC_WIRE_IMPOSSIBLE"] = "kyc-wire-impossible";
  MerchantAccountKycStatus2["KYC_WIRE_REQUIRED"] = "kyc-wire-required";
  MerchantAccountKycStatus2["KYC_REQUIRED"] = "kyc-required";
  MerchantAccountKycStatus2["AWAITING_AML_REVIEW"] = "awaiting-aml-review";
  MerchantAccountKycStatus2["READY"] = "ready";
  MerchantAccountKycStatus2["LOGIC_BUG"] = "logic-bug";
  MerchantAccountKycStatus2["EXCHANGE_INTERNAL_ERROR"] = "exchange-internal-error";
  MerchantAccountKycStatus2["EXCHANGE_GATEWAY_TIMEOUT"] = "exchange-gateway-timeout";
  MerchantAccountKycStatus2["EXCHANGE_UNREACHABLE"] = "exchange-unreachable";
  MerchantAccountKycStatus2["EXCHANGE_STATUS_INVALID"] = "exchange-status-invalid";
})(MerchantAccountKycStatus || (MerchantAccountKycStatus = {}));
var MerchantAccountKycStatusSimplified;
(function(MerchantAccountKycStatusSimplified2) {
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["OK"] = 0] = "OK";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["ACTION_REQUIRED"] = 100] = "ACTION_REQUIRED";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["WARNING"] = 200] = "WARNING";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["ERROR"] = 300] = "ERROR";
})(MerchantAccountKycStatusSimplified || (MerchantAccountKycStatusSimplified = {}));
function getMerchantAccountKycStatusSimplified(st) {
  switch (st) {
    case MerchantAccountKycStatus.AWAITING_AML_REVIEW:
    case MerchantAccountKycStatus.READY:
      return MerchantAccountKycStatusSimplified.OK;
    case MerchantAccountKycStatus.KYC_WIRE_REQUIRED:
    case MerchantAccountKycStatus.KYC_REQUIRED:
      return MerchantAccountKycStatusSimplified.ACTION_REQUIRED;
    case MerchantAccountKycStatus.NO_EXCHANGE_KEY:
    case MerchantAccountKycStatus.EXCHANGE_INTERNAL_ERROR:
    case MerchantAccountKycStatus.EXCHANGE_GATEWAY_TIMEOUT:
    case MerchantAccountKycStatus.EXCHANGE_UNREACHABLE:
      return MerchantAccountKycStatusSimplified.WARNING;
    case MerchantAccountKycStatus.KYC_WIRE_IMPOSSIBLE:
    case MerchantAccountKycStatus.LOGIC_BUG:
    case MerchantAccountKycStatus.EXCHANGE_STATUS_INVALID:
      return MerchantAccountKycStatusSimplified.ERROR;
    default:
      assertUnreachable(st);
  }
}
var TokenFamilyKind;
(function(TokenFamilyKind2) {
  TokenFamilyKind2["Discount"] = "discount";
  TokenFamilyKind2["Subscription"] = "subscription";
})(TokenFamilyKind || (TokenFamilyKind = {}));
var OrderInputType;
(function(OrderInputType2) {
  OrderInputType2["Token"] = "token";
})(OrderInputType || (OrderInputType = {}));
var OrderOutputType;
(function(OrderOutputType2) {
  OrderOutputType2["Token"] = "token";
  OrderOutputType2["TaxReceipt"] = "tax-receipt";
})(OrderOutputType || (OrderOutputType = {}));
var OrderVersion;
(function(OrderVersion2) {
  OrderVersion2[OrderVersion2["V0"] = 0] = "V0";
  OrderVersion2[OrderVersion2["V1"] = 1] = "V1";
})(OrderVersion || (OrderVersion = {}));
var codecForExchangeConfigInfo = () => buildCodecForObject().property("base_url", codecForString()).property("currency", codecForString()).property("master_pub", codecForEddsaPublicKey()).build("TalerMerchantApi.ExchangeConfigInfo");
var codecForTalerMerchantConfigResponse = () => buildCodecForObject().property("name", codecForConstString("taler-merchant")).property("currency", codecForString()).property("version", codecForString()).property("currencies", codecForMap(codecForCurrencySpecificiation())).property("exchanges", codecForList(codecForExchangeConfigInfo())).property("implementation", codecOptional(codecForString())).property("have_self_provisioning", codecOptionalDefault(codecForBoolean(), false)).property("have_donau", codecOptionalDefault(codecForBoolean(), false)).property("mandatory_tan_channels", codecOptionalDefault(codecForList(codecForEither(codecForConstString(TanChannel.SMS), codecForConstString(TanChannel.EMAIL))), [])).property("default_pay_delay", codecOptional(codecForDuration)).property("default_refund_delay", codecOptional(codecForDuration)).property("default_wire_transfer_delay", codecOptional(codecForDuration)).property("payment_target_regex", codecOptionalDefault(codecForString(), "*")).property("payment_target_types", codecOptionalDefault(codecForString(), "*")).build("TalerMerchantApi.VersionResponse");
var codecForClaimResponse = () => buildCodecForObject().property("contract_terms", codecForAny()).property("sig", codecForEddsaSignature()).build("TalerMerchantApi.ClaimResponse");
var codecForPaymentResponse = () => buildCodecForObject().property("pos_confirmation", codecOptional(codecForString())).property("sig", codecForEddsaSignature()).build("TalerMerchantApi.PaymentResponse");
var codecForPaymentDeniedLegallyResponse = () => buildCodecForObject().property("exchange_base_urls", codecForList(codecForString())).build("TalerMerchantApi.PaymentDeniedLegallyResponse");
var codecForStatusPaid = () => buildCodecForObject().property("refund_amount", codecForAmountString()).property("refund_pending", codecForBoolean()).property("refund_taken", codecForAmountString()).property("refunded", codecForBoolean()).property("type", codecForConstString("paid")).build("TalerMerchantApi.StatusPaid");
var codecForStatusGoto = () => buildCodecForObject().property("public_reorder_url", codecForURLString()).property("type", codecForConstString("goto")).build("TalerMerchantApi.StatusGotoResponse");
var codecForStatusStatusUnpaid = () => buildCodecForObject().property("type", codecForConstString("unpaid")).property("already_paid_order_id", codecOptional(codecForString())).property("fulfillment_url", codecOptional(codecForString())).property("taler_pay_uri", codecForTalerUriString()).build("TalerMerchantApi.PaymentResponse");
var codecForPaidRefundStatusResponse = () => buildCodecForObject().property("pos_confirmation", codecOptional(codecForString())).property("refunded", codecForBoolean()).build("TalerMerchantApi.PaidRefundStatusResponse");
var codecForMerchantAbortPayRefundSuccessStatus = () => buildCodecForObject().property("exchange_pub", codecForString()).property("exchange_sig", codecForString()).property("exchange_status", codecForConstNumber(200)).property("type", codecForConstString("success")).build("TalerMerchantApi.MerchantAbortPayRefundSuccessStatus");
var codecForMerchantAbortPayRefundFailureStatus = () => buildCodecForObject().property("exchange_code", codecForNumber()).property("exchange_reply", codecForAny()).property("exchange_status", codecForNumber()).property("type", codecForConstString("failure")).build("TalerMerchantApi.MerchantAbortPayRefundFailureStatus");
var codecForMerchantAbortPayRefundUndepositedStatus = () => buildCodecForObject().property("type", codecForConstString("undeposited")).build("TalerMerchantApi.MerchantAbortPayRefundUndepositedStatus");
var codecForMerchantAbortPayRefundStatus = () => buildCodecForUnion().discriminateOn("type").alternative("success", codecForMerchantAbortPayRefundSuccessStatus()).alternative("failure", codecForMerchantAbortPayRefundFailureStatus()).alternative("undeposited", codecForMerchantAbortPayRefundUndepositedStatus()).build("TalerMerchantApi.MerchantAbortPayRefundStatus");
var codecForAbortResponse = () => buildCodecForObject().property("refunds", codecForList(codecForMerchantAbortPayRefundStatus())).build("TalerMerchantApi.AbortResponse");
var codecForWalletRefundResponse = () => buildCodecForObject().property("merchant_pub", codecForEddsaPublicKey()).property("refund_amount", codecForAmountString()).property("refunds", codecForList(codecForMerchantCoinRefundStatus())).build("TalerMerchantApi.AbortResponse");
var codecForMerchantCoinRefundSuccessStatus = () => buildCodecForObject().property("type", codecForConstString("success")).property("coin_pub", codecForEddsaPublicKey()).property("exchange_status", codecForConstNumber(200)).property("exchange_sig", codecForEddsaSignature()).property("rtransaction_id", codecForNumber()).property("refund_amount", codecForAmountString()).property("exchange_pub", codecForEddsaPublicKey()).property("execution_time", codecForTimestamp).build("TalerMerchantApi.MerchantCoinRefundSuccessStatus");
var codecForMerchantCoinRefundFailureStatus = () => buildCodecForObject().property("type", codecForConstString("failure")).property("coin_pub", codecForEddsaPublicKey()).property("exchange_status", codecForNumber()).property("rtransaction_id", codecForNumber()).property("refund_amount", codecForAmountString()).property("exchange_code", codecOptional(codecForNumber())).property("exchange_reply", codecOptional(codecForAny())).property("execution_time", codecForTimestamp).build("TalerMerchantApi.MerchantCoinRefundFailureStatus");
var codecForMerchantCoinRefundStatus = () => buildCodecForUnion().discriminateOn("type").alternative("success", codecForMerchantCoinRefundSuccessStatus()).alternative("failure", codecForMerchantCoinRefundFailureStatus()).build("TalerMerchantApi.MerchantCoinRefundStatus");
var codecForMerchantAuthMethod = codecForEither(codecForConstString(MerchantAuthMethod.TOKEN));
var codecForQueryInstancesResponse = () => buildCodecForObject().property("name", codecForString()).property("email", codecOptional(codecForString())).property("phone_number", codecOptional(codecForString())).property("website", codecOptional(codecForString())).property("email_validated", codecOptional(codecForBoolean())).property("phone_validated", codecOptional(codecForBoolean())).property("logo", codecOptional(codecForString())).property("merchant_pub", codecForEddsaPublicKey()).property("address", codecForLocation()).property("jurisdiction", codecForLocation()).property("use_stefan", codecForBoolean()).property("default_wire_transfer_delay", codecForDuration).property("default_pay_delay", codecForDuration).property("auth", buildCodecForObject().property("method", codecForMerchantAuthMethod).build("TalerMerchantApi.QueryInstancesResponse.auth")).build("TalerMerchantApi.QueryInstancesResponse");
var codecForAccountKycRedirects = () => buildCodecForObject().property("kyc_data", codecForList(codecForMerchantAccountKycRedirect())).build("TalerMerchantApi.MerchantAccountKycRedirectsResponse");
var codecForMerchantAccountKycStatus = codecForEither(codecForConstString(MerchantAccountKycStatus.AWAITING_AML_REVIEW), codecForConstString(MerchantAccountKycStatus.EXCHANGE_GATEWAY_TIMEOUT), codecForConstString(MerchantAccountKycStatus.EXCHANGE_INTERNAL_ERROR), codecForConstString(MerchantAccountKycStatus.EXCHANGE_STATUS_INVALID), codecForConstString(MerchantAccountKycStatus.EXCHANGE_UNREACHABLE), codecForConstString(MerchantAccountKycStatus.KYC_REQUIRED), codecForConstString(MerchantAccountKycStatus.KYC_WIRE_IMPOSSIBLE), codecForConstString(MerchantAccountKycStatus.KYC_WIRE_REQUIRED), codecForConstString(MerchantAccountKycStatus.LOGIC_BUG), codecForConstString(MerchantAccountKycStatus.NO_EXCHANGE_KEY), codecForConstString(MerchantAccountKycStatus.READY));
var codecForMerchantAccountKycRedirect = () => buildCodecForObject().property("status", codecForMerchantAccountKycStatus).property("h_wire", codecForString()).property("payto_uri", codecForPaytoString()).property("exchange_url", codecForURLString()).property("exchange_http_status", codecForNumber()).property("no_keys", codecForBoolean()).property("auth_conflict", codecForBoolean()).property("exchange_code", codecOptional(codecForNumber())).property("access_token", codecOptional(codecForAccessToken())).property("limits", codecOptional(codecForList(codecForAccountLimit()))).property("payto_kycauths", codecOptional(codecForList(codecForString()))).build("TalerMerchantApi.MerchantAccountKycRedirect");
var codecForTokenScope = codecForEither(codecForConstString(LoginTokenScope.All), codecForConstString(LoginTokenScope.Spa), codecForConstString(LoginTokenScope.OrderFull), codecForConstString(LoginTokenScope.OrderManagement), codecForConstString(LoginTokenScope.OrderPos), codecForConstString(LoginTokenScope.OrderSimple), codecForConstString(LoginTokenScope.ReadOnly), codecForConstString(LoginTokenScope.All_Refreshable), codecForConstString(LoginTokenScope.Spa_Refreshable), codecForConstString(LoginTokenScope.OrderFull_Refreshable), codecForConstString(LoginTokenScope.OrderManagement_Refreshable), codecForConstString(LoginTokenScope.OrderPos_Refreshable), codecForConstString(LoginTokenScope.OrderSimple_Refreshable), codecForConstString(LoginTokenScope.ReadOnly_Refreshable));
var codecForLoginTokenSuccessResponse = () => buildCodecForObject().property("scope", codecForTokenScope).property("access_token", codecForAccessToken()).property("expiration", codecForTimestamp).property("refreshable", codecForBoolean()).build("TalerMerchantApi.LoginTokenSuccessResponse");
var codecForExchangeKycTimeout = () => buildCodecForObject().property("exchange_url", codecForURLString()).property("exchange_code", codecForNumber()).property("exchange_http_status", codecForNumber()).build("TalerMerchantApi.ExchangeKycTimeout");
var codecForAccountAddResponse = () => buildCodecForObject().property("h_wire", codecForString()).property("salt", codecForString()).build("TalerMerchantApi.AccountAddResponse");
var codecForAccountsSummaryResponse = () => buildCodecForObject().property("accounts", codecForList(codecForBankAccountEntry())).build("TalerMerchantApi.AccountsSummaryResponse");
var codecForBankAccountEntry = () => buildCodecForObject().property("payto_uri", codecForPaytoString()).property("h_wire", codecForString()).property("active", codecOptional(codecForBoolean())).build("TalerMerchantApi.BankAccountEntry");
var codecForBankAccountDetail = () => buildCodecForObject().property("payto_uri", codecForPaytoString()).property("h_wire", codecForString()).property("salt", codecForString()).property("credit_facade_url", codecOptional(codecForURLString())).property("active", codecOptional(codecForBoolean())).build("TalerMerchantApi.BankAccountEntry");
var codecForCategoryListResponse = () => buildCodecForObject().property("categories", codecForList(codecForCategoryListEntry())).build("TalerMerchantApi.CategoryListResponse");
var codecForCategoryListEntry = () => buildCodecForObject().property("category_id", codecForNumber()).property("name", codecForString()).property("name_i18n", codecForInternationalizedString()).property("product_count", codecForNumber()).build("TalerMerchantApi.CategoryListEntry");
var codecForCategoryProductList = () => buildCodecForObject().property("name", codecForString()).property("name_i18n", codecForInternationalizedString()).property("products", codecForList(codecForProductSummary())).build("TalerMerchantApi.CategoryProductList");
var codecForProductSummary = () => buildCodecForObject().property("product_id", codecForString()).build("TalerMerchantApi.ProductSummary");
var codecForInventorySummaryResponse = () => buildCodecForObject().property("products", codecForList(codecForInventoryEntry())).build("TalerMerchantApi.InventorySummaryResponse");
var codecForInventoryEntry = () => buildCodecForObject().property("product_id", codecForString()).property("product_serial", codecForNumber()).build("TalerMerchantApi.InventoryEntry");
var codecForMerchantPosProductDetail = () => buildCodecForObject().property("product_serial", codecForNumber()).property("product_id", codecOptional(codecForString())).property("product_name", codecOptional(codecForString())).property("categories", codecForList(codecForNumber())).property("description", codecForString()).property("description_i18n", codecForInternationalizedString()).property("unit", codecForString()).property("price", codecForAmountString()).property("image", codecForString()).property("taxes", codecOptional(codecForList(codecForTax()))).property("total_stock", codecForNumber()).property("minimum_age", codecOptional(codecForNumber())).build("TalerMerchantApi.MerchantPosProductDetail");
var codecForMerchantCategory = () => buildCodecForObject().property("id", codecForNumber()).property("name", codecForString()).property("name_i18n", codecForInternationalizedString()).build("TalerMerchantApi.MerchantCategory");
var codecForFullInventoryDetailsResponse = () => buildCodecForObject().property("categories", codecForList(codecForMerchantCategory())).property("products", codecForList(codecForMerchantPosProductDetail())).build("TalerMerchantApi.FullInventoryDetailsResponse");
var codecForProductDetail = () => buildCodecForObject().property("description", codecForString()).property("description_i18n", codecForInternationalizedString()).property("unit", codecForString()).property("product_name", codecOptional(codecForString())).property("price", codecForAmountString()).property("image", codecForString()).property("categories", codecForList(codecForNumber())).property("taxes", codecOptional(codecForList(codecForTax()))).property("address", codecOptional(codecForLocation())).property("next_restock", codecOptional(codecForTimestamp)).property("total_stock", codecForNumber()).property("total_sold", codecForNumber()).property("total_lost", codecForNumber()).property("minimum_age", codecOptional(codecForNumber())).build("TalerMerchantApi.ProductDetail");
var codecForTax = () => buildCodecForObject().property("name", codecForString()).property("tax", codecForAmountString()).build("TalerMerchantApi.Tax");
var codecForPostOrderResponse = () => buildCodecForObject().property("order_id", codecForString()).property("pay_deadline", codecOptional(codecForTimestamp)).property("token", codecOptional(codecForString())).build("TalerMerchantApi.PostOrderResponse");
var codecForOutOfStockResponse = () => buildCodecForObject().property("product_id", codecForString()).property("available_quantity", codecForNumber()).property("requested_quantity", codecForNumber()).property("restock_expected", codecForTimestamp).build("TalerMerchantApi.OutOfStockResponse");
var codecForOrderHistory = () => buildCodecForObject().property("orders", codecForList(codecForOrderHistoryEntry())).build("TalerMerchantApi.OrderHistory");
var codecForOrderHistoryEntry = () => buildCodecForObject().property("order_id", codecForString()).property("row_id", codecForNumber()).property("timestamp", codecForTimestamp).property("amount", codecForAmountString()).property("summary", codecForString()).property("refundable", codecForBoolean()).property("paid", codecForBoolean()).build("TalerMerchantApi.OrderHistoryEntry");
var codecForMerchant = () => buildCodecForObject().property("name", codecForString()).property("email", codecOptional(codecForString())).property("logo", codecOptional(codecForString())).property("website", codecOptional(codecForString())).property("address", codecOptional(codecForLocation())).property("jurisdiction", codecOptional(codecForLocation())).build("TalerMerchantApi.MerchantInfo");
var codecForExchange = () => buildCodecForObject().property("master_pub", codecForEddsaPublicKey()).property("priority", codecForNumber()).property("url", codecForString()).property("max_contribution", codecOptional(codecForAmountString())).build("TalerMerchantApi.Exchange");
var codecForOrderCommon = () => buildCodecForObject().property("order_id", codecOptional(codecForString())).property("public_reorder_url", codecOptional(codecForString())).property("fulfillment_url", codecOptional(codecForString())).property("fulfillment_message", codecOptional(codecForString())).property("fulfillment_message_i18n", codecOptional(codecForInternationalizedString())).property("merchant_base_url", codecOptional(codecForString())).property("auto_refund", codecOptional(codecForDuration)).property("summary", codecForString()).property("summary_i18n", codecOptional(codecForInternationalizedString())).property("pay_deadline", codecOptional(codecForTimestamp)).property("refund_deadline", codecOptional(codecForTimestamp)).property("wire_transfer_deadline", codecOptional(codecForTimestamp)).property("timestamp", codecOptional(codecForTimestamp)).property("delivery_location", codecOptional(codecForLocation())).property("delivery_date", codecOptional(codecForTimestamp)).property("products", codecOptional(codecForList(codecForProduct()))).property("extra", codecOptional(codecForAny())).build("TalerMerchantApi.Order");
var codecForOrderV0 = () => buildCodecForObject().property("version", codecOptional(codecForConstNumber(OrderVersion.V0))).property("amount", codecForAmountString()).property("max_fee", codecOptional(codecForAmountString())).mixin(codecForOrderCommon()).build("TalerMerchantApi.OrderV0");
var codecForOrderV1 = () => buildCodecForObject().property("version", codecForConstNumber(OrderVersion.V1)).property("choices", codecForList(codecForOrderChoice())).mixin(codecForOrderCommon()).build("TalerMerchantApi.OrderV1");
var codecForOrder = () => buildCodecForUnion().discriminateOn("version").alternative(void 0, codecForOrderV0()).alternative(OrderVersion.V0, codecForOrderV0()).alternative(OrderVersion.V1, codecForOrderV1()).build("TalerMerchantApi.Order");
var codecForOrderChoice = () => buildCodecForObject().property("amount", codecForAmountString()).property("description", codecOptional(codecForString())).property("description_i18n", codecOptional(codecForInternationalizedString())).property("max_fee", codecOptional(codecForAmountString())).property("inputs", codecOptional(codecForList(codecForOrderInput()))).property("outputs", codecOptional(codecForList(codecForOrderOutput()))).build("TalerMerchantApi.OrderChoice");
var codecForOrderInput = () => buildCodecForUnion().discriminateOn("type").alternative(OrderInputType.Token, codecForOrderInputToken()).build("TalerMerchantApi.OrderInput");
var codecForOrderInputToken = () => buildCodecForObject().property("type", codecForConstString(OrderInputType.Token)).property("token_family_slug", codecForString()).property("count", codecOptional(codecForNumber())).build("TalerMerchantApi.OrderInputToken");
var codecForOrderOutput = () => buildCodecForUnion().discriminateOn("type").alternative(OrderOutputType.Token, codecForOrderOutputToken()).alternative(OrderOutputType.TaxReceipt, codecForOrderOutputTaxReceipt()).build("TalerMerchantApi.OrderOutput");
var codecForOrderOutputToken = () => buildCodecForObject().property("type", codecForConstString(OrderOutputType.Token)).property("token_family_slug", codecForString()).property("count", codecOptional(codecForNumber())).property("valid_at", codecOptional(codecForPreciseTimestamp)).build("TalerMerchantApi.OrderOutputToken");
var codecForOrderOutputTaxReceipt = () => buildCodecForObject().property("type", codecForConstString(OrderOutputType.TaxReceipt)).property("amount", codecOptional(codecForAmountString())).property("donau_urls", codecForList(codecForStringURL())).build("TalerMerchantApi.OrderOutputTaxReceipt");
var codecForProduct = () => buildCodecForObject().property("product_id", codecOptional(codecForString())).property("product_name", codecOptional(codecForString())).property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("quantity", codecOptional(codecForNumber())).property("unit", codecOptional(codecForString())).property("price", codecOptional(codecForAmountString())).property("image", codecOptional(codecForString())).property("taxes", codecOptional(codecForList(codecForTax()))).property("delivery_date", codecOptional(codecForTimestamp)).build("TalerMerchantApi.Product");
var codecForCheckPaymentPaidResponse = () => buildCodecForObject().property("order_status", codecForConstString("paid")).property("refunded", codecForBoolean()).property("refund_pending", codecForBoolean()).property("wired", codecForBoolean()).property("deposit_total", codecForAmountString()).property("exchange_code", codecForNumber()).property("exchange_http_status", codecForNumber()).property("refund_amount", codecForAmountString()).property("contract_terms", codecForMerchantContractTerms()).property("wire_reports", codecForList(codecForTransactionWireReport())).property("wire_details", codecForList(codecForTransactionWireTransfer())).property("refund_details", codecForList(codecForRefundDetails())).property("order_status_url", codecForURLString()).build("TalerMerchantApi.CheckPaymentPaidResponse");
var codecForCheckPaymentUnpaidResponse = () => buildCodecForObject().property("order_status", codecForConstString("unpaid")).property("taler_pay_uri", codecForTalerUriString()).property("creation_time", codecForTimestamp).property("pay_deadline", codecOptional(codecForTimestamp)).property("summary", codecForString()).property("total_amount", codecForAmountString()).property("already_paid_order_id", codecOptional(codecForString())).property("already_paid_fulfillment_url", codecOptional(codecForString())).property("order_status_url", codecForString()).build("TalerMerchantApi.CheckPaymentUnpaidResponse");
var codecForCheckPaymentClaimedResponse = () => buildCodecForObject().property("order_status", codecForConstString("claimed")).property("contract_terms", codecForMerchantContractTerms()).property("order_status_url", codecForString()).build("TalerMerchantApi.CheckPaymentClaimedResponse");
var codecForMerchantOrderPrivateStatusResponse = () => buildCodecForUnion().discriminateOn("order_status").alternative("paid", codecForCheckPaymentPaidResponse()).alternative("unpaid", codecForCheckPaymentUnpaidResponse()).alternative("claimed", codecForCheckPaymentClaimedResponse()).build("TalerMerchantApi.MerchantOrderStatusResponse");
var codecForRefundDetails = () => buildCodecForObject().property("reason", codecForString()).property("pending", codecForBoolean()).property("timestamp", codecForTimestamp).property("amount", codecForAmountString()).build("TalerMerchantApi.RefundDetails");
var codecForTransactionWireTransfer = () => buildCodecForObject().property("exchange_url", codecForURLString()).property("wtid", codecForString()).property("execution_time", codecForTimestamp).property("amount", codecForAmountString()).property("confirmed", codecForBoolean()).build("TalerMerchantApi.TransactionWireTransfer");
var codecForTransactionWireReport = () => buildCodecForObject().property("code", codecForNumber()).property("hint", codecForString()).property("exchange_code", codecForNumber()).property("exchange_http_status", codecForNumber()).property("coin_pub", codecForEddsaPublicKey()).build("TalerMerchantApi.TransactionWireReport");
var codecForMerchantRefundResponse = () => buildCodecForObject().property("taler_refund_uri", codecForTalerUriString()).property("h_contract", codecForString()).build("TalerMerchantApi.MerchantRefundResponse");
var codecForTansferList = () => buildCodecForObject().property("transfers", codecForList(codecForTransferDetails())).build("TalerMerchantApi.TransferList");
var codecForTransferDetails = () => buildCodecForObject().property("credit_amount", codecForAmountString()).property("wtid", codecForString()).property("payto_uri", codecForPaytoString()).property("exchange_url", codecForURLString()).property("transfer_serial_id", codecForNumber()).property("execution_time", codecOptional(codecForTimestamp)).property("verified", codecOptional(codecForBoolean())).property("confirmed", codecOptional(codecForBoolean())).build("TalerMerchantApi.TransferDetails");
var codecForOtpDeviceSummaryResponse = () => buildCodecForObject().property("otp_devices", codecForList(codecForOtpDeviceEntry())).build("TalerMerchantApi.OtpDeviceSummaryResponse");
var codecForOtpDeviceEntry = () => buildCodecForObject().property("otp_device_id", codecForString()).property("device_description", codecForString()).build("TalerMerchantApi.OtpDeviceEntry");
var codecForOtpDeviceDetails = () => buildCodecForObject().property("device_description", codecForString()).property("otp_algorithm", codecForNumber()).property("otp_ctr", codecOptional(codecForNumber())).property("otp_timestamp", codecForNumber()).property("otp_code", codecOptional(codecForString())).build("TalerMerchantApi.OtpDeviceDetails");
var codecForTemplateSummaryResponse = () => buildCodecForObject().property("templates", codecForList(codecForTemplateEntry())).build("TalerMerchantApi.TemplateSummaryResponse");
var codecForTemplateEntry = () => buildCodecForObject().property("template_id", codecForString()).property("template_description", codecForString()).build("TalerMerchantApi.TemplateEntry");
var codecForTemplateDetails = () => buildCodecForObject().property("template_description", codecForString()).property("otp_id", codecOptional(codecForString())).property("template_contract", codecForTemplateContractDetails()).property("editable_defaults", codecOptional(codecForTemplateContractDetailsDefaults())).build("TalerMerchantApi.TemplateDetails");
var codecForTemplateContractDetails = () => buildCodecForObject().property("summary", codecOptional(codecForString())).property("currency", codecOptional(codecForString())).property("amount", codecOptional(codecForAmountString())).property("minimum_age", codecForNumber()).property("pay_duration", codecForDuration).build("TalerMerchantApi.TemplateContractDetails");
var codecForTemplateContractDetailsDefaults = () => buildCodecForObject().property("summary", codecOptional(codecForString())).property("currency", codecOptional(codecForString())).property("amount", codecOptional(codecForAmountString())).build("TalerMerchantApi.TemplateContractDetailsDefaults");
var codecForWalletTemplateDetails = () => buildCodecForObject().property("template_contract", codecForTemplateContractDetails()).property("editable_defaults", codecOptional(codecForTemplateContractDetailsDefaults())).build("TalerMerchantApi.WalletTemplateDetails");
var codecForWebhookSummaryResponse = () => buildCodecForObject().property("webhooks", codecForList(codecForWebhookEntry())).build("TalerMerchantApi.WebhookSummaryResponse");
var codecForWebhookEntry = () => buildCodecForObject().property("webhook_id", codecForString()).property("event_type", codecForString()).build("TalerMerchantApi.WebhookEntry");
var codecForWebhookDetails = () => buildCodecForObject().property("event_type", codecForString()).property("url", codecForString()).property("http_method", codecForString()).property("header_template", codecOptional(codecForString())).property("body_template", codecOptional(codecForString())).build("TalerMerchantApi.WebhookDetails");
var codecForTokenFamilyKind = codecForEither(codecForConstString(TokenFamilyKind.Discount), codecForConstString(TokenFamilyKind.Subscription));
var codecForTokenFamilyDetails = () => buildCodecForObject().property("slug", codecForString()).property("name", codecForString()).property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("valid_after", codecForTimestamp).property("valid_before", codecForTimestamp).property("duration", codecForDuration).property("kind", codecForTokenFamilyKind).property("issued", codecForNumber()).property("used", codecForNumber()).build("TalerMerchantApi.TokenFamilyDetails");
var codecForTokenFamiliesList = () => buildCodecForObject().property("token_families", codecForList(codecForTokenFamilySummary())).build("TalerMerchantApi.TokenFamiliesList");
var codecForTokenFamilySummary = () => buildCodecForObject().property("slug", codecForString()).property("name", codecForString()).property("valid_after", codecForTimestamp).property("valid_before", codecForTimestamp).property("kind", codecForTokenFamilyKind).build("TalerMerchantApi.TokenFamilySummary");
var codecForInstancesResponse = () => buildCodecForObject().property("instances", codecForList(codecForInstance())).build("TalerMerchantApi.InstancesResponse");
var codecForInstance = () => buildCodecForObject().property("name", codecForString()).property("website", codecOptional(codecForString())).property("logo", codecOptional(codecForString())).property("id", codecForString()).property("merchant_pub", codecForEddsaPublicKey()).property("payment_targets", codecForList(codecForString())).property("deleted", codecForBoolean()).build("TalerMerchantApi.Instance");
var codecForTemplateEditableDetails = () => buildCodecForObject().property("summary", codecOptional(codecForString())).property("currency", codecOptional(codecForString())).property("amount", codecOptional(codecForAmountString())).build("TemplateEditableDetails");
var codecForMerchantReserveCreateConfirmation = () => buildCodecForObject().property("accounts", codecForList(codecForExchangeWireAccount())).property("reserve_pub", codecForEddsaPublicKey()).build("MerchantReserveCreateConfirmation");
var TanChannel;
(function(TanChannel2) {
  TanChannel2["SMS"] = "sms";
  TanChannel2["EMAIL"] = "email";
})(TanChannel || (TanChannel = {}));
var codecForChallenge = () => buildCodecForObject().property("challenge_id", codecForString()).property("tan_channel", codecForEither(codecForConstString(TanChannel.SMS), codecForConstString(TanChannel.EMAIL))).property("tan_info", codecForString()).build("MFA.Challenge");
var codecForChallengeResponse = () => buildCodecForObject().property("challenges", codecForList(codecForChallenge())).property("combi_and", codecForBoolean()).build("MFA.ChallengeResponse");
var codecForChallengeRequestResponse = () => buildCodecForObject().property("solve_expiration", codecOptional(codecForTimestamp)).property("earliest_retransmission", codecOptional(codecForTimestamp)).build("MFA.ChallengeRequestResponse");

// ../taler-util/lib/contract-terms.js
var logger5 = new Logger("contractTerms.ts");
var ContractTermsUtil;
(function(ContractTermsUtil2) {
  function forgetAllImpl(anyJson, path, pred) {
    const dup = JSON.parse(JSON.stringify(anyJson));
    if (Array.isArray(dup)) {
      for (let i5 = 0; i5 < dup.length; i5++) {
        dup[i5] = forgetAllImpl(dup[i5], [...path, `${i5}`], pred);
      }
    } else if (typeof dup === "object" && dup != null) {
      if (typeof dup.$forgettable === "object") {
        for (const x6 of Object.keys(dup.$forgettable)) {
          if (!pred([...path, x6])) {
            continue;
          }
          if (!dup.$forgotten) {
            dup.$forgotten = {};
          }
          if (!dup.$forgotten[x6]) {
            const membValCanon = stringToBytes(canonicalJson(scrub(dup[x6])) + "\0");
            const membSalt = stringToBytes(dup.$forgettable[x6] + "\0");
            const h5 = kdf(64, membValCanon, membSalt, new Uint8Array([]));
            dup.$forgotten[x6] = encodeCrock(h5);
          }
          delete dup[x6];
          delete dup.$forgettable[x6];
        }
        if (Object.keys(dup.$forgettable).length === 0) {
          delete dup.$forgettable;
        }
      }
      for (const x6 of Object.keys(dup)) {
        if (x6.startsWith("$")) {
          continue;
        }
        dup[x6] = forgetAllImpl(dup[x6], [...path, x6], pred);
      }
    }
    return dup;
  }
  ContractTermsUtil2.forgetAllImpl = forgetAllImpl;
  function scrub(anyJson) {
    return forgetAllImpl(anyJson, [], () => true);
  }
  ContractTermsUtil2.scrub = scrub;
  function forgetAll(anyJson, pred) {
    return forgetAllImpl(anyJson, [], pred);
  }
  ContractTermsUtil2.forgetAll = forgetAll;
  function saltForgettable(anyJson) {
    const dup = JSON.parse(JSON.stringify(anyJson));
    if (Array.isArray(dup)) {
      for (let i5 = 0; i5 < dup.length; i5++) {
        dup[i5] = saltForgettable(dup[i5]);
      }
    } else if (typeof dup === "object" && dup !== null) {
      if (typeof dup.$forgettable === "object") {
        for (const k6 of Object.keys(dup.$forgettable)) {
          if (dup.$forgettable[k6] === true) {
            dup.$forgettable[k6] = encodeCrock(getRandomBytes(32));
          }
        }
      }
      for (const x6 of Object.keys(dup)) {
        if (x6.startsWith("$")) {
          continue;
        }
        dup[x6] = saltForgettable(dup[x6]);
      }
    }
    return dup;
  }
  ContractTermsUtil2.saltForgettable = saltForgettable;
  const nameRegex = /^[0-9A-Za-z_]+$/;
  function validateForgettable(anyJson) {
    if (anyJson === void 0) {
      return true;
    }
    if (typeof anyJson === "string") {
      return true;
    }
    if (typeof anyJson === "number") {
      return Number.isInteger(anyJson) && anyJson >= Number.MIN_SAFE_INTEGER && anyJson <= Number.MAX_SAFE_INTEGER;
    }
    if (typeof anyJson === "boolean") {
      return true;
    }
    if (anyJson === null) {
      return true;
    }
    if (Array.isArray(anyJson)) {
      return anyJson.every((x6) => validateForgettable(x6));
    }
    if (typeof anyJson === "object") {
      for (const k6 of Object.keys(anyJson)) {
        if (k6.match(nameRegex)) {
          if (validateForgettable(anyJson[k6])) {
            continue;
          } else {
            return false;
          }
        }
        if (k6 === "$forgettable") {
          const fga = anyJson.$forgettable;
          if (!fga || typeof fga !== "object") {
            return false;
          }
          for (const fk of Object.keys(fga)) {
            if (!fk.match(nameRegex)) {
              return false;
            }
            if (!(fk in anyJson)) {
              return false;
            }
            const fv = anyJson.$forgettable[fk];
            if (typeof fv !== "string") {
              return false;
            }
          }
        } else if (k6 === "$forgotten") {
          const fgo = anyJson.$forgotten;
          if (!fgo || typeof fgo !== "object") {
            return false;
          }
          for (const fk of Object.keys(fgo)) {
            if (!fk.match(nameRegex)) {
              return false;
            }
            if (fk in anyJson) {
              return false;
            }
            const fv = anyJson.$forgotten[fk];
            if (typeof fv !== "string") {
              return false;
            }
            try {
              const decFv = decodeCrock(fv);
              if (decFv.length != 64) {
                return false;
              }
            } catch (e5) {
              return false;
            }
            if (anyJson.$forgettable?.[k6] !== void 0) {
              return false;
            }
          }
        } else {
          return false;
        }
      }
      return true;
    }
    return false;
  }
  ContractTermsUtil2.validateForgettable = validateForgettable;
  function validateNothingForgotten(contractTerms) {
    throw Error("not implemented yet");
  }
  ContractTermsUtil2.validateNothingForgotten = validateNothingForgotten;
  function validateParsed(contractTerms) {
    if (contractTerms.version === MerchantContractVersion.V1) {
      const regex = new RegExp("^(\\*\\.)?([\\w\\d]+\\.)+[\\w\\d]+$");
      for (const slug in contractTerms.token_families) {
        const family = contractTerms.token_families[slug];
        var domains = [];
        switch (family.details.class) {
          case MerchantContractTokenKind.Subscription:
            domains.push(...family.details.trusted_domains);
            break;
          case MerchantContractTokenKind.Discount:
            domains.push(...family.details.expected_domains);
            break;
          default:
            assertUnreachable(family.details);
        }
        for (const domain in domains) {
          if (domain !== "*" && !regex.test(domain)) {
            return false;
          }
        }
      }
    }
    return true;
  }
  ContractTermsUtil2.validateParsed = validateParsed;
  function hashContractTerms(contractTerms) {
    const cleaned = scrub(contractTerms);
    const canon = canonicalJson(cleaned) + "\0";
    const bytes = stringToBytes(canon);
    return encodeCrock(hash2(bytes));
  }
  ContractTermsUtil2.hashContractTerms = hashContractTerms;
  function extractAmounts(contractTerms, choiceIndex) {
    let amountRaw;
    let maxFee;
    switch (contractTerms.version) {
      case void 0:
      case MerchantContractVersion.V0:
        amountRaw = contractTerms.amount;
        maxFee = contractTerms.max_fee;
        break;
      case MerchantContractVersion.V1:
        if (choiceIndex === void 0) {
          logger5.trace("choice index not specified for contract v1");
          return {
            available: false,
            amountRaw: void 0,
            maxFee: void 0
          };
        }
        if (contractTerms.choices[choiceIndex] === void 0)
          throw Error(`invalid choice index ${choiceIndex}`);
        amountRaw = contractTerms.choices[choiceIndex].amount;
        maxFee = contractTerms.choices[choiceIndex].max_fee;
        break;
      default:
        assertUnreachable(contractTerms);
    }
    return {
      available: true,
      amountRaw,
      maxFee
    };
  }
  ContractTermsUtil2.extractAmounts = extractAmounts;
  function getV0CompatChoiceIndex(terms) {
    let firstGood = void 0;
    for (let i5 = 0; i5 < terms.choices.length; i5++) {
      if (terms.choices[i5].inputs.length == 0) {
        firstGood = i5;
        break;
      }
    }
    if (firstGood != null) {
      return firstGood;
    }
    return void 0;
  }
  ContractTermsUtil2.getV0CompatChoiceIndex = getV0CompatChoiceIndex;
  function downgradeContractTerms(terms) {
    if (terms.version == MerchantContractVersion.V0) {
      return terms;
    }
    if (terms.version !== MerchantContractVersion.V1) {
      return void 0;
    }
    const firstGood = getV0CompatChoiceIndex(terms);
    if (firstGood == null) {
      return void 0;
    }
    return {
      amount: terms.choices[firstGood].amount,
      exchanges: terms.exchanges,
      h_wire: terms.h_wire,
      max_fee: terms.choices[firstGood].max_fee,
      merchant: terms.merchant,
      merchant_base_url: terms.merchant_base_url,
      merchant_pub: terms.merchant_pub,
      nonce: terms.nonce,
      order_id: terms.order_id,
      pay_deadline: terms.pay_deadline,
      refund_deadline: terms.refund_deadline,
      summary: terms.summary,
      timestamp: terms.timestamp,
      wire_method: terms.wire_method,
      wire_transfer_deadline: terms.wire_transfer_deadline,
      auto_refund: terms.auto_refund,
      delivery_date: terms.delivery_date,
      delivery_location: terms.delivery_location,
      extra: terms.extra,
      fulfillment_message: terms.fulfillment_message,
      fulfillment_message_i18n: terms.fulfillment_message_i18n,
      fulfillment_url: terms.fulfillment_url,
      minimum_age: terms.minimum_age,
      products: terms.products,
      public_reorder_url: terms.public_reorder_url,
      summary_i18n: terms.summary_i18n,
      version: MerchantContractVersion.V0
    };
  }
  ContractTermsUtil2.downgradeContractTerms = downgradeContractTerms;
})(ContractTermsUtil || (ContractTermsUtil = {}));

// ../taler-util/lib/fnutils.js
var fnutil;
(function(fnutil2) {
  function all(arr, f3) {
    for (const x6 of arr) {
      if (!f3(x6)) {
        return false;
      }
    }
    return true;
  }
  fnutil2.all = all;
  function any(arr, f3) {
    for (const x6 of arr) {
      if (f3(x6)) {
        return true;
      }
    }
    return false;
  }
  fnutil2.any = any;
})(fnutil || (fnutil = {}));

// ../taler-util/lib/http-status-codes.js
var HttpStatusCode;
(function(HttpStatusCode3) {
  HttpStatusCode3[HttpStatusCode3["Continue"] = 100] = "Continue";
  HttpStatusCode3[HttpStatusCode3["SwitchingProtocols"] = 101] = "SwitchingProtocols";
  HttpStatusCode3[HttpStatusCode3["Processing"] = 102] = "Processing";
  HttpStatusCode3[HttpStatusCode3["Ok"] = 200] = "Ok";
  HttpStatusCode3[HttpStatusCode3["Created"] = 201] = "Created";
  HttpStatusCode3[HttpStatusCode3["Accepted"] = 202] = "Accepted";
  HttpStatusCode3[HttpStatusCode3["NonAuthoritativeInformation"] = 203] = "NonAuthoritativeInformation";
  HttpStatusCode3[HttpStatusCode3["NoContent"] = 204] = "NoContent";
  HttpStatusCode3[HttpStatusCode3["ResetContent"] = 205] = "ResetContent";
  HttpStatusCode3[HttpStatusCode3["PartialContent"] = 206] = "PartialContent";
  HttpStatusCode3[HttpStatusCode3["MultiStatus"] = 207] = "MultiStatus";
  HttpStatusCode3[HttpStatusCode3["AlreadyReported"] = 208] = "AlreadyReported";
  HttpStatusCode3[HttpStatusCode3["ImUsed"] = 226] = "ImUsed";
  HttpStatusCode3[HttpStatusCode3["MultipleChoices"] = 300] = "MultipleChoices";
  HttpStatusCode3[HttpStatusCode3["MovedPermanently"] = 301] = "MovedPermanently";
  HttpStatusCode3[HttpStatusCode3["Found"] = 302] = "Found";
  HttpStatusCode3[HttpStatusCode3["SeeOther"] = 303] = "SeeOther";
  HttpStatusCode3[HttpStatusCode3["NotModified"] = 304] = "NotModified";
  HttpStatusCode3[HttpStatusCode3["UseProxy"] = 305] = "UseProxy";
  HttpStatusCode3[HttpStatusCode3["SwitchProxy"] = 306] = "SwitchProxy";
  HttpStatusCode3[HttpStatusCode3["TemporaryRedirect"] = 307] = "TemporaryRedirect";
  HttpStatusCode3[HttpStatusCode3["PermanentRedirect"] = 308] = "PermanentRedirect";
  HttpStatusCode3[HttpStatusCode3["BadRequest"] = 400] = "BadRequest";
  HttpStatusCode3[HttpStatusCode3["Unauthorized"] = 401] = "Unauthorized";
  HttpStatusCode3[HttpStatusCode3["PaymentRequired"] = 402] = "PaymentRequired";
  HttpStatusCode3[HttpStatusCode3["Forbidden"] = 403] = "Forbidden";
  HttpStatusCode3[HttpStatusCode3["NotFound"] = 404] = "NotFound";
  HttpStatusCode3[HttpStatusCode3["MethodNotAllowed"] = 405] = "MethodNotAllowed";
  HttpStatusCode3[HttpStatusCode3["NotAcceptable"] = 406] = "NotAcceptable";
  HttpStatusCode3[HttpStatusCode3["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
  HttpStatusCode3[HttpStatusCode3["RequestTimeout"] = 408] = "RequestTimeout";
  HttpStatusCode3[HttpStatusCode3["Conflict"] = 409] = "Conflict";
  HttpStatusCode3[HttpStatusCode3["Gone"] = 410] = "Gone";
  HttpStatusCode3[HttpStatusCode3["LengthRequired"] = 411] = "LengthRequired";
  HttpStatusCode3[HttpStatusCode3["PreconditionFailed"] = 412] = "PreconditionFailed";
  HttpStatusCode3[HttpStatusCode3["PayloadTooLarge"] = 413] = "PayloadTooLarge";
  HttpStatusCode3[HttpStatusCode3["UriTooLong"] = 414] = "UriTooLong";
  HttpStatusCode3[HttpStatusCode3["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
  HttpStatusCode3[HttpStatusCode3["RangeNotSatisfiable"] = 416] = "RangeNotSatisfiable";
  HttpStatusCode3[HttpStatusCode3["ExpectationFailed"] = 417] = "ExpectationFailed";
  HttpStatusCode3[HttpStatusCode3["IAmATeapot"] = 418] = "IAmATeapot";
  HttpStatusCode3[HttpStatusCode3["MisdirectedRequest"] = 421] = "MisdirectedRequest";
  HttpStatusCode3[HttpStatusCode3["UnprocessableEntity"] = 422] = "UnprocessableEntity";
  HttpStatusCode3[HttpStatusCode3["Locked"] = 423] = "Locked";
  HttpStatusCode3[HttpStatusCode3["FailedDependency"] = 424] = "FailedDependency";
  HttpStatusCode3[HttpStatusCode3["TooEarly"] = 425] = "TooEarly";
  HttpStatusCode3[HttpStatusCode3["UpgradeRequired"] = 426] = "UpgradeRequired";
  HttpStatusCode3[HttpStatusCode3["PreconditionRequired"] = 428] = "PreconditionRequired";
  HttpStatusCode3[HttpStatusCode3["TooManyRequests"] = 429] = "TooManyRequests";
  HttpStatusCode3[HttpStatusCode3["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
  HttpStatusCode3[HttpStatusCode3["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
  HttpStatusCode3[HttpStatusCode3["InternalServerError"] = 500] = "InternalServerError";
  HttpStatusCode3[HttpStatusCode3["NotImplemented"] = 501] = "NotImplemented";
  HttpStatusCode3[HttpStatusCode3["BadGateway"] = 502] = "BadGateway";
  HttpStatusCode3[HttpStatusCode3["ServiceUnavailable"] = 503] = "ServiceUnavailable";
  HttpStatusCode3[HttpStatusCode3["GatewayTimeout"] = 504] = "GatewayTimeout";
  HttpStatusCode3[HttpStatusCode3["HttpVersionNotSupported"] = 505] = "HttpVersionNotSupported";
  HttpStatusCode3[HttpStatusCode3["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
  HttpStatusCode3[HttpStatusCode3["InsufficientStorage"] = 507] = "InsufficientStorage";
  HttpStatusCode3[HttpStatusCode3["LoopDetected"] = 508] = "LoopDetected";
  HttpStatusCode3[HttpStatusCode3["NotExtended"] = 510] = "NotExtended";
  HttpStatusCode3[HttpStatusCode3["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(HttpStatusCode || (HttpStatusCode = {}));

// ../taler-util/lib/types-taler-bank-conversion.js
var codecForCashoutConversionResponse = () => buildCodecForObject().property("amount_credit", codecForAmountString()).property("amount_debit", codecForAmountString()).build("TalerCorebankApi.CashoutConversionResponse");
var codecForCashinConversionResponse = () => buildCodecForObject().property("amount_credit", codecForAmountString()).property("amount_debit", codecForAmountString()).build("TalerCorebankApi.CashinConversionResponse");
var codecForConversionRate = () => buildCodecForObject().property("cashin_fee", codecForAmountString()).property("cashin_min_amount", codecForAmountString()).property("cashin_ratio", codecForDecimalNumber()).property("cashin_rounding_mode", codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest"))).property("cashin_tiny_amount", codecForAmountString()).property("cashout_fee", codecForAmountString()).property("cashout_min_amount", codecForAmountString()).property("cashout_ratio", codecForDecimalNumber()).property("cashout_rounding_mode", codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest"))).property("cashout_tiny_amount", codecForAmountString()).build("ConversionBankConfig.ConversionInfo");
var codecForConversionBankConfig = () => buildCodecForObject().property("name", codecForConstString("taler-conversion-info")).property("version", codecForString()).property("regional_currency", codecForString()).property("regional_currency_specification", codecForCurrencySpecificiation()).property("fiat_currency", codecForString()).property("fiat_currency_specification", codecForCurrencySpecificiation()).property("conversion_rate", codecForConversionRate()).build("ConversionBankConfig.IntegrationConfig");

// ../taler-util/lib/types-taler-wallet.js
var ScopeType;
(function(ScopeType2) {
  ScopeType2["Global"] = "global";
  ScopeType2["Exchange"] = "exchange";
  ScopeType2["Auditor"] = "auditor";
})(ScopeType || (ScopeType = {}));
var TransactionAmountMode;
(function(TransactionAmountMode2) {
  TransactionAmountMode2["Effective"] = "effective";
  TransactionAmountMode2["Raw"] = "raw";
})(TransactionAmountMode || (TransactionAmountMode = {}));
var codecForConvertAmountRequest = buildCodecForObject().property("amount", codecForAmountString()).property("depositPaytoUri", codecForPaytoString()).property("type", codecForEither(codecForConstString(TransactionAmountMode.Raw), codecForConstString(TransactionAmountMode.Effective))).build("ConvertAmountRequest");
var BalanceFlag;
(function(BalanceFlag2) {
  BalanceFlag2["IncomingKyc"] = "incoming-kyc";
  BalanceFlag2["IncomingAml"] = "incoming-aml";
  BalanceFlag2["IncomingConfirmation"] = "incoming-confirmation";
  BalanceFlag2["OutgoingKyc"] = "outgoing-kyc";
})(BalanceFlag || (BalanceFlag = {}));
var CoinStatus;
(function(CoinStatus2) {
  CoinStatus2["Fresh"] = "fresh";
  CoinStatus2["DenomLoss"] = "denom-loss";
  CoinStatus2["FreshSuspended"] = "fresh-suspended";
  CoinStatus2["Dormant"] = "dormant";
})(CoinStatus || (CoinStatus = {}));
var ConfirmPayResultType;
(function(ConfirmPayResultType2) {
  ConfirmPayResultType2["Done"] = "done";
  ConfirmPayResultType2["Pending"] = "pending";
})(ConfirmPayResultType || (ConfirmPayResultType = {}));
var codecForTalerErrorDetail = () => buildCodecForObject().property("code", codecForNumber()).property("when", codecOptional(codecForAbsoluteTime)).property("hint", codecOptional(codecForString())).build("TalerErrorDetail");
var PreparePayResultType;
(function(PreparePayResultType2) {
  PreparePayResultType2["PaymentPossible"] = "payment-possible";
  PreparePayResultType2["InsufficientBalance"] = "insufficient-balance";
  PreparePayResultType2["AlreadyConfirmed"] = "already-confirmed";
  PreparePayResultType2["ChoiceSelection"] = "choice-selection";
})(PreparePayResultType || (PreparePayResultType = {}));
var InsufficientBalanceHint;
(function(InsufficientBalanceHint2) {
  InsufficientBalanceHint2["MerchantAcceptInsufficient"] = "merchant-accept-insufficient";
  InsufficientBalanceHint2["MerchantDepositInsufficient"] = "merchant-deposit-insufficient";
  InsufficientBalanceHint2["AgeRestricted"] = "age-restricted";
  InsufficientBalanceHint2["WalletBalanceMaterialInsufficient"] = "wallet-balance-material-insufficient";
  InsufficientBalanceHint2["WalletBalanceAvailableInsufficient"] = "wallet-balance-available-insufficient";
  InsufficientBalanceHint2["ExchangeMissingGlobalFees"] = "exchange-missing-global-fees";
  InsufficientBalanceHint2["FeesNotCovered"] = "fees-not-covered";
})(InsufficientBalanceHint || (InsufficientBalanceHint = {}));
var TokenAvailabilityHint;
(function(TokenAvailabilityHint2) {
  TokenAvailabilityHint2["WalletTokensAvailableInsufficient"] = "wallet-tokens-available-insufficient";
  TokenAvailabilityHint2["MerchantUnexpected"] = "merchant-unexpected";
  TokenAvailabilityHint2["MerchantUntrusted"] = "merchant-untrusted";
})(TokenAvailabilityHint || (TokenAvailabilityHint = {}));
var RefreshReason;
(function(RefreshReason2) {
  RefreshReason2["Manual"] = "manual";
  RefreshReason2["PayMerchant"] = "pay-merchant";
  RefreshReason2["PayDeposit"] = "pay-deposit";
  RefreshReason2["PayPeerPush"] = "pay-peer-push";
  RefreshReason2["PayPeerPull"] = "pay-peer-pull";
  RefreshReason2["Refund"] = "refund";
  RefreshReason2["AbortPay"] = "abort-pay";
  RefreshReason2["AbortDeposit"] = "abort-deposit";
  RefreshReason2["AbortPeerPushDebit"] = "abort-peer-push-debit";
  RefreshReason2["AbortPeerPullDebit"] = "abort-peer-pull-debit";
  RefreshReason2["Recoup"] = "recoup";
  RefreshReason2["BackupRestored"] = "backup-restored";
  RefreshReason2["Scheduled"] = "scheduled";
})(RefreshReason || (RefreshReason = {}));
var ExchangeTosStatus;
(function(ExchangeTosStatus2) {
  ExchangeTosStatus2["Pending"] = "pending";
  ExchangeTosStatus2["Proposed"] = "proposed";
  ExchangeTosStatus2["Accepted"] = "accepted";
  ExchangeTosStatus2["MissingTos"] = "missing-tos";
})(ExchangeTosStatus || (ExchangeTosStatus = {}));
var ExchangeEntryStatus;
(function(ExchangeEntryStatus2) {
  ExchangeEntryStatus2["Preset"] = "preset";
  ExchangeEntryStatus2["Ephemeral"] = "ephemeral";
  ExchangeEntryStatus2["Used"] = "used";
})(ExchangeEntryStatus || (ExchangeEntryStatus = {}));
var ExchangeUpdateStatus;
(function(ExchangeUpdateStatus2) {
  ExchangeUpdateStatus2["Initial"] = "initial";
  ExchangeUpdateStatus2["InitialUpdate"] = "initial-update";
  ExchangeUpdateStatus2["Suspended"] = "suspended";
  ExchangeUpdateStatus2["UnavailableUpdate"] = "unavailable-update";
  ExchangeUpdateStatus2["Ready"] = "ready";
  ExchangeUpdateStatus2["ReadyUpdate"] = "ready-update";
  ExchangeUpdateStatus2["OutdatedUpdate"] = "outdated-update";
})(ExchangeUpdateStatus || (ExchangeUpdateStatus = {}));
var ExchangeWalletKycStatus;
(function(ExchangeWalletKycStatus2) {
  ExchangeWalletKycStatus2["Done"] = "done";
  ExchangeWalletKycStatus2["LegiInit"] = "legi-init";
  ExchangeWalletKycStatus2["Legi"] = "legi";
})(ExchangeWalletKycStatus || (ExchangeWalletKycStatus = {}));
var ChoiceSelectionDetailType;
(function(ChoiceSelectionDetailType2) {
  ChoiceSelectionDetailType2["PaymentPossible"] = "payment-possible";
  ChoiceSelectionDetailType2["InsufficientBalance"] = "insufficient-balance";
})(ChoiceSelectionDetailType || (ChoiceSelectionDetailType = {}));
var RecoveryMergeStrategy;
(function(RecoveryMergeStrategy2) {
  RecoveryMergeStrategy2["Ours"] = "ours";
  RecoveryMergeStrategy2["Theirs"] = "theirs";
})(RecoveryMergeStrategy || (RecoveryMergeStrategy = {}));
var AttentionPriority;
(function(AttentionPriority2) {
  AttentionPriority2["High"] = "high";
  AttentionPriority2["Medium"] = "medium";
  AttentionPriority2["Low"] = "low";
})(AttentionPriority || (AttentionPriority = {}));
var AttentionType;
(function(AttentionType2) {
  AttentionType2["KycWithdrawal"] = "kyc-withdrawal";
  AttentionType2["BackupUnpaid"] = "backup-unpaid";
  AttentionType2["BackupExpiresSoon"] = "backup-expires-soon";
  AttentionType2["MerchantRefund"] = "merchant-refund";
  AttentionType2["ExchangeTosChanged"] = "exchange-tos-changed";
  AttentionType2["ExchangeKeyExpired"] = "exchange-key-expired";
  AttentionType2["ExchangeKeyExpiresSoon"] = "exchange-key-expires-soon";
  AttentionType2["ExchangeDenominationsExpired"] = "exchange-denominations-expired";
  AttentionType2["ExchangeDenominationsExpiresSoon"] = "exchange-denominations-expires-soon";
  AttentionType2["AuditorTosChanged"] = "auditor-tos-changed";
  AttentionType2["AuditorKeyExpires"] = "auditor-key-expires";
  AttentionType2["AuditorDenominationsExpires"] = "auditor-denominations-expires";
  AttentionType2["PullPaymentPaid"] = "pull-payment-paid";
  AttentionType2["PushPaymentReceived"] = "push-payment-withdrawn";
})(AttentionType || (AttentionType = {}));
var UserAttentionPriority = {
  "kyc-withdrawal": AttentionPriority.Medium,
  "backup-unpaid": AttentionPriority.High,
  "backup-expires-soon": AttentionPriority.Medium,
  "merchant-refund": AttentionPriority.Medium,
  "exchange-tos-changed": AttentionPriority.Medium,
  "exchange-key-expired": AttentionPriority.High,
  "exchange-key-expires-soon": AttentionPriority.Medium,
  "exchange-denominations-expired": AttentionPriority.High,
  "exchange-denominations-expires-soon": AttentionPriority.Medium,
  "auditor-tos-changed": AttentionPriority.Medium,
  "auditor-key-expires": AttentionPriority.Medium,
  "auditor-denominations-expires": AttentionPriority.Medium,
  "pull-payment-paid": AttentionPriority.High,
  "push-payment-withdrawn": AttentionPriority.High
};
var ProviderPaymentType;
(function(ProviderPaymentType2) {
  ProviderPaymentType2["Unpaid"] = "unpaid";
  ProviderPaymentType2["Pending"] = "pending";
  ProviderPaymentType2["InsufficientBalance"] = "insufficient-balance";
  ProviderPaymentType2["Paid"] = "paid";
  ProviderPaymentType2["TermsChanged"] = "terms-changed";
})(ProviderPaymentType || (ProviderPaymentType = {}));
var codecForEmptyObject = () => buildCodecForObject().build("EmptyObject");

// ../taler-util/lib/http-client/utils.js
function makeBasicAuthHeader2(username, password) {
  const auth = `${username}:${password}`;
  const authEncoded = base64FromArrayBuffer(stringToBytes(auth));
  return `Basic ${authEncoded}`;
}
function makeBearerTokenAuthHeader(token) {
  return `Bearer ${token}`;
}
function createAuthorizationHeader(auth) {
  if (!auth)
    return void 0;
  switch (auth.type) {
    case "basic": {
      return makeBasicAuthHeader2(auth.username, auth.password);
    }
    case "bearer": {
      return makeBearerTokenAuthHeader(auth.token);
    }
  }
  return void 0;
}
function addPaginationParams(url, pagination) {
  if (!pagination)
    return;
  if (pagination.offset) {
    url.searchParams.set("offset", pagination.offset);
  }
  const order = !pagination || pagination.order === "asc" ? 1 : -1;
  const limit = !pagination || !pagination.limit || pagination.limit === 0 ? 5 : Math.abs(pagination.limit);
  url.searchParams.set("limit", String(order * limit));
}
function addLongPollingParam(url, param) {
  if (!param)
    return;
  if (param.timeoutMs) {
    url.searchParams.set("timeout_ms", String(param.timeoutMs));
  }
}
var nullEvictor = {
  notifySuccess: () => Promise.resolve()
};

// ../taler-util/lib/http-client/bank-conversion.js
var TalerBankConversionCacheEviction;
(function(TalerBankConversionCacheEviction2) {
  TalerBankConversionCacheEviction2[TalerBankConversionCacheEviction2["UPDATE_RATE"] = 0] = "UPDATE_RATE";
})(TalerBankConversionCacheEviction || (TalerBankConversionCacheEviction = {}));
var TalerBankConversionHttpClient = class _TalerBankConversionHttpClient {
  constructor(baseUrl, httpClient, cacheEvictor) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
    this.cacheEvictor = cacheEvictor ?? nullEvictor;
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#get--config
   *
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-conversion-info", _TalerBankConversionHttpClient.PROTOCOL_VERSION, resp, codecForConversionBankConfig());
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#get--rate
   *
   */
  async getRate(auth) {
    const url = new URL(`rate`, this.baseUrl);
    const headers = {};
    if (auth) {
      headers.Authorization = makeBearerTokenAuthHeader(auth);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForConversionRate());
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#get--cashin-rate
   *
   */
  async getCashinRate(auth, conversion) {
    const url = new URL(`cashin-rate`, this.baseUrl);
    if (conversion.debit) {
      url.searchParams.set("amount_debit", Amounts.stringify(conversion.debit));
    }
    if (conversion.credit) {
      url.searchParams.set("amount_credit", Amounts.stringify(conversion.credit));
    }
    const headers = {};
    if (auth) {
      headers.Authorization = makeBearerTokenAuthHeader(auth);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCashinConversionResponse());
      case HttpStatusCode.BadRequest: {
        const body = await resp.json();
        const details = codecForTalerErrorDetail().decode(body);
        switch (details.code) {
          case TalerErrorCode.GENERIC_PARAMETER_MISSING:
            return opKnownHttpFailure(resp.status, resp);
          case TalerErrorCode.GENERIC_PARAMETER_MALFORMED:
            return opKnownHttpFailure(resp.status, resp);
          case TalerErrorCode.GENERIC_CURRENCY_MISMATCH:
            return opKnownHttpFailure(resp.status, resp);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#get--cashout-rate
   *
   */
  async getCashoutRate(auth, conversion) {
    const url = new URL(`cashout-rate`, this.baseUrl);
    if (conversion.debit) {
      url.searchParams.set("amount_debit", Amounts.stringify(conversion.debit));
    }
    if (conversion.credit) {
      url.searchParams.set("amount_credit", Amounts.stringify(conversion.credit));
    }
    const headers = {};
    if (auth) {
      headers.Authorization = makeBearerTokenAuthHeader(auth);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCashoutConversionResponse());
      case HttpStatusCode.BadRequest: {
        const body = await resp.json();
        const details = codecForTalerErrorDetail().decode(body);
        switch (details.code) {
          case TalerErrorCode.GENERIC_PARAMETER_MISSING:
            return opKnownHttpFailure(resp.status, resp);
          case TalerErrorCode.GENERIC_PARAMETER_MALFORMED:
            return opKnownHttpFailure(resp.status, resp);
          case TalerErrorCode.GENERIC_CURRENCY_MISMATCH:
            return opKnownHttpFailure(resp.status, resp);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#post--conversion-rate
   *
   */
  async updateConversionRate(auth, body) {
    const url = new URL(`conversion-rate`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      },
      body
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerBankConversionCacheEviction.UPDATE_RATE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerBankConversionHttpClient.PROTOCOL_VERSION = "0:0:0";

// ../taler-util/lib/result.js
var Result = {
  of(value) {
    return { tag: "ok", value };
  },
  error(error2) {
    return { tag: "error", error: error2 };
  }
};

// ../taler-util/lib/taleruri.js
function codecForTalerUriString() {
  return {
    decode(x6, c5) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c5)} but got ${typeof x6}`);
      }
      if (parseTalerUri(x6) === void 0) {
        throw new DecodingError(`invalid taler URI at ${renderContext(c5)} but got "${x6}"`);
      }
      return x6;
    }
  };
}
var TALER_PREFIX = "taler://";
var TALER_HTTP_PREFIX = "taler+http://";
var TalerUriParseError;
(function(TalerUriParseError2) {
  TalerUriParseError2[TalerUriParseError2["WRONG_PREFIX"] = 0] = "WRONG_PREFIX";
  TalerUriParseError2[TalerUriParseError2["INCOMPLETE"] = 1] = "INCOMPLETE";
  TalerUriParseError2[TalerUriParseError2["UNSUPPORTED"] = 2] = "UNSUPPORTED";
  TalerUriParseError2[TalerUriParseError2["COMPONENTS_LENGTH"] = 3] = "COMPONENTS_LENGTH";
  TalerUriParseError2[TalerUriParseError2["INVALID_TARGET_PATH"] = 4] = "INVALID_TARGET_PATH";
  TalerUriParseError2[TalerUriParseError2["INVALID_PARAMETER"] = 5] = "INVALID_PARAMETER";
})(TalerUriParseError || (TalerUriParseError = {}));
var TalerUris;
(function(TalerUris2) {
  const supported_targets = {
    "add-exchange": true,
    "dev-experiment": true,
    pay: true,
    "pay-pull": true,
    "pay-template": true,
    "pay-push": true,
    "withdraw-exchange": true,
    refund: true,
    restore: true,
    withdraw: true,
    "withdrawal-transfer-result": true
  };
  function createTalerPay(merchantBaseUrl, orderId, sessionId, opts = {}) {
    return {
      type: TalerUriAction.Pay,
      merchantBaseUrl,
      orderId,
      sessionId,
      ...opts
    };
  }
  TalerUris2.createTalerPay = createTalerPay;
  function createTalerWithdraw(bankIntegrationApiBaseUrl, withdrawalOperationId, opts = {}) {
    return {
      type: TalerUriAction.Withdraw,
      bankIntegrationApiBaseUrl,
      withdrawalOperationId,
      ...opts
    };
  }
  TalerUris2.createTalerWithdraw = createTalerWithdraw;
  function createTalerRefund(merchantBaseUrl, orderId) {
    return {
      type: TalerUriAction.Refund,
      merchantBaseUrl,
      orderId
    };
  }
  TalerUris2.createTalerRefund = createTalerRefund;
  function createTalerPayPull(exchangeBaseUrl, contractPriv) {
    return {
      type: TalerUriAction.PayPull,
      exchangeBaseUrl,
      contractPriv
    };
  }
  TalerUris2.createTalerPayPull = createTalerPayPull;
  function createTalerPayPush(exchangeBaseUrl, contractPriv) {
    return {
      type: TalerUriAction.PayPush,
      exchangeBaseUrl,
      contractPriv
    };
  }
  TalerUris2.createTalerPayPush = createTalerPayPush;
  function createTalerPayTemplate(merchantBaseUrl, templateId) {
    return {
      type: TalerUriAction.PayTemplate,
      merchantBaseUrl,
      templateId
    };
  }
  TalerUris2.createTalerPayTemplate = createTalerPayTemplate;
  function createTalerRestore(walletRootPriv, providers) {
    return {
      type: TalerUriAction.Restore,
      providers,
      walletRootPriv
    };
  }
  TalerUris2.createTalerRestore = createTalerRestore;
  function createTalerDevExperiment(devExperimentId, query) {
    return {
      type: TalerUriAction.DevExperiment,
      devExperimentId,
      query
    };
  }
  TalerUris2.createTalerDevExperiment = createTalerDevExperiment;
  function createTalerWithdrawExchange(exchangeBaseUrl, opts = {}) {
    return {
      type: TalerUriAction.WithdrawExchange,
      exchangeBaseUrl,
      ...opts
    };
  }
  TalerUris2.createTalerWithdrawExchange = createTalerWithdrawExchange;
  function createTalerAddExchange(exchangeBaseUrl) {
    return {
      type: TalerUriAction.AddExchange,
      exchangeBaseUrl
    };
  }
  TalerUris2.createTalerAddExchange = createTalerAddExchange;
  function createTalerWithdrawalTransferResult(ref, opts = {}) {
    return {
      type: TalerUriAction.WithdrawalTransferResult,
      ref,
      ...opts
    };
  }
  TalerUris2.createTalerWithdrawalTransferResult = createTalerWithdrawalTransferResult;
  function asHost(s6) {
    const b5 = new URL2(s6);
    return `${b5.host}${b5.pathname}`;
  }
  function getTalerParamList(p4) {
    const result = [];
    switch (p4.type) {
      case TalerUriAction.Withdraw: {
        if (p4.externalConfirmation)
          result.push(["external-confirmation", "1"]);
        return result;
      }
      case TalerUriAction.Pay: {
        if (p4.claimToken)
          result.push(["c", p4.claimToken]);
        if (p4.noncePriv)
          result.push(["n", p4.noncePriv]);
        return result;
      }
      case TalerUriAction.WithdrawExchange: {
        if (p4.amount)
          result.push(["a", p4.amount]);
        return result;
      }
      case TalerUriAction.WithdrawalTransferResult: {
        result.push(["ref", p4.ref]);
        if (p4.status)
          result.push(["status", p4.status]);
        return result;
      }
      case TalerUriAction.Refund:
      case TalerUriAction.PayPush:
      case TalerUriAction.PayPull:
      case TalerUriAction.PayTemplate:
      case TalerUriAction.Restore:
      case TalerUriAction.DevExperiment:
      case TalerUriAction.AddExchange: {
        return result;
      }
      default: {
        assertUnreachable(p4);
      }
    }
  }
  function getTalerPrefix(p4) {
    switch (p4.type) {
      case TalerUriAction.Withdraw:
        return p4.bankIntegrationApiBaseUrl.startsWith("http://") ? TALER_HTTP_PREFIX : TALER_PREFIX;
      case TalerUriAction.Pay:
      case TalerUriAction.Refund:
      case TalerUriAction.PayTemplate:
        return p4.merchantBaseUrl.startsWith("http://") ? TALER_HTTP_PREFIX : TALER_PREFIX;
      case TalerUriAction.PayPush:
      case TalerUriAction.PayPull:
      case TalerUriAction.AddExchange:
      case TalerUriAction.WithdrawExchange:
        return p4.exchangeBaseUrl.startsWith("http://") ? TALER_HTTP_PREFIX : TALER_PREFIX;
      case TalerUriAction.Restore:
      case TalerUriAction.DevExperiment:
      case TalerUriAction.WithdrawalTransferResult:
        return TALER_PREFIX;
      default:
        assertUnreachable(p4);
    }
  }
  function getTalerPath(p4) {
    switch (p4.type) {
      case TalerUriAction.Withdraw:
        return `/${asHost(p4.bankIntegrationApiBaseUrl)}${p4.withdrawalOperationId}`;
      case TalerUriAction.Pay:
        return `/${asHost(p4.merchantBaseUrl)}${p4.orderId}/${p4.sessionId}`;
      case TalerUriAction.Refund:
        return `/${asHost(p4.merchantBaseUrl)}${p4.orderId}/`;
      case TalerUriAction.PayTemplate:
        return `/${asHost(p4.merchantBaseUrl)}${p4.templateId}`;
      case TalerUriAction.PayPush:
        return `/${asHost(p4.exchangeBaseUrl)}${p4.contractPriv}`;
      case TalerUriAction.PayPull:
        return `/${asHost(p4.exchangeBaseUrl)}${p4.contractPriv}`;
      case TalerUriAction.AddExchange:
        return `/${asHost(p4.exchangeBaseUrl)}`;
      case TalerUriAction.WithdrawExchange:
        return `/${asHost(p4.exchangeBaseUrl)}`;
      case TalerUriAction.Restore:
        return `/${p4.walletRootPriv}/${p4.providers.map((d6) => encodeURIComponent(d6)).join(",")}`;
      case TalerUriAction.DevExperiment:
        return `/${p4.devExperimentId}`;
      case TalerUriAction.WithdrawalTransferResult:
        return `/`;
      default:
        assertUnreachable(p4);
    }
  }
  function toString(p4) {
    const prefix2 = getTalerPrefix(p4);
    const path = getTalerPath(p4);
    const paramList = getTalerParamList(p4);
    const url = new URL2(`${prefix2}${p4.type}${path}`);
    url.search = createSearchParams2(paramList);
    return url.href;
  }
  TalerUris2.toString = toString;
  function fromString(s6, opts = {}) {
    let isHttp = false;
    if (!s6.startsWith(TALER_PREFIX) && !(isHttp = s6.startsWith(TALER_HTTP_PREFIX))) {
      return opKnownFailure(TalerUriParseError.WRONG_PREFIX);
    }
    const scheme = isHttp ? "http" : "https";
    const [path, search] = s6.slice((isHttp ? TALER_HTTP_PREFIX : TALER_PREFIX).length).split("?", 2);
    const firstSlashPos = path.indexOf("/");
    const uriType = firstSlashPos === -1 ? path : path.slice(0, firstSlashPos);
    if (!supported_targets[uriType]) {
      const d6 = opKnownFailureWithBody(TalerUriParseError.UNSUPPORTED, {
        uriType
      });
      return d6;
    }
    const targetPath = path.slice(firstSlashPos + 1);
    if (firstSlashPos === -1 || !targetPath) {
      return opKnownFailureWithBody(TalerUriParseError.INCOMPLETE, {
        uriType
      });
    }
    const params = {};
    if (search) {
      const searchParams = new URLSearchParams2(search);
      searchParams.forEach((v3, k6) => {
        params[k6] = v3;
      });
    }
    const cs = targetPath.split("/");
    switch (uriType) {
      case TalerUriAction.Pay: {
        if (cs.length < 3) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const merchant = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -2).join("/"), scheme);
        if (!opts.ignoreComponentError && !merchant) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: merchant
          });
        }
        const orderId = cs[cs.length - 2];
        const sessionId = cs[cs.length - 1];
        return opFixedSuccess(createTalerPay(merchant ?? cs[0], orderId, sessionId, {
          claimToken: params["c"],
          noncePriv: params["n"]
        }));
      }
      case TalerUriAction.Withdraw: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const bank = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), scheme);
        if (!opts.ignoreComponentError && !bank) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: bank
          });
        }
        const operationId = cs[cs.length - 1];
        const externalConfirmation = !params["external-confirmation"] ? void 0 : params["external-confirmation"] === "1";
        return opFixedSuccess(createTalerWithdraw(bank ?? cs[0], operationId, {
          externalConfirmation
        }));
      }
      case TalerUriAction.Refund: {
        if (cs.length < 3) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        if (cs[cs.length - 1]) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 1,
            uriType
          });
        }
        const merchant = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -2).join("/"), scheme);
        if (!opts.ignoreComponentError && !merchant) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: merchant
          });
        }
        const orderId = cs[cs.length - 2];
        return opFixedSuccess(createTalerRefund(merchant ?? cs[0], orderId));
      }
      case TalerUriAction.PayPull: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const exchange = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), scheme);
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: exchange
          });
        }
        const contractPriv = cs[cs.length - 1];
        return opFixedSuccess(createTalerPayPull(exchange ?? cs[0], contractPriv));
      }
      case TalerUriAction.PayPush: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const exchange = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), scheme);
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: exchange
          });
        }
        const contractPriv = cs[cs.length - 1];
        return opFixedSuccess(createTalerPayPush(exchange ?? cs[0], contractPriv));
      }
      case TalerUriAction.PayTemplate: {
        if (cs.length < 2) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const merchant = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), scheme);
        if (!opts.ignoreComponentError && !merchant) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: merchant
          });
        }
        const contractPriv = cs[cs.length - 1];
        return opFixedSuccess(createTalerPayTemplate(merchant ?? cs[0], contractPriv));
      }
      case TalerUriAction.Restore: {
        if (cs.length !== 2) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const walletPriv = cs[0];
        const providers = [];
        cs[1].split(",").map((name) => {
          const url = decodeURIComponent(name);
          let isHttp2 = false;
          const withoutScheme = url.startsWith("https://") ? url.substring(8) : (isHttp2 = url.startsWith("http://")) ? url.substring(7) : url;
          const thisScheme = url === withoutScheme ? scheme : isHttp2 ? "http" : "https";
          const [hostname, path2] = withoutScheme.split("/", 1);
          const host = Paytos.parseHostPortPath2(hostname, path2, thisScheme);
          providers.push(host);
        });
        return opFixedSuccess(createTalerRestore(walletPriv ?? cs[0], providers));
      }
      case TalerUriAction.DevExperiment: {
        if (cs.length !== 1) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const experimentId = cs[0];
        const query = new URLSearchParams2(search);
        return opFixedSuccess(createTalerDevExperiment(experimentId, query));
      }
      case TalerUriAction.WithdrawExchange: {
        if (cs.length < 1) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        if (cs.length > 1 && cs[cs.length - 1]) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 1,
            uriType
          });
        }
        const exchange = Paytos.parseHostPortPath2(cs[0], cs.slice(1, -1).join("/"), scheme);
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: exchange
          });
        }
        const amountRes = !params["a"] ? void 0 : Amounts.parseWithError(params["a"]);
        if (!opts.ignoreComponentError && amountRes && amountRes.type === "fail") {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_PARAMETER, {
            name: "a",
            uriType,
            error: amountRes
          });
        }
        const amount = amountRes && amountRes.type === "ok" ? Amounts.stringify(amountRes.body) : void 0;
        return opFixedSuccess(createTalerWithdrawExchange(exchange ?? cs[0], {
          amount
        }));
      }
      case TalerUriAction.AddExchange: {
        if (cs.length === 1) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const exchange = Paytos.parseHostPortPath2(cs[0], cs.slice(1).join("/"), scheme);
        if (!opts.ignoreComponentError && !exchange) {
          return opKnownFailureWithBody(TalerUriParseError.INVALID_TARGET_PATH, {
            pos: 0,
            uriType,
            error: exchange
          });
        }
        return opFixedSuccess(createTalerAddExchange(exchange ?? cs[0]));
      }
      case TalerUriAction.WithdrawalTransferResult: {
        if (cs.length === 0) {
          return opKnownFailureWithBody(TalerUriParseError.COMPONENTS_LENGTH, {
            uriType
          });
        }
        const ref = params["ref"];
        const status = params["status"] !== "aborted" && params["status"] !== "success" ? void 0 : params["status"];
        return opFixedSuccess(createTalerWithdrawalTransferResult(ref, {
          status
        }));
      }
      default: {
        assertUnreachable(uriType);
      }
    }
  }
  TalerUris2.fromString = fromString;
})(TalerUris || (TalerUris = {}));
function parseWithdrawUriWithError(s6) {
  const pi = parseProtoInfoWithError(s6, "withdraw");
  if (pi.tag === "error") {
    return pi;
  }
  const c5 = pi.value.rest.split("?", 2);
  const path = c5[0];
  const q6 = new URLSearchParams2(c5[1] ?? "");
  const parts = path.split("/");
  if (parts.length < 2) {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
  const host = parts[0].toLowerCase();
  const pathSegments = parts.slice(1, parts.length - 1);
  const withdrawId = parts[parts.length - 1];
  const result = {
    type: TalerUriAction.Withdraw,
    bankIntegrationApiBaseUrl: Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.value.innerProto),
    withdrawalOperationId: withdrawId,
    externalConfirmation: q6.get("external-confirmation") == "1"
  };
  return Result.of(result);
}
function parseWithdrawUri(s6) {
  const r3 = parseWithdrawUriWithError(s6);
  if (r3.tag === "error")
    return void 0;
  return r3.value;
}
function parseAddExchangeUriWithError(s6) {
  const pi = parseProtoInfoWithError(s6, "add-exchange");
  if (pi.tag === "error") {
    return pi;
  }
  const parts = pi.value.rest.split("/");
  if (parts.length < 2) {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
  const host = parts[0].toLowerCase();
  const pathSegments = parts.slice(1, parts.length - 1);
  const result = {
    type: TalerUriAction.AddExchange,
    exchangeBaseUrl: Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.value.innerProto)
  };
  return Result.of(result);
}
function parseAddExchangeUri(s6) {
  const r3 = parseAddExchangeUriWithError(s6);
  if (r3.tag === "error")
    return void 0;
  return r3.value;
}
var TalerUriAction;
(function(TalerUriAction2) {
  TalerUriAction2["Withdraw"] = "withdraw";
  TalerUriAction2["Pay"] = "pay";
  TalerUriAction2["Refund"] = "refund";
  TalerUriAction2["PayPush"] = "pay-push";
  TalerUriAction2["PayPull"] = "pay-pull";
  TalerUriAction2["PayTemplate"] = "pay-template";
  TalerUriAction2["Restore"] = "restore";
  TalerUriAction2["DevExperiment"] = "dev-experiment";
  TalerUriAction2["AddExchange"] = "add-exchange";
  TalerUriAction2["WithdrawExchange"] = "withdraw-exchange";
  TalerUriAction2["WithdrawalTransferResult"] = "withdrawal-transfer-result";
})(TalerUriAction || (TalerUriAction = {}));
function parseProtoInfo(s6, action) {
  const pfxPlain = `taler://${action}/`;
  const pfxHttp = `taler+http://${action}/`;
  if (s6.toLowerCase().startsWith(pfxPlain)) {
    return {
      innerProto: "https",
      rest: s6.substring(pfxPlain.length)
    };
  } else if (s6.toLowerCase().startsWith(pfxHttp)) {
    return {
      innerProto: "http",
      rest: s6.substring(pfxHttp.length)
    };
  } else {
    return void 0;
  }
}
function parseProtoInfoWithError(s6, action) {
  if (!s6.toLowerCase().startsWith("taler://") && !s6.toLowerCase().startsWith("taler+http://")) {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
  const pfxPlain = `taler://${action}/`;
  const pfxHttp = `taler+http://${action}/`;
  if (s6.toLowerCase().startsWith(pfxPlain)) {
    return Result.of({
      innerProto: "https",
      rest: s6.substring(pfxPlain.length)
    });
  } else if (s6.toLowerCase().startsWith(pfxHttp)) {
    return Result.of({
      innerProto: "http",
      rest: s6.substring(pfxHttp.length)
    });
  } else {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
}
var parsers = {
  [TalerUriAction.Pay]: parsePayUri,
  [TalerUriAction.PayPull]: parsePayPullUri,
  [TalerUriAction.PayPush]: parsePayPushUri,
  [TalerUriAction.PayTemplate]: parsePayTemplateUri,
  [TalerUriAction.Restore]: parseRestoreUri,
  [TalerUriAction.Refund]: parseRefundUri,
  [TalerUriAction.Withdraw]: parseWithdrawUri,
  [TalerUriAction.DevExperiment]: parseDevExperimentUri,
  [TalerUriAction.WithdrawExchange]: parseWithdrawExchangeUri,
  [TalerUriAction.AddExchange]: parseAddExchangeUri,
  [TalerUriAction.WithdrawalTransferResult]: () => {
    throw new Error("not supported");
  }
};
function parseTalerUri(string) {
  const https = string.startsWith("taler://");
  const http = string.startsWith("taler+http://");
  if (!https && !http)
    return void 0;
  const actionStart = https ? 8 : 13;
  const actionEnd = string.indexOf("/", actionStart + 1);
  const action = string.substring(actionStart, actionEnd);
  const found = Object.values(TalerUriAction).find((x6) => x6 === action);
  if (!found)
    return void 0;
  return parsers[found](string);
}
function stringifyTalerUri(uri) {
  switch (uri.type) {
    case TalerUriAction.DevExperiment: {
      return stringifyDevExperimentUri(uri);
    }
    case TalerUriAction.Pay: {
      return stringifyPayUri(uri);
    }
    case TalerUriAction.PayPull: {
      return stringifyPayPullUri(uri);
    }
    case TalerUriAction.PayPush: {
      return stringifyPayPushUri(uri);
    }
    case TalerUriAction.PayTemplate: {
      return stringifyPayTemplateUri(uri);
    }
    case TalerUriAction.Restore: {
      return stringifyRestoreUri(uri);
    }
    case TalerUriAction.Refund: {
      return stringifyRefundUri(uri);
    }
    case TalerUriAction.Withdraw: {
      return stringifyWithdrawUri(uri);
    }
    case TalerUriAction.WithdrawExchange: {
      return stringifyWithdrawExchange(uri);
    }
    case TalerUriAction.AddExchange: {
      return stringifyAddExchange(uri);
    }
    case TalerUriAction.WithdrawalTransferResult: {
      throw Error("not supported");
    }
  }
}
function parsePayUri(s6) {
  const pi = parseProtoInfo(s6, "pay");
  if (!pi) {
    return void 0;
  }
  const c5 = pi?.rest.split("?");
  const q6 = new URLSearchParams2(c5[1] ?? "");
  const claimToken = q6.get("c") ?? void 0;
  const noncePriv = q6.get("n") ?? void 0;
  const parts = c5[0].split("/");
  if (parts.length < 3) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const sessionId = parts[parts.length - 1];
  const orderId = parts[parts.length - 2];
  const pathSegments = parts.slice(1, parts.length - 2);
  const merchantBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  return {
    type: TalerUriAction.Pay,
    merchantBaseUrl,
    orderId,
    sessionId,
    claimToken,
    noncePriv
  };
}
function parsePayTemplateUri(uriString) {
  const pi = parseProtoInfo(uriString, TalerUriAction.PayTemplate);
  if (!pi) {
    return void 0;
  }
  const c5 = pi.rest.split("?");
  const parts = c5[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const q6 = new URLSearchParams2(c5[1] ?? "");
  const params = {};
  q6.forEach((v3, k6) => {
    params[k6] = v3;
  });
  const host = parts[0].toLowerCase();
  const templateId = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const merchantBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  return {
    type: TalerUriAction.PayTemplate,
    merchantBaseUrl,
    templateId
  };
}
function parsePayPushUri(s6) {
  const pi = parseProtoInfo(s6, TalerUriAction.PayPush);
  if (!pi) {
    return void 0;
  }
  const c5 = pi?.rest.split("?");
  const parts = c5[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const contractPriv = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  return {
    type: TalerUriAction.PayPush,
    exchangeBaseUrl,
    contractPriv
  };
}
function parsePayPullUri(s6) {
  const pi = parseProtoInfo(s6, TalerUriAction.PayPull);
  if (!pi) {
    return void 0;
  }
  const c5 = pi?.rest.split("?");
  const parts = c5[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const contractPriv = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  return {
    type: TalerUriAction.PayPull,
    exchangeBaseUrl,
    contractPriv
  };
}
function parseWithdrawExchangeUri(s6) {
  const pi = parseProtoInfo(s6, "withdraw-exchange");
  if (!pi) {
    return void 0;
  }
  const c5 = pi?.rest.split("?");
  const parts = c5[0].split("/");
  if (parts.length < 1) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const lastPathComponent = parts.length > 1 ? parts[parts.length - 1] : void 0;
  if (lastPathComponent) {
    return void 0;
  }
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  const q6 = new URLSearchParams2(c5[1] ?? "");
  const amount = q6.get("a") ?? void 0;
  return {
    type: TalerUriAction.WithdrawExchange,
    exchangeBaseUrl,
    amount
  };
}
function parseRefundUri(s6) {
  const pi = parseProtoInfo(s6, "refund");
  if (!pi) {
    return void 0;
  }
  const c5 = pi?.rest.split("?");
  const parts = c5[0].split("/");
  if (parts.length < 3) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const sessionId = parts[parts.length - 1];
  const orderId = parts[parts.length - 2];
  const pathSegments = parts.slice(1, parts.length - 2);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const merchantBaseUrl = Paytos.parseHostPortPath2(host, pathSegments.join("/"), pi.innerProto);
  return {
    type: TalerUriAction.Refund,
    merchantBaseUrl,
    orderId
  };
}
function parseDevExperimentUri(s6) {
  const pi = parseProtoInfo(s6, "dev-experiment");
  const c5 = pi?.rest.split("?");
  if (!c5) {
    return void 0;
  }
  const parts = c5[0].split("/");
  return {
    type: TalerUriAction.DevExperiment,
    devExperimentId: parts[0],
    query: new URLSearchParams2(c5[1] ?? "")
  };
}
function parseRestoreUri(uri) {
  const pi = parseProtoInfo(uri, "restore");
  if (!pi) {
    return void 0;
  }
  const c5 = pi.rest.split("?");
  const parts = c5[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const walletRootPriv = parts[0];
  if (!walletRootPriv)
    return void 0;
  const providers = new Array();
  parts[1].split(",").map((name) => {
    const url = decodeURIComponent(name);
    let isHttp = false;
    const withoutScheme = url.startsWith("https://") ? url.substring(8) : (isHttp = url.startsWith("http://")) ? url.substring(7) : url;
    const scheme = url === withoutScheme ? pi.innerProto : isHttp ? "http" : "https";
    const [hostname, path] = withoutScheme.split("/", 1);
    const host = Paytos.parseHostPortPath2(hostname, path ?? "/", scheme);
    providers.push(host);
  });
  return {
    type: TalerUriAction.Restore,
    walletRootPriv,
    providers
  };
}
function stringifyPayUri({ merchantBaseUrl, orderId, sessionId, claimToken, noncePriv }) {
  const { proto, path, query } = getUrlInfo(merchantBaseUrl, {
    c: claimToken,
    n: noncePriv
  });
  return `${proto}://pay/${path}${orderId}/${sessionId}${query}`;
}
function stringifyPayPullUri({ contractPriv, exchangeBaseUrl }) {
  const { proto, path } = getUrlInfo(exchangeBaseUrl);
  return `${proto}://pay-pull/${path}${contractPriv}`;
}
function stringifyPayPushUri({ contractPriv, exchangeBaseUrl }) {
  const { proto, path } = getUrlInfo(exchangeBaseUrl);
  return `${proto}://pay-push/${path}${contractPriv}`;
}
function stringifyRestoreUri({ providers, walletRootPriv }) {
  const list = providers.map((url) => `${encodeURIComponent(new URL2(url).href)}`).join(",");
  return `taler://restore/${walletRootPriv}/${list}`;
}
function stringifyWithdrawExchange({ exchangeBaseUrl, amount }) {
  const { proto, path, query } = getUrlInfo(exchangeBaseUrl, {
    a: amount
  });
  return `${proto}://withdraw-exchange/${path}${query}`;
}
function stringifyAddExchange({ exchangeBaseUrl }) {
  const { proto, path } = getUrlInfo(exchangeBaseUrl);
  return `${proto}://add-exchange/${path}`;
}
function stringifyDevExperimentUri({ devExperimentId }) {
  return `taler://dev-experiment/${devExperimentId}`;
}
function stringifyPayTemplateUri({ merchantBaseUrl, templateId }) {
  const { proto, path, query } = getUrlInfo(merchantBaseUrl);
  return `${proto}://pay-template/${path}${templateId}${query}`;
}
function stringifyRefundUri({ merchantBaseUrl, orderId }) {
  const { proto, path } = getUrlInfo(merchantBaseUrl);
  return `${proto}://refund/${path}${orderId}/`;
}
function stringifyWithdrawUri({ bankIntegrationApiBaseUrl, withdrawalOperationId }) {
  const { proto, path } = getUrlInfo(bankIntegrationApiBaseUrl);
  return `${proto}://withdraw/${path}${withdrawalOperationId}`;
}
function getUrlInfo(baseUrl, params = {}) {
  const url = new URL2(baseUrl);
  let proto;
  if (url.protocol === "https:") {
    proto = "taler";
  } else if (url.protocol === "http:") {
    proto = "taler+http";
  } else {
    throw Error(`Unsupported URL protocol in ${baseUrl}`);
  }
  let path = url.hostname;
  if (url.port) {
    path = path + ":" + url.port;
  }
  if (url.pathname) {
    path = path + url.pathname;
  }
  if (!path.endsWith("/")) {
    path = path + "/";
  }
  const qp = new URLSearchParams2();
  let withParams = false;
  Object.entries(params).forEach(([name, value]) => {
    if (value !== void 0) {
      withParams = true;
      qp.append(name, value);
    }
  });
  const query = withParams ? "?" + qp.toString() : "";
  return { proto, path, query };
}
function encodeRFC3986URIComponent2(str) {
  return encodeURIComponent(str).replace(/[!'()*]/g, (c5) => `%${c5.charCodeAt(0).toString(16).toUpperCase()}`);
}
var rfc39862 = encodeRFC3986URIComponent2;
function createSearchParams2(paramList) {
  return paramList.map(([key, value]) => `${rfc39862(key)}=${rfc39862(value)}`).join("&");
}

// ../taler-util/lib/types-taler-corebank.js
var MonitorTimeframeParam;
(function(MonitorTimeframeParam2) {
  MonitorTimeframeParam2[MonitorTimeframeParam2["hour"] = 0] = "hour";
  MonitorTimeframeParam2[MonitorTimeframeParam2["day"] = 1] = "day";
  MonitorTimeframeParam2[MonitorTimeframeParam2["month"] = 2] = "month";
  MonitorTimeframeParam2[MonitorTimeframeParam2["year"] = 3] = "year";
  MonitorTimeframeParam2[MonitorTimeframeParam2["decade"] = 4] = "decade";
})(MonitorTimeframeParam || (MonitorTimeframeParam = {}));
var codecForIntegrationBankConfig = () => buildCodecForObject().property("name", codecForConstString("taler-bank-integration")).property("version", codecForString()).property("currency", codecForString()).property("currency_specification", codecForCurrencySpecificiation()).property("implementation", codecOptional(codecForString())).build("TalerCorebankApi.IntegrationConfig");
var codecForCoreBankConfig = () => buildCodecForObject().property("name", codecForEither(codecForConstString("taler-corebank"), codecForConstString("libeufin-bank"))).property("version", codecForString()).property("bank_name", codecOptional(codecForString())).property("base_url", codecOptional(codecForString())).property("allow_conversion", codecOptional(codecForBoolean())).property("allow_registrations", codecOptional(codecForBoolean())).property("allow_deletions", codecOptional(codecForBoolean())).property("allow_edit_name", codecOptional(codecForBoolean())).property("allow_edit_cashout_payto_uri", codecOptional(codecForBoolean())).property("default_debit_threshold", codecOptional(codecForAmountString())).property("currency", codecForString()).property("currency_specification", codecForCurrencySpecificiation()).property("supported_tan_channels", codecOptional(codecForList(codecForEither(codecForConstString(TanChannel.SMS), codecForConstString(TanChannel.EMAIL))))).property("wire_type", codecOptionalDefault(codecForString(), "iban")).property("wire_transfer_fees", codecOptional(codecForAmountString())).property("min_wire_transfer_amount", codecOptional(codecForAmountString())).property("max_wire_transfer_amount", codecOptional(codecForAmountString())).build("TalerCorebankApi.Config");
var codecForBalance = () => buildCodecForObject().property("amount", codecForAmountString()).property("credit_debit_indicator", codecForEither(codecForConstString("credit"), codecForConstString("debit"))).build("TalerCorebankApi.Balance");
var codecForPublicAccount = () => buildCodecForObject().property("username", codecForString()).property("balance", codecForBalance()).property("payto_uri", codecForPaytoString()).property("is_taler_exchange", codecForBoolean()).property("row_id", codecOptional(codecForNumber())).build("TalerCorebankApi.PublicAccount");
var codecForPublicAccountsResponse = () => buildCodecForObject().property("public_accounts", codecForList(codecForPublicAccount())).build("TalerCorebankApi.PublicAccountsResponse");
var codecForAccountMinimalData = () => buildCodecForObject().property("username", codecForString()).property("name", codecForString()).property("payto_uri", codecForPaytoString()).property("balance", codecForBalance()).property("row_id", codecForNumber()).property("debit_threshold", codecForAmountString()).property("is_public", codecForBoolean()).property("is_taler_exchange", codecForBoolean()).property("status", codecOptional(codecForEither(codecForConstString("active"), codecForConstString("locked"), codecForConstString("deleted")))).property("conversion_rate_class_id", codecOptional(codecForNumber())).property("conversion_rate", codecOptional(codecForConversionRate())).build("TalerCorebankApi.AccountMinimalData");
var codecForListBankAccountsResponse = () => buildCodecForObject().property("accounts", codecForList(codecForAccountMinimalData())).build("TalerCorebankApi.ListBankAccountsResponse");
var codecForAccountData = () => buildCodecForObject().property("name", codecForString()).property("balance", codecForBalance()).property("payto_uri", codecForPaytoString()).property("debit_threshold", codecForAmountString()).property("contact_data", codecOptional(codecForChallengeContactData())).property("cashout_payto_uri", codecOptional(codecForPaytoString())).property("is_public", codecForBoolean()).property("is_taler_exchange", codecForBoolean()).property("conversion_rate_class_id", codecOptional(codecForNumber())).property("tan_channel", codecOptional(codecForEither(codecForConstString(TanChannel.SMS), codecForConstString(TanChannel.EMAIL)))).property("status", codecOptional(codecForEither(codecForConstString("active"), codecForConstString("locked"), codecForConstString("deleted")))).build("TalerCorebankApi.AccountData");
var codecForConversionRateClassResponse = () => buildCodecForObject().property("conversion_rate_class_id", codecForNumber()).build("TalerCorebankApi.ConversionRateClassResponse");
var codecForConversionRateClass = () => buildCodecForObject().property("cashin_fee", codecOptional(codecForAmountString())).property("cashin_min_amount", codecOptional(codecForAmountString())).property("cashin_ratio", codecOptional(codecForDecimalNumber())).property("cashin_rounding_mode", codecOptional(codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest")))).property("cashout_fee", codecOptional(codecForAmountString())).property("cashout_min_amount", codecOptional(codecForAmountString())).property("cashout_ratio", codecOptional(codecForDecimalNumber())).property("cashout_rounding_mode", codecOptional(codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest")))).property("conversion_rate_class_id", codecForNumber()).property("description", codecOptional(codecForString())).property("name", codecForString()).property("num_users", codecForNumber()).build("TalerCorebankApi.ConversionRateClass");
var codecForConversionRateClasses = () => buildCodecForObject().property("classes", codecForList(codecForConversionRateClass())).build("TalerCorebankApi.ConversionRateClasses");
var codecForChallengeContactData = () => buildCodecForObject().property("email", codecOptional(codecForString())).property("phone", codecOptional(codecForString())).build("TalerCorebankApi.ChallengeContactData");
var codecForWithdrawalPublicInfo = () => buildCodecForObject().property("status", codecForEither(codecForConstString("pending"), codecForConstString("selected"), codecForConstString("aborted"), codecForConstString("confirmed"))).property("amount", codecOptional(codecForAmountString())).property("suggested_amount", codecOptional(codecForAmountString())).property("username", codecForString()).property("selected_reserve_pub", codecOptional(codecForString())).property("selected_exchange_account", codecOptional(codecForPaytoString())).property("no_amount_to_wallet", codecOptional(codecForBoolean())).build("TalerCorebankApi.WithdrawalPublicInfo");
var codecForBankAccountTransactionsResponse = () => buildCodecForObject().property("transactions", codecForList(codecForBankAccountTransactionInfo())).build("TalerCorebankApi.BankAccountTransactionsResponse");
var codecForBankAccountTransactionInfo = () => buildCodecForObject().property("creditor_payto_uri", codecForPaytoString()).property("debtor_payto_uri", codecForPaytoString()).property("amount", codecForAmountString()).property("direction", codecForEither(codecForConstString("debit"), codecForConstString("credit"))).property("subject", codecForString()).property("row_id", codecForNumber()).property("date", codecForTimestamp).build("TalerCorebankApi.BankAccountTransactionInfo");
var codecForCreateTransactionResponse = () => buildCodecForObject().property("row_id", codecForNumber()).build("TalerCorebankApi.CreateTransactionResponse");
var codecForRegisterAccountResponse = () => buildCodecForObject().property("internal_payto_uri", codecForPaytoString()).build("TalerCorebankApi.RegisterAccountResponse");
var codecForBankAccountCreateWithdrawalResponse = () => buildCodecForObject().property("taler_withdraw_uri", codecForTalerUriString()).property("withdrawal_id", codecForString()).build("TalerCorebankApi.BankAccountCreateWithdrawalResponse");
var codecForCashoutPending = () => buildCodecForObject().property("cashout_id", codecForNumber()).build("TalerCorebankApi.CashoutPending");
var codecForCashouts = () => buildCodecForObject().property("cashouts", codecForList(codecForCashoutInfo())).build("TalerCorebankApi.Cashouts");
var codecForCashoutInfo = () => buildCodecForObject().property("cashout_id", codecForNumber()).build("TalerCorebankApi.CashoutInfo");
var codecForGlobalCashouts = () => buildCodecForObject().property("cashouts", codecForList(codecForGlobalCashoutInfo())).build("TalerCorebankApi.GlobalCashouts");
var codecForGlobalCashoutInfo = () => buildCodecForObject().property("cashout_id", codecForNumber()).property("username", codecForString()).build("TalerCorebankApi.GlobalCashoutInfo");
var codecForCashoutStatusResponse = () => buildCodecForObject().property("amount_debit", codecForAmountString()).property("amount_credit", codecForAmountString()).property("subject", codecForString()).property("creation_time", codecForTimestamp).build("TalerCorebankApi.CashoutStatusResponse");
var codecForMonitorResponse = () => buildCodecForUnion().discriminateOn("type").alternative("no-conversions", codecForMonitorNoConversion()).alternative("with-conversions", codecForMonitorWithCashout()).build("TalerWireGatewayApi.IncomingBankTransaction");
var codecForMonitorNoConversion = () => buildCodecForObject().property("type", codecForConstString("no-conversions")).property("talerInCount", codecForNumber()).property("talerInVolume", codecForAmountString()).property("talerOutCount", codecForNumber()).property("talerOutVolume", codecForAmountString()).build("TalerCorebankApi.MonitorJustPayouts");
var codecForMonitorWithCashout = () => buildCodecForObject().property("type", codecForConstString("with-conversions")).property("cashinCount", codecForNumber()).property("cashinFiatVolume", codecForAmountString()).property("cashinRegionalVolume", codecForAmountString()).property("cashoutCount", codecForNumber()).property("cashoutFiatVolume", codecForAmountString()).property("cashoutRegionalVolume", codecForAmountString()).property("talerInCount", codecForNumber()).property("talerInVolume", codecForAmountString()).property("talerOutCount", codecForNumber()).property("talerOutVolume", codecForAmountString()).build("TalerCorebankApi.MonitorWithCashout");

// ../taler-util/lib/http-client/bank-core.js
var TalerCoreBankCacheEviction;
(function(TalerCoreBankCacheEviction2) {
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["DELETE_ACCOUNT"] = 0] = "DELETE_ACCOUNT";
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["CREATE_ACCOUNT"] = 1] = "CREATE_ACCOUNT";
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["UPDATE_ACCOUNT"] = 2] = "UPDATE_ACCOUNT";
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["UPDATE_PASSWORD"] = 3] = "UPDATE_PASSWORD";
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["CREATE_TRANSACTION"] = 4] = "CREATE_TRANSACTION";
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["CONFIRM_WITHDRAWAL"] = 5] = "CONFIRM_WITHDRAWAL";
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["ABORT_WITHDRAWAL"] = 6] = "ABORT_WITHDRAWAL";
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["CREATE_WITHDRAWAL"] = 7] = "CREATE_WITHDRAWAL";
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["CREATE_CASHOUT"] = 8] = "CREATE_CASHOUT";
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["CREATE_CONVERSION_RATE_CLASS"] = 9] = "CREATE_CONVERSION_RATE_CLASS";
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["UPDATE_CONVERSION_RATE_CLASS"] = 10] = "UPDATE_CONVERSION_RATE_CLASS";
  TalerCoreBankCacheEviction2[TalerCoreBankCacheEviction2["DELETE_CONVERSION_RATE_CLASS"] = 11] = "DELETE_CONVERSION_RATE_CLASS";
})(TalerCoreBankCacheEviction || (TalerCoreBankCacheEviction = {}));
var TalerCoreBankHttpClient = class _TalerCoreBankHttpClient {
  constructor(baseUrl, httpClient, cacheEvictor) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
    this.cacheEvictor = cacheEvictor ?? nullEvictor;
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   *
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-token
   */
  async createAccessToken(username, cred, body, params = {}) {
    const url = new URL(`accounts/${username}/token`, this.baseUrl);
    const headers = {};
    switch (cred.type) {
      case "basic": {
        headers.Authorization = makeBasicAuthHeader2(username, cred.password);
        break;
      }
      case "bearer": {
        headers.Authorization = makeBearerTokenAuthHeader(cred.accessToken);
        break;
      }
      default: {
        assertUnreachable(cred);
      }
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTokenSuccessResponse());
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.GENERIC_FORBIDDEN:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_ACCOUNT_LOCKED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * @deprecated use createAccessToken
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-token
   */
  async createAccessTokenBasic(username, password, body) {
    return this.createAccessToken(username, { type: "basic", password }, body);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#delete--accounts-$USERNAME-token
   */
  async deleteAccessToken(user, token) {
    const url = new URL(`accounts/${user}/token`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opEmptySuccess();
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-tokens
   *
   */
  async getAccessTokenList(user, pagination) {
    const url = new URL(`accounts/${user}/token`, this.baseUrl);
    addPaginationParams(url, pagination);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTokenInfoList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ public_accounts: [] });
      case HttpStatusCode.NotFound:
        return opFixedSuccess({ public_accounts: [] });
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#config
   *
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-corebank", _TalerCoreBankHttpClient.PROTOCOL_VERSION, resp, codecForCoreBankConfig());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // ACCOUNTS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts
   *
   */
  async createAccount(auth, body) {
    const url = new URL(`accounts`, this.baseUrl);
    const headers = {};
    if (auth) {
      headers.Authorization = makeBearerTokenAuthHeader(auth);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CREATE_ACCOUNT);
        return opSuccessFromHttp(resp, codecForRegisterAccountResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_REGISTER_USERNAME_REUSE:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_REGISTER_PAYTO_URI_REUSE:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNALLOWED_DEBIT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_RESERVED_USERNAME_CONFLICT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_PATCH_DEBT_LIMIT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_SET_TAN_CHANNEL:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_TAN_CHANNEL_NOT_SUPPORTED:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_MISSING_TAN_INFO:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_SHORT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_LONG:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_CONVERSION_RATE_CLASS_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#delete--accounts-$USERNAME
   *
   */
  async deleteAccount(auth, params = {}) {
    const url = new URL(`accounts/${auth.username}`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Accepted:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.DELETE_ACCOUNT);
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_RESERVED_USERNAME_CONFLICT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_ACCOUNT_BALANCE_NOT_ZERO:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#patch--accounts-$USERNAME
   *
   */
  async updateAccount(auth, body, params = {}) {
    const url = new URL(`accounts/${auth.username}`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.NoContent:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.UPDATE_ACCOUNT);
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_NON_ADMIN_PATCH_LEGAL_NAME:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_PATCH_CASHOUT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_PATCH_DEBT_LIMIT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_TAN_CHANNEL_NOT_SUPPORTED:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_MISSING_TAN_INFO:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_SHORT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_LONG:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_CONVERSION_RATE_CLASS_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#patch--accounts-$USERNAME-auth
   *
   */
  async updatePassword(auth, body, params = {}) {
    const url = new URL(`accounts/${auth.username}/auth`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PATCH_BAD_OLD_PASSWORD:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_SHORT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_PASSWORD_TOO_LONG:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--public-accounts
   *
   */
  async getPublicAccounts(filter = {}, pagination) {
    const url = new URL(`public-accounts`, this.baseUrl);
    addPaginationParams(url, pagination);
    if (filter.account !== void 0) {
      url.searchParams.set("filter_name", filter.account);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForPublicAccountsResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ public_accounts: [] });
      case HttpStatusCode.NotFound:
        return opFixedSuccess({ public_accounts: [] });
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts
   *
   */
  async listAccounts(auth, params) {
    const url = new URL(`accounts`, this.baseUrl);
    addPaginationParams(url, params);
    if (params?.account !== void 0) {
      url.searchParams.set("filter_name", params.account);
    }
    if (params?.conversionRateId !== void 0) {
      url.searchParams.set("conversion_rate_class_id", String(params.conversionRateId));
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForListBankAccountsResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ accounts: [] });
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME
   *
   */
  async getAccount(auth) {
    const url = new URL(`accounts/${auth.username}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAccountData());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // TRANSACTIONS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-transactions
   *
   */
  async getTransactions(auth, params) {
    const url = new URL(`accounts/${auth.username}/transactions`, this.baseUrl);
    addPaginationParams(url, params);
    addLongPollingParam(url, params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankAccountTransactionsResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ transactions: [] });
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-transactions-$TRANSACTION_ID
   *
   */
  async getTransactionById(auth, txid) {
    const url = new URL(`accounts/${auth.username}/transactions/${String(txid)}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankAccountTransactionInfo());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-transactions
   *
   */
  async createTransaction(auth, body, params = {}) {
    const url = new URL(`accounts/${auth.username}/transactions`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CREATE_TRANSACTION);
        return opSuccessFromHttp(resp, codecForCreateTransactionResponse());
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_ADMIN_CREDITOR:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_SAME_ACCOUNT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNKNOWN_CREDITOR:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNALLOWED_DEBIT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_TRANSFER_REQUEST_UID_REUSED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // WITHDRAWALS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-withdrawals
   *
   */
  async createWithdrawal(auth, body) {
    const url = new URL(`accounts/${auth.username}/withdrawals`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      },
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CREATE_WITHDRAWAL);
        return opSuccessFromHttp(resp, codecForBankAccountCreateWithdrawalResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-withdrawals-$WITHDRAWAL_ID-confirm
   *
   */
  async confirmWithdrawalById(auth, body, wid, params = {}) {
    const url = new URL(`accounts/${auth.username}/withdrawals/${wid}/confirm`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.NoContent:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CONFIRM_WITHDRAWAL);
        return opEmptySuccess();
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_CONFIRM_ABORT_CONFLICT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_CONFIRM_INCOMPLETE:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNALLOWED_DEBIT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_AMOUNT_DIFFERS:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_AMOUNT_REQUIRED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-withdrawals-$WITHDRAWAL_ID-abort
   *
   */
  async abortWithdrawalById(auth, wid) {
    const url = new URL(`accounts/${auth.username}/withdrawals/${wid}/abort`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.ABORT_WITHDRAWAL);
        return opEmptySuccess();
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--withdrawals-$WITHDRAWAL_ID
   *
   */
  async getWithdrawalById(wid, params) {
    const url = new URL(`withdrawals/${wid}`, this.baseUrl);
    addLongPollingParam(url, params);
    if (params) {
      url.searchParams.set("old_state", !params.old_state ? "pending" : params.old_state);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForWithdrawalPublicInfo());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // CASHOUTS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-cashouts
   *
   */
  async createCashout(auth, body, params = {}) {
    const url = new URL(`accounts/${auth.username}/cashouts`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBearerTokenAuthHeader(auth.token);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CREATE_CASHOUT);
        return opSuccessFromHttp(resp, codecForCashoutPending());
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details2 = await readTalerErrorResponse(resp);
        switch (details2.code) {
          case TalerErrorCode.BANK_TRANSFER_REQUEST_UID_REUSED:
            return opKnownTalerFailure(details2.code, details2);
          case TalerErrorCode.BANK_BAD_CONVERSION:
            return opKnownTalerFailure(details2.code, details2);
          case TalerErrorCode.BANK_CONVERSION_AMOUNT_TO_SMALL:
            return opKnownTalerFailure(details2.code, details2);
          case TalerErrorCode.BANK_UNALLOWED_DEBIT:
            return opKnownTalerFailure(details2.code, details2);
          case TalerErrorCode.BANK_CONFIRM_INCOMPLETE:
            return opKnownTalerFailure(details2.code, details2);
          default:
            return opUnknownHttpFailure(resp, details2);
        }
      }
      case HttpStatusCode.BadGateway: {
        const details2 = await readTalerErrorResponse(resp);
        switch (details2.code) {
          case TalerErrorCode.BANK_TAN_CHANNEL_SCRIPT_FAILED:
            return opKnownTalerFailure(details2.code, details2);
          default:
            return opUnknownHttpFailure(resp, details2);
        }
      }
      case HttpStatusCode.NotImplemented:
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_TAN_CHANNEL_NOT_SUPPORTED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opKnownHttpFailure(resp.status, resp);
        }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-cashouts-$CASHOUT_ID
   *
   */
  async getCashoutById(auth, cid) {
    const url = new URL(`accounts/${auth.username}/cashouts/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCashoutStatusResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-cashouts
   *
   */
  async getAccountCashouts(auth, pagination) {
    const url = new URL(`accounts/${auth.username}/cashouts`, this.baseUrl);
    addPaginationParams(url, pagination);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth.token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCashouts());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ cashouts: [] });
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--cashouts
   *
   */
  async getGlobalCashouts(auth, pagination) {
    const url = new URL(`cashouts`, this.baseUrl);
    addPaginationParams(url, pagination);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForGlobalCashouts());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ cashouts: [] });
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // CONVERSION RATE CLASS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--conversion-rate-classes
   *
   */
  async createConversionRateClass(auth, body) {
    const url = new URL(`conversion-rate-classes`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      },
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.CREATE_CONVERSION_RATE_CLASS);
        return opSuccessFromHttp(resp, codecForConversionRateClassResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_NAME_REUSE:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#patch--conversion-rate-classes-CLASS_ID
   *
   */
  async updateConversionRateClass(auth, cid, body) {
    const url = new URL(`conversion-rate-classes/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      },
      body
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.UPDATE_CONVERSION_RATE_CLASS);
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_NAME_REUSE:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-cashouts
   *
   */
  async deleteConversionRateClass(auth, cid) {
    const url = new URL(`conversion-rate-classes/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        await this.cacheEvictor.notifySuccess(TalerCoreBankCacheEviction.DELETE_CONVERSION_RATE_CLASS);
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--conversion-rate-classes-CLASS_ID
   *
   */
  async getConversionRateClass(auth, cid) {
    const url = new URL(`conversion-rate-classes/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForConversionRateClass());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--conversion-rate-classes
   *
   */
  async listConversionRateClasses(auth, params = {}) {
    const url = new URL(`conversion-rate-classes`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.className) {
      url.searchParams.set("filter_name", params.className);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForConversionRateClasses());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ classes: [], default: {} });
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotImplemented:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // 2FA
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-challenge-$CHALLENGE_ID
   *
   */
  async sendChallenge(username, cid) {
    const url = new URL(`accounts/${username}/challenge/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengeRequestResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({});
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.TooManyRequests:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.BadGateway: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_TAN_CHANNEL_SCRIPT_FAILED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-challenge-$CHALLENGE_ID-confirm
   *
   */
  async confirmChallenge(username, cid, body) {
    const url = new URL(`accounts/${username}/challenge/${cid}/confirm`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_TAN_CHALLENGE_FAILED:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_TAN_CHALLENGE_EXPIRED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.NotFound: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.BANK_TRANSACTION_NOT_FOUND:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_TAN_CHALLENGE_EXPIRED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.TooManyRequests: {
        return opKnownHttpFailure(resp.status, resp);
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // MONITOR
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#get--monitor
   *
   */
  async getMonitor(auth, params = {}) {
    const url = new URL(`monitor`, this.baseUrl);
    if (params.timeframe) {
      url.searchParams.set("timeframe", MonitorTimeframeParam[params.timeframe]);
    }
    if (params.date) {
      const { t_s: seconds } = AbsoluteTime.toProtocolTimestamp(params.date);
      if (seconds !== "never") {
        url.searchParams.set("date_s", String(seconds));
      }
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForMonitorResponse());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Others API
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#taler-bank-integration-api
   *
   */
  getIntegrationAPI() {
    return new URL(`taler-integration/`, this.baseUrl);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#taler-bank-integration-api
   *
   */
  getWireGatewayAPI(username) {
    return new URL(`accounts/${username}/taler-wire-gateway/`, this.baseUrl);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#taler-bank-integration-api
   *
   */
  getRevenueAPI(username) {
    return new URL(`accounts/${username}/taler-revenue/`, this.baseUrl);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#any--accounts-$USERNAME-conversion-info-*
   *
   */
  getConversionInfoAPIForUser(username) {
    return new URL(`accounts/${username}/conversion-info/`, this.baseUrl);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#any--conversion-rate-classes-$CLASS_ID-conversion-info-*
   *
   */
  getConversionInfoAPIForClass(classId) {
    return new URL(`conversion-rate-classes/${String(classId)}/conversion-info/`, this.baseUrl);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#any--conversion-info-*
   *
   */
  getConversionInfoAPI() {
    return new URL(`conversion-info/`, this.baseUrl);
  }
};
TalerCoreBankHttpClient.PROTOCOL_VERSION = "10:0:2";

// ../taler-util/lib/types-taler-bank-integration.js
var codecForBankWithdrawalOperationStatus = () => buildCodecForObject().property("status", codecForEither(codecForConstString("pending"), codecForConstString("selected"), codecForConstString("aborted"), codecForConstString("confirmed"))).property("currency", codecOptional(codecForCurrencyName())).property("amount", codecOptional(codecForAmountString())).property("suggested_amount", codecOptional(codecForAmountString())).property("min_amount", codecOptional(codecForAmountString())).property("max_amount", codecOptional(codecForAmountString())).property("card_fees", codecOptional(codecForAmountString())).property("sender_wire", codecOptional(codecForPaytoString())).property("suggested_exchange", codecOptional(codecForURLString())).property("required_exchange", codecOptional(codecForURLString())).property("confirm_transfer_url", codecOptional(codecForURLString())).property("wire_types", codecForList(codecForString())).property("selected_reserve_pub", codecOptional(codecForString())).property("selected_exchange_account", codecOptional(codecForString())).property("no_amount_to_wallet", codecOptional(codecForBoolean())).deprecatedProperty("aborted").deprecatedProperty("selection_done").deprecatedProperty("transfer_done").build("TalerBankIntegrationApi.BankWithdrawalOperationStatus");
var codecForBankWithdrawalOperationPostResponse = () => buildCodecForObject().property("status", codecForEither(codecForConstString("selected"), codecForConstString("aborted"), codecForConstString("confirmed"))).property("confirm_transfer_url", codecOptional(codecForURLString())).deprecatedProperty("transfer_done").build("TalerBankIntegrationApi.BankWithdrawalOperationPostResponse");

// ../taler-util/lib/http-client/bank-integration.js
var logger6 = new Logger("bank-integration.ts");
var TalerBankIntegrationHttpClient = class _TalerBankIntegrationHttpClient {
  constructor(baseUrl, httpClient) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#get--config
   *
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-bank-integration", _TalerBankIntegrationHttpClient.PROTOCOL_VERSION, resp, codecForIntegrationBankConfig());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#get--withdrawal-operation-$WITHDRAWAL_ID
   *
   */
  async getWithdrawalOperationById(woid, params) {
    const url = new URL(`withdrawal-operation/${woid}`, this.baseUrl);
    addLongPollingParam(url, params);
    if (params) {
      url.searchParams.set("old_state", !params.old_state ? "pending" : params.old_state);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankWithdrawalOperationStatus());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * FIXME: This is a misnomer!
   *
   * https://docs.taler.net/core/api-bank-integration.html#post-$BANK_API_BASE_URL-withdrawal-operation-$wopid
   */
  async completeWithdrawalOperationById(woid, body) {
    const url = new URL(`withdrawal-operation/${woid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankWithdrawalOperationPostResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const body2 = await readTalerErrorResponse(resp);
        const details = codecForTalerErrorDetail().decode(body2);
        switch (details.code) {
          case TalerErrorCode.BANK_UPDATE_ABORT_CONFLICT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_DUPLICATE_RESERVE_PUB_SUBJECT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNKNOWN_ACCOUNT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_ACCOUNT_IS_NOT_EXCHANGE:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_AMOUNT_DIFFERS:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNALLOWED_DEBIT:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#post-$BANK_API_BASE_URL-withdrawal-operation-$wopid
   *
   */
  async abortWithdrawalOperationById(woid) {
    const url = new URL(`withdrawal-operation/${woid}/abort`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST"
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerBankIntegrationHttpClient.PROTOCOL_VERSION = "5:0:0";

// ../taler-util/lib/types-taler-revenue.js
var codecForRevenueConfig = () => buildCodecForObject().property("name", codecForConstString("taler-revenue")).property("version", codecForString()).property("currency", codecForString()).property("implementation", codecOptional(codecForString())).build("TalerRevenueApi.RevenueConfig");
var codecForRevenueIncomingHistory = () => buildCodecForObject().property("credit_account", codecForPaytoString()).property("incoming_transactions", codecForList(codecForRevenueIncomingBankTransaction())).build("TalerRevenueApi.MerchantIncomingHistory");
var codecForRevenueIncomingBankTransaction = () => buildCodecForObject().property("row_id", codecForNumber()).property("date", codecForTimestamp).property("amount", codecForAmountString()).property("debit_account", codecForPaytoString()).property("subject", codecForString()).build("TalerRevenueApi.RevenueIncomingBankTransaction");

// ../taler-util/lib/http-client/bank-revenue.js
var TalerRevenueHttpClient = class _TalerRevenueHttpClient {
  constructor(baseUrl, httpClient) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-bank-revenue.html#get--config
   *
   */
  async getConfig(auth) {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: createAuthorizationHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-revenue", _TalerRevenueHttpClient.PROTOCOL_VERSION, resp, codecForRevenueConfig());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-revenue.html#get--history
   *
   * @returns
   */
  async getHistory(auth, params) {
    const url = new URL(`history`, this.baseUrl);
    addPaginationParams(url, params);
    addLongPollingParam(url, params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: createAuthorizationHeader(auth)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForRevenueIncomingHistory());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          incoming_transactions: [],
          credit_account: ""
        });
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerRevenueHttpClient.PROTOCOL_VERSION = "1:0:0";

// ../taler-util/lib/types-taler-wire-gateway.js
var codecForWireConfigResponse = () => buildCodecForObject().property("currency", codecForString()).property("implementation", codecForString()).property("name", codecForConstString("taler-wire-gateway")).property("support_account_check", codecForBoolean()).property("version", codecForString()).build("TalerWireGatewayApi.WireConfig");
var codecForTransferResponse = () => buildCodecForObject().property("row_id", codecForNumber()).property("timestamp", codecForTimestamp).build("TalerWireGatewayApi.TransferResponse");
var codecForIncomingHistory = () => buildCodecForObject().property("credit_account", codecForPaytoString()).property("incoming_transactions", codecForList(codecForIncomingBankTransaction())).build("TalerWireGatewayApi.IncomingHistory");
var codecForIncomingBankTransaction = () => buildCodecForUnion().discriminateOn("type").alternative("RESERVE", codecForIncomingReserveTransaction()).alternative("KYCAUTH", codecForIncomingKycAuthTransaction()).alternative("WAD", codecForIncomingWadTransaction()).build("TalerWireGatewayApi.IncomingBankTransaction");
var codecForIncomingReserveTransaction = () => buildCodecForObject().property("amount", codecForAmountString()).property("date", codecForTimestamp).property("debit_account", codecForPaytoString()).property("reserve_pub", codecForEddsaPublicKey()).property("row_id", codecForNumber()).property("type", codecForConstString("RESERVE")).build("TalerWireGatewayApi.IncomingReserveTransaction");
var codecForIncomingKycAuthTransaction = () => buildCodecForObject().property("amount", codecForAmountString()).property("date", codecForTimestamp).property("debit_account", codecForPaytoString()).property("account_pub", codecForEddsaPublicKey()).property("row_id", codecForNumber()).property("type", codecForConstString("KYCAUTH")).build("TalerWireGatewayApi.IncomingKycAuthTransaction");
var codecForIncomingWadTransaction = () => buildCodecForObject().property("amount", codecForAmountString()).property("date", codecForTimestamp).property("debit_account", codecForPaytoString()).property("origin_exchange_url", codecForString()).property("row_id", codecForNumber()).property("type", codecForConstString("WAD")).property("wad_id", codecForString()).build("TalerWireGatewayApi.IncomingWadTransaction");
var codecForOutgoingHistory = () => buildCodecForObject().property("debit_account", codecForPaytoString()).property("outgoing_transactions", codecForList(codecForOutgoingBankTransaction())).build("TalerWireGatewayApi.OutgoingHistory");
var codecForOutgoingBankTransaction = () => buildCodecForObject().property("row_id", codecForNumber()).property("date", codecForTimestamp).property("amount", codecForAmountString()).property("credit_account", codecForPaytoString()).property("wtid", codecForString()).property("exchange_base_url", codecForString()).build("TalerWireGatewayApi.OutgoingBankTransaction");
var codecForAddIncomingResponse = () => buildCodecForObject().property("row_id", codecForNumber()).property("timestamp", codecForTimestamp).build("TalerWireGatewayApi.AddIncomingResponse");
var codecForBankWireTransferList = () => buildCodecForObject().property("debit_account", codecForPaytoString()).property("transfers", codecForList(codecForBankWireTransferListStatus())).build("TalerWireGatewayApi.BankWireTransferList");
var codecForBankWireTransferListStatus = () => buildCodecForObject().property("row_id", codecForNumber()).property("status", codecForEither(codecForConstString("pending"), codecForConstString("transient_failure"), codecForConstString("permanent_failure"), codecForConstString("success"))).property("amount", codecForAmountString()).property("credit_account", codecForPaytoString()).property("timestamp", codecForTimestamp).build("TalerWireGatewayApi.BankWireTransferListStatus");

// ../taler-util/lib/http-client/bank-wire.js
var TalerWireGatewayHttpClient = class _TalerWireGatewayHttpClient {
  constructor(baseUrl, options = {}) {
    this.baseUrl = baseUrl;
    this.httpLib = options.httpClient ?? createPlatformHttpLib();
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get--config
   *
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-wire-gateway", _TalerWireGatewayHttpClient.PROTOCOL_VERSION, resp, codecForWireConfigResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#post--transfer
   *
   */
  async makeWireTransfer(req) {
    const url = new URL(`transfer`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      },
      body: req.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTransferResponse());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get--transfers
   *
   */
  async getTransfers(req) {
    const url = new URL(`transfers`, this.baseUrl);
    if (req.params) {
      if (req.params.status) {
        url.searchParams.set("status", req.params.status);
      }
    }
    addPaginationParams(url, req.params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankWireTransferList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          transfers: [],
          debit_account: void 0
        });
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get--transfers-$ROW_ID
   *
   */
  async getTransferStatus(req) {
    const url = new URL(`transfers/${req.rowId}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankWireTransferList());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get--history-incoming
   *
   */
  async getHistoryIncoming(req) {
    const url = new URL(`history/incoming`, this.baseUrl);
    addPaginationParams(url, req.params);
    addLongPollingParam(url, req.params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForIncomingHistory());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          incoming_transactions: [],
          credit_account: void 0
        });
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get--history-outgoing
   *
   */
  async getHistoryOutgoing(req) {
    const url = new URL(`history/outgoing`, this.baseUrl);
    addPaginationParams(url, req.params);
    addLongPollingParam(url, req.params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForOutgoingHistory());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          outgoing_transactions: [],
          debit_account: void 0
        });
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#post--admin-add-incoming
   *
   */
  async addIncoming(req) {
    const url = new URL(`admin/add-incoming`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      },
      body: req.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAddIncomingResponse());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#post--admin-add-kycauth
   *
   */
  async addKycAuth(req) {
    const url = new URL(`admin/add-kycauth`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        Authorization: makeBasicAuthHeader(req.auth.username, req.auth.password)
      },
      body: req.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAddIncomingResponse());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerWireGatewayHttpClient.PROTOCOL_VERSION = "4:0:0";

// ../taler-util/lib/types-taler-challenger.js
var codecForChallengerTermsOfServiceResponse = () => buildCodecForObject().property("name", codecForConstString("challenger")).property("version", codecForString()).property("implementation", codecOptional(codecForString())).property("restrictions", codecOptional(codecForMap(codecForAny()))).property("address_type", codecForEither(codecForConstString("phone"), codecForConstString("email"), codecForConstString("postal"), codecForConstString("postal-ch"))).build("ChallengerApi.ChallengerTermsOfServiceResponse");
var codecForChallengeSetupResponse = () => buildCodecForObject().property("nonce", codecForString()).build("ChallengerApi.ChallengeSetupResponse");
var codecForChallengeStatus = () => buildCodecForObject().property("fix_address", codecForBoolean()).property("solved", codecForBoolean()).property("last_address", codecOptional(codecForMap(codecForAny()))).property("changes_left", codecForNumber()).property("retransmission_time", codecForTimestamp).property("pin_transmissions_left", codecForNumber()).property("auth_attempts_left", codecForNumber()).build("ChallengerApi.ChallengeStatus");
var codecForChallengeResponse2 = () => buildCodecForUnion().discriminateOn("type").alternative("completed", codecForChallengeRedirect()).alternative("created", codecForChallengeCreateResponse()).build("ChallengerApi.ChallengeResponse");
var codecForChallengeCreateResponse = () => buildCodecForObject().property("attempts_left", codecForNumber()).property("type", codecForConstString("created")).property("nonce", codecOptional(codecForString())).property("address", codecForAny()).property("transmitted", codecForBoolean()).property("retransmission_time", codecForTimestamp).build("ChallengerApi.ChallengeCreateResponse");
var codecForChallengeRedirect = () => buildCodecForObject().property("type", codecForConstString("completed")).property("redirect_url", codecForString()).build("ChallengerApi.ChallengeRedirect");
var codecForChallengeInvalidPinResponse = () => buildCodecForObject().property("ec", codecOptional(codecForNumber())).property("code", codecOptional(codecForNumber())).property("hint", codecForAny()).property("type", codecForConstString("pending")).property("addresses_left", codecForNumber()).property("pin_transmissions_left", codecForNumber()).property("auth_attempts_left", codecForNumber()).property("exhausted", codecForBoolean()).property("no_challenge", codecForBoolean()).build("ChallengerApi.InvalidPinResponse");
var codecForChallengeSolveResponse = () => buildCodecForUnion().discriminateOn("type").alternative("completed", codecForChallengeRedirect()).alternative("pending", codecForChallengeInvalidPinResponse()).build("ChallengerApi.ChallengeSolveResponse");
var codecForChallengerAuthResponse = () => buildCodecForObject().property("access_token", codecForString()).property("token_type", codecForAny()).property("expires_in", codecForNumber()).build("ChallengerApi.ChallengerAuthResponse");
var codecForChallengerInfoResponse = () => buildCodecForObject().property("id", codecForNumber()).property("address", codecForAny()).property("address_type", codecForString()).property("expires", codecForTimestamp).build("ChallengerApi.ChallengerInfoResponse");

// ../taler-util/lib/http-client/challenger.js
var ChallengerCacheEviction;
(function(ChallengerCacheEviction2) {
  ChallengerCacheEviction2[ChallengerCacheEviction2["CREATE_CHALLENGE"] = 0] = "CREATE_CHALLENGE";
  ChallengerCacheEviction2[ChallengerCacheEviction2["SOLVE_CHALLENGE"] = 1] = "SOLVE_CHALLENGE";
})(ChallengerCacheEviction || (ChallengerCacheEviction = {}));
var ChallengerHttpClient = class _ChallengerHttpClient {
  constructor(baseUrl, httpClient, cacheEvictor) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
    this.cacheEvictor = cacheEvictor ?? nullEvictor;
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-challenger.html#get--config
   *
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("challenger", _ChallengerHttpClient.PROTOCOL_VERSION, resp, codecForChallengerTermsOfServiceResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-challenger.html#post--setup-$CLIENT_ID
   *
   */
  async setup(clientId, token, body) {
    const url = new URL(`setup/${clientId}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengeSetupResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // LOGIN
  /**
   * https://docs.taler.net/core/api-challenger.html#post--authorize-$NONCE
   *
   */
  async login(nonce, clientId, redirectUri, state) {
    const url = new URL(`authorize/${nonce}`, this.baseUrl);
    url.searchParams.set("response_type", "code");
    url.searchParams.set("client_id", clientId);
    url.searchParams.set("redirect_uri", redirectUri);
    if (state) {
      url.searchParams.set("state", state);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengeStatus());
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotAcceptable:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.TooManyRequests:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.InternalServerError:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // CHALLENGE
  /**
   * https://docs.taler.net/core/api-challenger.html#post--challenge-$NONCE
   *
   */
  async challenge(nonce, body) {
    const url = new URL(`challenge/${nonce}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        await this.cacheEvictor.notifySuccess(ChallengerCacheEviction.CREATE_CHALLENGE);
        return opSuccessFromHttp(resp, codecForChallengeResponse2());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotAcceptable:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.TooManyRequests:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.InternalServerError:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // SOLVE
  /**
   * https://docs.taler.net/core/api-challenger.html#post--solve-$NONCE
   *
   */
  async solve(nonce, body) {
    const url = new URL(`solve/${nonce}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body: new URLSearchParams(Object.entries(body)).toString(),
      headers: {
        "Content-Type": "application/x-www-form-urlencoded"
      },
      redirect: "manual"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        await this.cacheEvictor.notifySuccess(ChallengerCacheEviction.SOLVE_CHALLENGE);
        return opSuccessFromHttp(resp, codecForChallengeSolveResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownAlternativeHttpFailure(resp, HttpStatusCode.Forbidden, codecForChallengeInvalidPinResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotAcceptable:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.TooManyRequests:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.InternalServerError:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // AUTH
  /**
   * https://docs.taler.net/core/api-challenger.html#post--token
   *
   */
  async token(client_id, redirect_uri, client_secret, code) {
    const url = new URL(`token`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers: {
        "Content-Type": "application/x-www-form-urlencoded"
      },
      body: new URLSearchParams(Object.entries({
        client_id,
        redirect_uri,
        client_secret,
        code,
        grant_type: "authorization_code"
      })).toString()
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengerAuthResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // INFO
  /**
   * https://docs.taler.net/core/api-challenger.html#get--info
   *
   */
  async info(token) {
    const url = new URL(`info`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengerInfoResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
ChallengerHttpClient.PROTOCOL_VERSION = "2:0:0";

// ../taler-util/lib/types-donau.js
var codecForDonauVersionResponse = () => buildCodecForObject().property("version", codecForString()).property("name", codecForConstString("donau")).property("currency", codecForString()).property("legal_domain", codecForString()).build("DonauApi.DonauVersionResponse");
var codecForDonationUnitKeyGroup = codecForAny();
var codecForDonauKeysResponse = () => buildCodecForObject().property("version", codecForString()).property("base_url", codecForString()).property("currency", codecForString()).property("signkeys", codecForAny()).property("donation_units", codecForList(codecForDonationUnitKeyGroup)).build("DonauApi.DonauKeysResponse");
var codecForIssuePrepareResponse = () => buildCodecForUnion().discriminateOn("cipher").alternative("CS", codecForAny()).alternative("RSA", codecForAny()).build("DonauApi.IssuePrepareResponse");
var codecForDonauCharityResponse = () => buildCodecForObject().property("charity_id", codecForNumber()).build("DonauApi.DonauCharityResponse");
var codecForDonauDonationStatementResponse = () => buildCodecForObject().property("total", codecForAmountString()).property("donau_pub", codecForEddsaPublicKey()).property("donation_statement_sig", codecForEddsaSignature()).build("DonauApi.DonationStatementResponse");

// ../taler-util/lib/http-client/donau-client.js
var DonauHttpClient = class _DonauHttpClient {
  constructor(baseUrl, params = {}) {
    this.baseUrl = baseUrl;
    this.httpLib = params.httpClient ?? createPlatformHttpLib();
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(_DonauHttpClient.SUPPORTED_DONAU_PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--keys
   *
   * @returns
   */
  async getKeys() {
    const url = new URL(`keys`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForDonauKeysResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--seed
   *
   */
  async getSeed() {
    const url = new URL(`keys`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        const buffer = await resp.bytes();
        const uintar = new Uint8Array(buffer);
        return opFixedSuccess(uintar);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--config
   *
   * @returns
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("donau", _DonauHttpClient.SUPPORTED_DONAU_PROTOCOL_VERSION, resp, codecForDonauVersionResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#csr-issue
   *
   * @param args
   * @returns
   */
  async prepareIssueReceipt(body) {
    const url = new URL(`csr-issue`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForIssuePrepareResponse());
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      case HttpStatusCode.Gone:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#post--batch-issue-$CHARITY_ID
   *
   * @param args
   * @returns
   */
  async issueReceipts(charityId, body) {
    const url = new URL(`batch-issue/${charityId}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      case HttpStatusCode.Conflict:
        return opKnownFailure(resp.status);
      case HttpStatusCode.Gone:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#post--batch-submit
   *
   * @param args
   * @returns
   */
  async submitDonationReceipts(body) {
    const url = new URL(`batch-submit`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Created:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--donation-statement-$YEAR-$HASH_DONOR_ID
   *
   * @param args
   * @returns
   */
  async getDonationStatement(year, hash3) {
    const url = new URL(`donation-statement/${year}/${hash3}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForDonauDonationStatementResponse());
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--charities
   *
   * @param args
   * @returns
   */
  async getCharities(token) {
    const url = new URL(`charities`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          charities: []
        });
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#get--charities-$CHARITY_ID
   */
  async getCharitiesById(token, id) {
    const url = new URL(`charities/${id}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#post--charities
   *
   * @param args
   * @returns
   */
  async createCharity(token, body) {
    const url = new URL(`charities`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Created:
        return opSuccessFromHttp(resp, codecForDonauCharityResponse());
      case HttpStatusCode.NoContent:
        return opKnownFailure(resp.status);
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#patch--charities-id
   *
   * @returns
   */
  async updateCharity(token, id, body) {
    const url = new URL(`charities/${id}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-donau.html#patch--charities-id
   *
   * @returns
   */
  async deleteCharity(token, id) {
    const url = new URL(`charities/${id}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
        return opKnownFailure(resp.status);
      case HttpStatusCode.NotFound:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
DonauHttpClient.SUPPORTED_DONAU_PROTOCOL_VERSION = "0:0:0";

// ../taler-util/lib/http-client/exchange-client.js
var TalerExchangeCacheEviction;
(function(TalerExchangeCacheEviction2) {
  TalerExchangeCacheEviction2[TalerExchangeCacheEviction2["UPLOAD_KYC_FORM"] = 0] = "UPLOAD_KYC_FORM";
  TalerExchangeCacheEviction2[TalerExchangeCacheEviction2["MAKE_AML_DECISION"] = 1] = "MAKE_AML_DECISION";
})(TalerExchangeCacheEviction || (TalerExchangeCacheEviction = {}));
var TalerExchangeHttpClient = class _TalerExchangeHttpClient {
  constructor(baseUrl, params = {}) {
    this.baseUrl = baseUrl;
    this.httpLib = params.httpClient ?? createPlatformHttpLib();
    this.cacheEvictor = params.cacheEvictor ?? nullEvictor;
    this.preventCompression = !!params.preventCompression;
    this.cancelationToken = params.cancelationToken ?? CancellationToken.CONTINUE;
    this.longPollQueue = params.longPollQueue ?? new LongpollQueue();
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(_TalerExchangeHttpClient.SUPPORTED_EXCHANGE_PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  async fetch(url_or_path, opts = {}, longpoll = false) {
    const url = typeof url_or_path == "string" ? new URL(url_or_path, this.baseUrl) : url_or_path;
    if (longpoll || url.searchParams.has("timeout_ms")) {
      return this.longPollQueue.run(url, this.cancelationToken, async (timeoutMs) => {
        url.searchParams.set("timeout_ms", String(timeoutMs));
        return this.httpLib.fetch(url.href, {
          cancellationToken: this.cancelationToken,
          ...opts
        });
      });
    } else {
      return this.httpLib.fetch(url.href, {
        cancellationToken: this.cancelationToken,
        ...opts
      });
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--seed
   *
   */
  async getSeed() {
    const resp = await this.fetch("seed");
    switch (resp.status) {
      case HttpStatusCode.Ok:
        const buffer = await resp.bytes();
        const uintar = new Uint8Array(buffer);
        return opFixedSuccess(uintar);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--config
   *
   */
  async getConfig() {
    const resp = await this.fetch("config");
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-exchange", _TalerExchangeHttpClient.SUPPORTED_EXCHANGE_PROTOCOL_VERSION, resp, codecForExchangeConfig());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get--config
   *
   * PARTIALLY IMPLEMENTED!!
   */
  async getKeys() {
    const resp = await this.fetch("keys");
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeKeysResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // WALLET TO WALLET
  /**
   * https://docs.taler.net/core/api-exchange.html#get--purses-$PURSE_PUB-merge
   *
   */
  async getPurseStatusAtMerge(pursePub, longpoll = false) {
    const resp = await this.fetch(`purses/${pursePub}/merge`, {}, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangePurseStatus());
      case HttpStatusCode.Gone:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--purses-$PURSE_PUB-deposit
   *
   */
  async getPurseStatusAtDeposit(pursePub, longpoll = false) {
    const resp = await this.fetch(`purses/${pursePub}/deposit`, {}, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangePurseStatus());
      case HttpStatusCode.Gone:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--purses-$PURSE_PUB-create
   *
   */
  async createPurseFromDeposit(pursePub, body) {
    const resp = await this.fetch(`purses/${pursePub}/create`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPurseConflict());
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.TooEarly:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#delete--purses-$PURSE_PUB
   *
   */
  async deletePurse(pursePub, purseSig) {
    const resp = await this.fetch(`purses/${pursePub}`, {
      method: "DELETE",
      headers: {
        "taler-purse-signature": purseSig
      }
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * POST /purses/$PURSE_PUB/merge
   *
   * https://docs.taler.net/core/api-exchange.html#post--purses-$PURSE_PUB-merge
   */
  async postPurseMerge(pursePub, body) {
    const resp = await this.fetch(`purses/${pursePub}/merge`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeMergeSuccessResponse());
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForLegitimizationNeededResponse());
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForExchangeMergeConflictResponse());
      case HttpStatusCode.Gone:
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--reserves-$RESERVE_PUB-purse
   *
   */
  async createPurseFromReserve(pursePub, body) {
    const resp = await this.fetch(`reserves/${pursePub}/purse`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.PaymentRequired:
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPurseConflictPartial());
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForLegitimizationNeededResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--contracts-$CONTRACT_PUB
   *
   */
  async getContract(pursePub) {
    const resp = await this.fetch(`contracts/${pursePub}`);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeGetContractResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--purses-$PURSE_PUB-deposit
   *
   */
  async depositIntoPurse(pursePub, body) {
    const resp = await this.fetch(`purses/${pursePub}/deposit`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPurseConflict());
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Gone:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // WADS
  /**
   * https://docs.taler.net/core/api-exchange.html#get--wads-$WAD_ID
   *
   */
  async getWadInfo() {
    throw Error("not yet implemented");
  }
  //
  // KYC
  //
  /**
   * https://docs.taler.net/core/api-exchange.html#post--kyc-wallet
   *
   */
  async notifyKycBalanceLimit(body) {
    const url = new URL(`kyc-wallet`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlWalletKycCheckResponse());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForLegitimizationNeededResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--kyc-check-$H_NORMALIZED_PAYTO
   *
   */
  async checkKycStatus(args) {
    const { paytoHash, accountPub, accountSig, longpoll, awaitAuth } = args;
    const url = new URL(`kyc-check/${paytoHash}`, this.baseUrl);
    if (awaitAuth !== void 0) {
      url.searchParams.set("await_auth", awaitAuth ? "YES" : "NO");
    }
    const resp = await this.fetch(url, {
      headers: {
        "Account-Owner-Signature": accountSig,
        "Account-Owner-Pub": accountPub
      }
    }, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForAccountKycStatus());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * Do a /kyc-check request, but don't specify
   * the account pub explicitly.
   *
   * Deprecated, but used in tests.
   */
  async testingCheckKycStatusNoPub(args) {
    const { paytoHash, accountSig, longpoll, awaitAuth } = args;
    const url = new URL(`kyc-check/${paytoHash}`, this.baseUrl);
    if (awaitAuth !== void 0) {
      url.searchParams.set("await_auth", awaitAuth ? "YES" : "NO");
    }
    const resp = await this.fetch(url, {
      headers: {
        "Account-Owner-Signature": accountSig
      }
    }, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForAccountKycStatus());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--kyc-info-$ACCESS_TOKEN
   *
   */
  async checkKycInfo(token, known = [], longpoll = false) {
    const resp = await this.fetch(`kyc-info/${token}`, {
      method: "GET",
      headers: {
        "If-None-Match": known.length ? known.join(",") : void 0
      }
    }, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForKycProcessClientInformation());
      case HttpStatusCode.Accepted:
      case HttpStatusCode.NoContent:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForEmptyObject());
      case HttpStatusCode.NotModified:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * SPA-Specific version of checkKycInfo
   */
  async checkKycInfoSpa(token, etag, params = {}) {
    const url = new URL(`kyc-info/${token}`, this.baseUrl);
    addLongPollingParam(url, params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        "If-None-Match": etag
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        const etag2 = resp.headers.get("etag") ?? void 0;
        const body = await readSuccessResponseJsonOrThrow(resp, codecForKycProcessClientInformation());
        return opFixedSuccess({
          ...body,
          etag: etag2
        });
      }
      case HttpStatusCode.Accepted:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NoContent:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotModified:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--kyc-upload-$ID
   *
   */
  async uploadKycForm(requirement, body) {
    const resp = await this.fetch(`kyc-upload/${requirement}`, {
      method: "POST",
      body,
      compress: this.preventCompression ? void 0 : "deflate"
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerExchangeCacheEviction.UPLOAD_KYC_FORM);
        return opEmptySuccess();
      }
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
      case HttpStatusCode.PayloadTooLarge:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--kyc-start-$ID
   *
   */
  async startExternalKycProcess(requirement, body = {}) {
    const resp = await this.fetch(`kyc-start/${requirement}`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForKycProcessStartInformation());
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
      case HttpStatusCode.PayloadTooLarge:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--kyc-proof-$PROVIDER_NAME?state=$H_PAYTO
   *
   */
  async completeExternalKycProcess(provider, state, code) {
    const resp = await this.fetch(`kyc-proof/${provider}?state=${state}&code=${code}`, {
      method: "GET",
      redirect: "manual"
    });
    switch (resp.status) {
      case HttpStatusCode.SeeOther:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // AML operations
  //
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-measures
   *
   */
  async getAmlMeasures(auth) {
    const resp = await this.fetch(`aml/${auth.id}/measures`, {
      method: "GET",
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAvailableMeasureSummary());
      case HttpStatusCode.Conflict:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-kyc-statistics-$NAMES
   *
   */
  async getAmlKycStatistics(auth, names2, filter = {}) {
    const url = new URL(`aml/${auth.id}/kyc-statistics/${names2.join(" ")}`, this.baseUrl);
    if (filter.since !== void 0 && filter.since.t_ms !== "never") {
      url.searchParams.set("start_date", String(filter.since.t_ms));
    }
    if (filter.until !== void 0 && filter.until.t_ms !== "never") {
      url.searchParams.set("end_date", String(filter.until.t_ms));
    }
    const resp = await this.fetch(url, {
      method: "GET",
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlStatisticsResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ statistics: [] });
      case HttpStatusCode.Conflict:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-decisions
   *
   */
  async getAmlDecisions(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/decisions`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.account !== void 0) {
      url.searchParams.set("h_payto", params.account);
    }
    if (params.active !== void 0) {
      url.searchParams.set("active", params.active ? "YES" : "NO");
    }
    if (params.investigation !== void 0) {
      url.searchParams.set("investigation", params.investigation ? "YES" : "NO");
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlDecisionsResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ records: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-legitimizations
   */
  async getAmlLegitimizations(officer, params = {}) {
    const url = new URL(`aml/${officer.id}/legitimizations`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.account !== void 0) {
      url.searchParams.set("h_payto", params.account);
    }
    if (params.active !== void 0) {
      url.searchParams.set("active", params.active ? "YES" : "NO");
    }
    const resp = await this.httpLib.fetch(url.href, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(officer.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForLegitimizationMeasuresList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          measures: []
        });
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-attributes-$H_PAYTO
   *
   */
  async getAmlAttributesForAccount(auth, account, params = {}) {
    const url = new URL(`aml/${auth.id}/attributes/${account}`, this.baseUrl);
    addPaginationParams(url, params);
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlKycAttributes());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ details: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--aml-$OFFICER_PUB-decision
   *
   */
  async makeAmlDesicion(auth, decision) {
    const body = {
      officer_sig: encodeCrock(signAmlDecision(auth.signingKey, decision)),
      ...decision
    };
    const resp = await this.fetch(`aml/${auth.id}/decision`, {
      method: "POST",
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      },
      body,
      compress: this.preventCompression ? void 0 : "deflate"
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerExchangeCacheEviction.MAKE_AML_DECISION);
        return opEmptySuccess();
      }
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-transfers-credit
   *
   */
  async getTransfersCredit(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/transfers-credit`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.threshold) {
      url.searchParams.set("threshold", Amounts.stringify(params.threshold));
    }
    if (params.account) {
      url.searchParams.set("h_payto", params.account);
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeTransferList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ transfers: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-transfers-debit
   *
   */
  async getTransfersDebit(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/transfers-debit`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.threshold) {
      url.searchParams.set("threshold", Amounts.stringify(params.threshold));
    }
    if (params.account) {
      url.searchParams.set("h_payto", params.account);
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeTransferList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ transfers: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-transfers-kycauth
   *
   */
  async getTransfersKycAuth(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/transfers-kycauth`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.threshold) {
      url.searchParams.set("threshold", Amounts.stringify(params.threshold));
    }
    if (params.account) {
      url.searchParams.set("h_payto", params.account);
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeTransferList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ transfers: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * Request: POST /withdraw
   *
   * https://docs.taler.net/core/api-exchange.html#withdrawal
   */
  async withdraw(args) {
    const url = new URL(`withdraw`, this.baseUrl);
    const resp = await this.fetch(url, {
      method: "POST",
      body: args.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeWithdrawResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * Request: POST /melt
   *
   * https://docs.taler.net/core/api-exchange.html#post--melt
   */
  async postMelt(args) {
    const url = new URL(`melt`, this.baseUrl);
    const resp = await this.fetch(url, {
      method: "POST",
      body: args.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeMeltResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  async postRevealMelt(args) {
    const url = new URL(`reveal-melt`, this.baseUrl);
    const resp = await this.fetch(url, {
      method: "POST",
      body: args.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeWithdrawResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerExchangeHttpClient.SUPPORTED_EXCHANGE_PROTOCOL_VERSION = "27:0:2";

// ../taler-util/lib/http-client/merchant.js
var TalerMerchantInstanceCacheEviction;
(function(TalerMerchantInstanceCacheEviction2) {
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["CREATE_ORDER"] = 0] = "CREATE_ORDER";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["UPDATE_ORDER"] = 1] = "UPDATE_ORDER";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["DELETE_ORDER"] = 2] = "DELETE_ORDER";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["UPDATE_CURRENT_INSTANCE"] = 3] = "UPDATE_CURRENT_INSTANCE";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["DELETE_CURRENT_INSTANCE"] = 4] = "DELETE_CURRENT_INSTANCE";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["CREATE_BANK_ACCOUNT"] = 5] = "CREATE_BANK_ACCOUNT";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["UPDATE_BANK_ACCOUNT"] = 6] = "UPDATE_BANK_ACCOUNT";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["DELETE_BANK_ACCOUNT"] = 7] = "DELETE_BANK_ACCOUNT";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["CREATE_PRODUCT"] = 8] = "CREATE_PRODUCT";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["UPDATE_PRODUCT"] = 9] = "UPDATE_PRODUCT";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["DELETE_PRODUCT"] = 10] = "DELETE_PRODUCT";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["CREATE_CATEGORY"] = 11] = "CREATE_CATEGORY";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["UPDATE_CATEGORY"] = 12] = "UPDATE_CATEGORY";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["DELETE_CATEGORY"] = 13] = "DELETE_CATEGORY";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["CREATE_TRANSFER"] = 14] = "CREATE_TRANSFER";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["DELETE_TRANSFER"] = 15] = "DELETE_TRANSFER";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["CREATE_DEVICE"] = 16] = "CREATE_DEVICE";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["UPDATE_DEVICE"] = 17] = "UPDATE_DEVICE";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["DELETE_DEVICE"] = 18] = "DELETE_DEVICE";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["CREATE_TEMPLATE"] = 19] = "CREATE_TEMPLATE";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["UPDATE_TEMPLATE"] = 20] = "UPDATE_TEMPLATE";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["DELETE_TEMPLATE"] = 21] = "DELETE_TEMPLATE";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["CREATE_WEBHOOK"] = 22] = "CREATE_WEBHOOK";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["UPDATE_WEBHOOK"] = 23] = "UPDATE_WEBHOOK";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["DELETE_WEBHOOK"] = 24] = "DELETE_WEBHOOK";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["CREATE_TOKENFAMILY"] = 25] = "CREATE_TOKENFAMILY";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["UPDATE_TOKENFAMILY"] = 26] = "UPDATE_TOKENFAMILY";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["DELETE_TOKENFAMILY"] = 27] = "DELETE_TOKENFAMILY";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["CREATE_ACCESSTOKEN"] = 28] = "CREATE_ACCESSTOKEN";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["DELETE_ACCESSTOKEN"] = 29] = "DELETE_ACCESSTOKEN";
  TalerMerchantInstanceCacheEviction2[TalerMerchantInstanceCacheEviction2["LAST"] = 30] = "LAST";
})(TalerMerchantInstanceCacheEviction || (TalerMerchantInstanceCacheEviction = {}));
var TalerMerchantManagementCacheEviction;
(function(TalerMerchantManagementCacheEviction2) {
  TalerMerchantManagementCacheEviction2[TalerMerchantManagementCacheEviction2["CREATE_INSTANCE"] = 31] = "CREATE_INSTANCE";
  TalerMerchantManagementCacheEviction2[TalerMerchantManagementCacheEviction2["UPDATE_INSTANCE"] = 32] = "UPDATE_INSTANCE";
  TalerMerchantManagementCacheEviction2[TalerMerchantManagementCacheEviction2["DELETE_INSTANCE"] = 33] = "DELETE_INSTANCE";
})(TalerMerchantManagementCacheEviction || (TalerMerchantManagementCacheEviction = {}));
var TalerMerchantInstanceHttpClient = class _TalerMerchantInstanceHttpClient {
  constructor(baseUrl, httpClient, cacheEvictor, cancellationToken) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient ?? createPlatformHttpLib();
    this.cacheEvictor = cacheEvictor ?? nullEvictor;
    this.cancellationToken = cancellationToken;
  }
  static isCompatible(version) {
    const compare2 = LibtoolVersion.compare(_TalerMerchantInstanceHttpClient.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get--config
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return carefullyParseConfig("taler-merchant", _TalerMerchantInstanceHttpClient.PROTOCOL_VERSION, resp, codecForTalerMerchantConfigResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Auth
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-token
   *
   */
  async createAccessToken(instance, password, body, params = {}) {
    const url = new URL(`private/token`, this.baseUrl);
    const headers = {};
    headers.Authorization = makeBasicAuthHeader2(instance, password);
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_ACCESSTOKEN);
        return opSuccessFromHttp(resp, codecForLoginTokenSuccessResponse());
      }
      case HttpStatusCode.Accepted: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-tokens
   *
   */
  async listAccessTokens(token, params = {}) {
    const url = new URL(`private/tokens`, this.baseUrl);
    addPaginationParams(url, params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        Authorization: makeBearerTokenAuthHeader(token)
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTokenInfoList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ tokens: [] });
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-tokens-$SERIAL
   *
   */
  async deleteAccessToken(token, serial) {
    const url = new URL(`private/tokens/${String(serial)}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_ACCESSTOKEN);
        return opEmptySuccess();
      }
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Wallet API
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-orders-$ORDER_ID-claim
   */
  async claimOrder(args) {
    const { orderId, body } = args;
    const url = new URL(`orders/${orderId}/claim`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      cancellationToken: this.cancellationToken
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForClaimResponse());
      }
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-orders-$ORDER_ID-pay
   */
  async makePayment(orderId, body) {
    const url = new URL(`orders/${orderId}/pay`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForPaymentResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.PaymentRequired:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.RequestTimeout:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Gone:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.PreconditionFailed:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.BadGateway:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.GatewayTimeout:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPaymentDeniedLegallyResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-orders-$ORDER_ID
   */
  async getPaymentStatus(orderId, params = {}) {
    const url = new URL(`orders/${orderId}`, this.baseUrl);
    if (params.allowRefundedForRepurchase !== void 0) {
      url.searchParams.set("allow_refunded_for_repurchase", params.allowRefundedForRepurchase ? "YES" : "NO");
    }
    if (params.awaitRefundObtained !== void 0) {
      url.searchParams.set("await_refund_obtained", params.allowRefundedForRepurchase ? "YES" : "NO");
    }
    if (params.claimToken !== void 0) {
      url.searchParams.set("token", params.claimToken);
    }
    if (params.contractTermHash !== void 0) {
      url.searchParams.set("h_contract", params.contractTermHash);
    }
    if (params.refund !== void 0) {
      url.searchParams.set("refund", params.refund);
    }
    if (params.sessionId !== void 0) {
      url.searchParams.set("session_id", params.sessionId);
    }
    if (params.timeout !== void 0) {
      url.searchParams.set("timeout_ms", String(params.timeout));
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
      // body,
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForStatusPaid());
      case HttpStatusCode.Accepted:
        return opSuccessFromHttp(resp, codecForStatusGoto());
      case HttpStatusCode.PaymentRequired:
        return opSuccessFromHttp(resp, codecForStatusStatusUnpaid());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotAcceptable:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#demonstrating-payment
   */
  async demostratePayment(orderId, body) {
    const url = new URL(`orders/${orderId}/paid`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForPaidRefundStatusResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#aborting-incomplete-payments
   */
  async abortIncompletePayment(orderId, body) {
    const url = new URL(`orders/${orderId}/abort`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForAbortResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#obtaining-refunds
   */
  async obtainRefund(orderId, body) {
    const url = new URL(`orders/${orderId}/refund`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForWalletRefundResponse());
      }
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPaymentDeniedLegallyResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Management
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-auth
   */
  async updateCurrentInstanceAuthentication(token, body, params = {}) {
    const url = new URL(`private/auth`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opEmptySuccess();
      case HttpStatusCode.Accepted: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      }
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCE]-private
   */
  async updateCurrentInstance(token, body, params = {}) {
    const url = new URL(`private`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_CURRENT_INSTANCE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Accepted: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private
   *
   */
  async getCurrentInstanceDetails(token) {
    const url = new URL(`private`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForQueryInstancesResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private
   */
  async deleteCurrentInstance(token, params = {}) {
    const url = new URL(`private`, this.baseUrl);
    if (params.purge !== void 0) {
      url.searchParams.set("purge", params.purge ? "YES" : "NO");
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_CURRENT_INSTANCE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get--instances-$INSTANCE-private-kyc
   */
  async getCurrentInstanceKycStatus(token, params = {}) {
    const url = new URL(`private/kyc`, this.baseUrl);
    if (params.wireHash) {
      url.searchParams.set("h_wire", params.wireHash);
    }
    if (params.exchangeURL) {
      url.searchParams.set("exchange_url", params.exchangeURL);
    }
    if (params.timeout) {
      url.searchParams.set("timeout_ms", String(params.timeout));
    }
    if (params.reason) {
      url.searchParams.set("lpt", String(params.reason));
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAccountKycRedirects());
      case HttpStatusCode.Accepted:
        return opSuccessFromHttp(resp, codecForAccountKycRedirects());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.BadGateway:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForAccountKycRedirects());
      case HttpStatusCode.ServiceUnavailable:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.GatewayTimeout:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Bank Accounts
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-accounts
   */
  async addBankAccount(token, body, params = {}) {
    const url = new URL(`private/accounts`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_BANK_ACCOUNT);
        return opSuccessFromHttp(resp, codecForAccountAddResponse());
      }
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCE]-private-accounts-$H_WIRE
   */
  async updateBankAccount(token, wireAccount, body) {
    const url = new URL(`private/accounts/${wireAccount}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_BANK_ACCOUNT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-accounts
   */
  async listBankAccounts(token, params) {
    const url = new URL(`private/accounts`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAccountsSummaryResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-accounts-$H_WIRE
   */
  async getBankAccountDetails(token, wireAccount) {
    const url = new URL(`private/accounts/${wireAccount}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankAccountDetail());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-accounts-$H_WIRE
   */
  async deleteBankAccount(token, wireAccount) {
    const url = new URL(`private/accounts/${wireAccount}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_BANK_ACCOUNT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Inventory Management
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-categories
   */
  async listCategories(token, params) {
    const url = new URL(`private/categories`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCategoryListResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-categories-$CATEGORY_ID
   */
  async getCategoryDetails(token, cId) {
    const url = new URL(`private/categories/${cId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForCategoryProductList());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-categories
   */
  async addCategory(token, body) {
    const url = new URL(`private/categories`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_CATEGORY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-categories
   */
  async updateCategory(token, cid, body) {
    const url = new URL(`private/categories/${cid}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_CATEGORY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-categories-$CATEGORY_ID
   */
  async deleteCategory(token, cId) {
    const url = new URL(`private/categories/${cId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_CATEGORY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-products
   */
  async addProduct(token, body) {
    const url = new URL(`private/products`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_PRODUCT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCE]-private-products-$PRODUCT_ID
   */
  async updateProduct(token, productId, body) {
    const url = new URL(`private/products/${productId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_PRODUCT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-products
   */
  async listProducts(token, params) {
    const url = new URL(`private/products`, this.baseUrl);
    addPaginationParams(url, params);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForInventorySummaryResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-pos
   */
  async getPointOfSaleInventory(token) {
    const url = new URL(`private/pos`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForMerchantPosProductDetail());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-products-$PRODUCT_ID
   */
  async getProductDetails(token, productId) {
    const url = new URL(`private/products/${productId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForProductDetail());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-products-$PRODUCT_ID-lock
   */
  async lockProduct(token, productId, body) {
    const url = new URL(`private/products/${productId}/lock`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_PRODUCT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Gone:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-products-$PRODUCT_ID
   */
  async deleteProduct(token, productId) {
    const url = new URL(`private/products/${productId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_PRODUCT);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Payment processing
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-orders
   */
  async createOrder(token, body) {
    const url = new URL(`private/orders`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    return this.procesOrderCreationResponse(resp);
  }
  async procesOrderCreationResponse(resp) {
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_ORDER);
        return opSuccessFromHttp(resp, codecForPostOrderResponse());
      }
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPaymentDeniedLegallyResponse());
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Gone:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForOutOfStockResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#inspecting-orders
   */
  async listOrders(token, params = {}) {
    const url = new URL(`private/orders`, this.baseUrl);
    if (params.date) {
      url.searchParams.set("date_s", String(params.date));
    }
    if (params.fulfillmentUrl) {
      url.searchParams.set("fulfillment_url", params.fulfillmentUrl);
    }
    if (params.paid !== void 0) {
      url.searchParams.set("paid", params.paid ? "YES" : "NO");
    }
    if (params.refunded !== void 0) {
      url.searchParams.set("refunded", params.refunded ? "YES" : "NO");
    }
    if (params.sessionId) {
      url.searchParams.set("session_id", params.sessionId);
    }
    if (params.timeout) {
      url.searchParams.set("timeout", String(params.timeout));
    }
    if (params.wired !== void 0) {
      url.searchParams.set("wired", params.wired ? "YES" : "NO");
    }
    addPaginationParams(url, params);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForOrderHistory());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-orders-$ORDER_ID
   */
  async getOrderDetails(token, orderId, params = {}) {
    const url = new URL(`private/orders/${orderId}`, this.baseUrl);
    if (params.allowRefundedForRepurchase !== void 0) {
      url.searchParams.set("allow_refunded_for_repurchase", params.allowRefundedForRepurchase ? "YES" : "NO");
    }
    if (params.sessionId) {
      url.searchParams.set("session_id", params.sessionId);
    }
    if (params.timeout) {
      url.searchParams.set("timeout_ms", String(params.timeout));
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForMerchantOrderPrivateStatusResponse());
      case HttpStatusCode.NotFound: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_GENERIC_ORDER_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.MERCHANT_GENERIC_INSTANCE_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#private-order-data-cleanup
   */
  async forgetOrder(token, orderId, body) {
    const url = new URL(`private/orders/${orderId}/forget`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opEmptySuccess();
      }
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.BadRequest:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-orders-$ORDER_ID
   */
  async deleteOrder(token, orderId, force = false) {
    const url = new URL(`private/orders/${orderId}`, this.baseUrl);
    if (force) {
      url.searchParams.set("force", "yes");
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_ORDER);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Refunds
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-orders-$ORDER_ID-refund
   */
  async addRefund(token, orderId, body) {
    const url = new URL(`private/orders/${orderId}/refund`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_ORDER);
        return opSuccessFromHttp(resp, codecForMerchantRefundResponse());
      }
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Gone:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPaymentDeniedLegallyResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Wire Transfer
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-transfers
   */
  async informWireTransfer(token, body) {
    const url = new URL(`private/transfers`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_TRANSFER);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-transfers
   */
  async listWireTransfers(token, params = {}) {
    const url = new URL(`private/transfers`, this.baseUrl);
    if (params.after) {
      url.searchParams.set("after", String(params.after));
    }
    if (params.before) {
      url.searchParams.set("before", String(params.before));
    }
    if (params.paytoURI) {
      url.searchParams.set("payto_uri", params.paytoURI);
    }
    if (params.verified !== void 0) {
      url.searchParams.set("verified", params.verified ? "YES" : "NO");
    }
    addPaginationParams(url, params);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTansferList());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-transfers-$TID
   */
  async deleteWireTransfer(token, transferId) {
    const url = new URL(`private/transfers/${transferId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_TRANSFER);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // OTP Devices
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-otp-devices
   */
  async addOtpDevice(token, body) {
    const url = new URL(`private/otp-devices`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_DEVICE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCE]-private-otp-devices-$DEVICE_ID
   */
  async updateOtpDevice(token, deviceId, body) {
    const url = new URL(`private/otp-devices/${deviceId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_DEVICE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-otp-devices
   */
  async listOtpDevices(token, params) {
    const url = new URL(`private/otp-devices`, this.baseUrl);
    addPaginationParams(url, params);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForOtpDeviceSummaryResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-otp-devices-$DEVICE_ID
   */
  async getOtpDeviceDetails(token, deviceId, params = {}) {
    const url = new URL(`private/otp-devices/${deviceId}`, this.baseUrl);
    if (params.faketime) {
      url.searchParams.set("faketime", String(params.faketime));
    }
    if (params.price) {
      url.searchParams.set("price", params.price);
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForOtpDeviceDetails());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-otp-devices-$DEVICE_ID
   */
  async deleteOtpDevice(token, deviceId) {
    const url = new URL(`private/otp-devices/${deviceId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_DEVICE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // Templates
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-templates
   */
  async addTemplate(token, body) {
    const url = new URL(`private/templates`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_TEMPLATE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCE]-private-templates-$TEMPLATE_ID
   */
  async updateTemplate(token, templateId, body) {
    const url = new URL(`private/templates/${templateId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_TEMPLATE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#inspecting-template
   */
  async listTemplates(token, params) {
    const url = new URL(`private/templates`, this.baseUrl);
    addPaginationParams(url, params);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTemplateSummaryResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-private-templates-$TEMPLATE_ID
   */
  async getTemplateDetails(token, templateId) {
    const url = new URL(`private/templates/${templateId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTemplateDetails());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-templates-$TEMPLATE_ID
   */
  async deleteTemplate(token, templateId) {
    const url = new URL(`private/templates/${templateId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_TEMPLATE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCE]-templates-$TEMPLATE_ID
   */
  async useTemplateGetInfo(templateId) {
    const url = new URL(`templates/${templateId}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForWalletTemplateDetails());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCES]-templates-$TEMPLATE_ID
   */
  async useTemplateCreateOrder(templateId, body) {
    const url = new URL(`templates/${templateId}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    return this.procesOrderCreationResponse(resp);
  }
  //
  // Webhooks
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCES]-private-webhooks
   */
  async addWebhook(token, body) {
    const url = new URL(`private/webhooks`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_WEBHOOK);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCES]-private-webhooks-$WEBHOOK_ID
   */
  async updateWebhook(token, webhookId, body) {
    const url = new URL(`private/webhooks/${webhookId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_WEBHOOK);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCES]-private-webhooks
   */
  async listWebhooks(token, params) {
    const url = new URL(`private/webhooks`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForWebhookSummaryResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCES]-private-webhooks-$WEBHOOK_ID
   */
  async getWebhookDetails(token, webhookId) {
    const url = new URL(`private/webhooks/${webhookId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForWebhookDetails());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCES]-private-webhooks-$WEBHOOK_ID
   */
  async deleteWebhook(token, webhookId) {
    const url = new URL(`private/webhooks/${webhookId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_WEBHOOK);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // token families
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCES]-private-tokenfamilies
   */
  async createTokenFamily(token, body) {
    const url = new URL(`private/tokenfamilies`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_TOKENFAMILY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch-[-instances-$INSTANCES]-private-tokenfamilies-$TOKEN_FAMILY_SLUG
   */
  async updateTokenFamily(token, tokenSlug, body) {
    const url = new URL(`private/tokenfamilies/${tokenSlug}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_TOKENFAMILY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Ok: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.UPDATE_TOKENFAMILY);
        return opSuccessFromHttp(resp, codecForTokenFamilyDetails());
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCES]-private-tokenfamilies
   */
  async listTokenFamilies(token, params) {
    const url = new URL(`private/tokenfamilies`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTokenFamiliesList());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get-[-instances-$INSTANCES]-private-tokenfamilies-$TOKEN_FAMILY_SLUG
   */
  async getTokenFamilyDetails(token, tokenSlug) {
    const url = new URL(`private/tokenfamilies/${tokenSlug}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForTokenFamilyDetails());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCES]-private-tokenfamilies-$TOKEN_FAMILY_SLUG
   */
  async deleteTokenFamily(token, tokenSlug) {
    const url = new URL(`private/tokenfamilies/${tokenSlug}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.DELETE_TOKENFAMILY);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-challenge-$CHALLENGE_ID
   *
   */
  async sendChallenge(cid) {
    const url = new URL(`challenge/${cid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      // FIXME: this should be removed
      body: {}
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForChallengeRequestResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({});
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_CHALLENGE_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.Gone: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_CHALLENGE_SOLVED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.TooManyRequests: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_TOO_EARLY:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.BadGateway: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_MFA_HELPER_EXEC_FAILED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-challenge-$CHALLENGE_ID-confirm
   *
   */
  async confirmChallenge(cid, body) {
    const url = new URL(`challenge/${cid}/confirm`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_CHALLENGE_UNKNOWN:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.Conflict: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_CHALLENGE_FAILED:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      case HttpStatusCode.TooManyRequests: {
        const details = await readTalerErrorResponse(resp);
        switch (details.code) {
          case TalerErrorCode.MERCHANT_TAN_TOO_MANY_ATTEMPTS:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post--instances-$INSTANCE-forgot-password
   */
  async forgotPasswordSelfProvision(body, params = {}) {
    const url = new URL(`forgot-password`, this.baseUrl);
    const headers = {};
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        return opEmptySuccess();
      }
      case HttpStatusCode.Accepted: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      }
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  async postDonau(args) {
    const headers = {};
    if (args.token) {
      headers.Authorization = makeBearerTokenAuthHeader(args.token);
    }
    const url = new URL(`private/donau`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      headers,
      body: args.body
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
      case HttpStatusCode.Created:
      case HttpStatusCode.Ok: {
        return opEmptySuccess();
      }
      case HttpStatusCode.BadGateway:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * Get the auth api against the current instance
   *
   * https://docs.taler.net/core/api-merchant.html#post-[-instances-$INSTANCE]-private-token
   * https://docs.taler.net/core/api-merchant.html#delete-[-instances-$INSTANCE]-private-token
   */
  getAuthenticationAPI() {
    return new URL(`private/`, this.baseUrl);
  }
};
TalerMerchantInstanceHttpClient.PROTOCOL_VERSION = "22:0:4";
var TalerMerchantManagementHttpClient = class extends TalerMerchantInstanceHttpClient {
  constructor(baseUrl, httpClient, cacheEvictor) {
    super(baseUrl, httpClient, cacheEvictor);
    this.baseUrl = baseUrl;
    this.cacheManagementEvictor = cacheEvictor ?? nullEvictor;
  }
  getSubInstanceAPI(instanceId) {
    return new URL(`instances/${instanceId}/`, this.baseUrl).href;
  }
  //
  // Instance Management
  //
  /**
   * https://docs.taler.net/core/api-merchant.html#post--instances
   */
  async createInstanceSelfProvision(body, params = {}) {
    const url = new URL(`instances`, this.baseUrl);
    const headers = {};
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    if (params.tokenValidity) {
      url.searchParams.append("token_validity_ms", String(params.tokenValidity.d_ms));
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        this.cacheManagementEvictor.notifySuccess(TalerMerchantManagementCacheEviction.CREATE_INSTANCE);
        this.cacheEvictor.notifySuccess(TalerMerchantInstanceCacheEviction.CREATE_ACCESSTOKEN);
        return opSuccessFromHttp(resp, codecForLoginTokenSuccessResponse());
      }
      case HttpStatusCode.NoContent: {
        this.cacheManagementEvictor.notifySuccess(TalerMerchantManagementCacheEviction.CREATE_INSTANCE);
        return opFixedSuccess(void 0);
      }
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post--management-instances
   */
  async createInstance(token, body, params = {}) {
    const url = new URL(`management/instances`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheManagementEvictor.notifySuccess(TalerMerchantManagementCacheEviction.CREATE_INSTANCE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#post--management-instances-$INSTANCE-auth
   */
  async updateInstanceAuthentication(token, instanceId, body, params = {}) {
    const url = new URL(`management/instances/${instanceId}/auth`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#patch--management-instances-$INSTANCE
   */
  async updateInstance(token, instanceId, body) {
    const url = new URL(`management/instances/${instanceId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "PATCH",
      body,
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheManagementEvictor.notifySuccess(TalerMerchantManagementCacheEviction.UPDATE_INSTANCE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get--management-instances
   */
  async listInstances(token, params) {
    const url = new URL(`management/instances`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForInstancesResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get--management-instances-$INSTANCE
   *
   */
  async getInstanceDetails(token, instanceId) {
    const url = new URL(`management/instances/${instanceId}`, this.baseUrl);
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForQueryInstancesResponse());
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#delete--management-instances-$INSTANCE
   */
  async deleteInstance(token, instanceId, params = {}) {
    const url = new URL(`management/instances/${instanceId}`, this.baseUrl);
    if (params.purge !== void 0) {
      url.searchParams.set("purge", params.purge ? "YES" : "NO");
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    if (params.challengeIds && params.challengeIds.length > 0) {
      headers["Taler-Challenge-Ids"] = params.challengeIds.join(", ");
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "DELETE",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheManagementEvictor.notifySuccess(TalerMerchantManagementCacheEviction.DELETE_INSTANCE);
        return opEmptySuccess();
      }
      case HttpStatusCode.Accepted: {
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForChallengeResponse());
      }
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get--management-instances-$INSTANCE-kyc
   */
  async getIntanceKycStatus(token, instanceId, params) {
    const url = new URL(`management/instances/${instanceId}/kyc`, this.baseUrl);
    if (params.wireHash) {
      url.searchParams.set("h_wire", params.wireHash);
    }
    if (params.exchangeURL) {
      url.searchParams.set("exchange_url", params.exchangeURL);
    }
    if (params.timeout) {
      url.searchParams.set("timeout_ms", String(params.timeout));
    }
    const headers = {};
    if (token) {
      headers.Authorization = makeBearerTokenAuthHeader(token);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers
    });
    switch (resp.status) {
      case HttpStatusCode.Accepted:
        return opSuccessFromHttp(resp, codecForAccountKycRedirects());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opEmptySuccess();
      case HttpStatusCode.Unauthorized:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.BadGateway:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.ServiceUnavailable:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};

// ../taler-util/lib/i18n.js
var jedLib = __toESM(require_jed(), 1);
var logger7 = new Logger("i18n/index.ts");
var jed = void 0;
function setupI18n(lang, strings2) {
  lang = lang.replace("_", "-");
  if (!strings2[lang]) {
    strings2[lang] = {};
  }
  jed = new jedLib.Jed(strings2[lang]);
}
function toI18nString(stringSeq) {
  let s6 = "";
  for (let i5 = 0; i5 < stringSeq.length; i5++) {
    s6 += stringSeq[i5];
    if (i5 < stringSeq.length - 1) {
      s6 += `%${i5 + 1}$s`;
    }
  }
  return s6;
}
function singular(stringSeq, ...values) {
  const s6 = toI18nString(stringSeq);
  if (!s6)
    return "";
  const tr = jed.translate(s6).ifPlural(1, s6).fetch(...values);
  return tr;
}
function withContext(ctx) {
  return function(t5, ...v3) {
    const s6 = toI18nString(t5);
    const tr = jed.translate(s6).withContext(ctx).ifPlural(1, s6).fetch(...v3);
    return tr;
  };
}
function translate(stringSeq, ...values) {
  const s6 = toI18nString(stringSeq);
  if (!s6)
    return [];
  const translation = jed.ngettext(s6, s6, 1);
  return replacePlaceholderWithValues(translation, values);
}
function Translate({ children, debug, context: ctx }) {
  const c5 = [].concat(children);
  const s6 = stringifyArray(c5);
  if (!s6)
    return [];
  const translation = ctx ? jed.npgettext(ctx, s6, s6, 1) : jed.ngettext(s6, s6, 1);
  if (debug) {
    console.log("looking for ", s6, "got", translation);
  }
  return replacePlaceholderWithValues(translation, c5);
}
function replacePlaceholderWithValues(translation, childArray) {
  const tr = translation.split(/%(\d+)\$s/);
  const placeholderChildren = [];
  for (let i5 = 0; i5 < childArray.length; i5++) {
    const x6 = childArray[i5];
    if (x6 === void 0) {
      continue;
    } else if (typeof x6 === "string") {
      continue;
    } else {
      placeholderChildren.push(x6);
    }
  }
  const result = [];
  for (let i5 = 0; i5 < tr.length; i5++) {
    if (i5 % 2 == 0) {
      result.push(tr[i5]);
    } else {
      const childIdx = Number.parseInt(tr[i5]) - 1;
      result.push(placeholderChildren[childIdx]);
    }
  }
  return result;
}
function stringifyArray(children) {
  let n2 = 1;
  const ss = children.map((c5) => {
    if (typeof c5 === "string") {
      return c5;
    }
    return `%${n2++}$s`;
  });
  const s6 = ss.join("").replace(/ +/g, " ").trim();
  return s6;
}
var i18n = {
  str: singular,
  ctx: withContext,
  singular,
  Translate,
  translate
};

// ../taler-util/lib/promises.js
function openPromise() {
  let resolve = null;
  let promiseReject = null;
  const promise = new Promise((res, rej) => {
    resolve = res;
    promiseReject = rej;
  });
  if (!(resolve && promiseReject)) {
    throw Error("JS implementation is broken");
  }
  const result = { resolve, reject: promiseReject, promise };
  function saveLastError(reason) {
    result.lastError = reason;
    promiseReject(reason);
  }
  result.reject = saveLastError;
  return result;
}

// ../taler-util/lib/longpool-queue.js
var logger8 = new Logger("longpoll-queue.ts");
var PERMITS = 20;
var LongpollQueue = class {
  constructor() {
    this.idCounter = 0;
    this.queue = [];
    this.permits = PERMITS;
  }
  async run(url, cancellationToken, f3) {
    const hostname = url.hostname;
    const rid = this.idCounter++;
    const triggerNextLongpoll = () => {
      logger8.trace(`cleaning up after long-poll ${rid} to ${hostname}`);
      const next = this.queue.shift();
      if (next != null) {
        next();
      } else {
        this.permits++;
      }
    };
    const doRunLongpoll = async () => {
      const numWaiting = this.queue.length;
      const numConcurrent = PERMITS - this.permits;
      logger8.info(`running long-poll ${rid} to ${hostname} with ${numWaiting} waiting and ${numConcurrent} running`);
      try {
        const timeoutMs = Math.round(Math.max(1e4, 3e4 / (numWaiting + 1)));
        return await f3(timeoutMs);
      } finally {
        triggerNextLongpoll();
      }
    };
    if (this.permits > 0) {
      this.permits--;
      return doRunLongpoll();
    } else {
      logger8.info(`long-poll ${rid} to ${hostname} queued`);
      const promcap = openPromise();
      this.queue.push(promcap.resolve);
      try {
        await cancellationToken.racePromise(promcap.promise);
      } finally {
        logger8.info(`long-poll ${rid} to ${hostname} cancelled while queued`);
        triggerNextLongpoll();
      }
      return doRunLongpoll();
    }
  }
};

// ../taler-util/lib/notifications.js
var NotificationType;
(function(NotificationType2) {
  NotificationType2["BalanceChange"] = "balance-change";
  NotificationType2["BankAccountChange"] = "bank-account-change";
  NotificationType2["BackupOperationError"] = "backup-error";
  NotificationType2["TransactionStateTransition"] = "transaction-state-transition";
  NotificationType2["ExchangeStateTransition"] = "exchange-state-transition";
  NotificationType2["Idle"] = "idle";
  NotificationType2["TaskObservabilityEvent"] = "task-observability-event";
  NotificationType2["RequestObservabilityEvent"] = "request-observability-event";
})(NotificationType || (NotificationType = {}));
var ObservabilityEventType;
(function(ObservabilityEventType2) {
  ObservabilityEventType2["HttpFetchStart"] = "http-fetch-start";
  ObservabilityEventType2["HttpFetchFinishError"] = "http-fetch-finish-error";
  ObservabilityEventType2["HttpFetchFinishSuccess"] = "http-fetch-finish-success";
  ObservabilityEventType2["DbQueryStart"] = "db-query-start";
  ObservabilityEventType2["DbQueryFinishSuccess"] = "db-query-finish-success";
  ObservabilityEventType2["DbQueryFinishError"] = "db-query-finish-error";
  ObservabilityEventType2["RequestStart"] = "request-start";
  ObservabilityEventType2["RequestFinishSuccess"] = "request-finish-success";
  ObservabilityEventType2["RequestFinishError"] = "request-finish-error";
  ObservabilityEventType2["TaskStart"] = "task-start";
  ObservabilityEventType2["TaskStop"] = "task-stop";
  ObservabilityEventType2["TaskReset"] = "task-reset";
  ObservabilityEventType2["ShepherdTaskResult"] = "shepherd-task-result";
  ObservabilityEventType2["DeclareTaskDependency"] = "declare-task-dependency";
  ObservabilityEventType2["CryptoStart"] = "crypto-start";
  ObservabilityEventType2["CryptoFinishSuccess"] = "crypto-finish-success";
  ObservabilityEventType2["CryptoFinishError"] = "crypto-finish-error";
  ObservabilityEventType2["Message"] = "message";
  ObservabilityEventType2["DeclareConcernsTransaction"] = "declare-concerns-transaction";
})(ObservabilityEventType || (ObservabilityEventType = {}));

// ../taler-util/lib/observability.js
var seqId = 1e3;
var ObservableHttpClientLibrary = class {
  constructor(impl, oc) {
    this.impl = impl;
    this.oc = oc;
    this.cancelatorById = /* @__PURE__ */ new Map();
  }
  cancelRequest(id) {
    const cancelator = this.cancelatorById.get(id);
    if (!cancelator)
      return;
    cancelator.cancel();
  }
  async fetch(url, opt) {
    const id = `req-${seqId}`;
    seqId = seqId + 1;
    const cancelator = CancellationToken.create();
    if (opt?.cancellationToken) {
      opt.cancellationToken.onCancelled(cancelator.cancel);
    }
    this.cancelatorById.set(id, cancelator);
    this.oc.observe({
      id,
      when: AbsoluteTime.now(),
      type: ObservabilityEventType.HttpFetchStart,
      url
    });
    const optsWithCancel = opt ?? {};
    optsWithCancel.cancellationToken = cancelator.token;
    try {
      const res = await this.impl.fetch(url, optsWithCancel);
      this.oc.observe({
        id,
        when: AbsoluteTime.now(),
        type: ObservabilityEventType.HttpFetchFinishSuccess,
        url,
        status: res.status
      });
      return res;
    } catch (e5) {
      this.oc.observe({
        id,
        when: AbsoluteTime.now(),
        type: ObservabilityEventType.HttpFetchFinishError,
        url,
        error: getErrorDetailFromException(e5)
      });
      throw e5;
    } finally {
      this.cancelatorById.delete(id);
    }
  }
};

// ../taler-util/lib/RequestThrottler.js
var logger9 = new Logger("RequestThrottler.ts");
var MAX_PER_SECOND = 100;
var MAX_PER_MINUTE = 500;
var MAX_PER_HOUR = 2e3;
var OriginState = class {
  constructor() {
    this.tokensSecond = MAX_PER_SECOND;
    this.tokensMinute = MAX_PER_MINUTE;
    this.tokensHour = MAX_PER_HOUR;
    this.lastUpdate = AbsoluteTime.now();
  }
  refill() {
    const now2 = AbsoluteTime.now();
    if (AbsoluteTime.cmp(now2, this.lastUpdate) < 0) {
      this.lastUpdate = now2;
      return;
    }
    const d6 = AbsoluteTime.difference(now2, this.lastUpdate);
    if (d6.d_ms === "forever") {
      throw Error("assertion failed");
    }
    this.tokensSecond = Math.min(MAX_PER_SECOND, this.tokensSecond + d6.d_ms / 1e3);
    this.tokensMinute = Math.min(MAX_PER_MINUTE, this.tokensMinute + d6.d_ms / 1e3 / 60);
    this.tokensHour = Math.min(MAX_PER_HOUR, this.tokensHour + d6.d_ms / 1e3 / 60 / 60);
    this.lastUpdate = now2;
  }
  /**
   * Return true if the request for this origin should be throttled.
   * Otherwise, take a token out of the respective buckets.
   */
  applyThrottle() {
    this.refill();
    if (this.tokensSecond < 1) {
      logger9.warn("request throttled (per second limit exceeded)");
      return true;
    }
    if (this.tokensMinute < 1) {
      logger9.warn("request throttled (per minute limit exceeded)");
      return true;
    }
    if (this.tokensHour < 1) {
      logger9.warn("request throttled (per hour limit exceeded)");
      return true;
    }
    this.tokensSecond--;
    this.tokensMinute--;
    this.tokensHour--;
    return false;
  }
};
var RequestThrottler = class {
  constructor() {
    this.perOriginInfo = {};
  }
  /**
   * Get the throttling state for an origin, or
   * initialize if no state is associated with the
   * origin yet.
   */
  getState(origin) {
    const s6 = this.perOriginInfo[origin];
    if (s6) {
      return s6;
    }
    const ns = this.perOriginInfo[origin] = new OriginState();
    return ns;
  }
  /**
   * Apply throttling to a request.
   *
   * @returns whether the request should be throttled.
   */
  applyThrottle(requestUrl) {
    const origin = new URL(requestUrl).origin;
    return this.getState(origin).applyThrottle();
  }
  /**
   * Get the throttle statistics for a particular URL.
   */
  getThrottleStats(requestUrl) {
    const origin = new URL(requestUrl).origin;
    const state = this.getState(origin);
    return {
      tokensHour: state.tokensHour,
      tokensMinute: state.tokensMinute,
      tokensSecond: state.tokensSecond,
      maxTokensHour: MAX_PER_HOUR,
      maxTokensMinute: MAX_PER_MINUTE,
      maxTokensSecond: MAX_PER_SECOND
    };
  }
};

// ../taler-util/lib/ReserveTransaction.js
var ReserveTransactionType;
(function(ReserveTransactionType2) {
  ReserveTransactionType2["Withdraw"] = "WITHDRAW";
  ReserveTransactionType2["Credit"] = "CREDIT";
  ReserveTransactionType2["Recoup"] = "RECOUP";
  ReserveTransactionType2["Closing"] = "CLOSING";
})(ReserveTransactionType || (ReserveTransactionType = {}));

// ../taler-util/lib/rfc3548.js
var encTable2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
function encodeRfc3548Base32(data) {
  const dataBytes = new Uint8Array(data);
  let sb = "";
  const size = data.byteLength;
  let bitBuf = 0;
  let numBits = 0;
  let pos = 0;
  while (pos < size || numBits > 0) {
    if (pos < size && numBits < 5) {
      const d6 = dataBytes[pos++];
      bitBuf = bitBuf << 8 | d6;
      numBits += 8;
    }
    if (numBits < 5) {
      bitBuf = bitBuf << 5 - numBits;
      numBits = 5;
    }
    const v3 = bitBuf >>> numBits - 5 & 31;
    sb += encTable2[v3];
    numBits -= 5;
  }
  return sb;
}
function isRfc3548Base32Charset(s6) {
  for (let idx = 0; idx < s6.length; idx++) {
    const c5 = s6.charAt(idx);
    if (encTable2.indexOf(c5) === -1)
      return false;
  }
  return true;
}
function randomRfc3548Base32Key() {
  const buf = getRandomBytes(20);
  return encodeRfc3548Base32(buf);
}

// ../taler-util/lib/TaskThrottler.js
var logger10 = new Logger("OperationThrottler.ts");

// ../taler-util/lib/timer.js
var logger11 = new Logger("timer.ts");
var IntervalHandle = class {
  constructor(h5) {
    this.h = h5;
  }
  clear() {
    clearInterval(this.h);
  }
  /**
   * Make sure the event loop exits when the timer is the
   * only event left.  Has no effect in the browser.
   */
  unref() {
    if (typeof this.h === "object" && "unref" in this.h) {
      this.h.unref();
    }
  }
};
var TimeoutHandle = class {
  constructor(h5) {
    this.h = h5;
  }
  clear() {
    clearTimeout(this.h);
  }
  /**
   * Make sure the event loop exits when the timer is the
   * only event left.  Has no effect in the browser.
   */
  unref() {
    if (typeof this.h === "object" && "unref" in this.h) {
      this.h.unref();
    }
  }
};
var performanceNow = (() => {
  if (typeof process !== "undefined" && process.hrtime) {
    return () => {
      return process.hrtime.bigint();
    };
  }
  if (typeof performance !== "undefined") {
    return () => BigInt(Math.floor(performance.now() * 1e3)) * BigInt(1e3);
  }
  return () => BigInt((/* @__PURE__ */ new Date()).getTime()) * BigInt(1e3) * BigInt(1e3);
})();
var SetTimeoutTimerAPI = class {
  /**
   * Call a function every time the delay given in milliseconds passes.
   */
  every(delayMs, callback) {
    return new IntervalHandle(setInterval(callback, delayMs));
  }
  /**
   * Call a function after the delay given in milliseconds passes.
   */
  after(delayMs, callback) {
    return new TimeoutHandle(setTimeout(callback, delayMs));
  }
};
var timer = new SetTimeoutTimerAPI();

// ../taler-util/lib/types-taler-wallet-transactions.js
var TransactionMajorState;
(function(TransactionMajorState2) {
  TransactionMajorState2["None"] = "none";
  TransactionMajorState2["Pending"] = "pending";
  TransactionMajorState2["Done"] = "done";
  TransactionMajorState2["Aborting"] = "aborting";
  TransactionMajorState2["Aborted"] = "aborted";
  TransactionMajorState2["Dialog"] = "dialog";
  TransactionMajorState2["Finalizing"] = "finalizing";
  TransactionMajorState2["Suspended"] = "suspended";
  TransactionMajorState2["SuspendedFinalizing"] = "suspended-finalizing";
  TransactionMajorState2["SuspendedAborting"] = "suspended-aborting";
  TransactionMajorState2["Failed"] = "failed";
  TransactionMajorState2["Expired"] = "expired";
  TransactionMajorState2["Deleted"] = "deleted";
})(TransactionMajorState || (TransactionMajorState = {}));
var TransactionMinorState;
(function(TransactionMinorState2) {
  TransactionMinorState2["Unknown"] = "unknown";
  TransactionMinorState2["Deposit"] = "deposit";
  TransactionMinorState2["KycRequired"] = "kyc";
  TransactionMinorState2["KycInit"] = "kyc-init";
  TransactionMinorState2["MergeKycRequired"] = "merge-kyc";
  TransactionMinorState2["BalanceKycRequired"] = "balance-kyc";
  TransactionMinorState2["BalanceKycInit"] = "balance-kyc-init";
  TransactionMinorState2["KycAuthRequired"] = "kyc-auth";
  TransactionMinorState2["Track"] = "track";
  TransactionMinorState2["SubmitPayment"] = "submit-payment";
  TransactionMinorState2["RebindSession"] = "rebind-session";
  TransactionMinorState2["Refresh"] = "refresh";
  TransactionMinorState2["Pickup"] = "pickup";
  TransactionMinorState2["AutoRefund"] = "auto-refund";
  TransactionMinorState2["User"] = "user";
  TransactionMinorState2["Bank"] = "bank";
  TransactionMinorState2["Exchange"] = "exchange";
  TransactionMinorState2["ClaimProposal"] = "claim-proposal";
  TransactionMinorState2["CheckRefund"] = "check-refund";
  TransactionMinorState2["CreatePurse"] = "create-purse";
  TransactionMinorState2["DeletePurse"] = "delete-purse";
  TransactionMinorState2["RefreshExpired"] = "refresh-expired";
  TransactionMinorState2["Ready"] = "ready";
  TransactionMinorState2["Merge"] = "merge";
  TransactionMinorState2["Repurchase"] = "repurchase";
  TransactionMinorState2["BankRegisterReserve"] = "bank-register-reserve";
  TransactionMinorState2["BankConfirmTransfer"] = "bank-confirm-transfer";
  TransactionMinorState2["WithdrawCoins"] = "withdraw-coins";
  TransactionMinorState2["ExchangeWaitReserve"] = "exchange-wait-reserve";
  TransactionMinorState2["AbortingBank"] = "aborting-bank";
  TransactionMinorState2["Aborting"] = "aborting";
  TransactionMinorState2["Refused"] = "refused";
  TransactionMinorState2["Withdraw"] = "withdraw";
  TransactionMinorState2["MerchantOrderProposed"] = "merchant-order-proposed";
  TransactionMinorState2["Proposed"] = "proposed";
  TransactionMinorState2["RefundAvailable"] = "refund-available";
  TransactionMinorState2["AcceptRefund"] = "accept-refund";
  TransactionMinorState2["PaidByOther"] = "paid-by-other";
  TransactionMinorState2["CompletedByOtherWallet"] = "completed-by-other-wallet";
})(TransactionMinorState || (TransactionMinorState = {}));
var TransactionAction;
(function(TransactionAction2) {
  TransactionAction2["Delete"] = "delete";
  TransactionAction2["Suspend"] = "suspend";
  TransactionAction2["Resume"] = "resume";
  TransactionAction2["Abort"] = "abort";
  TransactionAction2["Fail"] = "fail";
  TransactionAction2["Retry"] = "retry";
})(TransactionAction || (TransactionAction = {}));
var TransactionType;
(function(TransactionType2) {
  TransactionType2["Withdrawal"] = "withdrawal";
  TransactionType2["InternalWithdrawal"] = "internal-withdrawal";
  TransactionType2["Payment"] = "payment";
  TransactionType2["Refund"] = "refund";
  TransactionType2["Refresh"] = "refresh";
  TransactionType2["Deposit"] = "deposit";
  TransactionType2["PeerPushDebit"] = "peer-push-debit";
  TransactionType2["PeerPushCredit"] = "peer-push-credit";
  TransactionType2["PeerPullDebit"] = "peer-pull-debit";
  TransactionType2["PeerPullCredit"] = "peer-pull-credit";
  TransactionType2["Recoup"] = "recoup";
  TransactionType2["DenomLoss"] = "denom-loss";
})(TransactionType || (TransactionType = {}));
var WithdrawalType;
(function(WithdrawalType2) {
  WithdrawalType2["TalerBankIntegrationApi"] = "taler-bank-integration-api";
  WithdrawalType2["ManualTransfer"] = "manual-transfer";
})(WithdrawalType || (WithdrawalType = {}));
var DenomLossEventType;
(function(DenomLossEventType2) {
  DenomLossEventType2["DenomExpired"] = "denom-expired";
  DenomLossEventType2["DenomVanished"] = "denom-vanished";
  DenomLossEventType2["DenomUnoffered"] = "denom-unoffered";
})(DenomLossEventType || (DenomLossEventType = {}));
var PaymentStatus;
(function(PaymentStatus2) {
  PaymentStatus2["Aborted"] = "aborted";
  PaymentStatus2["Failed"] = "failed";
  PaymentStatus2["Paid"] = "paid";
  PaymentStatus2["Accepted"] = "accepted";
})(PaymentStatus || (PaymentStatus = {}));

// ../taler-util/lib/transaction-test-data.js
var sampleWalletCoreTransactions = [
  {
    type: TransactionType.Payment,
    txState: {
      major: TransactionMajorState.Done
    },
    amountRaw: "KUDOS:10",
    amountEffective: "KUDOS:10",
    totalRefundRaw: "KUDOS:0",
    totalRefundEffective: "KUDOS:0",
    status: PaymentStatus.Paid,
    refundPending: void 0,
    posConfirmation: void 0,
    pending: false,
    refunds: [],
    timestamp: {
      t_s: 1677166045
    },
    transactionId: "txn:payment:NRRD9KJ8970P5HDAGPW1MBA6HZHB1XMFKF5M3CNR6WA0GT98DHY0",
    proposalId: "NRRD9KJ8970P5HDAGPW1MBA6HZHB1XMFKF5M3CNR6WA0GT98DHY0",
    info: {
      merchant: {
        name: "woocommerce",
        website: "woocommerce.demo.taler.net",
        email: "foo@example.com",
        address: {},
        jurisdiction: {}
      },
      orderId: "wc_order_KQCRldghIgDRB-100",
      products: [
        {
          description: "Using GCC",
          quantity: 1,
          price: "KUDOS:10",
          product_id: "28"
        }
      ],
      summary: "WooTalerShop #100",
      contractTermsHash: "A02E1M6ARWKBJ87K2TV4S6WQ4X5YH7BRVR6MYCHCTVAED8MBXTFD6PZ5Q50Y7Z5K18PYBTDA14NQ56XPC1VCQW1EVRWTSB7ZYT65B5G",
      fulfillmentUrl: "https://woocommerce.demo.taler.net/?wc-api=wc_gnutaler_gateway&order_id=wc_order_KQCRldghIgDRB-100"
    },
    refundQueryActive: false,
    frozen: false
  },
  {
    type: TransactionType.Refresh,
    txState: {
      major: TransactionMajorState.Pending
    },
    refreshReason: RefreshReason.PayMerchant,
    amountEffective: "KUDOS:0",
    amountRaw: "KUDOS:0",
    refreshInputAmount: "KUDOS:1.5",
    refreshOutputAmount: "KUDOS:1.4",
    originatingTransactionId: "txn:proposal:ZCGBZFE8KZ1CBYYGSC3ZC8E40KVJWV16VYCTHGC8FFSVZ5HD24BG",
    pending: true,
    timestamp: {
      t_s: 1681376214
    },
    transactionId: "txn:refresh:QQSWHHXCRQ269G0E3RW14JMC6F7NFDYDW26NSFHRTXSKDS6CMCZ0",
    frozen: false,
    error: {
      code: 7029,
      when: {
        t_ms: 1681376473665
      },
      hint: "Error (WALLET_REFRESH_GROUP_INCOMPLETE)",
      numErrors: 1,
      errors: [
        {
          code: 7001,
          when: {
            t_ms: 1681376473189
          },
          hint: "unexpected exception (message: exchange wire fee signature invalid)",
          stack: "    at validateWireInfo (../taler-wallet-core-qjs.mjs:23166)\n"
        }
      ]
    }
  }
];

// ../taler-util/lib/taler-signatures.js
function signAmlDecision(priv, decision) {
  const builder = buildSigPS(TalerSignaturePurpose.AML_DECISION);
  const flags = decision.keep_investigating ? 1 : 0;
  builder.put(timestampRoundedToBuffer(decision.decision_time));
  builder.put(timestampRoundedToBuffer(decision.attributes_expiration ?? TalerProtocolTimestamp.fromSeconds(0)));
  builder.put(decodeCrock(decision.h_payto));
  builder.put(hash2(stringToBytes(decision.justification)));
  builder.put(hash2(stringToBytes(canonicalJson(decision.properties) + "\0")));
  builder.put(hash2(stringToBytes(canonicalJson(decision.new_rules) + "\0")));
  if (decision.new_measures != null) {
    builder.put(hash2(stringToBytes(decision.new_measures)));
  } else {
    builder.put(new Uint8Array(64));
  }
  if (decision.attributes != null) {
    builder.put(hash2(stringToBytes(canonicalJson(decision.attributes) + "\0")));
  } else {
    builder.put(new Uint8Array(64));
  }
  builder.put(bufferForUint64(flags));
  const sigBlob = builder.build();
  return eddsaSign(sigBlob, priv);
}
function signAmlQuery(key) {
  const sigBlob = buildSigPS(TalerSignaturePurpose.AML_QUERY).build();
  return eddsaSign(sigBlob, key);
}

// ../taler-util/lib/taler-account-properties.js
var TalerAmlProperties = {
  /**
   * Description: Current note on the GWG file.
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  FILE_NOTE: "FILE_NOTE",
  /**
   * Description: Customer name or internal alias.
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  CUSTOMER_LABEL: "CUSTOMER_LABEL",
  /**
   * Description: Boolean flag indicating whether the account has been opened. The definition of opening an account is deployment-specific.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  ACCOUNT_OPEN: "ACCOUNT_OPEN",
  /**
   * Description: True if the customer is a domestic PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_DOMESTIC: "PEP_DOMESTIC",
  /**
   * Description: True if the customer is a foreign PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_FOREIGN: "PEP_FOREIGN",
  /**
   * Description: True if the customer is a international organization PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_INTERNATIONAL_ORGANIZATION: "PEP_INTERNATIONAL_ORGANIZATION",
  /**
   * Description: True if the customer is a  high-risk business.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  HIGH_RISK_CUSTOMER: "HIGH_RISK_CUSTOMER",
  /**
   * Description: True if the customer is associated with a high-risk country.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  HIGH_RISK_COUNTRY: "HIGH_RISK_COUNTRY",
  /**
   * Description: The account has been marked as idle.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  ACCOUNT_IDLE: "ACCOUNT_IDLE",
  /**
   * Description: The MROS reporting state for the account.
   *
   * GANA Type: 'NONE' | 'INVESTIGATION_PENDING' | 'INVESTIGATION_COMPLETED_WITHOUT_SUSPICION' | 'REPORTED_SUSPICION_SIMPLE' | 'REPORTED_SUSPICION_SUBSTANTIATED'
   * Deployment: TOPS
   */
  INVESTIGATION_STATE: "INVESTIGATION_STATE",
  /**
   * Description: Informal reason why the AML investigation was triggered. Examples include suspicious transaction or (automated) sanction list match
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  INVESTIGATION_TRIGGER: "INVESTIGATION_TRIGGER",
  /**
   * Description: Identifies the sanction list entry that the account matched against (best match, does not mean it was a good match)
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  SANCTION_LIST_BEST_MATCH: "SANCTION_LIST_BEST_MATCH",
  /**
   * Description: Score for how good the sanction list match was (0: none, 10**9: perfect match)
   *
   * GANA Type: Integer
   * Deployment: TOPS
   */
  SANCTION_LIST_RATING: "SANCTION_LIST_RATING",
  /**
   * Description: Score for how much supporting data we had for the sanction list match (0: none, 10**9: all fields available)
   *
   * GANA Type: Integer
   * Deployment: TOPS
   */
  SANCTION_LIST_CONFIDENCE: "SANCTION_LIST_CONFIDENCE",
  /**
   * Description: Suppress flagging this account when it creates a hit on a sanctions list, this is a false-positive.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  SANCTION_LIST_SUPPRESS: "SANCTION_LIST_SUPPRESS"
};

// ../taler-util/lib/aml/properties.js
var TOPS_AccountProperties = [
  TalerAmlProperties.FILE_NOTE,
  TalerAmlProperties.CUSTOMER_LABEL,
  TalerAmlProperties.ACCOUNT_OPEN,
  TalerAmlProperties.PEP_DOMESTIC,
  TalerAmlProperties.PEP_FOREIGN,
  TalerAmlProperties.PEP_INTERNATIONAL_ORGANIZATION,
  TalerAmlProperties.HIGH_RISK_CUSTOMER,
  TalerAmlProperties.HIGH_RISK_COUNTRY,
  TalerAmlProperties.ACCOUNT_IDLE,
  TalerAmlProperties.INVESTIGATION_TRIGGER,
  TalerAmlProperties.INVESTIGATION_STATE,
  TalerAmlProperties.SANCTION_LIST_BEST_MATCH,
  TalerAmlProperties.SANCTION_LIST_RATING,
  TalerAmlProperties.SANCTION_LIST_CONFIDENCE,
  TalerAmlProperties.SANCTION_LIST_SUPPRESS
];
var GLS_AccountProperties = [TalerAmlProperties.FILE_NOTE];
var KnownForms;
(function(KnownForms3) {
  KnownForms3[KnownForms3["vqf_902_1_customer"] = 0] = "vqf_902_1_customer";
  KnownForms3[KnownForms3["vqf_902_1_officer"] = 1] = "vqf_902_1_officer";
  KnownForms3[KnownForms3["vqf_902_4"] = 2] = "vqf_902_4";
  KnownForms3[KnownForms3["vqf_902_5"] = 3] = "vqf_902_5";
  KnownForms3[KnownForms3["vqf_902_9_customer"] = 4] = "vqf_902_9_customer";
  KnownForms3[KnownForms3["vqf_902_9_officer"] = 5] = "vqf_902_9_officer";
  KnownForms3[KnownForms3["vqf_902_11_customer"] = 6] = "vqf_902_11_customer";
  KnownForms3[KnownForms3["vqf_902_11_officer"] = 7] = "vqf_902_11_officer";
  KnownForms3[KnownForms3["vqf_902_12"] = 8] = "vqf_902_12";
  KnownForms3[KnownForms3["vqf_902_13"] = 9] = "vqf_902_13";
  KnownForms3[KnownForms3["vqf_902_14"] = 10] = "vqf_902_14";
  KnownForms3[KnownForms3["vqf_902_15"] = 11] = "vqf_902_15";
})(KnownForms || (KnownForms = {}));

// ../taler-util/lib/aml/events.js
var TOPS_AmlEventsName;
(function(TOPS_AmlEventsName2) {
  TOPS_AmlEventsName2["INCR_ACCOUNT_OPEN"] = "INCR_ACCOUNT_OPEN";
  TOPS_AmlEventsName2["DECR_ACCOUNT_OPEN"] = "DECR_ACCOUNT_OPEN";
  TOPS_AmlEventsName2["INCR_HIGH_RISK_CUSTOMER"] = "INCR_HIGH_RISK_CUSTOMER";
  TOPS_AmlEventsName2["DECR_HIGH_RISK_CUSTOMER"] = "DECR_HIGH_RISK_CUSTOMER";
  TOPS_AmlEventsName2["INCR_HIGH_RISK_COUNTRY"] = "INCR_HIGH_RISK_COUNTRY";
  TOPS_AmlEventsName2["DECR_HIGH_RISK_COUNTRY"] = "DECR_HIGH_RISK_COUNTRY";
  TOPS_AmlEventsName2["INCR_PEP"] = "INCR_PEP";
  TOPS_AmlEventsName2["DECR_PEP"] = "DECR_PEP";
  TOPS_AmlEventsName2["INCR_PEP_FOREIGN"] = "INCR_PEP_FOREIGN";
  TOPS_AmlEventsName2["DECR_PEP_FOREIGN"] = "DECR_PEP_FOREIGN";
  TOPS_AmlEventsName2["INCR_PEP_DOMESTIC"] = "INCR_PEP_DOMESTIC";
  TOPS_AmlEventsName2["DECR_PEP_DOMESTIC"] = "DECR_PEP_DOMESTIC";
  TOPS_AmlEventsName2["INCR_PEP_INTERNATIONAL_ORGANIZATION"] = "INCR_PEP_INTERNATIONAL_ORGANIZATION";
  TOPS_AmlEventsName2["DECR_PEP_INTERNATIONAL_ORGANIZATION"] = "DECR_PEP_INTERNATIONAL_ORGANIZATION";
  TOPS_AmlEventsName2["MROS_REPORTED_SUSPICION_SIMPLE"] = "MROS_REPORTED_SUSPICION_SIMPLE";
  TOPS_AmlEventsName2["MROS_REPORTED_SUSPICION_SUBSTANTIATED"] = "MROS_REPORTED_SUSPICION_SUBSTANTIATED";
  TOPS_AmlEventsName2["INCR_INVESTIGATION_CONCLUDED"] = "INCR_INVESTIGATION_CONCLUDED";
  TOPS_AmlEventsName2["DECR_INVESTIGATION_CONCLUDED"] = "DECR_INVESTIGATION_CONCLUDED";
})(TOPS_AmlEventsName || (TOPS_AmlEventsName = {}));
var GLS_AmlEventsName;
(function(GLS_AmlEventsName2) {
  GLS_AmlEventsName2["ACCOUNT_OPENED"] = "ACCOUNT_OPENED";
  GLS_AmlEventsName2["ACCOUNT_CLOSED"] = "ACCOUNT_CLOSED";
})(GLS_AmlEventsName || (GLS_AmlEventsName = {}));
var KnownForms2;
(function(KnownForms3) {
  KnownForms3[KnownForms3["vqf_902_1_customer"] = 0] = "vqf_902_1_customer";
  KnownForms3[KnownForms3["vqf_902_1_officer"] = 1] = "vqf_902_1_officer";
  KnownForms3[KnownForms3["vqf_902_4"] = 2] = "vqf_902_4";
  KnownForms3[KnownForms3["vqf_902_5"] = 3] = "vqf_902_5";
  KnownForms3[KnownForms3["vqf_902_9_customer"] = 4] = "vqf_902_9_customer";
  KnownForms3[KnownForms3["vqf_902_9_officer"] = 5] = "vqf_902_9_officer";
  KnownForms3[KnownForms3["vqf_902_11_customer"] = 6] = "vqf_902_11_customer";
  KnownForms3[KnownForms3["vqf_902_11_officer"] = 7] = "vqf_902_11_officer";
  KnownForms3[KnownForms3["vqf_902_12"] = 8] = "vqf_902_12";
  KnownForms3[KnownForms3["vqf_902_13"] = 9] = "vqf_902_13";
  KnownForms3[KnownForms3["vqf_902_14"] = 10] = "vqf_902_14";
  KnownForms3[KnownForms3["vqf_902_15"] = 11] = "vqf_902_15";
})(KnownForms2 || (KnownForms2 = {}));

// ../taler-util/lib/aml/reporting.js
var EventReporting_TOPS_queries = {
  // Number of accounts that are opened
  accounts_open_incr: {
    event: TOPS_AmlEventsName.INCR_ACCOUNT_OPEN,
    start: void 0,
    end: void 0
  },
  accounts_open_decr: {
    event: TOPS_AmlEventsName.DECR_ACCOUNT_OPEN,
    start: void 0,
    end: void 0
  },
  // Number of new GwG files in the last year
  gwg_files_new_last_year: {
    event: TOPS_AmlEventsName.INCR_ACCOUNT_OPEN,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of GwG files closed in the last year
  gwg_files_closed_last_year: {
    event: TOPS_AmlEventsName.DECR_ACCOUNT_OPEN,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of GwG files of high-risk customers
  gwg_files_high_risk_incr: {
    event: TOPS_AmlEventsName.INCR_HIGH_RISK_CUSTOMER,
    //FIXME: spec refers to INCR_HIGH_RISK
    start: void 0,
    end: void 0
  },
  gwg_files_high_risk_decr: {
    event: TOPS_AmlEventsName.DECR_HIGH_RISK_CUSTOMER,
    start: void 0,
    end: void 0
  },
  // Number of GwG files managed with “increased risk” due to PEP status
  gwg_files_pep_incr: {
    event: TOPS_AmlEventsName.INCR_PEP,
    start: void 0,
    end: void 0
  },
  gwg_files_pep_decr: {
    event: TOPS_AmlEventsName.DECR_PEP,
    start: void 0,
    end: void 0
  },
  // Number of MROS reports based on Art 9 Abs. 1 GwG (per year)
  mros_reports_art9_last_year: {
    event: TOPS_AmlEventsName.MROS_REPORTED_SUSPICION_SUBSTANTIATED,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of MROS reports based on Art 305ter Abs. 2 StGB (per year)
  mros_reports_art305_last_year: {
    event: TOPS_AmlEventsName.MROS_REPORTED_SUSPICION_SIMPLE,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of customers involved in proceedings for which Art 6 GwG did apply
  accounts_involed_in_proceedings_last_year: {
    event: TOPS_AmlEventsName.INCR_INVESTIGATION_CONCLUDED,
    //FIXME: spec refers to INCR_INVESTIGATION
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  }
};

// ../taler-util/lib/index.browser.js
loadBrowserPrng();

// ../web-util/lib/index.browser.mjs
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_compat_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
var __defProp2 = Object.defineProperty;
var __export2 = (target, all) => {
  for (var name in all)
    __defProp2(target, name, { get: all[name], enumerable: true });
};
var utils_exports = {};
__export2(utils_exports, {
  compose: () => compose,
  composeRef: () => composeRef,
  doAutoFocus: () => doAutoFocus,
  doAutoFocusWithScroll: () => doAutoFocusWithScroll,
  onComponentUnload: () => onComponentUnload,
  preconnectAs: () => preconnectAs,
  recursive: () => recursive,
  saveRef: () => saveRef,
  saveVNodeForInspection: () => saveVNodeForInspection
});
function compose(hook, viewMap) {
  function withHook(stateHook) {
    function ComposedComponent() {
      const state = stateHook();
      if (typeof state === "function") {
        const subComponent = withHook(state);
        return h(subComponent, {});
      }
      const statusName = state.status;
      const viewComponent = viewMap[statusName];
      return h(viewComponent, state);
    }
    return ComposedComponent;
  }
  return (p4) => {
    const h54 = withHook(() => hook(p4));
    return h54();
  };
}
function recursive(hook) {
  function withHook(stateHook) {
    function ComposedComponent() {
      const state = stateHook();
      if (typeof state === "function") {
        const subComponent = withHook(state);
        return h(subComponent, {});
      }
      return state;
    }
    return ComposedComponent;
  }
  return (p4) => {
    const h54 = withHook(() => hook(p4));
    return h54();
  };
}
function onComponentUnload(callback) {
  const ref = _2();
  ref.current = callback;
  h2(() => {
    return () => {
      ref.current();
    };
  }, []);
}
var ownerDocument = typeof document === "undefined" ? null : document;
var preconnectsSet = /* @__PURE__ */ new Set();
function preconnectAs(pre) {
  if (ownerDocument) {
    pre.forEach(({ rel, href, crossOrigin }) => {
      const key = `${rel}${href}${crossOrigin}`;
      if (preconnectsSet.has(key))
        return;
      preconnectsSet.add(key);
      const instance = ownerDocument.createElement("link");
      instance.setAttribute("rel", rel);
      instance.setAttribute("crossOrigin", crossOrigin);
      instance.setAttribute("href", href);
      ownerDocument.head.appendChild(instance);
    });
  }
}
function composeRef(...fn2) {
  return (element) => {
    fn2.forEach((handler) => {
      handler(element);
    });
  };
}
function saveRef(ref) {
  return (element) => {
    if (element) {
      ref.current = element;
    }
  };
}
function doAutoFocus(element) {
  if (element) {
    setTimeout(() => {
      element.focus({ preventScroll: true });
    }, 100);
  }
}
function doAutoFocusWithScroll(element) {
  if (element) {
    setTimeout(() => {
      element.focus({ preventScroll: true });
      element.scrollIntoView({
        behavior: "smooth",
        block: "center",
        inline: "center"
      });
    }, 100);
  }
}
function saveVNodeForInspection(obj) {
  window["showVNodeInfo"] = function showVNodeInfo() {
    inspect(obj);
  };
  return obj;
}
function inspect(obj) {
  if (!obj)
    return;
  if (obj.__c && obj.__c.__H) {
    const componentName = obj.__c.constructor.name;
    const hookState = obj.__c.__H;
    const stateList = hookState.__;
    console.log("==============", componentName);
    stateList.forEach((hook) => {
      const { __: value, c: context, __h: factory, __H: args } = hook;
      if (typeof context !== "undefined") {
        const { __c: contextId } = context;
        console.log("context:", contextId, hook);
      } else if (typeof factory === "function") {
        console.log("memo:", value, "deps:", args);
      } else if (typeof value === "function") {
        const effectName = value.name;
        console.log("effect:", effectName, "deps:", args);
      } else if (typeof value.current !== "undefined") {
        const ref = value.current;
        console.log("ref:", ref instanceof Element ? ref.outerHTML : ref);
      } else if (value instanceof Array) {
        console.log("state:", value[0]);
      } else {
        console.log(hook);
      }
    });
  }
  const children = obj.__k;
  if (children instanceof Array) {
    children.forEach((e22) => inspect(e22));
  } else {
    inspect(children);
  }
}
var Context = B(void 0);
var CommonPreferenceProvider = ({
  showDebug,
  children
}) => {
  const [value, update] = p3(showDebug ?? false);
  return h(Context.Provider, {
    value: {
      showDebugInfo: !!value,
      toggle() {
        update(!value);
      }
    },
    children
  });
};
function Loading() {
  return /* @__PURE__ */ h(
    "div",
    {
      class: "columns is-centered is-vcentered",
      style: {
        width: "100%",
        height: "200px",
        display: "flex",
        margin: "auto",
        justifyContent: "center"
      }
    },
    /* @__PURE__ */ h(Spinner, null)
  );
}
function Spinner() {
  return /* @__PURE__ */ h("div", { class: "lds-ring m-auto" }, /* @__PURE__ */ h("div", null), /* @__PURE__ */ h("div", null), /* @__PURE__ */ h("div", null), /* @__PURE__ */ h("div", null));
}
function toInteger(dirtyNumber) {
  if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
    return NaN;
  }
  var number = Number(dirtyNumber);
  if (isNaN(number)) {
    return number;
  }
  return number < 0 ? Math.ceil(number) : Math.floor(number);
}
function requiredArgs(required, args) {
  if (args.length < required) {
    throw new TypeError(required + " argument" + (required > 1 ? "s" : "") + " required, but only " + args.length + " present");
  }
}
function _typeof(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof(obj);
}
function toDate(argument) {
  requiredArgs(1, arguments);
  var argStr = Object.prototype.toString.call(argument);
  if (argument instanceof Date || _typeof(argument) === "object" && argStr === "[object Date]") {
    return new Date(argument.getTime());
  } else if (typeof argument === "number" || argStr === "[object Number]") {
    return new Date(argument);
  } else {
    if ((typeof argument === "string" || argStr === "[object String]") && typeof console !== "undefined") {
      console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as date arguments. Please use `parseISO` to parse strings. See: https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#string-arguments");
      console.warn(new Error().stack);
    }
    return /* @__PURE__ */ new Date(NaN);
  }
}
function addDays(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  date.setDate(date.getDate() + amount);
  return date;
}
function addMonths(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  var dayOfMonth = date.getDate();
  var endOfDesiredMonth = new Date(date.getTime());
  endOfDesiredMonth.setMonth(date.getMonth() + amount + 1, 0);
  var daysInMonth = endOfDesiredMonth.getDate();
  if (dayOfMonth >= daysInMonth) {
    return endOfDesiredMonth;
  } else {
    date.setFullYear(endOfDesiredMonth.getFullYear(), endOfDesiredMonth.getMonth(), dayOfMonth);
    return date;
  }
}
function _typeof2(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof2 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof2 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof2(obj);
}
function add2(dirtyDate, duration) {
  requiredArgs(2, arguments);
  if (!duration || _typeof2(duration) !== "object")
    return /* @__PURE__ */ new Date(NaN);
  var years = duration.years ? toInteger(duration.years) : 0;
  var months = duration.months ? toInteger(duration.months) : 0;
  var weeks = duration.weeks ? toInteger(duration.weeks) : 0;
  var days = duration.days ? toInteger(duration.days) : 0;
  var hours = duration.hours ? toInteger(duration.hours) : 0;
  var minutes = duration.minutes ? toInteger(duration.minutes) : 0;
  var seconds = duration.seconds ? toInteger(duration.seconds) : 0;
  var date = toDate(dirtyDate);
  var dateWithMonths = months || years ? addMonths(date, months + years * 12) : date;
  var dateWithDays = days || weeks ? addDays(dateWithMonths, days + weeks * 7) : dateWithMonths;
  var minutesToAdd = minutes + hours * 60;
  var secondsToAdd = seconds + minutesToAdd * 60;
  var msToAdd = secondsToAdd * 1e3;
  var finalDate = new Date(dateWithDays.getTime() + msToAdd);
  return finalDate;
}
function addMilliseconds(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var timestamp = toDate(dirtyDate).getTime();
  var amount = toInteger(dirtyAmount);
  return new Date(timestamp + amount);
}
var defaultOptions = {};
function getDefaultOptions() {
  return defaultOptions;
}
function getTimezoneOffsetInMilliseconds(date) {
  var utcDate = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()));
  utcDate.setUTCFullYear(date.getFullYear());
  return date.getTime() - utcDate.getTime();
}
function startOfDay(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setHours(0, 0, 0, 0);
  return date;
}
var MILLISECONDS_IN_DAY = 864e5;
function differenceInCalendarDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var startOfDayLeft = startOfDay(dirtyDateLeft);
  var startOfDayRight = startOfDay(dirtyDateRight);
  var timestampLeft = startOfDayLeft.getTime() - getTimezoneOffsetInMilliseconds(startOfDayLeft);
  var timestampRight = startOfDayRight.getTime() - getTimezoneOffsetInMilliseconds(startOfDayRight);
  return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_DAY);
}
function compareAsc(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var diff = dateLeft.getTime() - dateRight.getTime();
  if (diff < 0) {
    return -1;
  } else if (diff > 0) {
    return 1;
  } else {
    return diff;
  }
}
var daysInYear = 365.2425;
var maxTime = Math.pow(10, 8) * 24 * 60 * 60 * 1e3;
var millisecondsInMinute = 6e4;
var millisecondsInHour = 36e5;
var millisecondsInSecond = 1e3;
var minTime = -maxTime;
var secondsInHour = 3600;
var secondsInDay = secondsInHour * 24;
var secondsInWeek = secondsInDay * 7;
var secondsInYear = secondsInDay * daysInYear;
var secondsInMonth = secondsInYear / 12;
var secondsInQuarter = secondsInMonth * 3;
function _typeof3(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof3 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof3 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof3(obj);
}
function isDate(value) {
  requiredArgs(1, arguments);
  return value instanceof Date || _typeof3(value) === "object" && Object.prototype.toString.call(value) === "[object Date]";
}
function isValid(dirtyDate) {
  requiredArgs(1, arguments);
  if (!isDate(dirtyDate) && typeof dirtyDate !== "number") {
    return false;
  }
  var date = toDate(dirtyDate);
  return !isNaN(Number(date));
}
function differenceInCalendarMonths(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var yearDiff = dateLeft.getFullYear() - dateRight.getFullYear();
  var monthDiff = dateLeft.getMonth() - dateRight.getMonth();
  return yearDiff * 12 + monthDiff;
}
function differenceInCalendarYears(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  return dateLeft.getFullYear() - dateRight.getFullYear();
}
function compareLocalAsc(dateLeft, dateRight) {
  var diff = dateLeft.getFullYear() - dateRight.getFullYear() || dateLeft.getMonth() - dateRight.getMonth() || dateLeft.getDate() - dateRight.getDate() || dateLeft.getHours() - dateRight.getHours() || dateLeft.getMinutes() - dateRight.getMinutes() || dateLeft.getSeconds() - dateRight.getSeconds() || dateLeft.getMilliseconds() - dateRight.getMilliseconds();
  if (diff < 0) {
    return -1;
  } else if (diff > 0) {
    return 1;
  } else {
    return diff;
  }
}
function differenceInDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var sign2 = compareLocalAsc(dateLeft, dateRight);
  var difference2 = Math.abs(differenceInCalendarDays(dateLeft, dateRight));
  dateLeft.setDate(dateLeft.getDate() - sign2 * difference2);
  var isLastDayNotFull = Number(compareLocalAsc(dateLeft, dateRight) === -sign2);
  var result = sign2 * (difference2 - isLastDayNotFull);
  return result === 0 ? 0 : result;
}
function differenceInMilliseconds(dateLeft, dateRight) {
  requiredArgs(2, arguments);
  return toDate(dateLeft).getTime() - toDate(dateRight).getTime();
}
var roundingMap = {
  ceil: Math.ceil,
  round: Math.round,
  floor: Math.floor,
  trunc: function trunc(value) {
    return value < 0 ? Math.ceil(value) : Math.floor(value);
  }
  // Math.trunc is not supported by IE
};
var defaultRoundingMethod = "trunc";
function getRoundingMethod(method) {
  return method ? roundingMap[method] : roundingMap[defaultRoundingMethod];
}
function differenceInHours(dateLeft, dateRight, options) {
  requiredArgs(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / millisecondsInHour;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function differenceInMinutes(dateLeft, dateRight, options) {
  requiredArgs(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / millisecondsInMinute;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function endOfDay(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setHours(23, 59, 59, 999);
  return date;
}
function endOfMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var month = date.getMonth();
  date.setFullYear(date.getFullYear(), month + 1, 0);
  date.setHours(23, 59, 59, 999);
  return date;
}
function isLastDayOfMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  return endOfDay(date).getTime() === endOfMonth(date).getTime();
}
function differenceInMonths(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var sign2 = compareAsc(dateLeft, dateRight);
  var difference2 = Math.abs(differenceInCalendarMonths(dateLeft, dateRight));
  var result;
  if (difference2 < 1) {
    result = 0;
  } else {
    if (dateLeft.getMonth() === 1 && dateLeft.getDate() > 27) {
      dateLeft.setDate(30);
    }
    dateLeft.setMonth(dateLeft.getMonth() - sign2 * difference2);
    var isLastMonthNotFull = compareAsc(dateLeft, dateRight) === -sign2;
    if (isLastDayOfMonth(toDate(dirtyDateLeft)) && difference2 === 1 && compareAsc(dirtyDateLeft, dateRight) === 1) {
      isLastMonthNotFull = false;
    }
    result = sign2 * (difference2 - Number(isLastMonthNotFull));
  }
  return result === 0 ? 0 : result;
}
function differenceInSeconds(dateLeft, dateRight, options) {
  requiredArgs(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / 1e3;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function differenceInYears(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var sign2 = compareAsc(dateLeft, dateRight);
  var difference2 = Math.abs(differenceInCalendarYears(dateLeft, dateRight));
  dateLeft.setFullYear(1584);
  dateRight.setFullYear(1584);
  var isLastYearNotFull = compareAsc(dateLeft, dateRight) === -sign2;
  var result = sign2 * (difference2 - Number(isLastYearNotFull));
  return result === 0 ? 0 : result;
}
function subMilliseconds(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMilliseconds(dirtyDate, -amount);
}
var MILLISECONDS_IN_DAY2 = 864e5;
function getUTCDayOfYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var timestamp = date.getTime();
  date.setUTCMonth(0, 1);
  date.setUTCHours(0, 0, 0, 0);
  var startOfYearTimestamp = date.getTime();
  var difference2 = timestamp - startOfYearTimestamp;
  return Math.floor(difference2 / MILLISECONDS_IN_DAY2) + 1;
}
function startOfUTCISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var weekStartsOn = 1;
  var date = toDate(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}
function getUTCISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getUTCFullYear();
  var fourthOfJanuaryOfNextYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfNextYear.setUTCFullYear(year + 1, 0, 4);
  fourthOfJanuaryOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCISOWeek(fourthOfJanuaryOfNextYear);
  var fourthOfJanuaryOfThisYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfThisYear.setUTCFullYear(year, 0, 4);
  fourthOfJanuaryOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCISOWeek(fourthOfJanuaryOfThisYear);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}
function startOfUTCISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var year = getUTCISOWeekYear(dirtyDate);
  var fourthOfJanuary = /* @__PURE__ */ new Date(0);
  fourthOfJanuary.setUTCFullYear(year, 0, 4);
  fourthOfJanuary.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCISOWeek(fourthOfJanuary);
  return date;
}
var MILLISECONDS_IN_WEEK = 6048e5;
function getUTCISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfUTCISOWeek(date).getTime() - startOfUTCISOWeekYear(date).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK) + 1;
}
function startOfUTCWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions22 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions22.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions22.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}
function getUTCWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getUTCFullYear();
  var defaultOptions22 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions22.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions22.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var firstWeekOfNextYear = /* @__PURE__ */ new Date(0);
  firstWeekOfNextYear.setUTCFullYear(year + 1, 0, firstWeekContainsDate);
  firstWeekOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCWeek(firstWeekOfNextYear, options);
  var firstWeekOfThisYear = /* @__PURE__ */ new Date(0);
  firstWeekOfThisYear.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeekOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCWeek(firstWeekOfThisYear, options);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}
function startOfUTCWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions22 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions22.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions22.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  var year = getUTCWeekYear(dirtyDate, options);
  var firstWeek = /* @__PURE__ */ new Date(0);
  firstWeek.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeek.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCWeek(firstWeek, options);
  return date;
}
var MILLISECONDS_IN_WEEK2 = 6048e5;
function getUTCWeek(dirtyDate, options) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfUTCWeek(date, options).getTime() - startOfUTCWeekYear(date, options).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK2) + 1;
}
function addLeadingZeros(number, targetLength) {
  var sign2 = number < 0 ? "-" : "";
  var output = Math.abs(number).toString();
  while (output.length < targetLength) {
    output = "0" + output;
  }
  return sign2 + output;
}
var formatters = {
  // Year
  y: function y3(date, token) {
    var signedYear = date.getUTCFullYear();
    var year = signedYear > 0 ? signedYear : 1 - signedYear;
    return addLeadingZeros(token === "yy" ? year % 100 : year, token.length);
  },
  // Month
  M: function M4(date, token) {
    var month = date.getUTCMonth();
    return token === "M" ? String(month + 1) : addLeadingZeros(month + 1, 2);
  },
  // Day of the month
  d: function d3(date, token) {
    return addLeadingZeros(date.getUTCDate(), token.length);
  },
  // AM or PM
  a: function a3(date, token) {
    var dayPeriodEnumValue = date.getUTCHours() / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return dayPeriodEnumValue.toUpperCase();
      case "aaa":
        return dayPeriodEnumValue;
      case "aaaaa":
        return dayPeriodEnumValue[0];
      case "aaaa":
      default:
        return dayPeriodEnumValue === "am" ? "a.m." : "p.m.";
    }
  },
  // Hour [1-12]
  h: function h13(date, token) {
    return addLeadingZeros(date.getUTCHours() % 12 || 12, token.length);
  },
  // Hour [0-23]
  H: function H3(date, token) {
    return addLeadingZeros(date.getUTCHours(), token.length);
  },
  // Minute
  m: function m3(date, token) {
    return addLeadingZeros(date.getUTCMinutes(), token.length);
  },
  // Second
  s: function s3(date, token) {
    return addLeadingZeros(date.getUTCSeconds(), token.length);
  },
  // Fraction of second
  S: function S3(date, token) {
    var numberOfDigits = token.length;
    var milliseconds = date.getUTCMilliseconds();
    var fractionalSeconds = Math.floor(milliseconds * Math.pow(10, numberOfDigits - 3));
    return addLeadingZeros(fractionalSeconds, token.length);
  }
};
var lightFormatters_default = formatters;
var dayPeriodEnum = {
  am: "am",
  pm: "pm",
  midnight: "midnight",
  noon: "noon",
  morning: "morning",
  afternoon: "afternoon",
  evening: "evening",
  night: "night"
};
var formatters2 = {
  // Era
  G: function G2(date, token, localize52) {
    var era = date.getUTCFullYear() > 0 ? 1 : 0;
    switch (token) {
      case "G":
      case "GG":
      case "GGG":
        return localize52.era(era, {
          width: "abbreviated"
        });
      case "GGGGG":
        return localize52.era(era, {
          width: "narrow"
        });
      case "GGGG":
      default:
        return localize52.era(era, {
          width: "wide"
        });
    }
  },
  // Year
  y: function y22(date, token, localize52) {
    if (token === "yo") {
      var signedYear = date.getUTCFullYear();
      var year = signedYear > 0 ? signedYear : 1 - signedYear;
      return localize52.ordinalNumber(year, {
        unit: "year"
      });
    }
    return lightFormatters_default.y(date, token);
  },
  // Local week-numbering year
  Y: function Y3(date, token, localize52, options) {
    var signedWeekYear = getUTCWeekYear(date, options);
    var weekYear = signedWeekYear > 0 ? signedWeekYear : 1 - signedWeekYear;
    if (token === "YY") {
      var twoDigitYear = weekYear % 100;
      return addLeadingZeros(twoDigitYear, 2);
    }
    if (token === "Yo") {
      return localize52.ordinalNumber(weekYear, {
        unit: "year"
      });
    }
    return addLeadingZeros(weekYear, token.length);
  },
  // ISO week-numbering year
  R: function R2(date, token) {
    var isoWeekYear = getUTCISOWeekYear(date);
    return addLeadingZeros(isoWeekYear, token.length);
  },
  // Extended year. This is a single number designating the year of this calendar system.
  // The main difference between `y` and `u` localizers are B.C. years:
  // | Year | `y` | `u` |
  // |------|-----|-----|
  // | AC 1 |   1 |   1 |
  // | BC 1 |   1 |   0 |
  // | BC 2 |   2 |  -1 |
  // Also `yy` always returns the last two digits of a year,
  // while `uu` pads single digit years to 2 characters and returns other years unchanged.
  u: function u3(date, token) {
    var year = date.getUTCFullYear();
    return addLeadingZeros(year, token.length);
  },
  // Quarter
  Q: function Q2(date, token, localize52) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "Q":
        return String(quarter);
      case "QQ":
        return addLeadingZeros(quarter, 2);
      case "Qo":
        return localize52.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "QQQ":
        return localize52.quarter(quarter, {
          width: "abbreviated",
          context: "formatting"
        });
      case "QQQQQ":
        return localize52.quarter(quarter, {
          width: "narrow",
          context: "formatting"
        });
      case "QQQQ":
      default:
        return localize52.quarter(quarter, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone quarter
  q: function q4(date, token, localize52) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "q":
        return String(quarter);
      case "qq":
        return addLeadingZeros(quarter, 2);
      case "qo":
        return localize52.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "qqq":
        return localize52.quarter(quarter, {
          width: "abbreviated",
          context: "standalone"
        });
      case "qqqqq":
        return localize52.quarter(quarter, {
          width: "narrow",
          context: "standalone"
        });
      case "qqqq":
      default:
        return localize52.quarter(quarter, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // Month
  M: function M22(date, token, localize52) {
    var month = date.getUTCMonth();
    switch (token) {
      case "M":
      case "MM":
        return lightFormatters_default.M(date, token);
      case "Mo":
        return localize52.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "MMM":
        return localize52.month(month, {
          width: "abbreviated",
          context: "formatting"
        });
      case "MMMMM":
        return localize52.month(month, {
          width: "narrow",
          context: "formatting"
        });
      case "MMMM":
      default:
        return localize52.month(month, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone month
  L: function L4(date, token, localize52) {
    var month = date.getUTCMonth();
    switch (token) {
      case "L":
        return String(month + 1);
      case "LL":
        return addLeadingZeros(month + 1, 2);
      case "Lo":
        return localize52.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "LLL":
        return localize52.month(month, {
          width: "abbreviated",
          context: "standalone"
        });
      case "LLLLL":
        return localize52.month(month, {
          width: "narrow",
          context: "standalone"
        });
      case "LLLL":
      default:
        return localize52.month(month, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // Local week of year
  w: function w4(date, token, localize52, options) {
    var week = getUTCWeek(date, options);
    if (token === "wo") {
      return localize52.ordinalNumber(week, {
        unit: "week"
      });
    }
    return addLeadingZeros(week, token.length);
  },
  // ISO week of year
  I: function I4(date, token, localize52) {
    var isoWeek = getUTCISOWeek(date);
    if (token === "Io") {
      return localize52.ordinalNumber(isoWeek, {
        unit: "week"
      });
    }
    return addLeadingZeros(isoWeek, token.length);
  },
  // Day of the month
  d: function d22(date, token, localize52) {
    if (token === "do") {
      return localize52.ordinalNumber(date.getUTCDate(), {
        unit: "date"
      });
    }
    return lightFormatters_default.d(date, token);
  },
  // Day of year
  D: function D4(date, token, localize52) {
    var dayOfYear = getUTCDayOfYear(date);
    if (token === "Do") {
      return localize52.ordinalNumber(dayOfYear, {
        unit: "dayOfYear"
      });
    }
    return addLeadingZeros(dayOfYear, token.length);
  },
  // Day of week
  E: function E2(date, token, localize52) {
    var dayOfWeek = date.getUTCDay();
    switch (token) {
      case "E":
      case "EE":
      case "EEE":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "EEEEE":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "EEEEEE":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "EEEE":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Local day of week
  e: function e3(date, token, localize52, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "e":
        return String(localDayOfWeek);
      case "ee":
        return addLeadingZeros(localDayOfWeek, 2);
      case "eo":
        return localize52.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "eee":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "eeeee":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "eeeeee":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "eeee":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone local day of week
  c: function c3(date, token, localize52, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "c":
        return String(localDayOfWeek);
      case "cc":
        return addLeadingZeros(localDayOfWeek, token.length);
      case "co":
        return localize52.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "ccc":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "standalone"
        });
      case "ccccc":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "standalone"
        });
      case "cccccc":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "standalone"
        });
      case "cccc":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // ISO day of week
  i: function i3(date, token, localize52) {
    var dayOfWeek = date.getUTCDay();
    var isoDayOfWeek = dayOfWeek === 0 ? 7 : dayOfWeek;
    switch (token) {
      case "i":
        return String(isoDayOfWeek);
      case "ii":
        return addLeadingZeros(isoDayOfWeek, token.length);
      case "io":
        return localize52.ordinalNumber(isoDayOfWeek, {
          unit: "day"
        });
      case "iii":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "iiiii":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "iiiiii":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "iiii":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM or PM
  a: function a22(date, token, localize52) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "aaa":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "aaaaa":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "aaaa":
      default:
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM, PM, midnight, noon
  b: function b3(date, token, localize52) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours === 12) {
      dayPeriodEnumValue = dayPeriodEnum.noon;
    } else if (hours === 0) {
      dayPeriodEnumValue = dayPeriodEnum.midnight;
    } else {
      dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    }
    switch (token) {
      case "b":
      case "bb":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "bbb":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "bbbbb":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "bbbb":
      default:
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // in the morning, in the afternoon, in the evening, at night
  B: function B4(date, token, localize52) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours >= 17) {
      dayPeriodEnumValue = dayPeriodEnum.evening;
    } else if (hours >= 12) {
      dayPeriodEnumValue = dayPeriodEnum.afternoon;
    } else if (hours >= 4) {
      dayPeriodEnumValue = dayPeriodEnum.morning;
    } else {
      dayPeriodEnumValue = dayPeriodEnum.night;
    }
    switch (token) {
      case "B":
      case "BB":
      case "BBB":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "BBBBB":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "BBBB":
      default:
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Hour [1-12]
  h: function h14(date, token, localize52) {
    if (token === "ho") {
      var hours = date.getUTCHours() % 12;
      if (hours === 0)
        hours = 12;
      return localize52.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return lightFormatters_default.h(date, token);
  },
  // Hour [0-23]
  H: function H22(date, token, localize52) {
    if (token === "Ho") {
      return localize52.ordinalNumber(date.getUTCHours(), {
        unit: "hour"
      });
    }
    return lightFormatters_default.H(date, token);
  },
  // Hour [0-11]
  K: function K4(date, token, localize52) {
    var hours = date.getUTCHours() % 12;
    if (token === "Ko") {
      return localize52.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros(hours, token.length);
  },
  // Hour [1-24]
  k: function k4(date, token, localize52) {
    var hours = date.getUTCHours();
    if (hours === 0)
      hours = 24;
    if (token === "ko") {
      return localize52.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros(hours, token.length);
  },
  // Minute
  m: function m22(date, token, localize52) {
    if (token === "mo") {
      return localize52.ordinalNumber(date.getUTCMinutes(), {
        unit: "minute"
      });
    }
    return lightFormatters_default.m(date, token);
  },
  // Second
  s: function s22(date, token, localize52) {
    if (token === "so") {
      return localize52.ordinalNumber(date.getUTCSeconds(), {
        unit: "second"
      });
    }
    return lightFormatters_default.s(date, token);
  },
  // Fraction of second
  S: function S22(date, token) {
    return lightFormatters_default.S(date, token);
  },
  // Timezone (ISO-8601. If offset is 0, output is always `'Z'`)
  X: function X3(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    if (timezoneOffset === 0) {
      return "Z";
    }
    switch (token) {
      case "X":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);
      case "XXXX":
      case "XX":
        return formatTimezone(timezoneOffset);
      case "XXXXX":
      case "XXX":
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (ISO-8601. If offset is 0, output is `'+00:00'` or equivalent)
  x: function x4(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "x":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);
      case "xxxx":
      case "xx":
        return formatTimezone(timezoneOffset);
      case "xxxxx":
      case "xxx":
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (GMT)
  O: function O3(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "O":
      case "OO":
      case "OOO":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      case "OOOO":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (specific non-location)
  z: function z4(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "z":
      case "zz":
      case "zzz":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      case "zzzz":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },
  // Seconds timestamp
  t: function t3(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = Math.floor(originalDate.getTime() / 1e3);
    return addLeadingZeros(timestamp, token.length);
  },
  // Milliseconds timestamp
  T: function T4(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = originalDate.getTime();
    return addLeadingZeros(timestamp, token.length);
  }
};
function formatTimezoneShort(offset, dirtyDelimiter) {
  var sign2 = offset > 0 ? "-" : "+";
  var absOffset = Math.abs(offset);
  var hours = Math.floor(absOffset / 60);
  var minutes = absOffset % 60;
  if (minutes === 0) {
    return sign2 + String(hours);
  }
  var delimiter2 = dirtyDelimiter || "";
  return sign2 + String(hours) + delimiter2 + addLeadingZeros(minutes, 2);
}
function formatTimezoneWithOptionalMinutes(offset, dirtyDelimiter) {
  if (offset % 60 === 0) {
    var sign2 = offset > 0 ? "-" : "+";
    return sign2 + addLeadingZeros(Math.abs(offset) / 60, 2);
  }
  return formatTimezone(offset, dirtyDelimiter);
}
function formatTimezone(offset, dirtyDelimiter) {
  var delimiter2 = dirtyDelimiter || "";
  var sign2 = offset > 0 ? "-" : "+";
  var absOffset = Math.abs(offset);
  var hours = addLeadingZeros(Math.floor(absOffset / 60), 2);
  var minutes = addLeadingZeros(absOffset % 60, 2);
  return sign2 + hours + delimiter2 + minutes;
}
var formatters_default = formatters2;
var dateLongFormatter = function dateLongFormatter2(pattern, formatLong62) {
  switch (pattern) {
    case "P":
      return formatLong62.date({
        width: "short"
      });
    case "PP":
      return formatLong62.date({
        width: "medium"
      });
    case "PPP":
      return formatLong62.date({
        width: "long"
      });
    case "PPPP":
    default:
      return formatLong62.date({
        width: "full"
      });
  }
};
var timeLongFormatter = function timeLongFormatter2(pattern, formatLong62) {
  switch (pattern) {
    case "p":
      return formatLong62.time({
        width: "short"
      });
    case "pp":
      return formatLong62.time({
        width: "medium"
      });
    case "ppp":
      return formatLong62.time({
        width: "long"
      });
    case "pppp":
    default:
      return formatLong62.time({
        width: "full"
      });
  }
};
var dateTimeLongFormatter = function dateTimeLongFormatter2(pattern, formatLong62) {
  var matchResult = pattern.match(/(P+)(p+)?/) || [];
  var datePattern = matchResult[1];
  var timePattern = matchResult[2];
  if (!timePattern) {
    return dateLongFormatter(pattern, formatLong62);
  }
  var dateTimeFormat;
  switch (datePattern) {
    case "P":
      dateTimeFormat = formatLong62.dateTime({
        width: "short"
      });
      break;
    case "PP":
      dateTimeFormat = formatLong62.dateTime({
        width: "medium"
      });
      break;
    case "PPP":
      dateTimeFormat = formatLong62.dateTime({
        width: "long"
      });
      break;
    case "PPPP":
    default:
      dateTimeFormat = formatLong62.dateTime({
        width: "full"
      });
      break;
  }
  return dateTimeFormat.replace("{{date}}", dateLongFormatter(datePattern, formatLong62)).replace("{{time}}", timeLongFormatter(timePattern, formatLong62));
};
var longFormatters = {
  p: timeLongFormatter,
  P: dateTimeLongFormatter
};
var longFormatters_default = longFormatters;
var protectedDayOfYearTokens = ["D", "DD"];
var protectedWeekYearTokens = ["YY", "YYYY"];
function isProtectedDayOfYearToken(token) {
  return protectedDayOfYearTokens.indexOf(token) !== -1;
}
function isProtectedWeekYearToken(token) {
  return protectedWeekYearTokens.indexOf(token) !== -1;
}
function throwProtectedError(token, format22, input) {
  if (token === "YYYY") {
    throw new RangeError("Use `yyyy` instead of `YYYY` (in `".concat(format22, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "YY") {
    throw new RangeError("Use `yy` instead of `YY` (in `".concat(format22, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "D") {
    throw new RangeError("Use `d` instead of `D` (in `".concat(format22, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "DD") {
    throw new RangeError("Use `dd` instead of `DD` (in `".concat(format22, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  }
}
var formatDistanceLocale = {
  lessThanXSeconds: {
    one: "less than a second",
    other: "less than {{count}} seconds"
  },
  xSeconds: {
    one: "1 second",
    other: "{{count}} seconds"
  },
  halfAMinute: "half a minute",
  lessThanXMinutes: {
    one: "less than a minute",
    other: "less than {{count}} minutes"
  },
  xMinutes: {
    one: "1 minute",
    other: "{{count}} minutes"
  },
  aboutXHours: {
    one: "about 1 hour",
    other: "about {{count}} hours"
  },
  xHours: {
    one: "1 hour",
    other: "{{count}} hours"
  },
  xDays: {
    one: "1 day",
    other: "{{count}} days"
  },
  aboutXWeeks: {
    one: "about 1 week",
    other: "about {{count}} weeks"
  },
  xWeeks: {
    one: "1 week",
    other: "{{count}} weeks"
  },
  aboutXMonths: {
    one: "about 1 month",
    other: "about {{count}} months"
  },
  xMonths: {
    one: "1 month",
    other: "{{count}} months"
  },
  aboutXYears: {
    one: "about 1 year",
    other: "about {{count}} years"
  },
  xYears: {
    one: "1 year",
    other: "{{count}} years"
  },
  overXYears: {
    one: "over 1 year",
    other: "over {{count}} years"
  },
  almostXYears: {
    one: "almost 1 year",
    other: "almost {{count}} years"
  }
};
var formatDistance = function formatDistance2(token, count, options) {
  var result;
  var tokenValue = formatDistanceLocale[token];
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace("{{count}}", count.toString());
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "in " + result;
    } else {
      return result + " ago";
    }
  }
  return result;
};
var formatDistance_default = formatDistance;
function buildFormatLongFn(args) {
  return function() {
    var options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    var width = options.width ? String(options.width) : args.defaultWidth;
    var format22 = args.formats[width] || args.formats[args.defaultWidth];
    return format22;
  };
}
var dateFormats = {
  full: "EEEE, MMMM do, y",
  long: "MMMM do, y",
  medium: "MMM d, y",
  short: "MM/dd/yyyy"
};
var timeFormats = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a"
};
var dateTimeFormats = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong = {
  date: buildFormatLongFn({
    formats: dateFormats,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn({
    formats: timeFormats,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn({
    formats: dateTimeFormats,
    defaultWidth: "full"
  })
};
var formatLong_default = formatLong;
var formatRelativeLocale = {
  lastWeek: "'last' eeee 'at' p",
  yesterday: "'yesterday at' p",
  today: "'today at' p",
  tomorrow: "'tomorrow at' p",
  nextWeek: "eeee 'at' p",
  other: "P"
};
var formatRelative = function formatRelative2(token, _date, _baseDate, _options) {
  return formatRelativeLocale[token];
};
var formatRelative_default = formatRelative;
function buildLocalizeFn(args) {
  return function(dirtyIndex, options) {
    var context = options !== null && options !== void 0 && options.context ? String(options.context) : "standalone";
    var valuesArray;
    if (context === "formatting" && args.formattingValues) {
      var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
      var width = options !== null && options !== void 0 && options.width ? String(options.width) : defaultWidth;
      valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
    } else {
      var _defaultWidth = args.defaultWidth;
      var _width = options !== null && options !== void 0 && options.width ? String(options.width) : args.defaultWidth;
      valuesArray = args.values[_width] || args.values[_defaultWidth];
    }
    var index = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
    return valuesArray[index];
  };
}
var eraValues = {
  narrow: ["B", "A"],
  abbreviated: ["BC", "AD"],
  wide: ["Before Christ", "Anno Domini"]
};
var quarterValues = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["Q1", "Q2", "Q3", "Q4"],
  wide: ["1st quarter", "2nd quarter", "3rd quarter", "4th quarter"]
};
var monthValues = {
  narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
  abbreviated: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
  wide: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
};
var dayValues = {
  narrow: ["S", "M", "T", "W", "T", "F", "S"],
  short: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
  abbreviated: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
  wide: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
};
var dayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  }
};
var formattingDayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  }
};
var ordinalNumber = function ordinalNumber2(dirtyNumber, _options) {
  var number = Number(dirtyNumber);
  var rem100 = number % 100;
  if (rem100 > 20 || rem100 < 10) {
    switch (rem100 % 10) {
      case 1:
        return number + "st";
      case 2:
        return number + "nd";
      case 3:
        return number + "rd";
    }
  }
  return number + "th";
};
var localize = {
  ordinalNumber,
  era: buildLocalizeFn({
    values: eraValues,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn({
    values: quarterValues,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback(quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn({
    values: monthValues,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn({
    values: dayValues,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn({
    values: dayPeriodValues,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues,
    defaultFormattingWidth: "wide"
  })
};
var localize_default = localize;
function buildMatchFn(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var width = options.width;
    var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
    var matchResult = string.match(matchPattern);
    if (!matchResult) {
      return null;
    }
    var matchedString = matchResult[0];
    var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
    var key = Array.isArray(parsePatterns) ? findIndex(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    }) : findKey(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    });
    var value;
    value = args.valueCallback ? args.valueCallback(key) : key;
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}
function findKey(object, predicate) {
  for (var key in object) {
    if (object.hasOwnProperty(key) && predicate(object[key])) {
      return key;
    }
  }
  return void 0;
}
function findIndex(array, predicate) {
  for (var key = 0; key < array.length; key++) {
    if (predicate(array[key])) {
      return key;
    }
  }
  return void 0;
}
function buildMatchPatternFn(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var matchResult = string.match(args.matchPattern);
    if (!matchResult)
      return null;
    var matchedString = matchResult[0];
    var parseResult = string.match(args.parsePattern);
    if (!parseResult)
      return null;
    var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}
var matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern = /\d+/i;
var matchEraPatterns = {
  narrow: /^(b|a)/i,
  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
  wide: /^(before christ|before common era|anno domini|common era)/i
};
var parseEraPatterns = {
  any: [/^b/i, /^(a|c)/i]
};
var matchQuarterPatterns = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](th|st|nd|rd)? quarter/i
};
var parseQuarterPatterns = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
};
var parseMonthPatterns = {
  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
};
var matchDayPatterns = {
  narrow: /^[smtwf]/i,
  short: /^(su|mo|tu|we|th|fr|sa)/i,
  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
};
var parseDayPatterns = {
  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
};
var matchDayPeriodPatterns = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
};
var parseDayPeriodPatterns = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
};
var match = {
  ordinalNumber: buildMatchPatternFn({
    matchPattern: matchOrdinalNumberPattern,
    parsePattern: parseOrdinalNumberPattern,
    valueCallback: function valueCallback(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn({
    matchPatterns: matchEraPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn({
    matchPatterns: matchQuarterPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns,
    defaultParseWidth: "any",
    valueCallback: function valueCallback2(index) {
      return index + 1;
    }
  }),
  month: buildMatchFn({
    matchPatterns: matchMonthPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn({
    matchPatterns: matchDayPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn({
    matchPatterns: matchDayPeriodPatterns,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns,
    defaultParseWidth: "any"
  })
};
var match_default = match;
var locale = {
  code: "en-US",
  formatDistance: formatDistance_default,
  formatLong: formatLong_default,
  formatRelative: formatRelative_default,
  localize: localize_default,
  match: match_default,
  options: {
    weekStartsOn: 0,
    firstWeekContainsDate: 1
  }
};
var en_US_default = locale;
var defaultLocale_default = en_US_default;
var formattingTokensRegExp = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
var longFormattingTokensRegExp = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
var escapedStringRegExp = /^'([^]*?)'?$/;
var doubleQuoteRegExp = /''/g;
var unescapedLatinCharacterRegExp = /[a-zA-Z]/;
function format(dirtyDate, dirtyFormatStr, options) {
  var _ref, _options$locale, _ref2, _ref3, _ref4, _options$firstWeekCon, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2, _ref5, _ref6, _ref7, _options$weekStartsOn, _options$locale3, _options$locale3$opti, _defaultOptions$local3, _defaultOptions$local4;
  requiredArgs(2, arguments);
  var formatStr = String(dirtyFormatStr);
  var defaultOptions22 = getDefaultOptions();
  var locale62 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions22.locale) !== null && _ref !== void 0 ? _ref : defaultLocale_default;
  var firstWeekContainsDate = toInteger((_ref2 = (_ref3 = (_ref4 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.firstWeekContainsDate) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions22.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions22.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var weekStartsOn = toInteger((_ref5 = (_ref6 = (_ref7 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale3 = options.locale) === null || _options$locale3 === void 0 ? void 0 : (_options$locale3$opti = _options$locale3.options) === null || _options$locale3$opti === void 0 ? void 0 : _options$locale3$opti.weekStartsOn) !== null && _ref7 !== void 0 ? _ref7 : defaultOptions22.weekStartsOn) !== null && _ref6 !== void 0 ? _ref6 : (_defaultOptions$local3 = defaultOptions22.locale) === null || _defaultOptions$local3 === void 0 ? void 0 : (_defaultOptions$local4 = _defaultOptions$local3.options) === null || _defaultOptions$local4 === void 0 ? void 0 : _defaultOptions$local4.weekStartsOn) !== null && _ref5 !== void 0 ? _ref5 : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  if (!locale62.localize) {
    throw new RangeError("locale must contain localize property");
  }
  if (!locale62.formatLong) {
    throw new RangeError("locale must contain formatLong property");
  }
  var originalDate = toDate(dirtyDate);
  if (!isValid(originalDate)) {
    throw new RangeError("Invalid time value");
  }
  var timezoneOffset = getTimezoneOffsetInMilliseconds(originalDate);
  var utcDate = subMilliseconds(originalDate, timezoneOffset);
  var formatterOptions = {
    firstWeekContainsDate,
    weekStartsOn,
    locale: locale62,
    _originalDate: originalDate
  };
  var result = formatStr.match(longFormattingTokensRegExp).map(function(substring) {
    var firstCharacter = substring[0];
    if (firstCharacter === "p" || firstCharacter === "P") {
      var longFormatter = longFormatters_default[firstCharacter];
      return longFormatter(substring, locale62.formatLong);
    }
    return substring;
  }).join("").match(formattingTokensRegExp).map(function(substring) {
    if (substring === "''") {
      return "'";
    }
    var firstCharacter = substring[0];
    if (firstCharacter === "'") {
      return cleanEscapedString(substring);
    }
    var formatter = formatters_default[firstCharacter];
    if (formatter) {
      if (!(options !== null && options !== void 0 && options.useAdditionalWeekYearTokens) && isProtectedWeekYearToken(substring)) {
        throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
      }
      if (!(options !== null && options !== void 0 && options.useAdditionalDayOfYearTokens) && isProtectedDayOfYearToken(substring)) {
        throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
      }
      return formatter(utcDate, substring, locale62.localize, formatterOptions);
    }
    if (firstCharacter.match(unescapedLatinCharacterRegExp)) {
      throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
    }
    return substring;
  }).join("");
  return result;
}
function cleanEscapedString(input) {
  var matched = input.match(escapedStringRegExp);
  if (!matched) {
    return input;
  }
  return matched[1].replace(doubleQuoteRegExp, "'");
}
var defaultFormat = ["years", "months", "weeks", "days", "hours", "minutes", "seconds"];
function formatDuration(duration, options) {
  var _ref, _options$locale, _options$format, _options$zero, _options$delimiter;
  if (arguments.length < 1) {
    throw new TypeError("1 argument required, but only ".concat(arguments.length, " present"));
  }
  var defaultOptions22 = getDefaultOptions();
  var locale62 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions22.locale) !== null && _ref !== void 0 ? _ref : defaultLocale_default;
  var format22 = (_options$format = options === null || options === void 0 ? void 0 : options.format) !== null && _options$format !== void 0 ? _options$format : defaultFormat;
  var zero = (_options$zero = options === null || options === void 0 ? void 0 : options.zero) !== null && _options$zero !== void 0 ? _options$zero : false;
  var delimiter2 = (_options$delimiter = options === null || options === void 0 ? void 0 : options.delimiter) !== null && _options$delimiter !== void 0 ? _options$delimiter : " ";
  if (!locale62.formatDistance) {
    return "";
  }
  var result = format22.reduce(function(acc, unit) {
    var token = "x".concat(unit.replace(/(^.)/, function(m32) {
      return m32.toUpperCase();
    }));
    var value = duration[unit];
    if (typeof value === "number" && (zero || duration[unit])) {
      return acc.concat(locale62.formatDistance(token, value));
    }
    return acc;
  }, []).join(delimiter2);
  return result;
}
function formatISO(date, options) {
  var _options$format, _options$representati;
  requiredArgs(1, arguments);
  var originalDate = toDate(date);
  if (isNaN(originalDate.getTime())) {
    throw new RangeError("Invalid time value");
  }
  var format22 = String((_options$format = options === null || options === void 0 ? void 0 : options.format) !== null && _options$format !== void 0 ? _options$format : "extended");
  var representation = String((_options$representati = options === null || options === void 0 ? void 0 : options.representation) !== null && _options$representati !== void 0 ? _options$representati : "complete");
  if (format22 !== "extended" && format22 !== "basic") {
    throw new RangeError("format must be 'extended' or 'basic'");
  }
  if (representation !== "date" && representation !== "time" && representation !== "complete") {
    throw new RangeError("representation must be 'date', 'time', or 'complete'");
  }
  var result = "";
  var tzOffset = "";
  var dateDelimiter = format22 === "extended" ? "-" : "";
  var timeDelimiter = format22 === "extended" ? ":" : "";
  if (representation !== "time") {
    var day = addLeadingZeros(originalDate.getDate(), 2);
    var month = addLeadingZeros(originalDate.getMonth() + 1, 2);
    var year = addLeadingZeros(originalDate.getFullYear(), 4);
    result = "".concat(year).concat(dateDelimiter).concat(month).concat(dateDelimiter).concat(day);
  }
  if (representation !== "date") {
    var offset = originalDate.getTimezoneOffset();
    if (offset !== 0) {
      var absoluteOffset = Math.abs(offset);
      var hourOffset = addLeadingZeros(Math.floor(absoluteOffset / 60), 2);
      var minuteOffset = addLeadingZeros(absoluteOffset % 60, 2);
      var sign2 = offset < 0 ? "+" : "-";
      tzOffset = "".concat(sign2).concat(hourOffset, ":").concat(minuteOffset);
    } else {
      tzOffset = "Z";
    }
    var hour = addLeadingZeros(originalDate.getHours(), 2);
    var minute = addLeadingZeros(originalDate.getMinutes(), 2);
    var second = addLeadingZeros(originalDate.getSeconds(), 2);
    var separator = result === "" ? "" : "T";
    var time = [hour, minute, second].join(timeDelimiter);
    result = "".concat(result).concat(separator).concat(time).concat(tzOffset);
  }
  return result;
}
function getMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var month = date.getMonth();
  return month;
}
function getYear(dirtyDate) {
  requiredArgs(1, arguments);
  return toDate(dirtyDate).getFullYear();
}
function intervalToDuration(interval) {
  requiredArgs(1, arguments);
  var start = toDate(interval.start);
  var end = toDate(interval.end);
  if (isNaN(start.getTime()))
    throw new RangeError("Start Date is invalid");
  if (isNaN(end.getTime()))
    throw new RangeError("End Date is invalid");
  var duration = {};
  duration.years = Math.abs(differenceInYears(end, start));
  var sign2 = compareAsc(end, start);
  var remainingMonths = add2(start, {
    years: sign2 * duration.years
  });
  duration.months = Math.abs(differenceInMonths(end, remainingMonths));
  var remainingDays = add2(remainingMonths, {
    months: sign2 * duration.months
  });
  duration.days = Math.abs(differenceInDays(end, remainingDays));
  var remainingHours = add2(remainingDays, {
    days: sign2 * duration.days
  });
  duration.hours = Math.abs(differenceInHours(end, remainingHours));
  var remainingMinutes = add2(remainingHours, {
    hours: sign2 * duration.hours
  });
  duration.minutes = Math.abs(differenceInMinutes(end, remainingMinutes));
  var remainingSeconds = add2(remainingMinutes, {
    minutes: sign2 * duration.minutes
  });
  duration.seconds = Math.abs(differenceInSeconds(end, remainingSeconds));
  return duration;
}
function _typeof4(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof4 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof4 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof4(obj);
}
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf(subClass, superClass);
}
function _setPrototypeOf(o3, p4) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf(o3, p4);
}
function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}
function _possibleConstructorReturn(self2, call) {
  if (call && (_typeof4(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized(self2);
}
function _assertThisInitialized(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf(o3) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf(o3);
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  return Constructor;
}
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var Setter = /* @__PURE__ */ function() {
  function Setter2() {
    _classCallCheck(this, Setter2);
    _defineProperty(this, "subPriority", 0);
  }
  _createClass(Setter2, [{
    key: "validate",
    value: function validate(_utcDate, _options) {
      return true;
    }
  }]);
  return Setter2;
}();
var ValueSetter = /* @__PURE__ */ function(_Setter) {
  _inherits(ValueSetter2, _Setter);
  var _super = _createSuper(ValueSetter2);
  function ValueSetter2(value, validateValue, setValue, priority, subPriority) {
    var _this;
    _classCallCheck(this, ValueSetter2);
    _this = _super.call(this);
    _this.value = value;
    _this.validateValue = validateValue;
    _this.setValue = setValue;
    _this.priority = priority;
    if (subPriority) {
      _this.subPriority = subPriority;
    }
    return _this;
  }
  _createClass(ValueSetter2, [{
    key: "validate",
    value: function validate(utcDate, options) {
      return this.validateValue(utcDate, this.value, options);
    }
  }, {
    key: "set",
    value: function set(utcDate, flags, options) {
      return this.setValue(utcDate, flags, this.value, options);
    }
  }]);
  return ValueSetter2;
}(Setter);
function _classCallCheck2(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties2(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass2(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties2(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties2(Constructor, staticProps);
  return Constructor;
}
var Parser = /* @__PURE__ */ function() {
  function Parser2() {
    _classCallCheck2(this, Parser2);
  }
  _createClass2(Parser2, [{
    key: "run",
    value: function run(dateString, token, match52, options) {
      var result = this.parse(dateString, token, match52, options);
      if (!result) {
        return null;
      }
      return {
        setter: new ValueSetter(result.value, this.validate, this.set, this.priority, this.subPriority),
        rest: result.rest
      };
    }
  }, {
    key: "validate",
    value: function validate(_utcDate, _value, _options) {
      return true;
    }
  }]);
  return Parser2;
}();
function _typeof5(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof5 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof5 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof5(obj);
}
function _classCallCheck3(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties3(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass3(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties3(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties3(Constructor, staticProps);
  return Constructor;
}
function _inherits2(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf2(subClass, superClass);
}
function _setPrototypeOf2(o3, p4) {
  _setPrototypeOf2 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf2(o3, p4);
}
function _createSuper2(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct2();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf2(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf2(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn2(this, result);
  };
}
function _possibleConstructorReturn2(self2, call) {
  if (call && (_typeof5(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized2(self2);
}
function _assertThisInitialized2(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct2() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf2(o3) {
  _getPrototypeOf2 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf2(o3);
}
function _defineProperty2(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var EraParser = /* @__PURE__ */ function(_Parser) {
  _inherits2(EraParser2, _Parser);
  var _super = _createSuper2(EraParser2);
  function EraParser2() {
    var _this;
    _classCallCheck3(this, EraParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty2(_assertThisInitialized2(_this), "priority", 140);
    _defineProperty2(_assertThisInitialized2(_this), "incompatibleTokens", ["R", "u", "t", "T"]);
    return _this;
  }
  _createClass3(EraParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "G":
        case "GG":
        case "GGG":
          return match52.era(dateString, {
            width: "abbreviated"
          }) || match52.era(dateString, {
            width: "narrow"
          });
        case "GGGGG":
          return match52.era(dateString, {
            width: "narrow"
          });
        case "GGGG":
        default:
          return match52.era(dateString, {
            width: "wide"
          }) || match52.era(dateString, {
            width: "abbreviated"
          }) || match52.era(dateString, {
            width: "narrow"
          });
      }
    }
  }, {
    key: "set",
    value: function set(date, flags, value) {
      flags.era = value;
      date.setUTCFullYear(value, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return EraParser2;
}(Parser);
var numericPatterns = {
  month: /^(1[0-2]|0?\d)/,
  // 0 to 12
  date: /^(3[0-1]|[0-2]?\d)/,
  // 0 to 31
  dayOfYear: /^(36[0-6]|3[0-5]\d|[0-2]?\d?\d)/,
  // 0 to 366
  week: /^(5[0-3]|[0-4]?\d)/,
  // 0 to 53
  hour23h: /^(2[0-3]|[0-1]?\d)/,
  // 0 to 23
  hour24h: /^(2[0-4]|[0-1]?\d)/,
  // 0 to 24
  hour11h: /^(1[0-1]|0?\d)/,
  // 0 to 11
  hour12h: /^(1[0-2]|0?\d)/,
  // 0 to 12
  minute: /^[0-5]?\d/,
  // 0 to 59
  second: /^[0-5]?\d/,
  // 0 to 59
  singleDigit: /^\d/,
  // 0 to 9
  twoDigits: /^\d{1,2}/,
  // 0 to 99
  threeDigits: /^\d{1,3}/,
  // 0 to 999
  fourDigits: /^\d{1,4}/,
  // 0 to 9999
  anyDigitsSigned: /^-?\d+/,
  singleDigitSigned: /^-?\d/,
  // 0 to 9, -0 to -9
  twoDigitsSigned: /^-?\d{1,2}/,
  // 0 to 99, -0 to -99
  threeDigitsSigned: /^-?\d{1,3}/,
  // 0 to 999, -0 to -999
  fourDigitsSigned: /^-?\d{1,4}/
  // 0 to 9999, -0 to -9999
};
var timezonePatterns = {
  basicOptionalMinutes: /^([+-])(\d{2})(\d{2})?|Z/,
  basic: /^([+-])(\d{2})(\d{2})|Z/,
  basicOptionalSeconds: /^([+-])(\d{2})(\d{2})((\d{2}))?|Z/,
  extended: /^([+-])(\d{2}):(\d{2})|Z/,
  extendedOptionalSeconds: /^([+-])(\d{2}):(\d{2})(:(\d{2}))?|Z/
};
function mapValue(parseFnResult, mapFn) {
  if (!parseFnResult) {
    return parseFnResult;
  }
  return {
    value: mapFn(parseFnResult.value),
    rest: parseFnResult.rest
  };
}
function parseNumericPattern(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  return {
    value: parseInt(matchResult[0], 10),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseTimezonePattern(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  if (matchResult[0] === "Z") {
    return {
      value: 0,
      rest: dateString.slice(1)
    };
  }
  var sign2 = matchResult[1] === "+" ? 1 : -1;
  var hours = matchResult[2] ? parseInt(matchResult[2], 10) : 0;
  var minutes = matchResult[3] ? parseInt(matchResult[3], 10) : 0;
  var seconds = matchResult[5] ? parseInt(matchResult[5], 10) : 0;
  return {
    value: sign2 * (hours * millisecondsInHour + minutes * millisecondsInMinute + seconds * millisecondsInSecond),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseAnyDigitsSigned(dateString) {
  return parseNumericPattern(numericPatterns.anyDigitsSigned, dateString);
}
function parseNDigits(n2, dateString) {
  switch (n2) {
    case 1:
      return parseNumericPattern(numericPatterns.singleDigit, dateString);
    case 2:
      return parseNumericPattern(numericPatterns.twoDigits, dateString);
    case 3:
      return parseNumericPattern(numericPatterns.threeDigits, dateString);
    case 4:
      return parseNumericPattern(numericPatterns.fourDigits, dateString);
    default:
      return parseNumericPattern(new RegExp("^\\d{1," + n2 + "}"), dateString);
  }
}
function parseNDigitsSigned(n2, dateString) {
  switch (n2) {
    case 1:
      return parseNumericPattern(numericPatterns.singleDigitSigned, dateString);
    case 2:
      return parseNumericPattern(numericPatterns.twoDigitsSigned, dateString);
    case 3:
      return parseNumericPattern(numericPatterns.threeDigitsSigned, dateString);
    case 4:
      return parseNumericPattern(numericPatterns.fourDigitsSigned, dateString);
    default:
      return parseNumericPattern(new RegExp("^-?\\d{1," + n2 + "}"), dateString);
  }
}
function dayPeriodEnumToHours(dayPeriod) {
  switch (dayPeriod) {
    case "morning":
      return 4;
    case "evening":
      return 17;
    case "pm":
    case "noon":
    case "afternoon":
      return 12;
    case "am":
    case "midnight":
    case "night":
    default:
      return 0;
  }
}
function normalizeTwoDigitYear(twoDigitYear, currentYear) {
  var isCommonEra = currentYear > 0;
  var absCurrentYear = isCommonEra ? currentYear : 1 - currentYear;
  var result;
  if (absCurrentYear <= 50) {
    result = twoDigitYear || 100;
  } else {
    var rangeEnd = absCurrentYear + 50;
    var rangeEndCentury = Math.floor(rangeEnd / 100) * 100;
    var isPreviousCentury = twoDigitYear >= rangeEnd % 100;
    result = twoDigitYear + rangeEndCentury - (isPreviousCentury ? 100 : 0);
  }
  return isCommonEra ? result : 1 - result;
}
function isLeapYearIndex(year) {
  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
}
function _typeof6(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof6 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof6 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof6(obj);
}
function _classCallCheck4(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties4(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass4(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties4(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties4(Constructor, staticProps);
  return Constructor;
}
function _inherits3(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf3(subClass, superClass);
}
function _setPrototypeOf3(o3, p4) {
  _setPrototypeOf3 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf3(o3, p4);
}
function _createSuper3(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct3();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf3(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf3(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn3(this, result);
  };
}
function _possibleConstructorReturn3(self2, call) {
  if (call && (_typeof6(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized3(self2);
}
function _assertThisInitialized3(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct3() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf3(o3) {
  _getPrototypeOf3 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf3(o3);
}
function _defineProperty3(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var YearParser = /* @__PURE__ */ function(_Parser) {
  _inherits3(YearParser2, _Parser);
  var _super = _createSuper3(YearParser2);
  function YearParser2() {
    var _this;
    _classCallCheck4(this, YearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty3(_assertThisInitialized3(_this), "priority", 130);
    _defineProperty3(_assertThisInitialized3(_this), "incompatibleTokens", ["Y", "R", "u", "w", "I", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass4(YearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      var valueCallback92 = function valueCallback102(year) {
        return {
          year,
          isTwoDigitYear: token === "yy"
        };
      };
      switch (token) {
        case "y":
          return mapValue(parseNDigits(4, dateString), valueCallback92);
        case "yo":
          return mapValue(match52.ordinalNumber(dateString, {
            unit: "year"
          }), valueCallback92);
        default:
          return mapValue(parseNDigits(token.length, dateString), valueCallback92);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value.isTwoDigitYear || value.year > 0;
    }
  }, {
    key: "set",
    value: function set(date, flags, value) {
      var currentYear = date.getUTCFullYear();
      if (value.isTwoDigitYear) {
        var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
        date.setUTCFullYear(normalizedTwoDigitYear, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      }
      var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
      date.setUTCFullYear(year, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return YearParser2;
}(Parser);
function _typeof7(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof7 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof7 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof7(obj);
}
function _classCallCheck5(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties5(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass5(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties5(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties5(Constructor, staticProps);
  return Constructor;
}
function _inherits4(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf4(subClass, superClass);
}
function _setPrototypeOf4(o3, p4) {
  _setPrototypeOf4 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf4(o3, p4);
}
function _createSuper4(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct4();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf4(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf4(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn4(this, result);
  };
}
function _possibleConstructorReturn4(self2, call) {
  if (call && (_typeof7(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized4(self2);
}
function _assertThisInitialized4(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct4() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf4(o3) {
  _getPrototypeOf4 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf4(o3);
}
function _defineProperty4(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var LocalWeekYearParser = /* @__PURE__ */ function(_Parser) {
  _inherits4(LocalWeekYearParser2, _Parser);
  var _super = _createSuper4(LocalWeekYearParser2);
  function LocalWeekYearParser2() {
    var _this;
    _classCallCheck5(this, LocalWeekYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty4(_assertThisInitialized4(_this), "priority", 130);
    _defineProperty4(_assertThisInitialized4(_this), "incompatibleTokens", ["y", "R", "u", "Q", "q", "M", "L", "I", "d", "D", "i", "t", "T"]);
    return _this;
  }
  _createClass5(LocalWeekYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      var valueCallback92 = function valueCallback102(year) {
        return {
          year,
          isTwoDigitYear: token === "YY"
        };
      };
      switch (token) {
        case "Y":
          return mapValue(parseNDigits(4, dateString), valueCallback92);
        case "Yo":
          return mapValue(match52.ordinalNumber(dateString, {
            unit: "year"
          }), valueCallback92);
        default:
          return mapValue(parseNDigits(token.length, dateString), valueCallback92);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value.isTwoDigitYear || value.year > 0;
    }
  }, {
    key: "set",
    value: function set(date, flags, value, options) {
      var currentYear = getUTCWeekYear(date, options);
      if (value.isTwoDigitYear) {
        var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
        date.setUTCFullYear(normalizedTwoDigitYear, 0, options.firstWeekContainsDate);
        date.setUTCHours(0, 0, 0, 0);
        return startOfUTCWeek(date, options);
      }
      var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
      date.setUTCFullYear(year, 0, options.firstWeekContainsDate);
      date.setUTCHours(0, 0, 0, 0);
      return startOfUTCWeek(date, options);
    }
  }]);
  return LocalWeekYearParser2;
}(Parser);
function _typeof8(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof8 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof8 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof8(obj);
}
function _classCallCheck6(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties6(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass6(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties6(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties6(Constructor, staticProps);
  return Constructor;
}
function _inherits5(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf5(subClass, superClass);
}
function _setPrototypeOf5(o3, p4) {
  _setPrototypeOf5 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf5(o3, p4);
}
function _createSuper5(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct5();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf5(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf5(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn5(this, result);
  };
}
function _possibleConstructorReturn5(self2, call) {
  if (call && (_typeof8(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized5(self2);
}
function _assertThisInitialized5(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct5() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf5(o3) {
  _getPrototypeOf5 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf5(o3);
}
function _defineProperty5(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var ISOWeekYearParser = /* @__PURE__ */ function(_Parser) {
  _inherits5(ISOWeekYearParser2, _Parser);
  var _super = _createSuper5(ISOWeekYearParser2);
  function ISOWeekYearParser2() {
    var _this;
    _classCallCheck6(this, ISOWeekYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty5(_assertThisInitialized5(_this), "priority", 130);
    _defineProperty5(_assertThisInitialized5(_this), "incompatibleTokens", ["G", "y", "Y", "u", "Q", "q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass6(ISOWeekYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      if (token === "R") {
        return parseNDigitsSigned(4, dateString);
      }
      return parseNDigitsSigned(token.length, dateString);
    }
  }, {
    key: "set",
    value: function set(_date, _flags, value) {
      var firstWeekOfYear = /* @__PURE__ */ new Date(0);
      firstWeekOfYear.setUTCFullYear(value, 0, 4);
      firstWeekOfYear.setUTCHours(0, 0, 0, 0);
      return startOfUTCISOWeek(firstWeekOfYear);
    }
  }]);
  return ISOWeekYearParser2;
}(Parser);
function _typeof9(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof9 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof9 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof9(obj);
}
function _classCallCheck7(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties7(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass7(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties7(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties7(Constructor, staticProps);
  return Constructor;
}
function _inherits6(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf6(subClass, superClass);
}
function _setPrototypeOf6(o3, p4) {
  _setPrototypeOf6 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf6(o3, p4);
}
function _createSuper6(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct6();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf6(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf6(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn6(this, result);
  };
}
function _possibleConstructorReturn6(self2, call) {
  if (call && (_typeof9(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized6(self2);
}
function _assertThisInitialized6(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct6() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf6(o3) {
  _getPrototypeOf6 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf6(o3);
}
function _defineProperty6(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var ExtendedYearParser = /* @__PURE__ */ function(_Parser) {
  _inherits6(ExtendedYearParser2, _Parser);
  var _super = _createSuper6(ExtendedYearParser2);
  function ExtendedYearParser2() {
    var _this;
    _classCallCheck7(this, ExtendedYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty6(_assertThisInitialized6(_this), "priority", 130);
    _defineProperty6(_assertThisInitialized6(_this), "incompatibleTokens", ["G", "y", "Y", "R", "w", "I", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass7(ExtendedYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      if (token === "u") {
        return parseNDigitsSigned(4, dateString);
      }
      return parseNDigitsSigned(token.length, dateString);
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCFullYear(value, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return ExtendedYearParser2;
}(Parser);
function _typeof10(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof10 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof10 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof10(obj);
}
function _classCallCheck8(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties8(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass8(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties8(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties8(Constructor, staticProps);
  return Constructor;
}
function _inherits7(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf7(subClass, superClass);
}
function _setPrototypeOf7(o3, p4) {
  _setPrototypeOf7 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf7(o3, p4);
}
function _createSuper7(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct7();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf7(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf7(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn7(this, result);
  };
}
function _possibleConstructorReturn7(self2, call) {
  if (call && (_typeof10(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized7(self2);
}
function _assertThisInitialized7(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct7() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf7(o3) {
  _getPrototypeOf7 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf7(o3);
}
function _defineProperty7(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var QuarterParser = /* @__PURE__ */ function(_Parser) {
  _inherits7(QuarterParser2, _Parser);
  var _super = _createSuper7(QuarterParser2);
  function QuarterParser2() {
    var _this;
    _classCallCheck8(this, QuarterParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty7(_assertThisInitialized7(_this), "priority", 120);
    _defineProperty7(_assertThisInitialized7(_this), "incompatibleTokens", ["Y", "R", "q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass8(QuarterParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "Q":
        case "QQ":
          return parseNDigits(token.length, dateString);
        case "Qo":
          return match52.ordinalNumber(dateString, {
            unit: "quarter"
          });
        case "QQQ":
          return match52.quarter(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQQ":
          return match52.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQ":
        default:
          return match52.quarter(dateString, {
            width: "wide",
            context: "formatting"
          }) || match52.quarter(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 4;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCMonth((value - 1) * 3, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return QuarterParser2;
}(Parser);
function _typeof11(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof11 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof11 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof11(obj);
}
function _classCallCheck9(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties9(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass9(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties9(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties9(Constructor, staticProps);
  return Constructor;
}
function _inherits8(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf8(subClass, superClass);
}
function _setPrototypeOf8(o3, p4) {
  _setPrototypeOf8 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf8(o3, p4);
}
function _createSuper8(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct8();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf8(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf8(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn8(this, result);
  };
}
function _possibleConstructorReturn8(self2, call) {
  if (call && (_typeof11(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized8(self2);
}
function _assertThisInitialized8(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct8() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf8(o3) {
  _getPrototypeOf8 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf8(o3);
}
function _defineProperty8(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var StandAloneQuarterParser = /* @__PURE__ */ function(_Parser) {
  _inherits8(StandAloneQuarterParser2, _Parser);
  var _super = _createSuper8(StandAloneQuarterParser2);
  function StandAloneQuarterParser2() {
    var _this;
    _classCallCheck9(this, StandAloneQuarterParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty8(_assertThisInitialized8(_this), "priority", 120);
    _defineProperty8(_assertThisInitialized8(_this), "incompatibleTokens", ["Y", "R", "Q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass9(StandAloneQuarterParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "q":
        case "qq":
          return parseNDigits(token.length, dateString);
        case "qo":
          return match52.ordinalNumber(dateString, {
            unit: "quarter"
          });
        case "qqq":
          return match52.quarter(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match52.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqqq":
          return match52.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqq":
        default:
          return match52.quarter(dateString, {
            width: "wide",
            context: "standalone"
          }) || match52.quarter(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match52.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 4;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCMonth((value - 1) * 3, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneQuarterParser2;
}(Parser);
function _typeof12(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof12 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof12 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof12(obj);
}
function _classCallCheck10(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties10(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass10(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties10(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties10(Constructor, staticProps);
  return Constructor;
}
function _inherits9(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf9(subClass, superClass);
}
function _setPrototypeOf9(o3, p4) {
  _setPrototypeOf9 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf9(o3, p4);
}
function _createSuper9(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct9();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf9(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf9(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn9(this, result);
  };
}
function _possibleConstructorReturn9(self2, call) {
  if (call && (_typeof12(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized9(self2);
}
function _assertThisInitialized9(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct9() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf9(o3) {
  _getPrototypeOf9 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf9(o3);
}
function _defineProperty9(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var MonthParser = /* @__PURE__ */ function(_Parser) {
  _inherits9(MonthParser2, _Parser);
  var _super = _createSuper9(MonthParser2);
  function MonthParser2() {
    var _this;
    _classCallCheck10(this, MonthParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty9(_assertThisInitialized9(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "L", "w", "I", "D", "i", "e", "c", "t", "T"]);
    _defineProperty9(_assertThisInitialized9(_this), "priority", 110);
    return _this;
  }
  _createClass10(MonthParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      var valueCallback92 = function valueCallback102(value) {
        return value - 1;
      };
      switch (token) {
        case "M":
          return mapValue(parseNumericPattern(numericPatterns.month, dateString), valueCallback92);
        case "MM":
          return mapValue(parseNDigits(2, dateString), valueCallback92);
        case "Mo":
          return mapValue(match52.ordinalNumber(dateString, {
            unit: "month"
          }), valueCallback92);
        case "MMM":
          return match52.month(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMMM":
          return match52.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMM":
        default:
          return match52.month(dateString, {
            width: "wide",
            context: "formatting"
          }) || match52.month(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCMonth(value, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return MonthParser2;
}(Parser);
function _typeof13(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof13 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof13 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof13(obj);
}
function _classCallCheck11(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties11(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass11(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties11(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties11(Constructor, staticProps);
  return Constructor;
}
function _inherits10(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf10(subClass, superClass);
}
function _setPrototypeOf10(o3, p4) {
  _setPrototypeOf10 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf10(o3, p4);
}
function _createSuper10(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct10();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf10(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf10(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn10(this, result);
  };
}
function _possibleConstructorReturn10(self2, call) {
  if (call && (_typeof13(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized10(self2);
}
function _assertThisInitialized10(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct10() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf10(o3) {
  _getPrototypeOf10 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf10(o3);
}
function _defineProperty10(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var StandAloneMonthParser = /* @__PURE__ */ function(_Parser) {
  _inherits10(StandAloneMonthParser2, _Parser);
  var _super = _createSuper10(StandAloneMonthParser2);
  function StandAloneMonthParser2() {
    var _this;
    _classCallCheck11(this, StandAloneMonthParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty10(_assertThisInitialized10(_this), "priority", 110);
    _defineProperty10(_assertThisInitialized10(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "M", "w", "I", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass11(StandAloneMonthParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      var valueCallback92 = function valueCallback102(value) {
        return value - 1;
      };
      switch (token) {
        case "L":
          return mapValue(parseNumericPattern(numericPatterns.month, dateString), valueCallback92);
        case "LL":
          return mapValue(parseNDigits(2, dateString), valueCallback92);
        case "Lo":
          return mapValue(match52.ordinalNumber(dateString, {
            unit: "month"
          }), valueCallback92);
        case "LLL":
          return match52.month(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match52.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLLL":
          return match52.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLL":
        default:
          return match52.month(dateString, {
            width: "wide",
            context: "standalone"
          }) || match52.month(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match52.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCMonth(value, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneMonthParser2;
}(Parser);
function setUTCWeek(dirtyDate, dirtyWeek, options) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var week = toInteger(dirtyWeek);
  var diff = getUTCWeek(date, options) - week;
  date.setUTCDate(date.getUTCDate() - diff * 7);
  return date;
}
function _typeof14(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof14 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof14 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof14(obj);
}
function _classCallCheck12(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties12(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass12(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties12(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties12(Constructor, staticProps);
  return Constructor;
}
function _inherits11(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf11(subClass, superClass);
}
function _setPrototypeOf11(o3, p4) {
  _setPrototypeOf11 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf11(o3, p4);
}
function _createSuper11(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct11();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf11(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf11(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn11(this, result);
  };
}
function _possibleConstructorReturn11(self2, call) {
  if (call && (_typeof14(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized11(self2);
}
function _assertThisInitialized11(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct11() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf11(o3) {
  _getPrototypeOf11 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf11(o3);
}
function _defineProperty11(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var LocalWeekParser = /* @__PURE__ */ function(_Parser) {
  _inherits11(LocalWeekParser2, _Parser);
  var _super = _createSuper11(LocalWeekParser2);
  function LocalWeekParser2() {
    var _this;
    _classCallCheck12(this, LocalWeekParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty11(_assertThisInitialized11(_this), "priority", 100);
    _defineProperty11(_assertThisInitialized11(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "i", "t", "T"]);
    return _this;
  }
  _createClass12(LocalWeekParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "w":
          return parseNumericPattern(numericPatterns.week, dateString);
        case "wo":
          return match52.ordinalNumber(dateString, {
            unit: "week"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 53;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value, options) {
      return startOfUTCWeek(setUTCWeek(date, value, options), options);
    }
  }]);
  return LocalWeekParser2;
}(Parser);
function setUTCISOWeek(dirtyDate, dirtyISOWeek) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var isoWeek = toInteger(dirtyISOWeek);
  var diff = getUTCISOWeek(date) - isoWeek;
  date.setUTCDate(date.getUTCDate() - diff * 7);
  return date;
}
function _typeof15(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof15 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof15 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof15(obj);
}
function _classCallCheck13(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties13(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass13(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties13(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties13(Constructor, staticProps);
  return Constructor;
}
function _inherits12(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf12(subClass, superClass);
}
function _setPrototypeOf12(o3, p4) {
  _setPrototypeOf12 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf12(o3, p4);
}
function _createSuper12(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct12();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf12(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf12(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn12(this, result);
  };
}
function _possibleConstructorReturn12(self2, call) {
  if (call && (_typeof15(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized12(self2);
}
function _assertThisInitialized12(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct12() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf12(o3) {
  _getPrototypeOf12 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf12(o3);
}
function _defineProperty12(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var ISOWeekParser = /* @__PURE__ */ function(_Parser) {
  _inherits12(ISOWeekParser2, _Parser);
  var _super = _createSuper12(ISOWeekParser2);
  function ISOWeekParser2() {
    var _this;
    _classCallCheck13(this, ISOWeekParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty12(_assertThisInitialized12(_this), "priority", 100);
    _defineProperty12(_assertThisInitialized12(_this), "incompatibleTokens", ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass13(ISOWeekParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "I":
          return parseNumericPattern(numericPatterns.week, dateString);
        case "Io":
          return match52.ordinalNumber(dateString, {
            unit: "week"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 53;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      return startOfUTCISOWeek(setUTCISOWeek(date, value));
    }
  }]);
  return ISOWeekParser2;
}(Parser);
function _typeof16(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof16 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof16 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof16(obj);
}
function _classCallCheck14(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties14(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass14(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties14(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties14(Constructor, staticProps);
  return Constructor;
}
function _inherits13(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf13(subClass, superClass);
}
function _setPrototypeOf13(o3, p4) {
  _setPrototypeOf13 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf13(o3, p4);
}
function _createSuper13(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct13();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf13(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf13(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn13(this, result);
  };
}
function _possibleConstructorReturn13(self2, call) {
  if (call && (_typeof16(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized13(self2);
}
function _assertThisInitialized13(self2) {
  if (self2 === void 0) {
    throw new Referenc