// VQF 902.4 Risk Profile AMLA Template
// Pass JSON data as content dictionary

#let form(data) = {
  set page(
    paper: "a4",
    margin: (left: 2cm, right: 2cm, top: 2cm, bottom: 2.5cm),
    footer: context [
      #grid(
        columns: (1fr, 1fr),
        align: (left, right),
        text(size: 8pt)[
          VQF doc. No. 902.4#linebreak()
          Version of 17 July 2020
        ],
        text(size: 8pt)[
          Page #here().page() of #counter(page).final().first()
        ]
      )
    ]
  )

  set text(font: "Liberation Sans", size: 10pt)
  set par(justify: false, leading: 0.65em)

  // Helper function to get value or empty string
  let get(key, default: "") = {
    data.at(key, default: default)
  }

  // Helper function for checkbox
  let checkbox(checked) = {
    box(
      width: 3mm,
      height: 3mm,
      stroke: 0.5pt + black,
      inset: 0.3mm,
      if checked == true or checked == "true" {
        place(center + horizon, text(size: 8pt, sym.checkmark))
      }
    )
  }

  // Header
  align(center, text(size: 11pt, weight: "bold")[CONFIDENTIAL])

  v(0.5em)

  grid(
    columns: (50%, 50%),
    gutter: 1em,
    image("vss_vqf_verein.png", width: 80%),
    align(right)[
      #table(
        columns: (1fr, 1fr),
        stroke: 0.5pt + black,
        inset: 5pt,
        align: (left, left),
        [VQF member no.], [AMLA File No.],
        [#get("VQF_MEMBER_NUMBER")], [#get("FILE_NUMBER")]
      )
    ]
  )

  v(1em)

  align(left, text(size: 14pt, weight: "bold")[Risk Profile AMLA])

  v(0.3em)

  text(size: 9pt, style: "italic")[Evaluation of business relationship with increased risk and definition of criteria for transaction monitoring]

  v(-1em)
  line(length:100%)

  grid(
    columns: (auto, 1fr),
    gutter: 0.5em,
    align: (left, left),
    image("pointing_finger.svg", height: 2em),
    text(size: 9pt)[
      The member performs additional clarifications if the business relationship or the transaction is classified as increased risk (Art. 56 SRO Regulations)
    ]
  )

  v(1em)

  table(
    columns: (20%, 80%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Customer#footnote([Pursuant identification form (VQF doc. Nr. 902.1) numeral 1.]):],
    [#get("CUSTOMER_NAME")]
  )

  v(0.5em)

  text(weight: "bold")[This form was completed by:]

  v(0.3em)

  table(
    columns: (20%, 80%),
    stroke: 0.5pt + black,
    inset: 5pt,
    align: (left, left),
    [Full name], [#get("AML_STAFF_NAME")],
    [Date], [#get("FILING_DATE")],
  )

  v(1.5em)

  // Section 1: PEP Check
[= 1. Evaluation of politically exposed persons (PEP-Check)]

  v(0.5em)

  grid(
    columns: (auto, 1fr),
    gutter: 0.5em,
    align: (left, left),
    image("pointing_finger.svg", height: 2em),
    text(size: 9pt)[
      This evaluation has to be completed by all members for every business relationship.
    ]
  )

  v(1em)

  let pep_foreign = get("PEP_FOREIGN")
  let pep_domestic = get("PEP_DOMESTIC")
  let pep_intl = get("PEP_INTERNATIONAL_ORGANIZATION")
  let any_pep = pep_foreign or pep_domestic or pep_intl
  let pep_high_risk = get("PEP_HIGH_RISK")

  block(breakable: false)[
    #table(
      columns: (40%, 60%),
      stroke: 0.5pt + black,
      inset: 5pt,
      [#underline([Foreign PEP])#footnote[Definition see Art. 7 lit. g numeral 1 SRO Regulations.]
       \ #v(1em)
       Is the customer, the beneficial owner or the controlling person or authorised representative a foreign PEP or closely related to such a person?],
      [#grid(
        columns: (auto, 1fr),
        gutter: 0.5em,
        checkbox(not pep_foreign), [No],
        checkbox(pep_foreign), [#grid(
          columns: (auto, auto, auto),
          gutter: 0.5em,
          [Yes],
          [$=>$],
          [Classification of the business
           \ as increased risk is #underline([compulsory]).])],
      )],


      [#underline(
        [Domestic PEP#footnote[Definition see Art. 7 lit. g numeral 2 SRO Regulations.]
         and PEP of International Organisations#footnote[Definition see Art. 7 lit. g numeral 3 SRO Regulations.]]
       )
       \ #v(1em)
       Is the customer, the beneficial owner or the controlling person or authorised representative a domestic PEP or PEP in International Organisations or closely related to such a person?],
      [#grid(
        columns: (auto, 1fr),
        gutter: 0.5em,
        checkbox(not (pep_domestic or pep_intl)), [No],
        checkbox(pep_domestic or pep_intl), [#grid(
          columns: (auto, auto, auto),
          gutter: 0.5em,
          [Yes],
          [$=>$],
          [Is a risk criterion pursuant to numeral 3 subsequently increased?
            #grid(
              columns: (auto, 1fr),
              gutter: 0.5em,
             checkbox(not pep_high_risk), [No],
             checkbox(pep_high_risk), [#grid(
               columns: (auto, auto, auto),
               gutter: 0.5em,
               [Yes],
               [$=>$],
               [Classification of the business relationship as increased risk is #underline([compulsory])]
             )]
           )],
         )]
      )]
    )
    #if ("" == get("PEP_ACCEPTANCE_DATE")) [
      The decision of the Senior executive body on the acceptance of a business relationship
      with a PEP was #underline([not]) obtained.
    ] else [
      The decision of the Senior executive body on the acceptance of a business relationship
      with a PEP was obtained on #underline([#get("PEP_ACCEPTANCE_DATE")]).
    ]
  ]

  v(2em)
  pagebreak()
  // Section 2: High Risk Country
[= 2. Evaluation "high risk" or non-cooperative country]

  v(0.5em)

  grid(
    columns: (auto, 1fr),
    gutter: 0.5em,
    align: (left, left),
    image("pointing_finger.svg", height: 2em),
    text(size: 9pt)[
      This evaluation has to be completed by all members for each business relationship.
    ]
  )

  v(1em)

  let high_risk = get("HIGH_RISK_COUNTRY")

  block(breakable: false)[
    #table(
      columns: (40%, 60%),
      stroke: 0.5pt + black,
      inset: 5pt,
      [#underline(["High risk" or non-cooperative country])
       #v(1em)
       Is the customer, the beneficial owner or the controlling person or authorised representative in a country considered by the FATF *"high risk"* or *non-cooperative* and for which FATF requires *increased diligence*?],
      [#grid(
        columns: (auto, 1fr),
        gutter: 0.5em,
        checkbox(not high_risk), [No],
        checkbox(pep_foreign), [#grid(
          columns: (auto, auto, auto),
          gutter: 0.5em,
          [Yes],
          [$=>$],
          [Classification of the business
           \ as increased risk is #underline([compulsory]).])],
      )],
    )
    #if ("" == get("COUNTRY_RISK_ACCEPTANCE_DATE")) [
      The decision of the Senior executive body on the acceptance of such a business relationship
      was #underline([not]) obtained.
    ] else [
      The decision of the Senior executive body on the acceptance of a such a business relationship
      was obtained on #underline([#get("COUNTRY_RISK_ACCEPTANCE_DATE")]).
    ]
  ]

  v(2em)

  // Section 3: Business Relationship Risk
[= 3. Evaluation of business relationship risk]

  v(0.5em)

  grid(
    columns: (auto, 1fr),
    gutter: 0.5em,
    align: (left, left),
    image("pointing_finger.svg", height: 2em),
    text(size: 9pt)[
      This evaluation has to be completed by all members who have in total more than 20 customers for every business relationship. At least two risk categories have to be chosen and assessed.
    ]
  )

  v(1em)

  // Country Risk (Nationality)
  let nat_types = get("COUNTRY_RISK_NATIONALITY_TYPE", default: ())
  let nat_level = get("COUNTRY_RISK_NATIONALITY_LEVEL")

  block(breakable: false)[
  #text(size: 10pt, weight: "bold")[a) Country risk#footnote[Risk 0 = Risk Classification "Low"; Risk 1 = Risk Classification "Medium"; Risk 2 = Risk Classification "High".] (nationality)]

  #v(0.5em)

  #table(
    columns: (35%, 65%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [#checkbox(false) *Domicile/residential address:*
     #grid(
       columns: (1em, auto, 1fr),
       inset: 1pt,
       [],
       checkbox(nat_types.contains("DOMICILE_CUSTOMER")),
       [Customer],
       [],
       checkbox(nat_types.contains("DOMICILE_OWNER")),
       [Beneficial owner of the assets],
       [],
       checkbox(nat_types.contains("DOMICILE_CONTROLLING")),
       [Controlling person],
     )
     \ #checkbox(false) *Nationality:*
     #grid(
       columns: (1em, auto, 1fr),
       gutter: 0.3em,
       [],
       checkbox(nat_types.contains("NATIONALITY_CUSTOMER")),
       [Customer],
       [],
       checkbox(nat_types.contains("NATIONALITY_OWNER")),
       [Beneficial owner of the assets],
     )],
    [#grid(
      columns: (auto, 1fr),
      inset: 1em,
      stroke: 0.5pt + black,
      [0],
      [#checkbox(nat_level == "LOW")
       Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)],
      [1],
      [#checkbox(nat_level == "MEDIUM")
       Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)],
      [2],
      [#checkbox(nat_level == "HIGH")
       Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)],
    )]
  )]

  v(1em)

  // Country Risk (Business)
  let bus_types = get("COUNTRY_RISK_BUSINESS_TYPE", default: ())
  let bus_level = get("COUNTRY_RISK_BUSINESS_LEVEL")

  block(breakable: false)[
  #text(size: 10pt, weight: "bold")[b) Country risk (business activity)]

  #v(0.5em)

  #table(
    columns: (35%, 65%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [*Place of business activity:*
     #grid(
       columns: (1em, auto, 1fr),
       gutter: 0.3em,
       [],
       checkbox(bus_types.contains("CUSTOMER")),
       [Customer],
       [],
       checkbox(bus_types.contains("OWNER")),
       [Beneficial owner of the assets],
     )],
    [#grid(
      columns: (auto, 1fr),
      inset: 1em,
      stroke: 0.5pt + black,
      [0],
      [#checkbox(bus_level == "LOW")
       Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)],
      [1],
      [#checkbox(bus_level == "MEDIUM")
       Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)],
      [2],
      [#checkbox(bus_level == "HIGH")
       Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)],
    )]
  )]

  v(1em)

  // Country Risk (Payments)
  let pay_types = get("COUNTRY_RISK_PAYMENT_TYPE", default: ())
  let pay_level = get("COUNTRY_RISK_PAYMENTS_LEVEL")

  block(breakable: false)[
  #text(size: 10pt, weight: "bold")[c) Country risk (payments)]

  #v(0.5em)

  #table(
    columns: (35%, 65%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [*Country of origin and destination of frequent payments (if known):*
     #grid(
       columns: (1em, auto, 1fr),
       gutter: 0.3em,
       [],
       checkbox(bus_types.contains("CUSTOMER")),
       [Customer],
       [],
       checkbox(bus_types.contains("OWNER")),
       [Beneficial owner of the assets],
     )],
    [#grid(
      columns: (auto, 1fr),
      inset: 1em,
      stroke: 0.5pt + black,
      [0],
      [#checkbox(pay_level == "LOW")
       Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)],
      [1],
      [#checkbox(pay_level == "MEDIUM")
       Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)],
      [2],
      [#checkbox(pay_level == "HIGH")
       Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)],
    )]
  )]

  v(1em)



  // Industry Risk
  let ind_types = get("INDUSTRY_RISK_TYPE", default: ())
  let ind_level = get("INDUSTRY_RISK_LEVEL")

  block(breakable: false)[
  #text(size: 10pt, weight: "bold")[d) Industry risk]

  #v(0.5em)

  #table(
    columns: (35%, 65%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [*Nature of customer's business activity:*
     #grid(
       columns: (1em, auto, 1fr),
       gutter: 0.3em,
       [],
       checkbox(ind_types.contains("CUSTOMER")),
       [Customer],
       [],
       checkbox(ind_types.contains("OWNER")),
       [Beneficial owner of the assets],
     )],
    [#grid(
      columns: (auto, 1fr),
      inset: 0.5em,
      stroke: 0.5pt + black,
      [0],
      [#grid(
         columns: (auto, 1fr),
         inset: 0.2em,
         [#checkbox(ind_level == "TRANSPARENT")],
         [Clearly defined, transparent, easily comprehensible business activity well known to the member])],
      [1],
      [#grid(
         columns: (auto, 1fr),
         inset: 0.2em,
         [#checkbox(ind_level == "HIGH_CASH_TRANSACTION")],
         [Business activity with a high level of cash transactions],
         [#checkbox(ind_level == "NOT_WELL_KNOWN")],
         [Business activity not well known to the member])],
      [2],
      [#grid(
         columns: (auto, 1fr),
         inset: 0.2em,
         [#checkbox(ind_level == "HIGH_RISK_TRADE")],
         [Trade in munitions/arms, raw gem stones/diamonds, jewellery, international trade in exotic animals, casino and lottery business, trade in erotic wares],
         [#checkbox(ind_level == "UNKNOWN_INDUSTRY")],
         [Member has no personal knowledge of the customer's industry])]
    )]
  )]

  v(1em)

  // Contact Risk
  let contact_level = get("CONTACT_RISK_LEVEL")
  block(breakable: false)[
    #text(size: 10pt, weight: "bold")[e) Contact risk]

    #v(0.3em)
    #table(
      columns: (35%, 65%),
      stroke: 0.5pt + black,
      inset: 5pt,
      [*Type of contact to the customer/beneficial owner of the assets.*],
      [#grid(
       columns: (auto, 1fr),
       stroke: 0.5pt + black,
       inset: 5pt,
       [0],
       [#grid(
         columns: (auto, 1fr),
         inset: 0.2em,
         [#checkbox(contact_level == "LOW")],
         [Personal acquaintance between member and customer/beneficial owner of the assets over several years (at least 2) prior to entering into the business relationship.],
       )],
       [1],
       [#grid(
         columns: (auto, 1fr),
         inset: 0.2em,
         [#checkbox(contact_level == "MEDIUM")],
         [The customer/beneficial owner was not personally known to the member for several years (at least 2) prior to entering into the business relationship; however (a) no business was entered into in the absence of the customer/beneficial owner, or (b) the customer was at least introduced/brokered by a trusted third party.],
       )],
       [2],
       [#grid(
         columns: (auto, 1fr),
         inset: 0.2em,
         [#checkbox(contact_level == "HIGH")],
         [The customer/beneficial owner was not personally known to the member and business was entered into in the absence of the former (relationship by correspondence) and the customer was not introduced/brokered by a trusted third party.],
       )]
     )]
  )]

  v(2em)

  // Product Risk
  let prod_level = get("PRODUCT_RISK_LEVEL", default: ())
  block(breakable: false)[
    #text(size: 10pt, weight: "bold")[f) Product risk]

    #v(0.3em)
    #table(
      columns: (35%, 65%),
      stroke: 0.5pt + black,
      inset: 5pt,
      [*Nature of services and products requested by the customer*],
      [#grid(
       columns: (auto, 1fr),
       stroke: 0.5pt + black,
       inset: 5pt,
       [0],
       [#grid(
         columns: (auto, 1fr),
         inset: 0.2em,
         [#checkbox(prod_level.contains("EASY"))],
         [Easy to understand, transparent services and products whose financial background is easy to comprehend and verify.],
       )],
       [1],
       [#grid(
         columns: (auto, 1fr),
         inset: 0.2em,
         [#checkbox(prod_level.contains("SOPHISTICATED"))],
         [More sophisticated services/products whose financial background is not readily easy to comprehend and verify.],
       )],
       [2],
       [#grid(
         columns: (auto, 1fr),
         inset: 0.2em,
         [#checkbox(prod_level.contains("HIGH_OFFSHORE"))],
         [Main focus on offshore business (especially: relationships with domiciliary companies or other such offshore organisations) #v(0.5em)],
         [#checkbox(prod_level.contains("HIGH_COMPLEX"))],
         [Complex structures in particular by using a domiciliary company with fiduciary shareholders in a non-transparent jurisdiction, without comprehensible reason or for the purpose of short-term asset placement #v(0.5em)],
         [#checkbox(prod_level.contains("HIGH_PASSTHROUGH"))],
         [The customer or beneficial owner of the assets has a large number of accounts with pass-through transactions (pass-through accounts) #v(0.5em)],
         [#checkbox(prod_level.contains("HIGH_BACKGROUND"))],
         [Complex services/products whose financial background can’t be understood or verified with considerable effort. #v(0.5em)],
         [#checkbox(prod_level.contains("HIGH_FREQUENT_TMER"))],
         [Frequent transactions with increased risks #v(0.5em)],
       )]
     )]
  )]

  v(2em)


  // Summary Evaluation
  text(size: 11pt, weight: "bold")[Overall assessment of the business relationship]

  v(0.5em)

  block(
    fill: rgb("#f0f0f0"),
    inset: 10pt,
    width: 100%,
  )[
    A business relationship is classified as increased risk if:

    - Business relationship with PEP pursuant to numeral 1 (no exception possible)
    - Relationship with a person from a "high risk" or non-cooperative country according to numeral 2 (no exceptions possible)
    - Min. #underline[one] criterion pursuant to numeral 3 was assessed with #underline[risk 2] or min. #underline[two] criteria pursuant to numeral 3 were assessed with risk 1 (exception: justification by the member below why the business relationship overall does not have to be classified as increased risk despite the fact that individual risk criteria are increased).
  ]

  v(1em)

  let risk_class = get("RISK_CLASSIFICATION_LEVEL")
  let risk_class_low = "NO_HIGH_RISK" == risk_class

  table(
    columns: (40%, 60%),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Justification for differing risk assessment],
    [#get("RISK_RATIONALE")],
    [Risk classified],
    [#grid(
       columns: (auto),
       gutter: 1em,
       [#checkbox(risk_class_low) *Business relationship #underline[without] increased risk*],
       [#checkbox(not risk_class_low) *Business relationship #underline[with] increased risk*],
     )]
  )

  v(0.5em)

  if ("" == get("HIGH_RISK_ACCEPTANCE_DATE")) [
    The decision of the Senior executive body on the acceptance of a business relationship with increased risk was #underline([not]) obtained.
  ] else [
    The decision of the Senior executive body on the acceptance of a business relationship with increased risk was obtained on #underline([#get("RISK_ACCEPTANCE_DATE")]).
  ]

pagebreak()

[
= 4. Criteria for identification of increased risk transactions (transaction monitoring)

== 4.1 Criteria

Classification as as increased risk is compulsory if:

+ Transactions for which assets with an equivalent value of CHF 100'000.- or more are physically introduced at the beginning of the business relationship, either at once or in a staggered manner
+ Money and asset transfers ("money transfer") whereby a single transaction or multiple transactions which appear to be related reach or exceed the amount of CHF 5,000.-
+ Payments from or to a country that is considered to be "high risk" or non-cooperative by the FATF and for which increased diligence is required

== 4.2 Additional criteria defined by the member

  #grid(
    columns: (auto, 1fr),
    gutter: 0.5em,
    align: (left, left),
    image("pointing_finger.svg", height: 2em),
    text(size: 9pt)[
      All members have to define min. 1 additional criterion for every business relationship to identify unusual transactions#footnote[
      Possible criteria (Art. 59 para. 2 SRO Regulations):
- the amount of inflowing and outflowing assets; *or*
- type, volume and frequency of transactions usual to the business relationship (considerable variance would be unusual); *or*
- type, volume and frequency of transactions usual to comparable business relationships (considerable variance would be unusual); *or*
- description of expected transaction patterns which the client notify the member of (considerable variance would be unusual); *or*
- The country of origin or destination of payments, especially in the case of payments from or to a country considered by the FATF as "high risk" or non-cooperative.]
    ]
  )

]

  grid(
    columns: (100%),
    stroke: 0.5pt + black,
    inset: 5pt,
    align: (left, left),
    [#get("TRANSACTION_RISK_RULE")]
  )

v(2em)

text(size: 9pt, style: "italic")[⚠ *This form has to be updated immediately if changes occur.*]
}

// Example usage:
#form((
  "VQF_MEMBER_NUMBER": "12345",
  "FILE_NUMBER": "42",
  "CUSTOMER_NAME": "Example Company AG",
  "FILED_BY_NAME": "Jane Smith",
  "FILING_DATE": "10.11.2025",
  "PEP_FOREIGN": false,
  "PEP_DOMESTIC": false,
  "PEP_HIGH_RISK": false,
  "PEP_ACCEPTANCE_DATE": "2024-02-13",
  "ANY_RISK_CRITERION": false,
  "PEP_INTERNATIONAL_ORGANIZATION": false,
  "HIGH_RISK_COUNTRY": false,
  "COUNTRY_RISK_ACCEPTANCE_DATE": "2024-2-13",
  "COUNTRY_RISK_NATIONALITY_LEVEL": "LOW",
  "INDUSTRY_RISK_LEVEL": "TRANSPARENT",
  "CONTACT_RISK_LEVEL": "LOW",
  "RISK_CLASSIFICATION_LEVEL": "NO_HIGH_RISK",
  "TRANSACTION_RISK_RULE": "more than 50k/month",
  "HIGH_RISK_ACCEPTANCE_DATE": "2024-3-20",
))