#! @AWK@ -f

#######################################################################
#
#   Gtk wrapper creation scripts (creating hash table for callbacks)
#
########################################################################


#######################################################################
#
# Copyright 2003 Free Software Foundation, Inc.
# Written by Norman Jordan
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

BEGIN {
  print "/* Automatically generated, do not edit! */"
  print "#include <glib.h>\n"
  print "#include \"blox-gtk.h\"\n"
    
  print "GHashTable*"
  print "_blox_create_callback_hash()"
  print "{"
  print "  GHashTable *callBackHash, *currentHash;\n"
  print "  callBackHash = g_hash_table_new(g_str_hash, g_str_equal);\n"
}

$1 == "struct" && $2 ~ /_Gtk[A-Z][a-zA-Z]+Class/ {
  className = $2
  gsub(/_/, "", className)
  gsub(/Class$/, "", className)
  print "  currentHash = g_hash_table_new(g_str_hash, g_str_equal);"
  printf "  g_hash_table_insert(callBackHash, \"%s\", currentHash);\n", className
    
  while($1 != "};") {
    getline
    if ($0 ~ /[a-zA-Z0-9]+ \(\* [a-zA-Z_]+\)/) {
      signalName = $3
      if(signalName ~ /\)\(/) {
        gsub(/\(.*$/, "", signalName)
      }
      gsub(/\)$/, "", signalName)
    } else if($0 ~ /[a-zA-Z0-9]+ \(\*[a-zA-Z_]+\)/) {
      signalName = $2
      sub(/^\(\*/, "", signalName)
      gsub(/\).*$/, "", signalName)
    } else {
      continue
    }
    if(className != "GtkContainer" || signalName != "forall") {
      printf "  g_hash_table_insert(currentHash, \"%s\", %s_%s);\n", signalName, className, signalName
    }
  }
  print ""
}

END {
  print "  return(callBackHash);"
  print "}"
}
