#! @AWK@ -f

#######################################################################
#
#   Gtk wrapper creation scripts (C function declarations)
#
#   $Revision: 1.95.1$
#   $Date: 2000/12/27 10:45:49$
#   $Author: pb$
#
########################################################################


#######################################################################
#
# Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
# Written by Paolo Bonzini and Dragomir Milivojevic
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

BEGIN {
    FS = "[ \(\t]+"

    type["void"] = "#void"
    type["int"] = "#int"
    type["char"] = "#string"
    type["double"] = "#double"
    type["va_list"] = "#cObject"
    
    type["gint8"] = "#int"
    type["guint8"] = "#int"
    type["gint16"] = "#int"
    type["guint16"] = "#int"
    type["gint32"] = "#int"
    type["guint32"] = "#int"
    
    type["gchar"] = "#int"
    type["guchar"] = "#int"
    type["gshort"] = "#int"
    type["gushort"] = "#int"
    type["glong"] = "#long"
    type["gulong"] = "#long"
    type["gint"] = "#int"
    type["guint"] = "#int"
    type["gboolean"] = "#boolean"
    type["gfloat"] = "#float"
    type["gdouble"] = "#double"

    class_regexp = "^$"
}

/^#define/ {
  while ($0 ~ /\\$/)
    getline
}

# Pick the correct case for the class (e.g. CList vs. Clist)
# and decide what will be the prefix for its methods

$1 == "struct" && $2 ~ /^_/ && $2 !~ /Class$/ {
  name = substr($2, 2)
  correct_case[tolower(name)] = name
  prefix = method_prefix(name) "_"
  method_regexp = method_regexp "|^" prefix
  class[prefix] = name
}

$2 ~ /^gtk_/ && $1 ~ /[a-zA-Z]/ && $1 !~ /^#/ { 
  $0 = $0

  cFuncName = $2

  if (match($2, method_regexp))
    className = class[substr($2, 1, RLENGTH)]

  creation = 0
  if (className != "")
  {
    $2 = substr($2, RLENGTH + 1)
    if ($2 ~ /^newv?($|_)/)
      creation = 1
  }
  else if (match($2, /^gtk_(draw|paint)_/))
  {
    # Sigh, this loses symmetry...
    className = "GtkStyle"
    $2 = substr($2, 5)
  }
  else
    className = smalltalkize(toupper(substr($2, 1, 3)))

  smalltalkFuncName = smalltalkize($2)

  # create one long string and tokenize it
  decl = $0
  while( match( decl, ";" ) == 0 )
  {
    getline

    for (i = 1; i <= NF; i++)
      # Convert arrays to pointers
      while( $i ~ /\[\]/ )
      {
        $i = "*" $i
        sub (/\[\]/, "", $i)
      }

    decl = decl " " $0
  }
  split( decl, arr )

  # tokenize
  decl = ""
  self = void = 0
  
  for(i = 1; i in arr; i++) {
    last = strip(tst)
    tst = arr[i]

    if (substr(tst, 1, 3) == "...") {
      decl = decl " varargs: varargs"
      continue
    }

    if( tst !~ /[,\)]/ )
      continue
  
    tst = smalltalkize( strip( tst ) )

    if (tst == "void" || last == "void") {
      void = 1
      break
    }

    if (decl != "")
    {
      decl = decl " " tst ": " tst
      continue
    }

    if (i < 5 && last == className)
      self = 1
    else
      decl = smalltalkFuncName ": " tst
  }

  print className (self ? "" : " class")
  print "\tdefineCFunc: '" cFuncName "'"
  print "\twithSelectorArgs: '" (decl == "" ? smalltalkFuncName : decl) "'" 

  # returning

  if (creation)
    arr[1] = className "*"
  print "\treturning: " returned( arr[1] ) 

  # build args

  if (void)
  {
    print "\targs: #()!\n"
    next
  }

  decl = ""
  tst = ""

  for(i = 1; i in arr; i++)
  {
    last = strip(tst)
    tst = arr[i]

    if( tst !~ /[,\)]/ )
      continue
  
    if (i < 5 && self)
      decl = decl " self"

    else if (substr(tst, 1, 3) == "...")
      decl = decl " variadic"

    else if ( index( tst, "," ) > 0 || index( tst, ")" ) > 0 )
      decl = decl " " ctype( strip( last ), tst )
  }

  print "\targs: #(" decl " )!\n"
}


# strips garbage from string
function strip( var )
{
  gsub( /[()\\,;*]/, "", var )
  return var
}

function ctype( var, name )
{
  # everything else is CObject
  res = type[var]
  if (name ~ /^\*\*/)
    return "#cObject"
  else if (name ~ /^\*/)
    return var ~ /g?char$/ ? "#string" : "#cObject"
  else if( res != "" ) 
    return res
  else
    return "#int"
}

function returned( var )
{
  if (var ~ /*$/)
    return var ~ /g?char/ ? "#string" : strip(var) " type"

  # everything else is `xxx type'
  res = type[var];

  if( res != "" ) 
    return res
  else
    return "#int"
}

function smalltalkize( res )
{
  first = substr (res, 1, 1)
  res = tolower( substr (res, 2) )

  while (j = index (res, "_")) {
    first = first substr(res, 1, j - 1) toupper( substr (res, j + 1, 1))
    res = substr (res, j + 2)
  }

  return first res
}

function method_prefix( name )
{
  prefix = ""

  while (match(name, /[A-Z]/)) {
    prefix = prefix substr(name, 1, RSTART - 1) "_" substr(name, RSTART, 1)
    for (name = substr(name, RSTART + 1); name ~ /^[A-Z]/; \
         name = substr(name, 2))
      prefix = prefix substr(name, 1, 1)
  }

  return tolower(substr(prefix, 2) name)
}
