/* -*-C-*-
 * access to the X Window System for Sather
 * (c) 1994/11/03 - 1995/02/19 by Erik Schnetter
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "header.h"



XImage* X_CreateImage (Display* display, Visual* visual, INT depth, INT format,
		       INT offset, INT width, INT height, INT bitmap_pad)
{
  int scanline = ((width+offset-1) /bitmap_pad +1) *bitmap_pad /8;
  int bytes_per_line = scanline * height;
  char* data = (char*) malloc (height * scanline * depth);
  return XCreateImage (display, visual, depth, format, offset, data,
		       width, height, bitmap_pad, bytes_per_line);
}

void X_DestroyImage (XImage* image)
{
  XDestroyImage (image);
}

INT X_GetPixel (XImage* image, INT x, INT y)
{
  return XGetPixel (image, x, y);
}

void X_PutPixel (XImage* image, INT x, INT y, INT pixel)
{
  XPutPixel (image, x, y, pixel);
}

XImage* X_SubImage (XImage* image, INT x, INT y, INT width, INT height)
{
  return XSubImage (image, x, y, width, height);
}

void X_PutImage (Display* display, INT drawable, GC gc, XImage* image,
	    INT src_x, INT src_y, INT dest_x, INT dest_y,
	    INT width, INT height)
/* GC is struct* */
{
  XPutImage (display, drawable, gc, image,
	     src_x, src_y, dest_x, dest_y, width, height);
}

void X_AddPixel (XImage* image, INT value)
{
  XAddPixel (image, value);
}
