/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef DRAWER_H
#define DRAWER_H
#include <string>
#include "Drawable.h"
#include "MessageBoxDrawable.h"
#include "MenuDrawable.h"
#include "BoxElement.h"

#include <vector>
class Drawer
{
public:

	virtual void setCursor(int x,int y) = 0;
	virtual void setCursorPlacement(int x,int y) = 0;
	virtual void setCoord(int x,int y) = 0;
	virtual int &getWidth()=0;
	virtual int &getHeight()=0;
	virtual void draw(Drawable *dr) =0;
	virtual void draw() =0;
	virtual void right()=0;
	virtual void left()=0;
	virtual void up()=0;
	virtual void refreshConfig()=0;
	virtual void down()=0;
	virtual int getXMap()=0;
	virtual int getYMap()=0;
	virtual void redrawCursor()=0;
	virtual MessageBoxDrawable *createMessageBox(std::string message,std::string title)=0;
	virtual MenuDrawable *createMenu(std::vector<BoxElement *> ,std::string title)=0;

	
};

#endif

