/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "StringDrawerTest.h"
#include "StringDrawer.h"
#include "MapManager.h"
#include <iostream>


StringDrawerTest::StringDrawerTest(void)
{
}


StringDrawerTest::~StringDrawerTest(void)
{
}

int StringDrawerTest::testSimpleDraw(){
	std::string myMap="width 32\n";
	myMap+="height 23\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="  a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a.      b b       b b b \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b \n";
	myMap+="a a a a a           a.a     a a a a a   b b.b b b b b b b b b b \n";
	myMap+="  a a a a             a a     a a a     b b b b b b b b b b b b \n";
	myMap+="  a a a a             a a a     a a       b b b b b b b b b b b \n";
	myMap+="    a               a a   a       a               b b b b b b b \n";
	myMap+="    c             a                                 b b b b b b \n";
	myMap+="  c c c           a a                               b b b b b b \n";
	myMap+="c c c c c c c c c                                   b b b b b b \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b b ";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer stt(bBoard);
	std::string tov;//= stt.drawSimpleBoard(14,3,10,10);
	std::string resultat="----------\n";
	resultat+="|        |\n";
	resultat+="|        |\n";
	resultat+="|        |\n";
	resultat+="|        |\n";
	resultat+="|        |\n";
	resultat+="|        |\n";
	resultat+="|        |\n";
	resultat+="|        |\n";
	resultat+="----------";

	if (tov!=resultat){
		//std::cout << "ERROR : testSimpleDraw bad drawed map \n"<<tov<<std::endl;
		std::cout << "ERROR : testSimpleDraw bad drawed map \n"<<std::endl;
		return 1;
	}
	else
	{
		std::cout << "OK : testSimpleDraw"<<std::endl;
		return 0;
	}
}

int StringDrawerTest::testCompleteDraw(){
	std::string myMap="width 32\n";
	myMap+="height 23\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="  a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a.      b b       b b b \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b \n";
	myMap+="a a a a a           a.a     a a a a a   b b.b b b b b b b b b b \n";
	myMap+="  a a a a             a a     a a a     b b b b b b b b b b b b \n";
	myMap+="  a a a a             a a a     a a       b b b b b b b b b b b \n";
	myMap+="    a               a a   a       a               b b b b b b b \n";
	myMap+="    c             a                                 b b b b b b \n";
	myMap+="  c c c           a a                               b b b b b b \n";
	myMap+="c c c c c c c c c                                   b b b b b b \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b b ";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer stt(bBoard);
	std::string tov;//= stt.drawCompleteBoard(14,3,10,10);
	std::string resultat="Actual player:'No Player',Action:No action,Nb Free Action:0/0          \n----------\n";	
	resultat+="|aaaaaaaa|\n";
	resultat+="|aaaaaaaa|\n";
	resultat+="|aaaaaaaa|\n";
	resultat+="|aaaaaao |\n";
	resultat+="|aaaaaa b|\n";
	resultat+="|aaaaa bo|\n";
	resultat+="| aaa  bb|\n";
	resultat+="|  aa   b|\n";
	resultat+="----------";

	if (tov!=resultat){
		std::cout << "ERROR : testCompleteDraw bad drawed map \n"<<tov<<std::endl;
		//std::cout << "ERROR : testCompleteDraw bad drawed map \n"<<std::endl;
		return 0;
	}
	else
	{
		std::cout << "OK : testCompleteDraw"<<std::endl;
		return 0;
	}
}


int StringDrawerTest::testDrawScreen(){
	std::string myMap="width 96\n";
	myMap+="height 23\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="  a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="    a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a.      b b       b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a           a.a     a a a a a   b b.b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a             a a     a a a     b b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a             a a a     a a       b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a               a a   a       a               b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    c             a                                 b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  c c c           a a                               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c                                   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b.b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a ";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer sdr(bBoard);
	sdr.setCoord(0,0);
	sdr.setClearScreen(false);
	std::string tov;//= sdr.drawScreen( );
	//sdr.setCursor(0,0);
	std::string resultat="Actual player:'No Player',Action:No action,Nb Free Action:0/0          \n";
	resultat+="--------------------------------------------------------------------------------\n";
	resultat+="| aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|  aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|    aaaaaaaaaaaaaaaaaaaaaa aaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|    aaaaaaaaaaaaaaaaaaa a  aaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|    aaaaaaaaaaaaaaaaaa      aaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|    aaaaaaaaaaaaaaaaaa       bbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|aaaaaaaa aa  aaaaaaao   bb   bbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|aaaaaa    aa  aaaaaa bbbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|aaaaa     oa  aaaaa bobbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="| aaaa      aa  aaa  bbbbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="| aaaa      aaa  aa   bbbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|  a       aa a   a       bbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|  c      a                bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="| ccc     aa               bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|ccccccccc                 bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|ccccccccc       ccc       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|cccccccccco    cccccc   bbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|cccccccccccc   ccccccccbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|cccccccccccccccccccccccbb bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccccccccccccc   bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="--------------------------------------------------------------------------------";


	if (tov!=resultat){
		//std::cout << "ERROR : testDrawScreen bad drawed map \n"<<tov<<std::endl;
		std::cout << "ERROR : testDrawScreen bad drawed map \n"<<std::endl;
		return 0;

	}
	else
	{
		std::cout << "OK : testDrawScreen"<<std::endl;
		return 0;
	}
	
}

int StringDrawerTest::testDrawLittleScreen(){
	std::string myMap="width 32\n";
	myMap+="height 14\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="  a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a.      b b       b b b \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b \n";
	myMap+="a a a a a           a.a     a a a a a   b b.b b b b b b b b b b \n";
	myMap+="  a a a a             a a     a a a     b b b b b b b b b b b b \n";
	myMap+="  a a a a             a a a     a a       b b b b b b b b b b b \n";
	myMap+="    a               a a   a       a               b b b b b b b \n";
	myMap+="    c             a                                 b b b b b b \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b.b ";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer sdr(bBoard);
	sdr.setCoord(0,0);
	sdr.setClearScreen(false);
	std::string tov;//= sdr.drawScreen( );
	//sdr.setCursor(0,0);
	std::string resultat="Actual player:'No Player',Action:No action,Nb Free Action:0/0          \n";
	resultat+="-------------------------------------------------------------------------------\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                        aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa                      |\n";
	resultat+="|                         aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa                      |\n";
	resultat+="|                           aaaaaaaaaaaaaaaaaaaaaa aaaaa                      |\n";
	resultat+="|                           aaaaaaaaaaaaaaaaaaa a  aaaaa                      |\n";
	resultat+="|                           aaaaaaaaaaaaaaaaaa      aaaa                      |\n";
	resultat+="|                           aaaaaaaaaaaaaaaaaa       bbb                      |\n";
	resultat+="|                       aaaaaaaa aa  aaaaaaao   bb   bbb                      |\n";
	resultat+="|                       aaaaaa    aa  aaaaaa bbbbbbbbbbb                      |\n";
	resultat+="|                       aaaaa     oa  aaaaa bobbbbbbbbbb                      |\n";
	resultat+="|                        aaaa      aa  aaa  bbbbbbbbbbbb                      |\n";
	resultat+="|                        aaaa      aaa  aa   bbbbbbbbbbb                      |\n";
	resultat+="|                         a       aa a   a       bbbbbbb                      |\n";
	resultat+="|                         c      a                bbbbbb                      |\n";
	resultat+="|                       cccccccccccccccccccccccc   bbbob                      |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="|                                                                             |\n";
	resultat+="-------------------------------------------------------------------------------";

	if (tov!=resultat){
		//std::cout << "ERROR : testDrawLittleScreen bad drawed map \n"<<tov<<std::endl;
		std::cout << "ERROR : testDrawLittleScreen bad drawed map \n"<<std::endl;
		
		return 0;
	}
	else
	{
		std::cout << "OK : testDrawLittleScreen"<<std::endl;
		return 0;
	}
	
}

int StringDrawerTest::testDrawRightScreen(){
	std::string myMap="width 96\n";
	myMap+="height 35\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="  a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="    a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a.      b b       b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a           a.a     a a a a a   b b.b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a             a a     a a a     b b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a             a a a     a a       b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a               a a   a       a               b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    c             a                                 b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  c c c           a a                               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c                                   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b.b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a.a.a.";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer sdr(bBoard);
	sdr.setCoord(1000,1000);
	sdr.setClearScreen(false);
	std::string tov;//= sdr.drawScreen( );
	//sdr.setCursor(0,0);
	std::string resultat="Action:No action,Actual player:No Player,Nb Free Action:0/0\n";
	resultat+="-------------------------------------------------------------------------------\n";
	resultat+="|       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cc   bbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccbb bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc   bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaao|\n";
	resultat+="|ccccc  bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaao|\n";
	resultat+="|ccccc   bbbob aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaooo|\n";
	resultat+="-------------------------------------------------------------------------------";

	if (tov!=resultat){
		//std::cout << "ERROR : testDrawRightScreen bad drawed map \n"<<tov<<std::endl;
		std::cout << "ERROR : testDrawRightScreen bad drawed map \n"<<std::endl;
		return 0;

	}
	else
	{
		std::cout << "OK : testDrawRightScreen"<<std::endl;
		return 0;
	}
}


int StringDrawerTest::testDraw10x10Screen(){
	std::string myMap="width 96\n";
	myMap+="height 35\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="  a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="    a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a.      b b       b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a           a.a     a a a a a   b b.b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a         g k a a     a a a     b b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a           l a a a     a a       b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a               a a   a       a               b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    c             a                                 b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  c c c           a a                               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c                                   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b.b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a.a.a.";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer sdr(bBoard);
	sdr.setCoord(10,10);
	sdr.setClearScreen(false);
	std::string tov;//= sdr.drawScreen( );
	//sdr.setCursor(0,0);
	std::string resultat="Action:No action,Actual player:No Player,Nb Free Action:0/0\n";
	resultat+="-------------------------------------------------------------------------------\n";
	resultat+="|laaa  aa   bbbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|aa a   a       bbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|                bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|a               bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|                bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|      ccc       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|o    cccccc   bbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cc   ccccccccbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccccccccccccbb bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="-------------------------------------------------------------------------------";

	if (tov!=resultat){
		//std::cout << "ERROR : testDraw10x10Screen bad drawed map \n"<<tov<<std::endl;
		std::cout << "ERROR : testDraw10x10Screen bad drawed map \n"<<std::endl;
		//std::cout <<  "\033[2J"<<std::endl;
		return 0;

	}
	else
	{
		std::cout << "OK : testDraw10x10Screen"<<std::endl;
		return 0;
	}
}


int StringDrawerTest::testDraw0x0Screen(){
	std::string myMap="width 96\n";
	myMap+="height 35\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="K a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="    a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a.      b b       b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a           a.a     a a a a a   b b.b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a         g k a a     a a a     b b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a           l a a a     a a       b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a               a a   a       a               b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    c             a                                 b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  c c c           a a                               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c                                   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b.b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a.a.a.";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer sdr(bBoard);
	sdr.setCoord(0,0);
	sdr.setClearScreen(false);
	std::string tov;//= sdr.drawScreen( );
	//sdr.setCursor(0,0);
	std::string resultat="Action:No action,Actual player:No Player,Nb Free Action:0/0\n";
	resultat+="-------------------------------------------------------------------------------\n";
	resultat+="|kaoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|  aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|    aaaaaaaaaaaaaaaaaaaaaa aaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|    aaaaaaaaaaaaaaaaaaa a  aaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|    aaaaaaaaaaaaaaaaaa      aaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|    aaaaaaaaaaaaaaaaaa       bbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|aaaaaaaa aa  aaaaaaao   bb   bbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|aaaaaa    aa  aaaaaa bbbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|aaaaa     oa  aaaaa bobbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="| aaaa    gkaa  aaa  bbbbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="| aaaa     laaa  aa   bbbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|  a       aa a   a       bbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|  c      a                bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="| ccc     aa               bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|ccccccccc                 bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|ccccccccc       ccc       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|cccccccccco    cccccc   bbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|cccccccccccc   ccccccccbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|cccccccccccccccccccccccbb bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|ccccccccccccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|ccccccccccccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="|ccccccccccccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaa|\n";
	resultat+="-------------------------------------------------------------------------------";

	if (tov!=resultat){
		//std::cout << "ERROR : testDraw0x0Screen bad drawed map \n"<<tov<<std::endl;
		std::cout << "ERROR : testDraw0x0Screen bad drawed map \n"<<std::endl;
		return 0;

	}
	else
	{
		std::cout << "OK : testDraw0x0Screen"<<std::endl;
		return 0;
	}
}

int StringDrawerTest::testDraw1x1Screen(){
	std::string myMap="width 96\n";
	myMap+="height 35\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="K a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="  P a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a.      b b       b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a           a.a     a a a a a   b b.b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a         g k a a     a a a     b b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a           l a a a     a a       b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a               a a   a       a               b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    c             a                                 b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  c c c           a a                               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c                                   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b.b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a.a.a.";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer sdr(bBoard);
	sdr.setCoord(1,1);
	sdr.setClearScreen(false);
	std::string tov;//= sdr.drawScreen( );
	//sdr.setCursor(0,0);
	std::string resultat="Action:No action,Actual player:No Player,Nb Free Action:0/0\n";
	resultat+="-------------------------------------------------------------------------------\n";
	resultat+="|paaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|   aaaaaaaaaaaaaaaaaaaaaa aaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|   aaaaaaaaaaaaaaaaaaa a  aaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|   aaaaaaaaaaaaaaaaaa      aaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|   aaaaaaaaaaaaaaaaaa       bbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|aaaaaaa aa  aaaaaaao   bb   bbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|aaaaa    aa  aaaaaa bbbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|aaaa     oa  aaaaa bobbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|aaaa    gkaa  aaa  bbbbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|aaaa     laaa  aa   bbbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="| a       aa a   a       bbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="| c      a                bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|ccc     aa               bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|cccccccc                 bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|cccccccc       ccc       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|ccccccccco    cccccc   bbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|ccccccccccc   ccccccccbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|ccccccccccccccccccccccbb bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|cccccccccccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|cccccccccccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|cccccccccccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="|cccccccccccccccccccccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaa|\n";
	resultat+="-------------------------------------------------------------------------------";

	if (tov!=resultat){
		//std::cout << "ERROR : testDraw1x1Screen bad drawed map \n"<<tov<<std::endl;
		std::cout << "ERROR : testDraw1x1Screen bad drawed map \n"<<std::endl;
		return 0;

	}
	else
	{
		std::cout << "OK : testDraw1x1Screen"<<std::endl;
		return 0;
	}
}


int StringDrawerTest::testDrawBordScreen(){
	std::string myMap="width 96\n";
	myMap+="height 35\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="K a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="    a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a.      b b       b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a           a.a     a a a a a   b b.b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a         g k a a     a a a     b b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a           l a a a     a a       b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a               a a   a       a               b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    c             a                                 b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  c c c           a a                               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c                                   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b.b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a.a.Z ";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer sdr(bBoard);
	sdr.setCoord(95,34);
	sdr.setClearScreen(false);
	std::string tov;//= sdr.drawScreen( );
	//sdr.setCursor(0,0);
	std::string resultat="Action:No action,Actual player:No Player,Nb Free Action:0/0\n";
	resultat+="-------------------------------------------------------------------------------\n";
	resultat+="|       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cc   bbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccbb bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc   bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaao|\n";
	resultat+="|ccccc  bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaao|\n";
	resultat+="|ccccc   bbbob aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaooz|\n";
	resultat+="-------------------------------------------------------------------------------";

	if (tov!=resultat){
		std::cout << "ERROR : testDrawBordScreen bad drawed map \n"<<std::endl;
		
		return 0;

	}
	else
	{
		std::cout << "OK : testDrawBordScreen"<<std::endl;
		return 0;
	}
}

int StringDrawerTest::testDrawBordPresqScreen(){
	std::string myMap="width 96\n";
	myMap+="height 35\n";
	myMap+="warped 0\n";
	myMap+="players 3\n";
	myMap+="active_players 7\n";
	myMap+="remaining_players 7\n";
	myMap+="turn 1\n";
	myMap+="n_att 0\n";
	myMap+="K a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="    a a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a a a a   a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a a   a     a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a             a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="        a a a a a a a a a a a a a a a a a a               b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a a a   a a     a a a a a a a a.      b b       b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a a         a a     a a a a a a   b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="a a a a a           a.a     a a a a a   b b.b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a         g k a a     a a a     b b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  a a a a           l a a a     a a       b b b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    a               a a   a       a               b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="    c             a                                 b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="  c c c           a a                               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c                                   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c               c c c               b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c.        c c c c c c       b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c       c c c c c c c c b b b b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c b b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c   b   b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a \n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c       b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c     b b b b b b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a Y a.\n";
	myMap+="c c c c c c c c c c c c c c c c c c c c c c c c       b b b b.b   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a a a   a a.a a a a a a a a a a a a a a a a a a a a a a a a a a a.a.Z ";

	
	Board bBoard=MapManager::loadStringMap(myMap);
	
	StringDrawer sdr(bBoard);
	sdr.setCoord(94,33);
	sdr.setClearScreen(false);
	std::string tov;//= sdr.drawScreen( );
	//sdr.setCursor(0,0);
	std::string resultat="Action:No action,Actual player:No Player,Nb Free Action:0/0\n";
	resultat+="-------------------------------------------------------------------------------\n";
	resultat+="|       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|       bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cc   bbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccbbbbbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|ccccbb bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc b bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa|\n";
	resultat+="|cccc   bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaaao|\n";
	resultat+="|ccccc  bbbbbb aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaayo|\n";
	resultat+="|ccccc   bbbob aoaaaaaaaaaaaaaaaaaaaaaaaaaaaaa aoaaaaaaaaaaaaaaaaaaaaaaaaaaooz|\n";
	resultat+="-------------------------------------------------------------------------------";

	if (tov!=resultat){
		//std::cout << "ERROR : testDrawBordPresqScreen bad drawed map \n"<<tov<<std::endl;
		std::cout << "ERROR : testDrawBordPresqScreen bad drawed map \n"<<std::endl;
		return 0;

	}
	else
	{
		std::cout << "OK : testDrawBordPresqScreen"<<std::endl;
		return 0;
	}
}