/* -*-c-*- -------------- mixgtk.c :
 * Main functions of the mix gtk front-end
 * ------------------------------------------------------------------
 * $Id: mixgtk.c,v 1.15 2002/04/10 23:39:40 jao Exp $
 * ------------------------------------------------------------------
 * Copyright (C) 2001, 2002 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */

#include <stdio.h>
#include <string.h>

#include "mixgtk_widgets.h"
#include "mixgtk_cmd_dispatcher.h"
#include "mixgtk_device.h"
#include "mixgtk_mixvm.h"
#include "mixgtk_mixal.h"
#include "mixgtk_input.h"
#include "mixgtk_colorsel.h"
#include "mixgtk_fontsel.h"
#include "mixgtk_config.h"
#include "mixgtk_wm.h"
#include "mixgtk.h"

static const gchar *SPLIT_ARG_ = "-s";
static const gchar *SPLIT_LONG_ARG_ = "--s";

gboolean
mixgtk_restart (void)
{
  mix_vm_t *vm;
  
  if (!mixgtk_widget_factory_init ())
    {
      g_error (_("Unable to initialise application: missing glade file"));
      return FALSE;
    }

  mixgtk_fontsel_load_defaults ();

  if (!mixgtk_cmd_dispatcher_init (MIXGTK_MAIN))
    {
      g_error (_("Unable to initialise application (command dispatcher)\n"));
      return FALSE;
    }

  vm = mixgtk_cmd_dispatcher_get_vm ();
  
  if (!mixgtk_mixvm_init (vm, MIXGTK_MIXVM_DIALOG))
    {
      g_error (_("Unable to initialise application (mixvm widgets)\n"));
      return FALSE;
    }

  if (!mixgtk_mixal_init (vm, MIXGTK_MIXAL_DIALOG))
    {
      g_error (_("Unable to initialise application (mixal widgets)\n"));
      return FALSE;
    }

  if (!mixgtk_device_init (GTK_NOTEBOOK
			   (mixgtk_widget_factory_get
			    (MIXGTK_DEVICES_DIALOG, MIXGTK_WIDGET_DEVICE)),
			   vm))
    {
      g_error (_("Unable to initialise application (devices)\n"));
      return FALSE;
    }
  
  if (!mixgtk_wm_init ())
    {
      g_error (_("Unable to initialise application (visibility)\n"));
      return FALSE;
    }

  mixgtk_input_init ();
  mixgtk_colorsel_init ();

  gtk_widget_show (mixgtk_widget_factory_get_dialog (MIXGTK_MAIN));
  mixgtk_mixvm_update_vm_widgets ();

  return TRUE;
}

/* initialise the app */
gboolean
mixgtk_init (int argc, char *argv[])
{
  gboolean split = FALSE;
  gint k;
  
  mix_init_lib ();
  
  if (!mixgtk_config_load ())
    {
      g_error ("Unable to read configuration\n");
      return FALSE;
    }
  
  for (k = 0; k < argc; ++k)
    if (!strcmp (argv[k], SPLIT_ARG_) || !strcmp (argv[k], SPLIT_LONG_ARG_))
      {
	split = TRUE;
	break;
      }
  if (!split && mixgtk_config_is_split ()) split = TRUE;
  mixgtk_config_set_split (split);
  
  gtk_init (&argc, &argv);

  return mixgtk_restart ();
}

/* main loop */
void
mixgtk_main (void)
{
  gtk_main ();
}

/* clean up */
void
mixgtk_release (void) 
{
  if (mixgtk_config_is_autosave ()) mixgtk_config_save ();
  mix_vm_cmd_dispatcher_delete (mixgtk_cmd_dispatcher_get_mix_dispatcher ());
  mix_release_lib ();
}
