/* modi.h

   written by Frederic Bois
   27 November 1997

   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   -- Revisions -----
     Logfile:  %F%
    Revision:  %I%
        Date:  %G%
     Modtime:  %U%
      Author:  @a
   -- SCCS  ---------

   Header file for main parsing routines.
*/

#ifndef _MODI_H_

/* ---------------------------------------------------------------------------
   Typedefs */

typedef struct tagKM {
  PSTR szKeyword;
  int  iKWCode;   /* Enumeration code of Keyword KM_* */
  WORD  fContext; /* Bit flags of valid context for KW */
} KM, *PKM; /* Keyword Map */


/* ---------------------------------------------------------------------------
   Prototypes */

int  GetKeywordCode (PSTR szKeyword, PINT pfContext);
PSTR GetKeyword (int iCode);
void GetVarList (PINPUTBUF pibIn, PSTR szLex, int iKWCode);
void InitInfo (PINPUTINFO pinfo, PSTR szInputFilename);
void ProcessDTStatement (PINPUTBUF pibIn, PSTR szLex, PSTR szEqn, int iKWCode);
void ProcessIdentifier (PINPUTBUF pibIn, PSTR szLex, PSTR szEqn, int iKWCode);
void ProcessWord (PINPUTBUF pibIn, PSTR szLex, PSTR szEqn);
void ReadModel (PINPUTINFO pinfo, PSTR szFullPathname);

#define _MODI_H_
#endif

/* End */


