/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6MAP_H
#define LIQUIDWAR6MAP_H

#include "../sys/sys.h"

#define LW6MAP_MAX_FIGHTER_HEALTH 10000
/*
 * 10 teams maximum because well, in fact 5 is probably
 * enough but we raise the limit not to frustrate too much
 * is some players want to try out 7, 8, 9... Note that
 * increasing this could *really* slow down the game, so
 * there are good technical reasons not to have this too high.
 */
#define LW6MAP_MAX_NB_TEAMS 10
/*
 * Maximum of 26, just because there are 26 letters in the
 * standard latin alphabet, and associating a letter to a
 * cursor is convenient. 26 cursors for 10 teams is plenty
 * enough of cursors.
 */
#define LW6MAP_MAX_NB_CURSORS 26
/*
 * This should not be too high since it's closely related
 * to the max number of nodes in a network and in most
 * cases traffic is proportionnal to the square of nb_players-1,
 * that's to say with 11 players we already have 100 times more
 * traffic. In that context, 15 is enough, also don't forget
 * there are 10 teams max.
 */
#define LW6MAP_MAX_NB_NODES 15
#define LW6MAP_MAX_NB_DIR_TRIES 7
#define LW6MAP_CURSOR_TEXTURE_SIZE 64
#define LW6MAP_MIN_WEAPON_ID 0
#define LW6MAP_MAX_WEAPON_ID 19

/*
 * Previously tried to define this as an enum lw6map_weapon_e
 * with type lw6map_weapon_t but it fails on hlp-reference macros
 * and quoting, so plain old #defines are easier to read.
 */
#define LW6MAP_WEAPON_NONE -1
#define LW6MAP_WEAPON_BERZERK 0
#define LW6MAP_WEAPON_INVINCIBLE 1
#define LW6MAP_WEAPON_ESCAPE 2
#define LW6MAP_WEAPON_TURBO 3
#define LW6MAP_WEAPON_TELEPORT 4
#define LW6MAP_WEAPON_SCATTER 5
#define LW6MAP_WEAPON_FIX 6
#define LW6MAP_WEAPON_MIX 7
#define LW6MAP_WEAPON_CONTROL 8
#define LW6MAP_WEAPON_PERMUTATION 9
#define LW6MAP_WEAPON_STEAL 10
#define LW6MAP_WEAPON_ATOMIC 11
#define LW6MAP_WEAPON_REVERSE 12
#define LW6MAP_WEAPON_CRAZY 13
#define LW6MAP_WEAPON_REWIND 14
#define LW6MAP_WEAPON_ATTRACT 15
#define LW6MAP_WEAPON_SHRINK 16
#define LW6MAP_WEAPON_KAMIKAZE 17
#define LW6MAP_WEAPON_DISAPPEAR 18
#define LW6MAP_WEAPON_PLAGUE 19

#define LW6MAP_RULES_POSITION_MODE_PREDEFINED 0
#define LW6MAP_RULES_POSITION_MODE_PICK_EXISTING 1
#define LW6MAP_RULES_POSITION_MODE_TOTAL_RANDOM 2

#define LW6MAP_RULES_SPREAD_MODE_ONE 0
#define LW6MAP_RULES_SPREAD_MODE_HALF 1
#define LW6MAP_RULES_SPREAD_MODE_ALL 2

#define LW6MAP_RULES_COLOR_CONFLICT_MODE_ALLOW_SHARE 0
#define LW6MAP_RULES_COLOR_CONFLICT_MODE_ALLOW_LOCAL_SHARE 1
#define LW6MAP_RULES_COLOR_CONFLICT_MODE_PICK_NEW 2

#define LW6MAP_RULES_FRAGS_MODE_ONE_NEGATIVE_POINT 0
#define LW6MAP_RULES_FRAGS_MODE_ONE_FOR_WINNERS_ALL_FOR_LOSER 1
#define LW6MAP_RULES_FRAGS_MODE_BALANCED 2
#define LW6MAP_RULES_FRAGS_MODE_PROPORTIONAL 3

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_AGGRESSIVE 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_AGGRESSIVE 5
#define LW6MAP_RULES_MAX_TEAM_PROFILE_AGGRESSIVE 2000

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_VULNERABLE 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_VULNERABLE 5
#define LW6MAP_RULES_MAX_TEAM_PROFILE_VULNERABLE 2000

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_MOBILE 0
#define LW6MAP_RULES_MIN_TEAM_PROFILE_MOBILE -3
#define LW6MAP_RULES_MAX_TEAM_PROFILE_MOBILE 3

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_FAST 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_FAST 5
#define LW6MAP_RULES_MAX_TEAM_PROFILE_FAST 2000

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_HANDICAP 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_HANDICAP 10
#define LW6MAP_RULES_MAX_TEAM_PROFILE_HANDICAP 1000

#define LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_NONE 0
#define LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_BY_ID 1
#define LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_RANDOM 2

/*
 * All static rules default/min/max
 */
// 15 minutes
#define LW6MAP_RULES_DEFAULT_TOTAL_TIME 900
// 10 seconds
#define LW6MAP_RULES_MIN_TOTAL_TIME 10
// 10 days
#define LW6MAP_RULES_MAX_TOTAL_TIME 864000

#define LW6MAP_RULES_DEFAULT_RESPAWN_TEAM 1
#define LW6MAP_RULES_MIN_RESPAWN_TEAM 0
#define LW6MAP_RULES_MAX_RESPAWN_TEAM 1

#define LW6MAP_RULES_DEFAULT_RESPAWN_POSITION_MODE LW6MAP_RULES_POSITION_MODE_PICK_EXISTING
#define LW6MAP_RULES_MIN_RESPAWN_POSITION_MODE 0
#define LW6MAP_RULES_MAX_RESPAWN_POSITION_MODE 2

#define LW6MAP_RULES_DEFAULT_RESPAWN_DELAY 3
#define LW6MAP_RULES_MIN_RESPAWN_DELAY 0
#define LW6MAP_RULES_MAX_RESPAWN_DELAY 30

#define LW6MAP_RULES_DEFAULT_MOVES_PER_ROUND 2
#define LW6MAP_RULES_MIN_MOVES_PER_ROUND 1
#define LW6MAP_RULES_MAX_MOVES_PER_ROUND 50

#define LW6MAP_RULES_DEFAULT_SPREADS_PER_ROUND 5
#define LW6MAP_RULES_MIN_SPREADS_PER_ROUND 1
#define LW6MAP_RULES_MAX_SPREADS_PER_ROUND 100

#define LW6MAP_RULES_DEFAULT_ROUNDS_PER_SEC 50
#define LW6MAP_RULES_MIN_ROUNDS_PER_SEC 1
#define LW6MAP_RULES_MAX_ROUNDS_PER_SEC 200

#define LW6MAP_RULES_DEFAULT_FIGHTER_ATTACK 500
#define LW6MAP_RULES_MIN_FIGHTER_ATTACK 1
#define LW6MAP_RULES_MAX_FIGHTER_ATTACK LW6MAP_MAX_FIGHTER_HEALTH

#define LW6MAP_RULES_DEFAULT_FIGHTER_DEFENSE 50
#define LW6MAP_RULES_MIN_FIGHTER_DEFENSE 0
#define LW6MAP_RULES_MAX_FIGHTER_DEFENSE LW6MAP_MAX_FIGHTER_HEALTH

#define LW6MAP_RULES_DEFAULT_FIGHTER_NEW_HEALTH 5000
#define LW6MAP_RULES_MIN_FIGHTER_NEW_HEALTH 1
#define LW6MAP_RULES_MAX_FIGHTER_NEW_HEALTH LW6MAP_MAX_FIGHTER_HEALTH

#define LW6MAP_RULES_DEFAULT_FIGHTER_REGENERATE 5
#define LW6MAP_RULES_MIN_FIGHTER_REGENERATE 0
#define LW6MAP_RULES_MAX_FIGHTER_REGENERATE LW6MAP_MAX_FIGHTER_HEALTH

// 20%
#define LW6MAP_RULES_DEFAULT_SIDE_ATTACK_FACTOR 20
#define LW6MAP_RULES_MIN_SIDE_ATTACK_FACTOR 0
#define LW6MAP_RULES_MAX_SIDE_ATTACK_FACTOR 100

// 20%
#define LW6MAP_RULES_DEFAULT_SIDE_DEFENSE_FACTOR 20
#define LW6MAP_RULES_MIN_SIDE_DEFENSE_FACTOR 0
#define LW6MAP_RULES_MAX_SIDE_DEFENSE_FACTOR 100

#define LW6MAP_RULES_DEFAULT_NB_MOVE_TRIES 5
#define LW6MAP_RULES_MIN_NB_MOVE_TRIES 3
#define LW6MAP_RULES_MAX_NB_MOVE_TRIES LW6MAP_MAX_NB_DIR_TRIES

#define LW6MAP_RULES_DEFAULT_NB_ATTACK_TRIES 3
#define LW6MAP_RULES_MIN_NB_ATTACK_TRIES 1
#define LW6MAP_RULES_MAX_NB_ATTACK_TRIES LW6MAP_MAX_NB_DIR_TRIES

#define LW6MAP_RULES_DEFAULT_NB_DEFENSE_TRIES 1
#define LW6MAP_RULES_MIN_NB_DEFENSE_TRIES 1
#define LW6MAP_RULES_MAX_NB_DEFENSE_TRIES LW6MAP_MAX_NB_DIR_TRIES

#define LW6MAP_RULES_DEFAULT_VERTICAL_MOVE 1
#define LW6MAP_RULES_MIN_VERTICAL_MOVE 0
#define LW6MAP_RULES_MAX_VERTICAL_MOVE LW6MAP_MAX_NB_DIR_TRIES

#define LW6MAP_RULES_DEFAULT_SPREAD_MODE LW6MAP_RULES_SPREAD_MODE_HALF
#define LW6MAP_RULES_MIN_SPREAD_MODE LW6MAP_RULES_SPREAD_MODE_ONE
#define LW6MAP_RULES_MAX_SPREAD_MODE LW6MAP_RULES_SPREAD_MODE_ALL

// 9%
#define LW6MAP_RULES_DEFAULT_SINGLE_ARMY_SIZE 30
// 0.01%
#define LW6MAP_RULES_MIN_SINGLE_ARMY_SIZE 1
// 90%
#define LW6MAP_RULES_MAX_SINGLE_ARMY_SIZE 95

// 36%
#define LW6MAP_RULES_DEFAULT_TOTAL_ARMIES_SIZE 60
// 0.01%
#define LW6MAP_RULES_MIN_TOTAL_ARMIES_SIZE 1
// 90%
#define LW6MAP_RULES_MAX_TOTAL_ARMIES_SIZE 95

#define LW6MAP_RULES_DEFAULT_MAX_NB_TEAMS LW6MAP_MAX_NB_TEAMS
#define LW6MAP_RULES_MIN_MAX_NB_TEAMS 2
#define LW6MAP_RULES_MAX_MAX_NB_TEAMS LW6MAP_MAX_NB_TEAMS

#define LW6MAP_RULES_DEFAULT_MAX_NB_CURSORS LW6MAP_MAX_NB_CURSORS
#define LW6MAP_RULES_MIN_MAX_NB_CURSORS 2
#define LW6MAP_RULES_MAX_MAX_NB_CURSORS LW6MAP_MAX_NB_CURSORS

// LW6MAP_MAX_NB_TEAMS+2
#define LW6MAP_RULES_DEFAULT_MAX_NB_NODES 12
#define LW6MAP_RULES_MIN_MAX_NB_NODES 2
#define LW6MAP_RULES_MAX_MAX_NB_NODES LW6MAP_MAX_NB_NODES

#define LW6MAP_RULES_DEFAULT_EXP 1
#define LW6MAP_RULES_MIN_EXP 0
#define LW6MAP_RULES_MAX_EXP 99

// LW6MAP_MAX_NB_TEAMS-1
#define LW6MAP_RULES_DEFAULT_HIGHEST_TEAM_COLOR_ALLOWED 9
#define LW6MAP_RULES_MIN_HIGHEST_TEAM_COLOR_ALLOWED 3
#define LW6MAP_RULES_MAX_HIGHEST_TEAM_COLOR_ALLOWED 9

#define LW6MAP_RULES_DEFAULT_HIGHEST_WEAPON_ALLOWED LW6MAP_MAX_WEAPON_ID
#define LW6MAP_RULES_MIN_HIGHEST_WEAPON_ALLOWED 7
#define LW6MAP_RULES_MAX_HIGHEST_WEAPON_ALLOWED LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_X_POLARITY 0
#define LW6MAP_RULES_MIN_X_POLARITY -1
#define LW6MAP_RULES_MAX_X_POLARITY 1

#define LW6MAP_RULES_DEFAULT_Y_POLARITY 0
#define LW6MAP_RULES_MIN_Y_POLARITY -1
#define LW6MAP_RULES_MAX_Y_POLARITY 1

#define LW6MAP_RULES_DEFAULT_Z_POLARITY 0
#define LW6MAP_RULES_MIN_Z_POLARITY 0
#define LW6MAP_RULES_MAX_Z_POLARITY 1

#define LW6MAP_RULES_DEFAULT_MAX_ZONE_SIZE 8
#define LW6MAP_RULES_MIN_MAX_ZONE_SIZE 1
#define LW6MAP_RULES_MAX_MAX_ZONE_SIZE 64

#define LW6MAP_RULES_DEFAULT_ROUND_DELTA 1
#define LW6MAP_RULES_MIN_ROUND_DELTA 0
#define LW6MAP_RULES_MAX_ROUND_DELTA 100

#define LW6MAP_RULES_DEFAULT_MAX_ROUND_DELTA 1000
#define LW6MAP_RULES_MIN_MAX_ROUND_DELTA 1
#define LW6MAP_RULES_MAX_MAX_ROUND_DELTA 10000

#define LW6MAP_RULES_DEFAULT_MAX_CURSOR_POT 1000000
#define LW6MAP_RULES_MIN_MAX_CURSOR_POT 50000
#define LW6MAP_RULES_MAX_MAX_CURSOR_POT 5000000

#define LW6MAP_RULES_DEFAULT_CURSOR_POT_INIT 100000
#define LW6MAP_RULES_MIN_CURSOR_POT_INIT 5000
#define LW6MAP_RULES_MAX_CURSOR_POT_INIT 500000

#define LW6MAP_RULES_DEFAULT_MAX_CURSOR_POT_OFFSET 100
#define LW6MAP_RULES_MIN_MAX_CURSOR_POT_OFFSET 1
#define LW6MAP_RULES_MAX_MAX_CURSOR_POT_OFFSET 10000

#define LW6MAP_RULES_DEFAULT_START_RED_X 10
#define LW6MAP_RULES_MIN_START_RED_X 0
#define LW6MAP_RULES_MAX_START_RED_X 100

#define LW6MAP_RULES_DEFAULT_START_GREEN_X 90
#define LW6MAP_RULES_MIN_START_GREEN_X 0
#define LW6MAP_RULES_MAX_START_GREEN_X 100

#define LW6MAP_RULES_DEFAULT_START_BLUE_X 90
#define LW6MAP_RULES_MIN_START_BLUE_X 0
#define LW6MAP_RULES_MAX_START_BLUE_X 100

#define LW6MAP_RULES_DEFAULT_START_YELLOW_X 10
#define LW6MAP_RULES_MIN_START_YELLOW_X 0
#define LW6MAP_RULES_MAX_START_YELLOW_X 100

#define LW6MAP_RULES_DEFAULT_START_CYAN_X 35
#define LW6MAP_RULES_MIN_START_CYAN_X 0
#define LW6MAP_RULES_MAX_START_CYAN_X 100

#define LW6MAP_RULES_DEFAULT_START_MAGENTA_X 65
#define LW6MAP_RULES_MIN_START_MAGENTA_X 0
#define LW6MAP_RULES_MAX_START_MAGENTA_X 100

#define LW6MAP_RULES_DEFAULT_START_ORANGE_X 65
#define LW6MAP_RULES_MIN_START_ORANGE_X 0
#define LW6MAP_RULES_MAX_START_ORANGE_X 100

#define LW6MAP_RULES_DEFAULT_START_LIGHTBLUE_X 35
#define LW6MAP_RULES_MIN_START_LIGHTBLUE_X 0
#define LW6MAP_RULES_MAX_START_LIGHTBLUE_X 100

#define LW6MAP_RULES_DEFAULT_START_PURPLE_X 90
#define LW6MAP_RULES_MIN_START_PURPLE_X 0
#define LW6MAP_RULES_MAX_START_PURPLE_X 100

#define LW6MAP_RULES_DEFAULT_START_PINK_X 10
#define LW6MAP_RULES_MIN_START_PINK_X 0
#define LW6MAP_RULES_MAX_START_PINK_X 100

#define LW6MAP_RULES_DEFAULT_START_RED_Y 10
#define LW6MAP_RULES_MIN_START_RED_Y 0
#define LW6MAP_RULES_MAX_START_RED_Y 100

#define LW6MAP_RULES_DEFAULT_START_GREEN_Y 90
#define LW6MAP_RULES_MIN_START_GREEN_Y 0
#define LW6MAP_RULES_MAX_START_GREEN_Y 100

#define LW6MAP_RULES_DEFAULT_START_BLUE_Y 10
#define LW6MAP_RULES_MIN_START_BLUE_Y 0
#define LW6MAP_RULES_MAX_START_BLUE_Y 100

#define LW6MAP_RULES_DEFAULT_START_YELLOW_Y 90
#define LW6MAP_RULES_MIN_START_YELLOW_Y 0
#define LW6MAP_RULES_MAX_START_YELLOW_Y 100

#define LW6MAP_RULES_DEFAULT_START_CYAN_Y 10
#define LW6MAP_RULES_MIN_START_CYAN_Y 0
#define LW6MAP_RULES_MAX_START_CYAN_Y 100

#define LW6MAP_RULES_DEFAULT_START_MAGENTA_Y 90
#define LW6MAP_RULES_MIN_START_MAGENTA_Y 0
#define LW6MAP_RULES_MAX_START_MAGENTA_Y 100

#define LW6MAP_RULES_DEFAULT_START_ORANGE_Y 10
#define LW6MAP_RULES_MIN_START_ORANGE_Y 0
#define LW6MAP_RULES_MAX_START_ORANGE_Y 100

#define LW6MAP_RULES_DEFAULT_START_LIGHTBLUE_Y 90
#define LW6MAP_RULES_MIN_START_LIGHTBLUE_Y 0
#define LW6MAP_RULES_MAX_START_LIGHTBLUE_Y 100

#define LW6MAP_RULES_DEFAULT_START_PURPLE_Y 50
#define LW6MAP_RULES_MIN_START_PURPLE_Y 0
#define LW6MAP_RULES_MAX_START_PURPLE_Y 100

#define LW6MAP_RULES_DEFAULT_START_PINK_Y 50
#define LW6MAP_RULES_MIN_START_PINK_Y 0
#define LW6MAP_RULES_MAX_START_PINK_Y 100

#define LW6MAP_RULES_DEFAULT_START_POSITION_MODE LW6MAP_RULES_POSITION_MODE_PREDEFINED
#define LW6MAP_RULES_MIN_START_POSITION_MODE 0
#define LW6MAP_RULES_MAX_START_POSITION_MODE 2

#define LW6MAP_RULES_DEFAULT_COLOR_CONFLICT_MODE LW6MAP_RULES_COLOR_CONFLICT_MODE_ALLOW_LOCAL_SHARE
#define LW6MAP_RULES_MIN_COLOR_CONFLICT_MODE 0
#define LW6MAP_RULES_MAX_COLOR_CONFLICT_MODE 2

#define LW6MAP_RULES_DEFAULT_SPREAD_THREAD 0
#define LW6MAP_RULES_MIN_SPREAD_THREAD 0
#define LW6MAP_RULES_MAX_SPREAD_THREAD 1

#define LW6MAP_RULES_DEFAULT_GLUE_POWER 20
#define LW6MAP_RULES_MIN_GLUE_POWER 1
#define LW6MAP_RULES_MAX_GLUE_POWER 100

#define LW6MAP_RULES_DEFAULT_BOOST_POWER 3
#define LW6MAP_RULES_MIN_BOOST_POWER 1
#define LW6MAP_RULES_MAX_BOOST_POWER 10

#define LW6MAP_RULES_DEFAULT_DANGER_POWER 200
#define LW6MAP_RULES_MIN_DANGER_POWER 0
#define LW6MAP_RULES_MAX_DANGER_POWER LW6MAP_MAX_FIGHTER_HEALTH

#define LW6MAP_RULES_DEFAULT_MEDICINE_POWER 100
#define LW6MAP_RULES_MIN_MEDICINE_POWER 0
#define LW6MAP_RULES_MAX_MEDICINE_POWER LW6MAP_MAX_FIGHTER_HEALTH

#define LW6MAP_RULES_DEFAULT_FRAGS_MODE LW6MAP_RULES_FRAGS_MODE_BALANCED
#define LW6MAP_RULES_MIN_FRAGS_MODE 0
#define LW6MAP_RULES_MAX_FRAGS_MODE 3

#define LW6MAP_RULES_DEFAULT_FRAGS_TO_DISTRIBUTE 100
#define LW6MAP_RULES_MIN_FRAGS_TO_DISTRIBUTE 10
#define LW6MAP_RULES_MAX_FRAGS_TO_DISTRIBUTE 1000

#define LW6MAP_RULES_DEFAULT_FRAGS_FADE_OUT 100
#define LW6MAP_RULES_MIN_FRAGS_FADE_OUT 10
#define LW6MAP_RULES_MAX_FRAGS_FADE_OUT 100

#define LW6MAP_RULES_DEFAULT_USE_TEAM_PROFILES 1
#define LW6MAP_RULES_MIN_USE_TEAM_PROFILES 0
#define LW6MAP_RULES_MAX_USE_TEAM_PROFILES 1

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_RED_AGGRESSIVE 220
#define LW6MAP_RULES_MIN_TEAM_PROFILE_RED_AGGRESSIVE LW6MAP_RULES_MIN_TEAM_PROFILE_AGGRESSIVE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_RED_AGGRESSIVE LW6MAP_RULES_MAX_TEAM_PROFILE_AGGRESSIVE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_GREEN_AGGRESSIVE 70
#define LW6MAP_RULES_MIN_TEAM_PROFILE_GREEN_AGGRESSIVE LW6MAP_RULES_MIN_TEAM_PROFILE_AGGRESSIVE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_GREEN_AGGRESSIVE LW6MAP_RULES_MAX_TEAM_PROFILE_AGGRESSIVE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_BLUE_AGGRESSIVE 150
#define LW6MAP_RULES_MIN_TEAM_PROFILE_BLUE_AGGRESSIVE LW6MAP_RULES_MIN_TEAM_PROFILE_AGGRESSIVE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_BLUE_AGGRESSIVE LW6MAP_RULES_MAX_TEAM_PROFILE_AGGRESSIVE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_YELLOW_AGGRESSIVE 200
#define LW6MAP_RULES_MIN_TEAM_PROFILE_YELLOW_AGGRESSIVE LW6MAP_RULES_MIN_TEAM_PROFILE_AGGRESSIVE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_YELLOW_AGGRESSIVE LW6MAP_RULES_MAX_TEAM_PROFILE_AGGRESSIVE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_CYAN_AGGRESSIVE 44
#define LW6MAP_RULES_MIN_TEAM_PROFILE_CYAN_AGGRESSIVE LW6MAP_RULES_MIN_TEAM_PROFILE_AGGRESSIVE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_CYAN_AGGRESSIVE LW6MAP_RULES_MAX_TEAM_PROFILE_AGGRESSIVE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_MAGENTA_AGGRESSIVE 192
#define LW6MAP_RULES_MIN_TEAM_PROFILE_MAGENTA_AGGRESSIVE LW6MAP_RULES_MIN_TEAM_PROFILE_AGGRESSIVE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_MAGENTA_AGGRESSIVE LW6MAP_RULES_MAX_TEAM_PROFILE_AGGRESSIVE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_ORANGE_AGGRESSIVE 48
#define LW6MAP_RULES_MIN_TEAM_PROFILE_ORANGE_AGGRESSIVE LW6MAP_RULES_MIN_TEAM_PROFILE_AGGRESSIVE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_ORANGE_AGGRESSIVE LW6MAP_RULES_MAX_TEAM_PROFILE_AGGRESSIVE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_LIGHTBLUE_AGGRESSIVE 200
#define LW6MAP_RULES_MIN_TEAM_PROFILE_LIGHTBLUE_AGGRESSIVE LW6MAP_RULES_MIN_TEAM_PROFILE_AGGRESSIVE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_LIGHTBLUE_AGGRESSIVE LW6MAP_RULES_MAX_TEAM_PROFILE_AGGRESSIVE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PURPLE_AGGRESSIVE 32
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PURPLE_AGGRESSIVE LW6MAP_RULES_MIN_TEAM_PROFILE_AGGRESSIVE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PURPLE_AGGRESSIVE LW6MAP_RULES_MAX_TEAM_PROFILE_AGGRESSIVE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PINK_AGGRESSIVE 640
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PINK_AGGRESSIVE LW6MAP_RULES_MIN_TEAM_PROFILE_AGGRESSIVE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PINK_AGGRESSIVE LW6MAP_RULES_MAX_TEAM_PROFILE_AGGRESSIVE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_RED_VULNERABLE 110
#define LW6MAP_RULES_MIN_TEAM_PROFILE_RED_VULNERABLE LW6MAP_RULES_MIN_TEAM_PROFILE_VULNERABLE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_RED_VULNERABLE LW6MAP_RULES_MAX_TEAM_PROFILE_VULNERABLE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_GREEN_VULNERABLE 30
#define LW6MAP_RULES_MIN_TEAM_PROFILE_GREEN_VULNERABLE LW6MAP_RULES_MIN_TEAM_PROFILE_VULNERABLE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_GREEN_VULNERABLE LW6MAP_RULES_MAX_TEAM_PROFILE_VULNERABLE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_BLUE_VULNERABLE 60
#define LW6MAP_RULES_MIN_TEAM_PROFILE_BLUE_VULNERABLE LW6MAP_RULES_MIN_TEAM_PROFILE_VULNERABLE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_BLUE_VULNERABLE LW6MAP_RULES_MAX_TEAM_PROFILE_VULNERABLE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_YELLOW_VULNERABLE 90
#define LW6MAP_RULES_MIN_TEAM_PROFILE_YELLOW_VULNERABLE LW6MAP_RULES_MIN_TEAM_PROFILE_VULNERABLE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_YELLOW_VULNERABLE LW6MAP_RULES_MAX_TEAM_PROFILE_VULNERABLE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_CYAN_VULNERABLE 12
#define LW6MAP_RULES_MIN_TEAM_PROFILE_CYAN_VULNERABLE LW6MAP_RULES_MIN_TEAM_PROFILE_VULNERABLE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_CYAN_VULNERABLE LW6MAP_RULES_MAX_TEAM_PROFILE_VULNERABLE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_MAGENTA_VULNERABLE 1920
#define LW6MAP_RULES_MIN_TEAM_PROFILE_MAGENTA_VULNERABLE LW6MAP_RULES_MIN_TEAM_PROFILE_VULNERABLE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_MAGENTA_VULNERABLE LW6MAP_RULES_MAX_TEAM_PROFILE_VULNERABLE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_ORANGE_VULNERABLE 144
#define LW6MAP_RULES_MIN_TEAM_PROFILE_ORANGE_VULNERABLE LW6MAP_RULES_MIN_TEAM_PROFILE_VULNERABLE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_ORANGE_VULNERABLE LW6MAP_RULES_MAX_TEAM_PROFILE_VULNERABLE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_LIGHTBLUE_VULNERABLE 8
#define LW6MAP_RULES_MIN_TEAM_PROFILE_LIGHTBLUE_VULNERABLE LW6MAP_RULES_MIN_TEAM_PROFILE_VULNERABLE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_LIGHTBLUE_VULNERABLE LW6MAP_RULES_MAX_TEAM_PROFILE_VULNERABLE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PURPLE_VULNERABLE 16
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PURPLE_VULNERABLE LW6MAP_RULES_MIN_TEAM_PROFILE_VULNERABLE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PURPLE_VULNERABLE LW6MAP_RULES_MAX_TEAM_PROFILE_VULNERABLE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PINK_VULNERABLE 640
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PINK_VULNERABLE LW6MAP_RULES_MIN_TEAM_PROFILE_VULNERABLE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PINK_VULNERABLE LW6MAP_RULES_MAX_TEAM_PROFILE_VULNERABLE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_RED_MOBILE 0
#define LW6MAP_RULES_MIN_TEAM_PROFILE_RED_MOBILE LW6MAP_RULES_MIN_TEAM_PROFILE_MOBILE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_RED_MOBILE LW6MAP_RULES_MAX_TEAM_PROFILE_MOBILE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_GREEN_MOBILE 0
#define LW6MAP_RULES_MIN_TEAM_PROFILE_GREEN_MOBILE LW6MAP_RULES_MIN_TEAM_PROFILE_MOBILE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_GREEN_MOBILE LW6MAP_RULES_MAX_TEAM_PROFILE_MOBILE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_BLUE_MOBILE 0
#define LW6MAP_RULES_MIN_TEAM_PROFILE_BLUE_MOBILE LW6MAP_RULES_MIN_TEAM_PROFILE_MOBILE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_BLUE_MOBILE LW6MAP_RULES_MAX_TEAM_PROFILE_MOBILE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_YELLOW_MOBILE 0
#define LW6MAP_RULES_MIN_TEAM_PROFILE_YELLOW_MOBILE LW6MAP_RULES_MIN_TEAM_PROFILE_MOBILE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_YELLOW_MOBILE LW6MAP_RULES_MAX_TEAM_PROFILE_MOBILE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_CYAN_MOBILE 0
#define LW6MAP_RULES_MIN_TEAM_PROFILE_CYAN_MOBILE LW6MAP_RULES_MIN_TEAM_PROFILE_MOBILE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_CYAN_MOBILE LW6MAP_RULES_MAX_TEAM_PROFILE_MOBILE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_MAGENTA_MOBILE 0
#define LW6MAP_RULES_MIN_TEAM_PROFILE_MAGENTA_MOBILE LW6MAP_RULES_MIN_TEAM_PROFILE_MOBILE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_MAGENTA_MOBILE LW6MAP_RULES_MAX_TEAM_PROFILE_MOBILE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_ORANGE_MOBILE 0
#define LW6MAP_RULES_MIN_TEAM_PROFILE_ORANGE_MOBILE LW6MAP_RULES_MIN_TEAM_PROFILE_MOBILE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_ORANGE_MOBILE LW6MAP_RULES_MAX_TEAM_PROFILE_MOBILE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_LIGHTBLUE_MOBILE 0
#define LW6MAP_RULES_MIN_TEAM_PROFILE_LIGHTBLUE_MOBILE LW6MAP_RULES_MIN_TEAM_PROFILE_MOBILE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_LIGHTBLUE_MOBILE LW6MAP_RULES_MAX_TEAM_PROFILE_MOBILE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PURPLE_MOBILE 0
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PURPLE_MOBILE LW6MAP_RULES_MIN_TEAM_PROFILE_MOBILE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PURPLE_MOBILE LW6MAP_RULES_MAX_TEAM_PROFILE_MOBILE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PINK_MOBILE 0
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PINK_MOBILE LW6MAP_RULES_MIN_TEAM_PROFILE_MOBILE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PINK_MOBILE LW6MAP_RULES_MAX_TEAM_PROFILE_MOBILE

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_RED_FAST 160
#define LW6MAP_RULES_MIN_TEAM_PROFILE_RED_FAST LW6MAP_RULES_MIN_TEAM_PROFILE_FAST
#define LW6MAP_RULES_MAX_TEAM_PROFILE_RED_FAST LW6MAP_RULES_MAX_TEAM_PROFILE_FAST

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_GREEN_FAST 70
#define LW6MAP_RULES_MIN_TEAM_PROFILE_GREEN_FAST LW6MAP_RULES_MIN_TEAM_PROFILE_FAST
#define LW6MAP_RULES_MAX_TEAM_PROFILE_GREEN_FAST LW6MAP_RULES_MAX_TEAM_PROFILE_FAST

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_BLUE_FAST 50
#define LW6MAP_RULES_MIN_TEAM_PROFILE_BLUE_FAST LW6MAP_RULES_MIN_TEAM_PROFILE_FAST
#define LW6MAP_RULES_MAX_TEAM_PROFILE_BLUE_FAST LW6MAP_RULES_MAX_TEAM_PROFILE_FAST

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_YELLOW_FAST 70
#define LW6MAP_RULES_MIN_TEAM_PROFILE_YELLOW_FAST LW6MAP_RULES_MIN_TEAM_PROFILE_FAST
#define LW6MAP_RULES_MAX_TEAM_PROFILE_YELLOW_FAST LW6MAP_RULES_MAX_TEAM_PROFILE_FAST

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_CYAN_FAST 40
#define LW6MAP_RULES_MIN_TEAM_PROFILE_CYAN_FAST LW6MAP_RULES_MIN_TEAM_PROFILE_FAST
#define LW6MAP_RULES_MAX_TEAM_PROFILE_CYAN_FAST LW6MAP_RULES_MAX_TEAM_PROFILE_FAST

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_MAGENTA_FAST 320
#define LW6MAP_RULES_MIN_TEAM_PROFILE_MAGENTA_FAST LW6MAP_RULES_MIN_TEAM_PROFILE_FAST
#define LW6MAP_RULES_MAX_TEAM_PROFILE_MAGENTA_FAST LW6MAP_RULES_MAX_TEAM_PROFILE_FAST

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_ORANGE_FAST 160
#define LW6MAP_RULES_MIN_TEAM_PROFILE_ORANGE_FAST LW6MAP_RULES_MIN_TEAM_PROFILE_FAST
#define LW6MAP_RULES_MAX_TEAM_PROFILE_ORANGE_FAST LW6MAP_RULES_MAX_TEAM_PROFILE_FAST

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_LIGHTBLUE_FAST 20
#define LW6MAP_RULES_MIN_TEAM_PROFILE_LIGHTBLUE_FAST LW6MAP_RULES_MIN_TEAM_PROFILE_FAST
#define LW6MAP_RULES_MAX_TEAM_PROFILE_LIGHTBLUE_FAST LW6MAP_RULES_MAX_TEAM_PROFILE_FAST

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PURPLE_FAST 80
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PURPLE_FAST LW6MAP_RULES_MIN_TEAM_PROFILE_FAST
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PURPLE_FAST LW6MAP_RULES_MAX_TEAM_PROFILE_FAST

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PINK_FAST 80
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PINK_FAST LW6MAP_RULES_MIN_TEAM_PROFILE_FAST
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PINK_FAST LW6MAP_RULES_MAX_TEAM_PROFILE_FAST

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_RED_HANDICAP 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_RED_HANDICAP LW6MAP_RULES_MIN_TEAM_PROFILE_HANDICAP
#define LW6MAP_RULES_MAX_TEAM_PROFILE_RED_HANDICAP LW6MAP_RULES_MAX_TEAM_PROFILE_HANDICAP

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_GREEN_HANDICAP 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_GREEN_HANDICAP LW6MAP_RULES_MIN_TEAM_PROFILE_HANDICAP
#define LW6MAP_RULES_MAX_TEAM_PROFILE_GREEN_HANDICAP LW6MAP_RULES_MAX_TEAM_PROFILE_HANDICAP

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_BLUE_HANDICAP 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_BLUE_HANDICAP LW6MAP_RULES_MIN_TEAM_PROFILE_HANDICAP
#define LW6MAP_RULES_MAX_TEAM_PROFILE_BLUE_HANDICAP LW6MAP_RULES_MAX_TEAM_PROFILE_HANDICAP

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_YELLOW_HANDICAP 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_YELLOW_HANDICAP LW6MAP_RULES_MIN_TEAM_PROFILE_HANDICAP
#define LW6MAP_RULES_MAX_TEAM_PROFILE_YELLOW_HANDICAP LW6MAP_RULES_MAX_TEAM_PROFILE_HANDICAP

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_CYAN_HANDICAP 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_CYAN_HANDICAP LW6MAP_RULES_MIN_TEAM_PROFILE_HANDICAP
#define LW6MAP_RULES_MAX_TEAM_PROFILE_CYAN_HANDICAP LW6MAP_RULES_MAX_TEAM_PROFILE_HANDICAP

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_MAGENTA_HANDICAP 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_MAGENTA_HANDICAP LW6MAP_RULES_MIN_TEAM_PROFILE_HANDICAP
#define LW6MAP_RULES_MAX_TEAM_PROFILE_MAGENTA_HANDICAP LW6MAP_RULES_MAX_TEAM_PROFILE_HANDICAP

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_ORANGE_HANDICAP 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_ORANGE_HANDICAP LW6MAP_RULES_MIN_TEAM_PROFILE_HANDICAP
#define LW6MAP_RULES_MAX_TEAM_PROFILE_ORANGE_HANDICAP LW6MAP_RULES_MAX_TEAM_PROFILE_HANDICAP

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_LIGHTBLUE_HANDICAP 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_LIGHTBLUE_HANDICAP LW6MAP_RULES_MIN_TEAM_PROFILE_HANDICAP
#define LW6MAP_RULES_MAX_TEAM_PROFILE_LIGHTBLUE_HANDICAP LW6MAP_RULES_MAX_TEAM_PROFILE_HANDICAP

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PURPLE_HANDICAP 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PURPLE_HANDICAP LW6MAP_RULES_MIN_TEAM_PROFILE_HANDICAP
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PURPLE_HANDICAP LW6MAP_RULES_MAX_TEAM_PROFILE_HANDICAP

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PINK_HANDICAP 100
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PINK_HANDICAP LW6MAP_RULES_MIN_TEAM_PROFILE_HANDICAP
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PINK_HANDICAP LW6MAP_RULES_MAX_TEAM_PROFILE_HANDICAP

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_RED_WEAPON_ID LW6MAP_WEAPON_STEAL
#define LW6MAP_RULES_MIN_TEAM_PROFILE_RED_WEAPON_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_RED_WEAPON_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_GREEN_WEAPON_ID LW6MAP_WEAPON_CRAZY
#define LW6MAP_RULES_MIN_TEAM_PROFILE_GREEN_WEAPON_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_GREEN_WEAPON_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_BLUE_WEAPON_ID LW6MAP_WEAPON_REWIND
#define LW6MAP_RULES_MIN_TEAM_PROFILE_BLUE_WEAPON_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_BLUE_WEAPON_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_YELLOW_WEAPON_ID LW6MAP_WEAPON_SCATTER
#define LW6MAP_RULES_MIN_TEAM_PROFILE_YELLOW_WEAPON_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_YELLOW_WEAPON_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_CYAN_WEAPON_ID LW6MAP_WEAPON_TURBO
#define LW6MAP_RULES_MIN_TEAM_PROFILE_CYAN_WEAPON_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_CYAN_WEAPON_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_MAGENTA_WEAPON_ID LW6MAP_WEAPON_FIX
#define LW6MAP_RULES_MIN_TEAM_PROFILE_MAGENTA_WEAPON_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_MAGENTA_WEAPON_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_ORANGE_WEAPON_ID LW6MAP_WEAPON_BERZERK
#define LW6MAP_RULES_MIN_TEAM_PROFILE_ORANGE_WEAPON_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_ORANGE_WEAPON_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_LIGHTBLUE_WEAPON_ID LW6MAP_WEAPON_TELEPORT
#define LW6MAP_RULES_MIN_TEAM_PROFILE_LIGHTBLUE_WEAPON_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_LIGHTBLUE_WEAPON_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PURPLE_WEAPON_ID LW6MAP_WEAPON_ATOMIC
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PURPLE_WEAPON_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PURPLE_WEAPON_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PINK_WEAPON_ID LW6MAP_WEAPON_INVINCIBLE
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PINK_WEAPON_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PINK_WEAPON_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_RED_WEAPON_ALTERNATE_ID LW6MAP_WEAPON_ESCAPE
#define LW6MAP_RULES_MIN_TEAM_PROFILE_RED_WEAPON_ALTERNATE_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_RED_WEAPON_ALTERNATE_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_GREEN_WEAPON_ALTERNATE_ID LW6MAP_WEAPON_MIX
#define LW6MAP_RULES_MIN_TEAM_PROFILE_GREEN_WEAPON_ALTERNATE_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_GREEN_WEAPON_ALTERNATE_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_BLUE_WEAPON_ALTERNATE_ID LW6MAP_WEAPON_CONTROL
#define LW6MAP_RULES_MIN_TEAM_PROFILE_BLUE_WEAPON_ALTERNATE_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_BLUE_WEAPON_ALTERNATE_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_YELLOW_WEAPON_ALTERNATE_ID LW6MAP_WEAPON_PERMUTATION
#define LW6MAP_RULES_MIN_TEAM_PROFILE_YELLOW_WEAPON_ALTERNATE_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_YELLOW_WEAPON_ALTERNATE_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_CYAN_WEAPON_ALTERNATE_ID LW6MAP_WEAPON_REVERSE
#define LW6MAP_RULES_MIN_TEAM_PROFILE_CYAN_WEAPON_ALTERNATE_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_CYAN_WEAPON_ALTERNATE_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_MAGENTA_WEAPON_ALTERNATE_ID LW6MAP_WEAPON_ATTRACT
#define LW6MAP_RULES_MIN_TEAM_PROFILE_MAGENTA_WEAPON_ALTERNATE_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_MAGENTA_WEAPON_ALTERNATE_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_ORANGE_WEAPON_ALTERNATE_ID LW6MAP_WEAPON_SHRINK
#define LW6MAP_RULES_MIN_TEAM_PROFILE_ORANGE_WEAPON_ALTERNATE_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_ORANGE_WEAPON_ALTERNATE_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_LIGHTBLUE_WEAPON_ALTERNATE_ID LW6MAP_WEAPON_KAMIKAZE
#define LW6MAP_RULES_MIN_TEAM_PROFILE_LIGHTBLUE_WEAPON_ALTERNATE_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_LIGHTBLUE_WEAPON_ALTERNATE_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PURPLE_WEAPON_ALTERNATE_ID LW6MAP_WEAPON_DISAPPEAR
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PURPLE_WEAPON_ALTERNATE_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PURPLE_WEAPON_ALTERNATE_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PINK_WEAPON_ALTERNATE_ID LW6MAP_WEAPON_PLAGUE
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PINK_WEAPON_ALTERNATE_ID LW6MAP_MIN_WEAPON_ID
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PINK_WEAPON_ALTERNATE_ID LW6MAP_MAX_WEAPON_ID

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_RED_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_BY_ID
#define LW6MAP_RULES_MIN_TEAM_PROFILE_RED_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_NONE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_RED_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_RANDOM

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_GREEN_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_BY_ID
#define LW6MAP_RULES_MIN_TEAM_PROFILE_GREEN_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_NONE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_GREEN_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_RANDOM

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_BLUE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_BY_ID
#define LW6MAP_RULES_MIN_TEAM_PROFILE_BLUE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_NONE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_BLUE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_RANDOM

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_YELLOW_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_BY_ID
#define LW6MAP_RULES_MIN_TEAM_PROFILE_YELLOW_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_NONE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_YELLOW_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_RANDOM

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_CYAN_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_BY_ID
#define LW6MAP_RULES_MIN_TEAM_PROFILE_CYAN_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_NONE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_CYAN_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_RANDOM

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_MAGENTA_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_BY_ID
#define LW6MAP_RULES_MIN_TEAM_PROFILE_MAGENTA_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_NONE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_MAGENTA_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_RANDOM

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_ORANGE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_BY_ID
#define LW6MAP_RULES_MIN_TEAM_PROFILE_ORANGE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_NONE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_ORANGE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_RANDOM

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_LIGHTBLUE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_BY_ID
#define LW6MAP_RULES_MIN_TEAM_PROFILE_LIGHTBLUE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_NONE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_LIGHTBLUE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_RANDOM

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PURPLE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_BY_ID
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PURPLE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_NONE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PURPLE_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_RANDOM

#define LW6MAP_RULES_DEFAULT_TEAM_PROFILE_PINK_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_BY_ID
#define LW6MAP_RULES_MIN_TEAM_PROFILE_PINK_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_NONE
#define LW6MAP_RULES_MAX_TEAM_PROFILE_PINK_WEAPON_MODE LW6MAP_RULES_TEAM_PROFILE_WEAPON_MODE_RANDOM

#define LW6MAP_RULES_DEFAULT_WEAPON_DURATION 3
#define LW6MAP_RULES_MIN_WEAPON_DURATION 1
#define LW6MAP_RULES_MAX_WEAPON_DURATION 60

#define LW6MAP_RULES_DEFAULT_WEAPON_CHARGE_DELAY 30
#define LW6MAP_RULES_MIN_WEAPON_CHARGE_DELAY 1
#define LW6MAP_RULES_MAX_WEAPON_CHARGE_DELAY 600

#define LW6MAP_RULES_DEFAULT_WEAPON_CHARGE_MAX 200
#define LW6MAP_RULES_MIN_WEAPON_CHARGE_MAX 100
#define LW6MAP_RULES_MAX_WEAPON_CHARGE_MAX 1000

#define LW6MAP_RULES_DEFAULT_WEAPON_TUNE_BERZERK_POWER 3
#define LW6MAP_RULES_MIN_WEAPON_TUNE_BERZERK_POWER 1
#define LW6MAP_RULES_MAX_WEAPON_TUNE_BERZERK_POWER 100

#define LW6MAP_RULES_DEFAULT_WEAPON_TUNE_TURBO_POWER 3
#define LW6MAP_RULES_MIN_WEAPON_TUNE_TURBO_POWER 1
#define LW6MAP_RULES_MAX_WEAPON_TUNE_TURBO_POWER 10

/**
 * Content of rules.xml stored into a C struct.
 * This structure is used a lot, it needs
 * to be like this for we don't want to parse (even a hash) each
 * time we want a param so we need it in a real C struct.
 * In this structure, it's important, fundamental,
 * that floats are never ever used in map rules.
 * In fact, we need maps to be 100,00 (lots of zeroes) predictable,
 * given some identical user actions. Using floats could lead us
 * to very slight differences (floats are never accurate, especially
 * when you run calculus on different hardwares) which could, with
 * time, become very important. Sort of a "butterfly effect".
 * So well, we use int. Int32 to be exact.
 */
typedef struct lw6map_rules_s
{
  /// total_time parameter, stored as an integer.
  int32_t total_time;
  /// respawn_team parameter, stored as an integer.
  int32_t respawn_team;
  /// respawn_position_mode parameter, stored as an integer.
  int32_t respawn_position_mode;
  /// respawn_delay parameter, stored as an integer.
  int32_t respawn_delay;
  /// moves_per_round parameter, stored as an integer.
  int32_t moves_per_round;
  /// spreads_per_round parameter, stored as an integer.
  int32_t spreads_per_round;
  /// rounds_per_sec parameter, stored as an integer.
  int32_t rounds_per_sec;
  /// fighter_attack parameter, stored as an integer.
  int32_t fighter_attack;
  /// fighter_defense parameter, stored as an integer.
  int32_t fighter_defense;
  /// fighter_new_health parameter, stored as an integer.
  int32_t fighter_new_health;
  /// fighter_regenerate parameter, stored as an integer.
  int32_t fighter_regenerate;
  /// side_attack_factor parameter, stored as an integer.
  int32_t side_attack_factor;
  /// side_defense_factor parameter, stored as an integer.
  int32_t side_defense_factor;
  /// nb_move_tries parameter, stored as an integer.
  int32_t nb_move_tries;
  /// nb_attack_tries parameter, stored as an integer.
  int32_t nb_attack_tries;
  /// nb_defense_tries parameter, stored as an integer.
  int32_t nb_defense_tries;
  /// vertical_move parameter, stored as an integer.
  int32_t vertical_move;
  /// spread_mode parameter, stored as an integer.
  int32_t spread_mode;
  /// single_army_size parameter, stored as an integer.
  int32_t single_army_size;
  /// total_armies_size parameter, stored as an integer.
  int32_t total_armies_size;
  /// max_nb_teams parameter, stored as an integer.
  int32_t max_nb_teams;
  /// max_nb_cursors parameter, stored as an integer.
  int32_t max_nb_cursors;
  /// max_nb_nodes parameter, stored as an integer.
  int32_t max_nb_nodes;
  /// exp parameter, stored as an integer.
  int32_t exp;
  /// highest_team_color_allowed parameter, stored as an integer.
  int32_t highest_team_color_allowed;
  /// highest_weapon_allowed parameter, stored as an integer.
  int32_t highest_weapon_allowed;
  /// x_polarity parameter, stored as an integer.
  int32_t x_polarity;
  /// y_polarity parameter, stored as an integer.
  int32_t y_polarity;
  /// z_polarity parameter, stored as an integer.
  int32_t z_polarity;
  /// max_zone_size parameter, stored as an integer.
  int32_t max_zone_size;
  /// round_delta parameter, stored as an integer.
  int32_t round_delta;
  /// max_round_delta parameter, stored as an integer.
  int32_t max_round_delta;
  /// max_cursor_pot parameter, stored as an integer.
  int32_t max_cursor_pot;
  /// cursor_pot_init parameter, stored as an integer.
  int32_t cursor_pot_init;
  /// max_cursor_pot_offset parameter, stored as an integer.
  int32_t max_cursor_pot_offset;
  /// start_x parameters, stored as a per team integer.
  int32_t start_x[LW6MAP_MAX_NB_TEAMS];
  /// start_y parameters, stored as a per team integer.
  int32_t start_y[LW6MAP_MAX_NB_TEAMS];
  /// start_position_mode parameter, stored as an integer.
  int32_t start_position_mode;
  /// color_conflict_mode parameter, stored as an integer.
  int32_t color_conflict_mode;
  /// spread_thread parameter, stored as an integer.
  int32_t spread_thread;
  /// glue_power parameter, stored as an integer.
  int32_t glue_power;
  /// boost_power parameter, stored as an integer.
  int32_t boost_power;
  /// danger_power parameter, stored as an integer.
  int32_t danger_power;
  /// medicine_power parameter, stored as an integer.
  int32_t medicine_power;
  /// frags_mode parameter, stored as an integer.
  int32_t frags_mode;
  /// frags_to_distribute parameter, stored as an integer.
  int32_t frags_to_distribute;
  /// frags_fade_out parameter, stored as an integer.
  int32_t frags_fade_out;
  /// use_team_profiles parameter, stored as an integer.
  int32_t use_team_profiles;
  /// team_profile_aggressive parameters, stored as a per team integer.
  int32_t team_profile_aggressive[LW6MAP_MAX_NB_TEAMS];
  /// team_profile_vulnerable parameters, stored as a per team integer.
  int32_t team_profile_vulnerable[LW6MAP_MAX_NB_TEAMS];
  /// team_profile_mobile parameters, stored as a per team integer.
  int32_t team_profile_mobile[LW6MAP_MAX_NB_TEAMS];
  /// team_profile_fast parameters, stored as a per team integer.
  int32_t team_profile_fast[LW6MAP_MAX_NB_TEAMS];
  /// team_profile_handicap parameters, stored as a per team integer.
  int32_t team_profile_handicap[LW6MAP_MAX_NB_TEAMS];
  /// team_profile_weapon_id parameters, stored as a per team integer.
  int32_t team_profile_weapon_id[LW6MAP_MAX_NB_TEAMS];
  /// team_profile_weapon_alternate_id parameters, stored as a per team integer.
  int32_t team_profile_weapon_alternate_id[LW6MAP_MAX_NB_TEAMS];
  /// team_profile_weapon_mode parameters, stored as a per team integer.
  int32_t team_profile_weapon_mode[LW6MAP_MAX_NB_TEAMS];
  /// weapon_duration parameter, stored as an integer.
  int32_t weapon_duration;
  /// weapon_charge_delay parameter, stored as an integer.
  int32_t weapon_charge_delay;
  /// weapon_charge_max parameter, stored as an integer.
  int32_t weapon_charge_max;
  /// weapon_tune_berzerk_power parameter, stored as an integer.
  int32_t weapon_tune_berzerk_power;
  /// weapon_tune_turbo_power parameter, stored as an integer.
  int32_t weapon_tune_turbo_power;
} lw6map_rules_t;

extern const char *LW6MAP_RULES_LIST[];

// Reasonnably, nothing smaller than this is playable
#define LW6MAP_MIN_BODY_WIDTH 8
// Same concept
#define LW6MAP_MIN_BODY_HEIGHT 6
/*
 * Serious limit here, must be < 8191 because of possible
 * oververflow, but recent (!) optimizations even forces
 * to be below 1500x1000. The idea is that too big maps
 * simply put computers to death and prevent smart
 * optimizations such as (but not limited to) putting
 * everything on one big texture in GL mode. I (ufoot) believe
 * if you can't have fun on a 1000x1000 map
 * then your map design is just broken...
 */
#define LW6MAP_MAX_BODY_WIDTH 1500
// height is smaller, on purpose, still those optimisations
#define LW6MAP_MAX_BODY_HEIGHT 1000
// This corresponds to minimalist 16/9 (16*9)
#define LW6MAP_MIN_BODY_SURFACE 144
// 1000x1000, greater than HD 720p (921600)
#define LW6MAP_MAX_BODY_SURFACE 1000000

// yeah sur, 0 depth doesn't make sense
#define LW6MAP_MIN_BODY_DEPTH 1
// can't be too high for perf issues
#define LW6MAP_MAX_BODY_DEPTH 7

// below this, not complex enough
#define LW6MAP_MIN_BODY_VOLUME (LW6MAP_MIN_BODY_SURFACE * LW6MAP_MIN_BODY_DEPTH)
#define LW6MAP_MAX_BODY_VOLUME (LW6MAP_MAX_BODY_SURFACE * LW6MAP_MAX_BODY_DEPTH)

// Theorical limit
#define LW6MAP_MIN_TEXTURE_WIDTH 1
#define LW6MAP_MIN_TEXTURE_HEIGHT 1
// Limited to fit on one OpenGL texture on reasonnable hardware
#define LW6MAP_MAX_TEXTURE_WIDTH 3000
#define LW6MAP_MAX_TEXTURE_HEIGHT 2000

/*
 * Note : the floating points value below should not be written
 * with a tailing "f" so 1.0f should be written 1.0 else quoting
 * macros will not work very well in hlp-reference.
 */
#define LW6MAP_STYLE_DEFAULT_KEEP_RATIO 1
#define LW6MAP_STYLE_DEFAULT_ZOOM 1.0
#define LW6MAP_STYLE_DEFAULT_ZOOM_MIN 0.3
#define LW6MAP_STYLE_DEFAULT_ZOOM_MAX 30.0
#define LW6MAP_STYLE_DEFAULT_X_WRAP 1
#define LW6MAP_STYLE_DEFAULT_Y_WRAP 1
#define LW6MAP_STYLE_DEFAULT_BACKGROUND_STYLE "bubbles"
#define LW6MAP_STYLE_DEFAULT_HUD_STYLE "floating"
#define LW6MAP_STYLE_DEFAULT_MENU_STYLE "cylinder"
#define LW6MAP_STYLE_DEFAULT_VIEW_STYLE "flat"
#define LW6MAP_STYLE_DEFAULT_ANIMATION_DENSITY 1.0
#define LW6MAP_STYLE_DEFAULT_ANIMATION_SPEED 1.0
#define LW6MAP_STYLE_DEFAULT_CURSOR_SIZE 1.0
#define LW6MAP_STYLE_DEFAULT_COLORIZE_CURSOR 1
#define LW6MAP_STYLE_DEFAULT_BLINK_CURSOR 0
#define LW6MAP_STYLE_DEFAULT_HIDDEN_LAYER_ALPHA 0.1
#define LW6MAP_STYLE_DEFAULT_COLORIZE 1
#define LW6MAP_STYLE_DEFAULT_PIXELIZE 0
#define LW6MAP_STYLE_DEFAULT_COLOR_BASE_BG "#000000"
#define LW6MAP_STYLE_DEFAULT_COLOR_BASE_FG "#cccccc"
#define LW6MAP_STYLE_DEFAULT_COLOR_ALTERNATE_BG "#333333"
#define LW6MAP_STYLE_DEFAULT_COLOR_ALTERNATE_FG "#ffffff"
#define LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_ROOT_BG "#000000"
#define LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_ROOT_FG "#cccccc"
#define LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_STUFF_BG "#333333"
#define LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_STUFF_FG "#ffffff"
#define LW6MAP_STYLE_DEFAULT_HUD_COLOR_FRAME_BG "#000000"
#define LW6MAP_STYLE_DEFAULT_HUD_COLOR_FRAME_FG "#cccccc"
#define LW6MAP_STYLE_DEFAULT_HUD_COLOR_TEXT_BG "#333333"
#define LW6MAP_STYLE_DEFAULT_HUD_COLOR_TEXT_FG "#ffffff"
#define LW6MAP_STYLE_DEFAULT_MENU_COLOR_DEFAULT_BG "#333333"
#define LW6MAP_STYLE_DEFAULT_MENU_COLOR_DEFAULT_FG "#ffffff"
#define LW6MAP_STYLE_DEFAULT_MENU_COLOR_SELECTED_BG "#ffffff"
#define LW6MAP_STYLE_DEFAULT_MENU_COLOR_SELECTED_FG "#333333"
#define LW6MAP_STYLE_DEFAULT_MENU_COLOR_DISABLED_BG "#000000"
#define LW6MAP_STYLE_DEFAULT_MENU_COLOR_DISABLED_FG "#cccccc"
#define LW6MAP_STYLE_DEFAULT_VIEW_COLOR_CURSOR_BG "#333333"
#define LW6MAP_STYLE_DEFAULT_VIEW_COLOR_CURSOR_FG "#ffffff"
#define LW6MAP_STYLE_DEFAULT_VIEW_COLOR_MAP_BG "#000000"
#define LW6MAP_STYLE_DEFAULT_VIEW_COLOR_MAP_FG "#cccccc"
#define LW6MAP_STYLE_DEFAULT_SYSTEM_COLOR_BG "#333333"
#define LW6MAP_STYLE_DEFAULT_SYSTEM_COLOR_FG "#ffffff"
#define LW6MAP_STYLE_DEFAULT_TEAM_COLOR_DEAD "#000000"
#define LW6MAP_STYLE_DEFAULT_TEAM_COLOR_RED "#ff0000"
#define LW6MAP_STYLE_DEFAULT_TEAM_COLOR_GREEN "#00ff00"
#define LW6MAP_STYLE_DEFAULT_TEAM_COLOR_BLUE "#0000ff"
#define LW6MAP_STYLE_DEFAULT_TEAM_COLOR_YELLOW "#ffff00"
#define LW6MAP_STYLE_DEFAULT_TEAM_COLOR_CYAN "#00ffff"
#define LW6MAP_STYLE_DEFAULT_TEAM_COLOR_MAGENTA "#ff00ff"
#define LW6MAP_STYLE_DEFAULT_TEAM_COLOR_ORANGE "#ff8800"
#define LW6MAP_STYLE_DEFAULT_TEAM_COLOR_LIGHTBLUE "#88bbff"
#define LW6MAP_STYLE_DEFAULT_TEAM_COLOR_PURPLE "#bb88ff"
#define LW6MAP_STYLE_DEFAULT_TEAM_COLOR_PINK "#ff88bb"
#define LW6MAP_STYLE_DEFAULT_MUSIC_FILE ""
#define LW6MAP_STYLE_DEFAULT_MUSIC_FILTER ""
#define LW6MAP_STYLE_DEFAULT_WAVES 1
/*
 * Hi Tim, this is not to blacklist you, no way! Only this
 * is needed so that your tunes don't get played *in game*
 * but only while navigating in the menus.
 */
#define LW6MAP_STYLE_DEFAULT_MUSIC_EXCLUDE "Chadburn"

#define LW6MAP_NB_TEAM_COLORS LW6MAP_MAX_NB_TEAMS

#define LW6MAP_BUILTIN_DEFAULT_WIDTH 256
#define LW6MAP_BUILTIN_DEFAULT_HEIGHT 128
#define LW6MAP_BUILTIN_DEFAULT_DEPTH 1
#define LW6MAP_BUILTIN_DEFAULT_NOISE_PERCENT 10

typedef enum lw6map_team_color_e
{ LW6MAP_TEAM_COLOR_INVALID = -1,
  /*
   * Yes, 0 is a valid color
   */
  LW6MAP_TEAM_COLOR_RED =
    0, LW6MAP_TEAM_COLOR_GREEN = 1, LW6MAP_TEAM_COLOR_BLUE =
    2, LW6MAP_TEAM_COLOR_YELLOW = 3, LW6MAP_TEAM_COLOR_CYAN =
    4, LW6MAP_TEAM_COLOR_MAGENTA = 5, LW6MAP_TEAM_COLOR_ORANGE =
    6, LW6MAP_TEAM_COLOR_LIGHTBLUE = 7, LW6MAP_TEAM_COLOR_PURPLE =
    8, LW6MAP_TEAM_COLOR_PINK = 9
} lw6map_team_color_t;

#define LW6MAP_TEAMS_NB_PLAYERS 4

#define LW6MAP_TEAMS_DEFAULT_PLAYER1_COLOR LW6DEF_RED
#define LW6MAP_TEAMS_DEFAULT_PLAYER2_COLOR LW6DEF_GREEN
#define LW6MAP_TEAMS_DEFAULT_PLAYER3_COLOR LW6DEF_BLUE
#define LW6MAP_TEAMS_DEFAULT_PLAYER4_COLOR LW6DEF_YELLOW

#define LW6MAP_TEAMS_PLAYER1_INDEX 0
#define LW6MAP_TEAMS_PLAYER2_INDEX 1
#define LW6MAP_TEAMS_PLAYER3_INDEX 2
#define LW6MAP_TEAMS_PLAYER4_INDEX 3

#define LW6MAP_TEAMS_DEFAULT_NB_BOTS 2
#define LW6MAP_TEAMS_MIN_NB_BOTS 0
#define LW6MAP_TEAMS_MAX_NB_BOTS 9

#define LW6MAP_TEAMS_DEFAULT_BOT_SPEED 1.0f

#define LW6MAP_TEAMS_DEFAULT_BOT_IQ 100
#define LW6MAP_TEAMS_MIN_BOT_IQ 0
#define LW6MAP_TEAMS_MAX_BOT_IQ 200

#define LW6MAP_TEAMS_DEFAULT_BOT1_COLOR LW6DEF_GREEN
#define LW6MAP_TEAMS_DEFAULT_BOT2_COLOR LW6DEF_BLUE
#define LW6MAP_TEAMS_DEFAULT_BOT3_COLOR LW6DEF_YELLOW
#define LW6MAP_TEAMS_DEFAULT_BOT4_COLOR LW6DEF_CYAN
#define LW6MAP_TEAMS_DEFAULT_BOT5_COLOR LW6DEF_MAGENTA
#define LW6MAP_TEAMS_DEFAULT_BOT6_COLOR LW6DEF_ORANGE
#define LW6MAP_TEAMS_DEFAULT_BOT7_COLOR LW6DEF_LIGHTBLUE
#define LW6MAP_TEAMS_DEFAULT_BOT8_COLOR LW6DEF_PURPLE
#define LW6MAP_TEAMS_DEFAULT_BOT9_COLOR LW6DEF_PINK

#define LW6MAP_TEAMS_DEFAULT_BOT1_AI "idiot"
#define LW6MAP_TEAMS_DEFAULT_BOT2_AI "idiot"
#define LW6MAP_TEAMS_DEFAULT_BOT3_AI "random"
#define LW6MAP_TEAMS_DEFAULT_BOT4_AI "follow"
#define LW6MAP_TEAMS_DEFAULT_BOT5_AI "random"
#define LW6MAP_TEAMS_DEFAULT_BOT6_AI "follow"
#define LW6MAP_TEAMS_DEFAULT_BOT7_AI "idiot"
#define LW6MAP_TEAMS_DEFAULT_BOT8_AI "idiot"
#define LW6MAP_TEAMS_DEFAULT_BOT9_AI "idiot"

#define LW6MAP_TEAMS_BOT1_INDEX 0
#define LW6MAP_TEAMS_BOT2_INDEX 1
#define LW6MAP_TEAMS_BOT3_INDEX 2
#define LW6MAP_TEAMS_BOT4_INDEX 3
#define LW6MAP_TEAMS_BOT5_INDEX 4
#define LW6MAP_TEAMS_BOT6_INDEX 5
#define LW6MAP_TEAMS_BOT7_INDEX 6
#define LW6MAP_TEAMS_BOT8_INDEX 7
#define LW6MAP_TEAMS_BOT9_INDEX 8

/**
 * Bot information, contains the relevant generic
 * parameters for a bot.
 */
typedef struct lw6map_bot_info_s
{
  /// Team/color the bot is associated to.
  int color;
  /// AI engine used by bot, the name of the backend to load.
  char *ai;
}
lw6map_bot_info_t;

/**
 * Content of teams.xml stored into a C struct.
 */
typedef struct lw6map_teams_s
{
  /// Players colors.
  int player_color[LW6MAP_TEAMS_NB_PLAYERS];
  /// Number of bots.
  int nb_bots;
  /// Bots speed.
  float bot_speed;
  /// Bots IQ (how strong they are)
  int bot_iq;
  /**
   * Per-bot parameters, including their color and
   * the ai engine they use.
   */
  lw6map_bot_info_t bot[LW6MAP_TEAMS_MAX_NB_BOTS];
}
lw6map_teams_t;

/**
 * Content of metadata.xml stored into a C struct.
 */
typedef struct lw6map_metadata_s
{
  /// Title of the map.
  char *title;
  /// Author of the map.
  char *author;
  /// Description of the map.
  char *description;
  /// License of the map (short, like GPLv2+ or GPLv3+).
  char *license;
  /// Exp as stored in the XML file of the map.
  int vanilla_exp;
} lw6map_metadata_t;

/**
 * Local info is for fields which can be exploited locally,
 * but make no sense if transfered to another computer, over
 * the network for instance. This is typically something
 * which will be updated by the ldr module or some other external
 * code, but it's not directly linked to the content of the
 * map itself.
 */
typedef struct lw6map_local_info_s
{
  /// Directory where music files can be loaded.
  char *music_dir;
} lw6map_local_info_t;

/**
 * A layer contains the actual data for a layer.
 */
typedef struct lw6map_layer_s
{
  /// Shape of the layer. Z should be 1, logically.
  lw6sys_whd_t shape;
  /// Raw (byte) data.
  u_int8_t *data;
} lw6map_layer_t;

/**
 * A meta layer is a special layer which contains,
 * for instance, informations such as where there's a
 * special trick like glue.
 */
typedef struct lw6map_meta_layer_s
{
  /// Shape of the metalayer.
  lw6sys_whd_t shape;
  /// Raw (byte) data.
  u_int8_t *data;
} lw6map_meta_layer_t;

/**
 * Logical layers for the map. This is the big collection
 * of bytes arrays containing most of the information,
 * anything loaded from images (JPEG, PNG) from disk and having
 * some logical (and not pure eye candy) meaning.
 */
typedef struct lw6map_body_s
{
  /**
   * Checksum for this map body, we could recalculate it
   * dynamically but it's cached here for convenience and speed.
   */
  int checksum;
  /// Shape of the map, all layers need to be compatible with this.
  lw6sys_whd_t shape;
  /**
   * Layers, layer 0 is the top layer, the one stored
   * in map.png, other layers are layerN.png. Not all
   * layers are defined, just depends on body shape.
   */
  lw6map_layer_t layers[LW6MAP_MAX_BODY_DEPTH];
  /// Informations stored in glue.png.
  lw6map_meta_layer_t glue;
  /// Informations stored in boost.png.
  lw6map_meta_layer_t boost;
  /// Informations stored in danger.png.
  lw6map_meta_layer_t danger;
  /// Informations stored in medicine.png.
  lw6map_meta_layer_t medicine;
  /// Informations stored in one-way-north.png.
  lw6map_meta_layer_t one_way_north;
  /// Informations stored in one-way-east.png.
  lw6map_meta_layer_t one_way_east;
  /// Informations stored in one-way-south.png.
  lw6map_meta_layer_t one_way_south;
  /// Informations stored in one-way-west.png.
  lw6map_meta_layer_t one_way_west;
} lw6map_body_t;

/**
 * This structure simply binds 2 colors together,
 * one being foreground and the other background.
 * There's a good reason to bind those together, indeed
 * foreground and background need to be different
 * enough so that text written in fg over bg is readable,
 * and they need to go together well.
 */
typedef struct lw6map_color_couple_s
{
  /// Foreground color.
  lw6sys_color_8_t fg;
  /// Background color.
  lw6sys_color_8_t bg;
} lw6map_color_couple_t;

/**
 * Texture information, this is a bit different from
 * a layer, since this is RGBA data, plus some meta-informations
 * such as guessed colors.
 */
typedef struct lw6map_texture_s
{
  /// Texture width.
  int w;
  /// Texture height.
  int h;
  /**
   * True if texture has an alpha channel. If it has an alpha
   * channel on disk (for instance, it's a PNG) and if in practice
   * it has nothing else than full opaque 255 alpha values, then
   * this will be set to 0 anyway, the idea is to detect textures
   * that really need the engine to handle transparency.
   */
  int has_alpha;
  /// Color for each pixel.
  lw6sys_color_8_t *data;
  /**
   * Base guessed color couple. This is typically the best
   * or more representative color couple (fg and bg) the
   * program was able to automatically extract from the map.
   */
  lw6map_color_couple_t guessed_color_base;
  /**
   * An alternate color couple which still comes from the
   * map but is a bit different from the base one.
   */
  lw6map_color_couple_t guessed_color_alternate;
} lw6map_texture_t;

/**
 * Contains a cursor texture layer, this is basically a
 * fixed (64x64) sized array of colors.
 */
typedef struct lw6map_cursor_texture_layer_s
{
  /// Color for each pixel.
  lw6sys_color_8_t
    data[LW6MAP_CURSOR_TEXTURE_SIZE][LW6MAP_CURSOR_TEXTURE_SIZE];
} lw6map_cursor_texture_layer_t;

/**
 * A cursor texture. It's divided between a texture
 * that will be colorized depending on the map and another
 * texture which will be colorized depending on the
 * team playing the cursor.
 */
typedef struct lw6map_cursor_texture_s
{
  /// Layer to be colorized using foreground and background colors.
  lw6map_cursor_texture_layer_t fg_bg_layer;
  /// Layer to be colorized using team colors.
  lw6map_cursor_texture_layer_t color_layer;
} lw6map_cursor_texture_t;

/**
 * Holds the complete color set for the game,
 * including all color couples used for background,
 * hud, menu, view, as well as team colors.
 */
typedef struct lw6map_color_set_s
{
  /// Base color couple.
  lw6map_color_couple_t color_base;
  /// Alternate color couple.
  lw6map_color_couple_t color_alternate;
  /// Background color couple for root image.
  lw6map_color_couple_t background_color_root;
  /// Background color couple for drawn stuff.
  lw6map_color_couple_t background_color_stuff;
  /// Hud color couple for frames.
  lw6map_color_couple_t hud_color_frame;
  /// Hud color couple for text.
  lw6map_color_couple_t hud_color_text;
  /// Menu default color couple.
  lw6map_color_couple_t menu_color_default;
  /// Menu color couple for selected items.
  lw6map_color_couple_t menu_color_selected;
  /// Menu color couple for disabled items.
  lw6map_color_couple_t menu_color_disabled;
  /// Map view color couple for cursor.
  lw6map_color_couple_t view_color_cursor;
  /// Map view color couple for map.
  lw6map_color_couple_t view_color_map;
  /// System color couple (log messages).
  lw6map_color_couple_t system_color;
  /// Color to use for dead fighters.
  lw6sys_color_8_t team_color_dead;
  /// Team colors.
  lw6sys_color_8_t team_colors[LW6MAP_NB_TEAM_COLORS];
} lw6map_color_set_t;

/**
 * Content of style.xml stored into a C struct.
 */
typedef struct lw6map_style_s
{
  /// Boolean, wether to keep the map ratio or not.
  int keep_ratio;
  /// Default zoom.
  float zoom;
  /// Min zoom.
  float zoom_min;
  /// Max zoom.
  float zoom_max;
  /// Wether to wrap on X axis.
  int x_wrap;
  /// Wether to wrap on Y axis.
  int y_wrap;
  /// Background style to use (for instance, bubbles).
  char *background_style;
  /// Hud style to use (for instance, floating).
  char *hud_style;
  /// Menu style to use (for instance, cylinder).
  char *menu_style;
  /// View style to use (for instance, flat).
  char *view_style;
  /// How dense animations should be (many or few sprites).
  float animation_density;
  /// How fast animations should be (sprites speed).
  float animation_speed;
  /// Cursor size.
  float cursor_size;
  /// Wether to colorize cursors or not.
  int colorize_cursor;
  /// Wether to make cursors blink or not.
  int blink_cursor;
  /// Alpha value used to represent fighters hidden behind a layer.
  float hidden_layer_alpha;
  /// Wether to use colorization or not.
  int colorize;
  /// Wether to pixelize the map and fighters or not.
  int pixelize;
  /// All colors used by the game.
  lw6map_color_set_t color_set;
  /// Music file to play.
  char *music_file;
  /// Music files to keep.
  char *music_filter;
  /// Music files to exclude.
  char *music_exclude;
  /// Wether to turn on the wave effect or not.
  int waves;
} lw6map_style_t;

/**
 * All parameters in a map, indludes rules, style and teams.
 */
typedef struct lw6map_param_s
{
  /// Content of rules.xml.
  lw6map_rules_t rules;
  /// Content of style.xml.
  lw6map_style_t style;
  /// Content of teams.xml.
  lw6map_teams_t teams;
} lw6map_param_t;

/**
 * This structure contains everything about a level, once
 * it's loaded from disk. It's immutable, it cannot be changed
 * once it's loaded, and does not have any algorithm aware
 * struct, this is just plain raw data, file data transformed
 * into C struct.
 */
typedef struct lw6map_level_s
{
  /**
   * The id of the object, this is non-zero and unique within one run session,
   * incremented at each object creation.
   */
  u_int32_t id;
  /// Metadata (title, copyright, description, ...)
  lw6map_metadata_t metadata;
  /// Informations that depend on the host loading the map.
  lw6map_local_info_t local_info;
  /// All layers (bytes array) forming the map.
  lw6map_body_t body;
  /// Texture used by the map.
  lw6map_texture_t texture;
  /// Cursor texture.
  lw6map_cursor_texture_t cursor_texture;
  /// All map parameters.
  lw6map_param_t param;
} lw6map_level_t;


/*
 * Base used to make conversions between logarithmic
 * and linear scales. Initially used to handle bench
 * which is set by pil and read by ldr.
 */
#define LW6MAP_LOG2LIN_BASE 10

/*
 * Commodity inline setters/getters
 */

static inline void
lw6map_body_set (lw6map_body_t * body, int x, int y, int z, u_int8_t value)
{
  body->layers[z].data[y * body->shape.w + x] = value;
}

static inline u_int8_t
lw6map_body_get (const lw6map_body_t * body, int x, int y, int z)
{
  return body->layers[z].data[y * body->shape.w + x];
}

static inline void
lw6map_layer_set (lw6map_layer_t * layer, int x, int y, u_int8_t value)
{
  layer->data[y * layer->shape.w + x] = value;
}

static inline u_int8_t
lw6map_layer_get (const lw6map_layer_t * layer, int x, int y)
{
  return layer->data[y * layer->shape.w + x];
}

static inline void
lw6map_texture_set (lw6map_texture_t * texture, int x, int y,
		    lw6sys_color_8_t value)
{
  texture->data[y * texture->w + x] = value;
}

static inline lw6sys_color_8_t
lw6map_texture_get (const lw6map_texture_t * texture, int x, int y)
{
  return texture->data[y * texture->w + x];
}

/* map-body.c */
extern void lw6map_body_builtin_custom (lw6map_body_t * body, int w, int h,
					int d, int noise_percent,
					const lw6map_rules_t * rules);
extern void lw6map_body_clear (lw6map_body_t * body);
extern void lw6map_body_fix_checksum (lw6map_body_t * body);
extern int lw6map_body_check_and_fix_holes (lw6map_body_t * body,
					    const lw6map_rules_t * rules);
extern int lw6map_body_coord_from_texture (const lw6map_level_t * level,
					   int *body_x, int *body_y,
					   int texture_x, int texture_y);
extern u_int8_t lw6map_body_get_with_texture_coord (const lw6map_level_t *
						    level,
						    int texture_x,
						    int texture_y, int z);

/* map-color.c */
extern void lw6map_color_invert (lw6map_color_couple_t * color);
extern int lw6map_color_is_same (const lw6map_color_couple_t * color1,
				 const lw6map_color_couple_t * color2);
extern char *lw6map_team_color_index_to_key (int index);
extern int lw6map_team_color_key_to_index (const char *key);
extern char *lw6map_team_color_index_to_label (int index);
static inline int
lw6map_team_color_is_valid (int team_color)
{
  return (team_color >= 0 && team_color < LW6MAP_MAX_NB_TEAMS);
}

/* map-coords.c */
extern void lw6map_coords_fix_xy (const lw6map_rules_t * rules,
				  const lw6sys_whd_t * shape, int *x, int *y);
extern void lw6map_coords_fix_z (const lw6map_rules_t * rules,
				 const lw6sys_whd_t * shape, int *z);

/* map-cursortexture.c */
extern void lw6map_cursor_texture_layer_set (lw6map_cursor_texture_layer_t *
					     cursor_texture, int x, int y,
					     lw6sys_color_8_t color);
extern lw6sys_color_8_t
lw6map_cursor_texture_layer_get (const lw6map_cursor_texture_layer_t *
				 cursor_texture, int x, int y);
extern void lw6map_cursor_texture_clear (lw6map_cursor_texture_t *
					 cursor_texture);
extern void lw6map_cursor_texture_builtin (lw6map_cursor_texture_t *
					   cursor_texture);

/* map-dup.c */
extern lw6map_level_t *lw6map_dup (lw6map_level_t * source,
				   lw6sys_progress_t * progress);

/* map-exp.c */
extern int lw6map_exp_get_highest_team_color_allowed (int exp);
extern int lw6map_exp_get_highest_weapon_allowed (int exp);
extern int lw6map_exp_is_team_color_allowed (const lw6map_rules_t * rules,
					     int team_color_id);
extern int lw6map_exp_is_weapon_allowed (const lw6map_rules_t * rules,
					 int weapon_id);
extern int lw6map_exp_get_unlocked_team_color (int exp);
extern int lw6map_exp_get_unlocked_weapon (int exp);

/* map-hexa.c */
extern char *lw6map_to_hexa (const lw6map_level_t * level);
extern lw6map_level_t *lw6map_from_hexa (const char *hexa);

/* map-layer.c */
extern void lw6map_layer_builtin_custom (lw6map_layer_t * layer, int w,
					 int h);
extern void lw6map_layer_clear (lw6map_layer_t * layer);

/* map-level.c */
extern lw6map_level_t *lw6map_new ();
extern lw6map_level_t *lw6map_builtin_defaults ();
extern lw6map_level_t *lw6map_builtin_scale (int percent_factor);
extern lw6map_level_t *lw6map_builtin_custom (int w, int h, int d,
					      int noise_percent);
extern void lw6map_free (lw6map_level_t * level);
extern int lw6map_memory_footprint (const lw6map_level_t * level);
extern char *lw6map_repr (const lw6map_level_t * level);
extern int lw6map_is_same (const lw6map_level_t * level_a,
			   const lw6map_level_t * level_b);
extern const char *lw6map_get_title (const lw6map_level_t * level);
extern int lw6map_get_max_nb_colors (const lw6map_level_t * level);
extern int lw6map_get_max_nb_cursors (const lw6map_level_t * level);
extern int lw6map_get_max_nb_nodes (const lw6map_level_t * level);

/* map-localinfo.c */
extern int lw6map_local_info_set_music_dir (lw6map_local_info_t *
					    local_info,
					    const char *music_dir);
extern void lw6map_local_info_clear (lw6map_local_info_t * local_info);

/* map-metadata.c */
extern void lw6map_metadata_defaults (lw6map_metadata_t * metadata);
extern void lw6map_metadata_clear (lw6map_metadata_t * metadata);
extern int lw6map_metadata_is_same (const lw6map_metadata_t * metadata_a,
				    const lw6map_metadata_t * metadata_b);

/* map-metalayer.c */
extern void lw6map_meta_layer_set (lw6map_meta_layer_t * meta_layer, int x,
				   int y, u_int8_t value);
extern u_int8_t lw6map_meta_layer_get (const lw6map_meta_layer_t * meta_layer,
				       int x, int y);
extern void lw6map_meta_layer_clear (lw6map_meta_layer_t * meta_layer);
extern int lw6map_meta_layer_builtin_custom (lw6map_meta_layer_t * meta_layer,
					     int w, int h, int analog,
					     int noise_percent, int seed);

/* map-rules.c */
extern void lw6map_rules_zero (lw6map_rules_t * rules);
extern void lw6map_rules_defaults (lw6map_rules_t * rules);
extern void lw6map_rules_copy (lw6map_rules_t * dst,
			       const lw6map_rules_t * src);
extern void lw6map_rules_update_checksum (const lw6map_rules_t * rules,
					  u_int32_t * checksum);
extern int32_t lw6map_rules_get_default (const char *key);
extern int32_t lw6map_rules_get_min (const char *key);
extern int32_t lw6map_rules_get_max (const char *key);
extern int32_t lw6map_rules_get_int (const lw6map_rules_t * rules,
				     const char *key);
extern int lw6map_rules_set_int (lw6map_rules_t * rules, const char *key,
				 int32_t value);
extern int lw6map_rules_get_bool (const lw6map_rules_t * rules,
				  const char *key);
extern int lw6map_rules_set_bool (lw6map_rules_t * rules, const char *key,
				  int value);
extern void lw6map_rules_clear (lw6map_rules_t * rules);
extern int lw6map_rules_is_same (const lw6map_rules_t * rules_a,
				 const lw6map_rules_t * rules_b);
extern int lw6map_rules_sanity_check (const lw6map_rules_t * rules);

/* map-param.c */
extern void lw6map_param_zero (lw6map_param_t * param);
extern void lw6map_param_defaults (lw6map_param_t * param);
extern void lw6map_param_clear (lw6map_param_t * param);
extern void lw6map_param_copy (lw6map_param_t * dst,
			       const lw6map_param_t * src);
extern int lw6map_param_set (lw6map_param_t * param, const char *key,
			     const char *value);
extern char *lw6map_param_get (const lw6map_param_t * param, const char *key);
extern int lw6map_param_is_same (const lw6map_param_t * param_a,
				 const lw6map_param_t * param_b);

/* map-style.c */
extern void lw6map_style_zero (lw6map_style_t * style);
extern void lw6map_style_defaults (lw6map_style_t * style);
extern void lw6map_style_clear (lw6map_style_t * style);
extern void lw6map_style_copy (lw6map_style_t * dst,
			       const lw6map_style_t * src);
extern int lw6map_style_set (lw6map_style_t * style, const char *key,
			     const char *value);
extern char *lw6map_style_get (const lw6map_style_t * style, const char *key);
extern char *lw6map_style_get_default (const char *key);
extern int lw6map_color_set_is_same (const lw6map_color_set_t * color_set_a,
				     const lw6map_color_set_t * color_set_b);
extern int lw6map_style_is_same (const lw6map_style_t * style_a,
				 const lw6map_style_t * style_b);

/* map-teams.c */
extern void lw6map_teams_zero (lw6map_teams_t * teams);
extern void lw6map_teams_defaults (lw6map_teams_t * teams);
extern void lw6map_teams_clear (lw6map_teams_t * teams);
extern void lw6map_teams_copy (lw6map_teams_t * dst,
			       const lw6map_teams_t * src);
extern int lw6map_teams_set (lw6map_teams_t * teams, const char *key,
			     const char *value);
extern char *lw6map_teams_get (const lw6map_teams_t * teams, const char *key);
extern char *lw6map_teams_get_default (const char *key);
extern int lw6map_teams_is_same (const lw6map_teams_t * teams_a,
				 const lw6map_teams_t * teams_b);

/* map-test.c */
extern int lw6map_test_register (int mode);
extern int lw6map_test_run (int mode);

/* map-texture.c */
extern int lw6map_texture_from_body (lw6map_texture_t * texture,
				     const lw6map_body_t * body,
				     const lw6map_color_couple_t * color);
extern void lw6map_texture_clear (lw6map_texture_t * texture);
extern int lw6map_texture_coord_from_body (const lw6map_level_t * level,
					   int *texture_x, int *texture_y,
					   int body_x, int body_y);
extern lw6sys_color_8_t lw6map_texture_get_with_body_coord (const
							    lw6map_level_t *
							    level, int body_x,
							    int body_y);
extern int lw6map_texture_has_alpha (lw6map_texture_t * texture);

/* map-weapon.c */
extern char *lw6map_weapon_index_to_key (int index);
extern int lw6map_weapon_key_to_index (const char *key);
extern char *lw6map_weapon_index_to_label (int index);
static inline int
lw6map_weapon_is_valid (int weapon)
{
  return (weapon >= 0 && weapon <= LW6MAP_MAX_WEAPON_ID);
}

#endif
