#!/bin/sh
#$Id: check_nrg.sh.in,v 1.9 2003/10/06 04:04:05 rocky Exp $

if test -n "-L/usr/local/lib -lvcdinfo -liso9660 -lcdio -lm  " ; then
  vcd_opt='--no-vcd'
fi

if test -z $srcdir ; then
  srcdir=`pwd`
fi

. ${srcdir}/check_common_fn

if test ! -x ../src/cd-info ; then
  exit 77
fi

BASE=`basename $0 .sh`
fname=videocd

test_cdinfo "--quiet --nrg-file ${srcdir}/${fname}.nrg $vcd_opt --iso9660 " \
  ${fname}.dump ${srcdir}/${fname}.right
RC=$?
check_result $RC 'cd-info NRG test 1'

BASE=`basename $0 .sh`
nrg_file=${srcdir}/monvoisin.nrg

if test -f  $nrg_file ; then
  test_cdinfo "-q --nrg-file $nrg_file $vcd_opt --iso9660 " \
    monvoisin.dump ${srcdir}/monvoisin.right
  RC=$?
  check_result $RC 'cd-info NRG test 2'
else 
  echo "Don't see NRG file ${nrg_file}. Test skipped."
  exit 0
fi

nrg_file=${srcdir}/svcdgs.nrg
if test -f  $nrg_file ; then
  test_cdinfo "-q --nrg-file $nrg_file $vcd_opt --iso9660" \
    svcdgs.dump ${srcdir}/svcdgs.right
  RC=$?
  check_result $RC 'cd-info NRG test 3'
  
  exit $RC
else 
  echo "Don't see NRG file ${nrg_file}. Test skipped."
  exit $SKIP_TEST_EXITCODE
fi

#;;; Local Variables: ***
#;;; mode:shell-script ***
#;;; eval: (sh-set-shell "bash") ***
#;;; End: ***
