/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.kawa.models.Paintable;
import gnu.kawa.models.Viewable;
import gnu.kawa.swingviews.SwingDisplay;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import kawa.PaintableView;
import kawa.ReplPane;

class ReplEditorKit
extends StyledEditorKit {
    ViewFactory styledFactory;
    ViewFactory factory;
    final ReplPane pane;

    public ReplEditorKit(final ReplPane replPane) {
        this.pane = replPane;
        this.styledFactory = super.getViewFactory();
        this.factory = new ViewFactory(){

            public View create(Element element) {
                String string = element.getName();
                if (string == "Viewable") {
                    return new ComponentView(element){

                        protected Component createComponent() {
                            Component component;
                            AttributeSet attributeSet = this.getElement().getAttributes();
                            JPanel jPanel = new JPanel();
                            Viewable viewable = (Viewable)attributeSet.getAttribute(ReplPane.ViewableAttribute);
                            viewable.makeView(SwingDisplay.getInstance(), jPanel);
                            if (jPanel.getComponentCount() == 1) {
                                component = jPanel.getComponent(0);
                                jPanel.removeAll();
                            } else {
                                jPanel.setBackground(replPane.getBackground());
                                component = jPanel;
                            }
                            return component;
                        }
                    };
                }
                if (string == "Paintable") {
                    AttributeSet attributeSet = element.getAttributes();
                    return new PaintableView(element, (Paintable)attributeSet.getAttribute(ReplPane.PaintableAttribute));
                }
                return ReplEditorKit.this.styledFactory.create(element);
            }
        };
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

