/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolClass;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import java.io.DataOutputStream;
import java.io.IOException;

public class ExceptionsAttr
extends Attribute {
    ClassType[] exceptions;
    short[] exception_table;

    public ExceptionsAttr(Method method) {
        super("Exceptions");
        this.addToFrontOf(method);
    }

    public void setExceptions(short[] sArray, ClassType classType) {
        this.exception_table = sArray;
        this.exceptions = new ClassType[sArray.length];
        ConstantPool constantPool = classType.getConstants();
        for (int i = sArray.length - 1; i >= 0; --i) {
            this.exceptions[i] = (ClassType)((CpoolClass)constantPool.getPoolEntry(sArray[i])).getClassType();
        }
    }

    public void setExceptions(ClassType[] classTypeArray) {
        this.exceptions = classTypeArray;
    }

    public void assignConstants(ClassType classType) {
        super.assignConstants(classType);
        ConstantPool constantPool = classType.getConstants();
        int n = this.exceptions.length;
        this.exception_table = new short[n];
        for (int i = n - 1; i >= 0; --i) {
            this.exception_table[i] = (short)constantPool.addClass((ObjectType)this.exceptions[i]).index;
        }
    }

    public final int getLength() {
        return 2 + 2 * (this.exceptions == null ? 0 : this.exceptions.length);
    }

    public final ClassType[] getExceptions() {
        return this.exceptions;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n = this.exceptions.length;
        dataOutputStream.writeShort(n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeShort(this.exception_table[i]);
        }
    }

    public void print(ClassTypeWriter classTypeWriter) {
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", count: ");
        int n = this.exceptions.length;
        classTypeWriter.println(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.exception_table[i] & 0xFFFF;
            classTypeWriter.print("  ");
            classTypeWriter.printOptionalIndex(n2);
            classTypeWriter.printConstantTersely(n2, 7);
            classTypeWriter.println();
        }
    }
}

