/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.ImageLoader;
import gnu.jel.Library;
import gnu.jel.OP;
import gnu.jel.OPbinary;
import gnu.jel.OPcall;
import gnu.jel.OPcondtnl;
import gnu.jel.OPload;
import gnu.jel.OPunary;
import java.io.PrintStream;
import java.lang.constant.Constable;
import java.util.Stack;
import junit.framework.TestCase;

public class TestingUtils
extends TestCase {
    public TestingUtils(String name) {
        super(name);
    }

    protected static void simError(String expr, Class<?> fixType, Library lib, int errcol, PrintStream o) throws Exception {
        if (o != null) {
            o.print("*** : \"");
            o.print(expr);
            o.println('\"');
        }
        CompilationException ce = null;
        try {
            OP oP = Evaluator.parse(expr, lib, fixType);
        }
        catch (CompilationException e) {
            ce = e;
        }
        TestingUtils.assertTrue("No error detected, but should be", ce != null);
        int column = ce.getColumn();
        if (o != null) {
            o.print("       ");
            for (int i = 0; i < column - 1; ++i) {
                o.print(' ');
            }
            o.println('^');
            o.print("MESSAGE: ");
            o.println(ce.getMessage());
        }
        TestingUtils.assertEquals("Error column does not match expected", errcol, ce.getColumn());
    }

    protected static void simFullLogic(String expr, int bits, Library lib, PrintStream o, boolean showcases) throws Throwable {
        int cases = 1 << bits;
        if (o != null) {
            o.print("*** : FULL LOGIC TEST \"");
            o.print(expr);
            o.println("\" . ( " + cases + " cases ).");
        }
        boolean[] vars = new boolean[bits];
        boolean testOK = true;
        for (int ccase = 0; ccase < cases && testOK; ++ccase) {
            for (int i = 0; i < bits; ++i) {
                vars[i] = (ccase >>> i & 1) > 0;
            }
            StringBuffer cexpr = new StringBuffer();
            for (int i = 0; i < expr.length(); ++i) {
                char currchar = expr.charAt(i);
                if (currchar == '_') {
                    int varnum;
                    if (vars[varnum = (currchar = expr.charAt(++i)) - 97]) {
                        cexpr.append("true ");
                        continue;
                    }
                    cexpr.append("false");
                    continue;
                }
                cexpr.append(currchar);
            }
            OP op = null;
            try {
                op = Evaluator.parse(cexpr.toString(), lib, null);
            }
            catch (CompilationException ce) {
                if (o != null) {
                    o.print("--- COMPILATION ERROR :");
                    o.println(ce.getMessage());
                    o.print("                       ");
                    o.println(cexpr.toString());
                    int column = ce.getColumn();
                    for (int i = 0; i < column + 23 - 1; ++i) {
                        System.err.print(' ');
                    }
                    o.println('^');
                    o.println("Unexpected syntax error on supposingly correct expression.");
                }
                throw ce;
            }
            Object result = null;
            for (int iteration = 0; iteration < 2; ++iteration) {
                Object result1 = null;
                try {
                    byte[] image = Evaluator.getImage(op);
                    CompiledExpression expr_c = (CompiledExpression)ImageLoader.load(image).newInstance();
                    for (int acounter = 0; acounter < 20; ++acounter) {
                        result1 = expr_c.evaluate(null);
                    }
                }
                catch (Throwable e) {
                    if (o != null) {
                        o.println(cexpr.toString());
                        o.println("Exception emerged during compilation/evaluation.");
                        o.print("      ");
                        e.printStackTrace();
                    }
                    throw e;
                }
                if (result != null) {
                    TestingUtils.assertEquals("Interpretation and compilation give different reults", result, result1);
                }
                result = result1;
                if (iteration != 0) continue;
                try {
                    op = new OPload(op, op.eval());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!showcases || o == null) continue;
            o.print(cexpr.toString());
            o.print(" == ");
            o.println(result.toString());
        }
        TestingUtils.assertTrue(true);
    }

    protected static void simExpression(String expr, Object tobe, Class<?> fixType, Object[] runtimeParameters, Library lib, PrintStream o) throws Throwable {
        boolean voideval = false;
        if (tobe == Void.TYPE) {
            tobe = null;
            voideval = true;
        }
        if (o != null) {
            o.print("*** : \"");
            o.print(expr);
            if (tobe != null) {
                o.print("\" = ");
                if (tobe == Void.TYPE) {
                    o.println("[VOID]");
                } else {
                    o.println(tobe);
                }
            } else {
                o.println("\"   Should throw an exception at run time.");
            }
        }
        OP op = null;
        try {
            op = Evaluator.parse(expr, lib, fixType);
        }
        catch (CompilationException ce) {
            if (o != null) {
                o.print("--- COMPILATION ERROR :");
                o.println(ce.getMessage());
                o.print("                       ");
                o.println(expr);
                int column = ce.getColumn();
                for (int i = 0; i < column + 23 - 1; ++i) {
                    System.err.print(' ');
                }
                o.println('^');
                o.println("Unexpected syntax error on supposingly correct expression.");
            }
            throw ce;
        }
        for (int iteration = 0; iteration < 2; ++iteration) {
            if (o != null) {
                String message = "" + iteration + " |" + TestingUtils.toStr(op);
                o.print(message);
                for (int k = message.length(); k < 59; ++k) {
                    o.print(' ');
                }
            }
            Object result = null;
            Class<?> compile_type = null;
            try {
                byte[] image = Evaluator.getImage(op);
                CompiledExpression expr_c = (CompiledExpression)ImageLoader.load(image).newInstance();
                compile_type = expr_c.getTypeC();
                for (int acounter = 0; acounter < 20; ++acounter) {
                    result = expr_c.evaluate(runtimeParameters);
                }
            }
            catch (Throwable e) {
                if (tobe == null && !voideval) {
                    if (o != null) {
                        o.println("EXPECTED EXCEPTION.");
                        o.print("      ");
                        o.println(e.getMessage());
                    }
                }
                o.println("Exception emerged during compilation/evaluation.");
                o.print("      ");
                e.printStackTrace();
                throw e;
            }
            if (tobe != null) {
                TestingUtils.assertNotNull("NO RESULT", result);
                if (o != null) {
                    o.print(" =");
                    o.print(result);
                }
                TestingUtils.assertEquals(tobe, result);
                if (!compile_type.isInstance(result)) {
                    if (o != null) {
                        o.println("");
                        o.println("WRONG COMPILE-TYPE !!!");
                    }
                    TestingUtils.assertTrue("Wrong type of function result.", false);
                } else if (o != null) {
                    o.print("[!ETM got=\"" + result.getClass() + "\" expected=\"" + compile_type + "\"]");
                }
                if (o != null) {
                    o.println("");
                }
            } else {
                if (voideval) {
                    TestingUtils.assertEquals(compile_type, Class.forName("java.lang.Void"));
                } else {
                    TestingUtils.assertNull(result);
                }
                if (o != null) {
                    if (result != null) {
                        o.println(" =" + result.toString());
                    } else {
                        o.println("NO RESULT");
                    }
                }
            }
            if (iteration != 0) continue;
            try {
                op = new OPload(op, op.eval());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String toStr(OP o) {
        if (o instanceof OPload) {
            OPload op = (OPload)o;
            if (op.resID == 8) {
                return "\"" + op.what + "\"";
            }
            return op.what.toString() + (op.resID > 9 ? (char)'L' : "ZBCSIJFDLV".charAt(op.resID));
        }
        if (o instanceof OPbinary) {
            String[] opSymbols = new String[]{"+", "-", "*", "/", "%", "&", "|", "^", "==", "!=", "<", ">=", ">", "<=", "<<", ">>", ">>>", "&&", "||", "{}", ".+."};
            OPbinary op = (OPbinary)o;
            return TestingUtils.toStr(op.chi[0]) + opSymbols[op.code] + TestingUtils.toStr(op.chi[1]);
        }
        if (o instanceof OPunary) {
            String[] opSymbols = new String[]{"--", "~", "!", "<RET>", "(Z)", "(B)", "(C)", "(S)", "(I)", "(J)", "(F)", "(D)", "(L)", "(POP)", "->TSB", "->STR"};
            OPunary op = (OPunary)o;
            return opSymbols[op.code] + TestingUtils.toStr(op.chi[0]);
        }
        if (o instanceof OPcall) {
            OPcall op = (OPcall)o;
            if (op.m == null) {
                return "{" + op.nplv + "}";
            }
            StringBuffer res = new StringBuffer(op.m.getName());
            res.append('(');
            for (int i = 0; i < op.chi.length; ++i) {
                if (i > 0) {
                    res.append(",");
                }
                res.append(TestingUtils.toStr(op.chi[i]));
            }
            res.append(')');
            return res.toString();
        }
        if (o instanceof OPcondtnl) {
            OPcondtnl op = (OPcondtnl)o;
            StringBuffer res = new StringBuffer();
            if (op.chi[1] != null) {
                res.append('(');
            }
            res.append(TestingUtils.toStr(op.chi[0]));
            if (op.chi[1] != null) {
                res.append('?');
                res.append(TestingUtils.toStr(op.chi[1]));
                res.append(':');
                res.append(TestingUtils.toStr(op.chi[2]));
                res.append(')');
            }
            return res.toString();
        }
        return "<<<<<OP TYPE NOT IDENTIFIED>>>>";
    }

    protected static void testUnaryPrimitive(int code, int npbc, Library lib, Object[] context, long resVal, PrintStream o, String[] prefixes, String[] suffixes) throws Throwable {
        String[] typeNames = new String[]{"Boolean", "Byte", "Character", "Short", "Integer", "Long", "Float", "Double"};
        String[] opSymbols = new String[]{"-", "~", "!"};
        Object[] typeConstants = new Object[]{new Boolean(true), new Byte(1), new Character('\u0001'), new Short(1), new Integer(1), new Long(1L), new Float(1.0f), new Double(1.0)};
        int npbcActual = 0;
        for (int i = 0; i < 8; ++i) {
            int resID = -1;
            try {
                Stack<OP> paramOPs = new Stack<OP>();
                paramOPs.push(new OPload(typeConstants[i]));
                paramOPs.push(new OPunary(paramOPs, code));
                resID = paramOPs.peek().resID;
                ++npbcActual;
            }
            catch (CompilationException paramOPs) {
                // empty catch block
            }
            Constable res = null;
            if (resID >= 0) {
                switch (resID) {
                    case 0: {
                        res = new Boolean(resVal > 0L);
                        break;
                    }
                    case 1: {
                        res = new Byte((byte)resVal);
                        break;
                    }
                    case 2: {
                        res = new Character((char)resVal);
                        break;
                    }
                    case 3: {
                        res = new Short((short)resVal);
                        break;
                    }
                    case 4: {
                        res = new Integer((int)resVal);
                        break;
                    }
                    case 5: {
                        res = new Long(resVal);
                        break;
                    }
                    case 6: {
                        res = new Float(resVal);
                        break;
                    }
                    case 7: {
                        res = new Double(resVal);
                        break;
                    }
                    default: {
                        TestingUtils.assertTrue("The result of unary operation is not primitive", false);
                    }
                }
            }
            for (int k = 0; k < prefixes.length; ++k) {
                for (int m = k; m < prefixes.length; ++m) {
                    String op1 = prefixes[k] + typeNames[i] + suffixes[k];
                    String expr = opSymbols[code] + op1;
                    if (res != null) {
                        TestingUtils.simExpression(expr, res, null, context, lib, o);
                        continue;
                    }
                    TestingUtils.simError(expr, null, lib, 1, o);
                }
            }
        }
        if (o != null) {
            o.print("*=*=*= : the total number of successful operations " + npbcActual);
        }
        TestingUtils.assertEquals(npbc, npbcActual);
    }

    protected static void testBinaryPrimitive(int code, int npbc, Library lib, Object[] context, int resVal, PrintStream o, String[] prefixes, String[] suffixes) throws Throwable {
        String[] typeNames = new String[]{"Boolean", "Byte", "Character", "Short", "Integer", "Long", "Float", "Double"};
        String[] opSymbols = new String[]{"+", "-", "*", "/", "%", "&", "|", "^", "==", "!=", "<", ">=", ">", "<=", "<<", ">>", ">>>", "&&", "||", "{}", ".+."};
        Object[] typeConstants = new Object[]{new Boolean(true), new Byte(1), new Character('\u0001'), new Short(1), new Integer(1), new Long(1L), new Float(1.0f), new Double(1.0)};
        int npbcActual = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int resID = -1;
                try {
                    Stack<OP> paramOPs = new Stack<OP>();
                    paramOPs.push(new OPload(typeConstants[i]));
                    paramOPs.push(new OPload(typeConstants[j]));
                    paramOPs.push(new OPbinary(paramOPs, code));
                    resID = paramOPs.peek().resID;
                    ++npbcActual;
                }
                catch (CompilationException paramOPs) {
                    // empty catch block
                }
                Constable res = null;
                if (resID >= 0) {
                    switch (resID) {
                        case 0: {
                            res = new Boolean(resVal > 0);
                            break;
                        }
                        case 1: {
                            res = new Byte((byte)resVal);
                            break;
                        }
                        case 2: {
                            res = new Character((char)resVal);
                            break;
                        }
                        case 3: {
                            res = new Short((short)resVal);
                            break;
                        }
                        case 4: {
                            res = new Integer(resVal);
                            break;
                        }
                        case 5: {
                            res = new Long(resVal);
                            break;
                        }
                        case 6: {
                            res = new Float(resVal);
                            break;
                        }
                        case 7: {
                            res = new Double(resVal);
                            break;
                        }
                        default: {
                            TestingUtils.assertTrue("The result of binary operation is not primitive", false);
                        }
                    }
                }
                for (int k = 0; k < prefixes.length; ++k) {
                    for (int m = k; m < prefixes.length; ++m) {
                        String op1 = prefixes[k] + typeNames[i] + suffixes[k];
                        String expr = op1 + opSymbols[code] + prefixes[m] + typeNames[j] + suffixes[m];
                        if (res != null) {
                            TestingUtils.simExpression(expr, res, null, context, lib, o);
                            continue;
                        }
                        TestingUtils.simError(expr, null, lib, op1.length() + 1, o);
                    }
                }
            }
        }
        if (o != null) {
            o.print("*=*=*= : the total number of successful operations " + npbcActual);
        }
        TestingUtils.assertEquals(npbc, npbcActual);
    }
}

