/*-------------------------------------------------------------------------*/
/* GNU Prolog                                                              */
/*                                                                         */
/* Part  : Prolog engine                                                   */
/* File  : mem_alloc.c                                                     */
/* Descr.: memory allocator                                                */
/* Author: Daniel Diaz                                                     */
/*                                                                         */
/* Copyright (C) 1999 Daniel Diaz                                          */
/*                                                                         */
/* GNU Prolog is free software; you can redistribute it and/or modify it   */
/* under the terms of the GNU General Public License as published by the   */
/* Free Software Foundation; either version 2, or any later version.       */
/*                                                                         */
/* GNU Prolog is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of              */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        */
/* General Public License for more details.                                */
/*                                                                         */
/* You should have received a copy of the GNU General Public License along */
/* with this program; if not, write to the Free Software Foundation, Inc.  */
/* 59 Temple Place - Suite 330, Boston, MA 02111, USA.                     */
/*-------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------*/
/* If needed for some machine: redefine here malloc/calloc/realloc/free by */
/* inserting an appropriate file.                                          */
/* This file is included first because dl_malloc.c cannot be compiled after*/
/* the inclusion of string.h with egcs-1.1.2 release.                      */
/*-------------------------------------------------------------------------*/

#ifdef M_ix86_linux

#undef  HAVE_MMAP
#define HAVE_MMAP 0                      /* do not use mmap for big blocks */

#include "dl_malloc.c"

#endif



#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "engine_pl.h"


/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

#define ERR_ALLOC_FAULT            "Memory allocation fault (%s) in %s:%d"




/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/

/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/



/*-------------------------------------------------------------------------*/
/* MALLOC_CHECK                                                            */
/*                                                                         */
/*-------------------------------------------------------------------------*/
char *Malloc_Check(unsigned size,char *src_file,int src_line)

{
 char *m=malloc(size);

 if (m==NULL)
     Fatal_Error(ERR_ALLOC_FAULT,"malloc",src_file,src_line);

 return m;
}




/*-------------------------------------------------------------------------*/
/* CALLOC_CHECK                                                            */
/*                                                                         */
/*-------------------------------------------------------------------------*/
char *Calloc_Check(unsigned nb,unsigned size,char *src_file,int src_line)

{
 char *m=calloc(nb,size);

 if (m==NULL)
     Fatal_Error(ERR_ALLOC_FAULT,"calloc",src_file,src_line);

 return m;
}




/*-------------------------------------------------------------------------*/
/* REALLOC_CHECK                                                           */
/*                                                                         */
/*-------------------------------------------------------------------------*/
char *Realloc_Check(char *ptr,unsigned size,char *src_file,int src_line)

{
 char *m=realloc(ptr,size);

 if (m==NULL)
     Fatal_Error(ERR_ALLOC_FAULT,"realloc",src_file,src_line);

 return m;
}




/*-------------------------------------------------------------------------*/
/* STRDUP_CHECK                                                            */
/*                                                                         */
/*-------------------------------------------------------------------------*/
char *Strdup_Check(char *str,char *src_file,int src_line)

{
 char *s=strdup(str);

 if (s==NULL)
     Fatal_Error(ERR_ALLOC_FAULT,"strdup",src_file,src_line);

 return s;
}
