/* Copyright (C) 2022-2024 Free Software Foundation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses>.  */


package org.gprofng.mpmt.filter;

import org.gprofng.analyzer.AnEnvironment;
import org.gprofng.mpmt.AnLocale;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/**
 * @author thp
 */
public class CustomPanel extends JPanel {
  private CustomFilterDialog customFilterDialog;
  private CustomEditPanel customEditPanel = null;
  private boolean changed = false;

  /** Creates new form ExperimentsPanel */
  public CustomPanel(Filters filter, CustomFilterDialog customFilterDialog) {
    this.customFilterDialog = customFilterDialog;
    initComponents();
    String commentText =
        AnLocale.getString(
            "The Filter Specification text box initially displays filter expressions that are"
                + " generated when you select predefined filters in views such as the Functions"
                + " view. You can customize the Filter Specification by editing the filter text"
                + " directly.");
    String commentText21 = AnLocale.getString("To filter using your customizations, click OK.");
    commentTextArea.setText(commentText);
    commentTextArea.setOpaque(false);
    commentTextArea.setBackground(AnEnvironment.INVISIBLE_BACKGROUND);
    commentTextArea2.setText(commentText21);
    commentTextArea2.setOpaque(false);
    commentTextArea2.setBackground(AnEnvironment.INVISIBLE_BACKGROUND);

    customEditPanel = new CustomEditPanel(filter);
    customEditPanel.getTextPane().getDocument().addDocumentListener(new TextDocumentListner());
    editPanel.add(customEditPanel, BorderLayout.CENTER);

    getAccessibleContext()
        .setAccessibleName(
            AnLocale.getString("Custom filter settings", "ACCESSIBILITY_Custom_Panel"));
    getAccessibleContext()
        .setAccessibleDescription(
            AnLocale.getString("Custom filter settings", "ACCESSIBILITY_Custom_Panel"));
    commentTextArea
        .getAccessibleContext()
        .setAccessibleName(AnLocale.getString("Guidance", "ACCESSIBILITY_GUIDANCE"));
    commentTextArea
        .getAccessibleContext()
        .setAccessibleDescription(AnLocale.getString("Guidance", "ACCESSIBILITY_GUIDANCE"));
    commentTextArea2
        .getAccessibleContext()
        .setAccessibleName(AnLocale.getString("Guidance", "ACCESSIBILITY_GUIDANCE"));
    commentTextArea2
        .getAccessibleContext()
        .setAccessibleDescription(AnLocale.getString("Guidance", "ACCESSIBILITY_GUIDANCE"));
  }

  class TextDocumentListner implements DocumentListener {
    @Override
    public void changedUpdate(DocumentEvent e) {}

    @Override
    public void insertUpdate(DocumentEvent e) {
      changed = true;
      customFilterDialog.updateButtonStates();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
      changed = true;
      customFilterDialog.updateButtonStates();
    }
  }

  public boolean hasChanges() {
    return changed;
  }

  public boolean hasBeenChanged() {
    return customEditPanel.getTextPane().getText().length() > 0;
  }

  public void resetToFactorySetting() {
    customEditPanel.resetToFactorySetting();
  }

  public void addText(String text) {
    customEditPanel.addText(text);
  }

  public void apply() {
    customEditPanel.apply();
    changed = false;
  }

  public void undoToLastApply() {
    customEditPanel.undoToLastApply();
    changed = false;
  }

  public void setFilter(String filter) {
    customEditPanel.setFilter(filter);
    changed = false;
    customFilterDialog.updateButtonStates();
  }

  public String getFilter() {
    String filter = customEditPanel.getTextPane().getText();
    return filter;
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT
   * modify this code. The content of this method is always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    commentTextArea = new javax.swing.JTextArea();
    editPanel = new javax.swing.JPanel();
    commentTextArea2 = new javax.swing.JTextArea();

    setLayout(new java.awt.GridBagLayout());

    commentTextArea.setEditable(false);
    commentTextArea.setLineWrap(true);
    commentTextArea.setWrapStyleWord(true);
    commentTextArea.setBorder(null);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
    gridBagConstraints.weightx = 1.0;
    add(commentTextArea, gridBagConstraints);

    editPanel.setLayout(new java.awt.BorderLayout());
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 3;
    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.weighty = 1.0;
    add(editPanel, gridBagConstraints);

    commentTextArea2.setEditable(false);
    commentTextArea2.setLineWrap(true);
    commentTextArea2.setWrapStyleWord(true);
    commentTextArea2.setBorder(null);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 4;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.LAST_LINE_START;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 0);
    add(commentTextArea2, gridBagConstraints);
  } // </editor-fold>//GEN-END:initComponents

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JTextArea commentTextArea;
  private javax.swing.JTextArea commentTextArea2;
  private javax.swing.JPanel editPanel;
  // End of variables declaration//GEN-END:variables
}
