/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright (C) 2000 Edgar Denny (e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <ctype.h>

#include "text_util.h"
#include "food.h"
#include "recipe.h"
#include "recipe_win.h"
#include "nutrgoal_io.h"
#include "load_data.h"
#include "support.h"

GList *food_glist = NULL;
static GladeXML *xml = NULL;

/* Load the database files, and update progress bar. */
gint 
on_idle_in_main( gpointer dummy)
{
	GtkWidget *progressbar = NULL;
	static gboolean loaded_xml = FALSE;
	static gboolean loaded_foods = FALSE;

	/* load the glade interface. */
	if ( !loaded_xml)
	{
		xml = glade_xml_new( GNUTRITION_GLADEDIR "/progressbar.glade", NULL);

		if ( xml != NULL)
		{
			GtkWidget *progress_bar_win = NULL;

			glade_xml_signal_autoconnect( xml);

			progress_bar_win = glade_xml_get_widget( xml, "progressbar_win");
			gtk_widget_show( progress_bar_win);
		}
		else
		{
			g_log ("Gnutrition", G_LOG_LEVEL_ERROR,
					"on_idle_in_main: cannot load glade file\n");
		}
		loaded_xml = TRUE;

		return( TRUE);
	}

	progressbar = glade_xml_get_widget( xml, "pb_progressbar");

	/* load the list of foods. */
	if ( !loaded_foods)
	{
		food_glist = gnutr_create_food_glist();
		gtk_progress_set_value( GTK_PROGRESS( progressbar), 95.0);
		loaded_foods = TRUE;
		return( TRUE);
	}

	/* hide the progress bar, allocate recipe, and
	 * show the recipie window. */
	{
		GtkWidget *progress_bar_win = glade_xml_get_widget( 
				xml, "progressbar_win");
		gtk_widget_hide( progress_bar_win);
		gnutr_show_recipe_win();
	}
	return( FALSE);
}

/* return a pointer to the foods glist. */
GList *
gnutr_ret_food_glist()
{
	return food_glist;
}
