#!/usr/bin/env python
#
# Copyright 2004 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from gnuradio import gr
from gnuradio import audio
from gnuradio.eng_option import eng_option
from optparse import OptionParser

def build_graph (sampling_freq, filename, repeat):
    fg = gr.flow_graph ()
    src = gr.file_source (gr.sizeof_float, filename, repeat)
    dst = audio.sink (int (sampling_freq))
    fg.connect (src, dst)
    return fg

def main ():
    parser = OptionParser (option_class=eng_option)

    parser.add_option ("-r", "--rate", type="eng_float", default=8000,
                       help="set sampling rate to RATE (8000)")
    parser.add_option ("-f", "--file", type="string", default="audio.dat",
                       help="read input from FILE")
    parser.add_option ("-R", "--repeat", action="store_true", default=False)

    (options, args) = parser.parse_args ()

    fg = build_graph (options.rate, options.file, options.repeat)
    fg.start ()
    raw_input ('Press Enter to quit: ')
    fg.stop ()

if __name__ == '__main__':
    main ()

