/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRMAGNITUDE_H_
#define _GRMAGNITUDE_H_

#include <VrSigProc.h>

template<class iType, class oType>
class GrMagnitude : public VrSigProc {
 public:
  GrMagnitude () : VrSigProc (1, sizeof (iType), sizeof (oType)) {}

  virtual const char *name() { return "GrMagnitude"; }

  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);

};

template<class iType, class oType> int
GrMagnitude<iType,oType>::work(VrSampleRange output, void *ao[],
			       VrSampleRange inputs[], void *ai[])
{
  iType *i0 = ((iType **)ai)[0];
  oType *o0 = ((oType **)ao)[0];
  long 	size = output.size;
  long	i;

  for (i = 0; i < size; i++)
    o0[i] = (oType) abs (i0[i]);

  return output.size;
}


#endif /* _GRMAGNITUDE_H_ */
