/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.mode;

import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.mode.BaseMode;

public class CBC
extends BaseMode
implements Cloneable {
    private byte[] lastBlock;
    private byte[] scratch;

    CBC(IBlockCipher underlyingCipher, int cipherBlockSize) {
        super("cbc", underlyingCipher, cipherBlockSize);
    }

    private CBC(CBC that) {
        this((IBlockCipher)that.cipher.clone(), that.cipherBlockSize);
    }

    public Object clone() {
        return new CBC(this);
    }

    public void setup() {
        if (this.modeBlockSize != this.cipherBlockSize) {
            throw new IllegalArgumentException();
        }
        this.scratch = new byte[this.cipherBlockSize];
        this.lastBlock = new byte[this.cipherBlockSize];
        for (int i = 0; i < this.lastBlock.length && i < this.iv.length; ++i) {
            this.lastBlock[i] = this.iv[i];
        }
    }

    public void teardown() {
        this.lastBlock = null;
        this.scratch = null;
    }

    public void encryptBlock(byte[] in, int i, byte[] out, int o) {
        for (int k = 0; k < this.scratch.length; ++k) {
            this.scratch[k] = this.lastBlock[k] ^ in[k + i];
        }
        this.cipher.encryptBlock(this.scratch, 0, out, o);
        System.arraycopy(out, o, this.lastBlock, 0, this.cipherBlockSize);
    }

    public void decryptBlock(byte[] in, int i, byte[] out, int o) {
        byte[] buf = new byte[this.cipherBlockSize];
        System.arraycopy(in, i, buf, 0, this.cipherBlockSize);
        this.cipher.decryptBlock(in, i, this.scratch, 0);
        for (int k = 0; k < this.scratch.length; ++k) {
            out[o + k] = this.lastBlock[k] ^ this.scratch[k];
        }
        System.arraycopy(buf, 0, this.lastBlock, 0, this.cipherBlockSize);
    }
}

