// 
//   Copyright (C) 2005, 2006, 2007, 2008 Free Software Foundation, Inc.
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef __ASBROADCASTER_H__
#define __ASBROADCASTER_H__

// Forward declarations
namespace gnash {
	class as_value;
	class as_object;
	class fn_call;
}

namespace gnash {
  
/// AsBroadcaster facilities
class AsBroadcaster {

public:

	/// Initialize the given object as an AsBroadcaster
	//
	/// This method set the addListener,removeListener and broadcastMessage
	/// AS methods with the object, and set the _listners array member.
	///
	/// It is exposed so that Stage,TextField,Key,Mouse and Selection
	/// can call this internally.
	///
	/// The AsBroadcaster_init will take care of registering
	/// the _global.AsBroadcaster object and it's 'initialize'
	/// method for user-defined broadcasters initialization
	///
	static void initialize(as_object& obj);

	/// AsBroadcaster.initialize() AS method
	static as_value initialize_method(const fn_call& fn);

	/// Return the global AsBroadcaster
	/// (the native one, immune to any override)
	///
	static as_object* getAsBroadcaster();

private:

	static as_value addListener_method(const fn_call& fn);
	static as_value removeListener_method(const fn_call& fn);
	static as_value broadcastMessage_method(const fn_call& fn);

};

void AsBroadcaster_init(as_object& global);

} // end of gnash namespace

// __ASBROADCASTER_H__
#endif

