/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.simulation.acl2.mods.ElabMod;
import com.sun.electric.tool.simulation.acl2.mods.ModInst;
import com.sun.electric.tool.simulation.acl2.mods.ModName;
import com.sun.electric.tool.simulation.acl2.mods.Name;
import com.sun.electric.tool.simulation.acl2.mods.Path;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.modsext.ModExport;
import com.sun.electric.tool.simulation.acl2.modsext.ModuleExt;
import com.sun.electric.tool.simulation.acl2.modsext.PathExt;
import com.sun.electric.tool.simulation.acl2.modsext.WireExt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModInstExt {
    public final ModInst b;
    final ModuleExt parent;
    final ModuleExt proto;
    final Map<Name, PathExt.PortInst> portInstsIndex = new HashMap<Name, PathExt.PortInst>();
    final ElabMod.ElabModInst elabModInst;
    List<PathExt.PortInst> portInsts;

    ModInstExt(ModuleExt parent, ModInst b, int instIndex, Map<ModName, ModuleExt> downTop) {
        this.b = b;
        this.parent = parent;
        this.proto = downTop.get(b.modname);
        Util.check(this.proto != null);
        this.elabModInst = parent.elabMod.getInst(instIndex);
    }

    public Name getInstname() {
        return this.b.instname;
    }

    public ModName getModname() {
        return this.b.modname;
    }

    PathExt.PortInst newPortInst(Path.Scope path) {
        assert (path.namespace.equals(this.getInstname()));
        Path.Wire pathWire = (Path.Wire)path.subpath;
        PathExt.PortInst pi = this.portInstsIndex.get(pathWire.name);
        if (pi == null) {
            WireExt protoWire = this.proto.wiresIndex.get(pathWire.name);
            ModExport export = this.proto.makeExport(protoWire);
            pi = new PathExt.PortInst(this, path, export);
            this.portInstsIndex.put(pathWire.name, pi);
        }
        return pi;
    }

    public String toString() {
        return this.b.toString();
    }

    void checkExports() {
        assert (this.portInsts == null);
        this.portInsts = new ArrayList<PathExt.PortInst>();
        for (WireExt export : this.proto.wires) {
            if (!export.isExport()) continue;
            PathExt.PortInst pi = this.portInstsIndex.get(export.b.name);
            Util.check(pi != null && (pi.source != null || pi.driver != null));
            Util.check(pi.source == null || pi.driver == null);
            this.portInsts.add(pi);
        }
    }
}

