/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;

public class TieHi {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;

    public static Cell makePart(StdCellParams stdCell) {
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        String nm = stdCell.parameterizedName("tieHi") + "{lay}";
        Cell tieHi = stdCell.findPart(nm);
        if (tieHi != null) {
            return tieHi;
        }
        tieHi = stdCell.newPart(nm);
        double pwrX = 3.5;
        double pwrY = stdCell.getVddY();
        String vddName = stdCell.getVddExportName();
        PortCharacteristic vddRole = stdCell.getVddExportRole();
        LayoutLib.newExport(tieHi, vddName, ep, vddRole, tech.m2(), 4.0, pwrX, pwrY);
        LayoutLib.newExport(tieHi, "pwr", ep, PortCharacteristic.OUT, tech.m1(), 4.0, pwrX, pwrY);
        PortInst via = LayoutLib.newNodeInst(tech.m1m2(), ep, pwrX, pwrY, 4.0, stdCell.getVddWidth(), 0.0, tieHi).getOnlyPortInst();
        LayoutLib.newArcInst(tech.m2(), ep, Double.POSITIVE_INFINITY, tieHi.findExport(vddName).getOriginalPort(), via);
        LayoutLib.newArcInst(tech.m1(), ep, Double.POSITIVE_INFINITY, tieHi.findExport("pwr").getOriginalPort(), via);
        double wellMinX = pwrX - 6.0;
        double wellMaxX = pwrX + 6.0;
        stdCell.addNmosWell(wellMinX, wellMaxX, tieHi);
        stdCell.addPmosWell(wellMinX, wellMaxX, tieHi);
        double cellMaxX = pwrX + 2.0 + 1.5;
        stdCell.addEssentialBounds(0.0, cellMaxX, tieHi);
        return tieHi;
    }
}

