/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar1;

import com.sun.electric.tool.routing.experimentalAStar1.AStarRoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar1.Goal;
import com.sun.electric.tool.routing.experimentalAStar1.Map;
import com.sun.electric.tool.routing.experimentalAStar1.Net;
import com.sun.electric.tool.routing.experimentalAStar1.Node;
import com.sun.electric.tool.routing.experimentalAStar1.ObjectPool;
import com.sun.electric.tool.routing.experimentalAStar1.Path;
import com.sun.electric.tool.routing.experimentalAStar1.Storage;
import java.util.List;
import java.util.concurrent.Callable;

public class AStarWorker
implements Callable<Net> {
    private boolean DEBUG = false;
    private Storage storage;
    private List<ObjectPool<Node>> nodePools;
    private List<ObjectPool<Storage>> storagePools;
    private ObjectPool<Node> nodePool;
    private ObjectPool<Storage> storagePool;
    private Net net;
    private final Map map;
    private Goal goal;
    private long shutdownTime;

    public AStarWorker(Net net, List<ObjectPool<Node>> nodePools, List<ObjectPool<Storage>> storagePools, Map map2, Goal goal, long shutdownTime) {
        this.nodePools = nodePools;
        this.storagePools = storagePools;
        this.net = net;
        this.map = map2;
        this.goal = goal;
        this.shutdownTime = shutdownTime;
        this.DEBUG &= AStarRoutingFrame.getInstance().isOutputEnabled();
    }

    private void linkChild(int x, int y, int z, Node parent) {
        if (x < 0 || x >= this.map.getWidth() || y < 0 || y >= this.map.getHeight() || z < 0 || z >= this.map.getLayers()) {
            return;
        }
        if (this.goal.isTileOK(parent.x, parent.y, parent.z, x, y, z)) {
            int g = parent.g + this.goal.getTileCost(parent.x, parent.y, parent.z, x, y, z);
            Node child = this.storage.get(x, y, z);
            if (child != null) {
                byte by2 = parent.childCount;
                parent.childCount = (byte)(by2 + 1);
                parent.children[by2] = child;
                if (g < child.g) {
                    child.parent = parent;
                    child.g = g;
                    if (this.storage.isNodeInOpen(child)) {
                        this.storage.decreaseCost(child, g + child.h);
                    } else {
                        this.updateChildren(child);
                    }
                }
                return;
            }
            child = this.nodePool.alloc();
            child.initialize(x, y, z);
            child.parent = parent;
            child.g = g;
            child.h = this.goal.distanceToGoal(x, y, z);
            child.f = g + child.h;
            byte by3 = parent.childCount;
            parent.childCount = (byte)(by3 + 1);
            parent.children[by3] = child;
            this.storage.addToOpen(child);
        }
    }

    private void updateChildren(Node parent) {
        for (int i = 0; i < parent.childCount; ++i) {
            Node child = parent.children[i];
            int g = parent.g + this.goal.getTileCost(parent.x, parent.y, parent.z, child.x, child.y, child.z);
            if (g >= child.g) continue;
            child.g = g;
            child.parent = parent;
            if (this.storage.isNodeInOpen(child)) {
                this.storage.decreaseCost(child, g + child.h);
                continue;
            }
            this.updateChildren(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Net call() throws Exception {
        boolean shutdown;
        int index;
        List<ObjectPool<Node>> list = this.nodePools;
        synchronized (list) {
            this.storagePool = this.storagePools.remove(0);
            assert (this.nodePools.size() > 0);
            this.nodePool = this.nodePools.remove(0);
        }
        this.storage = this.storagePool.alloc();
        for (index = 0; index < this.net.pathDone.length && this.net.pathDone[index]; ++index) {
        }
        boolean bl = shutdown = System.currentTimeMillis() > this.shutdownTime;
        while (!this.goal.isRoutingComplete() && !shutdown) {
            this.storage.initialize(this.map.getWidth(), this.map.getHeight(), this.map.getLayers());
            Node startNode = this.nodePool.alloc();
            int[] startLoc = this.goal.getNextStart();
            startNode.initialize(startLoc[0], startLoc[1], startLoc[2]);
            startNode.g = 0;
            startNode.f = startNode.h = this.goal.distanceToGoal(startNode.x, startNode.y, startNode.z);
            int status = this.map.getStatus(startNode.x, startNode.y, startNode.z);
            assert (status != 0) : "Start position not marked!";
            if (status == this.net.getNetID()) {
                this.storage.addToOpen(startNode);
            }
            Node finishNode = null;
            int count2 = 0;
            long startTime = 0L;
            if (this.DEBUG) {
                startTime = System.currentTimeMillis();
            }
            while (!this.storage.isOpenEmpty()) {
                boolean yInside;
                ++count2;
                Node current = this.storage.shiftCheapestNode();
                short x = current.x;
                short y = current.y;
                byte z = current.z;
                if (this.goal.isFinishPosition(x, y, z)) {
                    finishNode = current;
                    break;
                }
                this.linkChild(x, y, z - 1, current);
                this.linkChild(x, y, z + 1, current);
                int spaceAround = this.map.getSpaceAround(x, y, z);
                if (spaceAround == 0) {
                    this.linkChild(x - 1, y, z, current);
                    this.linkChild(x + 1, y, z, current);
                    this.linkChild(x, y - 1, z, current);
                    this.linkChild(x, y + 1, z, current);
                    continue;
                }
                int spaceDiff = spaceAround - 1;
                int offX = x % spaceAround;
                int offY = y % spaceAround;
                boolean xInside = offX > 0 && offX < spaceDiff;
                boolean bl2 = yInside = offY > 0 && offY < spaceDiff;
                if (xInside && yInside) {
                    this.linkChild(x - offX, y, z, current);
                    this.linkChild(x - offX + spaceDiff, y, z, current);
                    this.linkChild(x, y - offY, z, current);
                    this.linkChild(x, y - offY + spaceDiff, z, current);
                    continue;
                }
                if (offX == spaceDiff && yInside) {
                    this.linkChild(x - spaceDiff, y, z, current);
                } else {
                    this.linkChild(x - 1, y, z, current);
                }
                if (offX == 0 && yInside) {
                    this.linkChild(x + spaceDiff, y, z, current);
                } else {
                    this.linkChild(x + 1, y, z, current);
                }
                if (offY == spaceDiff && xInside) {
                    this.linkChild(x, y - spaceDiff, z, current);
                } else {
                    this.linkChild(x, y - 1, z, current);
                }
                if (offY == 0 && xInside) {
                    this.linkChild(x, y + spaceDiff, z, current);
                    continue;
                }
                this.linkChild(x, y + 1, z, current);
            }
            Path path = this.net.getPaths().get(index);
            path.initialize();
            if (this.DEBUG) {
                long time = System.currentTimeMillis() - startTime;
                long speed = -2L;
                speed = time > 0L ? (long)count2 / time : (count2 > 0 ? 0L : -1L);
                System.out.printf("AStarWorker: %8d iterations in %4d ms (%4d it/ms) for path in \"%s\"\n", count2, time, speed, path.segment.getNetName());
            }
            if (finishNode != null) {
                int pathLength = 1;
                Node current = finishNode;
                while (current != startNode) {
                    pathLength += Math.abs(current.x - current.parent.x) + Math.abs(current.y - current.parent.y) + Math.abs(current.z - current.parent.z);
                    current = current.parent;
                }
                path.totalCost = finishNode.g;
                path.nodesX = new int[pathLength];
                path.nodesY = new int[pathLength];
                path.nodesZ = new int[pathLength];
                current = finishNode;
                int i = pathLength - 1;
                while (current != startNode) {
                    int z;
                    int y;
                    int x;
                    if (current.x < current.parent.x) {
                        for (x = current.x; x < current.parent.x; ++x) {
                            path.nodesX[i] = x;
                            path.nodesY[i] = current.y;
                            path.nodesZ[i] = current.z;
                            --i;
                        }
                    } else if (current.x > current.parent.x) {
                        for (x = current.x; x > current.parent.x; --x) {
                            path.nodesX[i] = x;
                            path.nodesY[i] = current.y;
                            path.nodesZ[i] = current.z;
                            --i;
                        }
                    } else if (current.y < current.parent.y) {
                        for (y = current.y; y < current.parent.y; ++y) {
                            path.nodesX[i] = current.x;
                            path.nodesY[i] = y;
                            path.nodesZ[i] = current.z;
                            --i;
                        }
                    } else if (current.y > current.parent.y) {
                        for (y = current.y; y > current.parent.y; --y) {
                            path.nodesX[i] = current.x;
                            path.nodesY[i] = y;
                            path.nodesZ[i] = current.z;
                            --i;
                        }
                    } else if (current.z < current.parent.z) {
                        for (z = current.z; z < current.parent.z; ++z) {
                            path.nodesX[i] = current.x;
                            path.nodesY[i] = current.y;
                            path.nodesZ[i] = z;
                            --i;
                        }
                    } else if (current.z > current.parent.z) {
                        z = current.z;
                        while (z > current.parent.z) {
                            path.nodesX[i] = current.x;
                            path.nodesY[i] = current.y;
                            path.nodesZ[i] = z--;
                            --i;
                        }
                    } else assert (false);
                    current = current.parent;
                }
                path.nodesX[0] = startNode.x;
                path.nodesY[0] = startNode.y;
                path.nodesZ[0] = startNode.z;
            } else {
                path.totalCost = count2;
                int finishStatus = this.goal.getFinishPositionStatus();
                if (finishStatus != this.net.getNetID()) {
                    path.totalCost = -2;
                }
            }
            this.storage.freeNodes(this.nodePool);
            ++index;
            while (index < this.net.getPaths().size() && this.net.pathDone[index]) {
                ++index;
            }
            shutdown = System.currentTimeMillis() > this.shutdownTime;
        }
        if (this.DEBUG && shutdown) {
            System.out.printf("AStarWorker: shutdown now\n", new Object[0]);
        }
        this.storagePool.free(this.storage);
        List<ObjectPool<Node>> list2 = this.nodePools;
        synchronized (list2) {
            this.nodePools.add(this.nodePool);
            this.storagePools.add(this.storagePool);
        }
        return this.net;
    }
}

