/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic1.g1;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic1.Chromosome;
import com.sun.electric.tool.placement.genetic1.Population;
import com.sun.electric.tool.placement.genetic1.PopulationCreation;
import com.sun.electric.tool.placement.genetic1.g1.PlacementNodeProxy;
import com.sun.electric.tool.placement.genetic1.g1.PopulationCreationRandomWithPlaceHolder2;
import com.sun.electric.tool.placement.genetic1.g1.PopulationMutation2;
import com.sun.electric.tool.placement.genetic1.g1.SubPopulationProcessing;
import com.sun.electric.util.math.Orientation;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneticPlacement
extends PlacementFrame {
    public PlacementFrame.PlacementParameter maxThreadsParam = (PlacementFrame)this.new PlacementFrame.PlacementParameter("threads", "Number of threads:", 4);
    public PlacementFrame.PlacementParameter maxRuntimeParam = (PlacementFrame)this.new PlacementFrame.PlacementParameter("runtime", "Runtime (seconds):", 240);
    public int numThreads;
    public int maxRuntime = 30;
    boolean printDebugInformation;
    private int generation;
    private PopulationCreation popCreator;
    private Population population;
    static ThreadPoolExecutor threadpool;
    private double previousFittestSolutionValue = Double.MAX_VALUE;
    double improvementRate;
    private Chromosome fittestSolution;
    boolean isMemoryBarrierReached;
    Runtime rt;
    ArrayList<Population> subPopulations;
    private long startTotal;
    private long stopTotal;
    private int placementWidth = -1;
    public static Random randomGenerator;
    public static final double PlacementWidthRatio = 1.2;
    public static PlacementNodeProxy[] nodeProxies;
    static int NBR_OF_THREADS;
    static final int EPOCH_LENGTH_START = 40;
    static final int EPOCH_LENGTH_MIN = 20;
    static final int EPOCH_LENGTH_MAX = 400;
    static final int EPOCH_LENGTH_STEP = 2;
    static final double EPOCH_LENGTH_RAISE = 0.005;
    static final double EPOCH_LENGTH_LOWER = 0.05;
    public static int current_epoch_length;
    static final int POPULATION_SIZE_PER_THREAD_START = 64;
    static final int POPULATION_SIZE_PER_THREAD_MIN = 32;
    static final int POPULATION_SIZE_PER_THREAD_MAX = 1024;
    static final int POPULATION_SIZE_PER_THREAD_STEP = 16;
    static final double POPULATION_SIZE_PER_THREAD_RAISE = 0.005;
    static final double POPULATION_SIZE_PER_THREAD_LOWER = 0.05;
    static int current_population_size_per_thread;
    public static long MAX_RUNTIME;
    public static long START_TIME;
    public static final boolean IS_PROGRESS_LOGGING_ENABLED = false;
    static String PROGRESS_LOG_FILENAME;
    static File PROGRESS_LOG_FILE;
    public static PrintWriter PROGRESS_LOGGER;
    static final boolean DEBUG = true;
    static final boolean MEASURE_PERFORMANCE = false;
    static Calendar calendar;
    public static final Logger logger;
    static List<PlacementFrame.PlacementNetwork> allNetworks;
    private static boolean beenRun;

    public void setParamterValues(int threads, int runtime, boolean debug) {
        this.maxRuntime = runtime;
        this.numThreads = threads;
        this.printDebugInformation = debug;
        this.numOfThreads = threads;
        this.runtime = runtime;
    }

    public static Random getRandomGenerator() {
        return randomGenerator;
    }

    void init() {
        current_population_size_per_thread = 64;
        current_epoch_length = 40;
        NBR_OF_THREADS = this.numThreads;
        MAX_RUNTIME = System.currentTimeMillis() + (long)(this.maxRuntime * 1000);
        START_TIME = System.currentTimeMillis();
        threadpool = (ThreadPoolExecutor)Executors.newFixedThreadPool(NBR_OF_THREADS);
        this.subPopulations = new ArrayList(NBR_OF_THREADS);
    }

    public static ExecutorService getThreadPool() {
        return threadpool;
    }

    public GeneticPlacement() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
        this.popCreator = new PopulationCreationRandomWithPlaceHolder2(new Random(System.currentTimeMillis()));
        this.rt = Runtime.getRuntime();
        randomGenerator = new Random(System.currentTimeMillis());
    }

    @Override
    public String getAlgorithmName() {
        return "Genetic-1";
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementAdapter.PlacementExport> exportsToPlace, String cellName, Job job) {
        int i;
        this.setParamterValues(this.maxThreadsParam.getIntValue(), this.maxRuntimeParam.getIntValue(), false);
        if (beenRun) {
            System.out.println("WARNING: The Genetic-1 placement code is not reentrant and can be run only once in an Electric session.");
        }
        beenRun = true;
        this.init();
        logger.debug("nodes :" + nodesToPlace.size());
        logger.debug("cell:" + cellName + " nodes:" + nodesToPlace.size() + " threads:" + NBR_OF_THREADS + " population per thread:" + 64 + "epoch:" + current_epoch_length);
        logger.debug("start wrapping placement nodes in proxies");
        nodeProxies = new PlacementNodeProxy[nodesToPlace.size()];
        for (int i2 = 0; i2 < nodesToPlace.size(); ++i2) {
            GeneticPlacement.nodeProxies[i2] = new PlacementNodeProxy(nodesToPlace.get(i2));
        }
        logger.debug("done wrapping placement nodes in proxies");
        GeneticPlacement.allNetworks = allNetworks;
        logger.debug("start population creation");
        this.spawnInitalPopulation(nodeProxies);
        logger.debug("done population creation");
        assert (this.population.chromosomes.size() % NBR_OF_THREADS == 0);
        this.subPopulations.clear();
        logger.debug("start partitioning population");
        while (!this.population.chromosomes.isEmpty()) {
            Population subPopulation = new Population(64);
            for (i = 0; i < 64; ++i) {
                subPopulation.chromosomes.add(this.population.chromosomes.remove(0));
            }
            this.subPopulations.add(subPopulation);
        }
        assert (this.subPopulations.size() == NBR_OF_THREADS);
        assert (this.population.chromosomes.size() == 0);
        ArrayList<SubPopulationProcessing> tasks = new ArrayList<SubPopulationProcessing>(NBR_OF_THREADS);
        logger.debug("done partitioning population");
        logger.debug("start parallel processing loop");
        for (i = 0; i < NBR_OF_THREADS; ++i) {
            tasks.add(new SubPopulationProcessing(current_epoch_length, randomGenerator.nextLong(), this.placementWidth, nodeProxies, allNetworks, this.subPopulations.get((int)0).chromosomes.get((int)0).Index2GenePositionInChromosome.length));
        }
        PopulationMutation2.resetMutationRates();
        logger.debug("current: " + System.currentTimeMillis() + " start: " + START_TIME + " diff sec: " + (System.currentTimeMillis() - START_TIME) / 1000L);
        while (System.currentTimeMillis() < MAX_RUNTIME) {
            for (int i3 = 0; i3 < NBR_OF_THREADS; ++i3) {
                ((SubPopulationProcessing)tasks.get(i3)).setSubPolulation(this.subPopulations.get(i3));
            }
            assert (this.isChromosomeOnlyInOneSubPopulation());
            assert (tasks.size() == NBR_OF_THREADS);
            try {
                ArrayList<SubPopulationProcessing> copyList = new ArrayList<SubPopulationProcessing>();
                for (SubPopulationProcessing pop : tasks) {
                    copyList.add(pop);
                }
                List threadResults = threadpool.invokeAll(copyList);
                assert (threadpool.getPoolSize() == NBR_OF_THREADS);
                for (Future f : threadResults) {
                    f.get();
                    assert (f.isDone());
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            this.collectAndRedistributeIndividuals();
            logger.debug("Best fitness value: " + this.fittestSolution.fitness + " improvement rate: " + this.improvementRate);
        }
        logger.debug("done parallel processing loop");
        if (this.fittestSolution != null) {
            for (int i4 = 0; i4 < nodesToPlace.size(); ++i4) {
                nodesToPlace.get(i4).setPlacement(this.fittestSolution.GeneXPos[i4], this.fittestSolution.GeneYPos[i4]);
                nodesToPlace.get(i4).setOrientation(Orientation.fromAngle(this.fittestSolution.GeneRotation[i4]));
            }
        }
        threadpool.shutdownNow();
    }

    private void collectAndRedistributeIndividuals() {
        for (Population p : this.subPopulations) {
            Collections.sort(p.chromosomes);
        }
        this.fittestSolution = this.subPopulations.get((int)0).chromosomes.get(0);
        for (Population subp : this.subPopulations) {
            if (!(subp.chromosomes.get((int)0).fitness < this.fittestSolution.fitness)) continue;
            this.fittestSolution = subp.chromosomes.get(0);
        }
        int subPopSize = this.subPopulations.get((int)0).chromosomes.size();
        int nbrOfExchangeIndividuals = (int)(0.7 * (double)subPopSize);
        if ((double)(nbrOfExchangeIndividuals * this.numThreads) > 0.25 * (double)subPopSize) {
            nbrOfExchangeIndividuals = (int)(0.25 * (double)subPopSize / (double)this.numThreads);
        }
        if (nbrOfExchangeIndividuals < 1) {
            nbrOfExchangeIndividuals = 1;
        }
        for (Population subp1 : this.subPopulations) {
            for (Population subp2 : this.subPopulations) {
                if (subp1 == subp2) continue;
                for (int i = 0; i < nbrOfExchangeIndividuals; ++i) {
                    Chromosome c1 = subp1.chromosomes.get(subp1.chromosomes.size() - 1 - i);
                    Chromosome c2 = subp2.chromosomes.get(i);
                    c1.altered = c2.altered;
                    c1.fitness = c2.fitness;
                    for (int rotation = 0; rotation < c1.GeneRotation.length; ++rotation) {
                        c1.GeneRotation[rotation] = c2.GeneRotation[rotation];
                    }
                    for (int xpadding = 0; xpadding < c1.GeneXPadding.length; ++xpadding) {
                        c1.GeneXPadding[xpadding] = c2.GeneXPadding[xpadding];
                    }
                    for (int ypadding = 0; ypadding < c1.GeneYPadding.length; ++ypadding) {
                        c1.GeneYPadding[ypadding] = c2.GeneYPadding[ypadding];
                    }
                    for (int xpos = 0; xpos < c1.GeneXPos.length; ++xpos) {
                        c1.GeneXPos[xpos] = c2.GeneXPos[xpos];
                    }
                    for (int ypos = 0; ypos < c1.GeneYPos.length; ++ypos) {
                        c1.GeneYPos[ypos] = c2.GeneYPos[ypos];
                    }
                    for (int index = 0; index < c1.Index2GenePositionInChromosome.length; ++index) {
                        c1.Index2GenePositionInChromosome[index] = c2.Index2GenePositionInChromosome[index];
                    }
                }
            }
        }
        this.generation += current_epoch_length * NBR_OF_THREADS;
        this.improvementRate = (this.previousFittestSolutionValue - this.fittestSolution.fitness) / this.previousFittestSolutionValue;
        this.previousFittestSolutionValue = this.fittestSolution.fitness;
        boolean bl = this.isMemoryBarrierReached = this.rt.totalMemory() == this.rt.maxMemory() && (double)this.rt.freeMemory() < 0.1 * (double)this.rt.maxMemory();
        if (this.improvementRate < 1.0) {
            if (!this.isMemoryBarrierReached && this.improvementRate > 0.05) {
                PopulationMutation2.increaseMutationRate();
            } else if (this.improvementRate < 0.004) {
                PopulationMutation2.lowerMutationRate();
            }
            if (!this.isMemoryBarrierReached && this.improvementRate < 0.005 && current_population_size_per_thread < 1024) {
                current_population_size_per_thread += 16;
            } else if (this.improvementRate > 0.05 && current_population_size_per_thread > 32) {
                current_population_size_per_thread -= 16;
            }
            if (!this.isMemoryBarrierReached && this.improvementRate < 0.005 && current_epoch_length < 400) {
                current_epoch_length += 2;
            } else if (this.improvementRate > 0.05 && current_epoch_length > 20) {
                current_epoch_length -= 2;
            }
        }
        logger.debug("Generation " + this.generation + " best fitness value: " + this.fittestSolution.fitness + " improvement rate: " + this.improvementRate);
    }

    private void spawnInitalPopulation(PlacementNodeProxy[] nodeProxies) {
        int allCellArea = 0;
        for (PlacementNodeProxy proxy : nodeProxies) {
            allCellArea += proxy.width * proxy.height;
        }
        allCellArea = (int)((double)allCellArea * 1.2);
        this.placementWidth = (int)Math.sqrt(allCellArea);
        this.population = this.popCreator.generatePopulation(nodeProxies, allNetworks, 64 * NBR_OF_THREADS);
        assert (this.population.chromosomes.size() == 64 * NBR_OF_THREADS);
    }

    private boolean isChromosomeOnlyInOneSubPopulation() {
        for (int i = 0; i < this.subPopulations.size(); ++i) {
            Population sp1 = this.subPopulations.get(i);
            for (Chromosome c : sp1.chromosomes) {
                for (int ii = i + 1; ii < this.subPopulations.size(); ++ii) {
                    Population sp2 = this.subPopulations.get(ii);
                    if (sp1 == sp2 || !sp2.chromosomes.contains(c)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void setAllNetworks(List<PlacementFrame.PlacementNetwork> nets) {
        allNetworks = nets;
    }

    public static List<PlacementFrame.PlacementNetwork> getAllNetworks() {
        return allNetworks;
    }

    public static int getNBR_OF_THREADS() {
        return NBR_OF_THREADS;
    }

    public static int getPOPULATION_SIZE() {
        return 64;
    }

    public void setNbrOfThreads(int nbrOfThreads) {
        NBR_OF_THREADS = nbrOfThreads;
        threadpool = (ThreadPoolExecutor)Executors.newFixedThreadPool(NBR_OF_THREADS);
        this.subPopulations = new ArrayList(NBR_OF_THREADS);
    }

    public void setEpochLength(int epochLength) {
        current_epoch_length = epochLength;
    }

    public void setPopulationSizePerThread(int populationSize) {
        current_population_size_per_thread = populationSize;
    }

    void logProgress(int population_size) {
        PROGRESS_LOGGER.println((System.currentTimeMillis() - START_TIME) / 1000L + ";" + "main" + ";" + this.generation + ";" + this.fittestSolution.fitness + ";" + population_size + ";" + current_population_size_per_thread + ";" + PopulationMutation2.chromosomeAlterPaddingRate + ";" + PopulationMutation2.genePaddingChangeRate_current + ";" + PopulationMutation2.chrosomeMaxPaddingChangeStep + ";" + PopulationMutation2.chromosomeMoveRate + ";" + PopulationMutation2.geneMoveRate_current + ";" + PopulationMutation2.geneMoveDistance + ";" + PopulationMutation2.chromosomeSwapRate + ";" + PopulationMutation2.geneSwapRate_current + ";" + PopulationMutation2.chromsomeRotationRate + ";" + this.improvementRate);
    }

    public int getRUNTIME() {
        return this.maxRuntime;
    }

    static {
        logger = LoggerFactory.getLogger(GeneticPlacement.class);
        beenRun = false;
    }
}

