/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.LayerId;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.GDSLayers;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import java.awt.Color;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Layer
implements Serializable,
Comparable {
    public static final double DEFAULT_THICKNESS = 0.0;
    public static final double DEFAULT_DISTANCE = 0.0;
    private static final int PTYPE = 64;
    private static final int NTYPE = 128;
    private static final int DEPLETION = 256;
    private static final int ENHANCEMENT = 512;
    private static final int LIGHT = 1024;
    private static final int HEAVY = 2048;
    private static final int DEEP = 4096;
    private static final int NONELEC = 8192;
    private static final int CONMETAL = 16384;
    private static final int CONPOLY = 32768;
    private static final int CONDIFF = 65536;
    private static final int NATIVE = 131072;
    private static final int HLVT = 0x200000;
    private static final int INTRANS = 0x400000;
    private static final int THICK = 0x800000;
    private static final int CARBNANO = 0x1000000;
    private static final int INTERCONNECT = 0x2000000;
    private static final LayerNumbers metalLayers = new LayerNumbers();
    private static final LayerNumbers metalLayers1 = new LayerNumbers();
    private static final LayerNumbers metalLayers2 = new LayerNumbers();
    private static final LayerNumbers metalLayers3 = new LayerNumbers();
    private static final LayerNumbers contactLayers = new LayerNumbers();
    private static final LayerNumbers polyLayers = new LayerNumbers();
    private static List<Function> allFunctions;
    public static final String DEFAULT_MASK_NAME = "_MASK_";
    private final LayerId layerId;
    private int index = -1;
    private final Technology tech;
    private EGraphics factoryGraphics;
    private Function function;
    private static final int NO_FUNCTION_EXTRAS = 0;
    private int functionExtras;
    private Setting cifLayerSetting;
    private Setting dxfLayerSetting;
    private Setting skillLayerSetting;
    private Setting resistanceSetting;
    private Setting capacitanceSetting;
    private Setting edgeCapacitanceSetting;
    private Setting layer3DThicknessSetting;
    private Setting layer3DDistanceSetting;
    private PrimitiveNode pureLayerNode;

    public static Function.Set getMultiLayersSet(Layer layer) {
        Function.Set thisLayerFunction = layer.getFunction().isPoly() ? new Function.Set(Function.POLY1, Function.GATE) : new Function.Set(layer);
        return thisLayerFunction;
    }

    public int compareTo(Object other) {
        String s2 = this.toString();
        String sOther = other.toString();
        return s2.compareToIgnoreCase(sOther);
    }

    public static int getNeighborLevel(Layer l1, Layer l2) {
        int level1 = l1.getFunction().getLevel();
        int level2 = l2.getFunction().getLevel();
        return level2 - level1;
    }

    public static List<Layer> getLayersSortedByRule(List<Layer> layerList, LayerSortingType type) {
        assert (type.layerFunction != null);
        Collections.sort(layerList, type.layerFunction);
        return layerList;
    }

    public static List<Layer> getLayersSortedByUserPreference(Technology tech, List<Layer> layerList, LayerSortingType type) {
        if (type != LayerSortingType.ByOrderInTechFile) {
            return Layer.getLayersSortedByRule(layerList, type);
        }
        ArrayList<Layer> tmp = new ArrayList<Layer>(layerList.size());
        Iterator<Layer> it = tech.getLayers();
        while (it.hasNext()) {
            Layer l = it.next();
            if (!layerList.contains(l)) continue;
            tmp.add(l);
        }
        return tmp;
    }

    private Layer(String name, Technology tech, EGraphics graphics) {
        this.layerId = tech.getId().newLayerId(name);
        this.tech = tech;
        if (graphics == null) {
            throw new NullPointerException();
        }
        this.factoryGraphics = graphics;
        this.function = Function.UNKNOWN;
    }

    protected Object writeReplace() {
        return new LayerKey(this);
    }

    public static Layer newInstance(Technology tech, String name, EGraphics graphics) {
        Color colorFromMap;
        if (tech == null) {
            throw new NullPointerException();
        }
        int transparent = graphics.getTransparentLayer();
        if (transparent != 0 && ((colorFromMap = tech.getFactoryTransparentLayerColors()[transparent - 1]).getRGB() & 0xFFFFFF) != graphics.getRGB()) {
            throw new IllegalArgumentException();
        }
        Layer layer = new Layer(name, tech, graphics);
        tech.addLayer(layer);
        return layer;
    }

    public LayerId getId() {
        return this.layerId;
    }

    public String getName() {
        return this.layerId.name;
    }

    public String getFullName() {
        return this.layerId.fullName;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Technology getTechnology() {
        return this.tech;
    }

    public void setGraphics(EGraphics graphics) {
        UserInterfaceMain.setGraphicsPreferences(UserInterfaceMain.getGraphicsPreferences().withGraphics(this, graphics));
    }

    public EGraphics getGraphics() {
        GraphicsPreferences gra = UserInterfaceMain.getGraphicsPreferences();
        return gra != null ? gra.getGraphics(this) : null;
    }

    public EGraphics getFactoryGraphics() {
        return this.factoryGraphics;
    }

    public void setFunction(Function function) {
        this.function = function;
        this.functionExtras = 0;
    }

    public void setFunction(Function function, int functionExtras) {
        this.function = function;
        int numBits = 0;
        for (int i = 0; i < 32; ++i) {
            if ((functionExtras & 1 << i) == 0) continue;
            ++numBits;
        }
        if (numBits >= 2 && functionExtras != 2304 && functionExtras != 1280 && functionExtras != 2560 && functionExtras != 1536 || numBits == 1 && Function.getExtraConstantName(functionExtras).length() == 0) {
            throw new IllegalArgumentException("functionExtras=" + Integer.toHexString(functionExtras));
        }
        this.functionExtras = functionExtras;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getFunctionExtras() {
        return this.functionExtras;
    }

    public void setPureLayerNode(PrimitiveNode pln) {
        this.pureLayerNode = pln;
    }

    public PrimitiveNode makePureLayerNode(String nodeName, double size2, Poly.Type style, String portName, ArcProto ... connections) {
        PrimitiveNode.Polygonal pln = new PrimitiveNode.Polygonal(nodeName, this.tech, EPoint.ORIGIN, size2, size2, ERectangle.ORIGIN, new Technology.NodeLayer[]{new Technology.NodeLayer(this, 0, style, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(0.0), EdgeV.b(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.t(0.0))})});
        pln.addPrimitivePorts(new PrimitivePort.Polygonal(pln, connections, portName, true, 0, 180, 0, EdgeH.l(0.0), EdgeV.b(0.0), EdgeH.r(0.0), EdgeV.t(0.0)));
        pln.setFunction(PrimitiveNode.Function.NODE);
        this.pureLayerNode = pln;
        return pln;
    }

    public PrimitiveNode getPureLayerNode() {
        return this.pureLayerNode;
    }

    public boolean isNonElectrical() {
        return (this.functionExtras & 0x2000) != 0;
    }

    public boolean isDiffusionLayer() {
        return this.getFunction().isDiff();
    }

    public boolean isVTImplantLayer() {
        return this.function.isImplant() && (this.functionExtras & 0x200000) != 0;
    }

    public boolean isPolyCutLayer() {
        return this.function.isContact() && (this.functionExtras & 0x8000) != 0;
    }

    public boolean isCarbonNanotubeLayer() {
        return (this.functionExtras & 0x1000000) != 0;
    }

    public boolean areLayersInSameMetalGroup(Layer other) {
        Function f1 = this.getFunction();
        Function f2 = other.getFunction();
        if (!f1.isMetal() || !f2.isMetal()) {
            return false;
        }
        return f1.getLevel() == f2.getLevel();
    }

    private Setting makeLayerSetting(String what, String factory) {
        String techName = this.tech.getTechName();
        return this.getSubNode(what).makeStringSetting(what + "LayerFor" + this.getName() + "IN" + techName, "technology/technologies", this.getName(), what + " tab", what + " for layer " + this.getName() + " in technology " + techName, factory);
    }

    private Setting makeParasiticSetting(String what, double factory) {
        return this.getSubNode(what).makeDoubleSetting(what + "ParasiticFor" + this.getName() + "IN" + this.tech.getTechName(), "technology/technologies", this.getName(), "Parasitic tab", "Technology " + this.tech.getTechName() + ", " + what + " for layer " + this.getName(), factory);
    }

    private Setting make3DSetting(String what, double factory) {
        factory = DBMath.round(factory);
        return this.getSubNode(what).makeDoubleSetting(what + "Of" + this.getName() + "IN" + this.tech.getTechName(), "technology/technologies", this.getName(), "3D tab", "Technology " + this.tech.getTechName() + ", 3D " + what + " for layer " + this.getName(), factory);
    }

    private Setting.Group getSubNode(String type) {
        return this.tech.getProjectSettings().node(type);
    }

    public void setFactory3DInfo(double thickness, double distance) {
        thickness = DBMath.round(thickness);
        distance = DBMath.round(distance);
        this.layer3DDistanceSetting = this.make3DSetting("Distance", distance);
        this.layer3DThicknessSetting = this.make3DSetting("Thickness", thickness);
    }

    public double getDistance() {
        return this.layer3DDistanceSetting.getDouble();
    }

    public Setting getDistanceSetting() {
        return this.layer3DDistanceSetting;
    }

    public double getThickness() {
        return this.layer3DThicknessSetting.getDouble();
    }

    public Setting getThicknessSetting() {
        return this.layer3DThicknessSetting;
    }

    public double getDepth() {
        return DBMath.round(this.getDistance() + this.getThickness());
    }

    public void setFactoryCIFLayer(String cifLayer) {
        this.cifLayerSetting = this.makeLayerSetting("CIF", cifLayer);
    }

    public String getCIFLayer() {
        return this.cifLayerSetting.getString();
    }

    public Setting getCIFLayerSetting() {
        return this.cifLayerSetting;
    }

    public void setFactoryDXFLayer(String dxfLayer) {
        this.dxfLayerSetting = this.makeLayerSetting("DXF", dxfLayer);
    }

    public String getDXFLayer() {
        if (this.dxfLayerSetting == null) {
            return "";
        }
        return this.dxfLayerSetting.getString();
    }

    public Setting getDXFLayerSetting() {
        return this.dxfLayerSetting;
    }

    public void setFactorySkillLayer(String skillLayer) {
        this.skillLayerSetting = this.makeLayerSetting("Skill", skillLayer);
    }

    public String getSkillLayer() {
        return this.skillLayerSetting.getString();
    }

    public Setting getSkillLayerSetting() {
        return this.skillLayerSetting;
    }

    public void setFactoryParasitics(double resistance, double capacitance, double edgeCapacitance) {
        this.resistanceSetting = this.makeParasiticSetting("Resistance", resistance);
        this.capacitanceSetting = this.makeParasiticSetting("Capacitance", capacitance);
        this.edgeCapacitanceSetting = this.makeParasiticSetting("EdgeCapacitance", edgeCapacitance);
    }

    public double getResistance() {
        return this.resistanceSetting.getDouble();
    }

    public Setting getResistanceSetting() {
        return this.resistanceSetting;
    }

    public double getCapacitance() {
        return this.capacitanceSetting.getDouble();
    }

    public Setting getCapacitanceSetting() {
        return this.capacitanceSetting;
    }

    public double getEdgeCapacitance() {
        return this.edgeCapacitanceSetting.getDouble();
    }

    public Setting getEdgeCapacitanceSetting() {
        return this.edgeCapacitanceSetting;
    }

    void finish() {
        if (this.resistanceSetting == null || this.capacitanceSetting == null || this.edgeCapacitanceSetting == null) {
            this.setFactoryParasitics(0.0, 0.0, 0.0);
        }
        if (this.cifLayerSetting == null) {
            this.setFactoryCIFLayer("");
        }
        if (this.dxfLayerSetting == null) {
            this.setFactoryDXFLayer("");
        }
        if (this.skillLayerSetting == null) {
            this.setFactorySkillLayer("");
        }
        if (this.layer3DThicknessSetting == null || this.layer3DDistanceSetting == null) {
            double thickness = this.layer3DThicknessSetting != null ? this.getThickness() : 0.0;
            double distance = this.layer3DDistanceSetting != null ? this.getDistance() : 0.0;
            this.setFactory3DInfo(thickness, distance);
        }
    }

    public String toString() {
        return "Layer " + this.getName();
    }

    public void copyState(Layer that) {
        assert (this.getName().equals(that.getName()));
        if (this.pureLayerNode != null) assert (this.pureLayerNode.getId() == that.pureLayerNode.getId());
    }

    void dump(PrintWriter out, Map<Setting, Object> settings) {
        EGraphics factoryDesc;
        String[] layerBits = new String[]{null, null, null, null, null, null, "PTYPE", "NTYPE", "DEPLETION", "ENHANCEMENT", "LIGHT", "HEAVY", null, "NONELEC", "CONMETAL", "CONPOLY", "CONDIFF", null, null, null, null, "HLVT", "INTRANS", "THICK"};
        out.print("Layer " + this.getName() + " " + this.getFunction().name());
        Technology.printlnBits(out, layerBits, this.getFunctionExtras());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getCIFLayerSetting());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getDXFLayerSetting());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getSkillLayerSetting());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getResistanceSetting());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getCapacitanceSetting());
        out.print("\t");
        Technology.printlnSetting(out, settings, this.getEdgeCapacitanceSetting());
        EGraphics desc = factoryDesc = this.getFactoryGraphics();
        out.println("\tpatternedOnDisplay=" + desc.isPatternedOnDisplay() + "(" + factoryDesc.isPatternedOnDisplay() + ")");
        out.println("\tpatternedOnPrinter=" + desc.isPatternedOnPrinter() + "(" + factoryDesc.isPatternedOnPrinter() + ")");
        out.println("\toutlined=" + (Object)((Object)desc.getOutlined()) + "(" + (Object)((Object)factoryDesc.getOutlined()) + ")");
        out.println("\ttransparent=" + desc.getTransparentLayer() + "(" + factoryDesc.getTransparentLayer() + ")");
        out.println("\tcolor=" + Integer.toHexString(desc.getColor().getRGB()) + "(" + Integer.toHexString(factoryDesc.getRGB()) + ")");
        out.println("\topacity=" + desc.getOpacity() + "(" + factoryDesc.getOpacity() + ")");
        out.println("\tforeground=" + factoryDesc.getForeground());
        int[] pattern = factoryDesc.getPattern();
        out.print("\tpattern");
        for (int p : pattern) {
            out.print(" " + Integer.toHexString(p));
        }
        out.println();
        out.println("\tdistance3D=" + this.getDistanceSetting().getDoubleFactoryValue());
        out.println("\tthickness3D=" + this.getThicknessSetting().getDoubleFactoryValue());
        out.println("\tmode3D=" + (Object)((Object)factoryDesc.getTransparencyMode()));
        out.println("\tfactor3D=" + factoryDesc.getTransparencyFactor());
    }

    Xml.Layer makeXml() {
        Xml.Layer l = new Xml.Layer();
        l.name = this.getName();
        l.function = this.getFunction();
        l.extraFunction = this.getFunctionExtras();
        l.desc = this.getFactoryGraphics();
        l.height3D = this.getDistanceSetting().getDoubleFactoryValue();
        l.thick3D = this.getThicknessSetting().getDoubleFactoryValue();
        l.cif = (String)this.getCIFLayerSetting().getFactoryValue();
        l.skill = (String)this.getSkillLayerSetting().getFactoryValue();
        l.resistance = this.getResistanceSetting().getDoubleFactoryValue();
        l.capacitance = this.getCapacitanceSetting().getDoubleFactoryValue();
        l.edgeCapacitance = this.getEdgeCapacitanceSetting().getDoubleFactoryValue();
        if (this.pureLayerNode != null) {
            l.pureLayerNode = new Xml.PureLayerNode();
            l.pureLayerNode.name = this.pureLayerNode.getName();
            for (Map.Entry<String, PrimitiveNode> e : this.tech.getOldNodeNames().entrySet()) {
                if (e.getValue() != this.pureLayerNode) continue;
                assert (l.pureLayerNode.oldName == null);
                l.pureLayerNode.oldName = e.getKey();
            }
            l.pureLayerNode.style = this.pureLayerNode.getNodeLayers()[0].getStyle();
            l.pureLayerNode.port = this.pureLayerNode.getPort(0).getName();
            l.pureLayerNode.size.addLambda(this.pureLayerNode.getFactoryDefaultSize().getLambdaX());
            for (ArcProto ap : this.pureLayerNode.getPort(0).getConnections()) {
                if (ap.getTechnology() != this.tech) continue;
                l.pureLayerNode.portArcs.add(ap.getName());
            }
        }
        return l;
    }

    private static class LayerKey
    extends EObjectInputStream.Key<Layer> {
        public LayerKey() {
        }

        private LayerKey(Layer layer) {
            super(layer);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, Layer layer) throws IOException {
            out.writeObject(layer.getTechnology());
            out.writeInt(layer.getId().chronIndex);
        }

        @Override
        public Layer readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int chronIndex;
            Technology tech = (Technology)in.readObject();
            Layer layer = tech.getLayerByChronIndex(chronIndex = in.readInt());
            if (layer == null) {
                throw new InvalidObjectException("arc proto not found");
            }
            return layer;
        }
    }

    private static class LayerHeight
    implements Comparator<Layer> {
        final boolean liftContacts;

        private LayerHeight(boolean liftContacts) {
            this.liftContacts = liftContacts;
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            Technology tech2;
            int cmp;
            Function f1 = l1.getFunction();
            Function f2 = l2.getFunction();
            if (f1 == null || f2 == null) {
                System.out.println();
            }
            int h1 = f1.getHeight();
            int h2 = f2.getHeight();
            if (this.liftContacts) {
                if (f1.isContact()) {
                    ++h1;
                } else if (f1.isMetal()) {
                    --h1;
                }
                if (f2.isContact()) {
                    ++h2;
                } else if (f2.isMetal()) {
                    --h2;
                }
            }
            if ((cmp = h1 - h2) != 0) {
                return cmp;
            }
            Technology tech1 = l1.getTechnology();
            if (tech1 != (tech2 = l2.getTechnology())) {
                int techIndex1 = tech1 != null ? tech1.getId().techIndex : -1;
                int techIndex2 = tech2 != null ? tech2.getId().techIndex : -1;
                return techIndex1 - techIndex2;
            }
            return l1.getIndex() - l2.getIndex();
        }
    }

    private static class LayerSortByGDSIndex
    implements Comparator<Layer> {
        private LayerSortByGDSIndex() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            EDatabase database = EDatabase.clientDatabase();
            Map<Setting, Object> context = database.getSettings();
            Foundry t1 = l1.getTechnology().getSelectedFoundry();
            Foundry t2 = l2.getTechnology().getSelectedFoundry();
            assert (t1 == t2);
            Setting s1 = t1.getGDSLayerSetting(l1);
            Setting s2 = t2.getGDSLayerSetting(l2);
            GDSLayers n1 = GDSLayers.parseLayerString(context.get(s1).toString());
            GDSLayers n2 = GDSLayers.parseLayerString(context.get(s2).toString());
            int int1 = n1 != null ? n1.getLayerNumber(GDSLayers.GDSLayerType.DRAWING) : 0;
            int int2 = n2 != null ? n2.getLayerNumber(GDSLayers.GDSLayerType.DRAWING) : 0;
            return int1 - int2;
        }
    }

    private static class LayerSortByName
    implements Comparator<Layer> {
        private LayerSortByName() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            String s1 = l1.getName().toLowerCase();
            String s2 = l2.getName().toLowerCase();
            return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
        }
    }

    private static class LayersByDepth
    implements Comparator<Layer> {
        private LayersByDepth() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            double diff2 = l1.getDepth() - l2.getDepth();
            if (diff2 == 0.0) {
                return 0;
            }
            if (diff2 < 0.0) {
                return -1;
            }
            return 1;
        }
    }

    private static class LayerSortByFunctionLevel
    implements Comparator<Layer> {
        private LayerSortByFunctionLevel() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            Function fun;
            int level1 = 1000;
            int level2 = 1000;
            boolean isContact1 = false;
            boolean isContact2 = false;
            if (l1 != null) {
                fun = l1.getFunction();
                level1 = fun.getLevel();
                isContact1 = fun.isContact();
            }
            if (l2 != null) {
                fun = l2.getFunction();
                level2 = fun.getLevel();
                isContact2 = fun.isContact();
            }
            if (isContact1 != isContact2) {
                return isContact1 ? -1 : 1;
            }
            return level1 - level2;
        }
    }

    public static enum LayerSortingType {
        ByName(new LayerSortByName()),
        ByGDSIndex(new LayerSortByGDSIndex()),
        ByOrderInTechFile(null),
        ByHeight(new LayerHeight(false)),
        ByHeightContact(new LayerHeight(true)),
        ByFunctionLevel(new LayerSortByFunctionLevel()),
        ByDepth(new LayersByDepth());

        Comparator<Layer> layerFunction = null;

        private LayerSortingType(Comparator<Layer> f) {
            this.layerFunction = f;
        }

        public static LayerSortingType findType(String userName) {
            try {
                LayerSortingType val = LayerSortingType.valueOf(userName);
                return val;
            }
            catch (Exception e) {
                System.out.println("Error: can't find User value for LayerSorting called '" + userName + ";");
                return ByOrderInTechFile;
            }
        }
    }

    public static enum Function {
        UNKNOWN("unknown", 0, 0, 0, 0, 35, 0, 0),
        METALNEG2("metal-2-local", -2, 0, 0, 0, 13, 0, 0),
        METALNEG1("metal-1-local", -1, 0, 0, 0, 15, 0, 0),
        METAL1("metal-1", 1, 0, 0, 0, 17, 0, 0),
        METAL1C1("metal-1-C1", 1, 0, 0, 1, 17, 0, 0),
        METAL1C2("metal-1-C2", 1, 0, 0, 2, 17, 0, 0),
        METAL1C3("metal-1-C3", 1, 0, 0, 3, 17, 0, 0),
        METAL2("metal-2", 2, 0, 0, 0, 19, 0, 0),
        METAL2C1("metal-2-C1", 2, 0, 0, 1, 19, 0, 0),
        METAL2C2("metal-2-C2", 2, 0, 0, 2, 19, 0, 0),
        METAL2C3("metal-2-C3", 2, 0, 0, 3, 19, 0, 0),
        METAL3("metal-3", 3, 0, 0, 0, 21, 0, 0),
        METAL3C1("metal-3-C1", 3, 0, 0, 1, 21, 0, 0),
        METAL3C2("metal-3-C2", 3, 0, 0, 2, 21, 0, 0),
        METAL3C3("metal-3-C3", 3, 0, 0, 3, 21, 0, 0),
        METAL4("metal-4", 4, 0, 0, 0, 23, 0, 0),
        METAL4C1("metal-4-C1", 4, 0, 0, 1, 23, 0, 0),
        METAL4C2("metal-4-C2", 4, 0, 0, 2, 23, 0, 0),
        METAL4C3("metal-4-C3", 4, 0, 0, 3, 23, 0, 0),
        METAL5("metal-5", 5, 0, 0, 0, 25, 0, 0),
        METAL5C1("metal-5-C1", 5, 0, 0, 1, 25, 0, 0),
        METAL5C2("metal-5-C2", 5, 0, 0, 2, 25, 0, 0),
        METAL5C3("metal-5-C3", 5, 0, 0, 3, 25, 0, 0),
        METAL6("metal-6", 6, 0, 0, 0, 27, 0, 0),
        METAL6C1("metal-6-C1", 6, 0, 0, 1, 27, 0, 0),
        METAL6C2("metal-6-C2", 6, 0, 0, 2, 27, 0, 0),
        METAL6C3("metal-6-C3", 6, 0, 0, 3, 27, 0, 0),
        METAL7("metal-7", 7, 0, 0, 0, 29, 0, 0),
        METAL7C1("metal-7-C1", 7, 0, 0, 1, 29, 0, 0),
        METAL7C2("metal-7-C2", 7, 0, 0, 2, 29, 0, 0),
        METAL7C3("metal-7-C3", 7, 0, 0, 3, 29, 0, 0),
        METAL8("metal-8", 8, 0, 0, 0, 31, 0, 0),
        METAL8C1("metal-8-C1", 8, 0, 0, 1, 31, 0, 0),
        METAL8C2("metal-8-C2", 8, 0, 0, 2, 31, 0, 0),
        METAL8C3("metal-8-C3", 8, 0, 0, 3, 31, 0, 0),
        METAL9("metal-9", 9, 0, 0, 0, 33, 0, 0),
        METAL9C1("metal-9-C1", 9, 0, 0, 1, 33, 0, 0),
        METAL9C2("metal-9-C2", 9, 0, 0, 2, 33, 0, 0),
        METAL9C3("metal-9-C3", 9, 0, 0, 3, 33, 0, 0),
        METAL10("metal-10", 10, 0, 0, 0, 35, 0, 0),
        METAL10C1("metal-10-C1", 10, 0, 0, 1, 35, 0, 0),
        METAL10C2("metal-10-C2", 10, 0, 0, 2, 35, 0, 0),
        METAL10C3("metal-10-C3", 10, 0, 0, 3, 35, 0, 0),
        METAL11("metal-11", 11, 0, 0, 0, 37, 0, 0),
        METAL11C1("metal-11-C1", 11, 0, 0, 1, 37, 0, 0),
        METAL11C2("metal-11-C2", 11, 0, 0, 2, 37, 0, 0),
        METAL11C3("metal-11-C3", 11, 0, 0, 3, 37, 0, 0),
        METAL12("metal-12", 12, 0, 0, 0, 39, 0, 0),
        METAL12C1("metal-12-C1", 12, 0, 0, 1, 39, 0, 0),
        METAL12C2("metal-12-C2", 12, 0, 0, 2, 39, 0, 0),
        METAL12C3("metal-12-C3", 12, 0, 0, 3, 39, 0, 0),
        METAL13("metal-13", 13, 0, 0, 0, 41, 0, 0),
        METAL13C1("metal-13-C1", 13, 0, 0, 1, 41, 0, 0),
        METAL13C2("metal-13-C2", 13, 0, 0, 2, 41, 0, 0),
        METAL13C3("metal-13-C3", 13, 0, 0, 3, 41, 0, 0),
        METAL14("metal-14", 14, 0, 0, 0, 43, 0, 0),
        METAL14C1("metal-14-C1", 14, 0, 0, 1, 43, 0, 0),
        METAL14C2("metal-14-C2", 14, 0, 0, 2, 43, 0, 0),
        METAL14C3("metal-14-C3", 14, 0, 0, 3, 43, 0, 0),
        POLY1("poly-1", 0, 0, 1, 0, 12, 0, 0),
        POLY2("poly-2", 0, 0, 2, 0, 13, 0, 0),
        POLY3("poly-3", 0, 0, 3, 0, 14, 0, 0),
        GATE("gate", 0, 0, 0, 0, 15, 0x400000, 0),
        DIFF("diffusion", 0, 0, 0, 0, 11, 0, 0),
        DIFFP("p-diffusion", 0, 0, 0, 0, 11, 64, 0),
        DIFFN("n-diffusion", 0, 0, 0, 0, 11, 128, 0),
        DIFFNCN("n-diffusion-cn", 0, 0, 0, 0, 11, 0x1000080, 0),
        DIFFPCN("n-diffusion-cn", 0, 0, 0, 0, 11, 0x1000080, 0),
        IMPLANT("implant", 0, 0, 0, 0, 2, 0, 0),
        IMPLANTP("p-implant", 0, 0, 0, 0, 2, 64, 0),
        IMPLANTN("n-implant", 0, 0, 0, 0, 2, 128, 0),
        CONTACT1("contact-1", 0, 1, 0, 0, 16, 0, 0),
        CONTACT2("contact-2", 0, 2, 0, 0, 18, 0, 0),
        CONTACT3("contact-3", 0, 3, 0, 0, 20, 0, 0),
        CONTACT4("contact-4", 0, 4, 0, 0, 22, 0, 0),
        CONTACT5("contact-5", 0, 5, 0, 0, 24, 0, 0),
        CONTACT6("contact-6", 0, 6, 0, 0, 26, 0, 0),
        CONTACT7("contact-7", 0, 7, 0, 0, 28, 0, 0),
        CONTACT8("contact-8", 0, 8, 0, 0, 30, 0, 0),
        CONTACT9("contact-9", 0, 9, 0, 0, 32, 0, 0),
        CONTACT10("contact-10", 0, 10, 0, 0, 34, 0, 0),
        CONTACT11("contact-11", 0, 11, 0, 0, 36, 0, 0),
        CONTACT12("contact-12", 0, 12, 0, 0, 38, 0, 0),
        CONTACT13("contact-13", 0, 13, 0, 0, 40, 0, 0),
        CONTACT14("contact-14", 0, 14, 0, 0, 42, 0, 0),
        PLUG("plug", 0, 0, 0, 0, 40, 0, 0),
        OVERGLASS("overglass", 0, 0, 0, 0, 41, 0, 0),
        RESISTOR("resistor", 0, 0, 0, 0, 4, 0, 0),
        CAP("capacitor", 0, 0, 0, 0, 5, 0, 0),
        TRANSISTOR("transistor", 0, 0, 0, 0, 3, 0, 0),
        EMITTER("emitter", 0, 0, 0, 0, 6, 0, 0),
        BASE("base", 0, 0, 0, 0, 7, 0, 0),
        COLLECTOR("collector", 0, 0, 0, 0, 8, 0, 0),
        SUBSTRATE("substrate", 0, 0, 0, 0, 1, 0, 0),
        WELL("well", 0, 0, 0, 0, 0, 0, 0),
        WELLP("p-well", 0, 0, 0, 0, 0, 64, 0),
        WELLN("n-well", 0, 0, 0, 0, 0, 128, 0),
        GUARD("guard", 0, 0, 0, 0, 9, 0, 0),
        ISOLATION("isolation", 0, 0, 0, 0, 10, 0, 0),
        BUS("bus", 0, 0, 0, 0, 42, 0, 0),
        ART("art", 0, 0, 0, 0, 43, 0, 0),
        CONTROL("control", 0, 0, 0, 0, 44, 0, 0),
        TILENOT("tileNot", 0, 0, 0, 0, 45, 0, 0),
        DMYPOLY1("dmy-poly-1", 0, 0, 0, 0, POLY1.getHeight(), 0, 0),
        DMYPOLY2("dmy-poly-2", 0, 0, 0, 0, POLY2.getHeight(), 0, 0),
        DMYPOLY3("dmy-poly-3", 0, 0, 0, 0, POLY3.getHeight(), 0, 0),
        DMYDIFF("dmy-diffusion", 0, 0, 0, 0, DIFF.getHeight(), 0, 0),
        DMYMETAL1("dmy-metal-1", 0, 0, 0, 0, METAL1.getHeight(), 0, 1),
        DMYMETAL2("dmy-metal-2", 0, 0, 0, 0, METAL2.getHeight(), 0, 2),
        DMYMETAL3("dmy-metal-3", 0, 0, 0, 0, METAL3.getHeight(), 0, 3),
        DMYMETAL4("dmy-metal-4", 0, 0, 0, 0, METAL4.getHeight(), 0, 4),
        DMYMETAL5("dmy-metal-5", 0, 0, 0, 0, METAL5.getHeight(), 0, 5),
        DMYMETAL6("dmy-metal-6", 0, 0, 0, 0, METAL6.getHeight(), 0, 6),
        DMYMETAL7("dmy-metal-7", 0, 0, 0, 0, METAL7.getHeight(), 0, 7),
        DMYMETAL8("dmy-metal-8", 0, 0, 0, 0, METAL8.getHeight(), 0, 8),
        DMYMETAL9("dmy-metal-9", 0, 0, 0, 0, METAL9.getHeight(), 0, 9),
        DMYMETAL10("dmy-metal-10", 0, 0, 0, 0, METAL10.getHeight(), 0, 10),
        DMYMETAL11("dmy-metal-11", 0, 0, 0, 0, METAL11.getHeight(), 0, 11),
        DMYMETAL12("dmy-metal-12", 0, 0, 0, 0, METAL12.getHeight(), 0, 12),
        DMYMETAL13("dmy-metal-13", 0, 0, 0, 0, METAL13.getHeight(), 0, 13),
        DMYMETAL14("dmy-metal-14", 0, 0, 0, 0, METAL14.getHeight(), 0, 14),
        DEXCLPOLY1("dexcl-poly-1", 0, 0, 0, 0, POLY1.getHeight(), 0, 0),
        DEXCLPOLY2("dexcl-poly-2", 0, 0, 0, 0, POLY2.getHeight(), 0, 0),
        DEXCLPOLY3("dexcl-poly-3", 0, 0, 0, 0, POLY3.getHeight(), 0, 0),
        DEXCLDIFF("dexcl-diffusion", 0, 0, 0, 0, DIFF.getHeight(), 0, 0),
        DEXCLMETAL1("dexcl-metal-1", 0, 0, 0, 0, METAL1.getHeight(), 0, 1),
        DEXCLMETAL2("dexcl-metal-2", 0, 0, 0, 0, METAL2.getHeight(), 0, 2),
        DEXCLMETAL3("dexcl-metal-3", 0, 0, 0, 0, METAL3.getHeight(), 0, 3),
        DEXCLMETAL4("dexcl-metal-4", 0, 0, 0, 0, METAL4.getHeight(), 0, 4),
        DEXCLMETAL5("dexcl-metal-5", 0, 0, 0, 0, METAL5.getHeight(), 0, 5),
        DEXCLMETAL6("dexcl-metal-6", 0, 0, 0, 0, METAL6.getHeight(), 0, 6),
        DEXCLMETAL7("dexcl-metal-7", 0, 0, 0, 0, METAL7.getHeight(), 0, 7),
        DEXCLMETAL8("dexcl-metal-8", 0, 0, 0, 0, METAL8.getHeight(), 0, 8),
        DEXCLMETAL9("dexcl-metal-9", 0, 0, 0, 0, METAL9.getHeight(), 0, 9),
        DEXCLMETAL10("dexcl-metal-10", 0, 0, 0, 0, METAL10.getHeight(), 0, 10),
        DEXCLMETAL11("dexcl-metal-11", 0, 0, 0, 0, METAL11.getHeight(), 0, 11),
        DEXCLMETAL12("dexcl-metal-12", 0, 0, 0, 0, METAL12.getHeight(), 0, 12),
        DEXCLMETAL13("dexcl-metal-13", 0, 0, 0, 0, METAL13.getHeight(), 0, 13),
        DEXCLMETAL14("dexcl-metal-14", 0, 0, 0, 0, METAL14.getHeight(), 0, 14);

        public static final int DEPLETION = 256;
        public static final int ENHANCEMENT = 512;
        public static final int LIGHT = 1024;
        public static final int HEAVY = 2048;
        public static final int INTERCONNECT = 0x2000000;
        public static final int NONELEC = 8192;
        public static final int CONMETAL = 16384;
        public static final int CONPOLY = 32768;
        public static final int CONDIFF = 65536;
        public static final int HLVT = 0x200000;
        public static final int THICK = 0x800000;
        public static final int NATIVE = 131072;
        public static final int DEEP = 4096;
        private final String name;
        private final boolean isMetal;
        private final boolean isContact;
        private final boolean isPoly;
        private final int level;
        private final int maskColor;
        private final int height;
        private final int extraBits;
        private static final int[] extras;

        private Function(String name, int metalLevel, int contactLevel, int polyLevel, int maskColor, int height, int extraBits, int genericLevel) {
            this.name = name;
            this.height = height;
            this.extraBits = extraBits;
            this.maskColor = maskColor;
            this.isMetal = metalLevel != 0;
            this.isContact = contactLevel != 0;
            this.isPoly = polyLevel != 0;
            int level = 0;
            if (genericLevel != 0) {
                level = genericLevel;
            }
            if (this.isMetal) {
                switch (maskColor) {
                    case 0: {
                        level = metalLevel;
                        metalLayers.addLayer(this, level);
                        break;
                    }
                    case 1: {
                        level = metalLevel;
                        metalLayers1.addLayer(this, level);
                        break;
                    }
                    case 2: {
                        level = metalLevel;
                        metalLayers2.addLayer(this, level);
                        break;
                    }
                    case 3: {
                        level = metalLevel;
                        metalLayers3.addLayer(this, level);
                    }
                }
            }
            if (this.isContact) {
                level = contactLevel;
                contactLayers.addLayer(this, level);
            }
            if (this.isPoly) {
                level = polyLevel;
                polyLayers.addLayer(this, level);
            }
            this.level = level;
        }

        public static Function findFunction(String userName) {
            try {
                Function val = Function.valueOf(userName);
                return val;
            }
            catch (Exception e) {
                System.out.println("Error: can't find User value for Function called '" + userName + ";");
                return null;
            }
        }

        public String toString() {
            String toStr = this.name;
            for (int i = 0; i < extras.length; ++i) {
                if ((this.extraBits & extras[i]) == 0) continue;
                toStr = toStr + "," + Function.getExtraName(extras[i]);
            }
            return toStr;
        }

        public String getName() {
            return this.name;
        }

        public String getConstantName() {
            return this.name();
        }

        public static List<Function> getFunctions() {
            return allFunctions;
        }

        public static int[] getFunctionExtras() {
            return extras;
        }

        public static String getExtraName(int extra) {
            if (extra == 64) {
                return "p-type";
            }
            if (extra == 128) {
                return "n-type";
            }
            if (extra == 256) {
                return "depletion";
            }
            if (extra == 512) {
                return "enhancement";
            }
            if (extra == 1024) {
                return "light";
            }
            if (extra == 2048) {
                return "heavy";
            }
            if (extra == 0x2000000) {
                return "interconnect";
            }
            if (extra == 8192) {
                return "nonelectrical";
            }
            if (extra == 16384) {
                return "connects-metal";
            }
            if (extra == 32768) {
                return "connects-poly";
            }
            if (extra == 65536) {
                return "connects-diff";
            }
            if (extra == 0x200000) {
                return "vt";
            }
            if (extra == 0x400000) {
                return "inside-transistor";
            }
            if (extra == 0x800000) {
                return "thick";
            }
            if (extra == 131072) {
                return "native";
            }
            if (extra == 4096) {
                return "deep";
            }
            if (extra == 0x1000000) {
                return "carb-nano";
            }
            return "";
        }

        public static String getExtraConstantName(int extra) {
            if (extra == 64) {
                return "PTYPE";
            }
            if (extra == 128) {
                return "NTYPE";
            }
            if (extra == 256) {
                return "DEPLETION";
            }
            if (extra == 512) {
                return "ENHANCEMENT";
            }
            if (extra == 1024) {
                return "LIGHT";
            }
            if (extra == 2048) {
                return "HEAVY";
            }
            if (extra == 0x2000000) {
                return "INTERCONNECT";
            }
            if (extra == 8192) {
                return "NONELEC";
            }
            if (extra == 16384) {
                return "CONMETAL";
            }
            if (extra == 32768) {
                return "CONPOLY";
            }
            if (extra == 65536) {
                return "CONDIFF";
            }
            if (extra == 0x200000) {
                return "HLVT";
            }
            if (extra == 0x400000) {
                return "INTRANS";
            }
            if (extra == 0x800000) {
                return "THICK";
            }
            if (extra == 131072) {
                return "NATIVE";
            }
            if (extra == 4096) {
                return "DEEP";
            }
            if (extra == 0x1000000) {
                return "CN";
            }
            return "";
        }

        public static int parseExtraName(String name) {
            if (name.equalsIgnoreCase("p-type")) {
                return 64;
            }
            if (name.equalsIgnoreCase("n-type")) {
                return 128;
            }
            if (name.equalsIgnoreCase("depletion")) {
                return 256;
            }
            if (name.equalsIgnoreCase("enhancement")) {
                return 512;
            }
            if (name.equalsIgnoreCase("light")) {
                return 1024;
            }
            if (name.equalsIgnoreCase("heavy")) {
                return 2048;
            }
            if (name.equalsIgnoreCase("interconnect")) {
                return 0x2000000;
            }
            if (name.equalsIgnoreCase("nonelectrical")) {
                return 8192;
            }
            if (name.equalsIgnoreCase("connects-metal")) {
                return 16384;
            }
            if (name.equalsIgnoreCase("connects-poly")) {
                return 32768;
            }
            if (name.equalsIgnoreCase("connects-diff")) {
                return 65536;
            }
            if (name.equalsIgnoreCase("inside-transistor")) {
                return 0x400000;
            }
            if (name.equalsIgnoreCase("thick")) {
                return 0x800000;
            }
            if (name.equalsIgnoreCase("vt")) {
                return 0x200000;
            }
            if (name.equalsIgnoreCase("native")) {
                return 131072;
            }
            if (name.equalsIgnoreCase("deep")) {
                return 4096;
            }
            if (name.equalsIgnoreCase("carb-nano")) {
                return 0x1000000;
            }
            return 0;
        }

        public int getLevel() {
            return this.level;
        }

        public int getMaskColor() {
            return this.maskColor;
        }

        public boolean isColored() {
            return this.getMaskColor() > 0;
        }

        public static Function getMetal(int level) {
            return Function.getMetal(level, 0);
        }

        public static Function getMetal(int level, int maskColor) {
            if (level > EGraphics.getMaxTransparentLayer()) {
                System.out.println("Invalid metal layer level:" + level);
                return null;
            }
            switch (maskColor) {
                case 0: {
                    return metalLayers.get(level);
                }
                case 1: {
                    return metalLayers1.get(level);
                }
                case 2: {
                    return metalLayers2.get(level);
                }
                case 3: {
                    return metalLayers3.get(level);
                }
            }
            return null;
        }

        public static Function getDummyMetal(int level) {
            if (level > EGraphics.getMaxTransparentLayer()) {
                System.out.println("Invalid metal layer level:" + level);
                return null;
            }
            switch (level) {
                case 0: {
                    return DMYMETAL1;
                }
                case 1: {
                    return DMYMETAL2;
                }
                case 2: {
                    return DMYMETAL3;
                }
                case 3: {
                    return DMYMETAL4;
                }
                case 4: {
                    return DMYMETAL5;
                }
                case 5: {
                    return DMYMETAL6;
                }
                case 6: {
                    return DMYMETAL7;
                }
                case 7: {
                    return DMYMETAL8;
                }
                case 8: {
                    return DMYMETAL9;
                }
                case 9: {
                    return DMYMETAL10;
                }
                case 10: {
                    return DMYMETAL11;
                }
                case 11: {
                    return DMYMETAL12;
                }
                case 12: {
                    return DMYMETAL13;
                }
                case 13: {
                    return DMYMETAL14;
                }
            }
            return null;
        }

        public static Function getDummyExclMetal(int l) {
            if (l > EGraphics.getMaxTransparentLayer()) {
                System.out.println("Invalid metal layer level:" + l);
                return null;
            }
            switch (l) {
                case 0: {
                    return DEXCLMETAL1;
                }
                case 1: {
                    return DEXCLMETAL2;
                }
                case 2: {
                    return DEXCLMETAL3;
                }
                case 3: {
                    return DEXCLMETAL4;
                }
                case 4: {
                    return DEXCLMETAL5;
                }
                case 5: {
                    return DEXCLMETAL6;
                }
                case 6: {
                    return DEXCLMETAL7;
                }
                case 7: {
                    return DEXCLMETAL8;
                }
                case 8: {
                    return DEXCLMETAL9;
                }
                case 9: {
                    return DEXCLMETAL10;
                }
                case 10: {
                    return DEXCLMETAL11;
                }
                case 11: {
                    return DEXCLMETAL12;
                }
                case 12: {
                    return DEXCLMETAL13;
                }
                case 13: {
                    return DEXCLMETAL14;
                }
            }
            return null;
        }

        public static Function getContact(int l) {
            if (l > EGraphics.getMaxTransparentLayer()) {
                System.out.println("Invalid via layer level:" + l);
                return null;
            }
            Function func = contactLayers.get(l);
            return func;
        }

        public static Function getPoly(int l) {
            Function func = polyLayers.get(l);
            return func;
        }

        public boolean isMetal() {
            return this.isMetal;
        }

        public boolean isDiff() {
            return this == DIFF || this == DIFFP || this == DIFFN || this == DIFFNCN || this == DIFFPCN;
        }

        public boolean isPoly() {
            return this.isPoly || this == GATE;
        }

        public boolean isGatePoly() {
            return this.isPoly() && (this.extraBits & 0x400000) != 0;
        }

        public boolean isContact() {
            return this.isContact;
        }

        public boolean isWell() {
            return this == WELL || this == WELLP || this == WELLN;
        }

        public boolean isSubstrate() {
            return this == SUBSTRATE || this == WELL || this == WELLP || this == WELLN || this == IMPLANT || this == IMPLANTN || this == IMPLANTP;
        }

        public boolean isImplant() {
            return this == IMPLANT || this == IMPLANTN || this == IMPLANTP;
        }

        public boolean isDummy() {
            return this == DMYDIFF || this == DMYPOLY1 || this == DMYPOLY2 || this == DMYPOLY3 || this == DMYMETAL1 || this == DMYMETAL2 || this == DMYMETAL3 || this == DMYMETAL4 || this == DMYMETAL5 || this == DMYMETAL6 || this == DMYMETAL7 || this == DMYMETAL8 || this == DMYMETAL9 || this == DMYMETAL10 || this == DMYMETAL11 || this == DMYMETAL12 || this == DMYMETAL13 || this == DMYMETAL14;
        }

        public boolean isDummyExclusion() {
            return this == DEXCLDIFF || this == DEXCLPOLY1 || this == DEXCLPOLY2 || this == DEXCLPOLY3 || this == DEXCLMETAL1 || this == DEXCLMETAL2 || this == DEXCLMETAL3 || this == DEXCLMETAL4 || this == DEXCLMETAL5 || this == DEXCLMETAL6 || this == DEXCLMETAL7 || this == DEXCLMETAL8 || this == DEXCLMETAL9 || this == DEXCLMETAL10 || this == DEXCLMETAL11 || this == DEXCLMETAL12 || this == DEXCLMETAL13 || this == DEXCLMETAL14;
        }

        public boolean isUsed(int numMetals, int numPolys) {
            if (this.isMetal || this.isContact || this.isDummyExclusion()) {
                return this.level <= numMetals;
            }
            if (this.isPoly) {
                return this.level <= numPolys;
            }
            return true;
        }

        public int getHeight() {
            return this.height;
        }

        static {
            extras = new int[]{64, 128, 256, 512, 1024, 2048, 0x2000000, 8192, 16384, 32768, 65536, 0x200000, 0x400000, 0x800000, 0x1000000};
            allFunctions = Arrays.asList(Function.class.getEnumConstants());
        }

        public static class Set {
            final BitSet bits = new BitSet();
            int extraBits;
            public static final Set ALL = new Set((Function[])Function.class.getEnumConstants());

            public Set(Layer l) {
                this.bits.set(l.getFunction().ordinal());
                this.extraBits = l.getFunctionExtras();
            }

            public Set(Function ... funs) {
                for (Function f : funs) {
                    this.bits.set(f.ordinal());
                }
                this.extraBits = 0;
            }

            public Set(Collection<Function> funs) {
                for (Function f : funs) {
                    this.bits.set(f.ordinal());
                }
                this.extraBits = 0;
            }

            public void add(Layer l) {
                this.bits.set(l.getFunction().ordinal());
                this.extraBits |= l.getFunctionExtras();
            }

            public boolean contains(Function f, int extraFunction) {
                int extra = this.extraBits & extraFunction;
                boolean extraBitsM = extraFunction == 0 || extra != 0;
                return extraBitsM && this.bits.get(f.ordinal());
            }
        }
    }

    private static class LayerNumbers {
        private final ArrayList<Function> list = new ArrayList();
        private int base = 0;

        LayerNumbers() {
        }

        public void addLayer(Function fun, int level) {
            while (level < this.base) {
                --this.base;
                this.list.add(0, null);
            }
            while (this.list.size() <= level - this.base) {
                this.list.add(null);
            }
            Function oldFunction = this.list.set(level - this.base, fun);
            assert (oldFunction == null);
        }

        public Function get(int level) {
            return this.list.get(level - this.base);
        }
    }
}

