/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.forceDirected.staged;

import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.PlacementDTO;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.StartUpStage;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingField;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingPattern;
import com.sun.electric.tool.placement.forceDirected2.metrics.AbstractMetric;
import com.sun.electric.tool.placement.forceDirected2.utils.GlobalVars;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.EmptyException;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.StageWorker;
import com.sun.electric.tool.placement.forceDirected2.utils.output.PNGOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndWorker
extends StageWorker {
    private double velocityFactor;
    private Map<PlacementDTO, Integer> elementCounter = new HashMap<PlacementDTO, Integer>();
    private Map<PlacementDTO, Integer> formatEnlargeElementCounter = new HashMap<PlacementDTO, Integer>();
    private Map<PlacementDTO, Integer> formatEnsmallElementCounter = new HashMap<PlacementDTO, Integer>();
    private StartUpStage startUpStage;
    private int width;
    private int height;
    private CheckboardingPattern checkPattern;
    private int currentStep;
    private static long finalTimeStamp;

    public EndWorker(int iterations, StartUpStage stage, int width, int height, CheckboardingPattern checkPattern, double velocity, PNGOutput out, AbstractMetric metric, long finalTimeStamp) {
        this.startUpStage = stage;
        this.height = height;
        EndWorker.finalTimeStamp = finalTimeStamp;
        this.velocityFactor = velocity * 2.0;
        this.width = width;
        this.checkPattern = checkPattern;
    }

    private List<PlacementDTO> enlargeDTO() {
        PlacementDTO tmp;
        CheckboardingField[][] fields;
        int i;
        ArrayList<PlacementDTO> dtos = new ArrayList<PlacementDTO>();
        int stepWidth = 11;
        CheckboardingField[][] fstFields = this.checkPattern.getFields(0, 0, stepWidth + 1, stepWidth + 1);
        PlacementDTO fstTmp = new PlacementDTO(fstFields, -1);
        fstTmp.setCounter(this.currentStep);
        dtos.add(fstTmp);
        for (i = stepWidth + 1; i < this.width; i += stepWidth) {
            CheckboardingField[][] fields2 = this.checkPattern.getFields(i, 0, stepWidth, stepWidth + 1);
            PlacementDTO tmp2 = new PlacementDTO(fields2, -1);
            tmp2.setCounter(this.currentStep);
            dtos.add(tmp2);
        }
        i = stepWidth + 1;
        int j = 0;
        while (i < this.height) {
            fields = this.checkPattern.getFields(0, i, stepWidth + 1, stepWidth);
            tmp = new PlacementDTO(fields, -1);
            tmp.setCounter(this.currentStep);
            dtos.add(tmp);
            i += stepWidth;
            ++j;
        }
        for (i = stepWidth + 1; i < this.height; i += stepWidth) {
            for (j = stepWidth + 1; j < this.width; j += stepWidth) {
                fields = this.checkPattern.getFields(j, i, stepWidth, stepWidth);
                tmp = new PlacementDTO(fields, -1);
                tmp.setCounter(this.currentStep);
                dtos.add(tmp);
            }
        }
        return dtos;
    }

    private List<PlacementDTO> ensmallDTO() {
        ArrayList<PlacementDTO> dtos = new ArrayList<PlacementDTO>();
        int stepWidth = 10;
        for (int i = 0; i < this.height; i += stepWidth) {
            for (int j = 0; j < this.width; j += stepWidth) {
                CheckboardingField[][] fields = this.checkPattern.getFields(j, i, stepWidth, stepWidth);
                PlacementDTO tmp = new PlacementDTO(fields, -1);
                tmp.setVelocityFactor(this.velocityFactor);
                tmp.setCounter(this.currentStep);
                dtos.add(tmp);
            }
        }
        return dtos;
    }

    @Override
    public void run() {
        while (!this.abort.booleanValue()) {
            try {
                PlacementDTO data2 = this.stage.getInput(this).get();
                data2.incCounter();
                this.elementCounter.put(data2, new Integer(data2.getCounter()));
                long now = System.currentTimeMillis();
                if (now < finalTimeStamp) {
                    List<PlacementDTO> dtos;
                    data2.setTimestamp(now);
                    if (data2.getCounter() % 6 == 0) {
                        this.formatEnsmallElementCounter.put(data2, new Integer(data2.getIndex()));
                        if (this.elementCounter.size() != this.formatEnsmallElementCounter.size()) continue;
                        this.currentStep = data2.getCounter();
                        dtos = this.ensmallDTO();
                        this.elementCounter.clear();
                        for (PlacementDTO dto : dtos) {
                            this.stage.sendToNextStage(dto);
                            this.elementCounter.put(dto, new Integer(dto.getIndex()));
                        }
                        this.formatEnsmallElementCounter.clear();
                        continue;
                    }
                    if (data2.getCounter() % 5 == 0) {
                        this.formatEnlargeElementCounter.put(data2, new Integer(data2.getIndex()));
                        if (this.elementCounter.size() != this.formatEnlargeElementCounter.size()) continue;
                        this.currentStep = data2.getCounter();
                        dtos = this.enlargeDTO();
                        this.elementCounter.clear();
                        for (PlacementDTO dto : dtos) {
                            dto.setVelocityFactor(this.velocityFactor);
                            this.stage.sendToNextStage(dto);
                            this.elementCounter.put(dto, new Integer(dto.getIndex()));
                        }
                        this.formatEnlargeElementCounter.clear();
                        continue;
                    }
                    this.stage.sendToNextStage(data2);
                    continue;
                }
                GlobalVars.rounds = new Integer(data2.getCounter());
                this.startUpStage.stop();
            }
            catch (EmptyException e) {
                Thread.yield();
            }
        }
    }
}

