/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.technology.BoundsBuilder;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Topology {
    final Cell cell;
    private final ArrayList<NodeInst> essenBounds = new ArrayList();
    private final ArrayList<NodeInst> chronNodes = new ArrayList();
    private final ArrayList<NodeInst> nodes = new ArrayList();
    private final HashMap<String, MaxSuffix> maxSuffix = new HashMap();
    private int maxArcSuffix = -1;
    private final ArrayList<ArcInst> chronArcs = new ArrayList();
    private final ArrayList<ArcInst> arcs = new ArrayList();
    boolean validArcBounds;
    private RTNode rTree = RTNode.makeTopLevel();
    private boolean rTreeFresh;

    public Topology(Cell cell, boolean loadBackup) {
        this.cell = cell;
        if (loadBackup) {
            CellRevision cellRevision = cell.backup().cellRevision;
            this.updateNodes(true, cellRevision, null, cell.lowLevelExpandedNodes());
            this.updateArcs(cellRevision);
        }
    }

    public synchronized Iterator<NodeInst> getNodes() {
        ArrayList<NodeInst> nodesCopy = new ArrayList<NodeInst>(this.nodes);
        return nodesCopy.iterator();
    }

    public synchronized Iterator<Nodable> getNodables() {
        ArrayList<NodeInst> nodesCopy = new ArrayList<NodeInst>(this.nodes);
        return nodesCopy.iterator();
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public final NodeInst getNode(int nodeIndex) {
        return this.nodes.get(nodeIndex);
    }

    public NodeInst getNodeById(int nodeId) {
        return nodeId < this.chronNodes.size() ? this.chronNodes.get(nodeId) : null;
    }

    public void updatePortInsts(Cell proto, int[] pattern) {
        for (NodeInst ni : this.nodes) {
            if (ni.getProto() != proto) continue;
            ni.updatePortInsts(pattern);
            ni.check();
        }
    }

    public PortInst getPortInst(int nodeId, PortProtoId portProtoId) {
        NodeInst ni = this.chronNodes.get(nodeId);
        assert (ni.getD().protoId == portProtoId.getParentId());
        NodeProto np = ni.getProto();
        PortProto pp = np.getPort(portProtoId);
        PortInst pi = ni.getPortInst(pp.getPortIndex());
        assert (pi.getNodeInst().getD().nodeId == nodeId);
        assert (pi.getPortProto().getId() == portProtoId);
        return pi;
    }

    public NodeInst findNode(String name) {
        int nodeIndex = this.searchNode(name);
        return nodeIndex >= 0 ? this.nodes.get(nodeIndex) : null;
    }

    public void killNodes(Set<NodeInst> killedNodes) {
        if (killedNodes.isEmpty()) {
            return;
        }
        for (NodeInst ni : killedNodes) {
            if (ni.getParent() == this.cell) continue;
            throw new IllegalArgumentException("parent");
        }
        HashSet<ArcInst> arcsToKill = new HashSet<ArcInst>();
        Iterator<ArcInst> it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            if (!killedNodes.contains(ai.getTailPortInst().getNodeInst()) && !killedNodes.contains(ai.getHeadPortInst().getNodeInst())) continue;
            arcsToKill.add(ai);
        }
        HashSet<Export> exportsToKill = new HashSet<Export>();
        Iterator<Export> it2 = this.cell.getExports();
        while (it2.hasNext()) {
            Export export = it2.next();
            if (!killedNodes.contains(export.getOriginalPort().getNodeInst())) continue;
            exportsToKill.add(export);
        }
        for (ArcInst ai : arcsToKill) {
            ai.kill();
        }
        this.cell.killExports(exportsToKill);
        for (NodeInst ni : killedNodes) {
            if (!ni.isLinked()) continue;
            this.removeNode(ni);
            Constraints.getCurrent().killObject(ni);
        }
    }

    public ImmutableNodeInst[] backupNodes(ImmutableArrayList<ImmutableNodeInst> oldNodes) {
        ImmutableNodeInst[] newNodes = new ImmutableNodeInst[this.nodes.size()];
        boolean changed = this.nodes.size() != oldNodes.size();
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = this.nodes.get(i);
            ImmutableNodeInst d = ni.getD();
            changed = changed || oldNodes.get(i) != d;
            newNodes[i] = d;
        }
        return changed ? newNodes : null;
    }

    public boolean updateNodes(boolean full, CellRevision newRevision, BitSet exportsModified, BitSet expandedNodes) {
        NodeInst ni;
        boolean expandStatusModified = false;
        this.nodes.clear();
        this.essenBounds.clear();
        this.maxSuffix.clear();
        for (int i = 0; i < newRevision.nodes.size(); ++i) {
            ImmutableNodeInst d = (ImmutableNodeInst)newRevision.nodes.get(i);
            while (d.nodeId >= this.chronNodes.size()) {
                this.chronNodes.add(null);
            }
            ni = this.chronNodes.get(d.nodeId);
            if (ni != null && ni.getProto().getId().isIcon() == d.protoId.isIcon()) {
                NodeProto oldProto = ni.getProto();
                ni.setDInUndo(d);
                if (ni.isCellInstance()) {
                    int subCellIndex = ((Cell)ni.getProto()).getCellIndex();
                    if (full || exportsModified != null && exportsModified.get(subCellIndex)) {
                        ni.updatePortInsts(full || ni.getProto() != oldProto);
                    }
                } else if (ni.getProto() != oldProto) {
                    ni.updatePortInsts(true);
                }
            } else {
                ni = NodeInst.lowLevelNewInstance(this, d);
                this.chronNodes.set(d.nodeId, ni);
                if (ni.isCellInstance()) {
                    Cell subCell = (Cell)ni.getProto();
                    boolean oldEx = expandedNodes.get(d.nodeId);
                    expandedNodes.set(d.nodeId, oldEx || subCell.isWantExpanded());
                    expandStatusModified = true;
                }
            }
            ni.setNodeIndex(i);
            this.nodes.add(ni);
            this.updateMaxSuffix(ni);
            NodeProto np = ni.getProto();
            if (np != Generic.tech().essentialBoundsNode) continue;
            this.essenBounds.add(ni);
        }
        assert (this.nodes.size() == newRevision.nodes.size());
        int nodeCount = 0;
        for (int i = 0; i < this.chronNodes.size(); ++i) {
            ni = this.chronNodes.get(i);
            if (ni == null) continue;
            int nodeIndex = ni.getNodeIndex();
            if (nodeIndex >= this.nodes.size() || ni != this.nodes.get(nodeIndex)) {
                ni.setNodeIndex(-1);
                this.chronNodes.set(i, null);
                continue;
            }
            ++nodeCount;
        }
        assert (nodeCount == this.nodes.size());
        return expandStatusModified;
    }

    public void updateSubCells(BitSet exportsModified, BitSet boundsModified) {
        this.unfreshRTree();
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = this.nodes.get(i);
            if (!ni.isCellInstance()) continue;
            int subCellIndex = ((Cell)ni.getProto()).getCellIndex();
            if (exportsModified != null && exportsModified.get(subCellIndex)) {
                ni.updatePortInsts(false);
            }
            if (boundsModified == null || !boundsModified.get(subCellIndex)) continue;
            ni.redoGeometric();
        }
    }

    public int addNode(NodeInst ni) {
        this.cell.checkChanging();
        this.addNodeName(ni);
        int nodeId = ni.getD().nodeId;
        while (this.chronNodes.size() <= nodeId) {
            this.chronNodes.add(null);
        }
        assert (this.chronNodes.get(nodeId) == null);
        this.chronNodes.set(nodeId, ni);
        if (ni.getProto() == Generic.tech().essentialBoundsNode) {
            this.essenBounds.add(ni);
        }
        return nodeId;
    }

    void addNodeName(NodeInst ni) {
        int nodeIndex = this.searchNode(ni.getName());
        assert (nodeIndex < 0);
        this.nodes.add(nodeIndex, ni);
        for (nodeIndex = -nodeIndex - 1; nodeIndex < this.nodes.size(); ++nodeIndex) {
            NodeInst n = this.nodes.get(nodeIndex);
            n.setNodeIndex(nodeIndex);
        }
        this.updateMaxSuffix(ni);
    }

    private void updateMaxSuffix(NodeInst ni) {
        int numSuffix;
        Name name = ni.getNameKey();
        if (!name.isTempname()) {
            return;
        }
        Name basename = name.getBasename();
        String basenameString = basename.toString();
        MaxSuffix ms = this.maxSuffix.get(basenameString);
        if (ms == null) {
            ms = new MaxSuffix();
            this.maxSuffix.put(basenameString, ms);
        }
        if ((numSuffix = name.getNumSuffix()) > ms.v) {
            ms.v = numSuffix;
        }
    }

    Name getNodeAutoname(Name basename) {
        Name name;
        String basenameString = basename.toString();
        MaxSuffix ms = this.maxSuffix.get(basenameString);
        if (ms == null) {
            ms = new MaxSuffix();
            this.maxSuffix.put(basenameString, ms);
            name = basename.findSuffixed(0);
        } else {
            ++ms.v;
            name = basename.findSuffixed(ms.v);
        }
        assert (this.searchNode(name.toString()) < 0);
        return name;
    }

    public void removeNode(NodeInst ni) {
        assert (ni.topology == this);
        this.essenBounds.remove(ni);
        this.removeNodeName(ni);
        int nodeId = ni.getD().nodeId;
        assert (this.chronNodes.get(nodeId) == ni);
        this.chronNodes.set(nodeId, null);
    }

    void removeNodeName(NodeInst ni) {
        int nodeIndex = ni.getNodeIndex();
        NodeInst removedNi = this.nodes.remove(nodeIndex);
        assert (removedNi == ni);
        for (int i = nodeIndex; i < this.nodes.size(); ++i) {
            NodeInst n = this.nodes.get(i);
            n.setNodeIndex(i);
        }
        ni.setNodeIndex(-1);
    }

    private int searchNode(String name) {
        int high;
        int low = 0;
        int pick = high = this.nodes.size() - 1;
        while (low <= high) {
            NodeInst ni = this.nodes.get(pick);
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(ni.getName(), name);
            if (cmp < 0) {
                low = pick + 1;
            } else if (cmp > 0) {
                high = pick - 1;
            } else {
                return pick;
            }
            pick = low + high >> 1;
        }
        return -(low + 1);
    }

    public Rectangle2D findEssentialBounds() {
        if (this.essenBounds.size() < 2) {
            return null;
        }
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (int i = 0; i < this.essenBounds.size(); ++i) {
            NodeInst ni = this.essenBounds.get(i);
            minX = Math.min(minX, ni.getTrueCenterX());
            maxX = Math.max(maxX, ni.getTrueCenterX());
            minY = Math.min(minY, ni.getTrueCenterY());
            maxY = Math.max(maxY, ni.getTrueCenterY());
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public synchronized Iterator<ArcInst> getArcs() {
        ArrayList<ArcInst> arcsCopy = new ArrayList<ArcInst>(this.arcs);
        return arcsCopy.iterator();
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public final ArcInst getArc(int arcIndex) {
        return this.arcs.get(arcIndex);
    }

    public ArcInst getArcById(int arcId) {
        return arcId < this.chronArcs.size() ? this.chronArcs.get(arcId) : null;
    }

    public int[] getArcIndexByArcIdMap() {
        int[] arcIndexByArcIdMap = new int[this.chronArcs.size()];
        Arrays.fill(arcIndexByArcIdMap, -1);
        int arcIndex = 0;
        while (arcIndex < this.getNumArcs()) {
            int arcId = this.getArc(arcIndex).getArcId();
            assert (arcIndexByArcIdMap[arcId] == -1);
            arcIndexByArcIdMap[arcId] = arcIndex++;
        }
        return arcIndexByArcIdMap;
    }

    public ArcInst findArc(String name) {
        ArcInst ai;
        int arcIndex = this.searchArc(name, 0);
        if (arcIndex >= 0) {
            return this.arcs.get(arcIndex);
        }
        if ((arcIndex = -arcIndex - 1) < this.arcs.size() && (ai = this.arcs.get(arcIndex)).getName().equals(name)) {
            return ai;
        }
        return null;
    }

    void addArc(ArcInst ai) {
        this.cell.setTopologyModified();
        this.validArcBounds = false;
        this.unfreshRTree();
        int arcIndex = this.searchArc(ai);
        assert (arcIndex < 0);
        arcIndex = -arcIndex - 1;
        this.arcs.add(arcIndex, ai);
        int arcId = ai.getArcId();
        while (this.chronArcs.size() <= arcId) {
            this.chronArcs.add(null);
        }
        assert (this.chronArcs.get(arcId) == null);
        this.chronArcs.set(arcId, ai);
        if (ai.isUsernamed()) {
            return;
        }
        Name name = ai.getNameKey();
        assert (name.getBasename() == ImmutableArcInst.BASENAME);
        this.maxArcSuffix = Math.max(this.maxArcSuffix, name.getNumSuffix());
    }

    Name getArcAutoname() {
        if (this.maxArcSuffix < Integer.MAX_VALUE) {
            return ImmutableArcInst.BASENAME.findSuffixed(++this.maxArcSuffix);
        }
        int i = 0;
        Name name;
        while (this.hasTempArcName(name = ImmutableArcInst.BASENAME.findSuffixed(i))) {
            ++i;
        }
        return name;
    }

    boolean hasTempArcName(Name name) {
        return name.isTempname() && this.findArc(name.toString()) != null;
    }

    void removeArc(ArcInst ai) {
        this.cell.checkChanging();
        this.cell.setTopologyModified();
        this.unfreshRTree();
        assert (ai.isLinked());
        int arcIndex = this.searchArc(ai);
        ArcInst removedAi = this.arcs.remove(arcIndex);
        assert (removedAi == ai);
        int arcId = ai.getArcId();
        assert (this.chronArcs.get(arcId) == ai);
        this.chronArcs.set(arcId, null);
    }

    public ImmutableArcInst[] backupArcs(ImmutableArrayList<ImmutableArcInst> oldArcs) {
        ImmutableArcInst[] newArcs = new ImmutableArcInst[this.arcs.size()];
        boolean changed = this.arcs.size() != oldArcs.size();
        for (int i = 0; i < this.arcs.size(); ++i) {
            ArcInst ai = this.arcs.get(i);
            ImmutableArcInst d = ai.getD();
            changed = changed || oldArcs.get(i) != d;
            newArcs[i] = d;
        }
        return changed ? newArcs : null;
    }

    public void updateArcs(CellRevision newRevision) {
        ArcInst ai;
        this.validArcBounds = false;
        this.arcs.clear();
        this.maxArcSuffix = -1;
        for (int i = 0; i < newRevision.arcs.size(); ++i) {
            ImmutableArcInst d = (ImmutableArcInst)newRevision.arcs.get(i);
            while (d.arcId >= this.chronArcs.size()) {
                this.chronArcs.add(null);
            }
            ai = this.chronArcs.get(d.arcId);
            PortInst headPi = this.getPortInst(d.headNodeId, d.headPortId);
            PortInst tailPi = this.getPortInst(d.tailNodeId, d.tailPortId);
            if (ai != null && ai.getHeadPortInst() == headPi && ai.getTailPortInst() == tailPi) {
                ai.setDInUndo(d);
            } else {
                ai = new ArcInst(this, d, headPi, tailPi);
                this.chronArcs.set(d.arcId, ai);
            }
            this.arcs.add(ai);
            if (ai.isUsernamed()) continue;
            Name name = ai.getNameKey();
            assert (name.getBasename() == ImmutableArcInst.BASENAME);
            this.maxArcSuffix = Math.max(this.maxArcSuffix, name.getNumSuffix());
        }
        int arcCount = 0;
        for (int i = 0; i < this.chronArcs.size(); ++i) {
            ai = this.chronArcs.get(i);
            if (ai == null) continue;
            int arcIndex = this.searchArc(ai);
            if (arcIndex < 0 || arcIndex >= this.arcs.size() || ai != this.arcs.get(arcIndex)) {
                this.chronArcs.set(i, null);
                continue;
            }
            ++arcCount;
        }
        assert (arcCount == this.arcs.size());
    }

    void computeArcBounds() {
        if (!Job.isThreadSafe() && !this.cell.getDatabase().canComputeBounds()) {
            return;
        }
        int[] intCoords = new int[4];
        BoundsBuilder b = new BoundsBuilder(this.cell.backupUnsafe());
        for (int arcIndex = 0; arcIndex < this.arcs.size(); ++arcIndex) {
            ArcInst ai = this.arcs.get(arcIndex);
            ai.computeBounds(b, intCoords);
        }
        this.validArcBounds = true;
    }

    private int searchArc(ArcInst ai) {
        return this.searchArc(ai.getName(), ai.getArcId());
    }

    private int searchArc(String name, int arcId) {
        int high;
        int low = 0;
        int pick = high = this.arcs.size() - 1;
        while (low <= high) {
            ArcInst ai = this.arcs.get(pick);
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(ai.getName(), name);
            if (cmp == 0) {
                cmp = ai.getArcId() - arcId;
            }
            if (cmp < 0) {
                low = pick + 1;
            } else if (cmp > 0) {
                high = pick - 1;
            } else {
                return pick;
            }
            pick = low + high >> 1;
        }
        return -(low + 1);
    }

    public Iterator<RTBounds> searchIterator(Rectangle2D bounds, boolean includeEdges) {
        return new RTNode.Search(bounds, this.getRTree(), includeEdges);
    }

    void setArcsDirty() {
        this.cell.setTopologyModified();
        this.validArcBounds = false;
        this.unfreshRTree();
    }

    public void unfreshRTree() {
        this.rTreeFresh = false;
    }

    public RTNode getRTree() {
        if (this.rTreeFresh) {
            return this.rTree;
        }
        EDatabase database = this.cell.getDatabase();
        if (Job.isThreadSafe() || database.canComputeBounds()) {
            this.rebuildRTree();
            this.rTreeFresh = true;
        }
        return this.rTree;
    }

    private void rebuildRTree() {
        if (!this.validArcBounds) {
            this.computeArcBounds();
        }
        CellId cellId = this.cell.getId();
        RTNode root = RTNode.makeTopLevel();
        Iterator<Geometric> it = this.cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            root = RTNode.linkGeom(cellId, root, ni);
        }
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            root = RTNode.linkGeom(cellId, root, ai);
        }
        root.checkRTree(0, cellId);
        this.rTree = root;
        this.rTreeFresh = true;
    }

    public void check(int[] cellUsages) {
        int i;
        NodeInst ni;
        ArcInst ai;
        ArcInst prevAi = null;
        Poly.Builder polyBuilder = Poly.newGridBuilder();
        for (int arcIndex = 0; arcIndex < this.arcs.size(); ++arcIndex) {
            ai = this.arcs.get(arcIndex);
            ImmutableArcInst a = ai.getD();
            assert (ai.getParent() == this.cell);
            assert (this.chronArcs.get(a.arcId) == ai);
            if (prevAi != null) {
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(prevAi.getName(), ai.getName());
                assert (cmp <= 0);
                if (cmp == 0) assert (prevAi.getArcId() < a.arcId);
            }
            assert (ai.getHeadPortInst() == this.cell.getPortInst(a.headNodeId, a.headPortId));
            assert (ai.getTailPortInst() == this.cell.getPortInst(a.tailNodeId, a.tailPortId));
            ai.check(polyBuilder);
            prevAi = ai;
        }
        for (int arcId = 0; arcId < this.chronArcs.size(); ++arcId) {
            ai = this.chronArcs.get(arcId);
            if (ai == null) continue;
            assert (ai.getArcId() == arcId);
            int arcIndex = this.searchArc(ai);
            assert (ai == this.arcs.get(arcIndex));
        }
        NodeInst prevNi = null;
        EDatabase database = this.cell.getDatabase();
        CellId cellId = this.cell.getId();
        int[] usages = new int[cellId.numUsagesIn()];
        for (int nodeIndex = 0; nodeIndex < this.nodes.size(); ++nodeIndex) {
            ni = this.nodes.get(nodeIndex);
            ImmutableNodeInst n = ni.getD();
            assert (ni.getParent() == this.cell);
            assert (ni.getNodeIndex() == nodeIndex);
            assert (this.chronNodes.get(n.nodeId) == ni);
            if (prevNi != null) assert (TextUtils.STRING_NUMBER_ORDER.compare(prevNi.getName(), ni.getName()) < 0);
            if (ni.isCellInstance()) {
                Cell subCell = (Cell)ni.getProto();
                assert (subCell.isLinked());
                assert (subCell.getDatabase() == database);
                CellUsage u = cellId.getUsageIn(subCell.getId());
                int n2 = u.indexInParent;
                usages[n2] = usages[n2] + 1;
            }
            ni.check();
            prevNi = ni;
        }
        for (int nodeId = 0; nodeId < this.chronNodes.size(); ++nodeId) {
            ni = this.chronNodes.get(nodeId);
            if (ni == null) continue;
            assert (ni.getD().nodeId == nodeId);
            assert (ni == this.nodes.get(ni.getNodeIndex()));
        }
        for (i = 0; i < cellUsages.length; ++i) {
            assert (cellUsages[i] == usages[i]);
        }
        for (i = cellUsages.length; i < usages.length; ++i) {
            assert (usages[i] == 0);
        }
        if (this.rTreeFresh) {
            this.rTree.checkRTree(0, this.cell.getId());
        }
    }

    private class MaxSuffix {
        int v = 0;

        private MaxSuffix() {
        }
    }
}

