/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.IdManager;
import com.sun.electric.database.LibId;
import com.sun.electric.database.TechId;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class SnapshotWriter {
    final IdManager idManager;
    private final DataOutputStream out;
    int techCount;
    int libCount;
    int[] exportCounts = new int[0];
    private HashMap<Variable.Key, Integer> varKeys = new HashMap();
    private HashMap<TextDescriptor, Integer> textDescriptors = new HashMap();
    private HashMap<Tool, Integer> tools = new HashMap();
    private HashMap<ArcProto, Integer> arcProtos = new HashMap();
    private HashMap<PrimitiveNode, Integer> primNodes = new HashMap();
    private HashMap<Orientation, Integer> orients = new HashMap();

    public SnapshotWriter(IdManager idManager, DataOutputStream out) {
        this.idManager = idManager;
        this.out = out;
    }

    void setTechCount(int techCount) {
        this.techCount = techCount;
    }

    void setLibCount(int libCount) {
        this.libCount = libCount;
    }

    void setCellCount(int cellCount) {
        if (cellCount == this.exportCounts.length) {
            return;
        }
        int[] newExportCounts = new int[cellCount];
        System.arraycopy(this.exportCounts, 0, newExportCounts, 0, this.exportCounts.length);
        this.exportCounts = newExportCounts;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    public void writeByte(byte v) throws IOException {
        this.out.writeByte(v);
    }

    public void writeShort(short v) throws IOException {
        this.out.writeShort(v);
    }

    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    public void writeBytes(byte[] v) throws IOException {
        this.out.writeInt(v.length);
        this.out.write(v);
    }

    public void writeString(String s) throws IOException {
        this.out.writeUTF(s);
    }

    public void writeVariableKey(Variable.Key key) throws IOException {
        Integer i = this.varKeys.get(key);
        if (i != null) {
            this.out.writeInt(i);
        } else {
            i = new Integer(this.varKeys.size());
            this.varKeys.put(key, i);
            this.out.writeInt(i);
            this.out.writeUTF(key.toString());
        }
    }

    public void writeTextDescriptor(TextDescriptor td) throws IOException {
        if (td == null) {
            this.out.writeInt(-1);
            return;
        }
        Integer i = this.textDescriptors.get(td);
        if (i != null) {
            this.out.writeInt(i);
        } else {
            i = new Integer(this.textDescriptors.size());
            this.textDescriptors.put(td, i);
            this.out.writeInt(i);
            this.out.writeLong(td.lowLevelGet());
            this.out.writeInt(td.getColorIndex());
            this.out.writeBoolean(td.isDisplay());
            this.out.writeBoolean(td.isJava());
            int face = td.getFace();
            String fontName = face != 0 ? AbstractTextDescriptor.ActiveFont.findActiveFont(face).getName() : "";
            this.out.writeUTF(fontName);
        }
    }

    public void writeTool(Tool tool) throws IOException {
        Integer i = this.tools.get(tool);
        if (i != null) {
            this.out.writeInt(i);
        } else {
            i = new Integer(this.tools.size());
            this.tools.put(tool, i);
            this.out.writeInt(i);
            this.out.writeUTF(tool.getName());
        }
    }

    public void writeTechId(TechId techId) throws IOException {
        this.out.writeInt(techId.techIndex);
    }

    private void writeTechnology(Technology tech) throws IOException {
        TechId techId = this.idManager.newTechId(tech.getTechName());
        this.writeTechId(techId);
    }

    public void writeArcProto(ArcProto ap) throws IOException {
        Integer i = this.arcProtos.get(ap);
        if (i != null) {
            this.out.writeInt(i);
        } else {
            i = new Integer(this.arcProtos.size());
            this.arcProtos.put(ap, i);
            this.out.writeInt(i);
            this.writeTechnology(ap.getTechnology());
            this.out.writeUTF(ap.getName());
        }
    }

    public void writeLibId(LibId libId) throws IOException {
        this.out.writeInt(libId.libIndex);
    }

    public void writeNodeProtoId(NodeProtoId nodeProtoId) throws IOException {
        if (nodeProtoId instanceof CellId) {
            this.out.writeInt(((CellId)nodeProtoId).cellIndex);
            return;
        }
        PrimitiveNode pn = (PrimitiveNode)nodeProtoId;
        Integer i = this.primNodes.get(pn);
        if (i != null) {
            this.out.writeInt(i);
        } else {
            i = new Integer(~this.primNodes.size());
            this.primNodes.put(pn, i);
            this.out.writeInt(i);
            this.writeTechnology(pn.getTechnology());
            this.out.writeUTF(pn.getName());
        }
    }

    public void writePortProtoId(PortProtoId portProtoId) throws IOException {
        this.writeNodeProtoId(portProtoId.getParentId());
        this.out.writeInt(portProtoId.getChronIndex());
    }

    public void writeNodeId(int nodeId) throws IOException {
        this.out.writeInt(nodeId);
    }

    public void writeArcId(int arcId) throws IOException {
        this.out.writeInt(arcId);
    }

    public void writeNameKey(Name nameKey) throws IOException {
        this.out.writeUTF(nameKey.toString());
    }

    public void writeOrientation(Orientation orient) throws IOException {
        Integer i = this.orients.get(orient);
        if (i != null) {
            this.out.writeInt(i);
        } else {
            i = new Integer(this.orients.size());
            this.orients.put(orient, i);
            this.out.writeInt(i);
            this.out.writeShort(orient.getAngle());
            this.out.writeBoolean(orient.isXMirrored());
            this.out.writeBoolean(orient.isYMirrored());
        }
    }

    public void writeCoord(long v) throws IOException {
        this.out.writeLong(v);
    }

    public void writePoint(EPoint p) throws IOException {
        this.writeCoord(p.getGridX());
        this.writeCoord(p.getGridY());
    }

    public void writeRectangle(ERectangle r) throws IOException {
        this.writeCoord(r.getGridX());
        this.writeCoord(r.getGridY());
        this.writeCoord(r.getGridWidth());
        this.writeCoord(r.getGridHeight());
    }
}

