/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.als;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.simulation.als.ALS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Flat {
    private ALS als;
    private ALS.Model primPtr2;

    Flat(ALS als) {
        this.als = als;
    }

    boolean flattenNetwork(Cell cell) {
        this.als.cellRoot = new ALS.Connect();
        this.als.cellRoot.modelName = this.als.cellRoot.instName = "[MIXED_SIGNAL_LEVEL]";
        this.als.cellRoot.exList = new ArrayList<ALS.ALSExport>();
        this.als.cellRoot.parent = null;
        this.als.cellRoot.child = null;
        this.als.cellRoot.next = null;
        ALS.Connect tempRoot = this.als.cellRoot;
        String mainName = cell.getName().toUpperCase();
        this.als.cellRoot = new ALS.Connect();
        this.als.cellRoot.modelName = this.als.cellRoot.instName = mainName;
        this.als.cellRoot.exList = new ArrayList<ALS.ALSExport>();
        this.als.cellRoot.parent = null;
        this.als.cellRoot.child = null;
        this.als.cellRoot.next = null;
        tempRoot.next = this.als.cellRoot;
        tempRoot.child = this.als.cellRoot;
        this.als.cellRoot = tempRoot;
        ALS.Model modHead = this.findModel(mainName);
        if (modHead == null) {
            return true;
        }
        for (ALS.ALSExport exHead : modHead.exList) {
            this.findXRefEntry(this.als.cellRoot.next, (String)exHead.nodeName);
        }
        if (this.flattenModel(this.als.cellRoot.next)) {
            return true;
        }
        for (ALS.Node nodeHead : this.als.nodeList) {
            if (!(nodeHead.load < 1.0)) continue;
            nodeHead.load = 1.0;
        }
        return false;
    }

    private boolean flattenModel(ALS.Connect cellHead) {
        ALS.Model modHead = this.findModel(cellHead.modelName);
        if (modHead == null) {
            return true;
        }
        switch (modHead.type) {
            case 'F': {
                if (!this.processFunction(cellHead, modHead)) break;
                return true;
            }
            case 'G': {
                this.processGate(cellHead, modHead);
                break;
            }
            case 'M': {
                if (this.processConnectList(cellHead, (ALS.Connect)modHead.ptr)) {
                    return true;
                }
                ALS.Connect subCell = cellHead.child;
                while (subCell != null) {
                    if (this.flattenModel(subCell)) {
                        return true;
                    }
                    subCell = subCell.next;
                }
                break;
            }
        }
        if (modHead.setList.size() != 0) {
            this.processSetEntry(cellHead, modHead.setList);
        }
        return false;
    }

    private boolean processConnectList(ALS.Connect cellHead, ALS.Connect conHead) {
        while (conHead != null) {
            ALS.Connect cellPtr2 = new ALS.Connect();
            cellPtr2.instName = conHead.instName;
            cellPtr2.modelName = conHead.modelName;
            cellPtr2.exList = new ArrayList<ALS.ALSExport>();
            cellPtr2.parent = cellHead;
            cellPtr2.child = null;
            cellPtr2.next = cellHead.child;
            cellHead.child = cellPtr2;
            ALS.Model modHead = this.findModel(conHead.modelName);
            if (modHead == null) {
                return true;
            }
            Iterator<ALS.ALSExport> it = modHead.exList.iterator();
            for (ALS.ALSExport exHead : conHead.exList) {
                if (!it.hasNext()) break;
                this.als.exPtr2 = it.next();
                ALS.ALSExport xRefHead = this.findXRefEntry(cellHead, (String)exHead.nodeName);
                if (this.als.exPtr2 == null) {
                    System.out.println("Insufficient parameters declared for model '" + conHead.modelName + "' in netlist");
                    return true;
                }
                for (ALS.ALSExport xRefPtr1 : cellPtr2.exList) {
                    if (!xRefPtr1.nodeName.equals(this.als.exPtr2.nodeName)) continue;
                    System.out.println("Node '" + this.als.exPtr2.nodeName + "' in model '" + conHead.modelName + "' connected more than once");
                    return true;
                }
                ALS.ALSExport xRefPtr2 = new ALS.ALSExport();
                xRefPtr2.nodeName = this.als.exPtr2.nodeName;
                xRefPtr2.nodePtr = xRefHead.nodePtr;
                cellPtr2.exList.add(xRefPtr2);
            }
            conHead = conHead.next;
        }
        return false;
    }

    private ALS.Model findModel(String modelName) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < modelName.length(); ++i) {
            char chr = modelName.charAt(i);
            if (!TextUtils.isLetterOrDigit(chr)) {
                chr = '_';
            }
            sb.append(chr);
        }
        String properName = sb.toString();
        for (ALS.Model modHead : this.als.modelList) {
            if (!modHead.name.equals(properName)) continue;
            return modHead;
        }
        System.out.println("ERROR: Model '" + properName + "' not found, simulation aborted");
        return null;
    }

    private ALS.ALSExport findXRefEntry(ALS.Connect cellHead, String name) {
        for (ALS.ALSExport xRefPtr1 : cellHead.exList) {
            if (!xRefPtr1.nodeName.equals(name)) continue;
            return xRefPtr1;
        }
        ALS.ALSExport xRefPtr2 = new ALS.ALSExport();
        xRefPtr2.nodeName = name;
        cellHead.exList.add(xRefPtr2);
        ALS.Node nodePtr2 = new ALS.Node();
        nodePtr2.cellPtr = cellHead;
        nodePtr2.statList = new ArrayList<ALS.Stat>();
        nodePtr2.pinList = new ArrayList<ALS.Load>();
        nodePtr2.load = -1.0;
        nodePtr2.visit = 0;
        nodePtr2.traceNode = false;
        this.als.nodeList.add(nodePtr2);
        xRefPtr2.nodePtr = nodePtr2;
        return xRefPtr2;
    }

    private void processGate(ALS.Connect cellHead, ALS.Model modHead) {
        this.primPtr2 = new ALS.Model(modHead.name, 'G');
        this.primPtr2.fanOut = modHead.fanOut;
        this.primPtr2.priority = modHead.priority;
        this.primPtr2.level = this.als.computePathName(cellHead);
        this.als.primList.add(this.primPtr2);
        ALS.Row rowHead = (ALS.Row)modHead.ptr;
        ALS.Row last = null;
        while (rowHead != null) {
            ALS.Row rowPtr2 = new ALS.Row();
            rowPtr2.inList = new ArrayList<Object>();
            rowPtr2.outList = new ArrayList<Object>();
            rowPtr2.delta = rowHead.delta;
            rowPtr2.linear = rowHead.linear;
            rowPtr2.exp = rowHead.exp;
            rowPtr2.abs = rowHead.abs;
            rowPtr2.random = rowHead.random;
            rowPtr2.delay = rowHead.delay;
            rowPtr2.delay = rowHead.delay == null ? null : rowHead.delay;
            rowPtr2.next = null;
            if (last == null) {
                this.primPtr2.ptr = rowPtr2;
            } else {
                last.next = rowPtr2;
            }
            last = rowPtr2;
            this.als.ioPtr1 = rowPtr2.inList;
            this.processIOEntry(modHead, cellHead, rowHead.inList, 'I');
            this.als.ioPtr1 = rowPtr2.outList;
            this.processIOEntry(modHead, cellHead, rowHead.outList, 'O');
            rowHead = rowHead.next;
        }
    }

    private void processIOEntry(ALS.Model modHead, ALS.Connect cellHead, List<Object> ioList, char flag) {
        for (Object obj : ioList) {
            ALS.IO ioHead = (ALS.IO)obj;
            ALS.ALSExport xRefHead = this.findXRefEntry(cellHead, (String)ioHead.nodePtr);
            this.als.ioPtr2 = new ALS.IO();
            this.als.ioPtr2.nodePtr = xRefHead.nodePtr;
            this.als.ioPtr2.operatr = ioHead.operatr;
            if (this.als.ioPtr2.operatr > '\u007f') {
                xRefHead = this.findXRefEntry(cellHead, (String)ioHead.operand);
                this.als.ioPtr2.operand = xRefHead.nodePtr;
            } else {
                this.als.ioPtr2.operand = ioHead.operand;
            }
            this.als.ioPtr2.strength = ioHead.strength;
            this.als.ioPtr1.add(this.als.ioPtr2);
            switch (flag) {
                case 'I': {
                    this.createPinEntry(modHead, (String)ioHead.nodePtr, (ALS.Node)this.als.ioPtr2.nodePtr);
                    break;
                }
                case 'O': {
                    this.als.ioPtr2.nodePtr = this.createStatEntry(modHead, (String)ioHead.nodePtr, (ALS.Node)this.als.ioPtr2.nodePtr);
                }
            }
            if (this.als.ioPtr2.operatr <= '\u007f') continue;
            this.createPinEntry(modHead, (String)ioHead.operand, (ALS.Node)this.als.ioPtr2.operand);
        }
    }

    private void createPinEntry(ALS.Model modHead, String nodeName, ALS.Node nodeHead) {
        for (ALS.Load pinPtr1 : nodeHead.pinList) {
            if (pinPtr1.ptr != this.primPtr2) continue;
            return;
        }
        ALS.Load pinPtr2 = new ALS.Load();
        pinPtr2.ptr = this.primPtr2;
        nodeHead.pinList.add(pinPtr2);
        nodeHead.load += this.findLoadValue(modHead, nodeName);
    }

    private ALS.Stat createStatEntry(ALS.Model modHead, String nodeName, ALS.Node nodeHead) {
        for (ALS.Stat statPtr1 : nodeHead.statList) {
            if (statPtr1.primPtr != this.primPtr2) continue;
            return statPtr1;
        }
        ALS.Stat statPtr2 = new ALS.Stat();
        statPtr2.primPtr = this.primPtr2;
        statPtr2.nodePtr = nodeHead;
        nodeHead.statList.add(statPtr2);
        nodeHead.load += this.findLoadValue(modHead, nodeName);
        return statPtr2;
    }

    private double findLoadValue(ALS.Model modHead, String nodeName) {
        for (ALS.Load loadHead : modHead.loadList) {
            if (!loadHead.ptr.equals(nodeName)) continue;
            return loadHead.load;
        }
        if (modHead.type == 'F') {
            return 0.0;
        }
        return 1.0;
    }

    private void processSetEntry(ALS.Connect cellHead, List<ALS.IO> ioList) {
        for (ALS.IO ioHead : ioList) {
            ALS.ALSExport xRefHead = this.findXRefEntry(cellHead, (String)ioHead.nodePtr);
            ALS.Link setHead = new ALS.Link();
            setHead.type = (char)78;
            setHead.ptr = xRefHead.nodePtr;
            setHead.state = ioHead.operand;
            setHead.strength = ioHead.strength;
            setHead.priority = 2;
            setHead.time = 0.0;
            setHead.right = null;
            this.als.insertSetList(setHead);
        }
    }

    private boolean processFunction(ALS.Connect cellHead, ALS.Model modHead) {
        ALS.ALSExport xRefHead;
        this.primPtr2 = new ALS.Model(modHead.name, 'F');
        this.primPtr2.ptr = new ALS.Func();
        this.primPtr2.priority = modHead.priority;
        this.primPtr2.level = this.als.computePathName(cellHead);
        this.als.primList.add(this.primPtr2);
        ALS.Func funcHead = (ALS.Func)modHead.ptr;
        ALS.Func funcPtr2 = (ALS.Func)this.primPtr2.ptr;
        funcPtr2.procPtr = ALS.UserProc.getFunctionAddress(modHead.name);
        if (funcPtr2.procPtr == null) {
            return true;
        }
        funcPtr2.inList = new ArrayList<ALS.ALSExport>();
        funcPtr2.delta = funcHead.delta;
        funcPtr2.linear = funcHead.linear;
        funcPtr2.exp = funcHead.exp;
        funcPtr2.abs = funcHead.abs;
        funcPtr2.random = funcHead.random;
        funcPtr2.userPtr = null;
        for (ALS.ALSExport exHead : modHead.exList) {
            xRefHead = this.findXRefEntry(cellHead, (String)exHead.nodeName);
            this.als.exPtr2 = new ALS.ALSExport();
            this.als.exPtr2.nodeName = exHead.nodePtr != null ? this.createStatEntry(modHead, (String)exHead.nodeName, xRefHead.nodePtr) : null;
            this.als.exPtr2.nodePtr = xRefHead.nodePtr;
            this.primPtr2.exList.add(this.als.exPtr2);
        }
        for (ALS.ALSExport exHead : funcHead.inList) {
            xRefHead = this.findXRefEntry(cellHead, (String)exHead.nodeName);
            this.als.exPtr2 = new ALS.ALSExport();
            this.als.exPtr2.nodePtr = xRefHead.nodePtr;
            this.primPtr2.exList.add(this.als.exPtr2);
            this.createPinEntry(modHead, (String)exHead.nodeName, xRefHead.nodePtr);
        }
        return false;
    }
}

