/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ChangeText
extends EDialog {
    private static boolean nodesSelected = false;
    private static boolean arcsSelected = false;
    private static boolean exportsSelected = false;
    private static boolean annotationsSelected = false;
    private static boolean instancesSelected = false;
    private static boolean cellsSelected = false;
    private Cell cell;
    private int numToChange;
    private int lowPointSize;
    private int highPointSize;
    private double lowUnitSize;
    private double highUnitSize;
    private int numNodesChanged;
    private int numArcsChanged;
    private int numExportsChanged;
    private int numAnnotationsChanged;
    private int numInstancesChanged;
    private int numCellsChanged;
    private EditWindow wnd;
    private JCheckBox bold;
    private JButton cancel;
    private JRadioButton changeAllInCell;
    private JRadioButton changeAllInLibrary;
    private JCheckBox changeAnnotationText;
    private JCheckBox changeArcText;
    private JCheckBox changeCellText;
    private JRadioButton changeCellsWithView;
    private JCheckBox changeExportText;
    private JCheckBox changeInstanceText;
    private JCheckBox changeNodeText;
    private JRadioButton changeSelectedObjects;
    private JComboBox font;
    private JCheckBox italic;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton ok;
    private JTextField pointSize;
    private JLabel selectedText;
    private ButtonGroup sizeGroup;
    private JCheckBox underline;
    private JTextField unitSize;
    private JRadioButton usePoints;
    private JRadioButton useUnits;
    private JComboBox viewList;
    private ButtonGroup whereGroup;

    public static void changeTextDialog() {
        ChangeText dialog = new ChangeText((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    private ChangeText(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.useUnits.setSelected(true);
        this.changeNodeText.setSelected(nodesSelected);
        this.changeArcText.setSelected(arcsSelected);
        this.changeExportText.setSelected(exportsSelected);
        this.changeAnnotationText.setSelected(annotationsSelected);
        this.changeInstanceText.setSelected(instancesSelected);
        this.changeCellText.setSelected(cellsSelected);
        this.cell = WindowFrame.getCurrentCell();
        this.wnd = EditWindow.getCurrent();
        Iterator it = View.getOrderedViews().iterator();
        while (it.hasNext()) {
            View view = (View)it.next();
            this.viewList.addItem(view.getFullName());
        }
        this.font.addItem("DEFAULT FONT");
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < fonts.length; ++i) {
            this.font.addItem(fonts[i].getFontName());
        }
        if (this.wnd == null || this.wnd.getHighlighter().getNumHighlights() == 0) {
            this.changeSelectedObjects.setEnabled(false);
            this.changeAllInCell.setSelected(true);
        } else {
            this.changeSelectedObjects.setSelected(true);
        }
        this.findSelectedText(false);
        this.changeSelectedObjects.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText(false);
            }
        });
        this.changeAllInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText(false);
            }
        });
        this.changeCellsWithView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText(false);
            }
        });
        this.viewList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText(false);
            }
        });
        this.changeAllInLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText(false);
            }
        });
        this.changeNodeText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText(false);
            }
        });
        this.changeArcText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText(false);
            }
        });
        this.changeExportText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText(false);
            }
        });
        this.changeAnnotationText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText(false);
            }
        });
        this.changeInstanceText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText(false);
            }
        });
        this.changeCellText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.findSelectedText(false);
            }
        });
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void findSelectedText(boolean change) {
        nodesSelected = this.changeNodeText.isSelected();
        arcsSelected = this.changeArcText.isSelected();
        exportsSelected = this.changeExportText.isSelected();
        annotationsSelected = this.changeAnnotationText.isSelected();
        instancesSelected = this.changeInstanceText.isSelected();
        cellsSelected = this.changeCellText.isSelected();
        this.numToChange = 0;
        this.lowPointSize = -1;
        this.lowUnitSize = -1.0;
        if (this.changeSelectedObjects.isSelected()) {
            EditWindow wnd;
            if (change) {
                Cell cell = WindowFrame.needCurCell();
                if (cell == null) {
                    return;
                }
                if (CircuitChanges.cantEdit(cell, null, true) != 0) {
                    return;
                }
            }
            if ((wnd = EditWindow.getCurrent()) != null) {
                Iterator it = wnd.getHighlighter().getHighlightedText(false).iterator();
                while (it.hasNext()) {
                    Highlight h = (Highlight)it.next();
                    if (h.getType() != Highlight.Type.TEXT) continue;
                    this.accumulateTextFound(h.getElectricObject(), h.getVar(), h.getName(), change);
                }
            }
        } else if (this.changeAllInCell.isSelected()) {
            this.findAllInCell(this.cell, change);
        } else if (this.changeCellsWithView.isSelected()) {
            String viewName = (String)this.viewList.getSelectedItem();
            View v = View.findView(viewName);
            if (v != null) {
                Iterator it = Library.getCurrent().getCells();
                while (it.hasNext()) {
                    Cell c = (Cell)it.next();
                    if (c.getView() != v) continue;
                    this.findAllInCell(c, change);
                }
            }
        } else if (this.changeAllInLibrary.isSelected()) {
            Iterator it = Library.getCurrent().getCells();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                this.findAllInCell(c, change);
            }
        }
        if (change) {
            return;
        }
        if (this.numToChange == 0) {
            this.selectedText.setText("No text to change");
        } else {
            String what = "Text runs from ";
            if (this.lowPointSize >= 0) {
                what = what + this.lowPointSize + " to " + this.highPointSize + " points";
            }
            if (this.lowUnitSize >= 0.0) {
                if (this.lowPointSize >= 0) {
                    what = what + "; ";
                }
                what = what + this.lowUnitSize + " to " + this.highUnitSize + " units";
            }
            this.selectedText.setText(what);
            if (this.lowUnitSize >= 0.0) {
                this.useUnits.setSelected(true);
                this.unitSize.setText(TextUtils.formatDouble(this.highUnitSize));
            } else {
                this.usePoints.setSelected(true);
                this.pointSize.setText(Integer.toString(this.highPointSize));
            }
        }
    }

    private void findAllInCell(Cell cell, boolean change) {
        Variable var;
        Iterator vIt;
        if (change && CircuitChanges.cantEdit(cell, null, true) != 0) {
            return;
        }
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() instanceof Cell && !ni.isExpanded()) {
                this.accumulateTextFound(ni, null, null, change);
            }
            if (!ni.getNameKey().isTempname()) {
                this.accumulateTextFound(ni, null, ni.getNameKey(), change);
            }
            vIt = ni.getVariables();
            while (vIt.hasNext()) {
                var = (Variable)vIt.next();
                if (!var.isDisplay()) continue;
                this.accumulateTextFound(ni, var, null, change);
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (!ai.getNameKey().isTempname()) {
                this.accumulateTextFound(ai, null, ai.getNameKey(), change);
            }
            vIt = ai.getVariables();
            while (vIt.hasNext()) {
                var = (Variable)vIt.next();
                if (!var.isDisplay()) continue;
                this.accumulateTextFound(ai, var, null, change);
            }
        }
        it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            this.accumulateTextFound(pp, null, null, change);
            vIt = pp.getVariables();
            while (vIt.hasNext()) {
                var = (Variable)vIt.next();
                if (!var.isDisplay()) continue;
                this.accumulateTextFound(pp, var, null, change);
            }
        }
        Iterator vIt2 = cell.getVariables();
        while (vIt2.hasNext()) {
            Variable var2 = (Variable)vIt2.next();
            if (!var2.isDisplay()) continue;
            this.accumulateTextFound(cell, var2, null, change);
        }
    }

    private void accumulateTextFound(ElectricObject eObj, Variable var, Name name, boolean change) {
        if (var != null) {
            String varName = var.getKey().getName();
            if (eObj instanceof NodeInst) {
                NodeInst ni = (NodeInst)eObj;
                if (ni.getProto() == Generic.tech.invisiblePinNode) {
                    if (this.changeAnnotationText.isSelected() && this.processText(eObj, varName, change)) {
                        ++this.numAnnotationsChanged;
                    }
                } else if (this.changeNodeText.isSelected() && this.processText(eObj, varName, change)) {
                    ++this.numNodesChanged;
                }
            } else if (eObj instanceof ArcInst) {
                if (this.changeArcText.isSelected() && this.processText(eObj, varName, change)) {
                    ++this.numArcsChanged;
                }
            } else if (eObj instanceof Cell && this.changeCellText.isSelected() && this.processText(eObj, varName, change)) {
                ++this.numCellsChanged;
            }
        } else if (name != null) {
            if (eObj instanceof NodeInst) {
                NodeInst ni = (NodeInst)eObj;
                if (this.changeNodeText.isSelected() && this.processText(ni, NodeInst.NODE_NAME_TD, change)) {
                    ++this.numNodesChanged;
                }
            } else {
                ArcInst ai = (ArcInst)eObj;
                if (this.changeArcText.isSelected() && this.processText(ai, ArcInst.ARC_NAME_TD, change)) {
                    ++this.numNodesChanged;
                }
            }
        } else if (eObj instanceof Export) {
            Export pp = (Export)eObj;
            if (this.changeExportText.isSelected() && this.processText(pp, Export.EXPORT_NAME_TD, change)) {
                ++this.numExportsChanged;
            }
        } else {
            NodeInst ni = (NodeInst)eObj;
            if (this.changeInstanceText.isSelected() && this.processText(ni, NodeInst.NODE_PROTO_TD, change)) {
                ++this.numInstancesChanged;
            }
        }
    }

    private boolean processText(ElectricObject owner, String varName, boolean change) {
        TextDescriptor.Size s = owner.getTextDescriptor(varName).getSize();
        boolean changed = false;
        if (change) {
            String nameOfFont;
            TextDescriptor.ActiveFont newFont;
            MutableTextDescriptor td = owner.getMutableTextDescriptor(varName);
            if (this.usePoints.isSelected()) {
                int size = TextUtils.atoi(this.pointSize.getText());
                if (!s.isAbsolute() || s.getSize() != (double)size) {
                    td.setAbsSize(size);
                    changed = true;
                }
            } else {
                double size = TextUtils.atof(this.unitSize.getText());
                if (s.isAbsolute() || s.getSize() != size) {
                    td.setRelSize(size);
                    changed = true;
                }
            }
            int fontIndex = 0;
            if (this.font.getSelectedIndex() != 0 && (newFont = TextDescriptor.ActiveFont.findActiveFont(nameOfFont = (String)this.font.getSelectedItem())) != null) {
                fontIndex = newFont.getIndex();
            }
            if (fontIndex != td.getFace()) {
                td.setFace(fontIndex);
                changed = true;
            }
            if (this.bold.isSelected() != td.isBold()) {
                td.setBold(!td.isBold());
                changed = true;
            }
            if (this.italic.isSelected() != td.isItalic()) {
                td.setItalic(!td.isItalic());
                changed = true;
            }
            if (this.underline.isSelected() != td.isUnderline()) {
                td.setUnderline(!td.isUnderline());
                changed = true;
            }
            if (changed) {
                owner.setTextDescriptor(varName, td);
            }
            return changed;
        }
        double size = s.getSize();
        if (this.numToChange == 0) {
            if (s.isAbsolute()) {
                this.lowPointSize = this.highPointSize = (int)size;
            } else {
                this.lowUnitSize = this.highUnitSize = size;
            }
        } else if (s.isAbsolute()) {
            if ((int)size < this.lowPointSize) {
                this.lowPointSize = (int)size;
            }
            if ((int)size > this.highPointSize) {
                this.highPointSize = (int)size;
            }
        } else {
            if (size < this.lowUnitSize) {
                this.lowUnitSize = size;
            }
            if (size > this.highUnitSize) {
                this.highUnitSize = size;
            }
        }
        ++this.numToChange;
        return false;
    }

    private void initComponents() {
        this.sizeGroup = new ButtonGroup();
        this.whereGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.changeNodeText = new JCheckBox();
        this.changeArcText = new JCheckBox();
        this.changeExportText = new JCheckBox();
        this.changeAnnotationText = new JCheckBox();
        this.changeInstanceText = new JCheckBox();
        this.changeCellText = new JCheckBox();
        this.selectedText = new JLabel();
        this.changeSelectedObjects = new JRadioButton();
        this.changeAllInCell = new JRadioButton();
        this.changeCellsWithView = new JRadioButton();
        this.viewList = new JComboBox();
        this.changeAllInLibrary = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.pointSize = new JTextField();
        this.unitSize = new JTextField();
        this.jLabel2 = new JLabel();
        this.usePoints = new JRadioButton();
        this.useUnits = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.font = new JComboBox();
        this.bold = new JCheckBox();
        this.italic = new JCheckBox();
        this.underline = new JCheckBox();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Change Text Size");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ChangeText.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("What to Change"));
        this.changeNodeText.setText("Change size of node text");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeNodeText, gridBagConstraints);
        this.changeArcText.setText("Change size of arc text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeArcText, gridBagConstraints);
        this.changeExportText.setText("Change size of export text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeExportText, gridBagConstraints);
        this.changeAnnotationText.setText("Change size of annotation text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeAnnotationText, gridBagConstraints);
        this.changeInstanceText.setText("Change size of instance name text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeInstanceText, gridBagConstraints);
        this.changeCellText.setText("Change size of cell text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.changeCellText, gridBagConstraints);
        this.selectedText.setText("No text to change");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.selectedText, gridBagConstraints);
        this.changeSelectedObjects.setText("Change only selected objects");
        this.whereGroup.add(this.changeSelectedObjects);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeSelectedObjects, gridBagConstraints);
        this.changeAllInCell.setText("Change all in this cell");
        this.whereGroup.add(this.changeAllInCell);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeAllInCell, gridBagConstraints);
        this.changeCellsWithView.setText("Change all cells with view:");
        this.whereGroup.add(this.changeCellsWithView);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeCellsWithView, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 20, 2, 4);
        this.jPanel1.add((Component)this.viewList, gridBagConstraints);
        this.changeAllInLibrary.setText("Change all in this library");
        this.whereGroup.add(this.changeAllInLibrary);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.changeAllInLibrary, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder("How to Change it"));
        this.pointSize.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.pointSize, gridBagConstraints);
        this.unitSize.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.unitSize, gridBagConstraints);
        this.jLabel2.setText("Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.usePoints.setText("Points (max 63)");
        this.sizeGroup.add(this.usePoints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.usePoints, gridBagConstraints);
        this.useUnits.setText("Units (max 127.75)");
        this.sizeGroup.add(this.useUnits);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.useUnits, gridBagConstraints);
        this.jLabel3.setText("Font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.font, gridBagConstraints);
        this.bold.setText("Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.jPanel2.add((Component)this.bold, gridBagConstraints);
        this.italic.setText("Italic");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.jPanel2.add((Component)this.italic, gridBagConstraints);
        this.underline.setText("Underline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.jPanel2.add((Component)this.underline, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeText.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.pack();
    }

    private void okActionPerformed(ActionEvent evt) {
        ChangeTextSizes job = new ChangeTextSizes(this);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class ChangeTextSizes
    extends Job {
        ChangeText dialog;

        protected ChangeTextSizes(ChangeText dialog) {
            super("Change Text Size", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            this.dialog.numNodesChanged = (this.dialog.numArcsChanged = (this.dialog.numExportsChanged = 0));
            this.dialog.numAnnotationsChanged = (this.dialog.numInstancesChanged = (this.dialog.numCellsChanged = 0));
            this.dialog.findSelectedText(true);
            if (this.dialog.numNodesChanged != 0 || this.dialog.numArcsChanged != 0 || this.dialog.numExportsChanged != 0 || this.dialog.numAnnotationsChanged != 0 || this.dialog.numInstancesChanged != 0 || this.dialog.numCellsChanged != 0) {
                String what = "Changed text on";
                boolean others = false;
                if (this.dialog.numNodesChanged != 0) {
                    what = what + " " + this.dialog.numNodesChanged + " nodes";
                    others = true;
                }
                if (this.dialog.numArcsChanged != 0) {
                    if (others) {
                        what = what + ", ";
                    }
                    what = what + " " + this.dialog.numArcsChanged + " arcs";
                    others = true;
                }
                if (this.dialog.numExportsChanged != 0) {
                    if (others) {
                        what = what + ", ";
                    }
                    what = what + " " + this.dialog.numExportsChanged + " exports";
                    others = true;
                }
                if (this.dialog.numAnnotationsChanged != 0) {
                    if (others) {
                        what = what + ", ";
                    }
                    what = what + " " + this.dialog.numAnnotationsChanged + " annotations";
                    others = true;
                }
                if (this.dialog.numInstancesChanged != 0) {
                    if (others) {
                        what = what + ", ";
                    }
                    what = what + " " + this.dialog.numInstancesChanged + " instances";
                    others = true;
                }
                if (this.dialog.numCellsChanged != 0) {
                    if (others) {
                        what = what + ", ";
                    }
                    what = what + " " + this.dialog.numCellsChanged + " cells";
                    others = true;
                }
                System.out.println(what);
            }
            return true;
        }
    }
}

