/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NewLocalPartitionWires {
    public static boolean useNewAlgorithm = true;
    private final NccGlobals globals;

    private void cannonizeSignatures(Map wireToSignature) {
        HashMap<Signature, Signature> signatures = new HashMap<Signature, Signature>();
        int sigID = 0;
        Iterator it = wireToSignature.keySet().iterator();
        while (it.hasNext()) {
            Wire w = (Wire)it.next();
            Signature s = (Signature)wireToSignature.get(w);
            Signature cannonicalS = (Signature)signatures.get(s);
            if (cannonicalS == null) {
                cannonicalS = s;
                signatures.put(cannonicalS, cannonicalS);
                cannonicalS.setID(sigID++);
                continue;
            }
            wireToSignature.put(w, cannonicalS);
        }
    }

    private NewLocalPartitionWires(NccGlobals globs) {
        this.globals = globs;
    }

    private void doYourJob() {
        EquivRecord wires = this.globals.getWires();
        if (wires == null) {
            return;
        }
        Map wireToSignature = ComputeSignatures.doYourJob(this.globals);
        this.cannonizeSignatures(wireToSignature);
        LocalPartitionWires.doYourJob(wireToSignature, this.globals);
        SignPartitions.doYourJob(wireToSignature, this.globals);
    }

    public static void doYourJob(NccGlobals globs) {
        NewLocalPartitionWires lpw = new NewLocalPartitionWires(globs);
        lpw.doYourJob();
    }

    private static class SignPartitions
    extends Strategy {
        private Map wireToSignature;
        private Signature lastSignature;

        public LeafList doFor(EquivRecord er) {
            LeafList l = super.doFor(er);
            if (er.isLeaf()) {
                er.setWireSignature(this.lastSignature);
            }
            return l;
        }

        public Integer doFor(NetObject no) {
            this.lastSignature = (Signature)this.wireToSignature.get(no);
            return Strategy.CODE_NO_CHANGE;
        }

        private SignPartitions(Map wireToSignature, NccGlobals globs) {
            super(globs);
            this.wireToSignature = wireToSignature;
        }

        public static void doYourJob(Map wireToSignature, NccGlobals globs) {
            new SignPartitions(wireToSignature, globs).doFor(globs.getWires());
        }
    }

    private static class LocalPartitionWires
    extends Strategy {
        private Map wireToSignature;

        private LocalPartitionWires(Map wireToSignature, NccGlobals globals) {
            super(globals);
            this.wireToSignature = wireToSignature;
        }

        public Integer doFor(NetObject o) {
            Wire w = (Wire)o;
            Signature s = (Signature)this.wireToSignature.get(w);
            return s.getID();
        }

        public static void doYourJob(Map wireToSignature, NccGlobals globs) {
            new LocalPartitionWires(wireToSignature, globs).doFor(globs.getWires());
        }
    }

    private static class ComputeSignatures
    extends Strategy {
        private Map wireToSignature = new HashMap();
        private Signature disconnectedWireSignature = new Signature();

        private void doFor(Wire w) {
            if (w.numParts() == 0) {
                this.wireToSignature.put(w, this.disconnectedWireSignature);
            }
        }

        private void doFor(Part p) {
            int pinNdx = 0;
            Iterator itw = p.getConnected();
            while (itw.hasNext()) {
                Wire w = (Wire)itw.next();
                PinType t = p.getPinTypeOfNthPin(pinNdx);
                Signature s = (Signature)this.wireToSignature.get(w);
                if (s == null) {
                    s = new Signature();
                    this.wireToSignature.put(w, s);
                }
                s.increment(t);
                ++pinNdx;
            }
        }

        public Integer doFor(NetObject no) {
            if (no instanceof Part) {
                this.doFor((Part)no);
            } else if (no instanceof Wire) {
                this.doFor((Wire)no);
            }
            return Strategy.CODE_NO_CHANGE;
        }

        private ComputeSignatures(NccGlobals globs) {
            super(globs);
        }

        private Map doYourJob2() {
            EquivRecord root = this.globals.getRoot();
            if (root != null) {
                this.doFor(root);
            }
            return this.wireToSignature;
        }

        public static Map doYourJob(NccGlobals globs) {
            return new ComputeSignatures(globs).doYourJob2();
        }
    }

    public static class Signature {
        private Map pinTypeToPinTypeCount = new HashMap();
        private Integer id;

        private List getListOfPinTypeCounts() {
            ArrayList<PinTypeCount> l = new ArrayList<PinTypeCount>();
            Iterator it = this.pinTypeToPinTypeCount.keySet().iterator();
            while (it.hasNext()) {
                PinTypeCount c = (PinTypeCount)this.pinTypeToPinTypeCount.get(it.next());
                l.add(c);
            }
            return l;
        }

        public int hashCode() {
            int code = 0;
            Iterator it = this.pinTypeToPinTypeCount.keySet().iterator();
            while (it.hasNext()) {
                PinType t = (PinType)it.next();
                PinTypeCount c = (PinTypeCount)this.pinTypeToPinTypeCount.get(t);
                code += t.hashCode() + c.hashCode();
            }
            return code;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Signature)) {
                return false;
            }
            Signature s2 = (Signature)o;
            if (this.pinTypeToPinTypeCount.size() != s2.pinTypeToPinTypeCount.size()) {
                return false;
            }
            Iterator it = this.pinTypeToPinTypeCount.keySet().iterator();
            while (it.hasNext()) {
                PinTypeCount c2;
                PinType t = (PinType)it.next();
                PinTypeCount c = (PinTypeCount)this.pinTypeToPinTypeCount.get(t);
                if (c.equals(c2 = (PinTypeCount)s2.pinTypeToPinTypeCount.get(t))) continue;
                return false;
            }
            return true;
        }

        public void increment(PinType t) {
            PinTypeCount c = (PinTypeCount)this.pinTypeToPinTypeCount.get(t);
            if (c == null) {
                c = new PinTypeCount(t);
                this.pinTypeToPinTypeCount.put(t, c);
            }
            c.increment();
        }

        public void setID(int id) {
            LayoutLib.error(this.id != null, "assigned a second ID?");
            this.id = new Integer(id);
        }

        public Integer getID() {
            return this.id;
        }

        public List getReasons() {
            List pinTypeCounts = this.getListOfPinTypeCounts();
            Collections.sort(pinTypeCounts, new PinTypeCompare());
            ArrayList<String> pinTypeDescrs = new ArrayList<String>();
            if (pinTypeCounts.size() == 0) {
                pinTypeDescrs.add("disconnected");
            } else {
                Iterator it = pinTypeCounts.iterator();
                while (it.hasNext()) {
                    String descr = ((PinTypeCount)it.next()).description();
                    pinTypeDescrs.add(descr);
                }
            }
            return pinTypeDescrs;
        }
    }

    private static class PinTypeCompare
    implements Comparator {
        private PinTypeCompare() {
        }

        public int compare(Object o1, Object o2) {
            PinTypeCount c1 = (PinTypeCount)o1;
            PinTypeCount c2 = (PinTypeCount)o2;
            String n1 = c1.pinType.description();
            String n2 = c2.pinType.description();
            return TextUtils.STRING_NUMBER_ORDER.compare(n1, n2);
        }
    }

    private static class PinTypeCount {
        private PinType pinType;
        private int count;

        public boolean equals(Object o) {
            if (!(o instanceof PinTypeCount)) {
                return false;
            }
            PinTypeCount p = (PinTypeCount)o;
            return p.count == this.count && p.pinType == this.pinType;
        }

        public int hashCode() {
            return this.pinType.hashCode() * this.count;
        }

        public PinTypeCount(PinType t) {
            this.pinType = t;
        }

        public void increment() {
            ++this.count;
        }

        public String description() {
            return this.count + " " + this.pinType.description();
        }
    }
}

