/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.CellId;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.HeadConnection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.TailConnection;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class ArcInst
extends Geometric
implements Comparable {
    public static final int TAILEND = 0;
    public static final int HEADEND = 1;
    public static final String ARC_NAME_TD;
    public static final Variable.Key ARC_NAME;
    public static final Variable.Key ARC_RADIUS;
    static final double MINPORTDISTANCE;
    private static final Name BASENAME;
    ImmutableArcInst d;
    private Name name;
    private Rectangle2D visBounds;
    final PortInst tailPortInst;
    byte tailShrink;
    private final TailConnection tailEnd;
    final PortInst headPortInst;
    byte headShrink;
    private final HeadConnection headEnd;
    private int arcIndex = -1;
    private static final int MAXARCPIECES = 16;
    private static int[] extendFactor;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ArcInst(Cell parent, ImmutableArcInst d, PortInst headPort, PortInst tailPort) {
        if (!$assertionsDisabled && parent != headPort.getNodeInst().getParent()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parent != tailPort.getNodeInst().getParent()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && d.headNodeId != headPort.getNodeInst().getD().nodeId) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && d.tailNodeId != tailPort.getNodeInst().getD().nodeId) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && d.headPortId != headPort.getPortProto().getId()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && d.tailPortId != tailPort.getPortProto().getId()) {
            throw new AssertionError();
        }
        this.parent = parent;
        this.d = d;
        this.tailPortInst = tailPort;
        this.tailEnd = new TailConnection(this);
        this.headPortInst = headPort;
        this.headEnd = new HeadConnection(this);
        this.visBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    private ArcInst(Cell parent, ArcProto protoType, String name, int duplicate, ImmutableTextDescriptor nameDescriptor, PortInst headPort, PortInst tailPort, EPoint headPt, EPoint tailPt, double width, int angle, int flags) {
        if (!$assertionsDisabled && parent != headPort.getNodeInst().getParent()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parent != tailPort.getNodeInst().getParent()) {
            throw new AssertionError();
        }
        this.parent = parent;
        if (width < 0.0) {
            width = protoType.getWidth();
        }
        width = DBMath.round(width);
        this.name = Name.findName(name);
        if (nameDescriptor == null) {
            nameDescriptor = ImmutableTextDescriptor.getArcTextDescriptor();
        }
        this.tailPortInst = tailPort;
        this.tailEnd = new TailConnection(this);
        this.headPortInst = headPort;
        this.headEnd = new HeadConnection(this);
        int arcId = 0;
        this.d = ImmutableArcInst.newInstance(arcId, protoType, this.name, duplicate, nameDescriptor, this.tailPortInst.getNodeInst().getD().nodeId, this.tailPortInst.getPortProto().getId(), tailPt, this.headPortInst.getNodeInst().getD().nodeId, this.headPortInst.getPortProto().getId(), headPt, width, angle, flags);
        this.visBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public static ArcInst makeInstance(ArcProto type, double width, PortInst head, PortInst tail) {
        return ArcInst.newInstance(type, width, head, tail, null, null, null, 0, type.getDefaultConstraints());
    }

    public static ArcInst makeInstance(ArcProto type, double width, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name) {
        return ArcInst.newInstance(type, width, head, tail, headPt, tailPt, name, 0, type.getDefaultConstraints());
    }

    public static ArcInst makeDummyInstance(ArcProto ap, double arcLength) {
        PrimitiveNode npEnd = ap.findPinProto();
        if (npEnd == null) {
            System.out.println("Cannot find pin for " + ap);
            return null;
        }
        EPoint xPH = new EPoint(-arcLength / 2.0, 0.0);
        NodeInst niH = NodeInst.makeDummyInstance(npEnd, xPH, npEnd.getDefWidth(), npEnd.getDefHeight(), Orientation.IDENT);
        PortInst piH = niH.getOnlyPortInst();
        EPoint xPT = new EPoint(arcLength / 2.0, 0.0);
        NodeInst niT = NodeInst.makeDummyInstance(npEnd, xPT, npEnd.getDefWidth(), npEnd.getDefHeight(), Orientation.IDENT);
        PortInst piT = niT.getOnlyPortInst();
        ImmutableArcInst d = ImmutableArcInst.newInstance(0, ap, BASENAME, 0, ImmutableTextDescriptor.getArcTextDescriptor(), niT.getD().nodeId, piT.getPortProto().getId(), xPT, niH.getD().nodeId, piH.getPortProto().getId(), xPH, ap.getDefaultWidth(), 0, 0);
        ArcInst ai = new ArcInst(null, d, piH, piT);
        ai.updateGeometric();
        return ai;
    }

    public static ArcInst newInstance(ArcProto type, double width, PortInst head, PortInst tail) {
        return ArcInst.newInstance(type, width, head, tail, null, null, null, 0, 0);
    }

    public static ArcInst newInstance(ArcProto type, double width, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name, int defAngle) {
        return ArcInst.newInstance(type, width, head, tail, headPt, tailPt, name, defAngle, 0);
    }

    public static ArcInst newInstance(ArcProto type, double width, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name, int defAngle, int flags) {
        EPoint tailP;
        EPoint headP;
        if (headPt == null) {
            Rectangle2D headBounds = head.getBounds();
            headP = new EPoint(headBounds.getCenterX(), headBounds.getCenterY());
        } else {
            headP = EPoint.snap(headPt);
        }
        if (tailPt == null) {
            Rectangle2D tailBounds = tail.getBounds();
            tailP = new EPoint(tailBounds.getCenterX(), tailBounds.getCenterY());
        } else {
            tailP = EPoint.snap(tailPt);
        }
        Cell parent = head.getNodeInst().getParent();
        Poly headPoly = head.getPoly();
        if (!ArcInst.stillInPoly(headP, headPoly)) {
            System.out.println("Error in " + parent + ": head of " + type.getName() + " arc at (" + headP.getX() + "," + headP.getY() + ") does not fit in " + head + " which is centered at (" + headPoly.getCenterX() + "," + headPoly.getCenterY() + ")");
            return null;
        }
        Poly tailPoly = tail.getPoly();
        if (!ArcInst.stillInPoly(tailP, tailPoly)) {
            System.out.println("Error in " + parent + ": tail of " + type.getName() + " arc at (" + tailP.getX() + "," + tailP.getY() + ") does not fit in " + tail + " which is centered at (" + tailPoly.getCenterX() + "," + tailPoly.getCenterY() + ")");
            return null;
        }
        return ArcInst.newInstance(parent, type, name, -1, null, head, tail, headP, tailP, width, defAngle, flags);
    }

    public static ArcInst newInstance(Cell parent, ArcProto protoType, String name, int duplicate, ImmutableTextDescriptor nameDescriptor, PortInst headPort, PortInst tailPort, EPoint headPt, EPoint tailPt, double width, int angle, int flags) {
        Name nameKey;
        if (protoType == null || headPort == null || tailPort == null || !headPort.isLinked() || !tailPort.isLinked()) {
            return null;
        }
        if (headPt == null || tailPt == null) {
            return null;
        }
        if (parent != headPort.getNodeInst().getParent() || parent != tailPort.getNodeInst().getParent()) {
            System.out.println("ArcProto.newInst: the 2 PortInsts are in different Cells!");
            return null;
        }
        PortProto headProto = headPort.getPortProto();
        PrimitivePort headPrimPort = headProto.getBasePort();
        if (!headPrimPort.connectsTo(protoType)) {
            System.out.println("Cannot create " + protoType + " in " + parent + " because it cannot connect to port " + headProto.getName());
            return null;
        }
        PortProto tailProto = tailPort.getPortProto();
        PrimitivePort tailPrimPort = tailProto.getBasePort();
        if (!tailPrimPort.connectsTo(protoType)) {
            System.out.println("Cannot create " + protoType + " in " + parent + " because it cannot connect to port " + tailProto.getName());
            return null;
        }
        Name name2 = nameKey = name != null ? Name.findName(name) : null;
        if (nameKey == null || nameKey.isTempname() && !parent.isUniqueName(nameKey, NodeInst.class, null) || ArcInst.checkNameKey(nameKey, parent, true)) {
            nameKey = parent.getAutoname(BASENAME);
            duplicate = 0;
        }
        duplicate = parent.fixupArcDuplicate(nameKey, duplicate);
        if (nameDescriptor == null) {
            nameDescriptor = ImmutableTextDescriptor.getArcTextDescriptor();
        }
        if (width < 0.0) {
            width = protoType.getWidth();
        }
        CellId parentId = (CellId)parent.getId();
        ImmutableArcInst d = ImmutableArcInst.newInstance(parentId.newArcId(), protoType, nameKey, duplicate, nameDescriptor, tailPort.getNodeInst().getD().nodeId, tailProto.getId(), tailPt, headPort.getNodeInst().getD().nodeId, headProto.getId(), headPt, width, angle, flags);
        ArcInst ai = new ArcInst(parent, d, headPort, tailPort);
        ai.lowLevelLink();
        Undo.newObject(ai);
        return ai;
    }

    public void kill() {
        if (!this.isLinked()) {
            System.out.println("ArcInst already killed");
            return;
        }
        this.lowLevelUnlink();
        Undo.killObject(this);
    }

    public void modify(double dWidth, double dHeadX, double dHeadY, double dTailX, double dTailY) {
        double oldxA = this.d.headLocation.getX();
        double oldyA = this.d.headLocation.getY();
        double oldxB = this.d.tailLocation.getX();
        double oldyB = this.d.tailLocation.getY();
        double oldWidth = this.getWidth();
        this.lowLevelModify(dWidth, dHeadX, dHeadY, dTailX, dTailY);
        Undo.modifyArcInst(this, oldxA, oldyA, oldxB, oldyB, oldWidth);
    }

    public ArcInst replace(ArcProto ap) {
        if (!this.headPortInst.getPortProto().connectsTo(ap) || !this.tailPortInst.getPortProto().connectsTo(ap)) {
            System.out.println("Cannot replace " + this + " with one of type " + ap.getName() + " because the nodes cannot connect to it");
            return null;
        }
        double newwid = this.getWidth() - this.getProto().getWidthOffset() + ap.getWidthOffset();
        ArcInst newar = ArcInst.newInstance(ap, newwid, this.headPortInst, this.tailPortInst, this.d.headLocation, this.d.tailLocation, null, 0);
        if (newar == null) {
            System.out.println("Cannot replace " + this + " with one of type " + ap.getName() + " because the new arc failed to create");
            return null;
        }
        newar.copyPropertiesFrom(this);
        this.kill();
        newar.setName(this.getName());
        return newar;
    }

    public ImmutableArcInst getD() {
        return this.d;
    }

    public void lowLevelLink() {
        if (!$assertionsDisabled && !this.isDatabaseObject()) {
            throw new AssertionError();
        }
        this.headPortInst.getNodeInst().addConnection(this.headEnd);
        this.tailPortInst.getNodeInst().addConnection(this.tailEnd);
        this.headPortInst.updateShrinkage();
        this.tailPortInst.updateShrinkage();
        this.updateGeometric();
        this.parent.addArc(this);
        this.parent.linkArc(this);
    }

    public void lowLevelUnlink() {
        this.headPortInst.getNodeInst().removeConnection(this.headEnd);
        this.tailPortInst.getNodeInst().removeConnection(this.tailEnd);
        this.parent.removeArc(this);
        this.parent.unLinkArc(this);
        this.headPortInst.updateShrinkage();
        this.tailPortInst.updateShrinkage();
    }

    public void lowLevelModify(double dWidth, double dHeadX, double dHeadY, double dTailX, double dTailY) {
        this.parent.unLinkArc(this);
        EPoint tail = this.d.tailLocation;
        if (dTailX != 0.0 || dTailY != 0.0) {
            tail = new EPoint(tail.getX() + dTailX, tail.getY() + dTailY);
        }
        EPoint head = this.d.headLocation;
        if (dHeadX != 0.0 || dHeadY != 0.0) {
            head = new EPoint(head.getX() + dHeadX, head.getY() + dHeadY);
        }
        this.d = this.d.withWidth(this.d.width + dWidth).withLocations(tail, head);
        this.updateGeometric();
        this.headPortInst.updateShrinkage();
        this.tailPortInst.updateShrinkage();
        this.parent.linkArc(this);
    }

    public double getWidth() {
        return this.d.width;
    }

    public double getLength() {
        return this.d.length;
    }

    public int getAngle() {
        return this.d.angle;
    }

    public void setAngle(int angle) {
        this.checkChanging();
        this.d = this.d.withAngle(angle);
        Undo.otherChange(this);
    }

    public Rectangle2D getBounds() {
        return this.visBounds;
    }

    public Poly makePoly(double width, Poly.Type style) {
        return ArcInst.makePolyForArc(this, this.d.length, width, this.d.headLocation, this.d.tailLocation, style);
    }

    public static Poly makePolyForArc(ArcInst real, double length, double width, EPoint headPt, EPoint tailPt, Poly.Type style) {
        Poly poly;
        Poly curvedPoly;
        Double radiusDouble;
        if (real.getProto().isCurvable() && (radiusDouble = real.getRadius()) != null && (curvedPoly = real.curvedArcOutline(style, width, radiusDouble)) != null) {
            return curvedPoly;
        }
        if (width == 0.0) {
            Poly poly2 = new Poly(new Point2D.Double[]{headPt.mutable(), tailPt.mutable()});
            if (style == Poly.Type.FILLED) {
                style = Poly.Type.OPENED;
            }
            poly2.setStyle(style);
            return poly2;
        }
        double extendH = 0.0;
        if (real.isHeadExtended()) {
            extendH = width / 2.0;
            if (real.headShrink != 0) {
                extendH = ArcInst.getExtendFactor(width, real.headShrink);
            }
        }
        double extendT = 0.0;
        if (real.isTailExtended()) {
            extendT = width / 2.0;
            if (real.tailShrink != 0) {
                extendT = ArcInst.getExtendFactor(width, real.tailShrink);
            }
        }
        if ((poly = Poly.makeEndPointPoly(length, width, real.getAngle(), headPt, extendH, tailPt, extendT)) != null) {
            poly.setStyle(style);
        }
        return poly;
    }

    public Double getRadius() {
        Variable var = this.getVar(ARC_RADIUS);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (obj instanceof Integer) {
            return new Double((double)((Integer)obj).intValue() / 2000.0);
        }
        if (obj instanceof Double) {
            return new Double((Double)obj);
        }
        return null;
    }

    public Poly curvedArcOutline(Poly.Type style, double wid, double radius) {
        int pieces;
        double pureRadius = Math.abs(radius);
        if (pureRadius * 2.0 < this.d.length) {
            return null;
        }
        Point2D[] centers = DBMath.findCenters(pureRadius, this.d.headLocation, this.d.tailLocation, this.d.length);
        if (centers == null) {
            return null;
        }
        Point2D centerPt = centers[1];
        if (radius < 0.0) {
            radius = -radius;
            centerPt = centers[0];
        }
        int angleBase = DBMath.figureAngle(centerPt, this.d.headLocation);
        int angleRange = DBMath.figureAngle(centerPt, this.d.tailLocation);
        if ((angleRange -= angleBase) < 0) {
            angleRange += 3600;
        }
        for (pieces = angleRange; pieces > 16; pieces /= 2) {
        }
        if (pieces == 0) {
            return null;
        }
        int points = (pieces + 1) * 2;
        Point2D[] pointArray = new Point2D[points];
        double outerRadius = radius + wid / 2.0;
        double innerRadius = outerRadius - wid;
        for (int i = 0; i <= pieces; ++i) {
            int a = (angleBase + i * angleRange / pieces) % 3600;
            double sin = DBMath.sin(a);
            double cos = DBMath.cos(a);
            pointArray[i] = new Point2D.Double(cos * innerRadius + centerPt.getX(), sin * innerRadius + centerPt.getY());
            pointArray[points - 1 - i] = new Point2D.Double(cos * outerRadius + centerPt.getX(), sin * outerRadius + centerPt.getY());
        }
        Poly poly = new Poly(pointArray);
        poly.setStyle(style);
        return poly;
    }

    public Poly[] getAllText(boolean hardToSelect, EditWindow_ wnd) {
        int dispVars = this.numDisplayableVariables(false);
        int totalText = dispVars;
        if (totalText == 0) {
            return null;
        }
        Poly[] polys = new Poly[totalText];
        this.addDisplayableVariables(this.getBounds(), polys, 0, wnd, false);
        return polys;
    }

    public static double getExtendFactor(double width, int extend) {
        if (extend <= 0) {
            return width / 2.0;
        }
        if (extend > 90) {
            return width / 2.0;
        }
        return width * 50.0 / (double)extendFactor[extend];
    }

    private void updateGeometric() {
        this.checkChanging();
        Poly poly = this.makePoly(this.d.width, Poly.Type.FILLED);
        this.visBounds.setRect(poly.getBounds2D());
        if (this.parent != null) {
            this.parent.setDirty();
        }
    }

    public TailConnection getTail() {
        return this.tailEnd;
    }

    public HeadConnection getHead() {
        return this.headEnd;
    }

    public Connection getConnection(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.tailEnd;
            }
            case 1: {
                return this.headEnd;
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public PortInst getTailPortInst() {
        return this.tailPortInst;
    }

    public PortInst getHeadPortInst() {
        return this.headPortInst;
    }

    public PortInst getPortInst(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.tailPortInst;
            }
            case 1: {
                return this.headPortInst;
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public EPoint getTailLocation() {
        return this.d.tailLocation;
    }

    public EPoint getHeadLocation() {
        return this.d.headLocation;
    }

    public EPoint getLocation(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.d.tailLocation;
            }
            case 1: {
                return this.d.headLocation;
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean tailStillInPort(Point2D pt, boolean reduceForArc) {
        return this.stillInPort(0, pt, reduceForArc);
    }

    public boolean headStillInPort(Point2D pt, boolean reduceForArc) {
        return this.stillInPort(1, pt, reduceForArc);
    }

    public boolean stillInPort(int connIndex, Point2D pt, boolean reduceForArc) {
        PortInst pi = this.getPortInst(connIndex);
        Poly poly = pi.getPoly();
        if (reduceForArc) {
            double wid = this.getWidth() - this.getProto().getWidthOffset();
            poly.reducePortPoly(pi, wid, this.getAngle());
        }
        return ArcInst.stillInPoly(pt, poly);
    }

    private static boolean stillInPoly(Point2D pt, Poly poly) {
        return poly.isInside(pt) || poly.polyDistance(pt.getX(), pt.getY()) < MINPORTDISTANCE;
    }

    public Name getNameKey() {
        return this.d.name;
    }

    public void lowLevelRename(Name name, int duplicate) {
        this.parent.removeArc(this);
        this.d = this.d.withName(name, this.parent.fixupArcDuplicate(name, duplicate));
        this.parent.addArc(this);
        this.parent.checkInvariants();
    }

    public int getDuplicate() {
        return this.d.duplicate;
    }

    public ImmutableTextDescriptor getTextDescriptor(String varName) {
        if (varName == ARC_NAME_TD) {
            return this.d.nameDescriptor;
        }
        return super.getTextDescriptor(varName);
    }

    public ImmutableTextDescriptor lowLevelSetTextDescriptor(String varName, ImmutableTextDescriptor td) {
        if (varName == ARC_NAME_TD) {
            ImmutableTextDescriptor oldDescriptor = this.d.nameDescriptor;
            this.d = this.d.withNameDescriptor(td.withDisplayWithoutParamAndCode());
            return oldDescriptor;
        }
        return super.lowLevelSetTextDescriptor(varName, td);
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        if (key == ARC_NAME) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    public String describe(boolean withQuotes) {
        String name;
        String description = this.getProto().describe();
        String string = name = withQuotes ? "'" + this.getName() + "'" : this.getName();
        if (name != null) {
            description = description + "[" + name + "]";
        }
        return description;
    }

    public int compareTo(Object obj) {
        int cmp;
        ArcInst that = (ArcInst)obj;
        if (this.parent != that.parent && (cmp = this.parent.compareTo(that.parent)) != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(that.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.d.duplicate - that.d.duplicate;
    }

    public String toString() {
        return "arc " + this.describe(true);
    }

    private void setFlag(ImmutableArcInst.Flag flag, boolean state) {
        this.checkChanging();
        this.d = this.d.withFlag(flag, state);
        Undo.otherChange(this);
    }

    public void setRigid(boolean state) {
        this.setFlag(ImmutableArcInst.RIGID, state);
    }

    public boolean isRigid() {
        return this.d.is(ImmutableArcInst.RIGID);
    }

    public void setFixedAngle(boolean state) {
        this.setFlag(ImmutableArcInst.FIXED_ANGLE, state);
    }

    public boolean isFixedAngle() {
        return this.d.is(ImmutableArcInst.FIXED_ANGLE);
    }

    public void setSlidable(boolean state) {
        this.setFlag(ImmutableArcInst.SLIDABLE, state);
    }

    public boolean isSlidable() {
        return this.d.is(ImmutableArcInst.SLIDABLE);
    }

    public boolean isArrowed(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.isTailArrowed();
            }
            case 1: {
                return this.isHeadArrowed();
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean isTailArrowed() {
        return this.d.is(ImmutableArcInst.TAIL_ARROWED);
    }

    public boolean isHeadArrowed() {
        return this.d.is(ImmutableArcInst.HEAD_ARROWED);
    }

    public boolean isBodyArrowed() {
        return this.d.is(ImmutableArcInst.BODY_ARROWED);
    }

    public void setArrowed(int connIndex, boolean state) {
        switch (connIndex) {
            case 0: {
                this.setTailArrowed(state);
                break;
            }
            case 1: {
                this.setHeadArrowed(state);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailArrowed(boolean state) {
        this.setFlag(ImmutableArcInst.TAIL_ARROWED, state);
    }

    public void setHeadArrowed(boolean state) {
        this.setFlag(ImmutableArcInst.HEAD_ARROWED, state);
    }

    public void setBodyArrowed(boolean state) {
        this.setFlag(ImmutableArcInst.BODY_ARROWED, state);
    }

    public boolean isExtended(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.isTailExtended();
            }
            case 1: {
                return this.isHeadExtended();
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean isTailExtended() {
        return this.d.is(ImmutableArcInst.TAIL_EXTENDED);
    }

    public boolean isHeadExtended() {
        return this.d.is(ImmutableArcInst.HEAD_EXTENDED);
    }

    public void setExtended(int connIndex, boolean e) {
        switch (connIndex) {
            case 0: {
                this.setTailExtended(e);
                break;
            }
            case 1: {
                this.setHeadExtended(e);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailExtended(boolean e) {
        this.setFlag(ImmutableArcInst.TAIL_EXTENDED, e);
        if (this.isLinked()) {
            this.updateGeometric();
        }
    }

    public void setHeadExtended(boolean e) {
        this.setFlag(ImmutableArcInst.HEAD_EXTENDED, e);
        if (this.isLinked()) {
            this.updateGeometric();
        }
    }

    public boolean isNegated(int connIndex) {
        switch (connIndex) {
            case 0: {
                return this.isTailNegated();
            }
            case 1: {
                return this.isHeadNegated();
            }
        }
        throw new IllegalArgumentException("Bad end " + connIndex);
    }

    public boolean isTailNegated() {
        return this.d.is(ImmutableArcInst.TAIL_NEGATED);
    }

    public boolean isHeadNegated() {
        return this.d.is(ImmutableArcInst.HEAD_NEGATED);
    }

    public void setNegated(int connIndex, boolean n) {
        switch (connIndex) {
            case 0: {
                this.setTailNegated(n);
                break;
            }
            case 1: {
                this.setHeadNegated(n);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad end " + connIndex);
            }
        }
    }

    public void setTailNegated(boolean n) {
        this.setFlag(ImmutableArcInst.TAIL_NEGATED, n);
    }

    public void setHeadNegated(boolean n) {
        this.setFlag(ImmutableArcInst.HEAD_NEGATED, n);
    }

    public int checkAndRepair(boolean repair, List list, ErrorLogger errorLogger) {
        ErrorLogger.MessageLog error;
        String msg;
        Poly poly;
        int errorCount = 0;
        ArcProto ap = this.getProto();
        if (ap.isNotUsed()) {
            if (errorLogger != null) {
                String msg2 = "Prototype of arc " + this.getName() + " is unused";
                ErrorLogger.MessageLog error2 = errorLogger.logError(msg2, this.parent, 1);
                error2.addGeom(this, true, this.parent, null);
            }
            if (repair) {
                list.add(this);
            }
            return 1;
        }
        if (!this.headStillInPort(this.d.headLocation, false)) {
            poly = this.headPortInst.getPoly();
            msg = this.parent + ", " + this + ": head not in port, is at (" + this.d.headLocation.getX() + "," + this.d.headLocation.getY() + ") distance to port is " + poly.polyDistance(this.d.headLocation.getX(), this.d.headLocation.getY()) + " port center is (" + poly.getCenterX() + "," + poly.getCenterY() + ")";
            System.out.println(msg);
            if (errorLogger != null) {
                error = errorLogger.logError(msg, this.parent, 1);
                error.addGeom(this, true, this.parent, null);
                error.addGeom(this.headPortInst.getNodeInst(), true, this.parent, null);
            }
            if (repair) {
                this.d = this.d.withLocations(this.d.tailLocation, new EPoint(poly.getCenterX(), poly.getCenterY()));
                this.updateGeometric();
            }
            ++errorCount;
        }
        if (!this.tailStillInPort(this.d.tailLocation, false)) {
            poly = this.tailPortInst.getPoly();
            msg = this.parent + ", " + this + ": tail not in port, is at (" + this.d.tailLocation.getX() + "," + this.d.tailLocation.getY() + ") distance to port is " + poly.polyDistance(this.d.tailLocation.getX(), this.d.tailLocation.getY()) + " port center is (" + poly.getCenterX() + "," + poly.getCenterY() + ")";
            System.out.println(msg);
            if (errorLogger != null) {
                error = errorLogger.logError(msg, this.parent, 1);
                error.addGeom(this, true, this.parent, null);
                error.addGeom(this.tailPortInst.getNodeInst(), true, this.parent, null);
            }
            if (repair) {
                this.d = this.d.withLocations(new EPoint(poly.getCenterX(), poly.getCenterY()), this.d.headLocation);
                this.updateGeometric();
            }
            ++errorCount;
        }
        return errorCount;
    }

    public void check() {
        if (!$assertionsDisabled && this.d.name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.d.duplicate < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.headEnd.getArc() != this) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.tailEnd.getArc() != this) {
            throw new AssertionError();
        }
    }

    public void setArcIndex(int arcIndex) {
        this.arcIndex = arcIndex;
    }

    public final int getArcIndex() {
        return this.arcIndex;
    }

    public boolean isLinked() {
        try {
            return this.parent != null && this.parent.isLinked() && this.parent.getArc(this.arcIndex) == this;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public Name getBasename() {
        return BASENAME;
    }

    public ArcProto getProto() {
        return this.d.protoType;
    }

    public void copyPropertiesFrom(ArcInst fromAi) {
        if (fromAi == null) {
            return;
        }
        this.copyVarsFrom(fromAi);
        this.copyConstraintsFrom(fromAi);
        this.copyTextDescriptorFrom(fromAi, ARC_NAME_TD);
    }

    public void copyConstraintsFrom(ArcInst fromAi) {
        this.checkChanging();
        if (fromAi == null) {
            return;
        }
        int flags = fromAi.d.flags;
        boolean extensionChanged = ImmutableArcInst.TAIL_EXTENDED.is(this.d.flags) != ImmutableArcInst.TAIL_EXTENDED.is(flags) || ImmutableArcInst.HEAD_EXTENDED.is(this.d.flags) != ImmutableArcInst.HEAD_EXTENDED.is(flags);
        this.d = this.d.withFlags(flags).withAngle(fromAi.d.angle);
        if (this.isLinked() && extensionChanged) {
            this.updateGeometric();
        }
        Undo.otherChange(this);
    }

    private void setDefaultConstraints(ArcProto protoType) {
        this.setRigid(protoType.isRigid());
        this.setFixedAngle(protoType.isFixedAngle());
        this.setSlidable(protoType.isSlidable());
        this.setHeadExtended(protoType.isExtended());
        this.setTailExtended(protoType.isExtended());
        this.setHeadArrowed(protoType.isDirectional());
        this.setBodyArrowed(protoType.isDirectional());
    }

    public void setHardSelect(boolean state) {
        this.setFlag(ImmutableArcInst.HARD_SELECT, state);
    }

    public boolean isHardSelect() {
        return this.d.is(ImmutableArcInst.HARD_SELECT);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Poly[] aPolyList;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArcInst a = (ArcInst)obj;
        if (this.getProto().getClass() != a.getProto().getClass()) {
            return false;
        }
        ArcProto arcType = a.getProto();
        Technology tech = arcType.getTechnology();
        if (this.getProto().getTechnology() != tech) {
            if (buffer != null) {
                buffer.append("No same technology for arcs " + this.getName() + " and " + a.getName() + "\n");
            }
            return false;
        }
        Poly[] polyList = this.getProto().getTechnology().getShapeOfArc(this);
        if (polyList.length != (aPolyList = tech.getShapeOfArc(a)).length) {
            if (buffer != null) {
                buffer.append("No same number of geometries in " + this.getName() + " and " + a.getName() + "\n");
            }
            return false;
        }
        ArrayList<Poly> noCheckAgain = new ArrayList<Poly>();
        for (int i = 0; i < polyList.length; ++i) {
            boolean found = false;
            for (int j = 0; j < aPolyList.length; ++j) {
                if (noCheckAgain.contains(aPolyList[j]) || !polyList[i].compare(aPolyList[j], buffer)) continue;
                found = true;
                noCheckAgain.add(aPolyList[j]);
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public Poly cropPerLayer(Poly poly) {
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null) {
            return poly;
        }
        polyBounds = new Rectangle2D.Double(polyBounds.getMinX(), polyBounds.getMinY(), polyBounds.getWidth(), polyBounds.getHeight());
        for (int i = 0; i < 2; ++i) {
            PortInst pi = this.getPortInst(i);
            NodeInst ni = pi.getNodeInst();
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            Poly[] activeCropPolyList = tech.getShapeOfNode(ni);
            int nTot = activeCropPolyList.length;
            for (int k = 0; k < nTot; ++k) {
                Poly nPoly = activeCropPolyList[k];
                if (nPoly.getLayer() != poly.getLayer()) continue;
                nPoly.transform(trans);
                Rectangle2D nPolyBounds = nPoly.getBox();
                if (nPolyBounds == null) continue;
                int result = Poly.cropBoxComplete(polyBounds, nPolyBounds, true);
                if (result == 1) {
                    return null;
                }
                if (result == -2) {
                    System.out.println("When is this case?");
                }
                Poly newPoly = new Poly(polyBounds);
                newPoly.setLayer(poly.getLayer());
                newPoly.setStyle(poly.getStyle());
                return newPoly;
            }
        }
        return poly;
    }

    public boolean isDiffusionArc() {
        return this.getProto().getFunction().isDiffusion();
    }

    public boolean polyPinRepair(EPoint centerPin, Connection con) {
        EPoint arcConP = con.getLocation();
        boolean okRepair = true;
        if (DBMath.areEquals(this.d.angle, 0.0) || DBMath.areEquals(this.d.angle, 1800.0)) {
            if (DBMath.areEquals(centerPin.getX(), arcConP.getX())) {
                this.d = this.d.withLocations(new EPoint(this.d.tailLocation.getX(), centerPin.getY()), new EPoint(this.d.headLocation.getX(), centerPin.getY()));
            } else if (DBMath.areEquals(centerPin.getY(), arcConP.getY())) {
                this.d = con instanceof TailConnection ? this.d.withLocations(new EPoint(centerPin.getX(), this.d.tailLocation.getY()), this.d.headLocation) : this.d.withLocations(this.d.tailLocation, new EPoint(centerPin.getX(), this.d.headLocation.getY()));
            } else {
                System.out.println("Leaving diagonal arc " + this);
                okRepair = false;
            }
        } else if (DBMath.areEquals(this.d.angle, 900.0) || DBMath.areEquals(this.d.angle, 2700.0)) {
            if (DBMath.areEquals(centerPin.getY(), arcConP.getY())) {
                this.d = this.d.withLocations(new EPoint(centerPin.getX(), this.d.tailLocation.getY()), new EPoint(centerPin.getX(), this.d.headLocation.getY()));
            } else if (DBMath.areEquals(centerPin.getX(), arcConP.getX())) {
                this.d = con instanceof TailConnection ? this.d.withLocations(new EPoint(this.d.tailLocation.getX(), centerPin.getY()), this.d.headLocation) : this.d.withLocations(this.d.tailLocation, new EPoint(this.d.headLocation.getX(), centerPin.getY()));
            } else {
                System.out.println("Leaving diagonal arc " + this);
                okRepair = false;
            }
        } else {
            okRepair = false;
        }
        this.updateGeometric();
        return okRepair;
    }

    static {
        $assertionsDisabled = !ArcInst.class.desiredAssertionStatus();
        ARC_NAME_TD = new String("ARC_name");
        ARC_NAME = Variable.newKey("ARC_name");
        ARC_RADIUS = Variable.newKey("ARC_radius");
        MINPORTDISTANCE = DBMath.getEpsilon() * 0.71;
        BASENAME = Name.findName("net@");
        extendFactor = new int[]{0, 11459, 5729, 3819, 2864, 2290, 1908, 1635, 1430, 1271, 1143, 1039, 951, 878, 814, 760, 712, 669, 631, 598, 567, 540, 514, 492, 470, 451, 433, 417, 401, 387, 373, 361, 349, 338, 327, 317, 308, 299, 290, 282, 275, 267, 261, 254, 248, 241, 236, 230, 225, 219, 214, 210, 205, 201, 196, 192, 188, 184, 180, 177, 173, 170, 166, 163, 160, 157, 154, 151, 148, 146, 143, 140, 138, 135, 133, 130, 128, 126, 123, 121, 119, 117, 115, 113, 111, 109, 107, 105, 104, 102, 100};
    }
}

