/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellUsage;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.NodeProtoId;
import java.util.ArrayList;

public final class CellId
implements NodeProtoId {
    public final int cellIndex;
    private volatile CellUsage[] usagesIn = NULL_CELL_USAGE_ARRAY;
    private volatile CellUsage[] hashUsagesIn = EMPTY_HASH;
    private volatile CellUsage[] usagesOf = NULL_CELL_USAGE_ARRAY;
    private volatile ExportId[] exportIds = NULL_EXPORT_ID_ARRAY;
    private volatile int numNodeIds = 0;
    private volatile int numArcIds = 0;
    private static final ArrayList cellIds;
    private static final CellUsage[] NULL_CELL_USAGE_ARRAY;
    private static final CellUsage[] EMPTY_HASH;
    private static final ExportId[] NULL_EXPORT_ID_ARRAY;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellId() {
        ArrayList arrayList = cellIds;
        synchronized (arrayList) {
            this.cellIndex = cellIds.size();
            cellIds.add(this);
        }
    }

    public int numUsagesIn() {
        return this.usagesIn.length;
    }

    public CellUsage getUsageIn(int i) {
        return this.usagesIn[i];
    }

    public int numUsagesOf() {
        return this.usagesOf.length;
    }

    public CellUsage getUsageOf(int i) {
        return this.usagesOf[i];
    }

    public CellUsage getUsageIn(CellId protoId) {
        return this.getUsageIn(protoId, true);
    }

    public int numExportIds() {
        return this.exportIds.length;
    }

    public ExportId getExportId(int chronIndex) {
        return this.exportIds[chronIndex];
    }

    public synchronized ExportId newExportId() {
        ExportId e;
        ExportId[] oldExportIds = this.exportIds;
        ExportId[] newExportIds = new ExportId[oldExportIds.length + 1];
        System.arraycopy(oldExportIds, 0, newExportIds, 0, oldExportIds.length);
        newExportIds[oldExportIds.length] = e = new ExportId(this, oldExportIds.length);
        this.exportIds = newExportIds;
        return e;
    }

    public int newNodeId() {
        return this.numNodeIds++;
    }

    public int newArcId() {
        return this.numArcIds++;
    }

    public NodeProto inCurrentThread() {
        return Cell.inCurrentThread(this);
    }

    public String toString() {
        String s = "CellId#" + this.cellIndex;
        Cell cell = Cell.inCurrentThread(this);
        if (cell != null) {
            s = s + "(" + cell.libDescribe() + ")";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CellUsage getUsageIn(CellId protoId, boolean create) {
        CellUsage u;
        CellUsage[] hash = this.hashUsagesIn;
        int i = protoId.hashCode() & Integer.MAX_VALUE;
        i %= hash.length;
        int j = 1;
        while (hash[i] != null) {
            u = hash[i];
            if (u.protoId == protoId) {
                return u;
            }
            if ((i += j) >= hash.length) {
                i -= hash.length;
            }
            j += 2;
        }
        Class clazz = CellUsage.class;
        synchronized (clazz) {
            if (hash == this.hashUsagesIn && hash[i] == null) {
                if (!create) {
                    return null;
                }
                if (this.usagesIn.length * 2 <= hash.length - 3) {
                    hash[i] = u = new CellUsage(this, protoId, this.usagesIn.length);
                    this.usagesIn = CellId.appendUsage(this.usagesIn, u);
                    protoId.usagesOf = CellId.appendUsage(protoId.usagesOf, u);
                    this.check();
                    return u;
                }
                this.rehash();
            }
            return this.getUsageIn(protoId, create);
        }
    }

    private void rehash() {
        CellUsage[] usagesIn = this.usagesIn;
        int newSize = usagesIn.length * 2 + 3;
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        CellUsage[] newHash = new CellUsage[GenMath.primeSince(newSize)];
        for (int k = usagesIn.length - 1; k >= 0; --k) {
            CellUsage u = usagesIn[k];
            int i = u.protoId.hashCode() & Integer.MAX_VALUE;
            i %= newHash.length;
            int j = 1;
            while (newHash[i] != null) {
                if ((i += j) >= newHash.length) {
                    i -= newHash.length;
                }
                j += 2;
            }
            newHash[i] = u;
        }
        this.hashUsagesIn = newHash;
        this.check();
    }

    private static CellUsage[] appendUsage(CellUsage[] usages, CellUsage newUsage) {
        CellUsage[] newUsages = new CellUsage[usages.length + 1];
        System.arraycopy(usages, 0, newUsages, 0, usages.length);
        newUsages[usages.length] = newUsage;
        return newUsages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkInvariants() {
        int numCellIds;
        ArrayList arrayList = cellIds;
        synchronized (arrayList) {
            numCellIds = cellIds.size();
        }
        for (int i = 0; i < numCellIds; ++i) {
            CellId cellId;
            ArrayList arrayList2 = cellIds;
            synchronized (arrayList2) {
                cellId = (CellId)cellIds.get(i);
            }
            if (!$assertionsDisabled && cellId.cellIndex != i) {
                throw new AssertionError();
            }
            cellId.check();
        }
    }

    void check() {
        this.checkLinked();
        CellUsage[] usagesIn = this.usagesIn;
        for (int k = 0; k < usagesIn.length; ++k) {
            CellUsage u = usagesIn[k];
            if (!$assertionsDisabled && u.parentId != this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && u.indexInParent != k) {
                throw new AssertionError();
            }
            u.protoId.checkLinked();
            u.check();
        }
        this.checkHash();
        CellUsage[] usagesOf = this.usagesOf;
        for (int k = 0; k < usagesOf.length; ++k) {
            CellUsage u = usagesOf[k];
            u.parentId.checkLinked();
            if (!$assertionsDisabled && u != u.parentId.usagesIn[u.indexInParent]) {
                throw new AssertionError();
            }
        }
        ExportId[] exportIds = this.exportIds;
        for (int k = 0; k < exportIds.length; ++k) {
            ExportId e = exportIds[k];
            if (!$assertionsDisabled && e.parentId != this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && e.chronIndex != k) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHash() {
        CellUsage[] hash;
        CellUsage[] usagesIn;
        Class clazz = CellUsage.class;
        synchronized (clazz) {
            usagesIn = this.usagesIn;
            hash = this.hashUsagesIn;
        }
        int count = 0;
        for (int i = 0; i < hash.length; ++i) {
            CellUsage u = hash[i];
            if (u == null) continue;
            if (!$assertionsDisabled && u.parentId != this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && u != usagesIn[u.indexInParent]) {
                throw new AssertionError();
            }
            ++count;
        }
        if (!$assertionsDisabled && usagesIn.length != count) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLinked() {
        ArrayList arrayList = cellIds;
        synchronized (arrayList) {
            if (!$assertionsDisabled && this != cellIds.get(this.cellIndex)) {
                throw new AssertionError();
            }
        }
    }

    static {
        $assertionsDisabled = !CellId.class.desiredAssertionStatus();
        cellIds = new ArrayList();
        NULL_CELL_USAGE_ARRAY = new CellUsage[0];
        EMPTY_HASH = new CellUsage[]{null};
        NULL_EXPORT_ID_ARRAY = new ExportId[0];
    }
}

