/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.PolyQTree;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PolyQTree
implements GeometryHandler {
    private static int MAX_NUM_CHILDREN = 4;
    private static int MAX_NUM_NODES = 10;
    private HashMap layers = new HashMap();
    private Rectangle2D rootBox;

    public PolyQTree(Rectangle2D root) {
        this.rootBox = root;
    }

    public void print() {
        Iterator it = this.getIterator();
        while (it.hasNext()) {
            PolyQNode root = (PolyQNode)it.next();
            if (root == null) continue;
            root.print();
        }
    }

    public Collection getKeySet() {
        return this.layers.keySet();
    }

    public Iterator getKeyIterator() {
        return this.getKeySet().iterator();
    }

    public Iterator getIterator() {
        return this.layers.values().iterator();
    }

    public Collection getObjects(Object layer, boolean modified, boolean simple) {
        HashSet objSet = new HashSet();
        PolyQNode root = (PolyQNode)this.layers.get(layer);
        if (root != null) {
            root.getLeafObjects(objSet, modified, simple);
            HashSet<PolyNode> toRemove = new HashSet<PolyNode>();
            HashSet toAdd = new HashSet();
            Iterator it = objSet.iterator();
            while (it.hasNext()) {
                boolean newC;
                PolyNode node = (PolyNode)it.next();
                boolean old = !node.isOriginal() && simple;
                boolean bl = newC = !node.isOriginal() && simple;
                if (newC != old) {
                    System.out.println("Aqui wribg");
                }
                if (node.isOriginal() || !simple) continue;
                toRemove.add(node);
                toAdd.addAll(node.getSimpleObjects(false));
            }
            objSet.addAll(toAdd);
            objSet.removeAll(toRemove);
        }
        return objSet;
    }

    public void add(Object layer, Object newObj, boolean fasterAlgorithm) {
        HashSet removedElems;
        Rectangle2D areaBB;
        PolyNode obj = (PolyNode)newObj;
        PolyQNode root = (PolyQNode)this.layers.get(layer);
        if (root == null) {
            root = new PolyQNode();
            this.layers.put(layer, root);
        }
        if (!root.findAndRemoveObjects(this.rootBox, obj, areaBB = obj.getBounds2D(), fasterAlgorithm, removedElems = new HashSet())) {
            Iterator it = removedElems.iterator();
            while (it.hasNext()) {
                PolyNode node = (PolyNode)it.next();
                obj.add(node);
            }
            areaBB = obj.getBounds2D();
            root.insert(this.rootBox, obj, areaBB, removedElems);
        }
    }

    public void addAll(GeometryHandler subMerge, AffineTransform trans) {
        PolyQTree other = (PolyQTree)subMerge;
        Iterator it = other.layers.keySet().iterator();
        while (it.hasNext()) {
            Object layer = it.next();
            Set set = (Set)other.getObjects(layer, false, false);
            Iterator i = set.iterator();
            while (i.hasNext()) {
                PolyNode geo = (PolyNode)i.next();
                PolyNode clone = new PolyNode(geo);
                clone.transform(trans);
                this.add(layer, clone, false);
            }
        }
    }

    private static class PolyQNode {
        private Set nodes;
        private PolyQNode[] children;

        private PolyQNode() {
        }

        private int getQuadrants(double centerX, double centerY, Rectangle2D box) {
            int loc = 0;
            if (box.getMinY() < centerY) {
                if (box.getMinX() < centerX) {
                    loc |= 1;
                }
                if (box.getMaxX() > centerX) {
                    loc |= 2;
                }
            }
            if (box.getMaxY() > centerY) {
                if (box.getMinX() < centerX) {
                    loc |= 4;
                }
                if (box.getMaxX() > centerX) {
                    loc |= 8;
                }
            }
            return loc;
        }

        private Rectangle2D getBox(double x, double y, double w, double h, double centerX, double centerY, int loc) {
            if ((loc >> 0 & 1) == 1) {
                x = centerX;
            }
            if ((loc >> 1 & 1) == 1) {
                y = centerY;
            }
            return new Rectangle2D.Double(x, y, w, h);
        }

        protected void getLeafObjects(Set set, boolean modified, boolean simple) {
            if (this.nodes != null) {
                Iterator it = this.nodes.iterator();
                while (it.hasNext()) {
                    PolyNode node = (PolyNode)it.next();
                    if (modified && (!modified || node.isOriginal())) continue;
                    set.add(node);
                }
            }
            if (this.children == null) {
                return;
            }
            for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].getLeafObjects(set, modified, simple);
            }
        }

        protected void print() {
            if (this.nodes == null) {
                return;
            }
            Iterator it = this.nodes.iterator();
            while (it.hasNext()) {
                System.out.println("Area " + it.next());
            }
            if (this.children == null) {
                return;
            }
            for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                if (this.children[i] == null) continue;
                this.children[i].print();
            }
        }

        private boolean compact() {
            if (this.children != null) {
                for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                    if (this.children[i] == null) continue;
                    return false;
                }
            }
            return this.nodes == null || this.nodes.isEmpty();
        }

        private static boolean intersects(Rectangle2D a, Rectangle2D b) {
            double x = b.getX();
            double y = b.getY();
            double w = b.getWidth();
            double h = b.getHeight();
            if (a.isEmpty() || w <= 0.0 || h <= 0.0) {
                return false;
            }
            double x0 = a.getX();
            double y0 = a.getY();
            return x + w >= x0 && y + h >= y0 && x <= x0 + a.getWidth() && y <= y0 + a.getHeight();
        }

        protected boolean findAndRemoveObjects(Rectangle2D box, PolyNode obj, Rectangle2D areaBB, boolean fasterAlgorithm, Set removedElems) {
            double centerX = box.getCenterX();
            double centerY = box.getCenterY();
            if (this.children != null) {
                int loc = this.getQuadrants(centerX, centerY, areaBB);
                double w = box.getWidth() / 2.0;
                double h = box.getHeight() / 2.0;
                double x = box.getX();
                double y = box.getY();
                for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                    if ((loc >> i & 1) != 1) continue;
                    Rectangle2D bb = this.getBox(x, y, w, h, centerX, centerY, i);
                    if (this.children[i] == null) continue;
                    if (this.children[i].findAndRemoveObjects(bb, obj, areaBB, fasterAlgorithm, removedElems)) {
                        return true;
                    }
                    if (!this.children[i].compact()) continue;
                    this.children[i] = null;
                }
            } else if (this.nodes != null) {
                HashSet<PolyNode> deleteSet = new HashSet<PolyNode>();
                Iterator it = this.nodes.iterator();
                while (it.hasNext()) {
                    PolyNode node = (PolyNode)it.next();
                    if (node.equals((Object)obj)) {
                        if (removedElems.size() != 0) {
                            System.out.println("I will have problems here!!");
                        }
                        return true;
                    }
                    if (fasterAlgorithm && (!fasterAlgorithm || !node.intersects(obj))) continue;
                    removedElems.add(node);
                    obj.setNotOriginal();
                    deleteSet.add(node);
                }
                this.nodes.removeAll(deleteSet);
                if (this.nodes.size() == 0) {
                    this.nodes.clear();
                    this.nodes = null;
                }
            }
            return false;
        }

        protected boolean insertInAllChildren(Rectangle2D box, double centerX, double centerY, PolyNode obj, Rectangle2D areaBB, Set removedElems) {
            int loc = this.getQuadrants(centerX, centerY, areaBB);
            boolean inserted = false;
            double w = box.getWidth() / 2.0;
            double h = box.getHeight() / 2.0;
            double x = box.getX();
            double y = box.getY();
            for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                if ((loc >> i & 1) != 1) continue;
                Rectangle2D bb = this.getBox(x, y, w, h, centerX, centerY, i);
                if (this.children[i] == null) {
                    this.children[i] = new PolyQNode();
                }
                boolean done = this.children[i].insert(bb, obj, areaBB, removedElems);
                inserted = inserted ? inserted : done;
            }
            return inserted;
        }

        protected boolean insert(Rectangle2D box, PolyNode obj, Rectangle2D areaBB, Set removedElems) {
            if (!box.intersects(areaBB)) {
                return false;
            }
            double centerX = box.getCenterX();
            double centerY = box.getCenterY();
            if (this.children != null) {
                return this.insertInAllChildren(box, centerX, centerY, obj, areaBB, removedElems);
            }
            if (this.nodes == null) {
                this.nodes = new HashSet();
            }
            boolean inserted = false;
            if (this.nodes.size() < MAX_NUM_NODES) {
                inserted = this.nodes.add(obj);
                if (removedElems != null) {
                    this.nodes.removeAll(removedElems);
                }
            } else {
                this.children = new PolyQNode[MAX_NUM_CHILDREN];
                double w = box.getWidth() / 2.0;
                double h = box.getHeight() / 2.0;
                double x = box.getX();
                double y = box.getY();
                for (int i = 0; i < MAX_NUM_CHILDREN; ++i) {
                    this.children[i] = new PolyQNode();
                    Rectangle2D bb = this.getBox(x, y, w, h, centerX, centerY, i);
                    Iterator it = this.nodes.iterator();
                    while (it.hasNext()) {
                        PolyNode node = (PolyNode)it.next();
                        this.children[i].insert(bb, node, node.getBounds2D(), removedElems);
                    }
                }
                this.nodes.clear();
                this.nodes = null;
                inserted = this.insertInAllChildren(box, centerX, centerY, obj, areaBB, null);
            }
            return inserted;
        }
    }

    public static class PolyNode
    extends Area
    implements Comparable {
        private byte original;

        public PolyNode(Shape shape) {
            super(shape);
        }

        public int compareTo(Object o1) {
            PolyNode n1 = (PolyNode)o1;
            return (int)(this.getArea() - n1.getArea());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Area)) {
                return obj.equals(this);
            }
            Area a = (Area)obj;
            return super.equals(a);
        }

        public int hasCode() {
            throw new UnsupportedOperationException();
        }

        public Point2D[] getPoints() {
            PathIterator pi = this.getPathIterator(null);
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            Point2D.Double lastMoveTo = null;
            while (!pi.isDone()) {
                int type = pi.currentSegment(coords);
                switch (type) {
                    case 4: {
                        if (lastMoveTo != null) {
                            pointList.add(lastMoveTo);
                        }
                        lastMoveTo = null;
                        break;
                    }
                    default: {
                        Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                        if (type != 0) break;
                        lastMoveTo = pt;
                    }
                }
                pi.next();
            }
            Point2D[] points = new Point2D[pointList.size()];
            return pointList.toArray(points);
        }

        public double getPerimeter() {
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            double perimeter = 0.0;
            PathIterator pi = this.getPathIterator(null);
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 4: {
                        Object[] points = pointList.toArray();
                        for (int i = 0; i < pointList.size(); ++i) {
                            int j = (i + 1) % pointList.size();
                            perimeter += ((Point2D)points[i]).distance((Point2D)points[j]);
                        }
                        pointList.clear();
                        break;
                    }
                    default: {
                        Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                pi.next();
            }
            return perimeter;
        }

        public boolean doesTouch(PathIterator opi) {
            Point2D.Double pt;
            int j;
            int i;
            Object[] points;
            class PolyEdge {
                private Point2D p1;
                private Point2D p2;
                private final /* synthetic */ PolyNode this$0;

                PolyEdge(PolyNode this$0, Point2D a, Point2D b) {
                    this.this$0 = this$0;
                    this.p1 = a;
                    this.p2 = b;
                }

                public int hashCode() {
                    return this.p1.hashCode() ^ this.p2.hashCode();
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof PolyEdge)) {
                        return false;
                    }
                    PolyEdge edge = (PolyEdge)obj;
                    return this.p1.equals(edge.p1) && this.p2.equals(edge.p2) || this.p1.equals(edge.p2) && this.p2.equals(edge.p1);
                }
            }
            HashMap<PolyEdge, PolyEdge> edges = new HashMap<PolyEdge, PolyEdge>();
            PathIterator pi = this.getPathIterator(null);
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 4: {
                        points = pointList.toArray();
                        for (i = 0; i < pointList.size(); ++i) {
                            j = (i + 1) % pointList.size();
                            PolyEdge edge = new PolyEdge(this, (Point2D)points[i], (Point2D)points[j]);
                            edges.put(edge, edge);
                        }
                        pointList.clear();
                        break;
                    }
                    default: {
                        pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                pi.next();
            }
            while (!opi.isDone()) {
                switch (opi.currentSegment(coords)) {
                    case 4: {
                        points = pointList.toArray();
                        for (i = 0; i < pointList.size(); ++i) {
                            Point2D p1 = (Point2D)points[i];
                            j = (i + 1) % pointList.size();
                            Point2D p2 = (Point2D)points[j];
                            if (p1.equals(p2)) continue;
                            PolyEdge edge = new PolyEdge(this, p1, p2);
                            if (edges.containsKey(edge)) {
                                return true;
                            }
                            edges.put(edge, edge);
                        }
                        pointList.clear();
                        break;
                    }
                    default: {
                        pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                opi.next();
            }
            return false;
        }

        public double getArea() {
            if (this.isRectangular()) {
                Rectangle2D bounds = this.getBounds2D();
                return bounds.getHeight() * bounds.getWidth();
            }
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            double area = 0.0;
            PathIterator pi = this.getPathIterator(null);
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 4: {
                        Object[] points = pointList.toArray();
                        for (int i = 0; i < pointList.size(); ++i) {
                            int j = (i + 1) % pointList.size();
                            area += ((Point2D)points[i]).getX() * ((Point2D)points[j]).getY();
                            area -= ((Point2D)points[j]).getX() * ((Point2D)points[i]).getY();
                        }
                        pointList.clear();
                        break;
                    }
                    default: {
                        Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                pi.next();
            }
            return (area /= 2.0) < 0.0 ? -area : area;
        }

        public String toString() {
            return "PolyNode " + this.getBounds();
        }

        public boolean intersects(Area a) {
            if (a.isRectangular()) {
                boolean inter = this.intersects(a.getBounds2D());
                if (inter) {
                    return inter;
                }
                inter = this.doesTouch(a.getBounds2D().getPathIterator(null));
                return inter;
            }
            if (this.isRectangular()) {
                return a.intersects(this.getBounds2D());
            }
            Area area = (Area)this.clone();
            area.intersect(a);
            boolean inter = !area.isEmpty();
            return inter;
        }

        private boolean isOriginal() {
            return (this.original >> 0 & 1) == 0;
        }

        private void setNotOriginal() {
            this.original = (byte)(this.original | 1);
        }

        private Collection getSimpleObjects(boolean simple) {
            HashSet<PolyNode> set = new HashSet<PolyNode>();
            double[] coords = new double[6];
            ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
            PathIterator pi = this.getPathIterator(null);
            ArrayList<GeneralPath> polyList = new ArrayList<GeneralPath>();
            boolean isSingular = this.isSingular();
            ArrayList<GeneralPath> toDelete = new ArrayList<GeneralPath>();
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 4: {
                        Object[] points = pointList.toArray();
                        GeneralPath simplepath = new GeneralPath();
                        for (int i = 0; i < pointList.size(); ++i) {
                            int j = (i + 1) % pointList.size();
                            Line2D.Double line = new Line2D.Double((Point2D)points[i], (Point2D)points[j]);
                            simplepath.append(line, true);
                        }
                        toDelete.clear();
                        if (!simple && !isSingular) {
                            Iterator it = polyList.iterator();
                            while (it.hasNext()) {
                                GeneralPath pn = (GeneralPath)it.next();
                                if (pn.contains((Point2D)pointList.get(0))) {
                                    pn.append(simplepath.getPathIterator(null), true);
                                    simplepath = null;
                                    break;
                                }
                                if (!simplepath.contains(pn.getCurrentPoint())) continue;
                                simplepath.append(pn.getPathIterator(null), true);
                                toDelete.add(pn);
                            }
                        }
                        if (simplepath != null) {
                            polyList.add(simplepath);
                        }
                        polyList.removeAll(toDelete);
                        pointList.clear();
                        break;
                    }
                    default: {
                        Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                        pointList.add(pt);
                    }
                }
                pi.next();
            }
            Iterator it = polyList.iterator();
            while (it.hasNext()) {
                GeneralPath pn = (GeneralPath)it.next();
                PolyNode node = new PolyNode(pn);
                set.add(node);
            }
            return set;
        }

        public List getSortedLoops() {
            Collection set = this.getSimpleObjects(true);
            ArrayList list = new ArrayList(set);
            Collections.sort(list);
            return list;
        }
    }
}

