/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.tool.ncc.basic.Messenger;
import com.sun.electric.tool.ncc.jemNets.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.NetObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class Port
extends NetObject {
    private Wire wire;
    private HashSet names = new HashSet();

    public Port(String name, Wire w) {
        super("");
        this.wire = w;
        this.names.add(name);
    }

    public NetObject.Type getNetObjType() {
        return NetObject.Type.PORT;
    }

    public Iterator getConnected() {
        return new ArrayList().iterator();
    }

    public void addExportName(String nm) {
        this.names.add(nm);
    }

    public Wire getWire() {
        return this.wire;
    }

    public String connectionString(int n) {
        return "is on Wire: " + this.wire.getName();
    }

    public void checkMe(Circuit parent) {
        Port.error(parent != this.getParent(), "wrong parent");
        Port.error(this.wire == null, this.nameString() + " has null connection");
        Port.error(!this.wire.touches(this), this.nameString() + " has inconsistant connection to " + this.wire.nameString());
    }

    public String exportNamesString() {
        String s = "";
        Iterator it = this.names.iterator();
        while (it.hasNext()) {
            if (s.length() != 0) {
                s = s + " ";
            }
            s = s + (String)it.next();
        }
        return s;
    }

    public String nameString() {
        return "Port " + this.exportNamesString();
    }

    public Iterator getExportNames() {
        return this.names.iterator();
    }

    public void printMe(int maxCon, Messenger messenger) {
        messenger.print("Port on wire: " + this.wire.getName() + " has Export names:");
        Iterator it = this.names.iterator();
        while (it.hasNext()) {
            String nm = (String)it.next();
            messenger.print(" " + nm);
        }
        messenger.println();
    }
}

