/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import [Ljava.lang.Float;;
import [Ljava.lang.Integer;;
import [Ljava.lang.String;;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.io.input.ELIB;
import com.sun.electric.tool.io.input.LibDirs;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.input.ReadableDump;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.Progress;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import javax.swing.ProgressMonitorInputStream;

public class Input {
    protected static final int READ_BUFFER_SIZE = 65536;
    public static final Variable.Key IO_TRUE_LIBRARY = ElectricObject.newKey("IO_true_library");
    public static final Variable.Key IO_DUMMY_OBJECT = ElectricObject.newKey("IO_dummy_object");
    protected static ErrorLogger errorLogger;
    protected String filePath;
    protected Library lib;
    protected InputStream inputStream;
    protected LineNumberReader lineReader;
    protected DataInputStream dataInputStream;
    protected long fileLength;
    protected static Progress progress;
    protected static String mainLibDirectory;
    protected boolean topLevelLibrary;
    protected int byteCount;
    private static String[] fontNames;
    ProgressMonitorInputStream is = null;

    Input() {
    }

    public static synchronized Library readLibrary(URL fileURL, OpenFile.Type type) {
        if (fileURL == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        errorLogger = ErrorLogger.newInstance("Library Read");
        LibDirs.readLibDirs();
        LibraryFiles.initializeLibraryInput();
        Undo.changesQuiet(true);
        Pref.initMeaningVariableGathering();
        Input.startProgressDialog("library", fileURL.getFile());
        StringBuffer errmsg = new StringBuffer();
        boolean exists = TextUtils.URLExists(fileURL, errmsg);
        Library lib = null;
        if (!exists) {
            System.out.print(errmsg.toString());
        } else {
            lib = Input.readALibrary(fileURL, null, type);
        }
        LibraryFiles.cleanupLibraryInput();
        Input.stopProgressDialog();
        Undo.changesQuiet(false);
        Network.reload();
        if (lib != null) {
            long endTime = System.currentTimeMillis();
            float finalTime = (float)(endTime - startTime) / 1000.0f;
            System.out.println("Library " + fileURL.getFile() + " read, took " + finalTime + " seconds");
        }
        Pref.reconcileMeaningVariables();
        errorLogger.termLogging(true);
        return lib;
    }

    /*
     * WARNING - void declaration
     */
    protected static Library readALibrary(URL fileURL, Library lib, OpenFile.Type type) {
        void var5_5;
        LibraryFiles in;
        String libName = TextUtils.getFileNameWithoutExtension(fileURL);
        String extension = TextUtils.getExtension(fileURL);
        if (type == OpenFile.Type.ELIB) {
            in = new ELIB();
            if (in.openBinaryInput(fileURL)) {
                return null;
            }
        } else if (type == OpenFile.Type.READABLEDUMP) {
            in = new ReadableDump();
            if (in.openTextInput(fileURL)) {
                return null;
            }
        } else {
            System.out.println("Unknown import type: " + type);
            return null;
        }
        var5_5.topLevelLibrary = false;
        if (lib == null) {
            mainLibDirectory = TextUtils.getFilePath(fileURL);
            var5_5.topLevelLibrary = true;
        }
        if (lib == null) {
            lib = Library.findLibrary(libName);
            if (lib != null) {
                if (FileMenu.preventLoss(lib, 2)) {
                    return null;
                }
                WindowFrame.removeLibraryReferences(lib);
                lib.erase();
            } else {
                lib = Library.newInstance(libName, fileURL);
            }
        }
        var5_5.lib = lib;
        boolean error = var5_5.readInputLibrary();
        var5_5.closeInput();
        if (error) {
            System.out.println("Error reading library " + lib.getName());
            if (var5_5.topLevelLibrary) {
                mainLibDirectory = null;
            }
            return null;
        }
        return var5_5.lib;
    }

    protected void scaleOutlineInformation(NodeInst ni, NodeProto np, double lambdaX, double lambdaY) {
        if (!(np instanceof PrimitiveNode)) {
            return;
        }
        if (!np.isHoldsOutline()) {
            return;
        }
        Variable var = ni.getVar(NodeInst.TRACE, Integer;.class);
        if (var != null) {
            Integer[] outline = (Integer[])var.getObject();
            int newLength = outline.length / 2;
            Point2D[] newOutline = new Point2D[newLength];
            for (int j = 0; j < newLength; ++j) {
                double oldX = outline[j * 2].intValue();
                double oldY = outline[j * 2 + 1].intValue();
                newOutline[j] = new Point2D.Double(oldX / lambdaX, oldY / lambdaY);
            }
            Variable newVar = ni.newVar(NodeInst.TRACE, (Object)newOutline);
            if (newVar == null) {
                System.out.println("Could not preserve outline information on node in cell " + ni.getParent().describe());
            }
            return;
        }
        var = ni.getVar(NodeInst.TRACE, Float;.class);
        if (var != null) {
            Float[] outline = (Float[])var.getObject();
            int newLength = outline.length / 2;
            Point2D[] newOutline = new Point2D[newLength];
            for (int j = 0; j < newLength; ++j) {
                double oldX = outline[j * 2].floatValue();
                double oldY = outline[j * 2 + 1].floatValue();
                newOutline[j] = new Point2D.Double(oldX, oldY);
            }
            Variable newVar = ni.newVar(NodeInst.TRACE, (Object)newOutline);
            if (newVar == null) {
                System.out.println("Could not preserve outline information on node in cell " + ni.getParent().describe());
            }
            return;
        }
    }

    protected Name makeGeomName(Geometric geom, Object value, int type) {
        if (value == null || !(value instanceof String)) {
            return null;
        }
        String str = (String)value;
        Name name = Name.findName(str);
        if ((type & 0x40) != 0) {
            if (name.isTempname()) {
                String newS = "";
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if (c == '@') {
                        c = '_';
                    }
                    newS = newS + c;
                }
                name = Name.findName(newS);
            }
        } else if (!name.isTempname()) {
            return null;
        }
        return name;
    }

    public static void getFontAssociationVariable(Library lib) {
        int fontNumber;
        int i;
        fontNames = null;
        Variable var = lib.getVar(Library.FONT_ASSOCIATIONS, String;.class);
        if (var == null) {
            return;
        }
        String[] associationArray = (String[])var.getObject();
        int maxAssociation = 0;
        for (i = 0; i < associationArray.length; ++i) {
            fontNumber = TextUtils.atoi(associationArray[i]);
            if (fontNumber <= maxAssociation) continue;
            maxAssociation = fontNumber;
        }
        if (maxAssociation <= 0) {
            return;
        }
        fontNames = new String[maxAssociation];
        for (i = 0; i < maxAssociation; ++i) {
            Input.fontNames[i] = null;
        }
        for (i = 0; i < associationArray.length; ++i) {
            int slashPos;
            fontNumber = TextUtils.atoi(associationArray[i]);
            if (fontNumber <= 0 || (slashPos = associationArray[i].indexOf(47)) < 0) continue;
            Input.fontNames[fontNumber - 1] = associationArray[i].substring(slashPos + 1);
        }
        lib.delVar(Library.FONT_ASSOCIATIONS);
    }

    public static void fixVariableFont(ElectricObject eobj) {
        if (eobj == null) {
            return;
        }
        Iterator it = eobj.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            Input.fixTextDescriptorFont(var.getTextDescriptor());
        }
    }

    public static void fixTextDescriptorFont(TextDescriptor td) {
        int fontNumber = td.getFace();
        if (fontNumber == 0) {
            return;
        }
        if (fontNames == null) {
            fontNumber = 0;
        } else if (fontNumber <= fontNames.length) {
            String fontName = fontNames[fontNumber - 1];
            TextDescriptor.ActiveFont af = TextDescriptor.ActiveFont.findActiveFont(fontName);
            fontNumber = af == null ? 0 : af.getIndex();
        }
        td.setFace(fontNumber);
    }

    protected boolean openBinaryInput(URL fileURL) {
        this.filePath = fileURL.getFile();
        URLConnection urlCon = null;
        try {
            urlCon = fileURL.openConnection();
            this.fileLength = urlCon.getContentLength();
            this.inputStream = urlCon.getInputStream();
        }
        catch (IOException e) {
            System.out.println("Could not find file: " + this.filePath);
            return true;
        }
        this.byteCount = 0;
        BufferedInputStream bufStrm = new BufferedInputStream(this.inputStream, 65536);
        this.dataInputStream = new DataInputStream(bufStrm);
        return false;
    }

    protected boolean openTextInput(URL fileURL) {
        if (this.openBinaryInput(fileURL)) {
            return true;
        }
        InputStreamReader is = new InputStreamReader(this.inputStream);
        this.lineReader = new LineNumberReader(is);
        return false;
    }

    protected static void startProgressDialog(String type, String filePath) {
        progress = new Progress("Reading " + type + " " + filePath + "...");
        progress.setProgress(0);
    }

    protected static void stopProgressDialog() {
        progress.close();
        progress = null;
    }

    protected void updateProgressDialog(int bytesRead) {
        this.byteCount += bytesRead;
        if (progress != null && this.fileLength > 0L) {
            progress.setProgress((int)((long)(this.byteCount * 100) / this.fileLength));
        }
    }

    protected void closeInput() {
        if (this.inputStream == null) {
            return;
        }
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing file");
        }
    }

    protected String getLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.lineReader.read()) == -1) {
                return null;
            }
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected String getLineFromBinary() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.dataInputStream.read()) == -1) {
                return null;
            }
            if (c == 10 || c == 13) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    static {
        progress = null;
        mainLibDirectory = null;
        fontNames = null;
    }

    protected static class FakeCell {
        String cellName;
        NodeProto firstInCell;

        protected FakeCell() {
        }
    }
}

