/*
 * Electric(tm) VLSI Design System
 *
 * File: sc1command.c
 * Command table for the QUISC Silicon Compiler to interface it with Electric
 * Written by: Andrew R. Kostiuk, Queen's University
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#include "config.h"
#if SCAID

#include "global.h"


/***********************************************************************
	QUISC SILICON COMPILER Command Completion Tables
-----------------------------------------------------------------------
*/

/*>>>>>>>>>>>>>>>>>>>> CONNECT command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_connap = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "name of node a", 0};

static COMCOMP sc_conpap = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "port on node a", 0};

static KEYWORD sc_conb[] = {
	{"power",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"ground",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_connbp = {sc_conb,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "name of node b", 0};

static COMCOMP sc_conpbp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "port on node b", 0};


/*>>>>>>>>>>>>>>>>>>>> CREATE command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_cellp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "name of cell", 0};

static COMCOMP sc_crinstnp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "instance name", 0};

static COMCOMP sc_crinsttp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "instance type", 0};

static KEYWORD sc_createopt[] =
{
	{"cell",		1,{&sc_cellp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"instance",	2,{&sc_crinstnp,&sc_crinsttp,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_createp = {sc_createopt,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "create option", 0};


/*>>>>>>>>>>>>>>>>>>>> EXPORT command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_exportnp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "name of instance", 0};

static COMCOMP sc_exportpp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "name of port on instance", 0};

static COMCOMP sc_exportpnp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "name of port", 0};

static KEYWORD sc_exportopt[] =
{
	{"bidirectional",	0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"input",			0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"output",			0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_exporttp = {sc_exportopt,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP,0, " \t", "type of port", 0};


/*>>>>>>>>>>>>>>>>>>>> EXTRACT command <<<<<<<<<<<<<<<<<<<<*/

static KEYWORD sc_echo[] =
{
	{"echo",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_extractp = {sc_echo,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "optional echo flag", 0};


/*>>>>>>>>>>>>>>>>>>>> LIBRARY command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_libusep = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "name of library", 0};

static KEYWORD sc_libopt[] =
{
	{"read",		1,{&sc_libusep,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_libp = {sc_libopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "library option", 0};


/*>>>>>>>>>>>>>>>>>>>> MAKE command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_makemsp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Minimum spacing (in internal units)", 0};

static COMCOMP sc_makevsp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Via Size (internal units)", 0};

static COMCOMP sc_makeavp = {NOKEYWORD,us_topofarcs,us_nextparse,NOPARAMS,
	NOBACKUP, 0, " \t", "Arc type to use for vertical wires", 0};

static COMCOMP sc_makeahp = {NOKEYWORD,us_topofarcs,us_nextparse,NOPARAMS,
	NOBACKUP, 0, " \t", "Arc type to use for horizontal wires", 0};

static COMCOMP sc_makevtp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Layer2 Track width (internal units)", 0};

static COMCOMP sc_makehtp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Layer1 Track width (internal units)", 0};

static COMCOMP sc_makeptp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Power Track width (internal units)", 0};

static COMCOMP sc_makemtp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Main Power Bus width (internal units)", 0};

static COMCOMP sc_makepwsp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "P-well Size (internal units)", 0};

static COMCOMP sc_makepwop = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "P-well Offset from bottom (internal units)", 0};

static KEYWORD sc_makesetopt[] =
{
	{"verbose",			0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"no-verbose",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"min-spacing",		1,{&sc_makemsp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"via-size",		1,{&sc_makevsp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"arc-horizontal",	1,{&sc_makeahp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"arc-vertical",	1,{&sc_makeavp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"l1-track-width",	1,{&sc_makehtp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"l2-track-width",	1,{&sc_makevtp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"power-track-width",1,{&sc_makeptp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"main-power-width",1,{&sc_makemtp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"p-well-size",		1,{&sc_makepwsp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"p-well-offset",	1,{&sc_makepwop,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"default",			0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_makesetp = {sc_makesetopt,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "Make set-control option", 0};

static KEYWORD sc_makeopt[] =
{
	{"information",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"set-control",		5,{&sc_makesetp,&sc_makesetp,&sc_makesetp,
								  &sc_makesetp,&sc_makesetp}},
	{"show-control",	0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

COMCOMP sc_makep = {sc_makeopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Make option", 0};


/*>>>>>>>>>>>>>>>>>>>> ORDER command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_orderp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "leaf cell to order ports", 0};

static COMCOMP sc_orderfp = {NOKEYWORD,topoffile,nextfile,NOPARAMS,NOBACKUP,
	NOFILL, " \t", "Optional input file", 0};


/*>>>>>>>>>>>>>>>>>>>> PLACE command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_placerp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Number of rows", 0};

static COMCOMP sc_placevp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Vertical cost scaling factor", 0};

static COMCOMP sc_placenp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Movement limit for Net Balancing", 0};

static KEYWORD sc_placesetopt[] =
{
	{"verbose",			0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"no-verbose",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"sort",			0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"no-sort",			0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"rows",			1,{&sc_placerp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"net-balance",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"no-net-balance",	0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"limit-net-balance",1,{&sc_placenp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"vertical-cost",	1,{&sc_placevp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"default",			0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_placesetp = {sc_placesetopt,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "Placement set-control option", 0};

static KEYWORD sc_placeopt[] =
{
	{"set-control",		5,{&sc_placesetp,&sc_placesetp,&sc_placesetp,
						   &sc_placesetp,&sc_placesetp}},
	{"show-control",	0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_placep = {sc_placeopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "placement algorithm", 0};


/*>>>>>>>>>>>>>>>>>>>> PULL command <<<<<<<<<<<<<<<<<<<<*/

static KEYWORD sc_pullopt[] =
{
	{"information",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_pullp = {sc_pullopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "pull (flatten) cell", 0};


/*>>>>>>>>>>>>>>>>>>>> ROUTE command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_routeftp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Size of Feed Throughs (internal units)", 0};

static COMCOMP sc_routepdp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Minimum Distance between ports (internal units)", 0};

static COMCOMP sc_routefwp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Fuzzy Window Limit (internal units)", 0};

static COMCOMP sc_routeadp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Minimum Active distance (internal units)", 0};

static KEYWORD sc_routesetopt[] =
{
	{"verbose",				0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"no-verbose",			0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"feed-through-size",	1,{&sc_routeftp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"port-x-min-distance",	1,{&sc_routepdp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"fuzzy-window-limit",	1,{&sc_routefwp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"active-distance",		1,{&sc_routeadp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"default",				0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_routesetp = {sc_routesetopt,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "Route set-control option", 0};

static KEYWORD sc_routeopt[] =
{
	{"set-control",		5,{&sc_routesetp,&sc_routesetp,&sc_routesetp,
						   &sc_routesetp,&sc_routesetp}},
	{"show-control",	0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_routep = {sc_routeopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Routing option", 0};


/*>>>>>>>>>>>>>>>>>>>> SELECT command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_selectp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "name of cell", 0};


/*>>>>>>>>>>>>>>>>>>>> SET command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_setpdp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "direction(s) to attach to port (u d r l)", 0};

static COMCOMP sc_setpdpp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "name of port", 0};

static COMCOMP sc_setpdcp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "name of cell", 0};

static COMCOMP sc_setnumvp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "From edge (internal units)", 0};

static KEYWORD sc_setnumopt[] =
{
	{"top-active",		1,{&sc_setnumvp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"bottom-active",	1,{&sc_setnumvp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"left-active",		1,{&sc_setnumvp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"right-active",	1,{&sc_setnumvp,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_setnump = {sc_setnumopt,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "cell number option", 0};

static COMCOMP sc_setnnip = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "instance name", 0};

static COMCOMP sc_setnnpp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "port name", 0};

static COMCOMP sc_setnnnp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "node name", 0};

static KEYWORD sc_setopt[] =
{
	{"leaf-cell-numbers",5,{&sc_setpdcp,&sc_setnump,&sc_setnump,
						  &sc_setnump,&sc_setnump}},
	{"node-name",		 3,{&sc_setnnip,&sc_setnnpp,&sc_setnnnp,NOKEY,NOKEY}},
	{"port-direction",	 3,{&sc_setpdcp,&sc_setpdpp,&sc_setpdp,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_setp = {sc_setopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "set option", 0};


/*>>>>>>>>>>>>>>>>>>>> SHOW command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_showpp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "cell name", 0};

static KEYWORD sc_shownopt[] =
{
	{"all",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_shownp = {sc_shownopt,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "show instances option", 0};

static COMCOMP sc_shownump = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "leaf cell name", 0};

static KEYWORD sc_showopt[] =
{
	{"cells",				0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"instances",			2,{&sc_showpp,&sc_shownp,NOKEY,NOKEY,NOKEY}},
	{"nodes",				0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"leaf-cell-numbers",	1,{&sc_shownump,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"placement",			1,{&sc_showpp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"ports",				1,{&sc_showpp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"routing",				1,{&sc_showpp,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_showp = {sc_showopt,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "show option", 0};


/*>>>>>>>>>>>>>>>>>>>> SIMULATION command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_simsetp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "name of cell", 0};

static COMCOMP sc_simwrfilep = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t", "name of output file", 0};

static COMCOMP sc_simformatp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,
	NOBACKUP, 0, " \t",  "Output format: als or silos", 0};

static KEYWORD sc_simopt[] =
{
	{"set",		1,{&sc_simsetp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"show",	1,{&sc_simsetp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"write",	2,{&sc_simsetp,&sc_simwrfilep,NOKEY,NOKEY,NOKEY}},
	{"format",	2,{&sc_simformatp,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

static COMCOMP sc_simp = {sc_simopt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "set option", 0};


/*>>>>>>>>>>>>>>>>>>>> HELP command <<<<<<<<<<<<<<<<<<<<*/

static COMCOMP sc_helpp = {NOKEYWORD,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "help object", 0};


/*>>>>>>>>>>>>>>>>>>>> SILICON COMPILER commands <<<<<<<<<<<<<<<<<<<<*/

static KEYWORD sc_opt[] =
{
	{"compile",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"connect",		4,{&sc_connap,&sc_conpap,&sc_connbp,&sc_conpbp,NOKEY}},
	{"create",		1,{&sc_createp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"delete",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"export",		4,{&sc_exportnp,&sc_exportpp,&sc_exportpnp,&sc_exporttp,NOKEY}},
	{"extract",		1,{&sc_extractp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"help",		1,{&sc_helpp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"library",		1,{&sc_libp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"make",		1,{&sc_makep,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"order",		2,{&sc_orderp,&sc_orderfp,NOKEY,NOKEY,NOKEY}},
	{"place",		1,{&sc_placep,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"pull",		1,{&sc_pullp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"route",		1,{&sc_routep,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"schematic",	0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"select",		1,{&sc_selectp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"set",			1,{&sc_setp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"show",		1,{&sc_showp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"simulation",	1,{&sc_simp,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"verify",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	{"quit",		0,{NOKEY,NOKEY,NOKEY,NOKEY,NOKEY}},
	TERMKEY
};

COMCOMP sc_silcomp = {sc_opt,NOTOPLIST,NONEXTLIST,NOPARAMS,NOBACKUP,
	0, " \t", "Silicon Compiler action ('quit' to terminate)", 0};

#endif  /* SCAID - at top */
