// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccscript.
// 
// The exception is that, if you link the ccscript library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccscript library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name ccscript.  If you copy code from other releases into a copy of
// ccscript, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own for ccscript, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.

#include <cc++/url.h>
#include <cc++/export.h>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include "script.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

static class ccManip
{
public:
	ccManip();
	static char *mOffset(ScriptInterp *interp, const char *token);
	static char *mTrim(ScriptInterp *interp, const char *token);
	static char *mSuffix(ScriptInterp *interp, const char *token);
	static char *mIndex(ScriptInterp *interp, const char *token);
} ccmanip;

char *ccManip::mOffset(ScriptInterp *interp, const char *token)
{
	char *opt = interp->getOption(NULL);
	char *str, *opt1;
	long ival;
	unsigned len;

	if(!opt)
		return NULL;

	if(!stricmp(opt, "("))
	{
		str = interp->getString();
		opt = interp->getOption(NULL);
		if(!str || !opt)
			return NULL;

		if(stricmp(opt, ","))
			return NULL;

		if(interp->getExpression(&ival, 1, 0) != 1)
			return NULL;
	}
	else
	{
		str = interp->getContent(opt);
		opt1 = interp->getOption(NULL);
		if(!stricmp(opt1, "("))
		{
			if(interp->getExpression(&ival, 1, 0) != 1)
				return NULL;
		}
		else
			ival = atol(interp->getContent(opt1));
	}	
	if(ival < 0)
	{
		if(!stricmp(token + 1, "offset"))
			token = "+roffset";
		else
			token = "+offset";
		ival = -ival;
	}

	len = strlen(str);

	if(!stricmp(token + 1, "roffset"))
	{
		if(len < ival)
			return str;
		return str + len - ival;
	}

	if(len < ival)
		return "";
	return str + ival;
}

char *ccManip::mIndex(ScriptInterp *interp, const char *token)
{
	char *opt = interp->getOption(NULL);
	char *str, *opt1;
	char packtoken = *interp->getSymbol("script.token");
	long ival;
	unsigned len;

	if(!opt)
		return NULL;

	if(!stricmp(opt, "("))
	{
		str = interp->getString();
		opt = interp->getOption(NULL);
		if(!str || !opt)
			return NULL;

		if(stricmp(opt, ","))
			return NULL;

		if(interp->getExpression(&ival, 1, 0) != 1)
			return NULL;
	}
	else
	{
		str = interp->getContent(opt);
		opt1 = interp->getOption(NULL);
		if(!stricmp(opt1, "("))
		{
			if(interp->getExpression(&ival, 1, 0) != 1)
				return NULL;
		}
		else
			ival = atol(interp->getContent(opt1));
	}	
	if(ival < 2)
		return str;
		
	while(*str && ival > 1)
	{
		if(*(str++) == packtoken)
			--ival;
	}	
	return str;
}		

char *ccManip::mTrim(ScriptInterp *interp, const char *token)
{
	char *opt = interp->getOption(NULL);
	char *str1, *str2, *opt1;
	unsigned len;

	if(!opt)
		return NULL;

	if(!stricmp(opt, "("))
	{
		str1 = interp->getString();
		opt = interp->getOption(NULL);
		if(!str1 || !opt)
			return NULL;

		if(stricmp(opt, ","))
			return NULL;

		str2 = interp->getValue(NULL);
	}
	else
	{
		str1 = interp->getContent(opt);
		opt = interp->getOption(NULL);

		if(!str1 || !opt)
			return NULL;

		str2 = interp->getContent(opt);
	}	

	if(!str2)
		return str1;

	if(!*str2)
		return str1;

	while(*str1)
	{
		if(!stricmp(token + 1, "chop"))
		{
			if(strchr(str2, *str1))
				break;
		}
		else
		{
			if(!strchr(str2, *str1))
				break;

		}
		++str1;
	}
	return str1;
}

char *ccManip::mSuffix(ScriptInterp *interp, const char *token)
{
	char *opt = interp->getOption(NULL);
	char *str1, *str2, *opt1;
	unsigned len;

	if(!opt)
		return NULL;

	if(!stricmp(opt, "("))
	{
		str1 = interp->getString();
		opt = interp->getOption(NULL);
		if(!str1 || !opt)
			return NULL;

		if(stricmp(opt, ","))
			return NULL;

		str2 = interp->getValue(NULL);
	}
	else
	{
		str1 = interp->getContent(opt);
		opt = interp->getOption(NULL);

		if(!str1 || !opt)
			return NULL;

		str2 = interp->getContent(opt);
	}	

	if(!str2)
		return str1;

	if(!*str2)
		return str1;
		
	len = strlen(str1);
	while(len--)
	{
		if(!strchr(str2, str1[len]))
			return str1 + len;
	}
	
	if(!stricmp(token + 1, "suffix"))
		return "";
	else
		return str1;	
}

ccManip::ccManip()
{
	addAttribute("offset", mOffset);
	addAttribute("roffset", mOffset);
	addAttribute("trim", mTrim);
	addAttribute("chop", mTrim);
	addAttribute("suffix", mSuffix);
	addAttribute("basename", mSuffix);
	addAttribute("index", mIndex);
};

#ifdef	CCXX_NAMESPACES
};
#endif



