/* translation of file "petrinet-patterns-structured.k" */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.11 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_FUNCTIONS_petrinet_patterns_structured

#include <stdlib.h>
#include "ast-system-k.h"
#include "petrinet-patterns-structured.h"
namespace kc { }
using namespace kc;
/* included stuff */
#line 22 "petrinet-patterns-structured.k"
/*!
 * \file    petrinet-patterns-structured.cc
 *
 * \brief   Petri net patterns for BPEL's structured activities
 *
 * \author  Niels Lohmann <nlohmann@informatik.hu-berlin.de>,
 *          last changes of: \$Author: nielslohmann $
 * 
 * \since   2006-11-26
 *
 * \date    \$Date: 2007/06/05 15:04:00 $
 * 
 * \note    This file is part of the tool BPEL2oWFN and was created during the
 *          project "Tools4BPEL" at the Humboldt-Universitt zu Berlin. See
 *          http://www.informatik.hu-berlin.de/top/tools4bpel for details.
 *
 * \note    This file was created using Kimwitu++ reading file petrinet-patterns-structured.k.
 *          See http://site.informatik.hu-berlin.de/kimwitu++ for details.
 *
 * \version \$Revision: 1.62 $
*/

#line  37 "petrinet-patterns-structured.cc"
#line 56 "petrinet-patterns-structured.k"
#include "ast-config.h"
#include "helpers.h"
#include "ast-tools.h"
#include "ast-details.h"
#include "globals.h"
#include "petrinet-patterns-shortcuts.h"
#include "extension-chor.h"

using std::cerr;
using std::endl;

extern PetriNet PN;

#line  52 "petrinet-patterns-structured.cc"
#line 79 "petrinet-patterns-structured.k"
/*!
 * \fn void kc::PWhile(impl_tWhile* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <while> activity.
 *
 *          \image html "while.png" "pattern"
 *
 * \ingroup patterns
 */

#line  64 "petrinet-patterns-structured.cc"
#line 277 "petrinet-patterns-structured.k"
/*!
 * \fn void kc::PRepeatUntil(impl_tRepeatUntil* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <repeatUntil> activity.
 * 
 *          \image html "repeatuntil.png" "pattern"
 *
 * \ingroup patterns
 */

#line  76 "petrinet-patterns-structured.cc"
#line 531 "petrinet-patterns-structured.k"
/*!
 * \fn      void kc::PSequence(impl_tSequence* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <sequence> activity.
 * 
 *          \image html "sequence.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  91 "petrinet-patterns-structured.cc"
#line 604 "petrinet-patterns-structured.k"
/*!
 * \fn void kc::PFlow(impl_tFlow* abstract_phylum, uview current_view)
 * \brief Pattern for the <flow> activity.
 * \image html "flow.png" "pattern"
 *
 * \ingroup patterns
 */

#line  101 "petrinet-patterns-structured.cc"
#line 711 "petrinet-patterns-structured.k"
/*!
 * \fn      void kc::PPick(impl_tPick* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <pick> activity.
 *
 *          \image html "pick.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 * 
 * \todo    Use "receivingTransition" function in <onMessage> branches.
 * \todo    Enable DPE for Choreography mode.
 */

#line  119 "petrinet-patterns-structured.cc"
#line 887 "petrinet-patterns-structured.k"
/*!
 * \fn      void kc::PIf(impl_tIf* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <if> and <switch> activity.
 *
 *          \image html "if.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    The branches are not checked sequentially, but in parallel. This
 *          would make a difference in colored Petri nets, but as we are
 *          modeling data-driven decisions by nondeterminism, the <if> can be
 *          modeled by a single conflicting place.
 *
 * \note    The <switch> activity of BPEL4WS 1.1 is modeled with the same
 *          pattern as the <if> activity as the two activity have similar
 *          semantics. The only difference is that an absent <otherwise> branch
 *          in the <switch> activity has to be filled with an <empty> activity
 *          rather than with a shortcut transition as an absent <else> branch.
 *          This implicit <empty> activity is added by the parser.
 *
 * \ingroup patterns
 */

#line  146 "petrinet-patterns-structured.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

void PWhile(impl_tWhile *abstract_phylum, uview current_view)
#line 90 "petrinet-patterns-structured.k"
{
    impl_tWhile_While* phylum = static_cast<impl_tWhile_While*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";

    assert(globals::ASTEmap[phylum->id] != NULL);
    ASTE *myself = globals::ASTEmap[phylum->id];

    switch(current_view)
    {
	case(petrinetnew_enum):
	{
	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "running");
	    Place *p3 = PN.newPlace(prefix + "p3");
	    Place *p4 = PN.newPlace(prefix + "final");
	    Place *p5 = PN.newPlace(prefix + "stop");
	    Place *p6 = PN.newPlace(prefix + "stopped");
	    Place *p7 = PN.newPlace(prefix + "p7");	

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		Place *p5l = PN.newPlace(prefix + "stop_loop");
		Place *p5a = PN.newPlace(prefix + "stop_activity");
		Place *p6l = PN.newPlace(prefix + "stopped_loop");
		Place *p6a = PN.newPlace(prefix + "stopped_activity");

		Transition *stop_split = PN.newTransition(prefix + "stop_split");
		PN.newArc(p5, stop_split);
		PN.newArc(stop_split, p5l);
		PN.newArc(stop_split, p5a);

		Transition *stopped_merge = PN.newTransition(prefix + "stopped_merge");
		PN.newArc(p6l, stopped_merge);
		PN.newArc(p6a, stopped_merge);
		PN.newArc(stopped_merge, p6);
	    }


	    Place *control_enter = NULL;
	    Place *control_leave = NULL;
	    if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
	    {
		control_enter = PN.newPlace("in.enterloop." + toString(phylum->id), IN);
		control_leave = PN.newPlace("in.leaveloop." + toString(phylum->id), IN);
	    }

	    Transition *t1 = PN.newTransition(prefix + "read_condition");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		looppattern(myself->attributes["condition"], myself->max_loops, prefix, phylum->id,
		    p2, p3, p4);
	    }
	    else
	    {

		if (!globals::parameters[P_LOOPCOUNT])
		{
		    Transition *t2 = PN.newTransition(prefix + "start");
		    PN.newArc(p2, t2);
		    PN.newArc(t2, p3);
		    if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
		    {
			PN.newArc(control_enter, t2);
		    }

		    if (myself->attributes["condition"] != "true")
		    {
			Transition *t3 = PN.newTransition(prefix + "end");
			PN.newArc(p2, t3);
			PN.newArc(t3, p4);
			if (globals::parameters[P_LOOPCONTROL])
			{
			    PN.newArc(control_leave, t3);
			}
		    }
		}
	    }


	    if (globals::parameters[P_STANDARDFAULTS])
	    Transition *t5 = throwFault(p2, p7, "running", prefix, mkinteger(phylum->id), globals::ASTEmap[phylum->id]->controlFlow);

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		Transition *t6 = stop_activity(p2, "running", prefix);
		Transition *t7 = stop_activity(p4, "final", prefix);
		Transition *t8 = stop_activity(p7, "p7", prefix);
	    }
	    else
	    {
		Transition *t6 = stop(p2, "running", prefix);
		Transition *t7 = stop(p4, "final", prefix);
		Transition *t8 = stop(p7, "p7", prefix);  
	    }


	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_1->unparse(pseudoPrinter, current_view);



	    PN.mergePlaces(phylum->id, ".internal.p3",      phylum->activity_1->id, ".initial");
	    PN.mergePlaces(phylum->id, ".internal.initial", phylum->activity_1->id, ".final");
	    PN.mergePlaces(phylum->id, ".internal.stop",    phylum->activity_1->id, ".stop");
	    PN.mergePlaces(phylum->id, ".internal.stopped", phylum->activity_1->id, ".stopped");

	    break;
	}

	case(petrinetsmall_enum):
	{
	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "running");
	    Place *p3 = PN.newPlace(prefix + "final");



	    Place *control_enter = NULL;
	    Place *control_leave = NULL;
	    if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
	    {
		control_enter = PN.newPlace("in.enterloop." + toString(phylum->id), IN);
		control_leave = PN.newPlace("in.leaveloop." + toString(phylum->id), IN);
	    }

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		looppattern(myself->attributes["condition"], myself->max_loops, prefix, phylum->id,
		    p1, p2, p3);
	    }
	    else
	    {
		if(myself->attributes["condition"] != "true")
		{
		    Transition *t1 = PN.newTransition(prefix + "leave");
		    PN.newArc(p1, t1);
		    PN.newArc(t1, p3);
		    if (globals::parameters[P_LOOPCONTROL])
		    PN.newArc(control_leave, t1);
		}

		Transition *t2 = PN.newTransition(prefix + "loop");
		PN.newArc(p1, t2);
		PN.newArc(t2, p2);
		if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
		PN.newArc(control_enter, t2);
	    }



	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_1->unparse(pseudoPrinter, current_view);



	    PN.mergePlaces(phylum->id, ".internal.running", phylum->activity_1->id, ".initial");
	    PN.mergePlaces(phylum->id, ".internal.initial", phylum->activity_1->id, ".final");	

	    break;
	}

	default: {  }
    }


    footer(phylum->id, true);

#line 266 "petrinet-patterns-structured.k"
}
#line  337 "petrinet-patterns-structured.cc"

void PRepeatUntil(impl_tRepeatUntil *abstract_phylum, uview current_view)
#line 288 "petrinet-patterns-structured.k"
{
    impl_tRepeatUntil_RepeatUntil* phylum = static_cast<impl_tRepeatUntil_RepeatUntil*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";

    assert(globals::ASTEmap[phylum->id] != NULL);
    ASTE *myself = globals::ASTEmap[phylum->id];

    switch (current_view)
    {
	case(petrinetnew_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "p2"); 
	    Place *p3 = PN.newPlace(prefix + "running");
	    Place *p4 = PN.newPlace(prefix + "final");
	    Place *p5 = PN.newPlace(prefix + "stop");
	    Place *p6 = PN.newPlace(prefix + "stopped");
	    Place *p7 = PN.newPlace(prefix + "faulted");


	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		Place *p5l = PN.newPlace(prefix + "stop_loop");
		Place *p5a = PN.newPlace(prefix + "stop_activity");
		Place *p6l = PN.newPlace(prefix + "stopped_loop");
		Place *p6a = PN.newPlace(prefix + "stopped_activity");

		Transition *stop_split = PN.newTransition(prefix + "stop_split");
		PN.newArc(p5, stop_split);
		PN.newArc(stop_split, p5l);
		PN.newArc(stop_split, p5a);

		Transition *stopped_merge = PN.newTransition(prefix + "stopped_merge");
		PN.newArc(p6l, stopped_merge);
		PN.newArc(p6a, stopped_merge);
		PN.newArc(stopped_merge, p6);
	    }


	    Place *control_enter = NULL;
	    Place *control_leave = NULL;
	    if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
	    {
		control_enter = PN.newPlace("in.enterloop." + toString(phylum->id), IN);
		control_leave = PN.newPlace("in.leaveloop." + toString(phylum->id), IN);
	    }

	    Transition *t1 = PN.newTransition(prefix + "read_condition");
	    PN.newArc(p2, t1);
	    PN.newArc(t1, p3);

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		looppattern(myself->attributes["condition"], (myself->max_loops-1), prefix, phylum->id,
		    p3, p1, p4);
	    }
	    else
	    {
		if(myself->attributes["condition"] != "true")
		{
		    Transition *t2 = PN.newTransition(prefix + "leave");
		    PN.newArc(p3, t2);
		    PN.newArc(t2, p4);
		    if( globals::parameters[P_LOOPCONTROL])
		    PN.newArc(control_leave, t2);
		}

		Transition *t3 = PN.newTransition(prefix + "loop");
		PN.newArc(p3, t3);
		PN.newArc(t3, p1);
		if( globals::parameters[P_LOOPCONTROL])
		PN.newArc(control_enter, t3);	
	    }

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		Transition *t4 = stop_activity(p3, "running", prefix);
		Transition *t5 = stop_activity(p4, "final", prefix);
		Transition *t6 = stop_activity(p7, "faulted", prefix);
	    }
	    else
	    {
		Transition *t4 = stop(p3, "running", prefix);
		Transition *t5 = stop(p4, "final", prefix);
		Transition *t6 = stop(p7, "faulted", prefix);
	    }

	    if (globals::parameters[P_STANDARDFAULTS])
	    Transition *t7 = throwFault(p3, p7, "running", prefix, mkinteger(phylum->id), globals::ASTEmap[phylum->id]->controlFlow);




































































	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_1->unparse(pseudoPrinter, current_view);


	    PN.mergePlaces(phylum->id, ".internal.initial", phylum->activity_1->id, ".initial");
	    PN.mergePlaces(phylum->id, ".internal.p2",      phylum->activity_1->id, ".final");
	    PN.mergePlaces(phylum->id, ".internal.stop",    phylum->activity_1->id, ".stop");
	    PN.mergePlaces(phylum->id, ".internal.stopped", phylum->activity_1->id, ".stopped");

	    break;
	}

	case(petrinetsmall_enum):
	{
	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "p2");
	    Place *p3 = PN.newPlace(prefix + "final");



	    Place *control_enter = NULL;
	    Place *control_leave = NULL;
	    if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
	    {
		control_enter = PN.newPlace("in.enterloop." + toString(phylum->id), IN);
		control_leave = PN.newPlace("in.leaveloop." + toString(phylum->id), IN);
	    }

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		looppattern(myself->attributes["condition"], (myself->max_loops-1), prefix, phylum->id,
		    p2, p1, p3);
	    }
	    else
	    {
		if(myself->attributes["condition"] != "true")
		{
		    Transition *t1 = PN.newTransition(prefix + "leave");
		    PN.newArc(p2, t1);
		    PN.newArc(t1, p3);
		    if (globals::parameters[P_LOOPCONTROL])
		    PN.newArc(control_leave, t1);
		}

		Transition *t2 = PN.newTransition(prefix + "loop");
		PN.newArc(p2, t2);
		PN.newArc(t2, p1);
		if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
		PN.newArc(control_enter, t2);
	    }



	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_1->unparse(pseudoPrinter, current_view);


	    PN.mergePlaces(phylum->id, ".internal.initial", phylum->activity_1->id, ".initial");
	    PN.mergePlaces(phylum->id, ".internal.p2", phylum->activity_1->id, ".final");

	    break;
	}

	default: {  }
    }

    footer(phylum->id, true);

#line 520 "petrinet-patterns-structured.k"
}
#line  576 "petrinet-patterns-structured.cc"

void PSequence(impl_tSequence *abstract_phylum, uview current_view)
#line 545 "petrinet-patterns-structured.k"
{
    impl_tSequence_Sequence* phylum = static_cast<impl_tSequence_Sequence*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";


    Place *p1  = PN.newPlace(prefix + "initial");
    Place *p2  = PN.newPlace(prefix + "final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


    phylum->activity_list_1->unparse(pseudoPrinter, current_view);


    int activityCount = 1;
    impl_activity* lastActivity;
    {
#line 572 "petrinet-patterns-structured.k"
	activity_list kc_fe_selvar_1 =  phylum->activity_list_1;

#line  611 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
	    ) {
	    activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
	    {
#line 572 "petrinet-patterns-structured.k"
		{
		    {
#line 573 "petrinet-patterns-structured.k"
#line 572 "petrinet-patterns-structured.k"
			const activity innerActivity = kc_selvar_0_1;
#line 573 "petrinet-patterns-structured.k"

			if (activityCount == 1)
			PN.mergePlaces(phylum->id, ".internal.initial", innerActivity->id, ".initial");
			else
			PN.mergePlaces(lastActivity->id, ".final", innerActivity->id, ".initial");

			if (activityCount == phylum->activity_list_1->length())
			PN.mergePlaces(phylum->id, ".internal.final", innerActivity->id, ".final");

			if (current_view != petrinetsmall_enum)
			{
			    PN.mergePlaces(phylum->id, ".internal.stop", innerActivity->id, ".stop");
			    PN.mergePlaces(phylum->id, ".internal.stopped", innerActivity->id, ".stopped");
			}

			lastActivity = innerActivity;
			activityCount++;

#line  642 "petrinet-patterns-structured.cc"
		    }
		}

#line  646 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 572 "petrinet-patterns-structured.k"

#line  651 "petrinet-patterns-structured.cc"
	}
    }
#line 591 "petrinet-patterns-structured.k"

    footer(phylum->id, true);

#line 593 "petrinet-patterns-structured.k"
}
#line  660 "petrinet-patterns-structured.cc"

void PFlow(impl_tFlow *abstract_phylum, uview current_view)
#line 613 "petrinet-patterns-structured.k"
{
    impl_tFlow_Flow* phylum = static_cast<impl_tFlow_Flow*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";


    switch(current_view)
    {
	case(petrinetnew_enum):
	{
	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");
	    Place *p3 = PN.newPlace(prefix + "stop");
	    Place *p4 = PN.newPlace(prefix + "stopped");
	    Place *p5 = PN.newPlace(prefix + "running");

	    Transition *t1 = PN.newTransition(prefix + "split");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p5);

	    Transition *t2 = PN.newTransition(prefix + "join");
	    PN.newArc(p5, t2);
	    PN.newArc(t2, p2);

	    Transition *t3 = PN.newTransition(prefix + "stop_all");
	    PN.newArc(p3, t3);
	    PN.newArc(p5, t3);

	    Transition *t4 = PN.newTransition(prefix + "all_stopped");
	    PN.newArc(t4, p4);


	    Transition *t5 = stop(p1, "initial", prefix);
	    Transition *t6 = stop(p2, "final", prefix);


	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_list_1->unparse(pseudoPrinter, current_view);


	    {
#line 657 "petrinet-patterns-structured.k"
		activity_list kc_fe_selvar_1 =  phylum->activity_list_1;

#line  712 "petrinet-patterns-structured.cc"
		while(
			kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
		    ) {
		    activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
		    {
#line 657 "petrinet-patterns-structured.k"
			{
			    {
#line 658 "petrinet-patterns-structured.k"
#line 657 "petrinet-patterns-structured.k"
				const activity innerActivity = kc_selvar_0_1;
#line 658 "petrinet-patterns-structured.k"

				PN.newArc(t1, PN.findPlace(innerActivity->id, ".initial"));
				PN.newArc(t3, PN.findPlace(innerActivity->id, ".stop"));
				PN.newArc(PN.findPlace(innerActivity->id, ".stopped"), t4);
				PN.newArc(PN.findPlace(innerActivity->id, ".final"), t2);

#line  731 "petrinet-patterns-structured.cc"
			    }
			}

#line  735 "petrinet-patterns-structured.cc"
		    }
		    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 657 "petrinet-patterns-structured.k"

#line  740 "petrinet-patterns-structured.cc"
		}
	    }
#line 664 "petrinet-patterns-structured.k"

	    break;
	}

	case(petrinetsmall_enum):
	{
	    Place *p1  = PN.newPlace(prefix + "initial");
	    Place *p2  = PN.newPlace(prefix + "final");

	    Transition *t1 = PN.newTransition(prefix + "split");
	    PN.newArc(p1, t1);

	    Transition *t2 = PN.newTransition(prefix + "join");
	    PN.newArc(t2, p2);


	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_list_1->unparse(pseudoPrinter, current_view);

	    {
#line 685 "petrinet-patterns-structured.k"
		activity_list kc_fe_selvar_1 =  phylum->activity_list_1;

#line  769 "petrinet-patterns-structured.cc"
		while(
			kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
		    ) {
		    activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
		    {
#line 685 "petrinet-patterns-structured.k"
			{
			    {
#line 686 "petrinet-patterns-structured.k"
#line 685 "petrinet-patterns-structured.k"
				const activity innerActivity = kc_selvar_0_1;
#line 686 "petrinet-patterns-structured.k"

				PN.newArc(t1, PN.findPlace(innerActivity->id, ".initial"));
				PN.newArc(PN.findPlace(innerActivity->id, ".final"), t2);

#line  786 "petrinet-patterns-structured.cc"
			    }
			}

#line  790 "petrinet-patterns-structured.cc"
		    }
		    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 685 "petrinet-patterns-structured.k"

#line  795 "petrinet-patterns-structured.cc"
		}
	    }
#line 690 "petrinet-patterns-structured.k"

	    break;
	}

	default: {  }
    }


    footer(phylum->id, true);


#line 700 "petrinet-patterns-structured.k"
}
#line  812 "petrinet-patterns-structured.cc"

void PPick(impl_tPick *abstract_phylum, uview current_view)
#line 728 "petrinet-patterns-structured.k"
{
    impl_tPick_Pick* phylum = static_cast<impl_tPick_Pick*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";



    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");

	Transition *t4 = stop(p1, "initial", prefix);
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);



    unsigned int branch_count = 1;
    {
#line 755 "petrinet-patterns-structured.k"
	tOnMessage_list kc_fe_selvar_1 =  phylum->tOnMessage_list_1;

#line  847 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
	    ) {
	    tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
	    {
#line 755 "petrinet-patterns-structured.k"
		{
#line 756 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 756 "petrinet-patterns-structured.k"
#line 755 "petrinet-patterns-structured.k"
			const tOnMessage ThisBranch = kc_selvar_0_1;
#line 755 "petrinet-patterns-structured.k"
			const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 755 "petrinet-patterns-structured.k"
			const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 755 "petrinet-patterns-structured.k"
			const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 755 "petrinet-patterns-structured.k"
			const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 756 "petrinet-patterns-structured.k"

			header(_id2, true);
			string branch = toString(branch_count++);


			innerActivity->unparse(pseudoPrinter, current_view);



			string interface_place_name = "in." + globals::ASTEmap[ThisBranch->id]->channelName;


			if (globals::instances_of_current_process == 0 &&
			    globals::ASTEmap[ThisBranch->id]->messageLink != NULL &&
			    (globals::ASTEmap[ThisBranch->id]->messageLink->receiver_is_iterator ||
				globals::ASTEmap[ThisBranch->id]->messageLink->sender_is_iterator ||
				globals::ASTEmap[ThisBranch->id]->messageLink->receiver_is_unique))
			{
			    interface_place_name += ".instance_" + toString(globals::ASTEmap[ThisBranch->id]->channel_instances++);
			}


			if (globals::ASTEmap[ThisBranch->id]->messageLink != NULL &&
			    globals::ASTEmap[ThisBranch->id]->messageLink->sender_is_unique)
			{
			    for (unsigned int i = 1; i <= globals::ASTEmap[ThisBranch->id]->messageLink->participantSet->count; i++)
			    {
				Transition *t1 = PN.newTransition(prefix + "onMessage_" + branch + "_" + toString(i));
				PN.newArc(PN.findPlace(prefix + "initial"), t1);
				PN.newArc(PN.findPlace(interface_place_name + ".instance_" + toString(i)), t1);
				PN.newArc(t1, PN.findPlace(toString(innerActivity->id) + ".initial"));
			    }
			}
			else
			{

			    Transition *t1 = PN.newTransition(prefix + "onMessage_" + branch);
			    PN.newArc(PN.findPlace(prefix + "initial"), t1);
			    PN.newArc(PN.findPlace(interface_place_name), t1);
			    PN.newArc(t1, PN.findPlace(toString(innerActivity->id) + ".initial"));
			}


			PN.mergePlaces(phylum->id, ".final", innerActivity->id, ".final");

			if (current_view != petrinetsmall_enum)
			{
			    PN.mergePlaces(phylum->id, ".stop",        innerActivity->id, ".stop");
			    PN.mergePlaces(phylum->id, ".stopped",     innerActivity->id, ".stopped");
			}

			footer(_id2, true);

#line  922 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  927 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 755 "petrinet-patterns-structured.k"

#line  932 "petrinet-patterns-structured.cc"
	}
    }
#line 809 "petrinet-patterns-structured.k"



    {
#line 812 "petrinet-patterns-structured.k"
	tOnAlarm_list kc_fe_selvar_1 =  phylum->tOnAlarm_list_1;

#line  943 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
	    ) {
	    tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
	    {
#line 812 "petrinet-patterns-structured.k"
		{
#line 813 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 813 "petrinet-patterns-structured.k"
#line 812 "petrinet-patterns-structured.k"
			const tOnAlarm onAlarmBranch = kc_selvar_0_1;
#line 812 "petrinet-patterns-structured.k"
			const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 812 "petrinet-patterns-structured.k"
			const integer _id2 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 813 "petrinet-patterns-structured.k"

			header(_id2, true);
			string branch = toString(branch_count++);


			innerActivity->unparse(pseudoPrinter, current_view);


			Transition *t3 = PN.newTransition(prefix + "onAlarm_" + branch);
			PN.newArc(PN.findPlace(prefix + "initial"), t3);
			PN.newArc(t3, PN.findPlace(toString(innerActivity->id) + ".initial"));


			PN.mergePlaces(phylum->id, ".final", innerActivity->id, ".final");

			if (current_view != petrinetsmall_enum)
			{
			    PN.mergePlaces(phylum->id, ".stop",        innerActivity->id, ".stop");
			    PN.mergePlaces(phylum->id, ".stopped",     innerActivity->id, ".stopped");
			}

			footer(_id2, true);

#line  984 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  989 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 812 "petrinet-patterns-structured.k"

#line  994 "petrinet-patterns-structured.cc"
	}
    }
#line 836 "petrinet-patterns-structured.k"





    if (modus == M_CHOREOGRAPHY)
    return;





    branch_count = 1;
    {
#line 849 "petrinet-patterns-structured.k"
	tOnMessage_list kc_fe_selvar_1 =  phylum->tOnMessage_list_1;

#line  1015 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
	    ) {
	    tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
	    {
#line 849 "petrinet-patterns-structured.k"
		{
#line 849 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 849 "petrinet-patterns-structured.k"
#line 849 "petrinet-patterns-structured.k"
			const tCorrelation_list corr_1 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 849 "petrinet-patterns-structured.k"
			const tFromPart_list from_1 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 849 "petrinet-patterns-structured.k"
			const activity innerActivity1 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 849 "petrinet-patterns-structured.k"
			const integer _id1 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 849 "petrinet-patterns-structured.k"

			{
#line 850 "petrinet-patterns-structured.k"
			    tOnMessage_list kc_fe_selvar_1 =  phylum->tOnMessage_list_1;

#line  1040 "petrinet-patterns-structured.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
				) {
				tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
				{
#line 850 "petrinet-patterns-structured.k"
				    {
#line 850 "petrinet-patterns-structured.k"
					if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 850 "petrinet-patterns-structured.k"
#line 850 "petrinet-patterns-structured.k"
					    const tCorrelation_list corr_2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->tCorrelation_list_1;
#line 850 "petrinet-patterns-structured.k"
					    const tFromPart_list from_2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->tFromPart_list_1;
#line 850 "petrinet-patterns-structured.k"
					    const activity innerActivity2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 850 "petrinet-patterns-structured.k"
					    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->integer_1;
#line 850 "petrinet-patterns-structured.k"

					    if ((innerActivity1 != innerActivity2))
					    dpeLinks(PN.findTransition(prefix + "onMessage_" + toString(branch_count)), innerActivity2->id, phylum->id); 

#line  1064 "petrinet-patterns-structured.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1069 "petrinet-patterns-structured.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 850 "petrinet-patterns-structured.k"

#line  1074 "petrinet-patterns-structured.cc"
			    }
			}
#line 854 "petrinet-patterns-structured.k"

			{
#line 855 "petrinet-patterns-structured.k"
			    tOnAlarm_list kc_fe_selvar_1 =  phylum->tOnAlarm_list_1;

#line  1083 "petrinet-patterns-structured.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
				) {
				tOnAlarm kc_selvar_1_1 = kc_fe_selvar_1->tOnAlarm_1;
				{
#line 855 "petrinet-patterns-structured.k"
				    {
#line 855 "petrinet-patterns-structured.k"
					if ((kc_selvar_1_1->prod_sel() == sel_OnAlarm)) {
#line 855 "petrinet-patterns-structured.k"
#line 855 "petrinet-patterns-structured.k"
					    const activity innerActivity2 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_1_1)->activity_1;
#line 855 "petrinet-patterns-structured.k"

					    dpeLinks(PN.findTransition(prefix + "onMessage_" + toString(branch_count)), innerActivity2->id, phylum->id); 

#line  1100 "petrinet-patterns-structured.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1105 "petrinet-patterns-structured.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 855 "petrinet-patterns-structured.k"

#line  1110 "petrinet-patterns-structured.cc"
			    }
			}
#line 858 "petrinet-patterns-structured.k"

			branch_count++;

#line  1117 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  1122 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 849 "petrinet-patterns-structured.k"

#line  1127 "petrinet-patterns-structured.cc"
	}
    }
#line 861 "petrinet-patterns-structured.k"

    {
#line 862 "petrinet-patterns-structured.k"
	tOnAlarm_list kc_fe_selvar_1 =  phylum->tOnAlarm_list_1;

#line  1136 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
	    ) {
	    tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
	    {
#line 862 "petrinet-patterns-structured.k"
		{
#line 862 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 862 "petrinet-patterns-structured.k"
#line 862 "petrinet-patterns-structured.k"
			const activity innerActivity1 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 862 "petrinet-patterns-structured.k"

			{
#line 863 "petrinet-patterns-structured.k"
			    tOnAlarm_list kc_fe_selvar_1 =  phylum->tOnAlarm_list_1;

#line  1155 "petrinet-patterns-structured.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
				) {
				tOnAlarm kc_selvar_1_1 = kc_fe_selvar_1->tOnAlarm_1;
				{
#line 863 "petrinet-patterns-structured.k"
				    {
#line 863 "petrinet-patterns-structured.k"
					if ((kc_selvar_1_1->prod_sel() == sel_OnAlarm)) {
#line 863 "petrinet-patterns-structured.k"
#line 863 "petrinet-patterns-structured.k"
					    const tOnAlarm otheronalarm = kc_selvar_1_1;
#line 863 "petrinet-patterns-structured.k"
					    const activity innerActivity2 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_1_1)->activity_1;
#line 863 "petrinet-patterns-structured.k"

					    if ((innerActivity1 != innerActivity2))
					    dpeLinks(PN.findTransition(prefix + "onAlarm_" + toString(branch_count)), innerActivity2->id, phylum->id); 

#line  1175 "petrinet-patterns-structured.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1180 "petrinet-patterns-structured.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 863 "petrinet-patterns-structured.k"

#line  1185 "petrinet-patterns-structured.cc"
			    }
			}
#line 867 "petrinet-patterns-structured.k"

			{
#line 868 "petrinet-patterns-structured.k"
			    tOnMessage_list kc_fe_selvar_1 =  phylum->tOnMessage_list_1;

#line  1194 "petrinet-patterns-structured.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
				) {
				tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
				{
#line 868 "petrinet-patterns-structured.k"
				    {
#line 868 "petrinet-patterns-structured.k"
					if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 868 "petrinet-patterns-structured.k"
#line 868 "petrinet-patterns-structured.k"
					    const tCorrelation_list _corr2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->tCorrelation_list_1;
#line 868 "petrinet-patterns-structured.k"
					    const tFromPart_list _from2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->tFromPart_list_1;
#line 868 "petrinet-patterns-structured.k"
					    const activity innerActivity2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 868 "petrinet-patterns-structured.k"
					    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->integer_1;
#line 868 "petrinet-patterns-structured.k"

					    dpeLinks(PN.findTransition(prefix + "onAlarm_" + toString(branch_count)), innerActivity2->id, phylum->id); 

#line  1217 "petrinet-patterns-structured.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1222 "petrinet-patterns-structured.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 868 "petrinet-patterns-structured.k"

#line  1227 "petrinet-patterns-structured.cc"
			    }
			}
#line 871 "petrinet-patterns-structured.k"

			branch_count++;

#line  1234 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  1239 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 862 "petrinet-patterns-structured.k"

#line  1244 "petrinet-patterns-structured.cc"
	}
    }
#line 874 "petrinet-patterns-structured.k"

    footer(phylum->id, true);

#line 876 "petrinet-patterns-structured.k"
}
#line  1253 "petrinet-patterns-structured.cc"

void PIf(impl_tIf *abstract_phylum, uview current_view)
#line 913 "petrinet-patterns-structured.k"
{
    impl_tIf_If* phylum = static_cast<impl_tIf_If*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";



    Place *p1 =  PN.newPlace(prefix + "initial");
    Place *p2 =  PN.newPlace(prefix + "final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 =  PN.newPlace(prefix + "stop");
	Place *p4 =  PN.newPlace(prefix + "stopped");

	Transition *t9 = stop(p1, "initial", prefix);
	Transition *t10 = stop(p2, "final", prefix);
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);




    unsigned int currentCase = 1;
    {
#line 942 "petrinet-patterns-structured.k"
	tElseIf_list kc_fe_selvar_1 =  phylum->tElseIf_list_1;

#line  1290 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
	    ) {
	    tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
	    {
#line 942 "petrinet-patterns-structured.k"
		{
#line 943 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 943 "petrinet-patterns-structured.k"
#line 942 "petrinet-patterns-structured.k"
			const tElseIf caseBranch = kc_selvar_0_1;
#line 942 "petrinet-patterns-structured.k"
			const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 942 "petrinet-patterns-structured.k"
			const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->integer_1;
#line 943 "petrinet-patterns-structured.k"

			header(_id2, true);
			string branch = toString(currentCase++);


			innerActivity->unparse(pseudoPrinter, current_view);


			Transition* t1 = PN.newTransition(prefix + "case" + branch);
			PN.newArc(PN.findPlace(prefix + "initial"), t1);


			PN.newArc(t1, PN.findPlace(innerActivity->id, ".initial"));
			PN.mergePlaces(phylum->id, ".internal.final", innerActivity->id, ".final");

			if (current_view != petrinetsmall_enum)
			{
			    PN.mergePlaces(phylum->id, ".internal.stop", innerActivity->id, ".stop");
			    PN.mergePlaces(phylum->id, ".internal.stopped", innerActivity->id, ".stopped");
			}

			footer(_id2, true);

#line  1331 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  1336 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 942 "petrinet-patterns-structured.k"

#line  1341 "petrinet-patterns-structured.cc"
	}
    }
#line 966 "petrinet-patterns-structured.k"



    Transition *t3 = PN.newTransition(prefix + "caseo");
    PN.newArc(PN.findPlace(prefix + "initial"), t3);

    impl_tElse *elseBranch = phylum->tElse_1;
    {
#line 973 "petrinet-patterns-structured.k"
	tElse kc_selvar_0_1 = phylum_cast<tElse>(elseBranch);
#line 996 "petrinet-patterns-structured.k"
	if ((kc_selvar_0_1->prod_sel() == sel_NoElse)) {
#line 996 "petrinet-patterns-structured.k"
#line 995 "petrinet-patterns-structured.k"
	    const tElse elseBranch = kc_selvar_0_1;
#line 995 "petrinet-patterns-structured.k"
	    const integer _id2 = phylum_cast<const impl_tElse_NoElse*>(kc_selvar_0_1)->integer_1;
#line 996 "petrinet-patterns-structured.k"

	    PN.newArc(t3, PN.findPlace(phylum->id, ".internal.final"));

#line  1366 "petrinet-patterns-structured.cc"
	} else
#line 976 "petrinet-patterns-structured.k"
	    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 976 "petrinet-patterns-structured.k"
#line 975 "petrinet-patterns-structured.k"
	    const tElse elseBranch = kc_selvar_0_1;
#line 975 "petrinet-patterns-structured.k"
	    const activity innerActivity = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 975 "petrinet-patterns-structured.k"
	    const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 976 "petrinet-patterns-structured.k"

	    header(_id2, true);


	    phylum->tElse_1->unparse(pseudoPrinter, current_view);


	    PN.newArc(t3, PN.findPlace(innerActivity->id, ".initial"));
	    PN.mergePlaces(phylum->id, ".internal.final", innerActivity->id, ".final");

	    if (current_view != petrinetsmall_enum)
	    {
		PN.mergePlaces(phylum->id, ".internal.stop", innerActivity->id, ".stop");
		PN.mergePlaces(phylum->id, ".internal.stopped", innerActivity->id, ".stopped");
	    }

	    footer(_id2, true);

#line  1396 "petrinet-patterns-structured.cc"
	} else
	{
#line 1000 "petrinet-patterns-structured.k"
#line 1000 "petrinet-patterns-structured.k"

#line  1402 "petrinet-patterns-structured.cc"
	}
    }
#line 1002 "petrinet-patterns-structured.k"





    currentCase = 1;
    {
#line 1008 "petrinet-patterns-structured.k"
	tElseIf_list kc_fe_selvar_1 =  phylum->tElseIf_list_1;

#line  1416 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
	    ) {
	    tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
	    {
#line 1008 "petrinet-patterns-structured.k"
		{
#line 1009 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 1009 "petrinet-patterns-structured.k"
#line 1008 "petrinet-patterns-structured.k"
			const activity innerActivity1 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 1009 "petrinet-patterns-structured.k"

			{
#line 1010 "petrinet-patterns-structured.k"
			    tElseIf_list kc_fe_selvar_1 =  phylum->tElseIf_list_1;

#line  1435 "petrinet-patterns-structured.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
				) {
				tElseIf kc_selvar_1_1 = kc_fe_selvar_1->tElseIf_1;
				{
#line 1010 "petrinet-patterns-structured.k"
				    {
#line 1011 "petrinet-patterns-structured.k"
					if ((kc_selvar_1_1->prod_sel() == sel_ElseIf)) {
#line 1011 "petrinet-patterns-structured.k"
#line 1010 "petrinet-patterns-structured.k"
					    const activity innerActivity2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_1_1)->activity_1;
#line 1011 "petrinet-patterns-structured.k"

					    if (innerActivity1 != innerActivity2)
					    {
						dpeLinks(PN.findTransition(prefix + "case" + toString(currentCase)), innerActivity2->id, phylum->id); 
					    }

#line  1455 "petrinet-patterns-structured.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1460 "petrinet-patterns-structured.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 1010 "petrinet-patterns-structured.k"

#line  1465 "petrinet-patterns-structured.cc"
			    }
			}
#line 1017 "petrinet-patterns-structured.k"

			{
#line 1018 "petrinet-patterns-structured.k"
			    tElse kc_selvar_1_1 = phylum_cast<tElse>(elseBranch);
#line 1021 "petrinet-patterns-structured.k"
			    if ((kc_selvar_1_1->prod_sel() == sel_Else)) {
#line 1021 "petrinet-patterns-structured.k"
#line 1020 "petrinet-patterns-structured.k"
				const tElse elseBranch = kc_selvar_1_1;
#line 1020 "petrinet-patterns-structured.k"
				const activity innerActivity3 = phylum_cast<const impl_tElse_Else*>(kc_selvar_1_1)->activity_1;
#line 1020 "petrinet-patterns-structured.k"
				const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_1_1)->integer_1;
#line 1021 "petrinet-patterns-structured.k"

				dpeLinks(PN.findTransition(prefix + "case" + toString(currentCase)), innerActivity3->id, phylum->id); 
				dpeLinks(PN.findTransition(prefix + "caseo"), innerActivity1->id, phylum->id); 

#line  1487 "petrinet-patterns-structured.cc"
			    } else
			    {
#line 1027 "petrinet-patterns-structured.k"
#line 1027 "petrinet-patterns-structured.k"

				dpeLinks(PN.findTransition(prefix + "caseo"), innerActivity1->id, phylum->id); 

#line  1495 "petrinet-patterns-structured.cc"
			    }
			}
#line 1031 "petrinet-patterns-structured.k"

			currentCase++;

#line  1502 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  1507 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 1008 "petrinet-patterns-structured.k"

#line  1512 "petrinet-patterns-structured.cc"
	}
    }
#line 1034 "petrinet-patterns-structured.k"

    footer(phylum->id, true);

#line 1036 "petrinet-patterns-structured.k"
}
#line  1521 "petrinet-patterns-structured.cc"

void PForEach(impl_tForEach *abstract_phylum, uview current_view)
#line 1047 "petrinet-patterns-structured.k"
{
    impl_tForEach_ForEach* phylum = static_cast<impl_tForEach_ForEach*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";

    assert(globals::ASTEmap[phylum->id] != NULL);
    ASTE *myself = globals::ASTEmap[phylum->id];



    if (globals::ASTEmap[phylum->id]->attributes["parallel"] == "yes")
    {
	switch(current_view)
	{
	    case(petrinetsmall_enum):
	    {
		Place *p1 = PN.newPlace(prefix + "initial");
		Place *p2 = PN.newPlace(prefix + "final");

		Transition *t1 = PN.newTransition(prefix + "split");
		PN.newArc(p1, t1);

		Transition *t2 = PN.newTransition(prefix + "join");
		PN.newArc(t2, p2);

		for (unsigned int branch = 1; branch <= myself->max_loops; branch++)
		{

		    PN.push_forEach_suffix(toString(branch));

		    Place *p_start = PN.newPlace(prefix + "start_branch");
		    Place *p_end = PN.newPlace(prefix + "end_branch");

		    PN.newArc(t1, p_start);
		    PN.newArc(p_end, t2);


		    phylum->tScope_1->unparse(pseudoPrinter, current_view);


		    PN.mergePlaces(prefix + "start_branch", toString(phylum->tScope_1->id) + ".initial");
		    PN.mergePlaces(prefix + "end_branch", toString(phylum->tScope_1->id) + ".final");


		    PN.pop_forEach_suffix();
		}


		phylum->standardElements_1->unparse(pseudoPrinter, current_view);

		break;	  
	    }


	    case(petrinetnew_enum):
	    {
		cerr << "no pattern" << endl;
		break;
	    }

	    default: {  }
	}
    }
    else
    cerr << "no pattern" << endl;






































































    footer(phylum->id, true);

#line 1185 "petrinet-patterns-structured.k"
}
#line  1666 "petrinet-patterns-structured.cc"


} // namespace kc
