/* translation of file(s)
	"bpel-abstract.k"
	"bpel-unparse-petri.k"
	"bpel-unparse-petri2.k"
	"bpel-unparse-xml.k"
	"bpel-unparse-cfg.k"
	"ast-printers.k"
 */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.8 (C) 1998-2003 Humboldt-University of Berlin $
 */
#define KC_CSGIO

#include <stdio.h>
#include <setjmp.h>
#include <ctype.h>
#include <stdlib.h>
#include <map>
#include <algorithm>
#include "bpel-kc-k.h"
#include "bpel-kc-csgiok.h"


namespace kc {


namespace { // all local to this file

/* macro that does the string concatenation */
#define kc_str_conc2(a,b) strcat(strcpy(new char[strlen(a) + strlen(b) +1], a), b)

/* function that reads the integers */
inline void
kc_do_get_int(int &c, int c_init, int &i, FILE *f)
{
    c = c_init;
    i = 0;
    while (isdigit(c)){
	i = (i*10) + (c-'0');
	c = getc(f);
    }
}

char *kc_malloc_area = 0;
size_t kc_sizeof_malloc_area = 0;
int kc_node_count;
int kc_node_count_base;

char*
kc_grow_malloc_area(size_t kc_s)
{
    delete kc_malloc_area;
    kc_malloc_area = new char[kc_s];
    kc_sizeof_malloc_area = kc_s;
    return kc_malloc_area;
}

inline char*
KC_GETMALLOCAREA(size_t kc_s)
{
    return kc_s > kc_sizeof_malloc_area ?
    kc_grow_malloc_area(kc_s) : kc_malloc_area;
}

/* global variables */
int kc_no_external_ops;
const int KC_NOT_FOUND_OPERATOR = -1;
int kc_file_offset_base;
int kc_file_offset;

/* Magic File descriptor(s) */
/* Magic descriptors of length up to KC_MAGIC_LENGTH-1 are supported.  When changing
 * KC_MAGIC_LENGTH. change constant in MAGIC_READ_FORMAT to be one less than
 * KC_MAGIC_LENGTH. */
/* Every file is assumed to start with the magic file descriptor for asc_csg_v3 */

char kc_ascii_prefix_magic_v3[] = "A#S#C#S#S#L#V#3";
char kc_ascii_prefix_magic_hu[] = "A#S#C#S#S#L#HUB";
const int KC_MAGIC_LENGTH = 25;
const char *KC_MAGIC_READ_FORMAT = "%24s\n";

/* Operators with names of length upto OP_LENGTH-1 are supported. */
/* When changing OP_LENGTH, change constant in OP_READ_FOMAT to be one less */
const int KC_OP_LENGTH = 256;
const char *KC_OP_READ_FORMAT = "%255s\n";

//**********************
// Error-string Routine
const char*
kc_CSGIOerrorstring(KC_IO_STATUS kc_io_status)
{
    switch( kc_io_status ) {
	case KC_CSGIOSTATUS_NO_ERR: return( "No errors" );
	case KC_CSGIOSTATUS_SCAN_ERR_1: return( "Scan error(1)" );
	case KC_CSGIOSTATUS_SCAN_ERR_2: return( "Scan error(2)" );
	case KC_CSGIOSTATUS_SCAN_ERR_3: return( "Scan error(3)" );
	case KC_CSGIOSTATUS_SCAN_ERR_4: return( "Scan error(4)" );
	case KC_CSGIOSTATUS_SCAN_ERR_5: return( "Scan error(5)" );
	case KC_CSGIOSTATUS_GRAM_INCONSISTENT: return( "Grammar is inconsistent" );
	case KC_CSGIOSTATUS_ROK: return( "Read OK structure file" );
	case KC_CSGIOSTATUS_ILLEGAL_OPTION: return( "Illegal option in write command" );
	case KC_CSGIOSTATUS_TOO_MANY_OPERATORS: return( "Too many operators for binary format" );
	case KC_CSGIOSTATUS_WOK: return( "Written OK" );
	case KC_CSGIOSTATUS_TXT_FILE_INPUT: return( "Read OK Text-file" );
	case KC_CSGIOSTATUS_SYNTAX_ERROR: return( "Syntax error" );
	case KC_CSGIOSTATUS_ILLEGAL_CONTEXT: return( "Illegal context for operator" );
	case KC_CSGIOSTATUS_PREMATURE_EOF: return( "Premature eof in file" );
	case KC_CSGIOSTATUS_UNEXP_FATHER_MARK: return( "Unexpected FATHER MARKER" );
	default: return( "Unknown error code" );
    }
}

struct csgio_info {
    int number;      // number of node, or -1 if no number
    bool created;    // whether the node is already written
    csgio_info():number(-1),created(false){}
};
typedef std::map<const void*,csgio_info> csgio_map;
csgio_map kc_CSGIOhashtable;

/* Maps */
typedef struct {
    int left;
    int right;
} kc_OpToOpMap_tuple_t;

kc_OpToOpMap_tuple_t kc_OpToOpMap[KC_NO_OF_OPERATORS];
const int KC_NOT_USED = -1;

int
kc_op_search(char *kc_s)
{
    int kc_i;
    for ( kc_i=0; kc_i < KC_NO_OF_OPERATORS; kc_i++ ) {
	if ( strcmp( kc_s, operator_info[kc_i].name ) == 0 ) return( kc_i );
    }
    return( KC_NOT_FOUND_OPERATOR );
}

void
kc_initializeOpToOpMap(int kc_v)
{
    int kc_i;
    for ( kc_i=0; kc_i < KC_NO_OF_OPERATORS; kc_i++ ) {
	kc_OpToOpMap[kc_i].left = kc_i;
	kc_OpToOpMap[kc_i].right = kc_v;
    }   }

bool
OpToOpMap_cmp_right(kc_OpToOpMap_tuple_t t1, kc_OpToOpMap_tuple_t t2)
{
    // sort in DECREASING order
    return t1.right > t2.right;
}

bool
OpToOpMap_cmp_left(kc_OpToOpMap_tuple_t t1, kc_OpToOpMap_tuple_t t2)
{
    // sort in INCREASING order
    return t1.left < t2.left;
}

void
kc_renumberOpToOpMap()
{
    int kc_i, kc_j = 0;
    for ( kc_i=0; kc_i < KC_NO_OF_OPERATORS; kc_i++ ) {
	if (kc_OpToOpMap[kc_i].right > 0) {
	    kc_OpToOpMap[kc_i].right = kc_j++;
	} else {
	    kc_OpToOpMap[kc_i].right = KC_NOT_USED;
	}   }	}


#define KC_MAKE_NEW_MAPPING(ext_op,int_op) kc_OpToOpMap[ext_op].right = int_op
#define KC_MAKE_NEW_SCAN_MAPPING(ext_op) kc_OpToOpMap[ext_op].right++
#define KC_MAP(op) (kc_OpToOpMap[op].right)
#define KC_IS_MAPPED(op) (kc_OpToOpMap[op].right != KC_NOT_USED)

void
kc_error_operator_not_in_phylum(int kc_op, int kc_phy)
{
    const char *kc_error_message1 = "operator not defined in phylum ";
    const char *kc_error_message2 = ": ";
    if ((kc_op <= one_before_first_operator) || (kc_op >= last_operator)) {
	char kc_value[30];
	sprintf(kc_value, "%d",kc_op);
	kc_csgio_err_reason = kc_str_conc2("unknown operator number: ", kc_value);
    } else {
	kc_csgio_err_reason = (char*)strcat(strcat(strcat(strcpy(new char[(size_t)(strlen(kc_error_message1)+strlen(phylum_info[kc_phy].name)+strlen(kc_error_message2)+strlen(operator_info[kc_op].name)+1)], kc_error_message1), phylum_info[kc_phy].name), kc_error_message2), operator_info[kc_op].name);
    }
    throw IO_exception(KC_CSGIOSTATUS_ILLEGAL_CONTEXT); /*NOTREACHED*/
}

} // anonymous namespace

char*
IO_exception2char(IO_exception kc_p)
{
    char *kc_err_ret = 0;
    const char *kc_err_sep = ": ";
    if (kc_p.io_status != KC_CSGIOSTATUS_ROK && kc_p.io_status != KC_CSGIOSTATUS_WOK) {
	const char *kc_io_err = kc_CSGIOerrorstring(kc_p.io_status);
	kc_err_ret = new char[strlen(kc_io_err)+strlen(kc_err_sep)+strlen(kc_p.err_reason)+1];
	strcpy(kc_err_ret, kc_io_err);
	strcat(kc_err_ret, kc_err_sep);
	strcat(kc_err_ret, kc_p.err_reason);
    }
    return kc_err_ret;
}

const char *kc_csgio_err_reason = "";

#ifndef KC_NO_CSGIO_READ
namespace { // all local to this file

/* Base 64 numbers are written with the digits:
   : ; < = > ? @ A-Z [ \ ] ^ _ ` a-y
   Base 10 numbers are written with the ordinary digits 0-9.
   Other characters are used in special circumstances:
    ! Indicates switch between reading attribute and unattributed nodes.
    # Indicates that the father is the next PROD_INSTANCE in the file.
    + Indicates that the following bytes are not a base 64 number
    * Indicates a line containing a (decimal) count of attributes.
*/
const char KC_B64_ZERO_CHAR =	':';
const char KC_ASCII_ZERO =	'0';
const char KC_SWITCH_ATTR =	'!';
const char KC_FATHER_MARKER =	'#';
const char KC_NON_B64_CHAR =	'+';
const char KC_ATTR_COUNT =	'*';
const char KC_NULL_POINTER =    '.';

inline bool
KC_IS_B64(int c)
{
    return c>=KC_B64_ZERO_CHAR && c<KC_B64_ZERO_CHAR+64;
}

/* read and compute the base 64 integer in stream */
unsigned
get_rest_of_b64(FILE *kc_stream, register int kc_read_char, char kc_trailing_char)
{
    int kc_next_char;
    int kc_offset;
    int kc_i = 0;

    if (!KC_IS_B64(kc_read_char))
	throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);
    kc_offset = kc_read_char - KC_B64_ZERO_CHAR;

    kc_next_char = getc(kc_stream);
    while(KC_IS_B64(kc_next_char)) {
	kc_offset += (kc_next_char - KC_B64_ZERO_CHAR) << (6 * (++kc_i));
	kc_next_char = getc(kc_stream);
    }

    if (kc_next_char == '-') {
	kc_offset *= -1;
	kc_next_char = getc(kc_stream);
    }

    if (kc_next_char != kc_trailing_char)
	throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);
    return kc_offset;
}

/* read shared functions */
typedef enum { KC_NOT_READ_YET, KC_READ_EARLIER } KC_READ_STATUS;
/* variable used by the sharing routines during a read */
/* stores pointers to value_ptr fields */
abstract_phylum *kc_offset_to_address_map;
char const* *kc_offset_to_address_map_base;

void
kc_init_read_sharing()
{
    kc_offset_to_address_map = new abstract_phylum[kc_node_count];
    for(int i=0; i<kc_node_count; ++i) kc_offset_to_address_map[i]=0;
    kc_file_offset = 0;
    kc_offset_to_address_map_base = new char const* [kc_node_count_base];
    for(int j=0; j<kc_node_count_base; ++j) kc_offset_to_address_map_base[j]=0;
    kc_file_offset_base = 0;
}

KC_READ_STATUS
kc_read_sharing_find(FILE *kc_stream, abstract_phylum &kc_valptr)
{
    char kc_first_char;
    unsigned kc_offset;

    kc_first_char = getc(kc_stream);
    if (KC_IS_B64(kc_first_char)) {
	kc_offset = get_rest_of_b64(kc_stream, kc_first_char, '\n');
	int off=kc_file_offset - kc_offset;
	assertReason(off>=0 && off<=kc_node_count, "base 64 offset out of range");
	kc_valptr = kc_offset_to_address_map[off];
	return(KC_READ_EARLIER);
    } else {
	ungetc(kc_first_char, kc_stream);
	return(KC_NOT_READ_YET);
    }
}

KC_READ_STATUS
kc_read_sharing_find_base(FILE *kc_stream, char const* &kc_valptr)
{
    char kc_first_char;
    unsigned kc_offset;

    kc_first_char = getc(kc_stream);
    if (KC_IS_B64(kc_first_char)) {
	kc_offset = get_rest_of_b64(kc_stream, kc_first_char, '\n');
	int off=kc_file_offset_base - kc_offset;
	assertReason(off>=0 && off<=kc_node_count_base, "base 64 offset out of range");
	kc_valptr = kc_offset_to_address_map_base[off];
	return(KC_READ_EARLIER);
    } else {
	return(KC_NOT_READ_YET);
    }
}

#define kc_read_sharing_store(kc_ptr, kc_loc) \
kc_offset_to_address_map[kc_loc] = kc_ptr
#define kc_read_sharing_store_base(kc_ptr) \
kc_offset_to_address_map_base[kc_file_offset_base++] = kc_ptr


void
kc_end_read_sharing()
{
    delete kc_offset_to_address_map;
    delete kc_offset_to_address_map_base;
}

void
kc_CSGIOdo_read_atom_denotation(FILE *kc_stream, char *kc_sbase, int kc_len)
{
    char * kc_sptr = kc_sbase;
    register int kc_ch, kc_ch1;
    register char kc_test;
    register int kc_i;

    for (kc_i=0; kc_i<kc_len; kc_i++, kc_sptr++) {
	kc_ch = getc(kc_stream);
	if (kc_ch == '\n') {
	    ungetc(kc_ch, kc_stream);
	    break;
	}
	*kc_sptr = (char) kc_ch;
	if ( kc_ch == '\\' ) {
	    if ( ( kc_test = getc( kc_stream ) ) != '\\' ) { /* Must be escaped hex */
		if (isdigit(kc_test)) kc_ch1 = kc_test - '0'; else kc_ch1 =kc_test + 10 - 'a';
		kc_ch1 = 16 * kc_ch1;
		kc_test = getc(kc_stream);
		if (isdigit(kc_test)) kc_test= kc_test - '0'; else kc_test=kc_test + 10 - 'a';
		kc_ch1 = kc_ch1 + kc_test;
		*kc_sptr = (char)kc_ch1; /* cast is for explicit narrowing from int to char */
	    }
	}
    }

    kc_ch = getc(kc_stream);
    if ( kc_ch == EOF ) throw IO_exception(KC_CSGIOSTATUS_PREMATURE_EOF);
    else if (kc_ch != '\n') throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);

    *kc_sptr = '\0';
}

abstract_phylum
CSGIOread2dft(FILE *kc_stream, enum_phyla kc_phy)
{
    char *kc_sbase;
    char const* c_kc_sbase;
    int kc_len;
    int kc_delim;
    abstract_phylum kc_answer;
    int kc_location;
    bool kc_not_read_yet = false;

    /* get operator */
    int kc_ext_op;
    int kc_testing;

    /* XXX MPi: misleading comment? scan for optional unparsing version number */
    if (kc_read_sharing_find( kc_stream, kc_answer ) == KC_READ_EARLIER ) {
	// MPi: I believe this is unnecessary or wrong - sharing is only done
	// when phyla are the _same_, so they should remain the same.
	// kc_answer = kc_answer->copy(false);
	return kc_answer;
    }
    kc_do_get_int(kc_testing,getc(kc_stream),kc_ext_op,kc_stream);
    if ( kc_testing == EOF )
	throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);
    if ( kc_testing == KC_NULL_POINTER )
    {
	kc_do_get_int(kc_testing,getc(kc_stream),kc_ext_op,kc_stream);
	if ( kc_testing != '\n' )
	    throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);
	return 0;
    }
    if ( kc_testing == KC_FATHER_MARKER )
	throw IO_exception(KC_CSGIOSTATUS_UNEXP_FATHER_MARK);
    if ( kc_testing != '\n' )
	throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);
    enum_operators kc_op(static_cast<enum_operators>(KC_MAP( kc_ext_op )));
    /* end get operator */

    if (kc_op<phylum_info[kc_phy].first_operator || kc_op>phylum_info[kc_phy].last_operator)
	kc_error_operator_not_in_phylum(kc_op,kc_phy);

    kc_location = kc_file_offset++;
    switch( kc_op ) {
    case sel__VoidPtr:
	// FATAL ERROR
	kc_do_get_int(kc_delim,getc(kc_stream),kc_len,kc_stream);
	if ( kc_delim == EOF )
	    throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);
	kc_sbase = KC_GETMALLOCAREA(kc_len + 1); // +1 for '\0'
	kc_CSGIOdo_read_atom_denotation(kc_stream, kc_sbase, kc_len);
	kc_answer = 0;
	break;
    case sel__Int:
	kc_do_get_int(kc_delim,getc(kc_stream),kc_len,kc_stream);
	if ( kc_delim == EOF )
	    throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);
	kc_sbase = KC_GETMALLOCAREA(kc_len + 1); // +1 for '\0'
	kc_CSGIOdo_read_atom_denotation(kc_stream, kc_sbase, kc_len);
	kc_answer = mkinteger(::atoi(kc_sbase));
	break;
    case sel__Real:
	kc_do_get_int(kc_delim,getc(kc_stream),kc_len,kc_stream);
	if ( kc_delim == EOF )
	    throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);
	kc_sbase = KC_GETMALLOCAREA(kc_len + 1); // +1 for '\0'
	kc_CSGIOdo_read_atom_denotation(kc_stream, kc_sbase, kc_len);
	kc_answer = mkreal(::atof(kc_sbase));
	break;
    case sel__Str:
	if (kc_read_sharing_find_base( kc_stream, c_kc_sbase ) == KC_NOT_READ_YET) {
	    kc_not_read_yet = true;
	    kc_do_get_int(kc_delim,getc(kc_stream),kc_len,kc_stream);
	    if ( kc_delim == EOF )
		throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);
	    kc_sbase = KC_GETMALLOCAREA(kc_len + 1); /* +1 for '\0' */
	    kc_CSGIOdo_read_atom_denotation(kc_stream, kc_sbase, kc_len);
	    c_kc_sbase=kc_sbase;
	}
	kc_answer = mkcasestring( c_kc_sbase );
	if (kc_not_read_yet) {
	    kc_read_sharing_store_base( phylum_cast<casestring>(kc_answer)->name );
	}
	break;
    case sel_NoCaseStr:
	if (kc_read_sharing_find_base( kc_stream, c_kc_sbase ) == KC_NOT_READ_YET) {
	    kc_not_read_yet = true;
	    kc_do_get_int(kc_delim,getc(kc_stream),kc_len,kc_stream);
	    if ( kc_delim == EOF )
		throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);
	    kc_sbase = KC_GETMALLOCAREA(kc_len + 1); /* +1 for '\0' */
	    kc_CSGIOdo_read_atom_denotation(kc_stream, kc_sbase, kc_len);
	    c_kc_sbase=kc_sbase;
	}
	kc_answer = mknocasestring( c_kc_sbase );
	if (kc_not_read_yet) {
	    kc_read_sharing_store_base( phylum_cast<nocasestring>(kc_answer)->name );
	}
	break;
	default:
	    abstract_phylum kc_subtmp[9];
	    for (int kc_i = 0; kc_i < operator_info[kc_op].no_sons; ++kc_i) {
		kc_subtmp[kc_i] = CSGIOread2dft(kc_stream, operator_info[kc_op].subphylum[kc_i] );
		assertReason(kc_subtmp[kc_i]!=0, "shared phylum is not contained in file (reference is wrong)");
	    }
	    switch(operator_info[kc_op].no_sons) {
		case 0: kc_answer = kc_create(kc_op); break;
		case 1: kc_answer = kc_create(kc_op, kc_subtmp[0]); break;
		case 2: kc_answer = kc_create(kc_op, kc_subtmp[0], kc_subtmp[1]); break;
		case 3: kc_answer = kc_create(kc_op, kc_subtmp[0], kc_subtmp[1], kc_subtmp[2]); break;
		case 7: kc_answer = kc_create(kc_op, kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4], kc_subtmp[5], kc_subtmp[6]); break;
		case 9: kc_answer = kc_create(kc_op, kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4], kc_subtmp[5], kc_subtmp[6], kc_subtmp[7], kc_subtmp[8]); break;
		default:
		    assertionFailed("unexpected number of sub-phyla"); break;
	    }
	// Read attributes
	for (int kc_i=0; kc_i<operator_info[kc_op].no_attrs; ++kc_i)
	    attributeOf(kc_answer, kc_i)=
		CSGIOread2dft(kc_stream, operator_info[kc_op].attribute[kc_i]);
    }

    kc_read_sharing_store( kc_answer, kc_location );
    return kc_answer;
}

} // anonymous namespace

void
CSGIOreadphylum(FILE *kc_stream, abstract_phylum &kc_ptr, enum_phyla kc_phy)
{
    int kc_scan_return_code;
    char kc_magic_no[KC_MAGIC_LENGTH];
    char kc_dollarcode[KC_OP_LENGTH];
    char kc_ext_name[KC_OP_LENGTH];
    int kc_operator;

    kc_csgio_err_reason = "";
    kc_scan_return_code = fscanf( kc_stream, KC_MAGIC_READ_FORMAT, kc_magic_no );
    if ( kc_scan_return_code != 1 )
	throw IO_exception(KC_CSGIOSTATUS_GRAM_INCONSISTENT, "magic string not scanned") ;
    if ( strcmp( kc_magic_no, kc_ascii_prefix_magic_v3 ) != 0 &&
	    strcmp( kc_magic_no, kc_ascii_prefix_magic_hu ) != 0 )
	throw IO_exception(KC_CSGIOSTATUS_GRAM_INCONSISTENT,"scanned magic string is not asc_ssl_v3 (or HUB specific) magic string") ;
    if ( fscanf( kc_stream, "$%[^ ] \n", kc_dollarcode ) != 1 )
	throw IO_exception(KC_CSGIOSTATUS_GRAM_INCONSISTENT,"problems finding $ before operators") ;
    while ( strcmp( kc_dollarcode, "operators" ) != 0 ) {
	if ( fscanf( kc_stream, "%*[^$]$%[^ ] \n", kc_dollarcode) != 1 )
	    throw IO_exception(KC_CSGIOSTATUS_GRAM_INCONSISTENT,"problems finding operators keyword") ;
    }
    /* read all external operator definitions and initialize map */
    kc_no_external_ops = 0;
    kc_initializeOpToOpMap(KC_NOT_FOUND_OPERATOR);
    while (true) {
	int kc_ext_arity, kc_ext_attr_arity, kc_ext_atomicity;

	if ( fscanf( kc_stream, "%[^ ] ", kc_ext_name ) != 1 )
	    throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_3, "no operator name at start of line") ;
	else if ( kc_ext_name[0] == '$' )
	    break;
	else if ( fscanf( kc_stream, "%d %d %d\n", &kc_ext_arity, &kc_ext_attr_arity, &kc_ext_atomicity ) != 3 )
	    throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_4, "no arity, attr_arity or atomicity") ;
	else {
	    kc_operator = kc_op_search( kc_ext_name );
	    if ( ( kc_operator == KC_NOT_FOUND_OPERATOR ) ||
		    ( KC_NO_SONS( kc_operator ) != kc_ext_arity ) ||
		    ( KC_ATOMICITY( kc_operator) != (kc_ext_atomicity!=0) )
		)
		throw IO_exception(KC_CSGIOSTATUS_GRAM_INCONSISTENT, kc_str_conc2("problems with operator: ",kc_ext_name)) ;
	    else {
		KC_MAKE_NEW_MAPPING( kc_no_external_ops, kc_operator );
		kc_no_external_ops++;
	    }	}   }
    /* ascertain that we are at the $object section, or get to that point */
    if ( strcmp( kc_ext_name, "$object" ) != 0 ) /* if not at $object */
	while ( strcmp( kc_ext_name, "object" ) != 0 ) {
	if ( fscanf( kc_stream, "%*[^$]$%[^ ]", kc_ext_name ) != 1 )
	    throw IO_exception(KC_CSGIOSTATUS_GRAM_INCONSISTENT, kc_str_conc2("problems finding start of object section","")) ;
    }

    /* read node_count; set up address map */
    if (fscanf(kc_stream, "%d %d\n", &kc_node_count, &kc_node_count_base) != 2)
	throw IO_exception(KC_CSGIOSTATUS_SCAN_ERR_1);
    kc_init_read_sharing(); /* for shared values */

    /* read the tree (actually a graph) */
    kc_ptr = CSGIOread2dft( kc_stream, kc_phy );
    kc_end_read_sharing(); /* for atomic values */
}
#endif // ! KC_NO_CSGIO_READ

#ifndef KC_NO_CSGIO_WRITE
namespace { // all local to this file


// print a string to a file, escaping backslashes and non-printables
void
kc_print_to_file(FILE *kc_f, char const* kc_value)
{
    unsigned char const* kc_vptr = (unsigned char const*)kc_value;
    int kc_len = strlen(kc_value);
    int kc_i;

    fprintf(kc_f, "%d ", kc_len);
    for (kc_i=0; kc_i<kc_len; kc_i++, kc_vptr++) {
	if (*kc_vptr == '\\') {
	    fprintf(kc_f, "\\\\");
	} else if (isprint(*kc_vptr)) {
	    putc((char)*kc_vptr, kc_f);
	} else {
	    fprintf(kc_f, "\\%.2x", *kc_vptr);
	}
    }
    putc('\n', kc_f);
}

void
kc_print_b64_to_file(FILE *kc_f, int kc_value)
{
    unsigned int kc_pos_value;

    if (kc_value == 0) {
	putc(KC_B64_ZERO_CHAR, kc_f);
    } else {
	kc_pos_value = abs(kc_value);
	while (kc_pos_value != 0) {
	    putc((kc_pos_value & ((1 << 6) - 1) ) + KC_B64_ZERO_CHAR, kc_f);
	    kc_pos_value >>= 6;
	}
	if (kc_value < 0) {
	    putc('-', kc_f);
	}
    }
    putc('\n', kc_f);
}

// realize sharing of strings in ouput file
void
kc_CSGIOscan(c_abstract_phylum kc_p)
{
    if (kc_p==0) return;
    enum_operators kc_op = kc_p->prod_sel();
    if (kc_CSGIOhashtable[kc_p].number == -1) {
	kc_CSGIOhashtable[kc_p].number = kc_node_count++;
	KC_MAKE_NEW_SCAN_MAPPING( kc_op );
	switch(kc_op) {
	    case sel__Str:
	    case sel_NoCaseStr: {
		char const* s = static_cast<c_casestring>(kc_p)->name;
		if (kc_CSGIOhashtable[s].number == -1)
			kc_CSGIOhashtable[s].number = kc_node_count_base++;
		break;
	    }
	    default: {
		abstract_phylum child;
		for (int i=0; (child = kc_p->subphylum(i)); ++i)
		    kc_CSGIOscan(child);
	    }
	}
	for (int i=0; i<operator_info[kc_op].no_attrs; ++i)
	    kc_CSGIOscan(attributeOf(const_cast<abstract_phylum>(kc_p), i));
    }
}

void
kc_CSGIOwrite2structure(FILE *kc_stream, c_abstract_phylum kc_p)
{
    if (kc_p==0) {
	fprintf( kc_stream, "%c\n", KC_NULL_POINTER );
	return;
    }
    char _kc_value[30];
    char *kc_value = _kc_value;
    enum_operators kc_op = kc_p->prod_sel();
    csgio_info &kc_hn = kc_CSGIOhashtable[kc_p];
    if (kc_hn.created) {
	kc_print_b64_to_file( kc_stream, kc_file_offset - kc_hn.number );
    } else {
	kc_hn.created = true;
	fprintf( kc_stream, "%d\n", KC_MAP( kc_op ) );
	kc_file_offset++;
	switch(kc_op) {
	case sel__VoidPtr:
	    /* FATAL ERROR */
	    sprintf( kc_value, "%p", static_cast<c_voidptr>(kc_p)->pointer);
	    kc_print_to_file( kc_stream, kc_value );
	    kc_file_offset_base++;
	    break;
	case sel__Str:
	case sel_NoCaseStr:
	    fprintf( kc_stream, "%c", KC_NON_B64_CHAR );
	    kc_print_to_file( kc_stream, static_cast<c_casestring>(kc_p)->name);
	    kc_file_offset_base++;
	    break;
	case sel__Int:
	    sprintf( kc_value, "%d", static_cast<c_integer>(kc_p)->value);
	    kc_print_to_file( kc_stream, kc_value );
	    kc_file_offset_base++;
	    break;
	case sel__Real:
	    sprintf( kc_value, "%.20f", static_cast<c_real>(kc_p)->value);
	    kc_print_to_file( kc_stream, kc_value );
	    kc_file_offset_base++;
	    break;
	default:
	abstract_phylum child;
	for (int kc_i=0; (child = kc_p->subphylum(kc_i)); ++kc_i)
	    kc_CSGIOwrite2structure(kc_stream, child);
	// Write attributes
	for (int kc_i=0; kc_i<operator_info[kc_op].no_attrs; ++kc_i)
	    kc_CSGIOwrite2structure(kc_stream, attributeOf(const_cast<abstract_phylum>(kc_p), kc_i));
    }
}
}

void
CSGIOwrite(FILE *kc_stream, c_abstract_phylum kc_p)
{
    int kc_i;
    kc_csgio_err_reason = "";

    /* write out the magic string and $operators string */
    fprintf( kc_stream, "%s\n$operators \n", kc_ascii_prefix_magic_hu );

    /* Initialize map from internal operators to external operators, */
    /* initially empty */
    kc_no_external_ops = 0;
    kc_node_count = 0;
    kc_node_count_base = 0;
    kc_initializeOpToOpMap(0); /* initialize to 0, not any other value */

    // realize sharing
    kc_CSGIOscan(kc_p);
    /* sort the optoopmap on decreasing operator usage */
    std::sort(&kc_OpToOpMap[0], &kc_OpToOpMap[KC_NO_OF_OPERATORS], OpToOpMap_cmp_right);
    kc_renumberOpToOpMap();

    /* write out the _sorted_ operator table */
    for(kc_i = 0; kc_i < KC_NO_OF_OPERATORS; kc_i++) {
	if (kc_OpToOpMap[kc_i].right != KC_NOT_USED) {
	    fprintf( kc_stream, "%s %d %d %d\n", KC_OP_NAME( kc_OpToOpMap[kc_i].left), KC_NO_SONS( kc_OpToOpMap[kc_i].left ), 0, KC_ATOMICITY( kc_OpToOpMap[kc_i].left ) );
	}	}

    /* sort the optoopmap increasing on the operator number */
    std::sort(&kc_OpToOpMap[0], &kc_OpToOpMap[KC_NO_OF_OPERATORS], OpToOpMap_cmp_left);

    /* write out the grammar terminator string and the number of nodes */
    fprintf( kc_stream, "$object \n%d %d\n", kc_node_count, kc_node_count_base );

    /* write out the tree */
    kc_file_offset = 0;
    kc_file_offset_base = 0;
    kc_CSGIOwrite2structure( kc_stream, kc_p);
    kc_CSGIOhashtable.clear();
}

} // anonymous namespace

void
impl_abstract_phylum::CSGIOwrite(FILE *kc_stream) const
{
    kc::CSGIOwrite(kc_stream, this);
}

#endif // ! KC_NO_CSGIO_WRITE


} // namespace kc
