// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "engine.h"

using namespace ost;
using namespace std;

BayonneBinder *BayonneBinder::binder = NULL;

BayonneBinder::BayonneBinder(const char *id) :
ScriptBinder(id)
{
	if(!binder)
		binder = this;
}

BayonneSession *BayonneBinder::session(ScriptInterp *s)
{
	return (BayonneSession *)(s);
}

bool BayonneBinder::scriptEvent(ScriptInterp *interp, const char *evt)
{
	return (session(interp))->stringEvent(evt);
}

bool BayonneBinder::digitEvent(ScriptInterp *interp, const char *evt)
{
	return (session(interp))->digitEvent(evt);
}

Script::Name *BayonneBinder::getService(ScriptImage *img, ScriptInterp *interp, const char *sid)
{
	return binder->service(img, interp, sid);
}

Script::Name *BayonneBinder::service(ScriptImage *img, ScriptInterp *interp, const char *sid)
{
	return NULL;
}


