// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "module.h"

namespace binder {
using namespace ost;
using namespace std;

bool Methods::scrAccept(void)
{
        const char *cp = getKeyword("id");
        state.timeout = getTimeoutKeyword("timeout");

        if(!cp)
                cp = getValue(NULL);

        if(cp)
        {
                state.join.peer = getSid(cp);
                if(!state.join.peer)
                {  
                        error("session-invalid");
                        return true;
                }   
        }
        else
                state.join.peer = NULL;

        state.join.dtmf = false;
        setState(STATE_WAIT);
        return false; 
}                                                                                
	
} // end namespace
