// Copyright (C) 2005 Open Source Telecom Corp.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#define	USE_OLD_CONSTS	1

#include "bayonne.h"
#include <cc++/slog.h>

#include <gclib.h>
#include <anapi.h>
#include <gcisdn.h>
#include <srllib.h>
#include <devmapr4.h>
#include <dtilib.h>
#include <sctools.h>
#include <msilib.h>
#include <dcblib.h>

namespace gcdriver {
using namespace ost;
using namespace std;

class Session;
class Span;

extern "C" {
        int uio_read(int fd, char *buffer, unsigned len);
        int uio_write(int fd, char *buffer, unsigned len);
        long uio_seek(int fd, long offset, int mode);
}

#define MAX_DEVNAME 64

typedef enum
{
        SPRINGWARE,
        DM3
} boardtype_t;

typedef struct
{
        Bayonne::interface_t iface;
	boardtype_t btype;
        LINEDEV linedev;
        char netdev[MAX_DEVNAME];
        char protocol[MAX_DEVNAME];
        char voicedev[MAX_DEVNAME];
        char devname[MAX_DEVNAME];
        int chdev;
        int tsdev;
	int faxdev;
        unsigned span;
}       device_t;

class Driver : public BayonneDriver, public Thread
{
public:
	friend class Session;
	static Driver dialogic;	// plugin activation
	
	Driver();

protected:
        static class Span
        {
        public:
                const char *gcname;
                const char *protocol;
                const char *span;
                unsigned ports;
        }       span[];

	bool stopping;
	device_t *devmap;
	int *voicemaps;
	int mode;
	DX_UIO uio;
	DV_TPT tpt[2], dm3tpt[1];

	DV_TPT *getPlayTPT();
	DV_TPT *getRecordTPT();

	unsigned getSpanCount();
	unsigned getSpanPorts();
	const char *getSpanProtocol();
	boardtype_t getBoardType();

	void startDriver(void);
	void stopDriver(void);

	void run(void);
};

class Session : public BayonneSession, public BayonneMsgport, public TimerPort
{
protected:
	friend class Driver;

	bool blocked, accepted, routing, waiting, disconnecting;
	device_t *devnode;
	CRN crn;
        WAITCALL_BLK wtcall;
        long tsinfo[3];
        SC_TSINFO voxts, intts, faxts;
        DV_DIGIT digbuf[33];
        DV_TPT digtpt[5];
        DX_IOTT iofile, iotone;
        DX_CAP dxcap;
	int callstate;
	bool update_pos;

        void tsConnect(void);
        void tsRelease(void);
        void stopChannel(int mode);

public:
	Session(BayonneSpan *span, timeslot_t ts, device_t *devif);
	~Session();

        // core timer virtuals all port session objects need to define
        timeout_t getRemaining(void);
        void startTimer(timeout_t timer);
        void stopTimer(void);

	void run(void);
	void initial(void);

	bool enableDTMF(void);
	void disableDTMF(void);
	void setOffhook(bool flag);

	bool postEvent(Event *event);
	bool enterHangup(Event *event);
	bool enterIdle(Event *event);
	bool enterReset(Event *event);
	bool enterRelease(Event *event);
	bool enterInitial(Event *event);
	bool enterPickup(Event *event);
	bool enterPlay(Event *event);
	bool enterRecord(Event *event);

        bool waitCall(void);
        bool callProgress(int indicator);
        bool acceptCall(void);
        bool answerCall(void);
        bool hangupCall(void);
        void releaseCall(void);
        void getCallerId(void);
        void resetChannel(void);
	void clrAudio(void);
};

extern	Session **iomap;

} // end namespace
