/* archimedes.c -- This code is a simulator for Submicron 2D III-V
   semiconductor Devices (along with SiO2). It implements the Monte Carlo method 
   and a  simplified version of MEP model for the simulation of the 
   semiclassical Boltzmann equation for both electrons and holes.
   It also includes the quantum effects by means of effective
   potential method. It is now able to simulate applied
   magnetic fields along with self consistent Faraday equation.

   Copyright (C) 2004, 2005, 2006, 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */


// =================================================================
// File Name : mainArchimedes.c
// Version   : release 0.0.8
// Date of Creation : 07 Dec.2003, Paris, France, Jean Michel Sellier
// Last Revision : 18 August 2007, Siracusa, Italy, Jean Michel Sellier.
// System of Measure : M.K.S.C. System
// =================================================================

#include<getopt.h>
#include<stdio.h>
#include<unistd.h>
#include<stdlib.h>
#include<math.h>
#include<memory.h>
#include<time.h>
#ifdef	HAVE_STRING_H
#include<string.h>
#else
#include<strings.h>
#endif


// Preprocessor Definitions
#define real double
#define MN3 4
#define NXM 158
#define NYM 158
#define DIME 2003
#define ITMAX 10000000
#define POISSONITMAX 1500
#define SMALL 1.e-5
#define VMAX 1000000
#define NPMAX 10000000 // maximum number of super-particles
#define MCE 0  // MCE stands for MC for electrons only
#define MCH 1  // MCH stands for MC for holes only
#define MCEH 2 // MCEH stands for MC both for electrons and holes
#define MEPE 3 // MEPE stands for MEP model for electrons only
#define MEPH 4 // MEPH stands for MEP model for holes only
#define MEPEH 5 // MEPEH stands for MEP model for electrons and holes
#define GNUPLOTFORMAT 0 // output file in GNUPLOT format
#define MESHFORMAT 1 // output file in Mesh format
#define SILICON 0 // flag for Silicon material
#define GAAS 1 // flag for GaAs material
#define GERMANIUM 2 // flag for Germanium material
#define NUMSIO2 2 // maximum number of SiO2 interfaces

// ===============================
#include "constants.h"
#include "extrema.h"
#include "sign.h"
#include "mm.h"
#include "mm2.h"
#include "definitionoffunctions.h"
// ===============================

// All integers here...
int NUM_VERT,NUM_EXAHEDRA,MEDIA,MAXIMINI;
int SAVEALWAYS;
int nx,ny;
int ISEED,NP1,INUM,IV;
int c,Model_Number,File_Format,Material,Quantum_Flag;
int leid_flag;
int SIO2_UP_FLAG;
int SIO2_DOWN_FLAG;
int FARADAYFLAG;

// All "real"'s here...
real u2d[NXM+1][NYM+1][MN3+1];
real h2d[NXM+1][NYM+1][MN3+1];
real PSI[NXM+1][NYM+1],E[NXM+1][NYM+1][2];
real N_D[NXM+1][NYM+1],N_H[NXM+1][NYM+1];
real dx,dy;
real TEMPO=0.,TF;
real LX,LY;
real TL,DT;
real mstar,mstar2,msh;
real BKTQ,QH,SMH[3],HHM[3],HM[3],GM;
real SWK[3][14][DIME+1];
real P[NPMAX+1][7],AF[3],EC[3];
real KX,KY,KZ,X,Y;
real TS,EPP,DDmax;
real EDGE[4][NXM+NYM+1][4];
real alphaMATERIAL;
real epsMATERIAL;
real CIMP,QD2,TAUW;
real DG[NXM+1][NYM+1],DL[NXM+1][NYM+1];
real bufx2d[NXM+1][NYM+1];
real bufy2d[NXM+1][NYM+1];
real ux2d[NXM+1][NYM+1][MN3+1];
real uy2d[NXM+1][NYM+1][MN3+1];
real f2d[NXM+1][NYM+1][MN3+1];
real g2d[NXM+1][NYM+1][MN3+1];
real fx2d[NXM+1][NYM+1][MN3+1];
real gy2d[NXM+1][NYM+1][MN3+1];
real c11[7],c12[7],c21[7],c22[7];
real u[7],f[7],g[7],cw[7];
real SIO2_INI[NUMSIO2],SIO2_FIN[NUMSIO2];
real SIO2_POT[NUMSIO2];
real SIO2_THICKNESS[NUMSIO2];
real SIO2[NUMSIO2][NXM+1][NYM+1];
real B[NXM+1][NYM+1];

// All structures here...
time_t binarytime;
struct tm *nowtm;
struct option longopts[] =
{
  { "version", no_argument, NULL, 'v' },
  { "help", no_argument, NULL, 'h' }
};
// All files here...
FILE *fp;
// All strings here...
static char *progname;

int 
main(int argc,char* argv[])
{
  int optc;
  int h = 0, v = 0, lose = 0, z = 0;

  progname = argv[0];

  while ((optc = getopt_long (argc, argv, "hv", longopts, (int *) 0))
         != EOF)
    switch (optc)
      {
      case 'v':
        v = 1;
        break;
      case 'h':
        h = 1;
        break;
      default:
        lose = 1;
        break;
      }
  
  if (optind == argc - 1)
    z = 1;
  else if (lose || optind < argc)
    {
      /* Print error message and exit.  */
      if (optind < argc)
        printf("Too many arguments\n");
        printf("Try `%s --help' for more information.\n",progname);
      exit (1);
    }

  /* `help' should come first.  If `help' is requested, ignore the other
     options. */
  if (h)
    {
      /* Print help info and exit.  */
      /* TRANSLATORS: --help output 1
         no-wrap */
      printf("\
GNU archimedes, a simulator for submicron silicon devices.\n");
      printf ("\n");
      /* TRANSLATORS: --help output 2
         no-wrap */
      printf ("\
Usage: %s [OPTION] file...\n",progname);

      printf ("\n");
      /* TRANSLATORS: --help output 3 : options 1/2
         no-wrap */
      printf("\
  -h, --help          display this help and exit\n\
  -v, --version       display version information and exit\n");

      printf ("\n");
      /* TRANSLATORS: --help output 5 (end)
         TRANSLATORS, please don't forget to add the contact address for
         your translation!
         no-wrap */
      printf ("\
Report bugs to sellier@dmi.unict.it\n");

      exit (0);
    }

  if (v)
    {
      /* Print version number.  */
      printf("archimedes - GNU archimedes 0.0.8\n");
      /* xgettext: no-wrap */
      printf("\n");
      printf("\
Copyright (C) %s Sellier Jean Michel.\n\
There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\n\
PARTICULAR PURPOSE.\n\
You may redistribute copies of GNU %s under the terms\n\
of the GNU General Public License.\n\
For more information about these matters, see the file named COPYING.\n",
              "2004, 2005","Archimedes");
      exit (0);
    }
  else if (z){
// In case of filename specified
// =============================
     fp=fopen(argv[1],"r"); // here we open th input file...
// File Control, just in case the file does not exist...
     if(fp==NULL){
      printf("%s: fatal error in opening the input file %s\n",
             progname,argv[1]);
      exit(EXIT_FAILURE);
     }
// We reset the some arrays
// ========================
     memset(&u2d,0,sizeof(u2d));
     memset(&E,0,sizeof(E));
     memset(&EDGE,0,sizeof(EDGE));
     memset(&SIO2,0,sizeof(SIO2));

// Read the geometrical and physical description of the MESFET
// ===========================================================
     Read_Input_File();

// Closure of the input file
// =========================
     fclose(fp);

// Read all the coefficients for MEP simulation
// ============================================
     MEP_coefficients();

// Loading of the initial runtime
// ==============================
     binarytime=time(NULL);
     nowtm=localtime(&binarytime);

     printf("\n\nComputation Started at %s\n",asctime(nowtm));

// Boundary conditions for the model simulated
// ===========================================
     PoissonBCs();
     if(FARADAYFLAG) FaradayBCs();

// Initialisation for Monte Carlo
// ==============================
     if(Model_Number==MCE || Model_Number==MCEH){
      MCparameters();
      MCdevice_config();
     }
// HERE IS THE SIMULATION
// ======================
     for(c=1;c<=ITMAX;c++) updating(Model_Number);
// Here we save the outputs
// ========================
     SaveOutputFiles(File_Format,0);
     printf("Final Output has been saved\n");
    }
  else{
// No filename has been specified
// ==============================
   printf("%s: no input file\n",progname);
   exit(0);
  }
    /* Print greeting message and exit. */
   binarytime=time(NULL);
   nowtm=localtime(&binarytime);
   printf("Computation Finished at %s\n",asctime(nowtm));
   system("PAUSE");
   return(EXIT_SUCCESS); // Successfull exit
}

/* ------------------- Inclusione funzioni --------------------- */

// ****************************************************

// =======================================================
// Modif. 06 ago.2004 - 18 Aug.2007, Siracusa, J.M.Sellier
// =======================================================
#include "poissonbcs.h"
#include "faradaybcs.h"
#include "media.h"
#include "saveoutput2dmeshformat.h"
#include "saveoutput2dgnuplot.h"
#include "saveoutput2dholegnuplot.h"
#include "saveoutput2dholemeshformat.h"
#include "saveoutputfiles.h"
#include "electric_field.h"
#include "faraday.h"
#include "quantumeffectivepotential.h"
#include "random.h"
#include "mcparameters.h"
#include "deviceconfig.h"
#include "particlecreation.h"
#include "ensemblemontecarlo.h"
#include "drift.h"
#include "scattering.h"
#include "charge.h"
#include "updating.h"
#include "readinputfile.h"
#include "computecurrents.h"
#include "electron_relaxation.h"
#include "ParabMEP2D.h"
#include "HMEPbcs.h"
#include "MEP_interpolation.h"
#include "holemep2d.h"
#include "hole_relaxation.h"
#include "Hole_bcs.h"
// =========================================

/* archimedes.c ends here */

// ***********************************************************************
// ************************************************************************
