#! /bin/sh
# -*- ksh -*-

# This program tests the correct support of all the provided prologues
# Especially missing files

: ${SRCDIR=.}

# Option to run a2ps with
OPT="-Esh"

# The testing file
IN_NAME=formfeed.txt

# Output name
OUT_NAME=prolog.ps

# Set up other vars
. $SRCDIR/defs || exit 1

pass='[ $? != 0 ] && exit 1'

for p in bold bw color gray gray2 matrix diff;
do
  $CHK --prologue=$p $OPT $TST_FILE -o- > /dev/null || exit 1
done

# Compare two prologues
eval $CHK $OPT $TST_FILE -P awkin > $CHK_FILE
if test -f $REF_FILE; then :; else
  eval $REF $OPT $TST_FILE -P awkin > $REF_FILE
fi

# Return the verdict
cmp -s $REF_FILE $CHK_FILE
exit $?
