#!/usr/bin/perl
# Habit . . .
#
# Extract info from Config.VMS, and add extra data here, to generate Config.sh
# Edit the static information after __END__ to reflect your site and options
# that went into your perl binary.
#
# Rev. 30-Sep-1994  Charles Bailey  bailey@genetics.upenn.edu
#

unshift(@INC,'lib');  # In case someone didn't define Perl_Root
                      # before the build
require 'ctime.pl' || die "Couldn't execute ctime.pl: $!\n";

if (-f "config.vms") { $infile = "config.vms"; $outdir = "[-]"; }
elsif (-f "[.vms]config.vms") { $infile = "[.vms]config.vms"; $outdir = "[]"; }
elsif (-f "config.h") { $infile = "config.h"; $outdir = "[]";}

if ($infile) { print "Generating Config.sh from $infile . . .\n"; }
else { die <<EndOfGasp;
Can't find config.vms or config.h to read!
	Please run this script from the perl source directory or
	the VMS subdirectory in the distribution.
EndOfGasp
}
$outdir = '';
open(IN,"$infile") || die "Can't open $infile: $!\n";
open(OUT,">${outdir}Config.sh") || die "Can't open ${outdir}Config.sh: $!\n";
select OUT;


$time = &ctime(time());
print <<EndOfIntro;
# This file generated by GenConfig.pl on a VMS system.
# Input obtained from:
#     $infile
#     $0
# Time: $time

EndOfIntro

while (<IN>) {  # roll through the comment header in Config.VMS
  last if /^#define _config_h_/;
}

while (<IN>) {
  chop;
  while (/\\\s*$/) {  # pick up contination lines
    my $line = $_;
    $line =~ s/\\\s*$//;
    $_ = <IN>;
    s/^\s*//;
    $_ = $line . $_;
  }              
  next unless my ($blocked,$un,$token,$val) = m%(\/\*)?\s*\#\s*(un)?def\w*\s*([A-za-z0-9]\w+)\S*\s*(.*)%;
  next if /config-skip/;
  $state = ($blocked || $un) ? 'undef' : 'define';
  $token =~ tr/A-Z/a-z/;
  $val =~ s%/\*.*\*/\s*%%g;  $val =~ s/\s*$//;  # strip off trailing comment
  $val =~ s/^"//; $val =~ s/"$//;               # remove end quotes
  $val =~ s/","/ /g;                            # make signal list look nice
  if ($val) { print "$token=\'$val\'\n"; }
  else {
    $token = "d_$token" unless $token =~ /^i_/;
    print "$token=\'$state\'\n"; }
}
close IN;

while (<DATA>) {
  next if /^\s*#/ or /^\s*$/;
  s/#.*$//;  s/\s*$//;
  ($key,$val) = split('=',$_,2);
  print "$key=\'$val\'\n";
}

__END__

# This list is incomplete in comparison to what ends up in config.sh, but
# should contain the essentials.  Some of these definitions reflect
# options chosen when building perl or site-specific data; these should
# be hand-edited appropriately.  Someday, perhaps, we'll get this automated.

# The definitions in this block are constant across most systems, and
# should only rarely need to be changed.
osname=VMS  # DO NOT CHANGE THIS! Tests elsewhere depend on this to identify
            # VMS.  Use the 'arch' item below to specify hardware version.
CONFIG=true
PATCHLEVEL=0
dldir=/ext/dl
dlobj=dl_vms.obj
dlsrc=dl_vms.c
so=exe
dlext=exe
libpth=/sys$share /sys$library
hintfile=
intsize=4
alignbytes=8
shrplib=define
signal_t=void
timetype=long
usemymalloc=n
builddir=perl_root:[000000]

# The definitions in this block are site-specific, and will probably need to
# be changed on most systems.
myhostname=nowhere.loopback.edu
arch=VAX
osvers=5.5-2
cppflags=/Define=(DEBUGGING)
d_vms_do_sockets=undef  #=define if perl5 built with socket support
d_has_sockets=undef  # This should have the same value as d_vms_do_sockets
libs=  # This should list RTLs other than the C RTL and IMAGELIB (e.g. socket RTL)
