#!/usr/bin/perl

package eBay::API::XML::Call::GetNotificationsUsage::GetNotificationsUsageResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetNotificationsUsageResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetNotificationsUsage::GetNotificationsUsageResponseType

=head1 DESCRIPTION

Returns an array of notifications sent to a given application identified by the appID
(comes in the credentials). The result can be used by third-party developers troubleshoot
issues with notifications.
Zero, one or many notifications can be returned in the array. The set of notifications
returned is limited to those that were sent between the StartTime and EndTime specified
in the request. If StartTime or EndTime filters were not found in the request, then
the response will contain the data for only one day (Now-1day). By default, maximum
duration is limited to 3 days (Now-3days). These min (1day) and max(3days) applies
to Notifications,MarkDownMarkUpHistory and NotificationStatistics.
Notifications are sent only if the ItemID is included in the request. If there is no
ItemID, then only Statistics and MarkDownMarkUpHistory information is included.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetNotificationsUsage::GetNotificationsUsageResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::MarkUpMarkDownHistoryType;
use eBay::API::XML::DataType::NotificationDetailsArrayType;
use eBay::API::XML::DataType::NotificationStatisticsType;


my @gaProperties = ( [ 'EndTime', 'xs:dateTime', '', '', '' ]
	, [ 'MarkUpMarkDownHistory', 'ns:MarkUpMarkDownHistoryType', ''
	     ,'eBay::API::XML::DataType::MarkUpMarkDownHistoryType', '1' ]
	, [ 'NotificationDetailsArray', 'ns:NotificationDetailsArrayType', ''
	     ,'eBay::API::XML::DataType::NotificationDetailsArrayType', '1' ]
	, [ 'NotificationStatistics', 'ns:NotificationStatisticsType', ''
	     ,'eBay::API::XML::DataType::NotificationStatisticsType', '1' ]
	, [ 'StartTime', 'xs:dateTime', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setEndTime()

Returns the end date and time for the notification information that is
returned by this call. The default is Now.

#    Argument: 'xs:dateTime'

=cut

sub setEndTime {
  my $self = shift;
  $self->{'EndTime'} = shift
}

=head2 getEndTime()

  Returned: Always
#    Returns: 'xs:dateTime'

=cut

sub getEndTime {
  my $self = shift;
  return $self->{'EndTime'};
}


=head2 setMarkUpMarkDownHistory()

List of objects representing MarkUp or MarkDown history for a given appID
and for given StartTime and EndTime. This node will always be returned.

#    Argument: 'ns:MarkUpMarkDownHistoryType'

=cut

sub setMarkUpMarkDownHistory {
  my $self = shift;
  $self->{'MarkUpMarkDownHistory'} = shift
}

=head2 getMarkUpMarkDownHistory()

  Returned: Always
#    Returns: 'ns:MarkUpMarkDownHistoryType'

=cut

sub getMarkUpMarkDownHistory {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MarkUpMarkDownHistory'
		,'eBay::API::XML::DataType::MarkUpMarkDownHistoryType');
}


=head2 setNotificationDetailsArray()

List of notification objects representing the notifications sent to an
application for the given time period. It will only be returned if ItemID
was specified in the input request.

#    Argument: 'ns:NotificationDetailsArrayType'

=cut

sub setNotificationDetailsArray {
  my $self = shift;
  $self->{'NotificationDetailsArray'} = shift
}

=head2 getNotificationDetailsArray()

  Returned: Conditionally
#    Returns: 'ns:NotificationDetailsArrayType'

=cut

sub getNotificationDetailsArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'NotificationDetailsArray'
		,'eBay::API::XML::DataType::NotificationDetailsArrayType');
}


=head2 setNotificationStatistics()

Summary information about number of notifications that were successfully
delivered, queued, failed, connection attempts made, connection timeouts,
http errors for the given appID and given time period. By default, statistics
for only one day (Now-1day) is included. Maximum time duration allowed is 3 days
(Now-3days).

#    Argument: 'ns:NotificationStatisticsType'

=cut

sub setNotificationStatistics {
  my $self = shift;
  $self->{'NotificationStatistics'} = shift
}

=head2 getNotificationStatistics()

  Returned: Always
#    Returns: 'ns:NotificationStatisticsType'

=cut

sub getNotificationStatistics {
  my $self = shift;
  return $self->_getDataTypeInstance( 'NotificationStatistics'
		,'eBay::API::XML::DataType::NotificationStatisticsType');
}


=head2 setStartTime()

Returns the start date and time for the notification information that is
returned by this call. The oldest date allowed for this field is Now-3days.
Default is Now-1day.

#    Argument: 'xs:dateTime'

=cut

sub setStartTime {
  my $self = shift;
  $self->{'StartTime'} = shift
}

=head2 getStartTime()

  Returned: Always
#    Returns: 'xs:dateTime'

=cut

sub getStartTime {
  my $self = shift;
  return $self->{'StartTime'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
