# Generated by default/object.tt
package Paws::LexModelsV2::BuiltInSlotTypeSummary;
  use Moose;
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has SlotTypeSignature => (is => 'ro', isa => 'Str', request_name => 'slotTypeSignature', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::BuiltInSlotTypeSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::BuiltInSlotTypeSummary object:

  $service_obj->Method(Att1 => { Description => $value, ..., SlotTypeSignature => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::BuiltInSlotTypeSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Provides summary information about a built-in slot type for the
ListBuiltInSlotTypes operation.

=head1 ATTRIBUTES


=head2 Description => Str

The description of the built-in slot type.


=head2 SlotTypeSignature => Str

The signature of the built-in slot type. Use this to specify the parent
slot type of a derived slot type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

