# Generated by default/object.tt
package Paws::LexModelsV2::AudioLogDestination;
  use Moose;
  has S3Bucket => (is => 'ro', isa => 'Paws::LexModelsV2::S3BucketLogDestination', request_name => 's3Bucket', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::AudioLogDestination

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::AudioLogDestination object:

  $service_obj->Method(Att1 => { S3Bucket => $value, ..., S3Bucket => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::AudioLogDestination object:

  $result = $service_obj->Method(...);
  $result->Att1->S3Bucket

=head1 DESCRIPTION

The location of audio log files collected when conversation logging is
enabled for a bot.

=head1 ATTRIBUTES


=head2 B<REQUIRED> S3Bucket => L<Paws::LexModelsV2::S3BucketLogDestination>

The Amazon S3 bucket where the audio log files are stored. The IAM role
specified in the C<roleArn> parameter of the CreateBot operation must
have permission to write to this bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

